/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.StructTreeNode;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.libraryElement.StructManipulator;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.jface.viewers.CheckboxTreeViewer;

public class CheckableStructTreeNode
extends StructTreeNode {
    private boolean isChecked = false;
    private boolean isGrey = false;

    private CheckableStructTreeNode(VarDeclaration memberVariable, CheckableStructTreeNode structTreeNode) {
        super(memberVariable, structTreeNode);
    }

    private CheckableStructTreeNode() {
    }

    public static CheckableStructTreeNode createRootNode() {
        return new CheckableStructTreeNode();
    }

    public static CheckableStructTreeNode initTree(StructManipulator struct, StructuredType structType) {
        CheckableStructTreeNode createRootNode = CheckableStructTreeNode.createRootNode();
        CheckableStructTreeNode.buildTree(struct, structType, createRootNode);
        return createRootNode;
    }

    public void updateNode(boolean check) {
        if (check && this.isGrayChecked()) {
            this.setGrey(false);
        }
        this.check(check);
        this.updateGreyedElements(this);
    }

    private void check(boolean isChecked) {
        if (this.getViewer() != null) {
            this.getViewer().setChecked((Object)this, isChecked);
        }
        this.isChecked = isChecked;
    }

    public boolean isChecked() {
        return this.isChecked;
    }

    public boolean isGrayChecked() {
        return this.isGrey && this.isChecked;
    }

    public boolean childIsChecked() {
        return this.childIsChecked(this);
    }

    public static void buildTree(StructManipulator struct, StructuredType structType, CheckableStructTreeNode parent) {
        for (VarDeclaration memberVariable : structType.getMemberVariables()) {
            CheckableStructTreeNode treeNode = parent.addChild(memberVariable);
            if (struct.getInterfaceElement(treeNode.getPinName()) != null) {
                treeNode.check(true);
            }
            if (memberVariable.getType() instanceof StructuredType && memberVariable.getType() != IecTypes.GenericTypes.ANY_STRUCT) {
                CheckableStructTreeNode.buildTree(struct, (StructuredType)memberVariable.getType(), treeNode);
                continue;
            }
            if (!treeNode.isChecked()) continue;
            CheckableStructTreeNode.greyParents(treeNode);
        }
    }

    private void updateGreyedElements(CheckableStructTreeNode node) {
        if (node.isChecked() || node.childIsChecked()) {
            CheckableStructTreeNode.greyParents(node);
        } else {
            this.ungreyParents(node);
        }
    }

    private void ungreyParents(CheckableStructTreeNode node) {
        CheckableStructTreeNode parent = node;
        CheckableStructTreeNode rootNode = node.getRootNode();
        while (parent != rootNode) {
            if (parent.isGrey() && !parent.childIsChecked()) {
                parent.setGrey(false);
                parent.check(false);
                if (this.getViewer() != null) {
                    this.getViewer().setGrayChecked((Object)parent, false);
                }
            }
            parent = (CheckableStructTreeNode)parent.getParent();
        }
    }

    public static void greyParents(CheckableStructTreeNode node) {
        CheckableStructTreeNode parent = node;
        CheckableStructTreeNode rootNode = node.getRootNode();
        while (parent != rootNode) {
            if (!parent.isChecked()) {
                parent.setGrey(true);
                parent.check(true);
                parent.setGrayChecked(true);
            }
            parent = (CheckableStructTreeNode)parent.getParent();
        }
    }

    private void setGrayChecked(boolean b) {
        if (this.getViewer() != null) {
            this.getViewer().setGrayChecked((Object)this, b);
        }
        this.setGrey(b);
        this.check(b);
    }

    protected boolean childIsChecked(StructTreeNode parent) {
        for (StructTreeNode node : parent.getChildren()) {
            if (((CheckableStructTreeNode)node).isChecked) {
                return true;
            }
            if (!node.hasChildren()) continue;
            return this.childIsChecked(node);
        }
        return false;
    }

    @Override
    public CheckableStructTreeNode addChild(VarDeclaration memberVariable) {
        CheckableStructTreeNode treeNode = new CheckableStructTreeNode(memberVariable, this);
        this.children.add(treeNode);
        return treeNode;
    }

    private static StructTreeNode find(StructTreeNode parent, String name) {
        for (StructTreeNode node : parent.getChildren()) {
            StructTreeNode find;
            if (node.pinName.equals(name)) {
                return node;
            }
            if (!node.hasChildren() || (find = CheckableStructTreeNode.find(node, name)) == null) continue;
            return find;
        }
        return null;
    }

    public StructTreeNode find(String name) {
        return CheckableStructTreeNode.find(this.getRootNode(), name);
    }

    private static void serializeTreeToString(CheckableStructTreeNode parent, StringBuilder stringBuilder) {
        for (StructTreeNode n : parent.getChildren()) {
            CheckableStructTreeNode node = (CheckableStructTreeNode)n;
            if (node.isChecked && !node.isGrey) {
                stringBuilder.append(node.pinName);
                stringBuilder.append(",");
            }
            CheckableStructTreeNode.serializeTreeToString(node, stringBuilder);
        }
    }

    public String visibleToString() {
        StringBuilder stringBuilder = new StringBuilder();
        CheckableStructTreeNode.serializeTreeToString(this, stringBuilder);
        if (stringBuilder.length() > 0) {
            return stringBuilder.substring(0, stringBuilder.length() - 1);
        }
        return "";
    }

    public CheckboxTreeViewer getViewer() {
        return (CheckboxTreeViewer)this.root.viewer;
    }

    public CheckableStructTreeNode getRootNode() {
        return (CheckableStructTreeNode)this.root;
    }

    public boolean isGrey() {
        return this.isGrey;
    }

    private void setGrey(boolean isGrey) {
        if (this.root.viewer != null) {
            this.getViewer().setGrayed((Object)this, isGrey);
        }
        this.isGrey = isGrey;
    }

    public static List<VarDeclaration> getVarDeclarations(List<String> varDeclNames, CheckableStructTreeNode node) {
        ArrayList<VarDeclaration> vars = new ArrayList<VarDeclaration>();
        varDeclNames.forEach(name -> {
            VarDeclaration varDecl;
            CheckableStructTreeNode find = (CheckableStructTreeNode)node.find((String)name);
            VarDeclaration findVarDeclarationInStruct = null;
            if (find != null && (varDecl = (VarDeclaration)EcoreUtil.copy((EObject)(findVarDeclarationInStruct = find.getVariable()))) != null) {
                varDecl.setName((String)name);
                vars.add(varDecl);
            }
        });
        return vars;
    }
}

