/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.delete;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.CheckableStructTreeNode;
import org.eclipse.fordiac.ide.model.commands.change.ChangeStructCommand;
import org.eclipse.fordiac.ide.model.data.DataFactory;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.libraryElement.Demultiplexer;
import org.eclipse.fordiac.ide.model.libraryElement.StructManipulator;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.gef.commands.Command;

public class DeleteDemuxPortCommand
extends Command {
    private Demultiplexer type;
    private final VarDeclaration variable;
    private final String oldVisibleChildren;
    private String newVisibleChildren;
    private ChangeStructCommand cmd;
    private Demultiplexer oldMux;
    private final CheckableStructTreeNode node;

    public DeleteDemuxPortCommand(Demultiplexer type, CheckableStructTreeNode node) {
        this.variable = (VarDeclaration)type.getInterfaceElement(node.getPinName());
        this.oldVisibleChildren = node.getRootNode().visibleToString();
        this.type = type;
        this.node = node;
    }

    public void execute() {
        this.node.updateNode(false);
        this.newVisibleChildren = this.node.getRootNode().visibleToString();
        this.createChangeStructCommand();
        this.cmd.execute();
        this.oldMux = this.type;
        this.type = (Demultiplexer)this.cmd.getNewMux();
        this.setVisibleChildrenAttribute(this.newVisibleChildren);
    }

    private void createChangeStructCommand() {
        StructuredType configuredStruct = DataFactory.eINSTANCE.createStructuredType();
        configuredStruct.setName(this.type.getStructType().getName());
        List<String> visibleChildrenNames = Arrays.asList(this.newVisibleChildren.trim().split(","));
        configuredStruct.getMemberVariables().addAll(EcoreUtil.copyAll((Collection)CheckableStructTreeNode.getVarDeclarations(visibleChildrenNames, (CheckableStructTreeNode)this.node)));
        this.cmd = new ChangeStructCommand((StructManipulator)this.type, configuredStruct);
    }

    public boolean canExecute() {
        return this.variable != null;
    }

    public void redo() {
        this.node.updateNode(false);
        this.cmd.redo();
        this.type = (Demultiplexer)this.cmd.getNewMux();
        this.setVisibleChildrenAttribute(this.newVisibleChildren);
    }

    public void undo() {
        this.node.updateNode(true);
        this.type = this.oldMux;
        this.cmd.undo();
        this.setVisibleChildrenAttribute(this.oldVisibleChildren);
    }

    private void setVisibleChildrenAttribute(String value) {
        this.type.setAttribute("VisibleChildren", "STRING", value, "");
    }

    public Demultiplexer getType() {
        return this.type;
    }
}

