/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.create;

import java.text.MessageFormat;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.commands.Messages;
import org.eclipse.fordiac.ide.model.data.EventType;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterType;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorMarkerFBNElement;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorMarkerInterface;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.SubAppType;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.fordiac.ide.ui.errormessages.ErrorMessenger;

public final class LinkConstraints {
    public static boolean canCreateDataConnection(IInterfaceElement source, IInterfaceElement target, FBNetwork parent) {
        return LinkConstraints.canExistDataConnection(source, target, parent, null);
    }

    public static boolean canExistDataConnection(IInterfaceElement source, IInterfaceElement target, FBNetwork parent, Connection con) {
        if (!LinkConstraints.isDataPin(source) || !LinkConstraints.isDataPin(target)) {
            ErrorMessenger.popUpErrorMessage((String)Messages.ConnectingIncompatibleInterfaceTypes);
            return false;
        }
        if (LinkConstraints.isSwapNeeded(source, parent)) {
            IInterfaceElement temp = source;
            source = target;
            target = temp;
        }
        if (!LinkConstraints.sourceAndDestCheck(source, target)) {
            ErrorMessenger.popUpErrorMessage((String)Messages.LinkConstraints_STATUSMessage_IN_IN_OUT_OUT_notAllowed);
            return false;
        }
        if (!LinkConstraints.hasAlreadyInputConnectionsCheck(source, target, con)) {
            ErrorMessenger.popUpErrorMessage((String)MessageFormat.format(Messages.LinkConstraints_STATUSMessage_hasAlreadyInputConnection, target.getName()));
            return false;
        }
        if (!LinkConstraints.typeCheck(source, target)) {
            ErrorMessenger.popUpErrorMessage((String)MessageFormat.format(Messages.LinkConstraints_STATUSMessage_NotCompatible, source.getType() != null ? source.getType().getName() : FordiacMessages.NA, target.getType() != null ? target.getType().getName() : FordiacMessages.NA));
            return false;
        }
        return LinkConstraints.isWithConstraintOK(source) && LinkConstraints.isWithConstraintOK(target);
    }

    public static boolean isWithConstraintOK(IInterfaceElement varDecl) {
        if (!(varDecl instanceof ErrorMarkerInterface) && ((VarDeclaration)varDecl).getWiths().isEmpty()) {
            EObject obj = varDecl.eContainer();
            if (obj != null && ((obj = obj.eContainer()) instanceof CompositeFBType || obj instanceof SubApp || obj instanceof ErrorMarkerFBNElement)) {
                return true;
            }
            ErrorMessenger.popUpErrorMessage((String)MessageFormat.format(Messages.LinkConstraints_ERROR_NotConnectedToAnEventByAWithConstruct, varDecl.getName()));
            return false;
        }
        return true;
    }

    private static boolean hasAlreadyOutputConnectionsCheck(IInterfaceElement source, Connection con) {
        for (Connection connection : source.getOutputConnections()) {
            if (connection.equals(con)) continue;
            return true;
        }
        return false;
    }

    public static boolean typeCheck(IInterfaceElement source, IInterfaceElement target) {
        return source.getType().isCompatibleWith(target.getType());
    }

    private static boolean hasAlreadyInputConnectionsCheck(IInterfaceElement src, IInterfaceElement target, Connection con) {
        boolean hasOnlyBrokenCons;
        block4: {
            hasOnlyBrokenCons = true;
            if (target.getInputConnections().isEmpty()) break block4;
            FBNetwork fbNetworkTarget = LinkConstraints.getContainingFBNetwork(target);
            FBNetwork fbNetworkSrc = LinkConstraints.getContainingFBNetwork(src);
            if (fbNetworkTarget != null && fbNetworkTarget != fbNetworkSrc) {
                for (Connection connection : target.getInputConnections()) {
                    if (connection.isBrokenConnection() || connection.equals(con)) continue;
                    hasOnlyBrokenCons = false;
                    break;
                }
            } else {
                for (Connection connection : target.getInputConnections()) {
                    if (connection.equals(con)) continue;
                    hasOnlyBrokenCons = false;
                    break;
                }
            }
        }
        return hasOnlyBrokenCons;
    }

    public static boolean isSwapNeeded(IInterfaceElement source, FBNetwork parent) {
        if (source.eContainer() != null && source.eContainer().eContainer() instanceof CompositeFBType || source.getFBNetworkElement() != null && source.getFBNetworkElement().getFbNetwork() != parent) {
            return !source.isIsInput();
        }
        return source.isIsInput();
    }

    private static FBNetwork getContainingFBNetwork(IInterfaceElement target) {
        FBNetwork retVal = null;
        EObject obj = target.eContainer();
        if (obj != null && (obj = obj.eContainer()) != null && (obj = obj.eContainer()) instanceof FBNetwork) {
            retVal = (FBNetwork)obj;
        }
        return retVal;
    }

    private static boolean sourceAndDestCheck(IInterfaceElement source, IInterfaceElement target) {
        boolean canExist;
        boolean bl = canExist = source.isIsInput() && !target.isIsInput() || !source.isIsInput() && target.isIsInput();
        if (!canExist && (source.isIsInput() && target.isIsInput() || !source.isIsInput() && !target.isIsInput())) {
            EObject destCont;
            EObject sourceCont = source.eContainer().eContainer();
            canExist = sourceCont != (destCont = target.eContainer().eContainer()) && (LinkConstraints.isTypeContainer(sourceCont) || LinkConstraints.isTypeContainer(destCont)) && sourceCont.eContainer() != destCont.eContainer();
        }
        return canExist;
    }

    private static boolean isTypeContainer(EObject cont) {
        return cont instanceof SubApp || cont instanceof SubAppType || cont instanceof CompositeFBType;
    }

    public static boolean canExistEventConnection(IInterfaceElement source, IInterfaceElement target, FBNetwork parent) {
        if (!LinkConstraints.isEventPin(source) || !LinkConstraints.isEventPin(target)) {
            ErrorMessenger.popUpErrorMessage((String)Messages.ConnectingIncompatibleInterfaceTypes);
            return false;
        }
        if (LinkConstraints.isSwapNeeded(source, parent)) {
            IInterfaceElement temp = source;
            source = target;
            target = temp;
        }
        if (LinkConstraints.duplicateConnection(source, target)) {
            return false;
        }
        return LinkConstraints.sourceAndDestCheck(source, target);
    }

    private static boolean duplicateConnection(IInterfaceElement source, IInterfaceElement destination) {
        for (Connection con : source.getOutputConnections()) {
            if (con.getDestination() != destination) continue;
            return true;
        }
        return false;
    }

    private static boolean isEventPin(IInterfaceElement pin) {
        return pin != null && pin.getType() instanceof EventType;
    }

    private static boolean isDataPin(IInterfaceElement pin) {
        return pin != null && !(pin.getType() instanceof EventType) && !(pin.getType() instanceof AdapterType);
    }

    private static boolean isAdapterPin(IInterfaceElement pin) {
        return pin != null && pin.getType() instanceof AdapterType;
    }

    public static boolean canExistAdapterConnection(IInterfaceElement source, IInterfaceElement target, FBNetwork parent, Connection con) {
        if (!LinkConstraints.isAdapterPin(source) || !LinkConstraints.isAdapterPin(target)) {
            ErrorMessenger.popUpErrorMessage((String)Messages.ConnectingIncompatibleInterfaceTypes);
            return false;
        }
        if (LinkConstraints.isSwapNeeded(source, parent)) {
            IInterfaceElement temp = source;
            source = target;
            target = temp;
        }
        if (!LinkConstraints.sourceAndDestCheck(source, target)) {
            ErrorMessenger.popUpErrorMessage((String)Messages.LinkConstraints_STATUSMessage_IN_IN_OUT_OUT_notAllowed);
            return false;
        }
        if (!LinkConstraints.hasAlreadyInputConnectionsCheck(source, target, con)) {
            ErrorMessenger.popUpErrorMessage((String)MessageFormat.format(Messages.LinkConstraints_STATUSMessage_hasAlreadyInputConnection, target.getName()));
            return false;
        }
        if (LinkConstraints.hasAlreadyOutputConnectionsCheck(source, con)) {
            ErrorMessenger.popUpErrorMessage((String)MessageFormat.format(Messages.LinkConstraints_STATUSMessage_hasAlreadyOutputConnection, source.getName()));
            return false;
        }
        if (!LinkConstraints.adapaterTypeCompatibilityCheck(source, target)) {
            ErrorMessenger.popUpErrorMessage((String)MessageFormat.format(Messages.LinkConstraints_STATUSMessage_NotCompatible, source.getType() != null ? source.getType().getName() : FordiacMessages.ND, target.getType() != null ? target.getType().getName() : FordiacMessages.ND));
            return false;
        }
        return true;
    }

    public static boolean canCreateAdapterConnection(IInterfaceElement source, IInterfaceElement target, FBNetwork parent) {
        return LinkConstraints.canExistAdapterConnection(source, target, parent, null);
    }

    private static boolean adapaterTypeCompatibilityCheck(IInterfaceElement source, IInterfaceElement target) {
        if (source.getType().getName().equals("ANY_ADAPTER") && !target.getType().getName().equals("ANY_ADAPTER") || !source.getType().getName().equals("ANY_ADAPTER") && target.getType().getName().equals("ANY_ADAPTER")) {
            return true;
        }
        return source.getType().getName().equalsIgnoreCase(target.getType().getName());
    }

    private LinkConstraints() {
        throw new UnsupportedOperationException(Messages.LinkConstraints_ClassLinconstraintsShouldNotBeCreated);
    }
}

