/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.change;

import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.gef.commands.Command;

public class ChangeVariableOrderCommand
extends Command {
    private final VarDeclaration variable;
    private final EList<VarDeclaration> type;
    private final int oldIndex;
    private int newIndex;

    public ChangeVariableOrderCommand(EList<VarDeclaration> type, VarDeclaration variable, int indexChanged) {
        this.type = type;
        this.variable = variable;
        this.oldIndex = type.indexOf((Object)variable);
        if (indexChanged == 1) {
            this.newIndex = this.oldIndex + 1;
        } else if (indexChanged == -1) {
            this.newIndex = this.oldIndex - 1;
        }
        if (this.newIndex < 0) {
            this.newIndex = 0;
        }
        if (this.newIndex >= type.size()) {
            this.newIndex = type.size() - 1;
        }
    }

    public ChangeVariableOrderCommand(EList<VarDeclaration> type, VarDeclaration variable, boolean moveUp) {
        this(type, variable, moveUp ? -1 : 1);
    }

    public boolean canExecute() {
        return this.variable != null && this.type.size() > 1 && this.type.size() > this.newIndex;
    }

    public void execute() {
        this.moveTo(this.newIndex);
    }

    public void redo() {
        this.moveTo(this.newIndex);
    }

    public void undo() {
        this.moveTo(this.oldIndex);
    }

    private void moveTo(int index) {
        this.type.move(index, (Object)this.variable);
    }
}

