/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.metrics.analyzers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.fordiac.ide.metrics.analyzers.AbstractCodeMetricAnalyzer;
import org.eclipse.fordiac.ide.metrics.analyzers.CyclomaticData;
import org.eclipse.fordiac.ide.metrics.analyzers.MetricData;
import org.eclipse.fordiac.ide.metrics.analyzers.MetricResult;
import org.eclipse.fordiac.ide.model.libraryElement.Algorithm;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ECAction;
import org.eclipse.fordiac.ide.model.libraryElement.ECC;
import org.eclipse.fordiac.ide.model.libraryElement.ECState;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;

public class CyclomaticComplexity
extends AbstractCodeMetricAnalyzer {
    static final String[] CONDITIONS = new String[]{"IF", "FOR", "WHILE", "REPEAT"};
    List<MetricResult> metrics = new ArrayList<MetricResult>();
    double ccapp = 0.0;

    @Override
    public void calculateMetrics(INamedElement element) {
        super.calculateMetrics(element);
        CyclomaticData cData = (CyclomaticData)this.data;
        this.metrics.add(0, new MetricResult("Cyclomatic Number " + element.getName(), cData.cc));
        this.metrics = CyclomaticComplexity.removeDuplicates(this.metrics);
    }

    private static List<MetricResult> removeDuplicates(List<MetricResult> list) {
        ArrayList<MetricResult> newList = new ArrayList<MetricResult>();
        boolean dupl = false;
        for (MetricResult m : list) {
            for (MetricResult n : newList) {
                if (!m.equals(n)) continue;
                dupl = true;
            }
            if (!dupl) {
                newList.add(m);
            }
            dupl = false;
        }
        return newList;
    }

    @Override
    public List<MetricResult> getResults() {
        return this.metrics;
    }

    @Override
    protected MetricData analyzeBFB(BasicFBType basicFBType) {
        CyclomaticData data = new CyclomaticData();
        ECC ecc = basicFBType.getECC();
        double ccfb = ecc.getECTransition().size() - ecc.getECState().size() + 2;
        for (ECState state : ecc.getECState()) {
            for (ECAction action : state.getECAction()) {
                if (action.getAlgorithm() == null) continue;
                ccfb += CyclomaticComplexity.analyzeAlgorithm(action.getAlgorithm());
            }
        }
        data.cc += ccfb;
        this.metrics.add(new MetricResult("Cyclomatic Number " + basicFBType.getName(), ccfb));
        return data;
    }

    private static double analyzeAlgorithm(Algorithm algorithm) {
        double ccAlg = 0.0;
        String algText = algorithm.toString();
        int saveIndex = 0;
        String[] stringArray = CONDITIONS;
        int n = CONDITIONS.length;
        int n2 = 0;
        while (n2 < n) {
            String cond = stringArray[n2];
            int lastIndex = 0;
            while (-1 != lastIndex) {
                saveIndex = cond.equals("REPEAT") ? algText.indexOf(String.valueOf(cond) + "\r\n", lastIndex) : algText.indexOf(String.valueOf(cond) + " ", lastIndex);
                if (saveIndex == 0 || -1 == (lastIndex = saveIndex)) continue;
                ccAlg += 1.0;
                lastIndex += cond.length();
            }
            ++n2;
        }
        return ccAlg;
    }

    @Override
    protected MetricData analyzeCFB(CompositeFBType compositeFBType) {
        MetricData data = this.analyzeFBNetwork(compositeFBType.getFBNetwork(), true);
        this.metrics.add(new MetricResult("Cyclomatic Number " + compositeFBType.getName(), ((CyclomaticData)data).cc));
        return data;
    }

    @Override
    protected MetricData createDataType() {
        return new CyclomaticData();
    }
}

