/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.properties;

import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.gef.properties.AbstractSection;
import org.eclipse.fordiac.ide.model.commands.change.ChangeCommentCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeDataTypeCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeInterfaceOrderCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeSubAppIENameCommand;
import org.eclipse.fordiac.ide.model.commands.create.CreateInterfaceElementCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteInterfaceCommand;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.edit.providers.InterfaceElementLabelProvider;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterType;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.ui.widgets.OpenStructMenu;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.fordiac.ide.ui.widget.AddDeleteReorderListWidget;
import org.eclipse.fordiac.ide.ui.widget.ComboBoxWidgetFactory;
import org.eclipse.fordiac.ide.ui.widget.CommandExecutor;
import org.eclipse.fordiac.ide.ui.widget.CustomTextCellEditor;
import org.eclipse.fordiac.ide.ui.widget.I4diacTableUtil;
import org.eclipse.fordiac.ide.ui.widget.TableWidgetFactory;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class AbstractEditInterfaceSection
extends AbstractSection
implements I4diacTableUtil {
    private static final int TYPE_AND_COMMENT_COLUMN_WIDTH = 100;
    private static final int NAME_COLUMN_WIDTH = 200;
    private static final String NAME_COL = "name";
    private static final String TYPE_COL = "type";
    private static final String COMMENT_COL = "comment";
    private TableViewer inputsViewer;
    private TableViewer outputsViewer;
    private boolean isInputsViewer;
    protected boolean createButtons = true;

    protected abstract CreateInterfaceElementCommand newCreateCommand(IInterfaceElement var1, boolean var2);

    protected abstract CreateInterfaceElementCommand newInsertCommand(IInterfaceElement var1, boolean var2, int var3);

    protected abstract DeleteInterfaceCommand newDeleteCommand(IInterfaceElement var1);

    protected abstract ChangeInterfaceOrderCommand newOrderCommand(IInterfaceElement var1, boolean var2);

    protected abstract String[] fillTypeCombo();

    protected abstract INamedElement getInputType(Object var1);

    protected ChangeDataTypeCommand newChangeTypeCommand(VarDeclaration data, DataType newType) {
        return new ChangeDataTypeCommand(data, newType);
    }

    public TableViewer getInputsViewer() {
        return this.inputsViewer;
    }

    public TableViewer getOutputsViewer() {
        return this.outputsViewer;
    }

    public boolean isInputsViewer() {
        return this.isInputsViewer;
    }

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        this.createSuperControls = false;
        super.createControls(parent, tabbedPropertySheetPage);
        parent.setLayout((Layout)new GridLayout(2, false));
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createInputEdit(parent);
        this.createOutputEdit(parent);
        this.inputsViewer.setContentProvider(this.getInputsContentProvider());
        this.outputsViewer.setContentProvider(this.getOutputsContentProvider());
        this.setFocusListeners();
        TableWidgetFactory.enableCopyPasteCut((Object)tabbedPropertySheetPage);
        AbstractEditInterfaceSection.createContextMenu(this.getInputsViewer());
        AbstractEditInterfaceSection.createContextMenu(this.getOutputsViewer());
    }

    private void setFocusListeners() {
        this.getOutputsViewer().getTable().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                AbstractEditInterfaceSection.this.isInputsViewer = false;
            }

            public void focusLost(FocusEvent e) {
            }
        });
        this.getInputsViewer().getTable().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                AbstractEditInterfaceSection.this.isInputsViewer = true;
            }

            public void focusLost(FocusEvent e) {
            }
        });
    }

    protected abstract IContentProvider getOutputsContentProvider();

    protected abstract IContentProvider getInputsContentProvider();

    protected TableLayout createTableLayout(Table table) {
        TableColumn column1 = new TableColumn(table, 16384);
        column1.setText(FordiacMessages.Name);
        TableColumn column2 = new TableColumn(table, 16384);
        column2.setText(FordiacMessages.Type);
        TableColumn column3 = new TableColumn(table, 16384);
        column3.setText(FordiacMessages.Comment);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(200));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(100));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(100));
        return layout;
    }

    private void createInputEdit(Composite parent) {
        Group inputsGroup = this.getWidgetFactory().createGroup(parent, "Inputs");
        inputsGroup.setLayout((Layout)new GridLayout(2, false));
        inputsGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        if (this.createButtons) {
            AddDeleteReorderListWidget buttons = new AddDeleteReorderListWidget();
            buttons.createControls((Composite)inputsGroup, (FormToolkit)this.getWidgetFactory());
            this.inputsViewer = this.createTypeTableView(inputsGroup);
            this.configureButtonList(buttons, this.inputsViewer, true);
        } else {
            this.inputsViewer = this.createTypeTableView(inputsGroup);
        }
    }

    private void createOutputEdit(Composite parent) {
        Group outputsGroup = this.getWidgetFactory().createGroup(parent, "Outputs");
        outputsGroup.setLayout((Layout)new GridLayout(2, false));
        outputsGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        if (this.createButtons) {
            AddDeleteReorderListWidget buttons = new AddDeleteReorderListWidget();
            buttons.createControls((Composite)outputsGroup, (FormToolkit)this.getWidgetFactory());
            this.outputsViewer = this.createTypeTableView(outputsGroup);
            this.configureButtonList(buttons, this.outputsViewer, false);
        } else {
            this.outputsViewer = this.createTypeTableView(outputsGroup);
        }
    }

    private TableViewer createTypeTableView(Group parent) {
        TableViewer viewer = TableWidgetFactory.createTableViewer((Composite)parent);
        viewer.getTable().setLayout((Layout)this.createTableLayout(viewer.getTable()));
        viewer.getTable().setHeaderVisible(true);
        viewer.getTable().setLinesVisible(true);
        viewer.setColumnProperties(this.getColumnProperties());
        viewer.setCellModifier((ICellModifier)this.getCellModifier(viewer));
        viewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        return viewer;
    }

    protected String[] getColumnProperties() {
        return new String[]{NAME_COL, TYPE_COL, COMMENT_COL};
    }

    protected LabelProvider getLabelProvider() {
        return new InterfaceElementLabelProvider();
    }

    protected InterfaceCellModifier getCellModifier(TableViewer viewer) {
        return new InterfaceCellModifier(viewer);
    }

    private void configureButtonList(AddDeleteReorderListWidget buttons, TableViewer viewer, boolean inputs) {
        buttons.bindToTableViewer(viewer, (CommandExecutor)this, ref -> this.newCreateCommand((IInterfaceElement)ref, inputs), ref -> this.newDeleteCommand((IInterfaceElement)ref), ref -> this.newOrderCommand((IInterfaceElement)ref, true), ref -> this.newOrderCommand((IInterfaceElement)ref, false));
    }

    protected CellEditor createTypeCellEditor(TableViewer viewer) {
        return ComboBoxWidgetFactory.createComboBoxCellEditor((Composite)viewer.getTable(), (String[])this.fillTypeCombo(), (int)8);
    }

    protected Object getTypeValue(Object element, TableViewer viewer, int TYPE_COLUMN_INDEX) {
        String type = ((IInterfaceElement)element).getTypeName();
        List<String> items = Arrays.asList(((ComboBoxCellEditor)viewer.getCellEditors()[TYPE_COLUMN_INDEX]).getItems());
        return items.indexOf(type);
    }

    protected Command createChangeDataTypeCommand(VarDeclaration data, Object value, TableViewer viewer) {
        String dataTypeName = ((ComboBoxCellEditor)viewer.getCellEditors()[1]).getItems()[(Integer)value];
        return this.newChangeTypeCommand(data, this.getDataTypeLib().getType(dataTypeName));
    }

    protected void setCellEditors(TableViewer viewer) {
        viewer.setCellEditors(new CellEditor[]{new CustomTextCellEditor((Composite)viewer.getTable()), this.createTypeCellEditor(viewer), new CustomTextCellEditor((Composite)viewer.getTable())});
    }

    @Override
    protected void setInputCode() {
    }

    @Override
    protected void setInputInit() {
        this.setCellEditors(this.inputsViewer);
        this.setCellEditors(this.outputsViewer);
    }

    public void refresh() {
        CommandStack commandStackBuffer = this.commandStack;
        this.commandStack = null;
        if (this.type != null) {
            this.inputsViewer.setInput((Object)this.getType());
            this.outputsViewer.setInput((Object)this.getType());
        }
        this.commandStack = commandStackBuffer;
    }

    protected int getInsertingIndex(IInterfaceElement interfaceElement, EList<? extends IInterfaceElement> interfaceList) {
        return interfaceList.indexOf((Object)interfaceElement) + 1;
    }

    protected abstract int getInsertingIndex(IInterfaceElement var1, boolean var2);

    protected String getCreationName(IInterfaceElement interfaceElement) {
        return interfaceElement != null ? interfaceElement.getName() : null;
    }

    public TableViewer getViewer() {
        return this.isInputsViewer() ? this.getInputsViewer() : this.getOutputsViewer();
    }

    public Object removeEntry(int index, CompoundCommand cmd) {
        IInterfaceElement entry = this.getEntry(index);
        cmd.add((Command)this.newDeleteCommand(entry));
        return entry;
    }

    public void executeCompoundCommand(CompoundCommand cmd) {
        this.executeCommand((Command)cmd);
        this.getViewer().refresh();
    }

    private IInterfaceElement getEntry(int index) {
        Object obj = this.getViewer().getElementAt(index);
        return (IInterfaceElement)obj;
    }

    private static void createContextMenu(TableViewer viewer) {
        OpenStructMenu.addTo((TableViewer)viewer);
    }

    protected class InterfaceCellModifier
    implements ICellModifier {
        private static final int TYPE_COLUMN_INDEX = 1;
        protected TableViewer viewer;

        public InterfaceCellModifier(TableViewer viewer) {
            this.viewer = viewer;
        }

        public boolean canModify(Object element, String property) {
            return !AbstractEditInterfaceSection.TYPE_COL.equals(property) || !(element instanceof IInterfaceElement) || ((IInterfaceElement)element).getInputConnections().isEmpty() && ((IInterfaceElement)element).getOutputConnections().isEmpty();
        }

        public Object getValue(Object element, String property) {
            switch (property) {
                case "name": {
                    return ((INamedElement)element).getName();
                }
                case "type": {
                    return AbstractEditInterfaceSection.this.getTypeValue(element, this.viewer, 1);
                }
                case "comment": {
                    return ((INamedElement)element).getComment() != null ? ((INamedElement)element).getComment() : "";
                }
            }
            return null;
        }

        public void modify(Object element, String property, Object value) {
            TableItem tableItem = (TableItem)element;
            Object data = tableItem.getData();
            ChangeSubAppIENameCommand cmd = null;
            switch (property) {
                case "name": {
                    cmd = new ChangeSubAppIENameCommand((IInterfaceElement)data, value.toString());
                    break;
                }
                case "comment": {
                    cmd = new ChangeCommentCommand((INamedElement)data, value.toString());
                    break;
                }
                case "type": {
                    if (data instanceof AdapterDeclaration) {
                        String dataTypeName = ((ComboBoxCellEditor)this.viewer.getCellEditors()[1]).getItems()[(Integer)value];
                        AdapterType newType = AbstractEditInterfaceSection.this.getPalette().getAdapterTypeEntry(dataTypeName).getType();
                        cmd = AbstractEditInterfaceSection.this.newChangeTypeCommand((VarDeclaration)data, (DataType)newType);
                        break;
                    }
                    if (!(data instanceof VarDeclaration)) break;
                    cmd = AbstractEditInterfaceSection.this.createChangeDataTypeCommand((VarDeclaration)data, value, this.viewer);
                    break;
                }
            }
            if (cmd != null) {
                AbstractEditInterfaceSection.this.executeCommand((Command)cmd);
                this.viewer.refresh(data);
            }
        }
    }

    protected static abstract class InterfaceContentProvider
    implements IStructuredContentProvider {
        private final boolean inputs;

        protected InterfaceContentProvider(boolean inputs) {
            this.inputs = inputs;
        }

        protected abstract Object[] getInputs(Object var1);

        protected abstract Object[] getOutputs(Object var1);

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof FBNetworkElement || inputElement instanceof FBType) {
                if (this.inputs) {
                    return this.getInputs(inputElement);
                }
                return this.getOutputs(inputElement);
            }
            return new Object[0];
        }

        static InterfaceList getInterfaceListFromInput(Object inputElement) {
            InterfaceList interfaceList = null;
            if (inputElement instanceof FBNetworkElement) {
                interfaceList = ((FBNetworkElement)inputElement).getInterface();
            } else if (inputElement instanceof FBType) {
                interfaceList = ((FBType)inputElement).getInterfaceList();
            }
            return interfaceList;
        }
    }
}

