/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.figures;

import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.AbstractBackground;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.fordiac.ide.gef.figures.FBShape;

public class FBShapeShadowBorder
extends AbstractBackground {
    private static final int SHADOW_ALPHA = 30;
    private static final int SHADOW_SIZE = 4;
    private static final int SHADOW_CORNER_RADIUS = 8;
    public static final Insets SHADOW_INSETS = new Insets(2, 2, 4, 2);

    public Insets getInsets(IFigure figure) {
        return SHADOW_INSETS;
    }

    public boolean isOpaque() {
        return true;
    }

    public void paintBackground(IFigure figure, Graphics graphics, Insets insets) {
        Assert.isTrue((boolean)(figure instanceof FBShape));
        FBShape fbShape = (FBShape)figure;
        graphics.pushState();
        graphics.setBackgroundColor(ColorConstants.black);
        Rectangle topShadowRect = fbShape.getTop().getBounds().getExpanded(2, 2);
        Rectangle middleShadowRect = fbShape.getMiddle().getBounds().getExpanded(2, 0);
        Rectangle bottomShadowRect = fbShape.getBottom().getBounds().getExpanded(2, 2);
        Rectangle clipRect = topShadowRect.getCopy();
        clipRect.union(middleShadowRect);
        clipRect.union(bottomShadowRect);
        clipRect.width += 4;
        clipRect.height += 4;
        graphics.setClip(clipRect);
        FBShapeShadowBorder.drawShadowHalo(graphics, topShadowRect, middleShadowRect, bottomShadowRect);
        FBShapeShadowBorder.drawDropShadow(graphics, topShadowRect, middleShadowRect, bottomShadowRect);
        graphics.popState();
    }

    private static void drawShadowHalo(Graphics graphics, Rectangle topShadowRect, Rectangle middleShadowRect, Rectangle bottomShadowRect) {
        graphics.setAlpha(30);
        FBShapeShadowBorder.drawShadowFigure(graphics, topShadowRect, middleShadowRect, bottomShadowRect);
        topShadowRect.shrink(1, 1);
        middleShadowRect.shrink(1, 0);
        bottomShadowRect.shrink(1, 1);
        graphics.setAlpha(60);
        FBShapeShadowBorder.drawShadowFigure(graphics, topShadowRect, middleShadowRect, bottomShadowRect);
    }

    private static void drawDropShadow(Graphics graphics, Rectangle topShadowRect, Rectangle middleShadowRect, Rectangle bottomShadowRect) {
        graphics.setAlpha(30);
        double horI = 0.0;
        int i = 0;
        while (i < 4) {
            topShadowRect.translate((int)(horI += 0.7), 1);
            middleShadowRect.translate((int)horI, 1);
            bottomShadowRect.translate((int)horI, 1);
            FBShapeShadowBorder.drawShadowFigure(graphics, topShadowRect, middleShadowRect, bottomShadowRect);
            if (horI >= 1.0) {
                horI -= 1.0;
            }
            ++i;
        }
    }

    private static void drawShadowFigure(Graphics graphics, Rectangle topShadowRect, Rectangle middleShadowRect, Rectangle bottomShadowRect) {
        graphics.fillRoundRectangle(topShadowRect, 8, 8);
        graphics.fillRectangle(middleShadowRect);
        graphics.fillRoundRectangle(bottomShadowRect, 8, 8);
    }
}

