/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.editparts;

import org.eclipse.draw2d.AncestorListener;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.fordiac.ide.gef.Activator;
import org.eclipse.fordiac.ide.gef.FixedAnchor;
import org.eclipse.fordiac.ide.gef.editparts.InterfaceEditPart;
import org.eclipse.fordiac.ide.gef.editparts.LabelDirectEditManager;
import org.eclipse.fordiac.ide.gef.figures.ValueToolTipFigure;
import org.eclipse.fordiac.ide.gef.policies.ValueEditPartChangeEditPolicy;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.libraryElement.Value;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.widgets.Display;

public class ValueEditPart
extends AbstractGraphicalEditPart
implements NodeEditPart {
    private DirectEditManager manager;
    private EditPart context;
    private InterfaceEditPart parentPart;
    private static int maxWidth = -1;
    private final Adapter contentAdapter = new AdapterImpl(){

        public void notifyChanged(Notification notification) {
            Object feature = notification.getFeature();
            if (LibraryElementPackage.eINSTANCE.getValue_Value().equals(feature)) {
                ValueEditPart.this.refreshValue();
                ValueEditPart.this.refreshPosition();
            } else if (LibraryElementPackage.eINSTANCE.getErrorMarkerRef_FileMarkerId().equals(feature)) {
                Display.getDefault().asyncExec(ValueEditPart.this::refreshValue);
            }
            super.notifyChanged(notification);
        }
    };

    private static int getMaxWidth() {
        if (-1 == maxWidth) {
            IPreferenceStore pf = Activator.getDefault().getPreferenceStore();
            int maxLabelSize = pf.getInt("MaxValueLabelSize");
            FontMetrics fm = FigureUtilities.getFontMetrics((Font)JFaceResources.getFontRegistry().get("org.eclipse.fordiac.ide.preferences.diagramFontDefinition"));
            maxWidth = (int)((double)maxLabelSize * fm.getAverageCharacterWidth());
        }
        return maxWidth;
    }

    public void activate() {
        super.activate();
        this.getModel().eAdapters().add((Object)this.contentAdapter);
        Object part = this.getViewer().getEditPartRegistry().get(this.getModel().getVarDeclaration());
        if (part instanceof InterfaceEditPart) {
            this.parentPart = (InterfaceEditPart)part;
            IFigure f = this.parentPart.getFigure();
            f.addAncestorListener(new AncestorListener(){

                public void ancestorRemoved(IFigure ancestor) {
                }

                public void ancestorMoved(IFigure ancestor) {
                    ValueEditPart.this.refreshVisuals();
                }

                public void ancestorAdded(IFigure ancestor) {
                }
            });
        }
        this.refreshVisuals();
    }

    private Point calculatePos() {
        if (this.parentPart != null) {
            Rectangle bounds = this.parentPart.getFigure().getBounds();
            int x = 0;
            x = this.isInput() ? bounds.x - 2 - this.calculateWidth() : bounds.x + bounds.width + 2;
            int y = bounds.y;
            return new Point(x, y);
        }
        return new Point(0, 0);
    }

    protected void refreshPosition() {
        if (this.getParent() != null) {
            Rectangle bounds = null;
            Point p = this.calculatePos();
            bounds = new Rectangle(p.x, p.y, this.calculateWidth(), -1);
            ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, (IFigure)this.getFigure(), (Object)bounds);
        }
    }

    private int calculateWidth() {
        int width = this.getFigure().getPreferredSize().width;
        width = Math.max(40, width);
        width = Math.min(width, ValueEditPart.getMaxWidth());
        return width;
    }

    public void deactivate() {
        super.deactivate();
        this.getModel().eAdapters().remove((Object)this.contentAdapter);
        if (this.manager != null) {
            this.manager = null;
        }
    }

    void refreshValue() {
        if (this.getModel().getValue() != null) {
            this.getFigure().setText(this.getModel().getValue());
            this.setVisible(true);
            this.setBackground(this.getModel().hasError());
        } else {
            this.setVisible(false);
        }
    }

    private void setBackground(boolean hasError) {
        this.getFigure().setOpaque(hasError);
        if (hasError) {
            this.getFigure().setBackgroundColor(ColorConstants.red);
        }
    }

    public void refresh() {
        super.refresh();
        this.refreshValue();
        this.refreshPosition();
    }

    public Label getFigure() {
        return (Label)super.getFigure();
    }

    public void setVisible(boolean visible) {
        this.getFigure().setVisible(visible);
    }

    protected IFigure createFigureForModel() {
        return new ValueFigure();
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshPosition();
    }

    protected void createEditPolicies() {
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new ValueEditPartChangeEditPolicy());
    }

    public Value getModel() {
        return (Value)super.getModel();
    }

    public boolean isInput() {
        return this.getIInterfaceElement().isIsInput();
    }

    private IInterfaceElement getIInterfaceElement() {
        return this.getModel().getVarDeclaration();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return new FixedAnchor((IFigure)this.getFigure(), this.isInput());
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return new FixedAnchor((IFigure)this.getFigure(), this.isInput());
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return new FixedAnchor((IFigure)this.getFigure(), this.isInput());
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return new FixedAnchor((IFigure)this.getFigure(), this.isInput());
    }

    protected IFigure createFigure() {
        IFigure f = null;
        try {
            f = this.createFigureForModel();
        }
        catch (IllegalArgumentException e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
        return f;
    }

    public EditPart getContext() {
        return this.context;
    }

    public void setContext(EditPart context) {
        this.context = context;
    }

    public DirectEditManager getManager() {
        if (this.manager == null) {
            this.manager = new LabelDirectEditManager((GraphicalEditPart)this, this.getFigure());
        }
        return this.manager;
    }

    public void performDirectEdit() {
        this.getManager().show();
    }

    public void performRequest(Request request) {
        FBNetworkElement fb = this.getModel().getVarDeclaration().getFBNetworkElement();
        if (!(ValueEditPart.isTypedInstance(fb) || request.getType() != "direct edit" && request.getType() != "open")) {
            this.performDirectEdit();
        } else {
            super.performRequest(request);
        }
    }

    private static boolean isTypedInstance(FBNetworkElement fb) {
        return fb != null && fb.isContainedInTypedInstance();
    }

    private class ValueFigure
    extends Label {
        public ValueFigure() {
            this.setText(ValueEditPart.this.getModel().getValue() != null ? ValueEditPart.this.getModel().getValue() : "");
            this.setOpaque(false);
            if (ValueEditPart.this.isInput()) {
                this.setLabelAlignment(4);
                this.setTextAlignment(2);
                this.setTextPlacement(16);
            } else {
                this.setLabelAlignment(1);
                this.setTextAlignment(1);
            }
            this.setToolTip((IFigure)new ValueToolTipFigure((INamedElement)ValueEditPart.this.getIInterfaceElement(), ValueEditPart.this.getModel()));
        }
    }
}

