/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.elk;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.elk.alg.layered.options.CrossingMinimizationStrategy;
import org.eclipse.elk.alg.layered.options.LayeredMetaDataProvider;
import org.eclipse.elk.alg.layered.options.LayeringStrategy;
import org.eclipse.elk.core.LayoutConfigurator;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.Direction;
import org.eclipse.elk.core.options.EdgeRouting;
import org.eclipse.elk.core.options.HierarchyHandling;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.service.DiagramLayoutEngine;
import org.eclipse.elk.core.util.IGraphElementVisitor;
import org.eclipse.elk.graph.ElkConnectableShape;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.ElkPort;
import org.eclipse.elk.graph.util.ElkGraphUtil;
import org.eclipse.fordiac.ide.application.editparts.AbstractFBNElementEditPart;
import org.eclipse.fordiac.ide.application.editparts.ConnectionEditPart;
import org.eclipse.fordiac.ide.application.editparts.EditorWithInterfaceEditPart;
import org.eclipse.fordiac.ide.application.editparts.SubAppForFBNetworkEditPart;
import org.eclipse.fordiac.ide.gef.editparts.InterfaceEditPart;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;

public class FordiacLayoutFactory {
    private FordiacLayoutFactory() {
        throw new IllegalStateException("Factory class");
    }

    public static ElkNode createFordiacLayoutGraph() {
        ElkNode graph = ElkGraphUtil.createGraph();
        ElkNode parent = ElkGraphUtil.createGraph();
        graph.setParent(parent);
        FordiacLayoutFactory.configureGraph(graph);
        return graph;
    }

    public static ElkNode createFordiacLayoutNode(AbstractFBNElementEditPart editPart, ElkNode parent) {
        ElkNode node = ElkGraphUtil.createNode((ElkNode)parent);
        FordiacLayoutFactory.configureNode(node);
        if (editPart instanceof SubAppForFBNetworkEditPart) {
            if (((SubAppForFBNetworkEditPart)editPart).getModel().isUnfolded()) {
                FordiacLayoutFactory.configureUnfoldedSubapp(node);
            } else {
                FordiacLayoutFactory.configureSubapp(node);
            }
        }
        return node;
    }

    public static ElkEdge createFordiacLayoutEdge(ConnectionEditPart editPart, ElkNode parent, ElkConnectableShape source, ElkConnectableShape target) {
        return ElkGraphUtil.createSimpleEdge((ElkConnectableShape)source, (ElkConnectableShape)target);
    }

    public static ElkPort createFordiacLayoutPort(InterfaceEditPart editPart, ElkNode parent, Point point) {
        ElkPort port = ElkGraphUtil.createPort((ElkNode)parent);
        port.setDimensions(1.0, (double)editPart.getFigure().getBounds().height);
        if (editPart.getParent() instanceof EditorWithInterfaceEditPart) {
            port.setProperty(CoreOptions.PORT_SIDE, (Object)(editPart.isInput() ? PortSide.EAST : PortSide.WEST));
            port.setProperty(CoreOptions.PORT_INDEX, (Object)FordiacLayoutFactory.getLayoutInterfaceIndex(editPart));
        } else {
            port.setLocation(point.preciseX() - parent.getX(), point.preciseY() - parent.getY());
        }
        return port;
    }

    private static void configureGraph(ElkNode graph) {
        graph.setProperty(CoreOptions.ALGORITHM, (Object)"org.eclipse.elk.layered").setProperty(CoreOptions.EDGE_ROUTING, (Object)EdgeRouting.ORTHOGONAL).setProperty(CoreOptions.DIRECTION, (Object)Direction.RIGHT).setProperty(CoreOptions.PORT_CONSTRAINTS, (Object)PortConstraints.FIXED_ORDER).setProperty(CoreOptions.SPACING_PORT_PORT, (Object)0.0).setProperty(LayeredMetaDataProvider.THOROUGHNESS, (Object)10).setProperty(CoreOptions.PADDING, (Object)new ElkPadding(50.0, 20.0)).setProperty(LayeredMetaDataProvider.CROSSING_MINIMIZATION_STRATEGY, (Object)CrossingMinimizationStrategy.LAYER_SWEEP).setProperty(CoreOptions.HIERARCHY_HANDLING, (Object)HierarchyHandling.INCLUDE_CHILDREN).setProperty(LayeredMetaDataProvider.LAYERING_STRATEGY, (Object)LayeringStrategy.MIN_WIDTH);
        FordiacLayoutFactory.configureSpacing(graph);
    }

    private static void configureNode(ElkNode node) {
        node.setProperty(CoreOptions.PORT_CONSTRAINTS, (Object)PortConstraints.FIXED_POS);
    }

    private static void configureSubapp(ElkNode node) {
    }

    private static void configureUnfoldedSubapp(ElkNode node) {
        node.setProperty(CoreOptions.PADDING, (Object)new ElkPadding(100.0));
        FordiacLayoutFactory.configureSpacing(node);
    }

    private static void configureSpacing(ElkNode node) {
        node.setProperty(CoreOptions.SPACING_NODE_NODE, (Object)25.0).setProperty(LayeredMetaDataProvider.SPACING_NODE_NODE_BETWEEN_LAYERS, (Object)80.0);
    }

    public static DiagramLayoutEngine.Parameters createLayoutParams() {
        DiagramLayoutEngine.Parameters params = new DiagramLayoutEngine.Parameters();
        params.addLayoutRun((IGraphElementVisitor)FordiacLayoutFactory.createConfigurator());
        return params;
    }

    private static LayoutConfigurator createConfigurator() {
        return new LayoutConfigurator();
    }

    public static int getLayoutInterfaceIndex(InterfaceEditPart ep) {
        InterfaceList ifList = (InterfaceList)ep.getModel().eContainer();
        int index = 0;
        if (ep.getModel().isIsInput()) {
            int rightSideIndices = ifList.getEventOutputs().size() + ifList.getOutputVars().size() + ifList.getPlugs().size();
            if (ep.isEvent()) {
                index = ifList.getEventInputs().size() - ifList.getEventInputs().indexOf((Object)ep.getModel()) - 1;
                index += ifList.getInputVars().size();
                index += ifList.getSockets().size();
                index += rightSideIndices;
            } else if (ep.isAdapter()) {
                index = ifList.getSockets().size() - ifList.getSockets().indexOf((Object)ep.getModel()) - 1;
                index += rightSideIndices;
            } else {
                index = ifList.getInputVars().size() - ifList.getInputVars().indexOf((Object)ep.getModel()) - 1;
                index += ifList.getSockets().size();
                index += rightSideIndices;
            }
        } else if (ep.isEvent()) {
            index = ifList.getEventOutputs().indexOf((Object)ep.getModel());
        } else if (ep.isAdapter()) {
            index = ifList.getPlugs().indexOf((Object)ep.getModel());
            index += ifList.getEventOutputs().size();
            index += ifList.getOutputVars().size();
        } else {
            index = ifList.getOutputVars().indexOf((Object)ep.getModel());
            index += ifList.getEventOutputs().size();
        }
        return index;
    }
}

