/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.ui.views;

import java.io.ByteArrayOutputStream;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.fordiac.ide.deployment.ui.Messages;
import org.eclipse.fordiac.ide.deployment.ui.views.AnnotationMarkerAccess;
import org.eclipse.fordiac.ide.deployment.ui.views.ErrorAnnotation;
import org.eclipse.fordiac.ide.deployment.ui.views.LogListener;
import org.eclipse.fordiac.ide.deployment.ui.xml.XMLConfiguration;
import org.eclipse.fordiac.ide.deployment.ui.xml.XMLPartitionScanner;
import org.eclipse.fordiac.ide.deployment.util.IDeploymentListener;
import org.eclipse.fordiac.ide.ui.providers.SourceViewerColorProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationBarHoverManager;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.AnnotationPainter;
import org.eclipse.jface.text.source.AnnotationRulerColumn;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.text.source.OverviewRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.xml.sax.InputSource;

public class Output
extends ViewPart
implements IDeploymentListener {
    private SourceViewer sv;
    private static final String ERROR_TYPE = Messages.Output_DownloadError;
    private static final String WARNIGN_TYPE = Messages.Output_DownloadWarning;
    private static final int OVERVIEW_RULER_WIDTH = 12;
    private static final int ANNOTATION_RULES_COLUMN_WIDTH = 16;
    private final AnnotationModel fAnnotationModel = new AnnotationModel();
    private StringBuilder buffer = new StringBuilder();

    public void createPartControl(Composite parent) {
        Composite root = new Composite(parent, 0);
        root.setLayout((Layout)new GridLayout());
        this.createSourceViewer(root);
        this.contributeToActionBars();
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        Action clearAction = new Action(Messages.Output_ClearActionLabel){

            public void run() {
                Output.this.clearOutput();
            }
        };
        clearAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ETOOL_CLEAR"));
        clearAction.setToolTipText(Messages.Output_ClearTooltip);
        clearAction.setDescription(Messages.Output_ClearDescription);
        manager.add((IAction)clearAction);
    }

    private void createSourceViewer(Composite parent) {
        AnnotationMarkerAccess annotationMarker = new AnnotationMarkerAccess();
        ColorCache colorCache = new ColorCache();
        CompositeRuler compositeRuler = new CompositeRuler();
        OverviewRuler overviewRuler = new OverviewRuler((IAnnotationAccess)annotationMarker, 12, (ISharedTextColors)colorCache);
        AnnotationRulerColumn annotationRuler = new AnnotationRulerColumn((IAnnotationModel)this.fAnnotationModel, 16, (IAnnotationAccess)annotationMarker);
        compositeRuler.setModel((IAnnotationModel)this.fAnnotationModel);
        overviewRuler.setModel((IAnnotationModel)this.fAnnotationModel);
        compositeRuler.addDecorator(0, (IVerticalRulerColumn)annotationRuler);
        annotationRuler.addAnnotationType((Object)ERROR_TYPE);
        annotationRuler.addAnnotationType((Object)WARNIGN_TYPE);
        overviewRuler.addAnnotationType((Object)ERROR_TYPE);
        overviewRuler.addAnnotationType((Object)WARNIGN_TYPE);
        overviewRuler.addHeaderAnnotationType((Object)ERROR_TYPE);
        overviewRuler.addHeaderAnnotationType((Object)WARNIGN_TYPE);
        overviewRuler.setAnnotationTypeLayer((Object)ERROR_TYPE, 3);
        overviewRuler.setAnnotationTypeLayer((Object)WARNIGN_TYPE, 4);
        overviewRuler.setAnnotationTypeColor((Object)ERROR_TYPE, colorCache.getColor(new RGB(255, 0, 0)));
        overviewRuler.setAnnotationTypeColor((Object)WARNIGN_TYPE, colorCache.getColor(new RGB(255, 255, 0)));
        this.sv = new SourceViewer(parent, (IVerticalRuler)compositeRuler, (IOverviewRuler)overviewRuler, true, 770);
        GridData gd = new GridData(4, 4, true, true);
        this.sv.getControl().setLayoutData((Object)gd);
        Document document = new Document();
        this.sv.setDocument((IDocument)document);
        this.sv.setEditable(false);
        document.addDocumentListener((IDocumentListener)new LogListener(this.fAnnotationModel));
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new XMLPartitionScanner(), new String[]{"__xml_tag", "__xml_comment"});
        partitioner.connect((IDocument)document);
        document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        this.sv.setDocument((IDocument)document, (IAnnotationModel)this.fAnnotationModel);
        this.sv.configure((SourceViewerConfiguration)new XMLConfiguration());
        AnnotationBarHoverManager fAnnotationHoverManager = new AnnotationBarHoverManager((IVerticalRulerInfo)compositeRuler, (ISourceViewer)this.sv, (IAnnotationHover)new AnnotationHover(), (IInformationControlCreator)new AnnotationConfiguration());
        fAnnotationHoverManager.install(annotationRuler.getControl());
        AnnotationPainter ap = new AnnotationPainter((ISourceViewer)this.sv, (IAnnotationAccess)annotationMarker);
        ap.addAnnotationType((Object)ERROR_TYPE, (Object)new AnnotationPainter.UnderlineStrategy(3));
        ap.setAnnotationTypeColor((Object)ERROR_TYPE, colorCache.getColor(new RGB(255, 0, 0)));
        this.sv.addPainter((IPainter)ap);
        SourceViewerColorProvider.initializeSourceViewerColors((ISourceViewer)this.sv);
    }

    public void setFocus() {
    }

    private static String getFormattedXML(String command) throws TransformerFactoryConfigurationError {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        documentBuilderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            org.w3c.dom.Document doc = documentBuilder.parse(new InputSource(new StringReader(command)));
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2");
            DOMSource domSource = new DOMSource(doc);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            StreamResult streamResult = new StreamResult(outputStream);
            transformer.transform(domSource, streamResult);
            return ((Object)outputStream).toString();
        }
        catch (Exception e) {
            return MessageFormat.format(Messages.Output_FormattedXML, command, e.getMessage());
        }
    }

    public void connectionOpened() {
    }

    public void postResponseReceived(String response, String source) {
        Display.getDefault().asyncExec(() -> {
            this.buffer.append("\n");
            this.buffer.append(Output.getFormattedXML(response));
        });
    }

    public void postCommandSent(String info, String destination, String command) {
        Display.getDefault().asyncExec(() -> {
            String temp = MessageFormat.format(Messages.Output_Comment, info);
            this.buffer.append("\n\n");
            this.buffer.append(temp);
            this.buffer.append("\n");
            this.buffer.append(Output.getFormattedXML(command));
        });
    }

    public void connectionClosed() {
        IDocument document = this.sv.getDocument();
        if (document != null) {
            Display.getDefault().asyncExec(() -> document.set(this.buffer.toString()));
        }
    }

    public void clearOutput() {
        this.sv.getDocument().set("");
        this.buffer = this.buffer.delete(0, this.buffer.length());
    }

    static class AnnotationConfiguration
    implements IInformationControlCreator {
        AnnotationConfiguration() {
        }

        public IInformationControl createInformationControl(Shell shell) {
            return new DefaultInformationControl(shell);
        }
    }

    class AnnotationHover
    implements IAnnotationHover,
    ITextHover {
        AnnotationHover() {
        }

        public String getHoverInfo(ISourceViewer sourceViewer, int lineNumber) {
            HashMap<String, String> annotations = new HashMap<String, String>();
            Iterator iterator = Output.this.fAnnotationModel.getAnnotationIterator();
            while (iterator.hasNext()) {
                Annotation annotation = (Annotation)iterator.next();
                if (!(annotation instanceof ErrorAnnotation)) continue;
                ErrorAnnotation err = (ErrorAnnotation)annotation;
                annotations.put(Integer.toString(err.getLine()), err.getText());
            }
            return (String)annotations.get(Integer.toString(lineNumber));
        }

        public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
            return null;
        }

        public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
            return null;
        }
    }

    static class ColorCache
    implements ISharedTextColors {
        private final Map<RGB, Color> rgbs = new HashMap<RGB, Color>();

        ColorCache() {
        }

        public Color getColor(RGB rgb) {
            return this.rgbs.computeIfAbsent(rgb, newRGB -> new Color((Device)Display.getDefault(), newRGB));
        }

        public void dispose() {
            for (Map.Entry<RGB, Color> entry : this.rgbs.entrySet()) {
                if (entry.getValue().isDisposed()) continue;
                entry.getValue().dispose();
            }
        }
    }
}

