/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.ui.views;

import java.text.MessageFormat;
import org.eclipse.fordiac.ide.deployment.ui.Activator;
import org.eclipse.fordiac.ide.deployment.ui.Messages;
import org.eclipse.fordiac.ide.deployment.ui.views.ErrorAnnotation;
import org.eclipse.fordiac.ide.deployment.ui.views.WarningAnnotation;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;

public class LogListener
implements IDocumentListener {
    private final AnnotationModel annotationModel;

    public LogListener(AnnotationModel annotationModel) {
        this.annotationModel = annotationModel;
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        try {
            IDocument doc = event.getDocument();
            FindReplaceDocumentAdapter search = new FindReplaceDocumentAdapter(doc);
            int offset = event.getOffset();
            if (event.getDocument().getLength() > 0) {
                ErrorAnnotation errorAnnotation;
                String s;
                IRegion msg;
                IRegion region;
                do {
                    if ((region = search.find(offset, "Reason", true, true, true, false)) == null) continue;
                    msg = search.find(region.getOffset(), "/", true, true, false, true);
                    if (msg != null) {
                        s = doc.get(region.getOffset() + 8, msg.getOffset() - region.getOffset() - 10);
                        errorAnnotation = new ErrorAnnotation(doc.getLineOfOffset(region.getOffset()), MessageFormat.format(Messages.LogListener_ReturnedError, s));
                    } else {
                        errorAnnotation = new ErrorAnnotation(doc.getLineOfOffset(region.getOffset()), Messages.LogListener_ErrorAnnotation);
                    }
                    this.annotationModel.addAnnotation((Annotation)errorAnnotation, new Position(region.getOffset(), region.getLength()));
                    offset = region.getOffset() + 6;
                } while (region != null);
                do {
                    if ((region = search.find(offset, "Error", true, true, true, false)) == null) continue;
                    msg = search.find(region.getOffset(), "/", true, true, false, true);
                    if (msg != null) {
                        s = doc.get(region.getOffset() + 8, msg.getOffset() - region.getOffset() - 10);
                        errorAnnotation = new ErrorAnnotation(doc.getLineOfOffset(region.getOffset()), MessageFormat.format(Messages.LogListener_ReturnedError, s));
                    } else {
                        errorAnnotation = new ErrorAnnotation(doc.getLineOfOffset(region.getOffset()), Messages.LogListener_ErrorAnnotation);
                    }
                    this.annotationModel.addAnnotation((Annotation)errorAnnotation, new Position(region.getOffset(), region.getLength()));
                    offset = region.getOffset() + 6;
                } while (region != null);
                do {
                    WarningAnnotation warningAnnotation;
                    if ((region = search.find(offset, "Warning", true, true, true, false)) == null) continue;
                    msg = search.find(region.getOffset(), "/", true, true, false, true);
                    if (msg != null) {
                        s = doc.get(region.getOffset(), msg.getOffset() - region.getOffset() - 10);
                        warningAnnotation = new WarningAnnotation(doc.getLineOfOffset(region.getOffset()), MessageFormat.format(Messages.LogListener_ReturnedError, s));
                    } else {
                        warningAnnotation = new WarningAnnotation(doc.getLineOfOffset(region.getOffset()), Messages.LogListener_MalformedError);
                    }
                    this.annotationModel.addAnnotation((Annotation)warningAnnotation, new Position(region.getOffset(), region.getLength()));
                    offset = region.getOffset() + 7;
                } while (region != null);
            }
        }
        catch (BadLocationException e) {
            Activator.getDefault().logError(e.getMessage(), (Exception)((Object)e));
        }
    }
}

