/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIMessages;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.WrappableTreeViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ExpandAllModelAction
extends Action {
    private final AbstractTreeViewer treeViewer;

    public ExpandAllModelAction(AbstractTreeViewer treeViewer) {
        this.treeViewer = treeViewer;
        this.setToolTipText(EMFCompareIDEUIMessages.getString("expand.all.tooltip"));
        this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.compare.ide.ui", (String)"icons/full/toolb16/expand_all.gif"));
    }

    public void run() {
        if (this.treeViewer instanceof WrappableTreeViewer) {
            WrappableTreeViewer wrappableTreeViewer = (WrappableTreeViewer)this.treeViewer;
            Tree tree = wrappableTreeViewer.getTree();
            TreeItem[] selection = tree.getSelection();
            TreeItem topItem = tree.getTopItem();
            TreeItem[] itemsOfInterest = selection.length == 0 && topItem != null ? new TreeItem[]{topItem} : selection;
            LinkedHashSet itemsToBeExpanded = Sets.newLinkedHashSet();
            List<List<TreeItem>> prioritizedItems = this.getPrioritizedExpansionList(itemsOfInterest, tree);
            for (List<TreeItem> list : prioritizedItems) {
                itemsToBeExpanded.addAll(list);
            }
            BusyIndicator.showWhile((Display)wrappableTreeViewer.getControl().getDisplay(), (Runnable)new TimeboxedExpandItemsRunnable(wrappableTreeViewer, itemsToBeExpanded));
        } else {
            this.treeViewer.expandToLevel(256);
        }
    }

    private List<List<TreeItem>> getPrioritizedExpansionList(TreeItem[] itemsOfInterest, Tree tree) {
        ArrayList prioritizedItems = Lists.newArrayList();
        prioritizedItems.add(Lists.newArrayList());
        TreeItem[] treeItemArray = itemsOfInterest;
        int n = itemsOfInterest.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            ((List)prioritizedItems.get(0)).add(treeItem);
            this.populateExpansionList(treeItem, prioritizedItems, tree);
            ++n2;
        }
        return prioritizedItems;
    }

    private void populateExpansionList(TreeItem treeItem, List<List<TreeItem>> prioritizedItems, Tree tree) {
        int count = 1;
        TreeItem parentItem = treeItem.getParentItem();
        TreeItem childItem = treeItem;
        while (true) {
            List<Object> currentItemList;
            if (count >= prioritizedItems.size()) {
                currentItemList = Lists.newArrayList();
                prioritizedItems.add((List<TreeItem>)currentItemList);
            } else {
                currentItemList = prioritizedItems.get(count);
            }
            List<TreeItem> siblingItems = parentItem != null ? Arrays.asList(parentItem.getItems()) : Arrays.asList(tree.getItems());
            int index = siblingItems.indexOf(childItem);
            int i = index + 1;
            int size = siblingItems.size();
            while (i < size) {
                TreeItem siblingItem = siblingItems.get(i);
                if (siblingItem.getItemCount() > 0) {
                    currentItemList.add(siblingItem);
                }
                ++i;
            }
            i = index - 1;
            while (i >= 0) {
                TreeItem siblingItem = siblingItems.get(i);
                if (siblingItem.getItemCount() > 0) {
                    currentItemList.add(siblingItem);
                }
                --i;
            }
            if (parentItem == null) {
                return;
            }
            childItem = parentItem;
            parentItem = parentItem.getParentItem();
            ++count;
        }
    }

    public static final class TimeboxedExpandItemsRunnable
    implements Runnable {
        private final WrappableTreeViewer wrappableTreeViewer;
        private final Set<TreeItem> itemsToBeExpanded;
        private final long timeout;

        public TimeboxedExpandItemsRunnable(WrappableTreeViewer wrappableTreeViewer, Set<TreeItem> itemsToBeExpanded) {
            this(wrappableTreeViewer, itemsToBeExpanded, (long)EMFCompareIDEUIPlugin.getDefault().getPreferenceStore().getInt("org.eclipse.emf.compare.ide.ui.preference.editor.tree.expand.timeout") * 1000L);
        }

        public TimeboxedExpandItemsRunnable(WrappableTreeViewer wrappableTreeViewer, Set<TreeItem> itemsToBeExpanded, long timeout) {
            this.wrappableTreeViewer = wrappableTreeViewer;
            this.itemsToBeExpanded = itemsToBeExpanded;
            this.timeout = timeout;
        }

        @Override
        public void run() {
            Control control = this.wrappableTreeViewer.getControl();
            Tree tree = this.wrappableTreeViewer.getTree();
            TreeItem[] selection = tree.getSelection();
            TreeItem topItem = tree.getTopItem();
            try {
                control.setRedraw(false);
                LinkedList queue = Lists.newLinkedList(this.itemsToBeExpanded);
                long start = System.currentTimeMillis();
                while (!queue.isEmpty()) {
                    TreeItem treeItem = (TreeItem)queue.poll();
                    if (!treeItem.getExpanded()) {
                        this.wrappableTreeViewer.createChildren((Widget)treeItem);
                        treeItem.setExpanded(true);
                    }
                    TreeItem[] childItems = treeItem.getItems();
                    int i = childItems.length - 1;
                    while (i >= 0) {
                        TreeItem childItem = childItems[i];
                        if (childItem.getData() != null && this.itemsToBeExpanded.add(childItem)) {
                            queue.addFirst(childItem);
                        }
                        --i;
                    }
                    if (System.currentTimeMillis() - start <= this.timeout) continue;
                    return;
                }
            }
            finally {
                tree.setTopItem(topItem);
                if (selection.length != 0) {
                    tree.setSelection(selection);
                }
                control.setRedraw(true);
            }
        }
    }
}

