.\" shorthand for double quote that works everywhere.
.ds q \N'34'
.TH xorg.conf @filemansuffix@ @vendorversion@
.SH NAME
xorg.conf, @xconfigdir@ \- configuration files for
Xorg X server
.SH INTRODUCTION
.B Xorg
supports several mechanisms for supplying/obtaining configuration and
run-time parameters: command line options, environment variables, the
xorg.conf and @xconfigdir@ configuration files, auto-detection,
and fallback defaults. When the same information is supplied in more
than one way, the highest precedence mechanism is used. The list of
mechanisms is ordered from highest precedence to lowest. Note that not
all parameters can be supplied via all methods. The available command
line options and environment variables (and some defaults) are
described in the Xserver(@appmansuffix@) and
Xorg(@appmansuffix@) manual pages. Most configuration file
parameters, with their defaults, are described below. Driver and module
specific configuration parameters are described in the relevant driver
or module manual page.
.SH DESCRIPTION
.B Xorg
uses a configuration file called
.I xorg.conf
and files ending in the suffix
.I .conf
from the directory
.I @xconfigdir@
for its initial setup.
The
.I xorg.conf
configuration file is searched for in the following places when the
server is started as a normal user:
.PP
.RS 4
.nf
.IR /etc/X11/ <cmdline>
.IR @projectroot@/etc/X11/ <cmdline>
.IB /etc/X11/ $XORGCONFIG
.IB @projectroot@/etc/X11/ $XORGCONFIG
.I /etc/X11/xorg.conf
.I /etc/xorg.conf
.IR @projectroot@/etc/X11/xorg.conf. <hostname>
.I @projectroot@/etc/X11/xorg.conf
.IR @projectroot@/lib/X11/xorg.conf. <hostname>
.I @projectroot@/lib/X11/xorg.conf
.fi
.RE
.PP
where
.I <cmdline>
is a relative path (with no \(lq..\(rq components) specified with the
.B \-config
command line option,
.B $XORGCONFIG
is the relative path (with no \(lq..\(rq components) specified by that
environment variable, and
.I <hostname>
is the machine's hostname as reported by
.BR gethostname (@libmansuffix@).
.PP
When the Xorg server is started by the \(lqroot\(rq user, the config file
search locations are as follows:
.PP
.RS 4
.nf
<cmdline>
.IR /etc/X11/ <cmdline>
.IR @projectroot@/etc/X11/ <cmdline>
.B $XORGCONFIG
.IB /etc/X11/ $XORGCONFIG
.IB @projectroot@/etc/X11/ $XORGCONFIG
.I /etc/X11/xorg.conf
.I /etc/xorg.conf
.IR @projectroot@/etc/X11/xorg.conf. <hostname>
.I @projectroot@/etc/X11/xorg.conf
.IR @projectroot@/lib/X11/xorg.conf. <hostname>
.I @projectroot@/lib/X11/xorg.conf
.fi
.RE
.PP
where
.I <cmdline>
is the path specified with the
.B \-config
command line option (which may be absolute or relative),
.B $XORGCONFIG
is the path specified by that
environment variable (absolute or relative),
.B $HOME
is the path specified by that environment variable (usually the home
directory), and
.I <hostname>
is the machine's hostname as reported by
.BR gethostname (@libmansuffix@).
.PP
Additional configuration files are searched for in the following
directories when the server is started as a normal user:
.PP
.RS 4
.nf
.IR /etc/X11/ <cmdline>
.IR @sysconfdir@/X11/ <cmdline>
.I /etc/X11/@xconfigdir@
.I @sysconfdir@/X11/@xconfigdir@
.fi
.RE
.PP
where
.I <cmdline>
is a relative path (with no \(lq..\(rq components) specified with the
.B \-configdir
command line option.
.PP
When the Xorg server is started by the \(lqroot\(rq user, the
config directory search locations are as follows:
.PP
.RS 4
.nf
<cmdline>
.IR /etc/X11/ <cmdline>
.IR @sysconfdir@/X11/ <cmdline>
.I /etc/X11/@xconfigdir@
.I @sysconfdir@/X11/@xconfigdir@
.fi
.RE
.PP
where
.I <cmdline>
is the path specified with the
.B \-configdir
command line option (which may be absolute or relative).
.PP
Finally, configuration files will also be searched for in a directory reserved
for system use.
This is to separate configuration files from the vendor or 3rd party packages
from those of local administration.
These files are found in the following directory:
.PP
.RS 4
.nf
.I @datadir@/X11/@xconfigdir@
.fi
.RE
.PP
The
.I xorg.conf
and
.I @xconfigdir@
files are composed of a number of sections which may be present in any order,
or omitted to use default configuration values.
Each section has the form:
.PP
.RS 4
.nf
.BI "Section  \*q" SectionName \*q
.RI "    " SectionEntry
    ...
.B EndSection
.fi
.RE
.PP
The section names are:
.PP
.RS 4
.nf
.BR "Files          " "File pathnames"
.BR "ServerFlags    " "Server flags"
.BR "Module         " "Dynamic module loading"
.BR "Extensions     " "Extension enabling"
.BR "InputDevice    " "Input device description"
.BR "InputClass     " "Input class description"
.BR "OutputClass    " "Output class description"
.BR "Device         " "Graphics device description"
.BR "VideoAdaptor   " "Xv video adaptor description"
.BR "Monitor        " "Monitor description"
.BR "Modes          " "Video modes descriptions"
.BR "Screen         " "Screen configuration"
.BR "ServerLayout   " "Overall layout"
.BR "DRI            " "DRI\-specific configuration"
.BR "Vendor         " "Vendor\-specific configuration"
.fi
.RE
.PP
The following obsolete section names are still recognised for compatibility
purposes.
In new config files, the
.B InputDevice
section should be used instead.
.PP
.RS 4
.nf
.BR "Keyboard       " "Keyboard configuration"
.BR "Pointer        " "Pointer/mouse configuration"
.fi
.RE
.PP
The old
.B XInput
section is no longer recognised.
.PP
The
.B ServerLayout
sections are at the highest level.
They bind together the input and output devices that will be used in a session.
The input devices are described in the
.B InputDevice
sections.
Output devices usually consist of multiple independent components (e.g.,
a graphics board and a monitor).
These multiple components are bound together in the
.B Screen
sections, and it is these that are referenced by the
.B ServerLayout
section.
Each
.B Screen
section binds together a graphics board and a monitor.
The graphics boards are described in the
.B Device
sections, and the monitors are described in the
.B Monitor
sections.
.PP
Config file keywords are case\-insensitive, and \(lq_\(rq characters are
ignored.
Most strings (including
.B Option
names) are also case-insensitive, and insensitive to white space and
\(lq_\(rq characters.
.PP
Each config file entry usually takes up a single line in the file.  They
consist of a keyword, which is possibly followed by one or more arguments,
with the number and types of the arguments depending on the keyword.
The argument types are:
.PP
.RS 4
.nf
.BR "Integer     " "an integer number in decimal, hex or octal"
.BR "Real        " "a floating point number"
.BR "String      " "a string enclosed in double quote marks (\*q)"
.fi
.RE
.PP
Note: hex integer values must be prefixed with \(lq0x\(rq, and octal values
with \(lq0\(rq.
.PP
A special keyword called
.B Option
may be used to provide free\-form data to various components of the server.
The
.B Option
keyword takes either one or two string arguments.
The first is the option name, and the optional second argument is the
option value.
Some commonly used option value types include:
.PP
.RS 4
.nf
.BR "Integer     " "an integer number in decimal, hex or octal"
.BR "Real        " "a floating point number"
.BR "String      " "a sequence of characters"
.BR "Boolean     " "a boolean value (see below)"
.BR "Frequency   " "a frequency value (see below)"
.fi
.RE
.PP
Note that
.I all
.B Option
values, not just strings, must be enclosed in quotes.
.PP
Boolean options may optionally have a value specified.
When no value is specified, the option's value is
.BR TRUE .
The following boolean option values are recognised as
.BR TRUE :
.PP
.RS 4
.BR 1 ,
.BR on ,
.BR true ,
.B yes
.RE
.PP
and the following boolean option values are recognised as
.BR FALSE :
.PP
.RS 4
.BR 0 ,
.BR off ,
.BR false ,
.B no
.RE
.PP
If an option name is prefixed with
.RB \*q No \*q,
then the option value is negated.
.PP
Example: the following option entries are equivalent:
.PP
.RS 4
.nf
.B "Option \*qAccel\*q   \*qOff\*q"
.B "Option \*qNoAccel\*q"
.B "Option \*qNoAccel\*q \*qOn\*q"
.B "Option \*qAccel\*q   \*qfalse\*q"
.B "Option \*qAccel\*q   \*qno\*q"
.fi
.RE
.PP
Frequency option values consist of a real number that is optionally
followed by one of the following frequency units:
.PP
.RS 4
.BR Hz ,
.BR k ,
.BR kHz ,
.BR M ,
.B MHz
.RE
.PP
When the unit name is omitted, the correct units will be determined from
the value and the expectations of the appropriate range of the value.
It is recommended that the units always be specified when using frequency
option values to avoid any errors in determining the value.
.SH "FILES SECTION"
The
.B Files
section is used to specify some path names required by the server.
Some of these paths can also be set from the command line (see
.BR Xserver (@appmansuffix@)
and
.BR Xorg (@appmansuffix@)).
The command line settings override the values specified in the config
file.
The
.B Files
section is optional, as are all of the entries that may appear in it.
.PP
The entries that can appear in this section are:
.TP 7
.BI "FontPath \*q" path \*q
sets the search path for fonts.
This path is a comma separated list of font path elements which the Xorg
server searches for font databases.
Multiple
.B FontPath
entries may be specified, and they will be concatenated to build up the
fontpath used by the server.  Font path elements can be absolute
directory paths, catalogue directories or a font server identifier. The
formats of the later two are explained below:
.PP
.RS 7
Catalogue directories:
.PP
.RS 4
Catalogue directories can be specified using the prefix \fBcatalogue:\fR
before the directory name. The directory can then be populated with
symlinks pointing to the real font directories, using the following
syntax in the symlink name:
.PP
.RS 4
.IR <identifier> : [attribute]: pri= <priority>
.RE
.PP
where
.I <identifier>
is an alphanumeric identifier,
.I [attribute]
is an attribute which will be passed to the underlying FPE and
.I <priority>
is a number used to order the fontfile FPEs. Examples:
.PP
.RS 4
.nf
.I 75dpi:unscaled:pri=20  -> /usr/share/X11/fonts/75dpi
.I gscript:pri=60 -> /usr/share/fonts/default/ghostscript
.I misc:unscaled:pri=10 \-> /usr/share/X11/fonts/misc
.fi
.PP
.RE
.RE
.RE
.PP
.RS 7
Font server identifiers:
.PP
.RS 4
Font server identifiers have the form:
.RS 4
.PP
.IR <trans> / <hostname> : <port\-number>
.RE
.PP
where
.I <trans>
is the transport type to use to connect to the font server (e.g.,
.B unix
for UNIX\-domain sockets or
.B tcp
for a TCP/IP connection),
.I <hostname>
is the hostname of the machine running the font server, and
.I <port\-number>
is the port number that the font server is listening on (usually 7100).
.RE
.PP
When this entry is not specified in the config file, the server falls back
to the compiled\-in default font path, which contains the following
font path elements (which can be set inside a catalogue directory):
.PP
.RS 4
.nf
.I @datadir@/fonts/X11/misc/
.I @datadir@/fonts/X11/TTF/
.I @datadir@/fonts/X11/OTF/
.I @datadir@/fonts/X11/Type1/
.I @datadir@/fonts/X11/100dpi/
.I @datadir@/fonts/X11/75dpi/
.fi
.RE
.PP
Font path elements that are found to be invalid are removed from the
font path when the server starts up.
.RE
.TP 7
.BI "ModulePath \*q" path \*q
sets the search path for loadable Xorg server modules.
This path is a comma separated list of directories which the Xorg server
searches for loadable modules loading in the order specified.
Multiple
.B ModulePath
entries may be specified, and they will be concatenated to build the
module search path used by the server.  The default module path is
.PP
.RS 11
@modulepath@
.RE
.\" The LogFile keyword is not currently implemented
.ig
.TP 7
.BI "LogFile \*q" path \*q
sets the name of the Xorg server log file.
The default log file name when running as root is
.PP
.RS 11
.RI @logdir@/Xorg. <n> .log
.RE
and for non root it is
.RS 11
.RI $XDG_DATA_HOME/xorg/Xorg. <n> .log
.RE
.PP
.RS 7
where
.I <n>
is the display number for the Xorg server.
..
.TP 7
.BI "XkbDir \*q" path \*q
sets the base directory for keyboard layout files.  The
.B \-xkbdir
command line option can be used to override this.  The default directory is
.PP
.RS 11
@xkbdir@
.RE
.SH "SERVERFLAGS SECTION"
In addition to options specific to this section (described below), the
.B ServerFlags
section is used to specify some global
Xorg server options.
All of the entries in this section are
.BR Options ,
although for compatibility purposes some of the old style entries are
still recognised.
Those old style entries are not documented here, and using them is
discouraged.
The
.B ServerFlags
section is optional, as are the entries that may be specified in it.
.PP
.B Options
specified in this section (with the exception of the
.B \*qDefaultServerLayout\*q
.BR Option )
may be overridden by
.B Options
specified in the active
.B ServerLayout
section.
Options with command line equivalents are overridden when their command
line equivalent is used.
The options recognised by this section are:
.TP 7
.BI "Option \*qDebug\*q  \*q" string \*q
This comma-separated list provides a way to control various debugging switches
from the config file.
At the moment the only defined value is
.B dmabuf_capable
which instructs glamor to enable some unstable buffer management code.
.TP 7
.BI "Option \*qDefaultServerLayout\*q  \*q" layout\-id \*q
This specifies the default
.B ServerLayout
section to use in the absence of the
.B \-layout
command line option.
.TP 7
.BI "Option \*qDontVTSwitch\*q  \*q" boolean \*q
This disallows the use of the
.BI Ctrl+Alt+F n
sequence (where
.RI F n
refers to one of the numbered function keys).
That sequence is normally used to switch to another \*qvirtual terminal\*q
on operating systems that have this feature.
When this option is enabled, that key sequence has no special meaning and
is passed to clients.
Default: off.
.TP 7
.BI "Option \*qDontZap\*q  \*q" boolean \*q
This disallows the use of the
.B Terminate_Server
XKB action (usually on Ctrl+Alt+Backspace, depending on XKB options).
This action is normally used to terminate the Xorg server.
When this option is enabled, the action has no effect.
Default: off.
.TP 7
.BI "Option \*qDontZoom\*q  \*q" boolean \*q
This disallows the use of the
.B Ctrl+Alt+Keypad\-Plus
and
.B Ctrl+Alt+Keypad\-Minus
sequences.
These sequences allows you to switch between video modes.
When this option is enabled, those key sequences have no special meaning
and are passed to clients.
Default: off.
.TP 7
.BI "Option \*qDisableVidModeExtension\*q  \*q" boolean \*q
This disables the parts of the VidMode extension used by the xvidtune client
that can be used to change the video modes.
Default: the VidMode extension is enabled.
.TP 7
.BI "Option \*qAllowNonLocalXvidtune\*q  \*q" boolean \*q
This allows the xvidtune client (and other clients that use the VidMode
extension) to connect from another host.
Default: off.
.TP 7
.BI "Option \*qAllowMouseOpenFail\*q  \*q" boolean \*q
This tells the mousedrv(@drivermansuffix@) and vmmouse(@drivermansuffix@)
drivers to not report failure if the mouse device can't be opened/initialised.
It has no effect on the evdev(@drivermansuffix@) or other drivers.
Default: false.
.TP 7
.BI "Option \*qBlankTime\*q  \*q" time \*q
sets the inactivity timeout for the
.B blank
phase of the screensaver.
.I time
is in minutes.
This is equivalent to the Xorg server's
.B \-s
flag, and the value can be changed at run\-time with
.BR xset(@appmansuffix@).
Default: 10 minutes.
.TP 7
.BI "Option \*qStandbyTime\*q  \*q" time \*q
sets the inactivity timeout for the
.B standby
phase of DPMS mode.
.I time
is in minutes, and the value can be changed at run\-time with
.BR xset(@appmansuffix@).
Default: 10 minutes.
This is only suitable for VESA DPMS compatible monitors, and may not be
supported by all video drivers.
It is only enabled for screens that have the
.B \*qDPMS\*q
option set (see the MONITOR section below).
.TP 7
.BI "Option \*qSuspendTime\*q  \*q" time \*q
sets the inactivity timeout for the
.B suspend
phase of DPMS mode.
.I time
is in minutes, and the value can be changed at run\-time with
.BR xset(@appmansuffix@).
Default: 10 minutes.
This is only suitable for VESA DPMS compatible monitors, and may not be
supported by all video drivers.
It is only enabled for screens that have the
.B \*qDPMS\*q
option set (see the MONITOR section below).
.TP 7
.BI "Option \*qOffTime\*q  \*q" time \*q
sets the inactivity timeout for the
.B off
phase of DPMS mode.
.I time
is in minutes, and the value can be changed at run\-time with
.BR xset(@appmansuffix@).
Default: 10 minutes.
This is only suitable for VESA DPMS compatible monitors, and may not be
supported by all video drivers.
It is only enabled for screens that have the
.B \*qDPMS\*q
option set (see the MONITOR section below).
.TP 7
.BI "Option \*qMaxClients\*q  \*q" integer \*q
Set the maximum number of clients allowed to connect to the X server.
Acceptable values are 64, 128, 256 or 512.
.TP 7
.BI "Option \*qNoPM\*q  \*q" boolean \*q
Disables something to do with power management events.
Default: PM enabled on platforms that support it.
.TP 7
.BI "Option \*qXinerama\*q  \*q" boolean \*q
enable or disable XINERAMA extension.
Default is disabled.
.TP 7
.BI "Option \*qIndirectGLX\*q \*q" boolean \*q
enable or disable indirect GLX contexts. Indirect GLX contexts are disabled by
default.
.TP 7
.BI "Option \*qDRI2\*q \*q" boolean \*q
enable or disable DRI2. DRI2 is disabled by default.
.TP 7
.BI "Option \*qGlxVisuals\*q \*q" string \*q
This option controls how many GLX visuals the GLX modules sets up.
The default value is
.BR "typical" ,
which will setup up a typical subset of
the GLXFBConfigs provided by the driver as GLX visuals.  Other options are
.BR "minimal" ,
which will set up the minimal set allowed by the GLX specification and
.BR "all"
which will setup GLX visuals for all GLXFBConfigs.
.TP 7
.BI "Option \*qUseDefaultFontPath\*q \*q" boolean \*q
Include the default font path even if other paths are specified in
xorg.conf. If enabled, other font paths are included as well. Enabled by
default.
.TP 7
.BI "Option \*qIgnoreABI\*q \*q" boolean \*q
Allow modules built for a different, potentially incompatible version of
the X server to load. Disabled by default.
.TP 7
.BI "Option \*qAutoAddDevices\*q \*q" boolean \*q
If this option is disabled, then no devices will be added from the HAL or
udev backends. Enabled by default.
.TP 7
.BI "Option \*qAutoEnableDevices\*q \*q" boolean \*q
If this option is disabled, then the devices will be added (and the
DevicePresenceNotify event sent), but not enabled, thus leaving policy up
to the client.
Enabled by default.
.TP 7
.BI "Option \*qAutoAddGPU\*q \*q" boolean \*q
If this option is disabled, then no GPU devices will be added from the udev
backend. Enabled by default. (May need to be disabled to setup Xinerama).
.TP 7
.BI "Option \*qAutoBindGPU\*q  \*q" boolean \*q
If enabled then secondary GPUs will be automatically set up as output-sinks and
offload-sources. Making e.g. laptop outputs connected only to the secondary
GPU directly available for use without needing to run
"xrandr --setprovideroutputsource". Enabled by default.
.TP 7
.BI "Option \*qLog\*q \*q" string \*q
This option controls whether the log is flushed and/or synced to disk after
each message.
Possible values are
.B flush
or
.BR sync .
Unset by default.
.SH "MODULE SECTION"
The
.B Module
section is used to specify which Xorg server modules should be loaded.
This section is ignored when the Xorg server is built in static form.
The type of modules normally loaded in this section are Xorg server
extension modules.
Most other module types are loaded automatically when they are needed via
other mechanisms.
The
.B Module
section is optional, as are all of the entries that may be specified in
it.
.PP
Entries in this section may be in two forms.
The first and most commonly used form is an entry that uses the
.B Load
keyword, as described here:
.TP 7
.BI "Load  \*q" modulename \*q
This instructs the server to load the module called
.IR modulename .
The module name given should be the module's standard name, not the
module file name.
The standard name is case\-sensitive, and does not include the \(lqlib\(rq
or \(lqcyg\(rq prefixes, or the \(lq.so\(rq or \(lq.dll\(rq suffixes.
.PP
.RS 7
Example: the DRI extension module can be loaded with the following entry:
.PP
.RS 4
.B "Load \*qdri\*q"
.RE
.RE
.TP 7
.BI "Disable  \*q" modulename \*q
This instructs the server to not load the module called
.IR modulename .
Some modules are loaded by default in the server, and this overrides that
default. If a
.B Load
instruction is given for the same module, it overrides the
.B Disable
instruction and the module is loaded. The module name given should be the
module's standard name, not the module file name. As with the
.B Load
instruction, the standard name is case-sensitive, and does not include the
"lib" prefix, or the ".a", ".o", or ".so" suffixes.
.PP
The second form of entry is a
.BR SubSection,
with the subsection name being the module name, and the contents of the
.B SubSection
being
.B Options
that are passed to the module when it is loaded.
.PP
Example: the extmod module (which contains a miscellaneous group of
server extensions) can be loaded, with the XFree86\-DGA extension
disabled by using the following entry:
.PP
.RS 4
.nf
.B "SubSection \*qextmod\*q"
.B "   Option  \*qomit XFree86\-DGA\*q"
.B EndSubSection
.fi
.RE
.PP
Modules are searched for in each directory specified in the
.B ModulePath
search path, and in the drivers, extensions, input, internal, and
multimedia subdirectories of each of those directories.
In addition to this, operating system specific subdirectories of all
the above are searched first if they exist.
.PP
To see what extension modules are available, check the extensions
subdirectory under:
.PP
.RS 4
.nf
@modulepath@
.fi
.RE
.PP
The \(lqextmod\(rq, \(lqdbe\(rq, \(lqdri\(rq, \(lqdri2\(rq, \(lqglx\(rq,
and \(lqrecord\(rq extension modules are loaded automatically, if they
are present, unless disabled with \*qDisable\*q entries.
It is recommended
that at very least the \(lqextmod\(rq extension module be loaded.
If it isn't, some commonly used server extensions (like the SHAPE
extension) will not be available.
.SH "EXTENSIONS SECTION"
The
.B Extensions
section is used to specify which X11 protocol extensions should be enabled
or disabled.
The
.B Extensions
section is optional, as are all of the entries that may be specified in
it.
.PP
Entries in this section are listed as Option statements with the name of
the extension as the first argument, and a boolean value as the second.
The extension name is case\-sensitive, and matches the form shown in the output
of \*qXorg -extension ?\*q.
.PP
.RS 7
Example: the MIT-SHM extension can be disabled with the following entry:
.PP
.RS 4
.nf
.B "Section \*qExtensions\*q"
.B "    Option \*qMIT-SHM\*q \*qDisable\*q"
.B "EndSection"
.fi
.RE
.RE
.SH "INPUTDEVICE SECTION"
The config file may have multiple
.B InputDevice
sections.
Recent X servers employ HAL or udev backends for input device enumeration
and input hotplugging. It is usually not
necessary to provide
.B InputDevice
sections in the xorg.conf if hotplugging is in use (i.e. AutoAddDevices is
enabled). If hotplugging is enabled,
.B InputDevice
sections using the
.B mouse, kbd
and
.B vmmouse
driver will be ignored.
.PP
If hotplugging is disabled, there will normally
be at least two: one for the core (primary) keyboard
and one for the core pointer.
If either of these two is missing, a default configuration for the missing
ones will be used. In the absence of an explicitly specified core input
device, the first
.B InputDevice
marked as
.B CorePointer
(or
.BR CoreKeyboard )
is used.
If there is no match there, the first
.B InputDevice
that uses the \(lqmouse\(rq (or \(lqkbd\(rq) driver is used.
The final fallback is to use built\-in default configurations.
Currently the default configuration may not work as expected on all platforms.
.PP
.B InputDevice
sections have the following format:
.PP
.RS 4
.nf
.B  "Section \*qInputDevice\*q"
.BI "    Identifier \*q" name \*q
.BI "    Driver     \*q" inputdriver \*q
.I  "    options"
.I  "    ..."
.B  "EndSection"
.fi
.RE
.PP
The
.B Identifier
and
.B Driver
entries are required in all
.B InputDevice
sections.
All other entries are optional.
.PP
The
.B Identifier
entry specifies the unique name for this input device.
The
.B Driver
entry specifies the name of the driver to use for this input device.
When using the loadable server, the input driver module
.RI \*q inputdriver \*q
will be loaded for each active
.B InputDevice
section.
An
.B InputDevice
section is considered active if it is referenced by an active
.B ServerLayout
section, if it is referenced by the
.B \-keyboard
or
.B \-pointer
command line options, or if it is selected implicitly as the core pointer
or keyboard device in the absence of such explicit references.
The most commonly used input drivers are
.BR evdev (@drivermansuffix@)
on Linux systems, and
.BR kbd (@drivermansuffix@)
and
.BR mousedrv (@drivermansuffix@)
on other platforms.
.PP
.PP
.B InputDevice
sections recognise some driver\-independent
.BR Options ,
which are described here.
See the individual input driver manual pages for a description of the
device\-specific options.
.TP 7
.BI "Option \*qAutoServerLayout\*q  \*q" boolean \*q
Always add the device to the ServerLayout section used by this instance of
the server. This affects implied layouts as well as explicit layouts
specified in the configuration and/or on the command line.
.TP 7
.BI "Option \*qCorePointer\*q"
Deprecated, see
.B Floating
.TP 7
.BI "Option \*qCoreKeyboard\*q"
Deprecated, see
.B Floating
.TP 7
.BI "Option \*qAlwaysCore\*q  \*q" boolean \*q
Deprecated, see
.B Floating
.TP 7
.BI "Option \*qSendCoreEvents\*q  \*q" boolean \*q
Deprecated, see
.B Floating

.TP 7
.BI "Option \*qFloating\*q  \*q" boolean \*q
When enabled, the input device is set up floating and does not
report events through any master device or control a cursor. The device is
only available to clients using the X Input Extension API. This option is
disabled by default.
The options
.B CorePointer,
.B CoreKeyboard,
.B AlwaysCore,
and
.B SendCoreEvents,
are the inverse of option
.B Floating
(i.e.
.B SendCoreEvents \*qon\*q
is equivalent to
.B Floating \*qoff\*q
).

This option controls the startup behavior only, a device
may be reattached or set floating at runtime.
.TP 7
.BI "Option \*qTransformationMatrix\*q \*q" a " " b " " c " " d " " e " " f " " g " " h " " i \*q
Specifies the 3x3 transformation matrix for absolute input devices. The
input device will be bound to the area given in the matrix.  In most
configurations, "a" and "e" specify the width and height of the area the
device is bound to, and "c" and "f" specify the x and y offset of the area.
The value range is 0 to 1, where 1 represents the width or height of all
root windows together, 0.5 represents half the area, etc. The values
represent a 3x3 matrix, with the first, second and third group of three
values representing the first, second and third row of the matrix,
respectively.  The identity matrix is "1 0 0 0 1 0 0 0 1".
.SS POINTER ACCELERATION
For pointing devices, the following options control how the pointer
is accelerated or decelerated with respect to physical device motion. Most of
these can be adjusted at runtime, see the xinput(1) man page for details. Only
the most important acceleration options are discussed here.
.TP 7
.BI "Option \*qAccelerationProfile\*q  \*q" integer \*q
Select the profile. In layman's terms, the profile constitutes the "feeling" of
the acceleration. More formally, it defines how the transfer function (actual
acceleration as a function of current device velocity and acceleration controls)
is constructed. This is mainly a matter of personal preference.
.PP
.RS 6
.nf
.B  " 0      classic (mostly compatible)"
.B  "-1      none (only constant deceleration is applied)"
.B  " 1      device-dependent"
.B  " 2      polynomial (polynomial function)"
.B  " 3      smooth linear (soft knee, then linear)"
.B  " 4      simple (normal when slow, otherwise accelerated)"
.B  " 5      power (power function)"
.B  " 6      linear (more speed, more acceleration)"
.B  " 7      limited (like linear, but maxes out at threshold)"
.fi
.RE
.TP 7
.BI "Option \*qConstantDeceleration\*q  \*q" real \*q
Makes the pointer go
.B deceleration
times slower than normal. Most useful for high-resolution devices. A value
between 0 and 1 will speed up the pointer.
.TP 7
.BI "Option \*qAdaptiveDeceleration\*q  \*q" real \*q
Allows to actually decelerate the pointer when going slow. At most, it will be
.B adaptive deceleration
times slower. Enables precise pointer placement without sacrificing speed.
.TP 7
.BI "Option \*qAccelerationScheme\*q  \*q" string \*q
Selects the scheme, which is the underlying algorithm.
.PP
.RS 7
.nf
.B  "predictable   default algorithm (behaving more predictable)"
.B  "lightweight   old acceleration code (as specified in the X protocol spec)"
.B  "none          no acceleration or deceleration"
.fi
.RE
.TP 7
.BI "Option \*qAccelerationNumerator\*q  \*q" integer \*q
.TP 7
.BI "Option \*qAccelerationDenominator\*q  \*q" integer \*q
Set numerator and denominator of the acceleration factor. The acceleration
factor is a rational which, together with threshold, can be used to tweak
profiles to suit the users needs. The
.B simple
and
.B limited
profiles use it directly (i.e. they accelerate by the factor), for other
profiles it should hold that a higher acceleration factor leads to a faster
pointer. Typically, 1 is unaccelerated and values up to 5 are sensible.
.TP 7
.BI "Option \*qAccelerationThreshold\*q  \*q" integer \*q
Set the threshold, which is roughly the velocity (usually device units per 10
ms) required for acceleration to become effective. The precise effect varies
with the profile however.

.SH "INPUTCLASS SECTION"
The config file may have multiple
.B InputClass
sections.
These sections are optional and are used to provide configuration for a
class of input devices as they are automatically added. An input device can
match more than one
.B InputClass
section. Each class can override settings from a previous class, so it is
best to arrange the sections with the most generic matches first.
.PP
.B InputClass
sections have the following format:
.PP
.RS 4
.nf
.B  "Section \*qInputClass\*q"
.BI "    Identifier  \*q" name \*q
.I  "    entries"
.I  "    ..."
.I  "    options"
.I  "    ..."
.B  "EndSection"
.fi
.RE
.PP
The
.B Identifier
entry is required in all
.B InputClass
sections.
All other entries are optional.
.PP
The
.B Identifier
entry specifies the unique name for this input class.
The
.B Driver
entry specifies the name of the driver to use for this input device.
After all classes have been examined, the
.RI \*q inputdriver \*q
module from the first
.B Driver
entry will be enabled when using the loadable server.
.PP
When an input device is automatically added, its characteristics are
checked against all
.B InputClass
sections. Each section can contain optional entries to narrow the match
of the class. If none of the optional entries appear, the
.B InputClass
section is generic and will match any input device. If more than one of
these entries appear, they all must match for the configuration to apply.
.PP
There are two types of match entries used in
.B InputClass
sections. The first allows various tokens to be matched against attributes
of the device. An entry can be constructed to match attributes from different
devices by separating arguments with a '|' character. Multiple entries of the
same type may be supplied to add multiple matching conditions on the same
attribute. For example:
.PP
.RS 4
.nf
.B  "Section \*qInputClass\*q"
.B  "    Identifier   \*qMy Class\*q"
.B  "    # product string must contain example and
.B  "    # either gizmo or gadget
.B  "    MatchProduct \*qexample\*q
.B  "    MatchProduct \*qgizmo|gadget\*q
.B  "    NoMatchDriver \*qdrivername\*q
.I  "    ..."
.B  "EndSection"
.fi
.RE
.TP 7
.BI "MatchProduct  \*q" matchproduct \*q
This entry can be used to check if the substring
.RI \*q matchproduct \*q
occurs in the device's product name.
.TP 7
.BI "MatchVendor  \*q" matchvendor \*q
This entry can be used to check if the substring
.RI \*q matchvendor \*q
occurs in the device's vendor name.
.TP 7
.BI "MatchDevicePath \*q" matchdevice \*q
This entry can be used to check if the device file matches the
.RI \*q matchdevice \*q
pathname pattern.
.TP 7
.BI "MatchOS \*q" matchos \*q
This entry can be used to check if the operating system matches the
case-insensitive
.RI \*q matchos \*q
string. This entry is only supported on platforms providing the
.BR uname (2)
system call.
.TP 7
.BI "MatchPnPID \*q" matchpnp \*q
The device's Plug and Play (PnP) ID can be checked against the
.RI \*q matchpnp \*q
shell wildcard pattern.
.TP 7
.BI "MatchUSBID \*q" matchusb \*q
The device's USB ID can be checked against the
.RI \*q matchusb \*q
shell wildcard pattern. The ID is constructed as lowercase hexadecimal numbers
separated by a ':'. This is the same format as the
.BR lsusb (8)
program.
.TP 7
.BI "MatchDriver \*q" matchdriver \*q
Check the case-sensitive string
.RI \*q matchdriver \*q
against the currently configured driver of the device. Ordering of sections
using this entry is important since it will not match unless the driver has
been set by the config backend or a previous
.B InputClass
section.
.TP 7
.BI "MatchTag \*q" matchtag \*q
This entry can be used to check if tags assigned by the config backend
matches the
.RI \*q matchtag \*q
pattern. A match is found if at least one of the tags given in
.RI \*q matchtag \*q
matches at least one of the tags assigned by the backend.
.TP 7
.BI "MatchLayout \*q" matchlayout \*q
Check the case-sensitive string
.RI \*q matchlayout \*q
against the currently active
.B ServerLayout
section. The empty string "" matches an implicit layout which appears
if no named
.B ServerLayout
sections have been found.
.PP
The above directives have equivalents for negative matching with the
.B NoMatchProduct,
.B NoMatchVendor,
.B NoMatchDevicePath,
.B NoMatchOS,
.B NoMatchPnPID,
.B NoMatchUSBID,
.B NoMatchDriver,
.B NoMatchTag,
and
.B NoMatchLayout
directives. These NoMatch directives match if the subsequent match is not
met by the device.
.PP
The second type of entry is used to match device types. These entries take a
boolean argument similar to
.B Option
entries.
.TP 7
.BI "MatchIsKeyboard     \*q" bool \*q
.TP 7
.BI "MatchIsPointer      \*q" bool \*q
.TP 7
.BI "MatchIsJoystick     \*q" bool \*q
.TP 7
.BI "MatchIsTablet       \*q" bool \*q
.TP 7
.BI "MatchIsTabletPad    \*q" bool \*q
.TP 7
.BI "MatchIsTouchpad     \*q" bool \*q
.TP 7
.BI "MatchIsTouchscreen  \*q" bool \*q
.PP
When an input device has been matched to the
.B InputClass
section, any
.B Option
entries are applied to the device. One
.B InputClass
specific
.B Option
is recognized. See the
.B InputDevice
section above for a description of the remaining
.B Option
entries.
.TP 7
.BI "Option \*qIgnore\*q \*q" boolean \*q
This optional entry specifies that the device should be ignored entirely,
and not added to the server. This can be useful when the device is handled
by another program and no X events should be generated.
.SH "OUTPUTCLASS SECTION"
The config file may have multiple
.B OutputClass
sections.
These sections are optional and are used to provide configuration for a
class of output devices as they are automatically added.
An output device can match more than one
.B OutputClass
section.
Each class can override settings from a previous class, so it is best to
arrange the sections with the most generic matches first.
.PP
.B OutputClass
sections have the following format:
.PP
.RS 4
.nf
.B  "Section \*qOutputClass\*q"
.BI "    Identifier  \*q" name \*q
.I  "    entries"
.I  "    ..."
.B  "EndSection"
.fi
.RE
.PP
The
.B Identifier
entry is required in all
.B OutputClass
sections.
All other entries are optional.
.PP
The
.B Identifier
entry specifies the unique name for this output class.
The
.B Driver
entry specifies the name of the driver to use for this output device.
After all classes have been examined, the
.RI \*q outputdriver \*q
module from the first
.B Driver
entry will be enabled when using the loadable server.
.PP
When an output device is automatically added, its characteristics are
checked against all
.B OutputClass
sections.
Each section can contain optional entries to narrow the match of the class.
If none of the optional entries appear, the
.B OutputClass
section is generic and will match any output device.
If more than one of these entries appear, they all must match for the
configuration to apply.
.PP
The following list of tokens can be matched against attributes of the device.
An entry can be constructed to match attributes from different devices by
separating arguments with a '|' character.
.PP
For example:
.PP
.RS 4
.nf
.B  "Section \*qOutputClass\*q"
.B  "    Identifier   \*qMy Class\*q"
.B  "    # kernel driver must be either foo or bar
.B  "    MatchDriver \*qfoo|bar\*q
.I  "    ..."
.B  "EndSection"
.fi
.RE
.TP 7
.BI "MatchDriver \*q" matchdriver \*q
Check the case-sensitive string
.RI \*q matchdriver \*q
against the kernel driver of the device.
.PP
When an output device has been matched to the
.B OutputClass
section, any
.B Option
entries are applied to the device. One
.B OutputClass
specific
.B Option
is recognized. See the
.B Device
section below for a description of the remaining
.B Option
entries.
.TP 7
.BI "Option \*qPrimaryGPU\*q \*q" boolean \*q
This option specifies that the matched device should be treated as the
primary GPU, replacing the selection of the GPU used as output by the
firmware. If multiple output devices match an OutputClass section with
the PrimaryGPU option set, the first one enumerated becomes the primary GPU.
.PP
A
.B OutputClass
Section may contain
.B ModulePath
entries. When an output device matches an
.B OutputClass
section, any
.B ModulePath
entries in that
.B OutputClass
are pre-pended to the search path for loadable Xorg server modules. See
.B ModulePath
in the
.B Files
section for more info.
.SH "DEVICE SECTION"
The config file may have multiple
.B Device
sections.
There must be at least one, for the video card being used.
.PP
.B Device
sections have the following format:
.PP
.RS 4
.nf
.B  "Section \*qDevice\*q"
.BI "    Identifier \*q" name \*q
.BI "    Driver     \*q" driver \*q
.I  "    entries"
.I  "    ..."
.B  "EndSection"
.fi
.RE
.PP
The
.B Identifier
and
.B Driver
entries are required in all
.B Device
sections.  All other entries are optional.
.PP
The
.B Identifier
entry specifies the unique name for this graphics device.
The
.B Driver
entry specifies the name of the driver to use for this graphics device.
When using the loadable server, the driver module
.RI \*q driver \*q
will be loaded for each active
.B Device
section.
A
.B Device
section is considered active if it is referenced by an active
.B Screen
section.
.PP
.B Device
sections recognise some driver\-independent entries and
.BR Options ,
which are described here.
Not all drivers make use of these
driver\-independent entries, and many of those that do don't require them
to be specified because the information is auto\-detected.
See the individual graphics driver manual pages for further information
about this, and for a description of the device\-specific options.
Note that most of the
.B Options
listed here (but not the other entries) may be specified in the
.B Screen
section instead of here in the
.B Device
section.
.TP 7
.BI "BusID  \*q" bus\-id \*q
This specifies the bus location of the graphics card.
For PCI/AGP cards,
the
.I bus\-id
string has the form
.BI PCI: bus @ domain : device : function
(e.g., \(lqPCI:1@0:0:0\(rq might be appropriate for an AGP card). The
"@domain" part can be left out for PCI domain 0. This field is usually
optional in single-head configurations when using the primary graphics card.
In multi-head configurations, or when using a secondary graphics card in a
single-head configuration, this entry is mandatory.
Its main purpose is to make an unambiguous connection between the device
section and the hardware it is representing.
This information can usually be found by running the pciaccess tool
scanpci.
.TP 7
.BI "Screen  " number
This option is mandatory for cards where a single PCI entity can drive more
than one display (i.e., multiple CRTCs sharing a single graphics accelerator
and video memory).
One
.B Device
section is required for each head, and this
parameter determines which head each of the
.B Device
sections applies to.
The legal values of
.I number
range from 0 to one less than the total number of heads per entity.
Most drivers require that the primary screen (0) be present.
.TP 7
.BI "Chipset  \*q" chipset \*q
This usually optional entry specifies the chipset used on the graphics
board.
In most cases this entry is not required because the drivers will probe the
hardware to determine the chipset type.
Don't specify it unless the driver-specific documentation recommends that you
do.
.TP 7
.BI "Ramdac  \*q" ramdac\-type \*q
This optional entry specifies the type of RAMDAC used on the graphics
board.
This is only used by a few of the drivers, and in most cases it is not
required because the drivers will probe the hardware to determine the
RAMDAC type where possible.
Don't specify it unless the driver-specific documentation recommends that you
do.
.TP 7
.BI "DacSpeed  " speed
.TP 7
.BI "DacSpeed  " "speed\-8 speed\-16 speed\-24 speed\-32"
This optional entry specifies the RAMDAC speed rating (which is usually
printed on the RAMDAC chip).
The speed is in MHz.
When one value is given, it applies to all framebuffer pixel sizes.
When multiple values are given, they apply to the framebuffer pixel sizes
8, 16, 24 and 32 respectively.
This is not used by many drivers, and only needs to be specified when the
speed rating of the RAMDAC is different from the defaults built in to
driver, or when the driver can't auto-detect the correct defaults.
Don't specify it unless the driver-specific documentation recommends that you
do.
.TP 7
.BI "Clocks  " "clock ..."
specifies the pixel that are on your graphics board.
The clocks are in MHz, and may be specified as a floating point number.
The value is stored internally to the nearest kHz.
The ordering of the clocks is important.
It must match the order in which they are selected on the graphics board.
Multiple
.B Clocks
lines may be specified, and each is concatenated to form the list.
Most drivers do not use this entry, and it is only required for some older
boards with non-programmable clocks.
Don't specify this entry unless the driver-specific documentation explicitly
recommends that you do.
.TP
.BI "ClockChip  \*q" clockchip\-type \*q
This optional entry is used to specify the clock chip type on graphics
boards which have a programmable clock generator.
Only a few Xorg drivers support programmable clock chips.
For details, see the appropriate driver manual page.
.TP 7
.BI "VideoRam  " "mem"
This optional entry specifies the amount of video ram that is installed
on the graphics board.
This is measured in kBytes.
In most cases this is not required because the Xorg server probes
the graphics board to determine this quantity.
The driver-specific documentation should indicate when it might be needed.
.TP 7
.BI "MemBase  " "baseaddress"
This optional entry specifies the memory base address of a graphics
board's linear frame buffer.
This entry is not used by many drivers, and it should only be specified if
the driver-specific documentation recommends it.
.TP 7
.BI "IOBase  " "baseaddress"
This optional entry specifies the IO base address.
This entry is not used by many drivers, and it should only be specified if
the driver-specific documentation recommends it.
.TP 7
.BI "ChipID  " "id"
This optional entry specifies a numerical ID representing the chip type.
For PCI cards, it is usually the device ID.
This can be used to override the auto-detection, but that should only be done
when the driver-specific documentation recommends it.
.TP 7
.BI "ChipRev  " "rev"
This optional entry specifies the chip revision number.
This can be used to override the auto-detection, but that should only be done
when the driver-specific documentation recommends it.
.TP 7
.BI "MatchSeat  " "seat\-id"
Only apply this
.B Device
section if X server was started with
.B -seat
.I seat\-id
option.
.TP 7
.BI "Option \*qModeDebug\*q \*q" boolean \*q
Enable printing of additional debugging information about modesetting to
the server log.
.TP 7
.BI "Option \*qNoOutputInitialSize\*q \*q" width " " height \*q
Normally, the X server infers the initial screen size based on any
connected outputs.
However, if no outputs are connected, the X server picks a default screen size
of 1024 x 768.
This option overrides the default screen size to use when no outputs are
connected.
In contrast to the \*qVirtual\*q Display SubSection entry, which applies
unconditionally, \*qNoOutputInitialSize\*q is only used if no outputs are
detected when the X server starts.
.TP 7
.BI "Option \*qPreferCloneMode\*q \*q" boolean \*q
If enabled, bring up monitors of a screen in clone mode instead of horizontal
extended layout by default. (Defaults to off; the video driver can change the
default value, but this option can always override it)
.ig
.TP 7
This optional entry allows an IRQ number to be specified.
..
.TP 7
.B Options
Option flags may be specified in the
.B Device
sections.
These include driver\-specific options and driver\-independent options.
The former are described in the driver\-specific documentation.
Some of the latter are described below in the section about the
.B Screen
section, and they may also be included here.

.SH "VIDEOADAPTOR SECTION"
Nobody wants to say how this works.
Maybe nobody knows ...

.SH "MONITOR SECTION"
The config file may have multiple
.B Monitor
sections.
There should normally be at least one, for the monitor being used,
but a default configuration will be created when one isn't specified.
.PP
.B Monitor
sections have the following format:
.PP
.RS 4
.nf
.B  "Section \*qMonitor\*q"
.BI "    Identifier \*q" name \*q
.I  "    entries"
.I  "    ..."
.B  "EndSection"
.fi
.RE
.PP
The only mandatory entry in a
.B Monitor
section is the
.B Identifier
entry.
.PP
The
.B Identifier
entry specifies the unique name for this monitor.
The
.B Monitor
section may be used to provide information about the specifications of the
monitor, monitor-specific
.BR Options ,
and information about the video modes to use with the monitor.
.PP
With RandR 1.2-enabled drivers, monitor sections may be tied to specific
outputs of the video card.  Using the name of the output defined by the video
driver plus the identifier of a monitor section, one associates a monitor
section with an output by adding an option to the Device section in the
following format:

.BI "Option \*qMonitor-" outputname "\*q \*q" monitorsection \*q

(for example,
.B Option \*qMonitor-VGA\*q \*qVGA monitor\*q
for a VGA output)
.PP
In the absence of specific association of monitor sections to outputs, if a
monitor section is present the server will associate it with an output to
preserve compatibility for previous single-head configurations.
.PP
Specifying video modes is optional because the server will use the DDC or other
information provided by the monitor to automatically configure the list of
modes available.
When modes are specified explicitly in the
.B Monitor
section (with the
.BR Mode ,
.BR ModeLine ,
or
.B UseModes
keywords), built-in modes with the same names are not included.
Built-in modes with different names are, however, still implicitly included,
when they meet the requirements of the monitor.
.PP
The entries that may be used in
.B Monitor
sections are described below.
.TP 7
.BI "VendorName  \*q" vendor \*q
This optional entry specifies the monitor's manufacturer.
.TP 7
.BI "ModelName  \*q" model \*q
This optional entry specifies the monitor's model.
.TP 7
.BI "HorizSync  " "horizsync\-range"
gives the range(s) of horizontal sync frequencies supported by the
monitor.
.I horizsync\-range
may be a comma separated list of either discrete values or ranges of
values.
A range of values is two values separated by a dash.
By default the values are in units of kHz.
They may be specified in MHz or Hz
if
.B MHz
or
.B Hz
is added to the end of the line.
The data given here is used by the Xorg server to determine if video
modes are within the specifications of the monitor.
This information should be available in the monitor's handbook.
If this entry is omitted, a default range of 28\-33kHz is used.
.TP 7
.BI "VertRefresh  " "vertrefresh\-range"
gives the range(s) of vertical refresh frequencies supported by the
monitor.
.I vertrefresh\-range
may be a comma separated list of either discrete values or ranges of
values.
A range of values is two values separated by a dash.
By default the values are in units of Hz.
They may be specified in MHz or kHz
if
.B MHz
or
.B kHz
is added to the end of the line.
The data given here is used by the Xorg server to determine if video
modes are within the specifications of the monitor.
This information should be available in the monitor's handbook.
If this entry is omitted, a default range of 43\-72Hz is used.
.TP 7
.BI "DisplaySize  " "width height"
This optional entry gives the width and height, in millimetres, of the
picture area of the monitor.
If given this is used to calculate the horizontal and vertical pitch (DPI) of
the screen.
.TP 7
.BI "Gamma  " "gamma\-value"
.TP 7
.BI "Gamma  " "red\-gamma green\-gamma blue\-gamma"
This is an optional entry that can be used to specify the gamma correction
for the monitor.
It may be specified as either a single value or as three separate RGB values.
The values should be in the range 0.1 to 10.0, and the default is 1.0.
Not all drivers are capable of using this information.
.TP 7
.BI "UseModes  \*q" modesection\-id \*q
Include the set of modes listed in the
.B Modes
section called
.IR modesection\-id.
This makes all of the modes defined in that section available for use by
this monitor.
.TP 7
.BI "Mode  \*q" name \*q
This is an optional multi-line entry that can be used to provide
definitions for video modes for the monitor.
In most cases this isn't necessary because the built-in set of VESA standard
modes will be sufficient.
The
.B Mode
keyword indicates the start of a multi-line video mode description.
The mode description is terminated with the
.B EndMode
keyword.
The mode description consists of the following entries:
.RS 7
.TP 4
.BI "DotClock  " clock
is the dot (pixel) clock rate to be used for the mode.
.TP 4
.BI "HTimings  " "hdisp hsyncstart hsyncend htotal"
specifies the horizontal timings for the mode.
.TP 4
.BI "VTimings  " "vdisp vsyncstart vsyncend vtotal"
specifies the vertical timings for the mode.
.TP 4
.BI "Flags  \*q" flag \*q " ..."
specifies an optional set of mode flags, each of which is a separate
string in double quotes.
.B \*qInterlace\*q
indicates that the mode is interlaced.
.B \*qDoubleScan\*q
indicates a mode where each scanline is doubled.
.B \*q+HSync\*q
and
.B \*q\-HSync\*q
can be used to select the polarity of the HSync signal.
.B \*q+VSync\*q
and
.B \*q\-VSync\*q
can be used to select the polarity of the VSync signal.
.B \*qComposite\*q
can be used to specify composite sync on hardware where this is supported.
Additionally, on some hardware,
.B \*q+CSync\*q
and
.B \*q\-CSync\*q
may be used to select the composite sync polarity.
.TP 4
.BI "HSkew  " hskew
specifies the number of pixels (towards the right edge of the screen) by
which the display enable signal is to be skewed.
Not all drivers use this information.
This option might become necessary to override the default value supplied
by the server (if any).
\(lqRoving\(rq horizontal lines indicate this value needs to be increased.
If the last few pixels on a scan line appear on the left of the screen,
this value should be decreased.
.TP 4
.BI "VScan  " vscan
specifies the number of times each scanline is painted on the screen.
Not all drivers use this information.
Values less than 1 are treated as 1, which is the default.
Generally, the
.B \*qDoubleScan\*q
.B Flag
mentioned above doubles this value.
.RE
.TP 7
.BI "ModeLine  \*q" name \*q " mode\-description"
This entry is a more compact version of the
.B Mode
entry, and it also can be used to specify video modes for the monitor.
This is a single line format for specifying video modes.
In most cases this isn't necessary because the built\-in set of VESA
standard modes will be sufficient.
.PP
.RS 7
The
.I mode\-description
is in four sections, the first three of which are mandatory.
The first is the dot (pixel) clock.
This is a single number specifying the pixel clock rate for the mode in
MHz.
The second section is a list of four numbers specifying the horizontal
timings.
These numbers are the
.IR hdisp ,
.IR hsyncstart ,
.IR hsyncend ,
and
.I htotal
values.
The third section is a list of four numbers specifying the vertical
timings.
These numbers are the
.IR vdisp ,
.IR vsyncstart ,
.IR vsyncend ,
and
.I vtotal
values.
The final section is a list of flags specifying other characteristics of
the mode.
.B Interlace
indicates that the mode is interlaced.
.B DoubleScan
indicates a mode where each scanline is doubled.
.B +HSync
and
.B \-HSync
can be used to select the polarity of the HSync signal.
.B +VSync
and
.B \-VSync
can be used to select the polarity of the VSync signal.
.B Composite
can be used to specify composite sync on hardware where this is supported.
Additionally, on some hardware,
.B +CSync
and
.B \-CSync
may be used to select the composite sync polarity.
The
.B HSkew
and
.B VScan
options mentioned above in the
.B Mode
entry description can also be used here.
.RE
.TP 7
.BI "Option \*qDPMS\*q \*q" bool \*q
This option controls whether the server should enable the DPMS extension
for power management for this screen.  The default is to enable the
extension.
.TP 7
.BI "Option \*qSyncOnGreen\*q \*q" bool \*q
This option controls whether the video card should drive the sync signal
on the green color pin.  Not all cards support this option, and most
monitors do not require it.  The default is off.
.TP 7
.BI "Option \*qPrimary\*q \*q" bool \*q
This optional entry specifies that the monitor should be treated as the primary
monitor. (RandR 1.2-supporting drivers only)
.TP 7
.BI "Option \*qPreferredMode\*q \*q" name \*q
This optional entry specifies a mode to be marked as the preferred initial mode
of the monitor.
(RandR 1.2-supporting drivers only)
.TP 7
.BI "Option \*qZoomModes\*q \*q" name " " name " " ... \*q
This optional entry specifies modes to be marked as zoom modes.
It is possible to switch to the next and previous mode via
.BR Ctrl+Alt+Keypad\-Plus " and " Ctrl+Alt+Keypad\-Minus .
All these keypad available modes are selected from the screen mode list.
This list is a copy of the compatibility output monitor mode list.
Since this output is the output connected to the lowest
dot-area monitor, as determined from its largest size mode, that
monitor defines the available zoom modes.
(RandR 1.2-supporting drivers only)
.TP 7
.BI "Option \*qPosition\*q \*q" x " " y \*q
This optional entry specifies the position of the monitor within the X
screen.
(RandR 1.2-supporting drivers only)
.TP 7
.BI "Option \*qLeftOf\*q \*q" output \*q
This optional entry specifies that the monitor should be positioned to the
left of the output (not monitor) of the given name.
(RandR 1.2-supporting drivers only)
.TP 7
.BI "Option \*qRightOf\*q \*q" output \*q
This optional entry specifies that the monitor should be positioned to the
right of the output (not monitor) of the given name.
(RandR 1.2-supporting drivers only)
.TP 7
.BI "Option \*qAbove\*q \*q" output \*q
This optional entry specifies that the monitor should be positioned above the
output (not monitor) of the given name.
(RandR 1.2-supporting drivers only)
.TP 7
.BI "Option \*qBelow\*q \*q" output \*q
This optional entry specifies that the monitor should be positioned below the
output (not monitor) of the given name.
(RandR 1.2-supporting drivers only)
.TP 7
.BI "Option \*qEnable\*q \*q" bool \*q
This optional entry specifies whether the monitor should be turned on
at startup.  By default, the server will attempt to enable all connected
monitors.
(RandR 1.2-supporting drivers only)
.TP 7
.BI "Option \*qDefaultModes\*q \*q" bool \*q
This optional entry specifies whether the server should add supported default
modes to the list of modes offered on this monitor. By default, the server
will add default modes; you should only disable this if you can guarantee
that EDID will be available at all times, or if you have added custom modelines
which the server can use.
(RandR 1.2-supporting drivers only)
.TP 7
.BI "Option \*qMinClock\*q \*q" frequency \*q
This optional entry specifies the minimum dot clock, in kHz, that is supported
by the monitor.
.TP 7
.BI "Option \*qMaxClock\*q \*q" frequency \*q
This optional entry specifies the maximum dot clock, in kHz, that is supported
by the monitor.
.TP 7
.BI "Option \*qIgnore\*q \*q" bool \*q
This optional entry specifies that the monitor should be ignored entirely,
and not reported through RandR.  This is useful if the hardware reports the
presence of outputs that don't exist.
(RandR 1.2-supporting drivers only)
.TP 7
.BI "Option \*qRotate\*q \*q" rotation \*q
This optional entry specifies the initial rotation of the given monitor.
Valid values for rotation are \*qnormal\*q, \*qleft\*q, \*qright\*q, and
\*qinverted\*q.
(RandR 1.2-supporting drivers only)

.SH "MODES SECTION"
The config file may have multiple
.B Modes
sections, or none.
These sections provide a way of defining sets of video modes independently
of the
.B Monitor
sections.
.B Monitor
sections may include the definitions provided in these sections by
using the
.B UseModes
keyword.
In most cases the
.B Modes
sections are not necessary because the built\-in set of VESA standard modes
will be sufficient.
.PP
.B Modes
sections have the following format:
.PP
.RS 4
.nf
.B  "Section \*qModes\*q"
.BI "    Identifier \*q" name \*q
.I  "    entries"
.I  "    ..."
.B  "EndSection"
.fi
.RE
.PP
The
.B Identifier
entry specifies the unique name for this set of mode descriptions.
The other entries permitted in
.B Modes
sections are the
.B Mode
and
.B ModeLine
entries that are described above in the
.B Monitor
section.
.SH "SCREEN SECTION"
The config file may have multiple
.B Screen
sections.
There must be at least one, for the \(lqscreen\(rq being used.
A \(lqscreen\(rq represents the binding of a graphics device
.RB ( Device
section) and a monitor
.RB ( Monitor
section).
A
.B Screen
section is considered \(lqactive\(rq if it is referenced by an active
.B ServerLayout
section or by the
.B \-screen
command line option.
If neither of those is present, the first
.B Screen
section found in the config file is considered the active one.
.PP
.B Screen
sections have the following format:
.PP
.RS 4
.nf
.B  "Section \*qScreen\*q"
.BI "    Identifier \*q" name \*q
.BI "    Device     \*q" devid \*q
.BI "    GPUDevice  \*q" devid \*q
.BI "    Monitor    \*q" monid \*q
.I  "    entries"
.I  "    ..."
.BI "    SubSection \*qDisplay\*q"
.I  "       entries"
.I  "       ...
.B  "    EndSubSection"
.I  "    ..."
.B  "EndSection"
.fi
.RE
.PP
The
.B Identifier
entry is mandatory.
All others are optional.
.PP
The
.B Identifier
entry specifies the unique name for this screen.
The
.B Screen
section provides information specific to the whole screen, including
screen\-specific
.BR Options .
In multi\-head configurations, there will be multiple active
.B Screen
sections, one for each head.
The entries available
for this section are:
.TP 7
.BI "Device  \*q" device\-id \*q
This entry specifies the
.B Device
section to be used for this screen.  When multiple graphics cards are
present, this is what ties a specific card to a screen.  The
.I device\-id
must match the
.B Identifier
of a
.B Device
section in the config file.
.TP 7
.BI "GPUDevice  \*q" device\-id \*q
This entry specifies the
.B Device
section to be used as a secondary GPU device for this screen.  When multiple graphics cards are
present, this is what ties a specific secondary card to a screen.  The
.I device\-id
must match the
.B Identifier
of a
.B Device
section in the config file. This can be specified up to 4 times for a single screen.
.TP 7
.BI "Monitor  \*q" monitor\-id \*q
specifies which monitor description is to be used for this screen.
If a
.B Monitor
name is not specified, a default configuration is used.
Currently the default configuration may not function as expected on all
platforms.
.TP 7
.BI "VideoAdaptor  \*q" xv\-id \*q
specifies an optional Xv video adaptor description to be used with this
screen.
.TP 7
.BI "DefaultDepth  " depth
specifies which color depth the server should use by default.
The
.B \-depth
command line option can be used to override this.
If neither is specified, the default depth is driver\-specific, but in most
cases is 8.
.TP 7
.BI "DefaultFbBpp  " bpp
specifies which framebuffer layout to use by default.
The
.B \-fbbpp
command line option can be used to override this.
In most cases the driver will chose the best default value for this.
The only case where there is even a choice in this value is for depth 24,
where some hardware supports both a packed 24 bit framebuffer layout and a
sparse 32 bit framebuffer layout.
.TP 7
.BI "MatchSeat  " "seat\-id"
Only apply this
.B Screen
section if X server was started with
.B -seat
.I seat\-id
option.
.TP 7
.B Options
Various
.B Option
flags may be specified in the
.B Screen
section.
Some are driver\-specific and are described in the driver documentation.
Others are driver\-independent, and will eventually be described here.
.\" XXX These should really be in an xaa man page.
.TP 7
.BI "Option \*qAccel\*q"
Enables 2D hardware acceleration.
This option is on by default, but it may be necessary to turn it off if
there are bugs in the driver.
There are many options to disable specific accelerated operations, listed
below.
Note that disabling an operation will have no effect if the operation is
not accelerated (whether due to lack of support in the hardware or in the
driver).
.TP 7
.BI "Option \*qGlxVendorLibrary\*q \*q" string \*q
This option specifies a space-separated list of OpenGL vendor libraries to
use for the screen. This may be used to select an alternate implementation
for development, debugging, or alternate feature sets.
Default: mesa.
.TP 7
.BI "Option \*qInitPrimary\*q \*q" boolean \*q
Use the Int10 module to initialize the primary graphics card.
Normally, only secondary cards are soft-booted using the Int10 module, as the
primary card has already been initialized by the BIOS at boot time.
Default: false.
.TP 7
.BI "Option \*qNoInt10\*q \*q" boolean \*q
Disables the Int10 module, a module that uses the int10 call to the BIOS
of the graphics card to initialize it.
Default: false.
.PP
Each
.B Screen
section may optionally contain one or more
.B Display
subsections.
Those subsections provide depth/fbbpp specific configuration information,
and the one chosen depends on the depth and/or fbbpp that is being used for
the screen.
The
.B Display
subsection format is described in the section below.

.SH "DISPLAY SUBSECTION"
Each
.B Screen
section may have multiple
.B Display
subsections.
The \(lqactive\(rq
.B Display
subsection is the first that matches the depth and/or fbbpp values being
used, or failing that, the first that has neither a depth or fbbpp value
specified.
The
.B Display
subsections are optional.
When there isn't one that matches the depth and/or fbbpp values being used,
all the parameters that can be specified here fall back to their defaults.
.PP
.B Display
subsections have the following format:
.PP
.RS 4
.nf
.B  "    SubSection \*qDisplay\*q"
.BI "        Depth  " depth
.I  "        entries"
.I  "        ..."
.B  "    EndSubSection"
.fi
.RE
.TP 7
.BI "Depth  " depth
This entry specifies what colour depth the
.B Display
subsection is to be used for.
This entry is usually specified, but it may be omitted to create a match\-all
.B Display
subsection or when wishing to match only against the
.B FbBpp
parameter.
The range of
.I depth
values that are allowed depends on the driver.
Most drivers support 8, 15, 16 and 24.
Some also support 1 and/or 4, and some may support other values (like 30).
Note:
.I depth
means the number of bits in a pixel that are actually used to determine
the pixel colour.
32 is not a valid
.I depth
value.
Most hardware that uses 32 bits per pixel only uses 24 of them to hold the
colour information, which means that the colour depth is 24, not 32.
.TP 7
.BI "FbBpp  " bpp
This entry specifies the framebuffer format this
.B Display
subsection is to be used for.
This entry is only needed when providing depth 24 configurations that allow
a choice between a 24 bpp packed framebuffer format and a 32bpp sparse
framebuffer format.
In most cases this entry should not be used.
.TP 7
.BI "Weight  " "red\-weight green\-weight blue\-weight"
This optional entry specifies the relative RGB weighting to be used
for a screen is being used at depth 16 for drivers that allow multiple
formats.
This may also be specified from the command line with the
.B \-weight
option (see
.BR Xorg(@appmansuffix@)).
.TP 7
.BI "Virtual  " "xdim ydim"
This optional entry specifies the virtual screen resolution to be used.
.I xdim
must be a multiple of either 8 or 16 for most drivers, and a multiple
of 32 when running in monochrome mode.
The given value will be rounded down if this is not the case.
Video modes which are too large for the specified virtual size will be
rejected.
If this entry is not present, the virtual screen resolution will be set to
accommodate all the valid video modes given in the
.B Modes
entry.
Some drivers/hardware combinations do not support virtual screens.
Refer to the appropriate driver\-specific documentation for details.
.TP 7
.BI "ViewPort  " "x0 y0"
This optional entry sets the upper left corner of the initial display.
This is only relevant when the virtual screen resolution is different
from the resolution of the initial video mode.
If this entry is not given, then the initial display will be centered in
the virtual display area.
.TP 7
.BI "Modes  \*q" mode\-name \*q " ..."
This optional entry specifies the list of video modes to use.
Each
.I mode\-name
specified must be in double quotes.
They must correspond to those specified or referenced in the appropriate
.B Monitor
section (including implicitly referenced built\-in VESA standard modes).
The server will delete modes from this list which don't satisfy various
requirements.
The first valid mode in this list will be the default display mode for
startup.
The list of valid modes is converted internally into a circular list.
It is possible to switch to the next mode with
.B Ctrl+Alt+Keypad\-Plus
and to the previous mode with
.BR Ctrl+Alt+Keypad\-Minus .
When this entry is omitted, the valid modes referenced by the appropriate
.B Monitor
section will be used.  If the
.B Monitor
section contains no modes, then the selection will be taken from the
built-in VESA standard modes.
.TP 7
.BI "Visual  \*q" visual\-name \*q
This optional entry sets the default root visual type.
This may also be specified from the command line (see the
.BR Xserver(@appmansuffix@)
man page).
The visual types available for depth 8 are (default is
.BR PseudoColor ):
.PP
.RS 11
.nf
.B StaticGray
.B GrayScale
.B StaticColor
.B PseudoColor
.B TrueColor
.B DirectColor
.fi
.RE
.PP
.RS 7
The visual type available for the depths 15, 16 and 24 are (default is
.BR TrueColor ):
.PP
.RS 4
.nf
.B TrueColor
.B DirectColor
.fi
.RE
.PP
Not all drivers support
.B DirectColor
at these depths.
.PP
The visual types available for the depth 4 are (default is
.BR StaticColor ):
.PP
.RS 4
.nf
.B StaticGray
.B GrayScale
.B StaticColor
.B PseudoColor
.fi
.RE
.PP
The visual type available for the depth 1 (monochrome) is
.BR StaticGray .
.RE
.TP 7
.BI "Black  " "red green blue"
This optional entry allows the \(lqblack\(rq colour to be specified.
This is only supported at depth 1.
The default is black.
.TP 7
.BI "White  " "red green blue"
This optional entry allows the \(lqwhite\(rq colour to be specified.
This is only supported at depth 1.
The default is white.
.TP 7
.B Options
Option flags may be specified in the
.B Display
subsections.
These may include driver\-specific options and driver\-independent options.
The former are described in the driver\-specific documentation.
Some of the latter are described above in the section about the
.B Screen
section, and they may also be included here.
.SH "SERVERLAYOUT SECTION"
The config file may have multiple
.B ServerLayout
sections.
A \(lqserver layout\(rq represents the binding of one or more screens
.RB ( Screen
sections) and one or more input devices
.RB ( InputDevice
sections) to form a complete configuration.
In multi\-head configurations, it also specifies the relative layout of the
heads.
A
.B ServerLayout
section is considered \(lqactive\(rq if it is referenced by the
.B \-layout
command line option or by an
.B "Option \*qDefaultServerLayout\*q"
entry in the
.B ServerFlags
section (the former takes precedence over the latter).
If those options are not used, the first
.B ServerLayout
section found in the config file is considered the active one.
If no
.B ServerLayout
sections are present, the single active screen and two active (core)
input devices are selected as described in the relevant sections above.
.PP
.B ServerLayout
sections have the following format:
.PP
.RS 4
.nf
.B  "Section \*qServerLayout\*q"
.BI "    Identifier   \*q" name \*q
.BI "    Screen       \*q" screen\-id \*q
.I  "    ..."
.BI "    InputDevice  \*q" idev\-id \*q
.I  "    ..."
.I  "    options"
.I  "    ..."
.B  "EndSection"
.fi
.RE
.PP
Each
.B ServerLayout
section must have an
.B Identifier
entry and at least one
.B Screen
entry.
.PP
The
.B Identifier
entry specifies the unique name for this server layout.
The
.B ServerLayout
section provides information specific to the whole session, including
session\-specific
.BR Options .
The
.B ServerFlags
options (described above) may be specified here, and ones given here
override those given in the
.B ServerFlags
section.
.PP
The entries that may be used in this section are described here.
.TP 7
.BI "Screen  " "screen\-num" " \*qscreen\-id\*q " "position\-information"
One of these entries must be given for each screen being used in
a session.
The
.I screen\-id
field is mandatory, and specifies the
.B Screen
section being referenced.
The
.I screen\-num
field is optional, and may be used to specify the screen number
in multi\-head configurations.
When this field is omitted, the screens will be numbered in the order that
they are listed in.
The numbering starts from 0, and must be consecutive.
The
.I position\-information
field describes the way multiple screens are positioned.
There are a number of different ways that this information can be provided:
.RS 7
.TP 4
.I  "x y"
.TP 4
.BI "Absolute  " "x y"
These both specify that the upper left corner's coordinates are
.RI ( x , y ).
The
.B Absolute
keyword is optional.
Some older versions of XFree86 (4.2 and earlier) don't recognise the
.B Absolute
keyword, so it's safest to just specify the coordinates without it.
.TP 4
.BI "RightOf   \*q" screen\-id \*q
.TP 4
.BI "LeftOf    \*q" screen\-id \*q
.TP 4
.BI "Above     \*q" screen\-id \*q
.TP 4
.BI "Below     \*q" screen\-id \*q
.TP 4
.BI "Relative  \*q" screen\-id \*q " x y"
These give the screen's location relative to another screen.
The first four position the screen immediately to the right, left, above or
below the other screen.
When positioning to the right or left, the top edges are aligned.
When positioning above or below, the left edges are aligned.
The
.B Relative
form specifies the offset of the screen's origin (upper left corner)
relative to the origin of another screen.
.RE
.TP 7
.BI "InputDevice  \*q" idev\-id "\*q \*q" option \*q " ..."
One of these entries should be given for each input device being used in
a session.
Normally at least two are required, one each for the core pointer and
keyboard devices.
If either of those is missing, suitable
.B InputDevice
entries are searched for using the method described above in the
.B INPUTDEVICE
section.  The
.I idev\-id
field is mandatory, and specifies the name of the
.B InputDevice
section being referenced.
Multiple
.I option
fields may be specified, each in double quotes.
The options permitted here are any that may also be given in the
.B InputDevice
sections.
Normally only session\-specific input device options would be used here.
The most commonly used options are:
.PP
.RS 11
.nf
.B \*qCorePointer\*q
.B \*qCoreKeyboard\*q
.B \*qSendCoreEvents\*q
.fi
.RE
.PP
.RS 7
and the first two should normally be used to indicate the core pointer
and core keyboard devices respectively.
.RE
.TP 7
.BI "MatchSeat  " "seat\-id"
Only apply this
.B ServerLayout
section if X server was started with
.B -seat
.I seat\-id
option.
.TP 7
.B Options
In addition to the following, any option permitted in the
.B ServerFlags
section may also be specified here.
When the same option appears in both places, the value given here overrides
the one given in the
.B ServerFlags
section.
.TP 7
.BI "Option \*qIsolateDevice\*q  \*q" bus\-id \*q
Restrict device resets to the specified
.IR bus\-id .
See the
.B BusID
option (described in
.BR "DEVICE SECTION" ,
above) for the format of the
.I bus\-id
parameter.
This option overrides
.BR SingleCard ,
if specified.
At present, only PCI devices can be isolated in this manner.
.TP 7
.BI "Option \*qSingleCard\*q  \*q" boolean \*q
As
.BR IsolateDevice ,
except that the bus ID of the first device in the layout is used.
.PP
Here is an example of a
.B ServerLayout
section for a dual headed configuration with two mice:
.PP
.RS 4
.nf
.B "Section \*qServerLayout\*q"
.B "    Identifier  \*qLayout 1\*q"
.B "    Screen      \*qMGA 1\*q"
.B "    Screen      \*qMGA 2\*q RightOf \*qMGA 1\*q"
.B "    InputDevice \*qKeyboard 1\*q \*qCoreKeyboard\*q"
.B "    InputDevice \*qMouse 1\*q    \*qCorePointer\*q"
.B "    InputDevice \*qMouse 2\*q    \*qSendCoreEvents\*q"
.B "    Option      \*qBlankTime\*q  \*q5\*q"
.B "EndSection"
.fi
.RE
.SH "DRI SECTION"
This optional section is used to provide some information for the
Direct Rendering Infrastructure.
Details about the format of this section can be found on-line at
.IR <https://dri.freedesktop.org/> .
.SH "VENDOR SECTION"
The optional
.B Vendor
section may be used to provide vendor\-specific configuration information.
Multiple
.B Vendor
sections may be present, and they may contain an
.B Identifier
entry and multiple
.B Option
flags.
The data therein is not used in this release.
.PP
.SH "SEE ALSO"
General:
.BR X (@miscmansuffix@),
.BR Xserver (@appmansuffix@),
.BR Xorg (@appmansuffix@),
.BR cvt (@appmansuffix@),
.BR gtf (@appmansuffix@).
.PP
.B "Not all modules or interfaces are available on all platforms."
.PP
Display drivers:
.BR apm (@drivermansuffix@),
.BR ati (@drivermansuffix@),
.BR chips (@drivermansuffix@),
.BR cirrus (@drivermansuffix@),
.BR cyrix (@drivermansuffix@),
.BR fbdev (@drivermansuffix@),
.BR glide (@drivermansuffix@),
.BR glint (@drivermansuffix@),
.BR i128 (@drivermansuffix@),
.BR i740 (@drivermansuffix@),
.BR imstt (@drivermansuffix@),
.BR intel (@drivermansuffix@),
.BR mga (@drivermansuffix@),
.BR neomagic (@drivermansuffix@),
.BR nv (@drivermansuffix@),
.BR openchrome (@drivermansuffix@),
.BR r128 (@drivermansuffix@),
.BR radeon (@drivermansuffix@),
.BR rendition (@drivermansuffix@),
.BR savage (@drivermansuffix@),
.BR s3virge (@drivermansuffix@),
.BR siliconmotion (@drivermansuffix@),
.BR sis (@drivermansuffix@),
.BR sisusb (@drivermansuffix@),
.BR sunbw2 (@drivermansuffix@),
.BR suncg14 (@drivermansuffix@),
.BR suncg3 (@drivermansuffix@),
.BR suncg6 (@drivermansuffix@),
.BR sunffb (@drivermansuffix@),
.BR sunleo (@drivermansuffix@),
.BR suntcx (@drivermansuffix@),
.BR tdfx (@drivermansuffix@),
.\" .BR tga (@drivermansuffix@),
.BR trident (@drivermansuffix@),
.BR tseng (@drivermansuffix@),
.BR vesa (@drivermansuffix@),
.BR vmware (@drivermansuffix@),
.BR voodoo (@drivermansuffix@),
.BR wsfb (@drivermansuffix@),
.BR xgi (@drivermansuffix@),
.BR xgixp (@drivermansuffix@).
.PP
Input drivers:
.BR acecad (@drivermansuffix@),
.BR citron (@drivermansuffix@),
.BR elographics (@drivermansuffix@),
.BR evdev (@drivermansuffix@),
.BR fpit (@drivermansuffix@),
.BR joystick (@drivermansuffix@),
.BR kbd (@drivermansuffix@),
.BR libinput (@drivermansuffix@),
.BR mousedrv (@drivermansuffix@),
.BR mutouch (@drivermansuffix@),
.BR penmount (@drivermansuffix@),
.BR synaptics (@drivermansuffix@),
.BR vmmouse (@drivermansuffix@),
.BR void (@drivermansuffix@),
.BR wacom (@drivermansuffix@).
.PP
Other modules and interfaces:
.BR exa (@drivermansuffix@),
.BR fbdevhw (@drivermansuffix@),
.\" .BR shadowfb (@drivermansuffix@),
.BR v4l (@drivermansuffix@).
.br
.SH AUTHORS
This manual page was largely rewritten by David Dawes
.IR <dawes@xfree86.org> .
