/* powerpc64-linux.elf-fold.h
   created from powerpc64-linux.elf-fold.bin, 20687 (0x50cf) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2025 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2025 Laszlo Molnar
   Copyright (C) 2000-2025 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */

/* clang-format off */

#define STUB_POWERPC64_LINUX_ELF_FOLD_SIZE    20687
#define STUB_POWERPC64_LINUX_ELF_FOLD_ADLER32 0x52fe5ba3
#define STUB_POWERPC64_LINUX_ELF_FOLD_CRC32   0x4ac8eb45

unsigned char stub_powerpc64_linux_elf_fold[20687] = {
/* 0x0000 */ 127, 69, 76, 70,  2,  2,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   0,  1,  0, 21,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 55,192,
/* 0x0030 */   0,  0,  0,  0,  0, 64,  0,  0,  0,  0,  0, 64,  0, 22,  0, 19,
/* 0x0040 */ 255,255,255,255,255,255,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0050 */  72,  0,  0,172,124,  8,  2,166, 72,  0,  0,  5,124,104,  2,166,
/* 0x0060 */ 124,  8,  3,166,232, 99,255,228, 78,128,  0, 32,124,  8,  2,166,
/* 0x0070 */  72,  0,  0,  5,124,200,  2,166,124,  8,  3,166,232,  6,255,204,
/* 0x0080 */ 124, 96,  0,120,124, 96, 24, 80,124,132,  2, 20, 72,  0,  0,  0,
/* 0x0090 */ 124,  8,  2,166, 72,  0,  0,  5,124,200,  2,166,124,  8,  3,166,
/* 0x00a0 */ 232,  6,255,168,124, 96,  0,120,124, 96, 24, 80,124,132,  2, 20,
/* 0x00b0 */  72,  0,  0,  0,124,  8,  2,166, 72,  0,  0,  5,124,200,  2,166,
/* 0x00c0 */ 124,  8,  3,166,232,  6,255,132,124, 96,  0,120,124, 96, 24, 80,
/* 0x00d0 */ 124,132,  2, 20, 72,  0,  0,  0,124,  8,  2,166, 72,  0,  0,  5,
/* 0x00e0 */ 124,200,  2,166,124,  8,  3,166,232,  6,255, 96,124, 96,  0,120,
/* 0x00f0 */ 124, 96, 24, 80,124,132,  2, 20, 72,  0,  0,  0,124,  9,  3,166,
/* 0x0100 */ 128, 22,  0,  0, 84,  0, 96, 38,124, 16,129, 32, 72,  0,  0, 25,
/* 0x0110 */  32, 32, 32, 61, 47,112,114,111, 99, 47,115,101,108,102, 47,101,
/* 0x0120 */ 120,101,  0,  0,126,200,  2,166, 58,214,  0,  4, 56,129,255,248,
/* 0x0130 */  65,146,  0, 16, 56,  0, 16,  4,124, 32,  8, 80,120, 33,  6,228,
/* 0x0140 */  56, 97,255,248, 59, 90,255,248,232,  4,  0,  9,127,164,208, 64,
/* 0x0150 */ 248,  3,  0,  9, 65,156,255,244, 59, 67,  0, 16,248,  3,  0,  9,
/* 0x0160 */ 232,  4,  0,  8, 43,160,  0,  0,248,  3,  0,  8,232,  4,  0, 17,
/* 0x0170 */ 248,  3,  0, 17, 64,158,255,236, 58,163,  0,  8, 65,146,  0,180,
/* 0x0180 */ 126,122,168, 80,128, 22,255,252, 58, 68,  0,  8,148,  3,  0,  8,
/* 0x0190 */  59,195,  0,  4, 56,128,  0,  0,126,195,179,120, 72,  0,  0,  1,
/* 0x01a0 */ 124,123, 27,120, 56,160, 15,255,127,196,243,120,126,195,179,120,
/* 0x01b0 */  72,  0,  0,  1, 56,190,255,252, 44, 35,  0,  0, 65,129,  0, 12,
/* 0x01c0 */  56,182,255,252, 56, 96,  0, 12, 56, 99,  0,  4,124,133, 26, 20,
/* 0x01d0 */ 124,105,  3,166,126, 67,147,120, 56,160,  0,  0,156,163,255,255,
/* 0x01e0 */ 140,  4,255,255,156,  3,255,255, 66,  0,255,248,248,122,255,240,
/* 0x01f0 */ 120, 99,  7, 36,124, 32, 34,120,124,  0, 26,120,120,  0,  7, 32,
/* 0x0200 */ 124, 96, 24, 80,126,164,171,120, 56,  0,  0,  0,248,  3,255,249,
/* 0x0210 */ 248,  3,255,249,124,117, 27,120,127, 83, 24, 80,232,  4,255,249,
/* 0x0220 */ 127,164,  8, 64,248,  3,255,249, 65,253,255,244,124, 97, 27,120,
/* 0x0230 */  57, 33,  1,136,251, 41,  0,  0,248, 33,247,113,127,  3,195,120,
/* 0x0240 */ 126,228,187,120, 56,161,  0,144,127, 70,211,120, 56,225, 10, 24,
/* 0x0250 */ 251, 39,  0,  0, 72,  0,  0,  1, 56, 33,  8,144,126,162,171,120,
/* 0x0260 */ 112, 96,  0,  7, 64,130,  0, 36,128,  3,  0,  0, 40,  0,  0,  0,
/* 0x0270 */  64,130,  0, 24,232,  1,  1,136,232, 67,  0,  8,124, 66,  2, 20,
/* 0x0280 */ 232, 99,  0,  0,124, 99,  2, 20,248,117,  0,  0,124,127, 27,120,
/* 0x0290 */ 127, 35,203,120, 72,  0,  0,  1,232,153,  0,160,127, 35,203,120,
/* 0x02a0 */  72,  0,  0,  1, 65,146,  0, 48, 57,  0,  0,  0,127,103,219,120,
/* 0x02b0 */  44,  7,  0,  0, 65,128,  0, 32, 56,192,  0,  2, 56,160,  0,  1,
/* 0x02c0 */ 124,148,  0,208, 56, 96,  0,  0, 72,  0,  0,  1,127, 99,219,120,
/* 0x02d0 */  72,  0,  0,  1,232, 21,255,248,124,  9,  3,166,251,225,  1,128,
/* 0x02e0 */ 127,163,235,120,127,132,227,120, 56,  0,  0, 91,127,232,  3,166,
/* 0x02f0 */ 232,161,  0,176,232,193,  0,184,232,225,  0,192,233,  1,  0,200,
/* 0x0300 */ 233, 33,  0,208,233, 65,  0,216,233, 97,  0,224,233,129,  0,232,
/* 0x0310 */ 233,161,  0,240,233,193,  0,248,233,225,  1,  0,234,  1,  1,  8,
/* 0x0320 */ 234, 33,  1, 16,234, 65,  1, 24,234, 97,  1, 32,234,129,  1, 40,
/* 0x0330 */ 234,161,  1, 48,234,193,  1, 56,234,225,  1, 64,235,  1,  1, 72,
/* 0x0340 */ 235, 33,  1, 80,235, 65,  1, 88,235, 97,  1, 96,235,129,  1,104,
/* 0x0350 */ 235,161,  1,112,235,193,  1,120,235,225,  1,128, 56, 33,  1,144,
/* 0x0360 */  78,128,  4, 32,233,  3,  0,  8,233, 67,  0,  0,127,170, 40, 64,
/* 0x0370 */  65,220,  0, 40, 57, 37,255,255, 57, 72,255,255, 56,132,255,255,
/* 0x0380 */ 125, 40, 74, 20,125, 42, 72, 80,125, 41,  3,166, 47,165,  0,  0,
/* 0x0390 */  64,158,  0, 32, 72,  0,  0, 40,124,  8,  2,166,248,  1,  0, 16,
/* 0x03a0 */ 248, 33,255,145, 56, 96,  0,127, 72,  0,  0,  1, 96,  0,  0,  0,
/* 0x03b0 */ 141, 42,  0,  1,157, 36,  0,  1, 66,  0,255,248,233, 35,  0,  8,
/* 0x03c0 */ 125, 41, 42, 20,249, 35,  0,  8,233, 35,  0,  0,124,165, 72, 80,
/* 0x03d0 */ 248,163,  0,  0, 78,128,  0, 32,  0,  0,  0,  0,  0,  0,  0,  1,
/* 0x03e0 */ 128,  0,  0,  0, 44, 35,  0,  0, 77,130,  0, 32,120,105,  7,225,
/* 0x03f0 */  76,130,  0, 32, 57,  0,  0,  0, 56,192,  0,  0,233, 35,  0,  0,
/* 0x0400 */ 124,135, 35,120,127,169, 32, 64, 64,158,  0, 20,248,163,  0,  8,
/* 0x0410 */  57,  8,  0,  1,125,  8,  7,180, 72,  0,  0, 12, 43,169,  0,  1,
/* 0x0420 */  65,158,  0, 64, 47,169,  0,  0, 64,158,  0, 60, 47,168,  0,  0,
/* 0x0430 */  76,158,  0, 32, 47,166,  0,  0, 65,222,  0, 16,248,230,  0,  0,
/* 0x0440 */ 248,166,  0,  8, 78,128,  0, 32,124,  8,  2,166,248,  1,  0, 16,
/* 0x0450 */ 248, 33,255,145, 56, 96,  0,127, 72,  0,  0,  1, 96,  0,  0,  0,
/* 0x0460 */ 124,102, 27,120, 56, 99,  0, 16, 75,255,255,148,  0,  0,  0,  0,
/* 0x0470 */   0,  0,  0,  1,128,  0,  0,  0,233, 36,  0,  0, 47,169,  0,  0,
/* 0x0480 */  77,158,  0, 32,124,  8,  2,166,248,  1,  0, 16,251,193,255,240,
/* 0x0490 */ 251,225,255,248,248, 33,255, 97,124,159, 35,120,124,126, 27,120,
/* 0x04a0 */ 127,195,243,120, 56,129,  0,112, 56,160,  0, 12, 75,255,254,185,
/* 0x04b0 */ 129, 33,  0,112, 47,169,  0,  0, 64,158,  0, 40,129, 33,  0,116,
/* 0x04c0 */  61, 64, 33, 88, 97, 74, 80, 85,127,137, 80,  0, 64,222,  0, 32,
/* 0x04d0 */ 233, 62,  0,  0, 47,169,  0,  0, 65,254,  0,204, 72,  0,  0, 16,
/* 0x04e0 */ 128,161,  0,116, 47,165,  0,  0, 64,254,  0, 16, 56, 96,  0,127,
/* 0x04f0 */  72,  0,  0,  1, 96,  0,  0,  0,127,137, 40, 64, 65,220,255,240,
/* 0x0500 */ 233, 95,  0,  0,127,169, 80, 64, 65,221,255,228,127,137, 40, 64,
/* 0x0510 */  64,157,  0, 88,249, 33,  0,128,232,126,  0,  8, 56, 99,255,244,
/* 0x0520 */ 232,159,  0,  8, 56,161,  0,128, 72,  0,  0,  1, 96,  0,  0,  0,
/* 0x0530 */  47,163,  0,  0, 64,222,255,184,129, 33,  0,112,233, 65,  0,128,
/* 0x0540 */ 127,169, 80,  0, 64,222,255,168,129,  1,  0,116,233, 94,  0,  8,
/* 0x0550 */ 125, 74, 66, 20,249, 94,  0,  8,233, 62,  0,  0,125, 40, 72, 80,
/* 0x0560 */ 249, 62,  0,  0, 72,  0,  0, 28,233, 62,  0,  0, 57, 41,  0, 12,
/* 0x0570 */ 249, 62,  0,  0,127,195,243,120,232,159,  0,  8, 75,255,253,233,
/* 0x0580 */ 129,  1,  0,112,233, 95,  0,  8,125, 74, 66, 20,249, 95,  0,  8,
/* 0x0590 */ 233, 63,  0,  0,125, 40, 72, 80,249, 63,  0,  0, 47,169,  0,  0,
/* 0x05a0 */  64,158,255,  0, 56, 33,  0,160,232,  1,  0, 16,124,  8,  3,166,
/* 0x05b0 */ 235,193,255,240,235,225,255,248, 78,128,  0, 32,  0,  0,  0,  0,
/* 0x05c0 */   0,  0,  0,  1,128,  2,  0,  0,124,  8,  2,166,248,  1,  0, 16,
/* 0x05d0 */ 125,128,  0, 38,249,193,255,112,249,225,255,120,250,  1,255,128,
/* 0x05e0 */ 250, 33,255,136,250, 65,255,144,250, 97,255,152,250,129,255,160,
/* 0x05f0 */ 250,161,255,168,250,193,255,176,250,225,255,184,251,  1,255,192,
/* 0x0600 */ 251, 33,255,200,251, 65,255,208,251, 97,255,216,251,129,255,224,
/* 0x0610 */ 251,161,255,232,251,193,255,240,251,225,255,248,145,129,  0,  8,
/* 0x0620 */ 248, 33,254,193,124,122, 27,120,248,161,  1,128,124,211, 51,120,
/* 0x0630 */ 248,225,  1,144,235,227,  0, 32,127,227,250, 20,124,142, 35,121,
/* 0x0640 */  65,130,  0, 64,233,  7,  0,  0, 57, 72,  0, 64,234,202,  0, 72,
/* 0x0650 */ 161, 35,  0, 16, 47,137,  0,  2, 65,158,  0, 16,126,214, 64, 80,
/* 0x0660 */ 126,195,179,120, 72,  0,  0, 12,232,106,  0, 16, 58,192,  0,  0,
/* 0x0670 */ 232,138,  0, 40, 72,  0,  0,  1, 96,  0,  0,  0, 72,  0,  1,124,
/* 0x0680 */ 161, 35,  0, 16, 59,160,  0, 16, 47,137,  0,  3, 64,158,  0,  8,
/* 0x0690 */  59,160,  0,  0,163,218,  0, 56,127,220,  7,180, 72,  0,  0,  1,
/* 0x06a0 */  96,  0,  0,  0, 59,156,255,255, 47,156,  0,  0, 65,156,  0,136,
/* 0x06b0 */  57, 62,255,255,121, 41,  0, 32, 57, 41,  0,  1,121, 40, 31, 36,
/* 0x06c0 */ 121, 41, 54,100,125,  8, 72, 80,125, 31, 66, 20,127,233,251,120,
/* 0x06d0 */  59,192, 16,  0, 56,224,  0,  0, 59, 96,255,255,129, 73,  0,  0,
/* 0x06e0 */  47,138,  0,  1, 64,158,  0, 64,233, 73,  0, 40, 47,170,  0,  0,
/* 0x06f0 */  65,158,  0, 52,232,201,  0, 16,127,187, 48, 64, 64,157,  0,  8,
/* 0x0700 */ 124,219, 51,120,125, 70, 82, 20,127,167, 80, 64, 64,156,  0,  8,
/* 0x0710 */ 125, 71, 83,120,233, 73,  0, 48,127,190, 80, 64, 64,156,  0,  8,
/* 0x0720 */ 125, 94, 83,120, 57, 41,  0, 56,127,169, 64, 64, 64,158,255,176,
/* 0x0730 */  72,  0,  0, 16, 59,192, 16,  0, 56,224,  0,  0, 59, 96,255,255,
/* 0x0740 */ 125,  3,  0,208,127,123, 24, 56,124,105, 24,248,125, 41, 58, 20,
/* 0x0750 */ 125, 59, 72, 80,125, 57, 24, 56,127,168,240, 64, 64,156,  4,192,
/* 0x0760 */  57, 64,  0,  1,121, 74,  8, 40,125, 40, 81,210,127,169,240, 64,
/* 0x0770 */  65,156,255,244,123, 56,  0, 32, 57, 74,255,255,125, 74, 65,214,
/* 0x0780 */ 127,138,194, 20,123,151,  0, 32, 99,166,  0, 34,127, 99,219,120,
/* 0x0790 */ 126,228,187,120, 56,160,  0,  0,124,198,  7,180, 56,224,255,255,
/* 0x07a0 */  57,  0,  0,  0, 72,  0,  0,  1, 96,  0,  0,  0,124,117, 27,120,
/* 0x07b0 */ 124,118, 27,120,127,163,  0,208, 59,222,255,255,127,189,240, 57,
/* 0x07c0 */  65,130,  0, 28,127,164,235,120, 72,  0,  0,  1, 96,  0,  0,  0,
/* 0x07d0 */ 126,213,234, 20,127,221,224, 80,123,215,  0, 32,127, 24,184, 80,
/* 0x07e0 */ 123,  4,  0, 33, 65,130,  0, 16,124,118,202, 20, 72,  0,  0,  1,
/* 0x07f0 */  96,  0,  0,  0,126,219,176, 80, 72,  0,  0,  1, 96,  0,  0,  0,
/* 0x0800 */ 161, 58,  0, 56, 47,137,  0,  0, 64,157,  3,248, 59,192,  0,  0,
/* 0x0810 */  46, 46,  0,  0, 62,  0,115, 81, 98, 16, 98, 64,124,117, 24,248,
/* 0x0820 */  72,  0,  0, 21, 68,  0,  0,  2,127,236,251,120, 56,128,  0,  0,
/* 0x0830 */  78,128,  0, 32,124,168,  2,166,248,161,  0,144, 61,224,  0,  1,
/* 0x0840 */ 121,239,131,228, 97,239,  0,  1,122,104,  7,164,249,  1,  0,152,
/* 0x0850 */ 124, 99, 24,248,144, 97,  0,128,120,105,  0, 32,249, 33,  0,160,
/* 0x0860 */  72,  0,  0,  9,117,112,120,  0,125, 72,  2,166,249, 65,  0,168,
/* 0x0870 */  58,128,  0,  0, 72,  0,  0,  9,117,112,120,  0,124,168,  2,166,
/* 0x0880 */ 248,161,  0,136, 65,146,  0, 40,129, 63,  0,  0, 47,137,  0,  6,
/* 0x0890 */  64,158,  0, 28,232,191,  0, 16,126, 99,155,120, 56,128,  0,  3,
/* 0x08a0 */ 124,182, 42, 20, 75,255,251, 65, 72,  0,  3, 64,129, 63,  0,  0,
/* 0x08b0 */  47,137,  0,  1, 64,158,  3, 52,233, 63,  0, 40, 47,169,  0,  0,
/* 0x08c0 */  65,158,  3, 40,131,159,  0,  4, 87,156, 22,250,126, 28,228, 48,
/* 0x08d0 */  87,151,  7,126,122,241,  0, 32, 65,146,  0, 76,233, 63,  0,  8,
/* 0x08e0 */  47,169,  0,  0, 64,158,  0, 64,233, 58,  0, 32,125, 54, 74, 20,
/* 0x08f0 */ 232,191,  0, 16,126, 99,155,120, 56,128,  0,  3,124,169, 42, 20,
/* 0x0900 */  75,255,250,229,126, 99,155,120, 56,128,  0,  5,160,186,  0, 56,
/* 0x0910 */  75,255,250,213,126, 99,155,120, 56,128,  0,  4,160,186,  0, 54,
/* 0x0920 */  75,255,250,197,235,127,  0, 32,251, 97,  0,112,235,191,  0, 16,
/* 0x0930 */ 127,182,234, 20,251,161,  0,120,235, 31,  0, 40,127, 29,194, 20,
/* 0x0940 */ 127, 61,218, 20,127,170,168, 56,127,106,218, 20,127,170,232, 80,
/* 0x0950 */ 125, 61,218, 20,125, 41,  0,208,125, 41,168, 56,127,105,218, 20,
/* 0x0960 */  65,146,  0,144,129, 63,  0,  4,121, 40,  7,225, 65,130,  0, 80,
/* 0x0970 */ 232, 97,  0,136, 56,128,  0, 16, 72,  0,  0,  1, 96,  0,  0,  0,
/* 0x0980 */ 124,114, 27,120,127,100,219,120, 72,  0,  0,  1, 96,  0,  0,  0,
/* 0x0990 */ 127,163,235,120,127,100,219,120, 56,160,  0,  3, 56,192,  0, 17,
/* 0x09a0 */ 126, 71,147,120, 57,  0,  0,  0, 72,  0,  0,  1, 96,  0,  0,  0,
/* 0x09b0 */ 127,189, 24,  0, 65,254,  2,148, 72,  0,  1,244,123,133,  7,224,
/* 0x09c0 */ 127,163,235,120,127,100,219,120, 96,165,  0,  2, 56,192,  0, 50,
/* 0x09d0 */  56,224,255,255, 57,  0,  0,  0, 72,  0,  0,  1, 96,  0,  0,  0,
/* 0x09e0 */ 127,189, 24,  0, 64,222,  1,200, 58, 64,  0,  0, 72,  0,  2, 92,
/* 0x09f0 */ 233, 31,  0,  8,127,163,235,120,127,100,219,120,126,229,  7,180,
/* 0x0a00 */  56,192,  0, 18,232,225,  1,128,125, 10, 64, 80, 72,  0,  0,  1,
/* 0x0a10 */  96,  0,  0,  0,127,189, 24,  0, 64,222,  1,148,123,137,255,227,
/* 0x0a20 */  65,130,  1,104, 58, 64,  0,  0,125, 57,  0,208,129, 65,  0,128,
/* 0x0a30 */ 125, 41, 80, 56,121, 42,  0, 33, 65,130,  0, 20, 57, 57,255,255,
/* 0x0a40 */ 125, 73,  3,166,158,137,  0,  1, 66,  0,255,252,127, 57, 82, 20,
/* 0x0a50 */  65,210,  1, 56,129, 63,  0,  4,121, 37,  7,225, 65,130,  1, 44,
/* 0x0a60 */ 233, 65,  0,120, 57, 74,  0,  3,121, 74,  7,100,125, 92, 83,120,
/* 0x0a70 */ 233, 63,  0,  0,121, 41,  7,194,121, 41,  0,  2,127,169,120,  0,
/* 0x0a80 */  64,158,  0,148,125, 42,  0,208,233,  1,  0,160,125,  9, 72, 56,
/* 0x0a90 */  47,169,  0, 15, 64,157,  0, 44,233, 33,  0,144,128,201,  0,  0,
/* 0x0aa0 */ 128,233,  0,  4,129,  9,  0,  8,129, 41,  0, 12,144,202,  0,  0,
/* 0x0ab0 */ 144,234,  0,  4,145, 10,  0,  8,145, 42,  0, 12, 72,  0,  0, 88,
/* 0x0ac0 */ 232, 97,  0,168, 56,128,  0, 16, 72,  0,  0,  1, 96,  0,  0,  0,
/* 0x0ad0 */ 124,113, 27,120,232,129,  0,144, 56,160,  0, 16, 72,  0,  0,  1,
/* 0x0ae0 */  96,  0,  0,  0, 56, 96,  0,  0, 56,128,  0, 16, 56,160,  0,  5,
/* 0x0af0 */  56,192,  0,  1,126, 39,139,120, 57,  0,  0,  0, 72,  0,  0,  1,
/* 0x0b00 */  96,  0,  0,  0,124,124, 27,120,126, 35,139,120, 72,  0,  0,  1,
/* 0x0b10 */  96,  0,  0,  0, 47,188,  0,  0, 65,158,  0, 20,232, 97,  0,152,
/* 0x0b20 */  56,128,  0,  0,127,133,227,120, 75,255,248,189,127,163,235,120,
/* 0x0b30 */ 127,100,219,120, 56,160,  0,  4, 72,  0,  0,  1, 96,  0,  0,  0,
/* 0x0b40 */ 127,163,235,120,127,100,219,120, 72,  0,  0,  1, 96,  0,  0,  0,
/* 0x0b50 */ 127,163,235,120,127,100,219,120,126,229,  7,180, 56,192,  0, 17,
/* 0x0b60 */ 126, 71,147,120, 57,  0,  0,  0, 72,  0,  0,  1, 96,  0,  0,  0,
/* 0x0b70 */ 127,189, 24,  0, 64,222,  0, 56,126, 67,147,120, 72,  0,  0,  1,
/* 0x0b80 */  96,  0,  0,  0, 72,  0,  0, 52, 43,151,  0,  3, 65,158,  0, 44,
/* 0x0b90 */ 127,163,235,120,127,100,219,120,126, 37,139,120, 72,  0,  0,  1,
/* 0x0ba0 */  96,  0,  0,  0, 47,163,  0,  0, 65,254,  0, 16, 56, 96,  0,127,
/* 0x0bb0 */  72,  0,  0,  1, 96,  0,  0,  0,127,184,200, 64, 64,157,  0, 44,
/* 0x0bc0 */ 127, 35,203,120,124,153,192, 80,126,229,  7,180, 56,192,  0, 50,
/* 0x0bd0 */  56,224,255,255, 57,  0,  0,  0, 72,  0,  0,  1, 96,  0,  0,  0,
/* 0x0be0 */ 127,185, 24,  0, 64,222,255,200, 59,255,  0, 56, 57, 94,  0,  1,
/* 0x0bf0 */ 125, 94,  7,180,161, 58,  0, 56,127,137, 80,  0, 65,157,252,136,
/* 0x0c00 */ 233, 65,  1,144, 47,170,  0,  0, 65,158,  0,  8,250,202,  0,  0,
/* 0x0c10 */ 232,122,  0, 24,124,118, 26, 20, 72,  0,  0, 72, 99,166,  0, 34,
/* 0x0c20 */ 127, 99,219,120,123, 36,  0, 32, 56,160,  0,  0,124,198,  7,180,
/* 0x0c30 */  56,224,255,255, 57,  0,  0,  0, 72,  0,  0,  1, 96,  0,  0,  0,
/* 0x0c40 */ 124,118, 27,120, 75,255,251,176,125,195,115,120, 56,129,  0,112,
/* 0x0c50 */  75,255,248, 41,123,133,255,227, 65,130,253,252, 75,255,253,204,
/* 0x0c60 */  56, 33,  1, 64,232,  1,  0, 16,129,129,  0,  8,124,  8,  3,166,
/* 0x0c70 */ 233,193,255,112,233,225,255,120,234,  1,255,128,234, 33,255,136,
/* 0x0c80 */ 234, 65,255,144,234, 97,255,152,234,129,255,160,234,161,255,168,
/* 0x0c90 */ 234,193,255,176,234,225,255,184,235,  1,255,192,235, 33,255,200,
/* 0x0ca0 */ 235, 65,255,208,235, 97,255,216,235,129,255,224,235,161,255,232,
/* 0x0cb0 */ 235,193,255,240,235,225,255,248,125,144,129, 32, 78,128,  0, 32,
/* 0x0cc0 */   0,  0,  0,  0,  0,  0,  0,  3,128, 18,  0,  0,124,  8,  2,166,
/* 0x0cd0 */ 248,  1,  0, 16,251,161,255,232,251,193,255,240,251,225,255,248,
/* 0x0ce0 */ 248, 33,239,113,124,125, 27,120,124,159, 35,120,124,190, 43,120,
/* 0x0cf0 */  56, 97,  0,112, 72,  0,  0,  1, 96,  0,  0,  0,127,227,251,120,
/* 0x0d00 */ 127,164,235,120, 56,160,  0,  3, 56,192,  0, 50, 56,224,255,255,
/* 0x0d10 */  57,  0,  0,  0, 72,  0,  0,  1, 96,  0,  0,  0,127,227,251,120,
/* 0x0d20 */  56,129,  0,112,127,197,243,120, 72,  0,  0,  1, 96,  0,  0,  0,
/* 0x0d30 */  56, 33, 16,144,232,  1,  0, 16,124,  8,  3,166,235,161,255,232,
/* 0x0d40 */ 235,193,255,240,235,225,255,248, 78,128,  0, 32,  0,  0,  0,  0,
/* 0x0d50 */   0,  0,  0,  1,128,  3,  0,  0,124,  8,  2,166,248,  1,  0, 16,
/* 0x0d60 */ 251, 33,255,200,251, 65,255,208,251, 97,255,216,251,129,255,224,
/* 0x0d70 */ 251,161,255,232,251,193,255,240,251,225,255,248,248, 33,255, 33,
/* 0x0d80 */ 124,189, 43,120,124,217, 51,120,124,251, 59,120,248,161,  0,120,
/* 0x0d90 */ 129, 35,  0,  0,249, 33,  0,112,248, 97,  0,152,129, 35,  0,  4,
/* 0x0da0 */  57, 41,  0, 12,249, 33,  0,144,248, 97,  0,136,248,129,  0,128,
/* 0x0db0 */  56, 97,  0,144, 56,129,  0,112, 75,255,246,193, 72,  0,  0,  1,
/* 0x0dc0 */  96,  0,  0,  0,127,163,235,120, 56,129,  0,128, 56,160,  0,  0,
/* 0x0dd0 */ 127, 38,203,120,127,103,219,120, 75,255,247,241,124,122, 27,120,
/* 0x0de0 */ 127, 35,203,120, 56,128,  0,  9,127, 69,211,120, 75,255,245,249,
/* 0x0df0 */  59,253,  0, 64,161, 61,  0, 56, 47,137,  0,  0, 65,158,  0,184,
/* 0x0e00 */  59,192,  0,  0,129, 63,  0,  0, 47,137,  0,  3, 64,158,  0,144,
/* 0x0e10 */ 233, 95,  0, 16,232,123,  0,  0,124,106, 26, 20, 56,128,  0,  0,
/* 0x0e20 */  56,160,  0,  0, 72,  0,  0,  1, 96,  0,  0,  0,124,124, 27,120,
/* 0x0e30 */  47,131,  0,  0, 65,220,  0, 28,127,164,235,120, 56,160,  4,  0,
/* 0x0e40 */  72,  0,  0,  1, 96,  0,  0,  0, 47,163,  4,  0, 65,254,  0, 16,
/* 0x0e50 */  56, 96,  0,127, 72,  0,  0,  1, 96,  0,  0,  0, 57, 32,  0,  0,
/* 0x0e60 */ 249, 59,  0,  0,127,163,235,120, 56,128,  0,  0,127,133,227,120,
/* 0x0e70 */  56,192,  0,  0,127,103,219,120, 75,255,247, 81,124,122, 27,120,
/* 0x0e80 */ 127, 35,203,120, 56,128,  0,  7,232,187,  0,  0, 75,255,245, 89,
/* 0x0e90 */ 127,131,227,120, 72,  0,  0,  1, 96,  0,  0,  0, 59,255,  0, 56,
/* 0x0ea0 */  57, 94,  0,  1,121, 94,  0, 32,161, 61,  0, 56,127,137, 80, 64,
/* 0x0eb0 */  65,157,255, 84,127, 67,211,120, 56, 33,  0,224,232,  1,  0, 16,
/* 0x0ec0 */ 124,  8,  3,166,235, 33,255,200,235, 65,255,208,235, 97,255,216,
/* 0x0ed0 */ 235,129,255,224,235,161,255,232,235,193,255,240,235,225,255,248,
/* 0x0ee0 */  78,128,  0, 32,  0,  0,  0,  0,  0,  0,  0,  1,128,  7,  0,  0,
/* 0x0ef0 */  56,  0,  9,153,124,128,  0,  8,120,231,  0, 32, 56,  0,  0, 90,
/* 0x0f00 */  68,  0,  0,  2, 64,227,  0,  8, 56, 96,255,255, 78,128,  0, 32,
/* 0x0f10 */  56,  0,  0, 91, 72,  0,  0,  8, 56,  0,  0,125, 72,  0,  0,  8,
/* 0x0f20 */  56,  0,  0,144, 72,  0,  0,  8, 56,  0,  0, 93, 72,  0,  0,  8,
/* 0x0f30 */  56,  0,  0,  1, 72,  0,  0,  8, 56,  0,  0, 45, 72,  0,  0,  8,
/* 0x0f40 */  56,  0,  0, 85, 72,  0,  0,  8, 56,  0,  0,  4, 72,  0,  0,  8,
/* 0x0f50 */  56,  0,  0,  3, 72,  0,  0,  8, 56,  0,  0,  5, 72,  0,  0,  8,
/* 0x0f60 */  56,  0,  0,  6, 75,255,255,156, 56,  0,  1,104, 68,  0,  0,  2,
/* 0x0f70 */  64,227,  0, 76, 44,  5,  0,  0, 65,130,  0, 12, 56,160,  0,  0,
/* 0x0f80 */  75,255,255,232,124,200,  2,166, 72,  0,  0, 17, 47,100,101,118,
/* 0x0f90 */  47,115,104,109,  0,  0,  0,  0,124,136,  2,166,124,200,  3,166,
/* 0x0fa0 */  56,160,  1,192, 60,192,  0, 65, 96,198,  0,  2, 56,  0,  0,  5,
/* 0x0fb0 */  68,  0,  0,  2, 64,227,  0,  8,124,128,  0,  8, 78,128,  0, 32,
/* 0x0fc0 */ 124,200,  2,166, 56,128,  0, 16, 72,  0,  0,  9,117,112,120,  0,
/* 0x0fd0 */ 124,104,  2,166, 56,  0,  1,104, 68,  0,  0,  2, 64,227,  0, 32,
/* 0x0fe0 */  47,132,  0,  0, 64,158,  0,  8,124,128,  0,  8, 47,131,  0, 22,
/* 0x0ff0 */  64,158,255,248, 56,128,  0,  0, 75,255,255,208,124,200,  3,166,
/* 0x1000 */  78,128,  0, 32, 44,  5,  0,  0, 65,194,  0, 28,124,169,  3,166,
/* 0x1010 */  56,195,255,255, 56,132,255,255,140,  4,  0,  1,156,  6,  0,  1,
/* 0x1020 */  66,  0,255,248, 78,128,  0, 32,124,128,  0,  8, 78,128,  0, 32,
/* 0x1030 */ 124,  8,  2,166,248, 97,255,225,248,129,  0,  8,248,161,  0, 16,
/* 0x1040 */ 248,  1,  0, 24,136,227,  0,  8,124,166, 43,120,124,133, 35,120,
/* 0x1050 */ 128,131,  0,  4, 56, 99,  0, 12, 72,  0,  0,129,124,102, 27,120,
/* 0x1060 */ 232,161,  0,  0,232, 97,  0,  8,232,129,  0, 16, 56, 33,  0, 24,
/* 0x1070 */ 232,132,  0,  0,248, 97,255,233,248,129,  0,  8,248,193,  0, 16,
/* 0x1080 */ 136,197,  0,  9,136,165,  0, 10, 44,  6,  0,  0, 65,130,  0,  8,
/* 0x1090 */  72,  0,  0,  1,232, 97,  0,  0,232,129,  0,  8, 56, 33,  0, 16,
/* 0x10a0 */ 124,132, 26, 20, 96, 99,  0, 31,124,  0, 24,108,124,  3, 32, 64,
/* 0x10b0 */ 124,  0, 31,172, 56, 99,  0, 32, 65,128,255,240,124,  0,  4,172,
/* 0x10c0 */  76,  0,  1, 44,232, 97,  0,  0,232,  1,  0,  8, 56, 33,  0, 16,
/* 0x10d0 */ 124,  8,  3,166, 78,128,  0, 32,124,227, 59,120,124,131, 24,  8,
/* 0x10e0 */ 232,230,  0,  0,125,168,  3,166,124,100, 24, 80,124,135, 40, 80,
/* 0x10f0 */  56, 99,  0,  1, 56,132,  0,  1,248,134,  0,  0, 78,128,  0, 32,
/* 0x1100 */  40,  6,  0,208, 76,194,  0, 32, 84,132,240,191, 77,194,  0, 32,
/* 0x1110 */  60,  0,  0, 16,124,  4,  0, 64, 65,128,  0,  8,124,  4,  3,120,
/* 0x1120 */  56,165,  1, 32,124,103, 27,120, 56, 99,255,252,124,137,  3,166,
/* 0x1130 */  72,  0,  0, 28, 84, 11,  2,186,125, 99, 88, 80,125,107, 58, 20,
/* 0x1140 */  81, 96,  1,186,144,  3,  0,  0, 79, 64,  0, 32,132,  3,  0,  4,
/* 0x1150 */  84, 11, 85,190,124, 11, 40, 64, 65,194,255,220, 67, 32,255,240,
/* 0x1160 */  78,128,  0, 32, 44,  7,  0,  8, 64,130,  1, 88,124,  0, 41,236,
/* 0x1170 */ 125,168,  2,166, 40,  7,  0,  8, 64,130,  1, 72,248,166,  0,  0,
/* 0x1180 */ 124,132, 26, 20, 60,  0,128,  0,120,  0,  7,198,124,  9,  3,120,
/* 0x1190 */  56, 99,255,255, 56,165,255,255, 57, 64,255,255, 72,  0,  1, 20,
/* 0x11a0 */  57, 32,  0,  1,125, 41, 28, 44, 56, 99,  0,  4,125, 41, 73, 20,
/* 0x11b0 */ 121, 41,248, 36,124, 41,  0, 64,125, 41, 72, 20, 78,128,  0, 32,
/* 0x11c0 */ 141,  3,  0,  1,157,  5,  0,  1,124, 41,  0, 64,125, 41, 72, 20,
/* 0x11d0 */  65,194,255,209, 65,225,255,236, 56,224,  0,  1, 72,  0,  0, 20,
/* 0x11e0 */  56,231,255,255,125, 41, 72, 21, 65,194,255,185,124,231, 57, 20,
/* 0x11f0 */ 125, 41, 72, 21, 65,194,255,173,124,231, 57, 20,124, 41,  0, 64,
/* 0x1200 */ 125, 41, 72, 20, 65,194,255,157, 65,192,255,216, 52,231,255,253,
/* 0x1210 */  57,  0,  0,  0, 65,192,  0, 40,141, 99,  0,  1,120,231, 69,198,
/* 0x1220 */ 124,231,  6,118,124,234, 88,249,125, 74, 14,116, 65,194,  0,  0,
/* 0x1230 */ 113,107,  0,  1, 65,226,  0, 80, 72,  0,  0, 20,124, 41,  0, 64,
/* 0x1240 */ 125, 41, 72, 20, 65,194,255, 93, 65,225,  0, 60, 57,  0,  0,  1,
/* 0x1250 */ 124, 41,  0, 64,125, 41, 72, 20, 65,194,255, 73, 65,225,  0, 40,
/* 0x1260 */ 125, 41, 72, 21, 65,194,255, 61,125,  8, 65, 20,124, 41,  0, 64,
/* 0x1270 */ 125, 41, 72, 20, 65,194,255, 45, 65,192,255,232, 57,  8,  0,  2,
/* 0x1280 */  72,  0,  0, 16,125, 41, 72, 21, 65,194,255, 25,125,  8, 65, 20,
/* 0x1290 */  33,106,250,255, 57,  8,  0,  2,125,  8,  1,148,124,234, 42, 20,
/* 0x12a0 */ 125,  9,  3,166,141,103,  0,  1,157,101,  0,  1, 67, 32,255,248,
/* 0x12b0 */  56,224,  1,  0,124,  7, 41,236,124,  7, 26, 44, 75,255,255, 12,
/* 0x12c0 */  44,  7,  0,  5, 64,130,  1, 64,124,  0, 41,236,125,168,  2,166,
/* 0x12d0 */  40,  7,  0,  5, 64,130,  1, 48,248,166,  0,  0,124,132, 26, 20,
/* 0x12e0 */  60,  0,128,  0,120,  0,  7,198, 61, 32,128,  0,121, 41,  7,198,
/* 0x12f0 */  56, 99,255,255, 56,165,255,255, 57, 64,255,255, 72,  0,  0,248,
/* 0x1300 */  57, 32,  0,  1,125, 41, 28, 44, 56, 99,  0,  4,125, 41, 73, 20,
/* 0x1310 */ 121, 41,248, 36,124, 41,  0, 64,125, 41, 72, 20, 78,128,  0, 32,
/* 0x1320 */ 141,  3,  0,  1,157,  5,  0,  1,124, 41,  0, 64,125, 41, 72, 20,
/* 0x1330 */  65,194,255,209, 65,225,255,236, 56,224,  0,  1, 72,  0,  0, 20,
/* 0x1340 */  56,231,255,255,125, 41, 72, 21, 65,194,255,185,124,231, 57, 21,
/* 0x1350 */ 125, 41, 72, 21, 65,194,255,173,124,231, 57, 21,124, 41,  0, 64,
/* 0x1360 */ 125, 41, 72, 20, 65,194,255,157, 65,192,255,216, 57,  0,  0,  0,
/* 0x1370 */  52,231,255,253, 84,231, 64, 46, 65,192,  0, 28,141, 99,  0,  1,
/* 0x1380 */ 124,234, 88,249,125, 74, 14,112, 44, 42,  0,  0, 65,194,  0,  0,
/* 0x1390 */  72,  0,  0, 12,125, 41, 72, 21, 65,194,255,105,125,  8, 65, 21,
/* 0x13a0 */ 125, 41, 72, 21, 65,194,255, 93,125,  8, 65, 21, 64,130,  0, 40,
/* 0x13b0 */  57,  0,  0,  1,125, 41, 72, 21, 65,194,255, 73,125,  8, 65, 21,
/* 0x13c0 */ 124, 41,  0, 64,125, 41, 72, 20, 65,194,255, 57, 65,192,255,232,
/* 0x13d0 */  57,  8,  0,  2, 32,234,250,255, 57,  8,  0,  1,125,  8,  1,148,
/* 0x13e0 */ 124,234, 42, 20,125,  9,  3,166,141,  7,  0,  1,157,  5,  0,  1,
/* 0x13f0 */  67, 32,255,248, 56,224,  1,  0,124,  7, 41,236,124,  7, 26, 44,
/* 0x1400 */  75,255,255, 40, 44,  7,  0,  2, 64,130,  0,252,124,  0, 41,236,
/* 0x1410 */ 125,168,  2,166, 40,  7,  0,  2, 64,130,  0,236,248,166,  0,  0,
/* 0x1420 */ 124,132, 26, 20, 60,  0,128,  0,120,  0,  7,198,124,  9,  3,120,
/* 0x1430 */  56, 99,255,255, 56,165,255,255, 57, 64,255,255, 72,  0,  0,184,
/* 0x1440 */ 125, 41, 73, 20,121, 41,248, 36,124, 41,  0, 64,125, 41, 72, 20,
/* 0x1450 */  76,226,  0, 32, 57, 32,  0,  1,125, 41, 28, 44, 56, 99,  0,  4,
/* 0x1460 */  75,255,255,224,141,  3,  0,  1,157,  5,  0,  1, 75,255,255,221,
/* 0x1470 */  65,225,255,244, 56,224,  0,  1, 75,255,255,209,124,231, 57, 21,
/* 0x1480 */  75,255,255,201, 65,192,255,244, 52,231,255,253, 57,  0,  0,  0,
/* 0x1490 */  65,192,  0, 24,141, 99,  0,  1, 84,231, 64, 46,124,234, 88,248,
/* 0x14a0 */  85, 75,  0, 63, 65,194,  0,  0, 75,255,255,161,125,  8, 65, 21,
/* 0x14b0 */  75,255,255,153,125,  8, 65, 21, 56,224,  0,  1, 64,194,  0, 28,
/* 0x14c0 */  56,224,  0,  3, 57,  0,  0,  1, 75,255,255,129,125,  8, 65, 21,
/* 0x14d0 */  75,255,255,121, 65,192,255,244, 33,106,242,255,125,  8, 57, 20,
/* 0x14e0 */ 124,234, 42, 20,125,  9,  3,166,141,  7,  0,  1,157,  5,  0,  1,
/* 0x14f0 */  67, 32,255,248, 56,224,  1,  0,124,  7, 41,236,124,  7, 26, 44,
/* 0x1500 */  75,255,255,108, 44,  7,  0, 14, 64,130,  0,  0,124, 42, 11,120,
/* 0x1510 */  57, 38,  0,  4,129,  6,  0,  4,124,167, 43,120, 56,164,255,254,
/* 0x1520 */  56,131,  0,  2,137,131,  0,  0,121,139,232,194,121,140,  7, 96,
/* 0x1530 */  56, 96,250,  0,124, 99, 88, 54, 56, 99,241,100,124, 33, 26, 20,
/* 0x1540 */ 120, 33,  6,100, 56,  0,  0,  0,125, 67, 83,120,144,  9,  0,  0,
/* 0x1550 */ 248,  3,255,249,124, 33, 24, 64, 65,128,255,248,136,  4,255,255,
/* 0x1560 */  56,193,  0, 36, 56, 97,  0, 40,153,131,  0,  2,248,225,  0, 16,
/* 0x1570 */ 249, 33,  0, 24,120, 11,225,  2,120,  0,  7, 32,153, 99,  0,  1,
/* 0x1580 */ 152,  3,  0,  0,249, 65,255,145,124,  8,  2,166,248,  1,  0, 16,
/* 0x1590 */  72,  0,  0, 21,232,  1,  0, 16,232, 33,  0,  0,124,  8,  3,166,
/* 0x15a0 */  78,128,  0, 32, 56, 33,  0,112,232,161,  0, 24,232,225,  0, 16,
/* 0x15b0 */ 128,165,  0,  0,232, 33,  0,  0,124,165, 58, 20,232,  1,  0, 16,
/* 0x15c0 */  56,165,255,255,124,  8,  3,166,232, 33,  0,  0, 78,128,  0, 32,
/* 0x15d0 */  78,128,  0, 32,124,  8,  2,166, 57, 64,  0,  1, 72,  0,  0,  1,
/* 0x15e0 */  59, 99,  0,  4, 59,227,  0,  2, 56,  0,  4,  0,137, 99,  0,  2,
/* 0x15f0 */ 125, 75, 88, 48, 57,107,255,255,121,107,  0, 32,249, 97,255, 96,
/* 0x1600 */ 137, 99,  0,  1,125, 74, 88, 48, 57, 96,  0,  0, 57, 74,255,255,
/* 0x1610 */ 121, 74,  0, 32,249, 65,255,104,137, 67,  0,  0,145,102,  0,  0,
/* 0x1620 */ 145,105,  0,  0,125, 85,  7,180,137, 99,  0,  1,125, 75, 82, 20,
/* 0x1630 */  57, 96,  3,  0,125,106, 80, 48, 57, 74,  7, 54,121, 74,  0, 32,
/* 0x1640 */  47,138,  0,  0, 57,106,  0,  1, 64,254,  0,  8, 57, 96,  0,  1,
/* 0x1650 */  53,107,255,255, 65,130,  0, 12,180, 31,  0,  2, 75,255,255,244,
/* 0x1660 */  56,  0,  0,  5,124,164, 42, 20,124,  9,  3,166, 57,100,  0,  5,
/* 0x1670 */ 124,159, 35,120, 57, 64,  0,  0,127,191, 40, 64, 64,158,  0, 12,
/* 0x1680 */  56, 96,  0,  1, 72,  0, 10, 88, 59,255,  0,  1,136, 31,255,255,
/* 0x1690 */  85, 74, 64, 46,124, 10, 83,120,121, 74,  0, 32, 66,  0,255,220,
/* 0x16a0 */  56,  0,255,255, 63, 32,  0,255,120,  0,  0, 32, 58,192,  0,  1,
/* 0x16b0 */  59,  0,  0,  1, 58,224,  0,  1, 58, 64,  0,  1, 57,128,  0,  0,
/* 0x16c0 */  59,192,  0,  0, 59, 64,  0,  0, 99, 57,255,255, 58,128,  0,  1,
/* 0x16d0 */  34,117,  0,  8,127,154, 64, 64, 64,156,  9,216,235,161,255, 96,
/* 0x16e0 */ 127,128,200, 64,127, 95,232, 56, 85,157, 32, 54,127,252,  7,180,
/* 0x16f0 */ 127,189,  7,180,127,188,234, 20,123,189, 15,164, 65,157,  0, 36,
/* 0x1700 */ 127,171, 40, 64, 65,158,255,124,139,139,  0,  0, 85, 74, 64, 46,
/* 0x1710 */ 120,  0, 64, 40, 57,107,  0,  1,127,138, 83,120,121, 74,  0, 32,
/* 0x1720 */ 125,251,234, 46, 84, 16,170,254,126, 16,121,214,127,138,128, 64,
/* 0x1730 */ 122, 28,  0, 32, 64,156,  1,228, 32, 15,  8,  0,235,225,255,104,
/* 0x1740 */ 127,222,158, 48,124,  0, 46,112,125,224,122, 20,127, 64,248, 56,
/* 0x1750 */ 125,251,235, 46,124, 29,168, 48, 47,140,  0,  6,127,190,234, 20,
/* 0x1760 */  31,189,  3,  0,123,189,  0, 32, 59,189,  7, 54,123,189, 15,164,
/* 0x1770 */ 127,187,234, 20, 65,157,  0, 16, 59,192,  0,  1,127,128,227,120,
/* 0x1780 */  72,  0,  1, 12,124, 18,208, 80, 59,192,  0,  1,120,  0,  0, 32,
/* 0x1790 */ 125,231,  0,174, 85,255,  8, 60,127,239,  7,180, 87,255,  5,238,
/* 0x17a0 */ 127,156,200, 64,127,255,  7,180, 58, 63,  1,  0,126, 49,242, 20,
/* 0x17b0 */ 122, 49, 15,164, 65,157,  0, 36,127,171, 40, 64, 65,158,254,196,
/* 0x17c0 */ 136, 11,  0,  0, 85, 74, 64, 46,123,156, 64, 40, 57,107,  0,  1,
/* 0x17d0 */ 124, 10, 83,120,121, 74,  0, 32,126, 29,138, 46, 87,128,170,254,
/* 0x17e0 */  87,222,  8, 60,124,  0,129,214,127, 10,  0, 64,120, 14,  0, 32,
/* 0x17f0 */  47,191,  0,  0, 64,152,  0, 36, 32, 16,  8,  0,127,222,  7,180,
/* 0x1800 */ 124,  0, 46,112,126,  0,130, 20,125,220,115,120,126, 29,139, 46,
/* 0x1810 */  65,158,  0, 48, 75,255,255,104,127,128,224, 80,125, 64, 80, 80,
/* 0x1820 */  86,  0,217,126,126,  0,128, 80, 59,222,  0,  1,123,156,  0, 32,
/* 0x1830 */ 121, 74,  0, 32,126, 29,139, 46,127,222,  7,180, 65,158,255, 64,
/* 0x1840 */  47,158,  0,255, 64,157,255, 80, 75,255,255, 52,127,128,200, 64,
/* 0x1850 */ 123,208, 15,164, 64,157,  0, 68,127,157,130, 46, 84, 31,170,254,
/* 0x1860 */  87,222,  8, 60,127,255,225,214,127,138,248, 64,123,241,  0, 32,
/* 0x1870 */  64,156,  0, 76, 32, 28,  8,  0,127,222,  7,180,124,  0, 46,112,
/* 0x1880 */ 127,128,226, 20,127,157,131, 46,126, 32,139,120, 47,158,  0,255,
/* 0x1890 */  64,157,255,188, 72,  0,  0, 80,127,171, 40, 64, 65,158,253,228,
/* 0x18a0 */ 139,235,  0,  0, 85, 74, 64, 46,120,  0, 64, 40, 57,107,  0,  1,
/* 0x18b0 */ 127,234, 83,120,121, 74,  0, 32, 75,255,255,160,124, 31,  0, 80,
/* 0x18c0 */ 125, 95, 80, 80, 87,159,217,126,127,159,224, 80, 59,222,  0,  1,
/* 0x18d0 */ 121, 74,  0, 32,127,157,131, 46,127,222,  7,180,120, 17,  0, 32,
/* 0x18e0 */  75,255,255,168,123,222,  6, 32, 59,250,  0,  1, 47,140,  0,  3,
/* 0x18f0 */ 123,255,  0, 32,127,199,209,174, 64,157,  7,172, 47,140,  0,  9,
/* 0x1900 */  65,157,  0, 12, 57,140,255,253, 72,  0,  0,  8, 57,140,255,250,
/* 0x1910 */ 125,140,  7,180, 72,  0,  7,148,124, 16,  0, 80, 85,254,217,126,
/* 0x1920 */ 126, 16, 80, 80,125,254,120, 80, 59,140,  0,192,127,128,200, 64,
/* 0x1930 */ 125,251,235, 46,120, 17,  0, 32,122, 10,  0, 32,123,156, 15,164,
/* 0x1940 */  65,157,  0, 36,127,171, 40, 64, 65,158,253, 56,137, 75,  0,  0,
/* 0x1950 */  86, 16, 64, 46,120, 17, 64, 40, 57,107,  0,  1,125, 74,131,120,
/* 0x1960 */ 121, 74,  0, 32,126, 27,226, 46, 86, 32,170,254,124,  0,129,214,
/* 0x1970 */ 127,138,  0, 64,120, 30,  0, 32, 64,156,  0, 68, 47,140,  0,  7,
/* 0x1980 */  32, 16,  8,  0,125,144, 16, 38, 85,140,239,254,124,  0, 46,112,
/* 0x1990 */ 126,  0,130, 20,127, 22,195,120,125,140,  0,208,126,248,187,120,
/* 0x19a0 */ 126, 27,227, 46,121,140,240, 66, 59,163,  6,104,121,140, 16,  0,
/* 0x19b0 */ 126, 87,147,120, 57,140,  0,  3, 72,  0,  2,124,127,192,136, 80,
/* 0x19c0 */  86, 15,217,126,126, 15,128, 80,124,  0, 80, 80,127,158,200, 64,
/* 0x19d0 */ 126, 27,227, 46,123,209,  0, 32,120, 10,  0, 32, 58, 28,  0, 24,
/* 0x19e0 */  65,157,  0, 36,127,171, 40, 64, 65,158,252,152,137, 75,  0,  0,
/* 0x19f0 */  84,  0, 64, 46,123,209, 64, 40, 57,107,  0,  1,125, 74,  3,120,
/* 0x1a00 */ 121, 74,  0, 32,125,251,130, 46, 86, 32,170,254,124,  0,121,214,
/* 0x1a10 */ 127,138,  0, 64,120, 30,  0, 32, 64,156,  0,208, 35,143,  8,  0,
/* 0x1a20 */ 127,128,200, 64,127,156, 46,112,125,252,122, 20, 59,189,  1,224,
/* 0x1a30 */ 125,251,131, 46, 65,157,  0, 36,127,171, 40, 64, 65,158,252, 68,
/* 0x1a40 */ 120, 30, 64, 40,136, 11,  0,  0, 85, 74, 64, 46, 57,107,  0,  1,
/* 0x1a50 */ 124, 10, 83,120,121, 74,  0, 32,126, 59,234, 46, 87,220,170,254,
/* 0x1a60 */ 127,156,137,214,127,138,224, 64,123,128,  0, 32, 64,156,  0, 80,
/* 0x1a70 */  35,241,  8,  0, 47,186,  0,  0,127,255, 46,112,126, 63,138, 20,
/* 0x1a80 */ 126, 59,235, 46, 65,158,251,252, 47,140,  0,  7,127,242,208, 80,
/* 0x1a90 */ 125,144, 16, 38, 85,140,239,254,123,255,  0, 32,125,140,  0,208,
/* 0x1aa0 */ 127,199,248,174,121,140,  7,164, 59,250,  0,  1, 57,140,  0, 11,
/* 0x1ab0 */ 123,255,  0, 32,127,199,209,174, 72,  0,  5,240, 86, 32,217,126,
/* 0x1ac0 */ 124,  0,136, 80,127,220,240, 80,125, 92, 80, 80,124, 27,235, 46,
/* 0x1ad0 */ 123,222,  0, 32,127,  0,195,120,121, 74,  0, 32,126, 88,147,120,
/* 0x1ae0 */ 126,242,187,120, 72,  0,  0,124,126, 32,136, 80, 85,254,217,126,
/* 0x1af0 */ 124,  0, 80, 80,125,254,120, 80,127,145,200, 64,125,251,131, 46,
/* 0x1b00 */ 122, 61,  0, 32,120, 10,  0, 32, 58, 28,  0, 48, 65,157,  0, 36,
/* 0x1b10 */ 127,171, 40, 64, 65,158,251,108,137, 75,  0,  0, 84,  0, 64, 46,
/* 0x1b20 */ 122, 61, 64, 40, 57,107,  0,  1,125, 74,  3,120,121, 74,  0, 32,
/* 0x1b30 */ 126, 59,130, 46, 87,160,170,254,124,  0,137,214,127,138,  0, 64,
/* 0x1b40 */ 120, 30,  0, 32, 64,156,  0, 36, 32, 17,  8,  0,124,  0, 46,112,
/* 0x1b50 */ 126, 32,138, 20,127,  0,195,120,126, 59,131, 46,126,248,187,120,
/* 0x1b60 */ 124, 23,  3,120, 72,  0,  0,160,127,160,232, 80, 86, 62,217,126,
/* 0x1b70 */ 124,  0, 80, 80,126, 62,136, 80,127,157,200, 64,123,175,  0, 32,
/* 0x1b80 */ 126, 59,131, 46,120, 10,  0, 32, 59,156,  0, 72, 65,157,  0, 36,
/* 0x1b90 */ 127,171, 40, 64, 65,158,250,236,137, 75,  0,  0, 84,  0, 64, 46,
/* 0x1ba0 */ 123,175, 64, 40, 57,107,  0,  1,125, 74,  3,120,121, 74,  0, 32,
/* 0x1bb0 */ 127,187,226, 46, 85,224,170,254,124,  0,233,214,127,138,  0, 64,
/* 0x1bc0 */ 120, 30,  0, 32, 64,156,  0, 24, 32, 29,  8,  0,124,  0, 46,112,
/* 0x1bd0 */ 124,  0,234, 20,124, 27,227, 46, 72,  0,  0, 44,127,192,120, 80,
/* 0x1be0 */ 125, 64, 80, 80, 87,160,217,126,124,  0,232, 80,121, 74,  0, 32,
/* 0x1bf0 */ 124, 27,227, 46,127,  0,195,120,123,222,  0, 32,126,216,179,120,
/* 0x1c00 */ 124, 22,  3,120, 47,140,  0,  7,126, 64,147,120,125,144, 16, 38,
/* 0x1c10 */  85,140,239,254,127, 18,195,120, 59,163, 10,108,126,248,187,120,
/* 0x1c20 */ 124, 23,  3,120,125,140,  0,208,121,140,240, 66,121,140, 16,  0,
/* 0x1c30 */  57,140,  0, 11,127,158,200, 64, 65,157,  0, 36,127,171, 40, 64,
/* 0x1c40 */  65,158,250, 64,136, 11,  0,  0, 85, 74, 64, 46,123,222, 64, 40,
/* 0x1c50 */  57,107,  0,  1,124, 10, 83,120,121, 74,  0, 32,161,253,  0,  0,
/* 0x1c60 */  87,220,170,254,127,156,121,214,127,138,224, 64,123,128,  0, 32,
/* 0x1c70 */  64,156,  0, 48, 87,255, 24, 56, 34, 47,  8,  0,127,255,  7,180,
/* 0x1c80 */ 126, 49, 46,112, 59,255,  0,  2,126, 49,122, 20,123,255, 15,164,
/* 0x1c90 */ 178, 61,  0,  0, 58,  0,  0,  0,127,189,250, 20, 72,  0,  0,136,
/* 0x1ca0 */ 127,220,240, 80, 85,241,217,126,127,156, 80, 80,126, 49,120, 80,
/* 0x1cb0 */ 127,158,200, 64,123,208,  0, 32,178, 61,  0,  0,123,138,  0, 32,
/* 0x1cc0 */  65,157,  0, 36,127,171, 40, 64, 65,158,249,184,137, 75,  0,  0,
/* 0x1cd0 */  87,156, 64, 46,123,208, 64, 40, 57,107,  0,  1,125, 74,227,120,
/* 0x1ce0 */ 121, 74,  0, 32,163,157,  0,  2, 86, 30,170,254,127,222,225,214,
/* 0x1cf0 */ 127,138,240, 64,123,192,  0, 32, 64,156,  0, 52, 87,255, 24, 56,
/* 0x1d00 */  35,220,  8,  0,127,255,  7,180,127,222, 46,112, 59,255,  0,130,
/* 0x1d10 */ 127,158,226, 20,123,255, 15,164,179,157,  0,  2, 58,  0,  0,  8,
/* 0x1d20 */ 127,189,250, 20, 58, 32,  0,  3, 72,  0,  0, 44, 87,159,217,126,
/* 0x1d30 */ 124, 30,128, 80,125, 94, 80, 80,127,255,224, 80,121, 74,  0, 32,
/* 0x1d40 */ 179,253,  0,  2,120,  0,  0, 32, 59,189,  2,  4, 58,  0,  0, 16,
/* 0x1d50 */  58, 32,  0,  8, 59,241,255,255, 59,192,  0,  1,123,255,  0, 32,
/* 0x1d60 */  59,255,  0,  1,127,233,  3,166,123,220, 15,164,127,128,200, 64,
/* 0x1d70 */ 127,157,226, 20, 65,157,  0, 36,127,171, 40, 64, 65,158,249,  4,
/* 0x1d80 */ 139,235,  0,  0, 85, 74, 64, 46,120,  0, 64, 40, 57,107,  0,  1,
/* 0x1d90 */ 127,234, 83,120,121, 74,  0, 32,161,252,  0,  0, 84, 31,170,254,
/* 0x1da0 */  87,222,  8, 60,127,255,121,214,127,138,248, 64,123,238,  0, 32,
/* 0x1db0 */  64,156,  0, 32, 32, 15,  8,  0,127,222,  7,180,124,  0, 46,112,
/* 0x1dc0 */ 125,224,122, 20,125,192,115,120,177,252,  0,  0, 72,  0,  0, 40,
/* 0x1dd0 */ 124, 31,  0, 80,125, 95, 80, 80, 85,255,217,126,125,255,120, 80,
/* 0x1de0 */  59,222,  0,  1,177,252,  0,  0,120,  0,  0, 32,121, 74,  0, 32,
/* 0x1df0 */ 127,222,  7,180, 66,  0,255,116,126,145,136, 48, 47,140,  0,  3,
/* 0x1e00 */ 126, 49,128, 80,127,145,242, 20, 65,157,  2, 80, 47,156,  0,  3,
/* 0x1e10 */ 127,158,227,120, 64,157,  0,  8, 59,192,  0,  3, 87,222, 48, 50,
/* 0x1e20 */ 127,222,  7,180, 59,160,  0,  6, 59,222,  1,176,127,169,  3,166,
/* 0x1e30 */ 123,222, 15,164, 59,224,  0,  1,123,241, 15,164,127,128,200, 64,
/* 0x1e40 */ 126, 49,242, 20, 65,157,  0, 36,127,171, 40, 64, 65,158,248, 52,
/* 0x1e50 */ 139,171,  0,  0, 85, 74, 64, 46,120,  0, 64, 40, 57,107,  0,  1,
/* 0x1e60 */ 127,170, 83,120,121, 74,  0, 32,126, 91,138, 46, 84, 29,170,254,
/* 0x1e70 */  87,255,  8, 60,127,189,145,214,127,138,232, 64,123,176,  0, 32,
/* 0x1e80 */  64,156,  0, 32, 32, 18,  8,  0,127,255,  7,180,124,  0, 46,112,
/* 0x1e90 */ 126, 64,146, 20,126,  0,131,120,126, 91,139, 46, 72,  0,  0, 40,
/* 0x1ea0 */ 124, 29,  0, 80,125, 93, 80, 80, 86, 93,217,126,126, 93,144, 80,
/* 0x1eb0 */  59,255,  0,  1,126, 91,139, 46,120,  0,  0, 32,121, 74,  0, 32,
/* 0x1ec0 */ 127,255,  7,180, 66,  0,255,116, 59,255,255,192, 47,159,  0,  3,
/* 0x1ed0 */ 127,242,  7,180, 64,157,  1,108, 87,241,  7,254, 47,159,  0, 13,
/* 0x1ee0 */  98, 49,  0,  2,127,254, 14,112,122, 61,  0, 32, 65,157,  0, 40,
/* 0x1ef0 */  59,254,255,255, 35,210,  2,176,127,253,  7,180,126, 63,248, 48,
/* 0x1f00 */ 127,222,250, 20,123,222, 15,164, 59,222,255,254,127,219,242, 20,
/* 0x1f10 */  72,  0,  0,116, 59,222,255,250,123,222,  0, 32, 59,222,  0,  1,
/* 0x1f20 */ 127,201,  3,166,127,128,200, 64, 65,157,  0, 36,127,171, 40, 64,
/* 0x1f30 */  65,158,247, 80,139,235,  0,  0, 85, 74, 64, 46,120,  0, 64, 40,
/* 0x1f40 */  57,107,  0,  1,127,234, 83,120,121, 74,  0, 32, 84, 30,248,126,
/* 0x1f50 */  87,191,  8, 60,127,138,240, 64,123,192,  0, 32,123,253,  0, 32,
/* 0x1f60 */  65,156,  0, 20,125, 94, 80, 80, 99,255,  0,  1,121, 74,  0, 32,
/* 0x1f70 */ 123,253,  0, 32, 66,  0,255,176,123,191, 32, 40, 59,195,  6, 72,
/* 0x1f80 */  59,160,  0,  4, 59,189,255,255, 58, 64,  0,  1,123,189,  0, 32,
/* 0x1f90 */  58, 32,  0,  1, 59,189,  0,  1,127,169,  3,166,122, 80, 15,164,
/* 0x1fa0 */ 127,128,200, 64,126, 30,130, 20, 65,157,  0, 36,127,171, 40, 64,
/* 0x1fb0 */  65,158,246,208,139,171,  0,  0, 85, 74, 64, 46,120,  0, 64, 40,
/* 0x1fc0 */  57,107,  0,  1,127,170, 83,120,121, 74,  0, 32,161,240,  0,  0,
/* 0x1fd0 */  84, 29,170,254, 86, 82,  8, 60,127,189,121,214,127,138,232, 64,
/* 0x1fe0 */ 123,174,  0, 32, 64,156,  0, 32, 32, 15,  8,  0,126, 82,  7,180,
/* 0x1ff0 */ 124,  0, 46,112,125,224,122, 20,125,192,115,120,177,240,  0,  0,
/* 0x2000 */  72,  0,  0, 48,124, 29,  0, 80,125, 93, 80, 80, 85,253,217,126,
/* 0x2010 */ 125,253,120, 80, 58, 82,  0,  1,177,240,  0,  0,126, 63,251,120,
/* 0x2020 */ 120,  0,  0, 32,121, 74,  0, 32,126, 82,  7,180,123,255,  0, 32,
/* 0x2030 */  86, 49,  8, 60,126, 49,  7,180, 66,  0,255,100, 72,  0,  0,  8,
/* 0x2040 */ 123,255,  0, 32, 59,255,  0,  1,123,242,  0, 33, 65,130,  0,100,
/* 0x2050 */  57,140,  0,  7,125,140,  7,180, 59,220,  0,  2,127,146,208, 64,
/* 0x2060 */ 127,222,  7,180, 65,157,246, 28, 59,222,255,255,123,222,  0, 32,
/* 0x2070 */  59,222,  0,  1,127,201,  3,166,127,242,208, 80, 59,186,  0,  1,
/* 0x2080 */ 123,255,  0, 32,127,199,248,174,123,191,  0, 32,127,199,209,174,
/* 0x2090 */  66, 64,  0, 24,127,157, 64, 64,127,250,251,120, 65,156,255,220,
/* 0x20a0 */  72,  0,  0,  8, 57,128,  0,  0,127,250,251,120, 75,255,246, 40,
/* 0x20b0 */  61, 64,  0,255, 97, 74,255,255,127,128, 80, 64, 65,157,  0, 16,
/* 0x20c0 */ 127,171, 40, 64, 65,158,245,188, 57,107,  0,  1,124,132, 88, 80,
/* 0x20d0 */  56, 96,  0,  0,144,134,  0,  0,147, 73,  0,  0, 72,  0,  0,  0,
/* 0x20e0 */ 249,193,255,112,249,225,255,120,250,  1,255,128,250, 33,255,136,
/* 0x20f0 */ 250, 65,255,144,250, 97,255,152,250,129,255,160,250,161,255,168,
/* 0x2100 */ 250,193,255,176,250,225,255,184,251,  1,255,192,251, 33,255,200,
/* 0x2110 */ 251, 65,255,208,251, 97,255,216,251,129,255,224,251,161,255,232,
/* 0x2120 */ 251,193,255,240,251,225,255,248,248,  1,  0, 16, 78,128,  0, 32,
/* 0x2130 */ 233,193,255,112,233,225,255,120,234,  1,255,128,234, 33,255,136,
/* 0x2140 */ 234, 65,255,144,234, 97,255,152,234,129,255,160,234,161,255,168,
/* 0x2150 */ 234,193,255,176,234,225,255,184,235,  1,255,192,235, 33,255,200,
/* 0x2160 */ 235, 65,255,208,235, 97,255,216,235,129,255,224,232,  1,  0, 16,
/* 0x2170 */ 235,161,255,232,124,  8,  3,166,235,193,255,240,235,225,255,248,
/* 0x2180 */  78,128,  0, 32,  0,  0,  0,  0,  0,  0,  0,  1,249,225,255,120,
/* 0x2190 */ 249,193,255,112, 56,  0,  0,  0, 57, 96,  0,  1,250, 97,255,152,
/* 0x21a0 */ 250, 65,255,144, 58, 99,  0,  4,251,225,255,248,251,193,255,240,
/* 0x21b0 */  59,227,  0,  2,250,  1,255,128,250, 33,255,136,250,129,255,160,
/* 0x21c0 */ 250,161,255,168,250,193,255,176,250,225,255,184,251,  1,255,192,
/* 0x21d0 */ 251, 33,255,200,251, 65,255,208,251, 97,255,216,251,129,255,224,
/* 0x21e0 */ 251,161,255,232,137, 67,  0,  0,138, 67,  0,  1,138, 35,  0,  2,
/* 0x21f0 */ 144,  6,  0,  0,144,  9,  0,  0,125, 79,  7,180,125,113,136, 48,
/* 0x2200 */ 125,107,144, 48, 58, 49,255,255, 57,107,255,255,122, 49,  0, 32,
/* 0x2210 */ 121,114,  0, 32,137, 99,  0,  1,125,107, 82, 20, 57, 64,  3,  0,
/* 0x2220 */ 125, 74, 88, 48, 57, 74,  7, 54,121, 75,  0, 33, 65,130,  0, 40,
/* 0x2230 */  57, 75,255,255, 57, 96,  4,  0,121, 74,  0, 32, 57, 74,  0,  1,
/* 0x2240 */ 125, 73,  3,166, 96,  0,  0,  0, 96,  0,  0,  0,181,127,  0,  2,
/* 0x2250 */  66,  0,255,252,124,164, 42, 20,127,164, 40, 64, 65,158,  2,240,
/* 0x2260 */  59,224,  0,  4,137, 68,  0,  0, 57,100,  0,  1,127,233,  3,166,
/* 0x2270 */  57,132,  0,  5,127,171, 40, 64, 85, 74, 64, 46, 57,107,  0,  1,
/* 0x2280 */  65,158,  2,204,136, 11,255,255,124, 10, 83,120,121, 74,  0, 32,
/* 0x2290 */  66,  0,255,228, 47,168,  0,  0, 65,158, 11, 80, 56,  0,  0,  1,
/* 0x22a0 */  57, 96,  0,  1,248,  1,255, 96,249, 97,255, 88, 32, 15,  0,  8,
/* 0x22b0 */  59,224,255,255,144,  1,255, 84, 63, 32,  0,255,123,255,  0, 32,
/* 0x22c0 */  57,192,  0,  1, 58,  0,  0,  1, 58,160,  0,  0, 57, 96,  0,  0,
/* 0x22d0 */  58,192,  0,  0, 99, 57,255,255,126,221,136, 56, 86,160, 32, 54,
/* 0x22e0 */ 127,190,  7,180,124,  0,  7,180,127,222,  2, 20,127,159,200, 64,
/* 0x22f0 */ 123,222, 15,164, 65,157,  0, 36,127,172, 40, 64, 65,158,  2, 80,
/* 0x2300 */ 136, 12,  0,  0, 85, 74, 64, 46,123,255, 64, 40, 57,140,  0,  1,
/* 0x2310 */ 124, 10, 83,120,121, 74,  0, 32,127,147,242, 46, 87,251,170,254,
/* 0x2320 */ 127,123,225,214,127,138,216, 64,123, 96,  0, 32, 64,156,  2,112,
/* 0x2330 */ 131,225,255, 84,126,221,144, 56, 47,149,  0,  6,127,189,120, 48,
/* 0x2340 */ 125,107,254, 48, 35,252,  8,  0,127,255, 46,112,127,255,226, 20,
/* 0x2350 */ 125,107,234, 20,127,243,243, 46, 85,125, 64, 46, 85,107, 80, 42,
/* 0x2360 */ 127,189, 88, 80, 57, 96,  0,  1,123,189,  0, 32, 59,189,  7, 54,
/* 0x2370 */ 123,189, 15,164,127,179,234, 20, 64,157,  1, 40,127,240,176, 80,
/* 0x2380 */  57, 96,  0,  1,123,255,  0, 32,127, 71,248,174, 72,  0,  0, 40,
/* 0x2390 */  96,  0,  0,  0, 96,  0,  0,  0, 96,  0,  0,  0,127,125,243, 46,
/* 0x23a0 */ 125,107,  7,180,127,224,251,120, 64,130,  0,172, 47,139,  0,255,
/* 0x23b0 */  65,157,  0,172, 87, 90,  8, 60, 87, 95,  5,238, 85,120,  8, 60,
/* 0x23c0 */ 127,255,  7,180, 59,223,  1,  0, 44, 63,  0,  0,127,222, 90, 20,
/* 0x23d0 */ 127,  0,200, 64, 79,128,  0,  0,127, 11,195,120,124,172, 40, 64,
/* 0x23e0 */  59, 24,  0,  1, 85, 95, 64, 46,123,222, 15,164,127, 90,  7,180,
/* 0x23f0 */  65,153,  0, 28, 65,134,  1, 88,137, 76,  0,  0,120,  0, 64, 40,
/* 0x2400 */  57,140,  0,  1,125, 74,251,120,121, 74,  0, 32,127,157,242, 46,
/* 0x2410 */  84, 27,170,254,127,251,225,214, 35,124,  8,  0, 87,151,217,126,
/* 0x2420 */ 127,123, 46,112,127, 10,248, 64,127,123,226, 20,124, 31,  0, 80,
/* 0x2430 */ 126,159, 80, 80,127,151,224, 80,123,255,  0, 32, 65,152,255, 96,
/* 0x2440 */ 127,157,243, 46,127, 11,  7,180,120,  0,  0, 32,122,138,  0, 32,
/* 0x2450 */  64,158,255, 92, 47,139,  0,255, 64,253,  0, 72,121,107,  6, 32,
/* 0x2460 */  59,214,  0,  1,125,103,177,174,124, 31,  3,120,123,214,  0, 32,
/* 0x2470 */  47,149,  0,  9, 65,157,  8,104, 58,181,255,253,126,181,  7,180,
/* 0x2480 */  72,  0,  6, 84, 96,  0,  0,  0, 96,  0,  0,  0,127,107,  7,180,
/* 0x2490 */  47,139,  0,255,127,221,227, 46,127, 64,211,120, 65,157,  0,136,
/* 0x24a0 */  85,123,  8, 60,127,128,200, 64,127, 44, 40, 64,127,120,219,120,
/* 0x24b0 */  85, 95, 64, 46,121,124, 15,164, 65,157,  0, 28, 65,154,  0,144,
/* 0x24c0 */ 137, 76,  0,  0,120,  0, 64, 40, 57,140,  0,  1,125, 74,251,120,
/* 0x24d0 */ 121, 74,  0, 32,127, 93,226, 46, 84, 31,170,254, 57,120,  0,  1,
/* 0x24e0 */ 127,255,209,214, 35,218,  8,  0, 87, 88,217,126,127,222, 46,112,
/* 0x24f0 */ 127,138,248, 64,127, 24,208, 80,127,222,210, 20,123,250,  0, 32,
/* 0x2500 */  65,156,255,140,125,107,  7,180,124, 31,  0, 80,125, 95, 80, 80,
/* 0x2510 */ 127, 29,227, 46, 47,139,  0,255,120,  0,  0, 32,121, 74,  0, 32,
/* 0x2520 */  64,157,255,128, 59,214,  0,  1,121,107,  6, 32,123,222,  0, 32,
/* 0x2530 */  47,149,  0,  3,125,103,177,174,124, 31,  3,120,127,214,243,120,
/* 0x2540 */  65,157,255, 48, 58,160,  0,  0, 72,  0,  5,140, 56, 96,  0,  1,
/* 0x2550 */ 233,193,255,112,233,225,255,120,234,  1,255,128,234, 33,255,136,
/* 0x2560 */ 234, 65,255,144,234, 97,255,152,234,129,255,160,234,161,255,168,
/* 0x2570 */ 234,193,255,176,234,225,255,184,235,  1,255,192,235, 33,255,200,
/* 0x2580 */ 235, 65,255,208,235, 97,255,216,235,129,255,224,235,161,255,232,
/* 0x2590 */ 235,193,255,240,235,225,255,248, 78,128,  0, 32,124, 27,248, 80,
/* 0x25a0 */  87,159,217,126,127,123, 80, 80,127,255,224, 80, 57,117,  0,192,
/* 0x25b0 */ 127,128,200, 64,127,243,243, 46,120, 26,  0, 32,123,106,  0, 32,
/* 0x25c0 */ 121,107, 15,164, 65,157,  0, 36,127,172, 40, 64, 65,158,255,128,
/* 0x25d0 */ 137, 76,  0,  0, 87,123, 64, 46,120, 26, 64, 40, 57,140,  0,  1,
/* 0x25e0 */ 125, 74,219,120,121, 74,  0, 32,127,115, 90, 46, 87, 64,170,254,
/* 0x25f0 */ 124,  0,217,214,127,138,  0, 64,120, 28,  0, 32, 64,156,  3, 16,
/* 0x2600 */  32, 27,  8,  0,250,  1,255,104, 47,149,  0,  7,124,  0, 46,112,
/* 0x2610 */ 127, 96,218, 20, 59,  3,  6,104,127,115, 91, 46,126,176, 16, 38,
/* 0x2620 */  86,181,239,254,126,181,  0,208,122,181,240, 66,122,181, 16,  0,
/* 0x2630 */  58,181,  0,  3,127,156,200, 64, 65,157,  0, 36,127,172, 40, 64,
/* 0x2640 */  65,158,255, 12,137,108,  0,  0, 85, 74, 64, 46,123,156, 64, 40,
/* 0x2650 */  57,140,  0,  1,125,106, 83,120,121, 74,  0, 32,160, 24,  0,  0,
/* 0x2660 */  87,139,170,254,125,107,  1,214,127,138, 88, 64,121,127,  0, 32,
/* 0x2670 */  64,156,  4,156, 87,171, 24, 56, 35,192,  8,  0,125,107,  7,180,
/* 0x2680 */ 127,222, 46,112, 57,107,  0,  2,124, 30,  2, 20,121,107, 15,164,
/* 0x2690 */ 176, 24,  0,  0, 58,128,  0,  0,127, 24, 90, 20, 58,224,  0,  3,
/* 0x26a0 */  57,119,255,255, 56,  0,  0,  1,121,107,  0, 32, 57,107,  0,  1,
/* 0x26b0 */ 125,105,  3,166, 96,  0,  0,  0, 96,  0,  0,  0,120, 28, 15,164,
/* 0x26c0 */  84, 26,  8, 60,127,159,200, 64,127, 44, 40, 64,127, 93,211,120,
/* 0x26d0 */  85, 75, 64, 46,127,152,226, 20, 65,157,  0, 28, 65,154,254,112,
/* 0x26e0 */ 137, 76,  0,  0,123,255, 64, 40, 57,140,  0,  1,125, 74, 91,120,
/* 0x26f0 */ 121, 74,  0, 32,163,220,  0,  0, 87,235,170,254, 56, 29,  0,  1,
/* 0x2700 */ 125,107,241,214, 35,190,  8,  0, 87,219,217,126,127,189, 46,112,
/* 0x2710 */ 127,138, 88, 64,127,123,240, 80,127,221,242, 20,121,125,  0, 32,
/* 0x2720 */  64,156,  2,236,127, 64,  7,180,179,220,  0,  0,127,191,235,120,
/* 0x2730 */  66,  0,255,140, 57, 96,  0,  1, 47,149,  0,  3,125,119,184, 48,
/* 0x2740 */ 126,247,160, 80,126,247,  2, 20,146,225,255, 80, 65,157,  3, 24,
/* 0x2750 */  47,151,  0,  3,122,235,  0, 32, 65,157,  5,148, 85,120, 48, 50,
/* 0x2760 */ 127, 24,  7,180, 56,  0,  0,  6, 59, 24,  1,176,124,  9,  3,166,
/* 0x2770 */ 123, 24, 15,164, 57, 96,  0,  1, 96,  0,  0,  0,121,124, 15,164,
/* 0x2780 */  85,119,  8, 60,127,159,200, 64,127, 44, 40, 64,126,235,187,120,
/* 0x2790 */  85, 64, 64, 46,127,156,194, 20, 65,157,  0, 28, 65,154,253,176,
/* 0x27a0 */ 137, 76,  0,  0,123,255, 64, 40, 57,140,  0,  1,125, 74,  3,120,
/* 0x27b0 */ 121, 74,  0, 32,127,211,226, 46, 87,224,170,254, 57,107,  0,  1,
/* 0x27c0 */ 124,  0,241,214, 35,190,  8,  0, 87,219,217,126,127,189, 46,112,
/* 0x27d0 */ 127,138,  0, 64,127,123,240, 80,127,221,242, 20,120, 29,  0, 32,
/* 0x27e0 */  64,156,  2, 76,126,235,  7,180,127,211,227, 46,127,191,235,120,
/* 0x27f0 */  66,  0,255,140, 57,107,255,192, 47,139,  0,  3,125,126,  7,180,
/* 0x2800 */  64,157,  2, 76, 85,122,  7,254, 47,139,  0, 13, 99, 90,  0,  2,
/* 0x2810 */ 125,107, 14,112,123, 64,  0, 32, 65,157,  5, 48, 57,107,255,255,
/* 0x2820 */  34, 30,  2,176,127, 90, 88, 48,125,107,  7,180,126, 16,210, 20,
/* 0x2830 */ 122, 16, 15,164, 58, 16,255,254,126, 19,130, 20, 57,107,255,255,
/* 0x2840 */  59,192,  0,  1,121,107,  0, 32, 59,128,  0,  1, 57,107,  0,  1,
/* 0x2850 */ 125,105,  3,166, 72,  0,  0, 32, 96,  0,  0,  0,176, 27,  0,  0,
/* 0x2860 */ 126,254,  7,180,127,191,235,120, 87,156,  8, 60,127,156,  7,180,
/* 0x2870 */  66, 64,  1,224,123,219, 15,164, 87,215,  8, 60,127,159,200, 64,
/* 0x2880 */ 127, 44, 40, 64,126,254,187,120, 85, 75, 64, 46,127,112,218, 20,
/* 0x2890 */  65,157,  0, 28, 65,154,252,184,137, 76,  0,  0,123,255, 64, 40,
/* 0x28a0 */  57,140,  0,  1,125, 74, 91,120,121, 74,  0, 32,160, 27,  0,  0,
/* 0x28b0 */  87,235,170,254,127,148,211,120,125,107,  1,214, 35,160,  8,  0,
/* 0x28c0 */  84, 24,217,126,127,189, 46,112,127,138, 88, 64,127, 24,  0, 80,
/* 0x28d0 */ 124, 29,  2, 20,121,125,  0, 32, 65,156,255,132,127,235,248, 80,
/* 0x28e0 */ 125, 75, 80, 80,179, 27,  0,  0, 59,222,  0,  1,123,255,  0, 32,
/* 0x28f0 */ 121, 74,  0, 32,127,222,  7,180,122,154,  0, 32, 75,255,255,108,
/* 0x2900 */  96,  0,  0,  0, 96,  0,  0,  0, 96,  0,  0,  0,127,224,208, 80,
/* 0x2910 */  87,124,217,126,127,124,216, 80,124,  0, 80, 80,127,159,200, 64,
/* 0x2920 */ 123,250,  0, 32,127,115, 91, 46,120, 10,  0, 32, 59,139,  0, 24,
/* 0x2930 */  65,157,  0, 36,127,172, 40, 64, 65,158,252, 20,137, 76,  0,  0,
/* 0x2940 */  84,  0, 64, 46,123,250, 64, 40, 57,140,  0,  1,125, 74,  3,120,
/* 0x2950 */ 121, 74,  0, 32,127,243,226, 46, 87, 64,170,254,124,  0,249,214,
/* 0x2960 */ 127,138,  0, 64,120, 27,  0, 32, 64,156,  2, 52, 33,127,  8,  0,
/* 0x2970 */ 127,128,200, 64,125,107, 46,112,127,235,250, 20, 59,222,  1,224,
/* 0x2980 */ 127,243,227, 46, 65,157,  0, 36,127,172, 40, 64, 65,158,251,192,
/* 0x2990 */ 137,108,  0,  0, 85, 74, 64, 46,120, 27, 64, 40, 57,140,  0,  1,
/* 0x29a0 */ 125,106, 83,120,121, 74,  0, 32,124, 19,242, 46, 87,107,170,254,
/* 0x29b0 */ 125,107,  1,214,127,138, 88, 64,121,127,  0, 32, 64,156,  3, 56,
/* 0x29c0 */  33, 96,  8,  0, 47,182,  0,  0,125,107, 46,112,124, 11,  2, 20,
/* 0x29d0 */ 124, 19,243, 46, 65,158,251,120, 47,149,  0,  7,125,112,176, 80,
/* 0x29e0 */ 126,176, 16, 38, 86,181,239,254,121,107,  0, 32, 56, 22,  0,  1,
/* 0x29f0 */ 126,181,  0,208,122,181,  7,164,125,103, 88,174,125,103,177,174,
/* 0x2a00 */  58,181,  0, 11,120, 22,  0, 32, 72,  0,  0,204,127,235,248, 80,
/* 0x2a10 */ 125, 75, 80, 80,179,124,  0,  0,123,255,  0, 32,121, 74,  0, 32,
/* 0x2a20 */ 124,  0,  7,180, 66,  0,252,152, 75,255,253, 12,127,224,248, 80,
/* 0x2a30 */ 125, 64, 80, 80,127,115,227, 46,123,255,  0, 32,121, 74,  0, 32,
/* 0x2a40 */ 125,107,  7,180, 66,  0,253, 56, 75,255,253,172,121,122,  0, 32,
/* 0x2a50 */  59, 90,  0,  1,123, 80,  0, 33, 65,130,  0,132, 58,181,  0,  7,
/* 0x2a60 */ 126,181,  7,180,127,144,176, 64, 65,157,250,228,128,  1,255, 80,
/* 0x2a70 */  59,182,  0,  1,127,208,176, 80,123,222,  0, 32,126,220,179,120,
/* 0x2a80 */ 125,125,  2, 20,125,112, 88, 80,125,126, 88, 80,121,107,  0, 32,
/* 0x2a90 */  57,107,  0,  1,125,105,  3,166, 72,  0,  0, 20,126,220,179,120,
/* 0x2aa0 */ 123,222,  0, 32, 64,157,  0, 56, 59,182,  0,  1,125,103,240,174,
/* 0x2ab0 */ 127,136,232, 64, 59,222,  0,  1,123,182,  0, 32,125,103,225,174,
/* 0x2ac0 */  66,  0,255,220,232,  1,255,104,249,193,255, 96,233,193,255, 88,
/* 0x2ad0 */ 248,  1,255, 88,127,136,176, 64, 65,253,248,  0, 61, 64,  0,255,
/* 0x2ae0 */  97, 74,255,255,127,159, 80, 64, 65,157,  0, 16,127,172, 40, 64,
/* 0x2af0 */  65,158,250, 92, 57,140,  0,  1,124,132, 96, 80, 56, 96,  0,  0,
/* 0x2b00 */ 144,134,  0,  0,146,201,  0,  0, 75,255,250, 72,127,139,224, 80,
/* 0x2b10 */  84, 31,217,126,125,107, 80, 80,124, 31,  0, 80,127,156,200, 64,
/* 0x2b20 */ 123,158,  0, 32,176, 24,  0,  0,121,106,  0, 32, 65,157,  0, 36,
/* 0x2b30 */ 127,172, 40, 64, 65,158,250, 24,137, 76,  0,  0, 85,107, 64, 46,
/* 0x2b40 */ 123,158, 64, 40, 57,140,  0,  1,125, 74, 91,120,121, 74,  0, 32,
/* 0x2b50 */ 160, 24,  0,  2, 87,203,170,254,125,107,  1,214,127,138, 88, 64,
/* 0x2b60 */ 121,127,  0, 32, 64,156,  1, 72, 87,171, 24, 56, 35,192,  8,  0,
/* 0x2b70 */ 125,107,  7,180,127,222, 46,112, 57,107,  0,130,124, 30,  2, 20,
/* 0x2b80 */ 121,107, 15,164,176, 24,  0,  2, 58,128,  0,  8,127, 24, 90, 20,
/* 0x2b90 */  58,224,  0,  3, 75,255,251, 12, 96,  0,  0,  0,127, 64,208, 80,
/* 0x2ba0 */  87,251,217,126,127,192, 80, 80,127,251,248, 80,127,154,200, 64,
/* 0x2bb0 */ 127,243,227, 46,123, 64,  0, 32,123,202,  0, 32, 59,235,  0, 48,
/* 0x2bc0 */  65,157,  0, 36,127,172, 40, 64, 65,158,249,132,137, 76,  0,  0,
/* 0x2bd0 */  87,192, 64, 46, 57,140,  0,  1,125, 74,  3,120,123, 64, 64, 40,
/* 0x2be0 */ 121, 74,  0, 32,127,115,250, 46, 84, 30,170,254,127,222,217,214,
/* 0x2bf0 */ 127,138,240, 64,123,220,  0, 32, 65,156,  1, 44,124, 30,  0, 80,
/* 0x2c00 */  87,124,217,126,127,222, 80, 80,127,156,216, 80,127,128,200, 64,
/* 0x2c10 */ 120, 26,  0, 32,127,147,251, 46,123,202,  0, 32, 57,107,  0, 72,
/* 0x2c20 */  65,157,  0, 36,127,172, 40, 64, 65,158,249, 36,137, 76,  0,  0,
/* 0x2c30 */  87,222, 64, 46,120, 26, 64, 40, 57,140,  0,  1,125, 74,243,120,
/* 0x2c40 */ 121, 74,  0, 32,127,243, 90, 46, 87, 64,170,254,124,  0,249,214,
/* 0x2c50 */ 127,138,  0, 64,120, 28,  0, 32, 64,156,  1,104, 32, 31,  8,  0,
/* 0x2c60 */ 250,  1,255,104,125,208,115,120,233,193,255, 96,124,  0, 46,112,
/* 0x2c70 */ 127,224,250, 20,127,243, 91, 46, 96,  0,  0,  0, 47,149,  0,  7,
/* 0x2c80 */  59,  3, 10,108,126,176, 16, 38, 86,181,239,254,126,181,  0,208,
/* 0x2c90 */ 122,181,240, 66,122,181, 16,  0, 58,181,  0, 11, 75,255,249,152,
/* 0x2ca0 */  96,  0,  0,  0, 96,  0,  0,  0, 96,  0,  0,  0, 84, 31,217,126,
/* 0x2cb0 */ 124, 31,  0, 80,125, 75, 80, 80,127,235,240, 80,176, 24,  0,  2,
/* 0x2cc0 */ 121, 74,  0, 32, 59, 24,  2,  4,123,255,  0, 32, 58,128,  0, 16,
/* 0x2cd0 */  58,224,  0,  8, 75,255,249,204, 96,  0,  0,  0, 58,181,255,250,
/* 0x2ce0 */ 126,181,  7,180, 75,255,253,240, 96,  0,  0,  0, 57, 96,  0,  3,
/* 0x2cf0 */  75,255,250,108, 84, 31,217,126,127,139,216, 80,125, 75, 80, 80,
/* 0x2d00 */ 233, 97,255, 88,249,193,255, 88,124, 31,  0, 80,249, 97,255,104,
/* 0x2d10 */ 123,156,  0, 32,233,193,255, 96,121, 74,  0, 32,124, 19,243, 46,
/* 0x2d20 */  75,255,255, 92, 33,123,  8,  0,250,  1,255,104,234,  1,255, 88,
/* 0x2d30 */ 125,107, 46,112,127,107,218, 20,249,193,255, 88,233,193,255, 96,
/* 0x2d40 */ 127,115,251, 46, 75,255,255, 56, 57,107,255,250,121,107,  0, 32,
/* 0x2d50 */  57,107,  0,  1,125,105,  3,166, 96,  0,  0,  0,127,159,200, 64,
/* 0x2d60 */  84, 26,  8, 60,127, 44, 40, 64, 85, 75, 64, 46, 65,157,  0, 28,
/* 0x2d70 */  65,154,247,220,137, 76,  0,  0,123,255, 64, 40, 57,140,  0,  1,
/* 0x2d80 */ 125, 74, 91,120,121, 74,  0, 32, 87,235,248,126,127,138, 88, 64,
/* 0x2d90 */ 123, 64,  0, 32,121,127,  0, 32, 65,156,  0, 20,125, 75, 80, 80,
/* 0x2da0 */  99, 90,  0,  1,121, 74,  0, 32,123, 64,  0, 32, 66,  0,255,176,
/* 0x2db0 */  58,  3,  6, 72,120, 26, 32, 40, 57, 96,  0,  4, 75,255,250,128,
/* 0x2dc0 */  87,254,217,126,127,254,248, 80,127,128,208, 80,250,  1,255,104,
/* 0x2dd0 */ 234,  1,255, 96,125, 64, 80, 80,127,243, 91, 46,123,156,  0, 32,
/* 0x2de0 */ 121, 74,  0, 32, 75,255,254,152, 58,192,  0,  0, 75,255,253, 12,
/* 0x2df0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2e00 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2e10 */   0,  0,  0,  0,  3,  0,  0,  6,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2e20 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  0, 16,
/* 0x2e30 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2e40 */   0,  0,  0,  0,  3,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2e50 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  0,  3,
/* 0x2e60 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2e70 */   0,  0,  0,  0,  3,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2e80 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  0,  7,
/* 0x2e90 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2ea0 */   0,  0,  0,  0,  3,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2eb0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  0, 11,
/* 0x2ec0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2ed0 */   0,  0,  0,  0,  3,  0,  0, 13,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2ee0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  0, 15,
/* 0x2ef0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2f00 */   0,  0,  0,  0,  3,  0,  0, 17,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2f10 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  0, 18,
/* 0x2f20 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2f30 */   0,  0,  0,  1, 16,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,116,
/* 0x2f40 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  6, 18,  0,  0,  4,
/* 0x2f50 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2f60 */   0,  0,  0, 15, 16,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0, 20,
/* 0x2f70 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 29, 16,  0,  0,  3,
/* 0x2f80 */   0,  0,  0,  0,  0,  0,  0, 32,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2f90 */   0,  0,  0, 36, 16,  0,  0,  3,  0,  0,  0,  0,  0,  0,  1, 20,
/* 0x2fa0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 43, 16,  0,  0,  3,
/* 0x2fb0 */   0,  0,  0,  0,  0,  0,  0, 80,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2fc0 */   0,  0,  0, 52, 16,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0, 80,
/* 0x2fd0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 58, 16,  0,  0,  3,
/* 0x2fe0 */   0,  0,  0,  0,  0,  0,  0, 56,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2ff0 */   0,  0,  0, 68, 16,  0,  0,  3,  0,  0,  0,  0,  0,  0,  0,  8,
/* 0x3000 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 73, 16,  0,  0,  3,
/* 0x3010 */   0,  0,  0,  0,  0,  0,  0, 88,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3020 */   0,  0,  0, 79, 18,  0,  0,  1,  0,  0,  0,  0,  0,  0, 13, 24,
/* 0x3030 */   0,  0,  0,  0,  0,  0,  1,152,  0,  0,  0, 89, 16,  0,  0,  3,
/* 0x3040 */   0,  0,  0,  0,  0,  0,  0,208,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3050 */   0,  0,  0,102, 16,  0,  0,  3,  0,  0,  0,  0,  0,  0,  0, 96,
/* 0x3060 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,107, 18,  0,  0,  1,
/* 0x3070 */   0,  0,  0,  0,  0,  0, 12,140,  0,  0,  0,  0,  0,  0,  0,140,
/* 0x3080 */   0,  0,  0,116, 16,  0,  0,  3,  0,  0,  0,  0,  0,  0,  0, 48,
/* 0x3090 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,122, 16,  0,  0,  3,
/* 0x30a0 */   0,  0,  0,  0,  0,  0,  0,120,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x30b0 */   0,  0,  0,135, 16,  0,  0,  6,  0,  0,  0,  0,  0,  0,  0,  8,
/* 0x30c0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,143, 16,  0,  0,  3,
/* 0x30d0 */   0,  0,  0,  0,  0,  0,  1, 56,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x30e0 */   0,  0,  0,151, 16,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0, 44,
/* 0x30f0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,160, 16,  0,  0,  1,
/* 0x3100 */   0,  0,  0,  0,  0,  0,  0,152,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3110 */   0,  0,  0,167, 16,  0,  0,  3,  0,  0,  0,  0,  0,  0,  0, 64,
/* 0x3120 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,172, 16,  0,  0,  3,
/* 0x3130 */   0,  0,  0,  0,  0,  0,  0, 72,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3140 */   0,  0,  0,176, 16,  0,  0,  3,  0,  0,  0,  0,  0,  0,  0,104,
/* 0x3150 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,181, 16,  0,  0,  3,
/* 0x3160 */   0,  0,  0,  0,  0,  0,  0, 40,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3170 */   0,  0,  0,190, 16,  0,  0,  3,  0,  0,  0,  0,  0,  0,  0,112,
/* 0x3180 */   0,  0,  0,  0,  0,  0,  0,  0,  0, 80,109, 97,112,  0,102, 95,
/* 0x3190 */ 101,120,112, 97,110,100,  0,103,101,116, 95,112, 97,103,101, 95,
/* 0x31a0 */ 109, 97,115,107,  0,109,117,110,109, 97,112,  0,109,101,109, 99,
/* 0x31b0 */ 112,121,  0,114,101, 97,100,108,105,110,107,  0, 80,115,121,110,
/* 0x31c0 */  99,  0,102,116,114,117,110, 99, 97,116,101,  0,109,109, 97,112,
/* 0x31d0 */   0,119,114,105,116,101,  0,117,112,120, 95,109, 97,105,110, 50,
/* 0x31e0 */   0,109,101,109,102,100, 95, 99,114,101, 97,116,101,  0,114,101,
/* 0x31f0 */  97,100,  0,117,110,100,101,114,108, 97,121,  0,109,115,121,110,
/* 0x3200 */  99,  0,117,112,120,102,100, 95, 99,114,101, 97,116,101,  0,101,
/* 0x3210 */ 111,102, 95,110,114,118,  0,109,121, 95, 98,107,112,116,  0, 80,
/* 0x3220 */ 112,114,111,116,101, 99,116,  0, 80,117,110,109, 97,112,  0,101,
/* 0x3230 */ 120,105,116,  0, 98,114,107,  0,111,112,101,110,  0,109,112,114,
/* 0x3240 */ 111,116,101, 99,116,  0, 99,108,111,115,101,  0,  0,  0,  0,  0,
/* 0x3250 */   0,  0,  0,  0,  0,  0,  0, 76,  0,  0,  0, 36,  0,  0,  0, 10,
/* 0x3260 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,112,
/* 0x3270 */   0,  0,  0, 27,  0,  0,  0, 10,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3280 */   0,  0,  0,  0,  0,  0,  0,148,  0,  0,  0, 21,  0,  0,  0, 10,
/* 0x3290 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,184,
/* 0x32a0 */   0,  0,  0, 16,  0,  0,  0, 10,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x32b0 */   0,  0,  0,  0,  0,  0,  1, 92,  0,  0,  0, 35,  0,  0,  0, 10,
/* 0x32c0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,112,
/* 0x32d0 */   0,  0,  0, 18,  0,  0,  0, 10,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x32e0 */   0,  0,  0,  0,  0,  0,  2, 20,  0,  0,  0, 23,  0,  0,  0, 10,
/* 0x32f0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  2, 84,
/* 0x3300 */   0,  0,  0, 34,  0,  0,  0, 10,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3310 */   0,  0,  0,  0,  0,  0,  2, 96,  0,  0,  0, 16,  0,  0,  0, 10,
/* 0x3320 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  2,136,
/* 0x3330 */   0,  0,  0, 21,  0,  0,  0, 10,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3340 */   0,  0,  0,  0,  0,  0,  2,144,  0,  0,  0, 37,  0,  0,  0, 10,
/* 0x3350 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,104,
/* 0x3360 */   0,  0,  0, 33,  0,  0,  0, 10,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3370 */   0,  0,  0,  0,  0,  0,  4, 24,  0,  0,  0, 33,  0,  0,  0, 10,
/* 0x3380 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  4,176,
/* 0x3390 */   0,  0,  0, 33,  0,  0,  0, 10,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x33a0 */   0,  0,  0,  0,  0,  0,  4,232,  0,  0,  0, 14,  0,  0,  0, 10,
/* 0x33b0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  6, 52,
/* 0x33c0 */   0,  0,  0, 16,  0,  0,  0, 10,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x33d0 */   0,  0,  0,  0,  0,  0,  6, 92,  0,  0,  0, 15,  0,  0,  0, 10,
/* 0x33e0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  7,100,
/* 0x33f0 */   0,  0,  0, 21,  0,  0,  0, 10,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3400 */   0,  0,  0,  0,  0,  0,  7,136,  0,  0,  0, 16,  0,  0,  0, 10,
/* 0x3410 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  7,172,
/* 0x3420 */   0,  0,  0, 16,  0,  0,  0, 10,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3430 */   0,  0,  0,  0,  0,  0,  7,184,  0,  0,  0, 15,  0,  0,  0, 10,
/* 0x3440 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  9, 56,
/* 0x3450 */   0,  0,  0, 28,  0,  0,  0, 10,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3460 */   0,  0,  0,  0,  0,  0,  9, 72,  0,  0,  0, 20,  0,  0,  0, 10,
/* 0x3470 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  9,104,
/* 0x3480 */   0,  0,  0, 21,  0,  0,  0, 10,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3490 */   0,  0,  0,  0,  0,  0,  9,152,  0,  0,  0, 21,  0,  0,  0, 10,
/* 0x34a0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  9,204,
/* 0x34b0 */   0,  0,  0, 21,  0,  0,  0, 10,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x34c0 */   0,  0,  0,  0,  0,  0, 10,136,  0,  0,  0, 28,  0,  0,  0, 10,
/* 0x34d0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 10,156,
/* 0x34e0 */   0,  0,  0, 22,  0,  0,  0, 10,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x34f0 */   0,  0,  0,  0,  0,  0, 10,188,  0,  0,  0, 21,  0,  0,  0, 10,
/* 0x3500 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 10,204,
/* 0x3510 */   0,  0,  0, 37,  0,  0,  0, 10,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3520 */   0,  0,  0,  0,  0,  0, 10,248,  0,  0,  0, 19,  0,  0,  0, 10,
/* 0x3530 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 11,  8,
/* 0x3540 */   0,  0,  0, 16,  0,  0,  0, 10,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3550 */   0,  0,  0,  0,  0,  0, 11, 40,  0,  0,  0, 21,  0,  0,  0, 10,
/* 0x3560 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 11, 60,
/* 0x3570 */   0,  0,  0, 37,  0,  0,  0, 10,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3580 */   0,  0,  0,  0,  0,  0, 11, 92,  0,  0,  0, 31,  0,  0,  0, 10,
/* 0x3590 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 11,112,
/* 0x35a0 */   0,  0,  0, 33,  0,  0,  0, 10,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x35b0 */   0,  0,  0,  0,  0,  0, 11,152,  0,  0,  0, 21,  0,  0,  0, 10,
/* 0x35c0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 11,248,
/* 0x35d0 */   0,  0,  0, 21,  0,  0,  0, 10,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x35e0 */   0,  0,  0,  0,  0,  0, 12,180,  0,  0,  0, 17,  0,  0,  0, 10,
/* 0x35f0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 12,212,
/* 0x3600 */   0,  0,  0, 21,  0,  0,  0, 10,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3610 */   0,  0,  0,  0,  0,  0, 12,232,  0,  0,  0, 17,  0,  0,  0, 10,
/* 0x3620 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 13,124,
/* 0x3630 */   0,  0,  0, 15,  0,  0,  0, 10,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3640 */   0,  0,  0,  0,  0,  0, 13,228,  0,  0,  0, 35,  0,  0,  0, 10,
/* 0x3650 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 14,  0,
/* 0x3660 */   0,  0,  0, 25,  0,  0,  0, 10,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3670 */   0,  0,  0,  0,  0,  0, 14, 20,  0,  0,  0, 33,  0,  0,  0, 10,
/* 0x3680 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 14, 84,
/* 0x3690 */   0,  0,  0, 37,  0,  0,  0, 10,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x36a0 */   0,  0,  0,  0,  0,  0,  0, 96,  0,  0,  0,  1,  0,  0,  0, 10,
/* 0x36b0 */   0,  0,  0,  0,  0,  0,  0, 40,  0,  0,  0,  0,  0,  0,  0,200,
/* 0x36c0 */   0,  0,  0, 29,  0,  0,  0, 11,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x36d0 */   0,  0,  0,  0,  0,  0,  0,204,  0,  0,  0, 29,  0,  0,  0, 11,
/* 0x36e0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,160,
/* 0x36f0 */   0,  0,  0, 29,  0,  0,  0, 11,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3700 */   0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0,  2,  0,  0,  0, 11,
/* 0x3710 */   0,  0,  0,  0,  0,  0,  0, 48,  0, 46,115,121,109,116, 97, 98,
/* 0x3720 */   0, 46,115,116,114,116, 97, 98,  0, 46,115,104,115,116,114,116,
/* 0x3730 */  97, 98,  0, 46,114,101,108, 97, 46,116,101,120,116,  0, 83, 89,
/* 0x3740 */  83, 67, 65, 76, 76, 83,  0, 46,114,101,108, 97, 69, 88, 80, 95,
/* 0x3750 */  72, 69, 65, 68,  0, 69, 88, 80, 95, 84, 65, 73, 76,  0, 46,114,
/* 0x3760 */ 101,108, 97, 78, 82, 86, 50, 69,  0, 46,114,101,108, 97, 78, 82,
/* 0x3770 */  86, 50, 68,  0, 46,114,101,108, 97, 78, 82, 86, 50, 66,  0, 46,
/* 0x3780 */ 114,101,108, 97, 76, 90, 77, 65, 95, 68, 65, 73, 83, 89,  0, 76,
/* 0x3790 */  90, 77, 65, 95, 69, 76, 70, 48, 48,  0, 76, 90, 77, 65, 95, 68,
/* 0x37a0 */  69, 67, 51, 48,  0, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,  0,
/* 0x37b0 */  76, 90, 77, 65, 95, 68, 69, 67, 50, 48,  0,  0,  0,  0,  0,  0,
/* 0x37c0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x37d0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x37e0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x37f0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3800 */   0,  0,  0, 32,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  6,
/* 0x3810 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 64,
/* 0x3820 */   0,  0,  0,  0,  0,  0, 14,176,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3830 */   0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3840 */   0,  0,  0, 27,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0, 64,
/* 0x3850 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 50, 80,
/* 0x3860 */   0,  0,  0,  0,  0,  0,  4, 80,  0,  0,  0, 20,  0,  0,  0,  1,
/* 0x3870 */   0,  0,  0,  0,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0, 24,
/* 0x3880 */   0,  0,  0, 38,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3890 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 14,240,
/* 0x38a0 */   0,  0,  0,  0,  0,  0,  1, 64,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x38b0 */   0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x38c0 */   0,  0,  0, 52,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x38d0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 16, 48,
/* 0x38e0 */   0,  0,  0,  0,  0,  0,  0,168,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x38f0 */   0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3900 */   0,  0,  0, 47,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0, 64,
/* 0x3910 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 54,160,
/* 0x3920 */   0,  0,  0,  0,  0,  0,  0, 24,  0,  0,  0, 20,  0,  0,  0,  4,
/* 0x3930 */   0,  0,  0,  0,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0, 24,
/* 0x3940 */   0,  0,  0, 61,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3950 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 16,216,
/* 0x3960 */   0,  0,  0,  0,  0,  0,  0,140,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3970 */   0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3980 */   0,  0,  0, 75,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3990 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 17,100,
/* 0x39a0 */   0,  0,  0,  0,  0,  0,  1, 92,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x39b0 */   0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x39c0 */   0,  0,  0, 70,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0, 64,
/* 0x39d0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 54,184,
/* 0x39e0 */   0,  0,  0,  0,  0,  0,  0, 24,  0,  0,  0, 20,  0,  0,  0,  7,
/* 0x39f0 */   0,  0,  0,  0,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0, 24,
/* 0x3a00 */   0,  0,  0, 86,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3a10 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 18,192,
/* 0x3a20 */   0,  0,  0,  0,  0,  0,  1, 68,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3a30 */   0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3a40 */   0,  0,  0, 81,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0, 64,
/* 0x3a50 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 54,208,
/* 0x3a60 */   0,  0,  0,  0,  0,  0,  0, 24,  0,  0,  0, 20,  0,  0,  0,  9,
/* 0x3a70 */   0,  0,  0,  0,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0, 24,
/* 0x3a80 */   0,  0,  0, 97,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3a90 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 20,  4,
/* 0x3aa0 */   0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3ab0 */   0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3ac0 */   0,  0,  0, 92,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0, 64,
/* 0x3ad0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 54,232,
/* 0x3ae0 */   0,  0,  0,  0,  0,  0,  0, 24,  0,  0,  0, 20,  0,  0,  0, 11,
/* 0x3af0 */   0,  0,  0,  0,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0, 24,
/* 0x3b00 */   0,  0,  0,108,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3b10 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 21,  4,
/* 0x3b20 */   0,  0,  0,  0,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3b30 */   0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3b40 */   0,  0,  0,103,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0, 64,
/* 0x3b50 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 55,  0,
/* 0x3b60 */   0,  0,  0,  0,  0,  0,  0, 24,  0,  0,  0, 20,  0,  0,  0, 13,
/* 0x3b70 */   0,  0,  0,  0,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0, 24,
/* 0x3b80 */   0,  0,  0,119,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3b90 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 21, 12,
/* 0x3ba0 */   0,  0,  0,  0,  0,  0,  0,152,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3bb0 */   0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3bc0 */   0,  0,  0,130,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3bd0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 21,164,
/* 0x3be0 */   0,  0,  0,  0,  0,  0,  0, 48,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3bf0 */   0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3c00 */   0,  0,  0,141,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3c10 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 21,212,
/* 0x3c20 */   0,  0,  0,  0,  0,  0, 11,184,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3c30 */   0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3c40 */   0,  0,  0,152,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3c50 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 33,140,
/* 0x3c60 */   0,  0,  0,  0,  0,  0, 12,108,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3c70 */   0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3c80 */   0,  0,  0, 17,  0,  0,  0,  3,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3c90 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 55, 24,
/* 0x3ca0 */   0,  0,  0,  0,  0,  0,  0,163,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3cb0 */   0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3cc0 */   0,  0,  0,  1,  0,  0,  0,  2,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3cd0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 45,248,
/* 0x3ce0 */   0,  0,  0,  0,  0,  0,  3,144,  0,  0,  0, 21,  0,  0,  0, 13,
/* 0x3cf0 */   0,  0,  0,  0,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0, 24,
/* 0x3d00 */   0,  0,  0,  9,  0,  0,  0,  3,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3d10 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 49,136,
/* 0x3d20 */   0,  0,  0,  0,  0,  0,  0,196,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3d30 */   0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3d40 */ 102,105,108,101, 32,102,111,114,109, 97,116, 32,101,108,102, 54,
/* 0x3d50 */  52, 45,112,111,119,101,114,112, 99, 10, 10, 83,101, 99,116,105,
/* 0x3d60 */ 111,110,115, 58, 10, 73,100,120, 32, 78, 97,109,101, 32, 32, 32,
/* 0x3d70 */  32, 32, 32, 32, 32, 32, 32, 83,105,122,101, 32, 32, 32, 32, 32,
/* 0x3d80 */  32, 86, 77, 65, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3d90 */  32, 32, 32, 76, 77, 65, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3da0 */  32, 32, 32, 32, 32, 70,105,108,101, 32,111,102,102, 32, 32, 65,
/* 0x3db0 */ 108,103,110, 32, 32, 70,108, 97,103,115, 10, 32, 32, 48, 32, 46,
/* 0x3dc0 */ 116,101,120,116, 32, 32, 32, 32, 32, 32, 32, 32, 32, 48,101, 98,
/* 0x3dd0 */  48, 32, 32, 48, 32, 32, 48, 32, 32, 48, 52, 48, 32, 32, 50, 42,
/* 0x3de0 */  42, 50, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 49,
/* 0x3df0 */  32, 83, 89, 83, 67, 65, 76, 76, 83, 32, 32, 32, 32, 32, 32, 48,
/* 0x3e00 */  49, 52, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48,101,102, 48, 32,
/* 0x3e10 */  32, 50, 42, 42, 50, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x3e20 */  32, 32, 50, 32, 69, 88, 80, 95, 72, 69, 65, 68, 32, 32, 32, 32,
/* 0x3e30 */  32, 32, 48, 97, 56, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 48,
/* 0x3e40 */  51, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x3e50 */  84, 83, 10, 32, 32, 51, 32, 69, 88, 80, 95, 84, 65, 73, 76, 32,
/* 0x3e60 */  32, 32, 32, 32, 32, 48, 56, 99, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x3e70 */  48, 49, 48,100, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x3e80 */  84, 69, 78, 84, 83, 10, 32, 32, 52, 32, 78, 82, 86, 50, 69, 32,
/* 0x3e90 */  32, 32, 32, 32, 32, 32, 32, 32, 48, 49, 53, 99, 32, 32, 48, 32,
/* 0x3ea0 */  32, 48, 32, 32, 48, 49, 49, 54, 52, 32, 32, 50, 42, 42, 48, 32,
/* 0x3eb0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 53, 32, 78, 82,
/* 0x3ec0 */  86, 50, 68, 32, 32, 32, 32, 32, 32, 32, 32, 32, 48, 49, 52, 52,
/* 0x3ed0 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 50, 99, 48, 32, 32, 50,
/* 0x3ee0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32,
/* 0x3ef0 */  54, 32, 78, 82, 86, 50, 66, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3f00 */  48, 49, 48, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 52, 48,
/* 0x3f10 */  52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x3f20 */  83, 10, 32, 32, 55, 32, 76, 90, 77, 65, 95, 68, 65, 73, 83, 89,
/* 0x3f30 */  32, 32, 32, 32, 48, 56, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,
/* 0x3f40 */  53, 48, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x3f50 */  78, 84, 83, 10, 32, 32, 56, 32, 76, 90, 77, 65, 95, 69, 76, 70,
/* 0x3f60 */  48, 48, 32, 32, 32, 32, 48, 57, 56, 32, 32, 48, 32, 32, 48, 32,
/* 0x3f70 */  32, 48, 49, 53, 48, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x3f80 */  78, 84, 69, 78, 84, 83, 10, 32, 32, 57, 32, 76, 90, 77, 65, 95,
/* 0x3f90 */  68, 69, 67, 51, 48, 32, 32, 32, 32, 48, 51, 48, 32, 32, 48, 32,
/* 0x3fa0 */  32, 48, 32, 32, 48, 49, 53, 97, 52, 32, 32, 50, 42, 42, 48, 32,
/* 0x3fb0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 48, 32, 76, 90,
/* 0x3fc0 */  77, 65, 95, 68, 69, 67, 49, 48, 32, 32, 32, 32, 48, 98, 98, 56,
/* 0x3fd0 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 53,100, 52, 32, 32, 50,
/* 0x3fe0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49,
/* 0x3ff0 */  49, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 32, 32, 32, 32,
/* 0x4000 */  48, 99, 54, 99, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 49, 56,
/* 0x4010 */  99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x4020 */  83, 10, 83, 89, 77, 66, 79, 76, 32, 84, 65, 66, 76, 69, 58, 10,
/* 0x4030 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4040 */  32,108, 32, 32, 32, 32,100, 32, 32, 69, 88, 80, 95, 84, 65, 73,
/* 0x4050 */  76, 32, 48, 32, 69, 88, 80, 95, 84, 65, 73, 76, 10, 48, 48, 48,
/* 0x4060 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x4070 */  32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48,
/* 0x4080 */  32, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 10, 48, 48,
/* 0x4090 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x40a0 */  32, 32, 32, 32,100, 32, 32, 46,116,101,120,116, 32, 48, 32, 46,
/* 0x40b0 */ 116,101,120,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x40c0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 83, 89,
/* 0x40d0 */  83, 67, 65, 76, 76, 83, 32, 48, 32, 83, 89, 83, 67, 65, 76, 76,
/* 0x40e0 */  83, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x40f0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 69, 88, 80, 95, 72,
/* 0x4100 */  69, 65, 68, 32, 48, 32, 69, 88, 80, 95, 72, 69, 65, 68, 10, 48,
/* 0x4110 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4120 */ 108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50, 69, 32, 48, 32,
/* 0x4130 */  78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4140 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x4150 */  82, 86, 50, 68, 32, 48, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48,
/* 0x4160 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x4170 */  32, 32, 32,100, 32, 32, 78, 82, 86, 50, 66, 32, 48, 32, 78, 82,
/* 0x4180 */  86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4190 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77,
/* 0x41a0 */  65, 95, 68, 65, 73, 83, 89, 32, 48, 32, 76, 90, 77, 65, 95, 68,
/* 0x41b0 */  65, 73, 83, 89, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x41c0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90,
/* 0x41d0 */  77, 65, 95, 69, 76, 70, 48, 48, 32, 48, 32, 76, 90, 77, 65, 95,
/* 0x41e0 */  69, 76, 70, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x41f0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76,
/* 0x4200 */  90, 77, 65, 95, 68, 69, 67, 49, 48, 32, 48, 32, 76, 90, 77, 65,
/* 0x4210 */  95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4220 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x4230 */  76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 32, 48, 32, 76, 90, 77,
/* 0x4240 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4250 */  48, 48, 48, 48, 48, 48, 55, 52, 32,103, 32, 32, 32, 32, 32, 32,
/* 0x4260 */  32, 46,116,101,120,116, 32, 48, 32, 80,109, 97,112, 10, 48, 48,
/* 0x4270 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,103,
/* 0x4280 */  32, 32, 32, 32, 32, 70, 32, 69, 88, 80, 95, 72, 69, 65, 68, 32,
/* 0x4290 */  48, 32,102, 95,101,120,112, 97,110,100, 10, 48, 48, 48, 48, 48,
/* 0x42a0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 52, 32,103, 32, 32, 32,
/* 0x42b0 */  32, 32, 32, 32, 46,116,101,120,116, 32, 48, 32,103,101,116, 95,
/* 0x42c0 */ 112, 97,103,101, 95,109, 97,115,107, 10, 48, 48, 48, 48, 48, 48,
/* 0x42d0 */  48, 48, 48, 48, 48, 48, 48, 48, 50, 48, 32,103, 32, 32, 32, 32,
/* 0x42e0 */  32, 32, 32, 83, 89, 83, 67, 65, 76, 76, 83, 32, 48, 32,109,117,
/* 0x42f0 */ 110,109, 97,112, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4300 */  48, 48, 49, 49, 52, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 89,
/* 0x4310 */  83, 67, 65, 76, 76, 83, 32, 48, 32,109,101,109, 99,112,121, 10,
/* 0x4320 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 53, 48,
/* 0x4330 */  32,103, 32, 32, 32, 32, 32, 32, 32, 83, 89, 83, 67, 65, 76, 76,
/* 0x4340 */  83, 32, 48, 32,114,101, 97,100,108,105,110,107, 10, 48, 48, 48,
/* 0x4350 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 53, 48, 32,103, 32,
/* 0x4360 */  32, 32, 32, 32, 32, 32, 46,116,101,120,116, 32, 48, 32, 80,115,
/* 0x4370 */ 121,110, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4380 */  48, 48, 51, 56, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 89, 83,
/* 0x4390 */  67, 65, 76, 76, 83, 32, 48, 32,102,116,114,117,110, 99, 97,116,
/* 0x43a0 */ 101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x43b0 */  48, 56, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 89, 83, 67, 65,
/* 0x43c0 */  76, 76, 83, 32, 48, 32,109,109, 97,112, 10, 48, 48, 48, 48, 48,
/* 0x43d0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 53, 56, 32,103, 32, 32, 32,
/* 0x43e0 */  32, 32, 32, 32, 83, 89, 83, 67, 65, 76, 76, 83, 32, 48, 32,119,
/* 0x43f0 */ 114,105,116,101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4400 */  48, 48,100, 49, 56, 32,103, 32, 32, 32, 32, 32, 70, 32, 46,116,
/* 0x4410 */ 101,120,116, 32, 48, 49, 57, 56, 32,117,112,120, 95,109, 97,105,
/* 0x4420 */ 110, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4430 */  48,100, 48, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 89, 83, 67,
/* 0x4440 */  65, 76, 76, 83, 32, 48, 32,109,101,109,102,100, 95, 99,114,101,
/* 0x4450 */  97,116,101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4460 */  48, 48, 54, 48, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 89, 83,
/* 0x4470 */  67, 65, 76, 76, 83, 32, 48, 32,114,101, 97,100, 10, 48, 48, 48,
/* 0x4480 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 99, 56, 99, 32,103, 32,
/* 0x4490 */  32, 32, 32, 32, 70, 32, 46,116,101,120,116, 32, 48, 56, 99, 32,
/* 0x44a0 */ 117,110,100,101,114,108, 97,121, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x44b0 */  48, 48, 48, 48, 48, 48, 48, 51, 48, 32,103, 32, 32, 32, 32, 32,
/* 0x44c0 */  32, 32, 83, 89, 83, 67, 65, 76, 76, 83, 32, 48, 32,109,115,121,
/* 0x44d0 */ 110, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x44e0 */  48, 55, 56, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 89, 83, 67,
/* 0x44f0 */  65, 76, 76, 83, 32, 48, 32,117,112,120,102,100, 95, 99,114,101,
/* 0x4500 */  97,116,101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4510 */  48, 48, 48, 56, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 88, 80,
/* 0x4520 */  95, 84, 65, 73, 76, 32, 48, 32,101,111,102, 95,110,114,118, 10,
/* 0x4530 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 51, 56,
/* 0x4540 */  32,103, 32, 32, 32, 32, 32, 32, 32, 83, 89, 83, 67, 65, 76, 76,
/* 0x4550 */  83, 32, 48, 32,109,121, 95, 98,107,112,116, 10, 48, 48, 48, 48,
/* 0x4560 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 50, 99, 32,103, 32, 32,
/* 0x4570 */  32, 32, 32, 32, 32, 46,116,101,120,116, 32, 48, 32, 80,112,114,
/* 0x4580 */ 111,116,101, 99,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4590 */  48, 48, 48, 48, 57, 56, 32,103, 32, 32, 32, 32, 32, 32, 32, 46,
/* 0x45a0 */ 116,101,120,116, 32, 48, 32, 80,117,110,109, 97,112, 10, 48, 48,
/* 0x45b0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 52, 48, 32,103,
/* 0x45c0 */  32, 32, 32, 32, 32, 32, 32, 83, 89, 83, 67, 65, 76, 76, 83, 32,
/* 0x45d0 */  48, 32,101,120,105,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x45e0 */  48, 48, 48, 48, 48, 52, 56, 32,103, 32, 32, 32, 32, 32, 32, 32,
/* 0x45f0 */  83, 89, 83, 67, 65, 76, 76, 83, 32, 48, 32, 98,114,107, 10, 48,
/* 0x4600 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 54, 56, 32,
/* 0x4610 */ 103, 32, 32, 32, 32, 32, 32, 32, 83, 89, 83, 67, 65, 76, 76, 83,
/* 0x4620 */  32, 48, 32,111,112,101,110, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4630 */  48, 48, 48, 48, 48, 48, 50, 56, 32,103, 32, 32, 32, 32, 32, 32,
/* 0x4640 */  32, 83, 89, 83, 67, 65, 76, 76, 83, 32, 48, 32,109,112,114,111,
/* 0x4650 */ 116,101, 99,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4660 */  48, 48, 48, 55, 48, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 89,
/* 0x4670 */  83, 67, 65, 76, 76, 83, 32, 48, 32, 99,108,111,115,101, 10, 10,
/* 0x4680 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x4690 */  68, 83, 32, 70, 79, 82, 32, 91, 46,116,101,120,116, 93, 58, 10,
/* 0x46a0 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x46b0 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x46c0 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x46d0 */  48, 48, 48, 48, 48, 48, 48, 52, 99, 32, 82, 95, 80, 80, 67, 54,
/* 0x46e0 */  52, 95, 82, 69, 76, 50, 52, 32, 32, 32, 32, 32,109,112,114,111,
/* 0x46f0 */ 116,101, 99,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4700 */  48, 48, 48, 55, 48, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69,
/* 0x4710 */  76, 50, 52, 32, 32, 32, 32, 32,109,115,121,110, 99, 10, 48, 48,
/* 0x4720 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 57, 52, 32, 82,
/* 0x4730 */  95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 50, 52, 32, 32, 32, 32,
/* 0x4740 */  32,109,109, 97,112, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4750 */  48, 48, 48, 48, 98, 56, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82,
/* 0x4760 */  69, 76, 50, 52, 32, 32, 32, 32, 32,109,117,110,109, 97,112, 10,
/* 0x4770 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 53, 99,
/* 0x4780 */  32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 50, 52, 32, 32,
/* 0x4790 */  32, 32, 32,111,112,101,110, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x47a0 */  48, 48, 48, 48, 48, 49, 55, 48, 32, 82, 95, 80, 80, 67, 54, 52,
/* 0x47b0 */  95, 82, 69, 76, 50, 52, 32, 32, 32, 32, 32,114,101, 97,100,108,
/* 0x47c0 */ 105,110,107, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x47d0 */  48, 50, 49, 52, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76,
/* 0x47e0 */  50, 52, 32, 32, 32, 32, 32,117,112,120, 95,109, 97,105,110, 50,
/* 0x47f0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 50, 53,
/* 0x4800 */  52, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 50, 52, 32,
/* 0x4810 */  32, 32, 32, 32, 98,114,107, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4820 */  48, 48, 48, 48, 48, 50, 54, 48, 32, 82, 95, 80, 80, 67, 54, 52,
/* 0x4830 */  95, 82, 69, 76, 50, 52, 32, 32, 32, 32, 32,109,117,110,109, 97,
/* 0x4840 */ 112, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 50,
/* 0x4850 */  56, 56, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 50, 52,
/* 0x4860 */  32, 32, 32, 32, 32,109,109, 97,112, 10, 48, 48, 48, 48, 48, 48,
/* 0x4870 */  48, 48, 48, 48, 48, 48, 48, 50, 57, 48, 32, 82, 95, 80, 80, 67,
/* 0x4880 */  54, 52, 95, 82, 69, 76, 50, 52, 32, 32, 32, 32, 32, 99,108,111,
/* 0x4890 */ 115,101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x48a0 */  51, 54, 56, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 50,
/* 0x48b0 */  52, 32, 32, 32, 32, 32,101,120,105,116, 10, 48, 48, 48, 48, 48,
/* 0x48c0 */  48, 48, 48, 48, 48, 48, 48, 48, 52, 49, 56, 32, 82, 95, 80, 80,
/* 0x48d0 */  67, 54, 52, 95, 82, 69, 76, 50, 52, 32, 32, 32, 32, 32,101,120,
/* 0x48e0 */ 105,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x48f0 */  52, 98, 48, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 50,
/* 0x4900 */  52, 32, 32, 32, 32, 32,101,120,105,116, 10, 48, 48, 48, 48, 48,
/* 0x4910 */  48, 48, 48, 48, 48, 48, 48, 48, 52,101, 56, 32, 82, 95, 80, 80,
/* 0x4920 */  67, 54, 52, 95, 82, 69, 76, 50, 52, 32, 32, 32, 32, 32,102, 95,
/* 0x4930 */ 101,120,112, 97,110,100, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4940 */  48, 48, 48, 48, 54, 51, 52, 32, 82, 95, 80, 80, 67, 54, 52, 95,
/* 0x4950 */  82, 69, 76, 50, 52, 32, 32, 32, 32, 32,109,117,110,109, 97,112,
/* 0x4960 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 54, 53,
/* 0x4970 */  99, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 50, 52, 32,
/* 0x4980 */  32, 32, 32, 32,103,101,116, 95,112, 97,103,101, 95,109, 97,115,
/* 0x4990 */ 107, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 55,
/* 0x49a0 */  54, 52, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 50, 52,
/* 0x49b0 */  32, 32, 32, 32, 32,109,109, 97,112, 10, 48, 48, 48, 48, 48, 48,
/* 0x49c0 */  48, 48, 48, 48, 48, 48, 48, 55, 56, 56, 32, 82, 95, 80, 80, 67,
/* 0x49d0 */  54, 52, 95, 82, 69, 76, 50, 52, 32, 32, 32, 32, 32,109,117,110,
/* 0x49e0 */ 109, 97,112, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x49f0 */  48, 55, 97, 99, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76,
/* 0x4a00 */  50, 52, 32, 32, 32, 32, 32,109,117,110,109, 97,112, 10, 48, 48,
/* 0x4a10 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 55, 98, 56, 32, 82,
/* 0x4a20 */  95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 50, 52, 32, 32, 32, 32,
/* 0x4a30 */  32,103,101,116, 95,112, 97,103,101, 95,109, 97,115,107, 10, 48,
/* 0x4a40 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 57, 51, 56, 32,
/* 0x4a50 */  82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 50, 52, 32, 32, 32,
/* 0x4a60 */  32, 32,117,112,120,102,100, 95, 99,114,101, 97,116,101, 10, 48,
/* 0x4a70 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 57, 52, 56, 32,
/* 0x4a80 */  82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 50, 52, 32, 32, 32,
/* 0x4a90 */  32, 32,102,116,114,117,110, 99, 97,116,101, 10, 48, 48, 48, 48,
/* 0x4aa0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 57, 54, 56, 32, 82, 95, 80,
/* 0x4ab0 */  80, 67, 54, 52, 95, 82, 69, 76, 50, 52, 32, 32, 32, 32, 32,109,
/* 0x4ac0 */ 109, 97,112, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4ad0 */  48, 57, 57, 56, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76,
/* 0x4ae0 */  50, 52, 32, 32, 32, 32, 32,109,109, 97,112, 10, 48, 48, 48, 48,
/* 0x4af0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 57, 99, 99, 32, 82, 95, 80,
/* 0x4b00 */  80, 67, 54, 52, 95, 82, 69, 76, 50, 52, 32, 32, 32, 32, 32,109,
/* 0x4b10 */ 109, 97,112, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4b20 */  48, 97, 56, 56, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76,
/* 0x4b30 */  50, 52, 32, 32, 32, 32, 32,117,112,120,102,100, 95, 99,114,101,
/* 0x4b40 */  97,116,101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4b50 */  48, 97, 57, 99, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76,
/* 0x4b60 */  50, 52, 32, 32, 32, 32, 32,119,114,105,116,101, 10, 48, 48, 48,
/* 0x4b70 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 97, 98, 99, 32, 82, 95,
/* 0x4b80 */  80, 80, 67, 54, 52, 95, 82, 69, 76, 50, 52, 32, 32, 32, 32, 32,
/* 0x4b90 */ 109,109, 97,112, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4ba0 */  48, 48, 97, 99, 99, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69,
/* 0x4bb0 */  76, 50, 52, 32, 32, 32, 32, 32, 99,108,111,115,101, 10, 48, 48,
/* 0x4bc0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 97,102, 56, 32, 82,
/* 0x4bd0 */  95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 50, 52, 32, 32, 32, 32,
/* 0x4be0 */  32, 80,115,121,110, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4bf0 */  48, 48, 48, 48, 98, 48, 56, 32, 82, 95, 80, 80, 67, 54, 52, 95,
/* 0x4c00 */  82, 69, 76, 50, 52, 32, 32, 32, 32, 32,109,117,110,109, 97,112,
/* 0x4c10 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 98, 50,
/* 0x4c20 */  56, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 50, 52, 32,
/* 0x4c30 */  32, 32, 32, 32,109,109, 97,112, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4c40 */  48, 48, 48, 48, 48, 48, 98, 51, 99, 32, 82, 95, 80, 80, 67, 54,
/* 0x4c50 */  52, 95, 82, 69, 76, 50, 52, 32, 32, 32, 32, 32, 99,108,111,115,
/* 0x4c60 */ 101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 98,
/* 0x4c70 */  53, 99, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 50, 52,
/* 0x4c80 */  32, 32, 32, 32, 32, 80,112,114,111,116,101, 99,116, 10, 48, 48,
/* 0x4c90 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 98, 55, 48, 32, 82,
/* 0x4ca0 */  95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 50, 52, 32, 32, 32, 32,
/* 0x4cb0 */  32,101,120,105,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4cc0 */  48, 48, 48, 98, 57, 56, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82,
/* 0x4cd0 */  69, 76, 50, 52, 32, 32, 32, 32, 32,109,109, 97,112, 10, 48, 48,
/* 0x4ce0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 98,102, 56, 32, 82,
/* 0x4cf0 */  95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 50, 52, 32, 32, 32, 32,
/* 0x4d00 */  32,109,109, 97,112, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4d10 */  48, 48, 48, 99, 98, 52, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82,
/* 0x4d20 */  69, 76, 50, 52, 32, 32, 32, 32, 32,109,101,109, 99,112,121, 10,
/* 0x4d30 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 99,100, 52,
/* 0x4d40 */  32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 50, 52, 32, 32,
/* 0x4d50 */  32, 32, 32,109,109, 97,112, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4d60 */  48, 48, 48, 48, 48, 99,101, 56, 32, 82, 95, 80, 80, 67, 54, 52,
/* 0x4d70 */  95, 82, 69, 76, 50, 52, 32, 32, 32, 32, 32,109,101,109, 99,112,
/* 0x4d80 */ 121, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,100,
/* 0x4d90 */  55, 99, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 50, 52,
/* 0x4da0 */  32, 32, 32, 32, 32,103,101,116, 95,112, 97,103,101, 95,109, 97,
/* 0x4db0 */ 115,107, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4dc0 */ 100,101, 52, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 50,
/* 0x4dd0 */  52, 32, 32, 32, 32, 32,111,112,101,110, 10, 48, 48, 48, 48, 48,
/* 0x4de0 */  48, 48, 48, 48, 48, 48, 48, 48,101, 48, 48, 32, 82, 95, 80, 80,
/* 0x4df0 */  67, 54, 52, 95, 82, 69, 76, 50, 52, 32, 32, 32, 32, 32,114,101,
/* 0x4e00 */  97,100, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4e10 */ 101, 49, 52, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 50,
/* 0x4e20 */  52, 32, 32, 32, 32, 32,101,120,105,116, 10, 48, 48, 48, 48, 48,
/* 0x4e30 */  48, 48, 48, 48, 48, 48, 48, 48,101, 53, 52, 32, 82, 95, 80, 80,
/* 0x4e40 */  67, 54, 52, 95, 82, 69, 76, 50, 52, 32, 32, 32, 32, 32, 99,108,
/* 0x4e50 */ 111,115,101, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x4e60 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 69, 88, 80,
/* 0x4e70 */  95, 72, 69, 65, 68, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x4e80 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x4e90 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x4ea0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 54,
/* 0x4eb0 */  48, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 50, 52, 32,
/* 0x4ec0 */  32, 32, 32, 32, 69, 88, 80, 95, 84, 65, 73, 76, 43, 48,120, 48,
/* 0x4ed0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 50, 56, 10,
/* 0x4ee0 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x4ef0 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 50, 69, 93, 58,
/* 0x4f00 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4f10 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4f20 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x4f30 */  48, 48, 48, 48, 48, 48, 48, 48, 99, 56, 32, 82, 95, 80, 80, 67,
/* 0x4f40 */  54, 52, 95, 82, 69, 76, 49, 52, 32, 32, 32, 32, 32,101,111,102,
/* 0x4f50 */  95,110,114,118, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x4f60 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82,
/* 0x4f70 */  86, 50, 68, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32,
/* 0x4f80 */  32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x4f90 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x4fa0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 99, 99, 32,
/* 0x4fb0 */  82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 49, 52, 32, 32, 32,
/* 0x4fc0 */  32, 32,101,111,102, 95,110,114,118, 10, 10, 82, 69, 76, 79, 67,
/* 0x4fd0 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x4fe0 */  82, 32, 91, 78, 82, 86, 50, 66, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x4ff0 */  84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69,
/* 0x5000 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x5010 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x5020 */  48, 48, 97, 48, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76,
/* 0x5030 */  49, 52, 32, 32, 32, 32, 32,101,111,102, 95,110,114,118, 10, 10,
/* 0x5040 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x5050 */  68, 83, 32, 70, 79, 82, 32, 91, 76, 90, 77, 65, 95, 68, 65, 73,
/* 0x5060 */  83, 89, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32,
/* 0x5070 */  32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x5080 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x5090 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82,
/* 0x50a0 */  95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 49, 52, 32, 32, 32, 32,
/* 0x50b0 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 43, 48,120, 48, 48,
/* 0x50c0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 51, 48, 10
};
