/*
 * This file contains D-Bus client proxy classes generated by qt-client-gen.py.
 *
 * This file can be distributed under the same terms as the specification from
 * which it was generated.
 */

#ifndef IN_TP_QT_HEADER
#error IN_TP_QT_HEADER
#endif

#include <TelepathyQt/Types>

#include <QtGlobal>

#include <QString>
#include <QObject>
#include <QVariant>

#include <QDBusPendingReply>

#include <TelepathyQt/AbstractInterface>
#include <TelepathyQt/DBusProxy>
#include <TelepathyQt/Global>

namespace Tp
{
class PendingVariant;
class PendingOperation;
}

namespace Tp
{
namespace Client
{

/**
 * \class DebugInterface
 * \headerfile TelepathyQt/debug-receiver.h <TelepathyQt/DebugReceiver>
 * \ingroup clientdebug
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Debug".
 */
class TP_QT_EXPORT DebugInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Debug", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Debug");
    }

    /**
     * Creates a DebugInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    DebugInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a DebugInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    DebugInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a DebugInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    DebugInterface(Tp::DBusProxy *proxy);

    /**
     * Asynchronous getter for the remote object property \c Enabled of type \c bool.
     *
     * 
     * TRUE if the NewDebugMessage signal should be emitted when a new debug 
     * message is generated.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyEnabled() const
    {
        return internalRequestProperty(QLatin1String("Enabled"));
    }

    /**
     * Asynchronous setter for the remote object property \c Enabled of type \c bool.
     *
     * 
     * TRUE if the NewDebugMessage signal should be emitted when a new debug 
     * message is generated.
     *
     * \return A pending operation which will emit finished when the property has been
     *          set.
     */
    inline Tp::PendingOperation *setPropertyEnabled(bool newValue)
    {
        return internalSetProperty(QLatin1String("Enabled"), QVariant::fromValue(newValue));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c GetMessages on the remote object.
     * 
     * Retrieve buffered debug messages. An implementation could have a limit 
     * on how many message it keeps and so the array returned from this method 
     * should not be assumed to be all of the messages in the lifetime of the 
     * service.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     *
     * \return
     *     
     *     A list of debug messages.
     */
    inline QDBusPendingReply<Tp::DebugMessageList> GetMessages(int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<Tp::DebugMessageList>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("GetMessages"));
        return this->connection().asyncCall(callMessage, timeout);
    }

Q_SIGNALS:
    /**
     * Represents the signal \c NewDebugMessage on the remote object.
     * 
     * Emitted when a debug messages is generated if the Enabled property is 
     * set to TRUE.
     *
     * \param time
     *     
     *     Timestamp of the debug message.
     *
     * \param domain
     *     
     *     Domain of the debug message, as described in the Debug_Message 
     *     struct.
     *
     * \param level
     *     
     *     Level of the debug message.
     *
     * \param message
     *     
     *     The text of the debug message.
     */
    void NewDebugMessage(double time, const QString& domain, uint level, const QString& message);

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};
}
}
Q_DECLARE_METATYPE(Tp::Client::DebugInterface*)
