/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSWebKitNamedFlow.h"

#include "Event.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSEvent.h"
#include "JSEventListener.h"
#include "JSNode.h"
#include "JSNodeList.h"
#include "KURL.h"
#include "NameNodeList.h"
#include "NodeList.h"
#include "WebKitNamedFlow.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSWebKitNamedFlowTableValues[] =
{
    { "name", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitNamedFlowName), (intptr_t)0, NoIntrinsic },
    { "overset", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitNamedFlowOverset), (intptr_t)0, NoIntrinsic },
    { "firstEmptyRegionIndex", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitNamedFlowFirstEmptyRegionIndex), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitNamedFlowConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWebKitNamedFlowTable = { 9, 7, JSWebKitNamedFlowTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSWebKitNamedFlowConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWebKitNamedFlowConstructorTable = { 1, 0, JSWebKitNamedFlowConstructorTableValues, 0 };
const ClassInfo JSWebKitNamedFlowConstructor::s_info = { "WebKitNamedFlowConstructor", &Base::s_info, &JSWebKitNamedFlowConstructorTable, 0, CREATE_METHOD_TABLE(JSWebKitNamedFlowConstructor) };

JSWebKitNamedFlowConstructor::JSWebKitNamedFlowConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSWebKitNamedFlowConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSWebKitNamedFlowPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSWebKitNamedFlowConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSWebKitNamedFlowConstructor, JSDOMWrapper>(exec, &JSWebKitNamedFlowConstructorTable, jsCast<JSWebKitNamedFlowConstructor*>(cell), propertyName, slot);
}

bool JSWebKitNamedFlowConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSWebKitNamedFlowConstructor, JSDOMWrapper>(exec, &JSWebKitNamedFlowConstructorTable, jsCast<JSWebKitNamedFlowConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSWebKitNamedFlowPrototypeTableValues[] =
{
    { "getRegionsByContent", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsWebKitNamedFlowPrototypeFunctionGetRegionsByContent), (intptr_t)1, NoIntrinsic },
    { "getRegions", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsWebKitNamedFlowPrototypeFunctionGetRegions), (intptr_t)0, NoIntrinsic },
    { "getContent", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsWebKitNamedFlowPrototypeFunctionGetContent), (intptr_t)0, NoIntrinsic },
    { "addEventListener", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsWebKitNamedFlowPrototypeFunctionAddEventListener), (intptr_t)3, NoIntrinsic },
    { "removeEventListener", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsWebKitNamedFlowPrototypeFunctionRemoveEventListener), (intptr_t)3, NoIntrinsic },
    { "dispatchEvent", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsWebKitNamedFlowPrototypeFunctionDispatchEvent), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWebKitNamedFlowPrototypeTable = { 16, 15, JSWebKitNamedFlowPrototypeTableValues, 0 };
const ClassInfo JSWebKitNamedFlowPrototype::s_info = { "WebKitNamedFlowPrototype", &Base::s_info, &JSWebKitNamedFlowPrototypeTable, 0, CREATE_METHOD_TABLE(JSWebKitNamedFlowPrototype) };

JSObject* JSWebKitNamedFlowPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWebKitNamedFlow>(exec, globalObject);
}

bool JSWebKitNamedFlowPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSWebKitNamedFlowPrototype* thisObject = jsCast<JSWebKitNamedFlowPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSWebKitNamedFlowPrototypeTable, thisObject, propertyName, slot);
}

bool JSWebKitNamedFlowPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSWebKitNamedFlowPrototype* thisObject = jsCast<JSWebKitNamedFlowPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSWebKitNamedFlowPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSWebKitNamedFlow::s_info = { "WebKitNamedFlow", &Base::s_info, &JSWebKitNamedFlowTable, 0 , CREATE_METHOD_TABLE(JSWebKitNamedFlow) };

JSWebKitNamedFlow::JSWebKitNamedFlow(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<WebKitNamedFlow> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSWebKitNamedFlow::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSWebKitNamedFlow::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSWebKitNamedFlowPrototype::create(exec->globalData(), globalObject, JSWebKitNamedFlowPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

void JSWebKitNamedFlow::destroy(JSC::JSCell* cell)
{
    JSWebKitNamedFlow* thisObject = static_cast<JSWebKitNamedFlow*>(cell);
    thisObject->JSWebKitNamedFlow::~JSWebKitNamedFlow();
}

JSWebKitNamedFlow::~JSWebKitNamedFlow()
{
    releaseImplIfNotNull();
}

bool JSWebKitNamedFlow::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSWebKitNamedFlow* thisObject = jsCast<JSWebKitNamedFlow*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSWebKitNamedFlow, Base>(exec, &JSWebKitNamedFlowTable, thisObject, propertyName, slot);
}

bool JSWebKitNamedFlow::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSWebKitNamedFlow* thisObject = jsCast<JSWebKitNamedFlow*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSWebKitNamedFlow, Base>(exec, &JSWebKitNamedFlowTable, thisObject, propertyName, descriptor);
}

JSValue jsWebKitNamedFlowName(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWebKitNamedFlow* castedThis = jsCast<JSWebKitNamedFlow*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebKitNamedFlow* impl = static_cast<WebKitNamedFlow*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->name());
    return result;
}


JSValue jsWebKitNamedFlowOverset(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWebKitNamedFlow* castedThis = jsCast<JSWebKitNamedFlow*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebKitNamedFlow* impl = static_cast<WebKitNamedFlow*>(castedThis->impl());
    JSValue result = jsBoolean(impl->overset());
    return result;
}


JSValue jsWebKitNamedFlowFirstEmptyRegionIndex(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWebKitNamedFlow* castedThis = jsCast<JSWebKitNamedFlow*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebKitNamedFlow* impl = static_cast<WebKitNamedFlow*>(castedThis->impl());
    JSValue result = jsNumber(impl->firstEmptyRegionIndex());
    return result;
}


JSValue jsWebKitNamedFlowConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWebKitNamedFlow* domObject = jsCast<JSWebKitNamedFlow*>(asObject(slotBase));
    return JSWebKitNamedFlow::getConstructor(exec, domObject->globalObject());
}

JSValue JSWebKitNamedFlow::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebKitNamedFlowConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsWebKitNamedFlowPrototypeFunctionGetRegionsByContent(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSWebKitNamedFlow::s_info))
        return throwVMTypeError(exec);
    JSWebKitNamedFlow* castedThis = jsCast<JSWebKitNamedFlow*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSWebKitNamedFlow::s_info);
    WebKitNamedFlow* impl = static_cast<WebKitNamedFlow*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    Node* contentNode(toNode(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->getRegionsByContent(contentNode)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsWebKitNamedFlowPrototypeFunctionGetRegions(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSWebKitNamedFlow::s_info))
        return throwVMTypeError(exec);
    JSWebKitNamedFlow* castedThis = jsCast<JSWebKitNamedFlow*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSWebKitNamedFlow::s_info);
    WebKitNamedFlow* impl = static_cast<WebKitNamedFlow*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->getRegions()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsWebKitNamedFlowPrototypeFunctionGetContent(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSWebKitNamedFlow::s_info))
        return throwVMTypeError(exec);
    JSWebKitNamedFlow* castedThis = jsCast<JSWebKitNamedFlow*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSWebKitNamedFlow::s_info);
    WebKitNamedFlow* impl = static_cast<WebKitNamedFlow*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->getContent()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsWebKitNamedFlowPrototypeFunctionAddEventListener(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSWebKitNamedFlow::s_info))
        return throwVMTypeError(exec);
    JSWebKitNamedFlow* castedThis = jsCast<JSWebKitNamedFlow*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSWebKitNamedFlow::s_info);
    WebKitNamedFlow* impl = static_cast<WebKitNamedFlow*>(castedThis->impl());
    JSValue listener = exec->argument(1);
    if (!listener.isObject())
        return JSValue::encode(jsUndefined());
    impl->addEventListener(exec->argument(0).toString(exec)->value(exec), JSEventListener::create(asObject(listener), castedThis, false, currentWorld(exec)), exec->argument(2).toBoolean(exec));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebKitNamedFlowPrototypeFunctionRemoveEventListener(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSWebKitNamedFlow::s_info))
        return throwVMTypeError(exec);
    JSWebKitNamedFlow* castedThis = jsCast<JSWebKitNamedFlow*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSWebKitNamedFlow::s_info);
    WebKitNamedFlow* impl = static_cast<WebKitNamedFlow*>(castedThis->impl());
    JSValue listener = exec->argument(1);
    if (!listener.isObject())
        return JSValue::encode(jsUndefined());
    impl->removeEventListener(exec->argument(0).toString(exec)->value(exec), JSEventListener::create(asObject(listener), castedThis, false, currentWorld(exec)).get(), exec->argument(2).toBoolean(exec));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebKitNamedFlowPrototypeFunctionDispatchEvent(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSWebKitNamedFlow::s_info))
        return throwVMTypeError(exec);
    JSWebKitNamedFlow* castedThis = jsCast<JSWebKitNamedFlow*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSWebKitNamedFlow::s_info);
    WebKitNamedFlow* impl = static_cast<WebKitNamedFlow*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Event* event(toEvent(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->dispatchEvent(event, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

void JSWebKitNamedFlow::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    JSWebKitNamedFlow* thisObject = jsCast<JSWebKitNamedFlow*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    COMPILE_ASSERT(StructureFlags & OverridesVisitChildren, OverridesVisitChildrenWithoutSettingFlag);
    ASSERT(thisObject->structure()->typeInfo().overridesVisitChildren());
    Base::visitChildren(thisObject, visitor);
    thisObject->impl()->visitJSEventListeners(visitor);
}

static inline bool isObservable(JSWebKitNamedFlow* jsWebKitNamedFlow)
{
    if (jsWebKitNamedFlow->hasCustomProperties())
        return true;
    if (jsWebKitNamedFlow->impl()->hasEventListeners())
        return true;
    return false;
}

bool JSWebKitNamedFlowOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSWebKitNamedFlow* jsWebKitNamedFlow = jsCast<JSWebKitNamedFlow*>(handle.get().asCell());
    if (!isObservable(jsWebKitNamedFlow))
        return false;
    void* root = WebCore::root(jsWebKitNamedFlow->impl()->base());
    return visitor.containsOpaqueRoot(root);
}

void JSWebKitNamedFlowOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSWebKitNamedFlow* jsWebKitNamedFlow = jsCast<JSWebKitNamedFlow*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsWebKitNamedFlow->impl(), jsWebKitNamedFlow);
    jsWebKitNamedFlow->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, WebKitNamedFlow* impl)
{
    return wrap<JSWebKitNamedFlow>(exec, globalObject, impl);
}

WebKitNamedFlow* toWebKitNamedFlow(JSC::JSValue value)
{
    return value.inherits(&JSWebKitNamedFlow::s_info) ? jsCast<JSWebKitNamedFlow*>(asObject(value))->impl() : 0;
}

}
