/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.16
 *
 *     Copyright: (c) 2018 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"


        #include <wx/image.h>


PyDoc_STRVAR(doc_wxImageArray_append, "append(self, obj: Image)");

extern "C" {static PyObject *meth_wxImageArray_append(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImageArray_append(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxImage* obj;
         ::wxImageArray *sipCpp;

        static const char *sipKwdList[] = {
            sipName_obj,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxImageArray, &sipCpp, sipType_wxImage, &obj))
        {
        sipCpp->Add(*obj);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_ImageArray, sipName_append, doc_wxImageArray_append);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxImageArray_index, "index(self, obj: Image) -> int");

extern "C" {static PyObject *meth_wxImageArray_index(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxImageArray_index(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxImage* obj;
         ::wxImageArray *sipCpp;

        static const char *sipKwdList[] = {
            sipName_obj,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxImageArray, &sipCpp, sipType_wxImage, &obj))
        {
            int sipRes = 0;
            sipErrorState sipError = sipErrorNone;

        int idx = sipCpp->Index(*obj, false);
        if (idx == wxNOT_FOUND) {
            sipError = sipErrorFail;
            wxPyErr_SetString(PyExc_ValueError,
                              "sequence.index(x): x not in sequence");
            }
        sipRes = idx;

            if (sipError == sipErrorFail)
                return 0;

            if (sipError == sipErrorNone)
            {
            return SIPLong_FromLong(sipRes);
            }

            sipAddException(sipError, &sipParseErr);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_ImageArray, sipName_index, doc_wxImageArray_index);

    return SIP_NULLPTR;
}


extern "C" {static int slot_wxImageArray___contains__(PyObject *,PyObject *);}
static int slot_wxImageArray___contains__(PyObject *sipSelf,PyObject *sipArg)
{
     ::wxImageArray *sipCpp = reinterpret_cast< ::wxImageArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxImageArray));

    if (!sipCpp)
        return -1;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxImage* obj;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxImage, &obj))
        {
            int sipRes = 0;

        int idx = sipCpp->Index(*obj, false);
        sipRes = idx != wxNOT_FOUND;

            return sipRes;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_ImageArray, sipName___contains__, SIP_NULLPTR);

    return -1;
}


extern "C" {static PyObject *slot_wxImageArray___getitem__(PyObject *,PyObject *);}
static PyObject *slot_wxImageArray___getitem__(PyObject *sipSelf,PyObject *sipArg)
{
     ::wxImageArray *sipCpp = reinterpret_cast< ::wxImageArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxImageArray));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        long index;

        if (sipParseArgs(&sipParseErr, sipArg, "1l", &index))
        {
             ::wxImage*sipRes = 0;
            sipErrorState sipError = sipErrorNone;

            if (0 > index)
                index += sipCpp->GetCount();

            if ((index < sipCpp->GetCount()) && (0 <= index)) {
                sipRes = &sipCpp->Item(index);
            }
            else {
                wxPyErr_SetString(PyExc_IndexError, "sequence index out of range");
                sipError = sipErrorFail;
            }

            if (sipError == sipErrorFail)
                return 0;

            if (sipError == sipErrorNone)
            {
            return sipConvertFromType(sipRes,sipType_wxImage,SIP_NULLPTR);
            }

            sipAddException(sipError, &sipParseErr);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_ImageArray, sipName___getitem__, SIP_NULLPTR);

    return SIP_NULLPTR;
}


extern "C" {static SIP_SSIZE_T slot_wxImageArray___len__(PyObject *);}
static SIP_SSIZE_T slot_wxImageArray___len__(PyObject *sipSelf)
{
     ::wxImageArray *sipCpp = reinterpret_cast< ::wxImageArray *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxImageArray));

    if (!sipCpp)
        return 0;


    {
        {
            SIP_SSIZE_T sipRes = 0;

        sipRes = sipCpp->GetCount();

            return sipRes;
        }
    }

    return 0;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxImageArray(void *, int);}
static void release_wxImageArray(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxImageArray *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_wxImageArray(void *, SIP_SSIZE_T, void *);}
static void assign_wxImageArray(void *sipDst, SIP_SSIZE_T sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxImageArray *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxImageArray *>(sipSrc);
}


extern "C" {static void *array_wxImageArray(SIP_SSIZE_T);}
static void *array_wxImageArray(SIP_SSIZE_T sipNrElem)
{
    return new  ::wxImageArray[sipNrElem];
}


extern "C" {static void *copy_wxImageArray(const void *, SIP_SSIZE_T);}
static void *copy_wxImageArray(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new  ::wxImageArray(reinterpret_cast<const  ::wxImageArray *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxImageArray(sipSimpleWrapper *);}
static void dealloc_wxImageArray(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxImageArray(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxImageArray(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxImageArray(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxImageArray *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxImageArray();
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    {
        const  ::wxImageArray* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_wxImageArray, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxImageArray(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_wxImageArray[] = {
    {(void *)slot_wxImageArray___contains__, contains_slot},
    {(void *)slot_wxImageArray___getitem__, getitem_slot},
    {(void *)slot_wxImageArray___len__, len_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_wxImageArray[] = {
    {SIP_MLNAME_CAST(sipName_append), SIP_MLMETH_CAST(meth_wxImageArray_append), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImageArray_append)},
    {SIP_MLNAME_CAST(sipName_index), SIP_MLMETH_CAST(meth_wxImageArray_index), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxImageArray_index)}
};

PyDoc_STRVAR(doc_wxImageArray, "\1ImageArray()\n"
"ImageArray(ImageArray)");


sipClassTypeDef sipTypeDef__core_wxImageArray = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_CLASS,
        sipNameNr_wxImageArray,
        {SIP_NULLPTR},
        SIP_NULLPTR
    },
    {
        sipNameNr_ImageArray,
        {0, 0, 1},
        2, methods_wxImageArray,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxImageArray,
    -1,
    -1,
    SIP_NULLPTR,
    slots_wxImageArray,
    init_type_wxImageArray,
    SIP_NULLPTR,
    SIP_NULLPTR,
#if PY_MAJOR_VERSION >= 3
    SIP_NULLPTR,
    SIP_NULLPTR,
#else
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
#endif
    dealloc_wxImageArray,
    assign_wxImageArray,
    array_wxImageArray,
    copy_wxImageArray,
    release_wxImageArray,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR
};
