/*
 * This file was generated automatically by ExtUtils::ParseXS version 3.44 from the
 * contents of Bignum.xs. Do not edit this file, edit Bignum.xs instead.
 *
 *    ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "Bignum.xs"
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include <openssl/err.h>
#include <openssl/bn.h>

#define checkOpenSslCall( result ) if( ! ( result ) ) \
  croak( "OpenSSL error: %s", ERR_reason_error_string( ERR_get_error() ) );

typedef BIGNUM *Crypt__OpenSSL__Bignum;
typedef BN_CTX *Crypt__OpenSSL__Bignum__CTX;

SV* new_obj( void* obj )
{
    SV * tmp = sv_newmortal();
    sv_setref_pv(tmp, "Crypt::OpenSSL::Bignum", (void*)obj);
    return tmp;
}

BIGNUM* sv2bn( SV* sv )
{
    if (SvROK(sv) && sv_derived_from(sv, "Crypt::OpenSSL::Bignum")) {
        return INT2PTR(Crypt__OpenSSL__Bignum, SvIV((SV*)SvRV(sv)));
    }
    else Perl_croak(aTHX_ "argument is not a Crypt::OpenSSL::Bignum object");
}

#line 39 "Bignum.c"
#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef dVAR
#  define dVAR		dNOOP
#endif


/* This stuff is not part of the API! You have been warned. */
#ifndef PERL_VERSION_DECIMAL
#  define PERL_VERSION_DECIMAL(r,v,s) (r*1000000 + v*1000 + s)
#endif
#ifndef PERL_DECIMAL_VERSION
#  define PERL_DECIMAL_VERSION \
	  PERL_VERSION_DECIMAL(PERL_REVISION,PERL_VERSION,PERL_SUBVERSION)
#endif
#ifndef PERL_VERSION_GE
#  define PERL_VERSION_GE(r,v,s) \
	  (PERL_DECIMAL_VERSION >= PERL_VERSION_DECIMAL(r,v,s))
#endif
#ifndef PERL_VERSION_LE
#  define PERL_VERSION_LE(r,v,s) \
	  (PERL_DECIMAL_VERSION <= PERL_VERSION_DECIMAL(r,v,s))
#endif

/* XS_INTERNAL is the explicit static-linkage variant of the default
 * XS macro.
 *
 * XS_EXTERNAL is the same as XS_INTERNAL except it does not include
 * "STATIC", ie. it exports XSUB symbols. You probably don't want that
 * for anything but the BOOT XSUB.
 *
 * See XSUB.h in core!
 */


/* TODO: This might be compatible further back than 5.10.0. */
#if PERL_VERSION_GE(5, 10, 0) && PERL_VERSION_LE(5, 15, 1)
#  undef XS_EXTERNAL
#  undef XS_INTERNAL
#  if defined(__CYGWIN__) && defined(USE_DYNAMIC_LOADING)
#    define XS_EXTERNAL(name) __declspec(dllexport) XSPROTO(name)
#    define XS_INTERNAL(name) STATIC XSPROTO(name)
#  endif
#  if defined(__SYMBIAN32__)
#    define XS_EXTERNAL(name) EXPORT_C XSPROTO(name)
#    define XS_INTERNAL(name) EXPORT_C STATIC XSPROTO(name)
#  endif
#  ifndef XS_EXTERNAL
#    if defined(HASATTRIBUTE_UNUSED) && !defined(__cplusplus)
#      define XS_EXTERNAL(name) void name(pTHX_ CV* cv __attribute__unused__)
#      define XS_INTERNAL(name) STATIC void name(pTHX_ CV* cv __attribute__unused__)
#    else
#      ifdef __cplusplus
#        define XS_EXTERNAL(name) extern "C" XSPROTO(name)
#        define XS_INTERNAL(name) static XSPROTO(name)
#      else
#        define XS_EXTERNAL(name) XSPROTO(name)
#        define XS_INTERNAL(name) STATIC XSPROTO(name)
#      endif
#    endif
#  endif
#endif

/* perl >= 5.10.0 && perl <= 5.15.1 */


/* The XS_EXTERNAL macro is used for functions that must not be static
 * like the boot XSUB of a module. If perl didn't have an XS_EXTERNAL
 * macro defined, the best we can do is assume XS is the same.
 * Dito for XS_INTERNAL.
 */
#ifndef XS_EXTERNAL
#  define XS_EXTERNAL(name) XS(name)
#endif
#ifndef XS_INTERNAL
#  define XS_INTERNAL(name) XS(name)
#endif

/* Now, finally, after all this mess, we want an ExtUtils::ParseXS
 * internal macro that we're free to redefine for varying linkage due
 * to the EXPORT_XSUB_SYMBOLS XS keyword. This is internal, use
 * XS_EXTERNAL(name) or XS_INTERNAL(name) in your code if you need to!
 */

#undef XS_EUPXS
#if defined(PERL_EUPXS_ALWAYS_EXPORT)
#  define XS_EUPXS(name) XS_EXTERNAL(name)
#else
   /* default to internal */
#  define XS_EUPXS(name) XS_INTERNAL(name)
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
	    Perl_croak_nocontext("Usage: %s::%s(%s)", hvname, gvname, params);
        else
	    Perl_croak_nocontext("Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
	Perl_croak_nocontext("Usage: CODE(0x%" UVxf ")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#define croak_xs_usage        S_croak_xs_usage

#endif

/* NOTE: the prototype of newXSproto() is different in versions of perls,
 * so we define a portable version of newXSproto()
 */
#ifdef newXS_flags
#define newXSproto_portable(name, c_impl, file, proto) newXS_flags(name, c_impl, file, proto, 0)
#else
#define newXSproto_portable(name, c_impl, file, proto) (PL_Sv=(SV*)newXS(name, c_impl, file), sv_setpv(PL_Sv, proto), (CV*)PL_Sv)
#endif /* !defined(newXS_flags) */

#if PERL_VERSION_LE(5, 21, 5)
#  define newXS_deffile(a,b) Perl_newXS(aTHX_ a,b,file)
#else
#  define newXS_deffile(a,b) Perl_newXS_deffile(aTHX_ a,b)
#endif

#line 183 "Bignum.c"

XS_EUPXS(XS_Crypt__OpenSSL__Bignum_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__Bignum_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Crypt__OpenSSL__Bignum	self;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__OpenSSL__Bignum,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"Crypt::OpenSSL::Bignum::DESTROY",
			"self")
;
#line 41 "Bignum.xs"
        BN_clear_free( self );
#line 205 "Bignum.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Crypt__OpenSSL__Bignum_new_from_word); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__Bignum_new_from_word)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "CLASS, p_word");
    {
	unsigned long	p_word = (unsigned long)SvUV(ST(1))
;
#line 47 "Bignum.xs"
    BIGNUM* bn;
#line 222 "Bignum.c"
	Crypt__OpenSSL__Bignum	RETVAL;
#line 49 "Bignum.xs"
    checkOpenSslCall( bn = BN_new() );
    checkOpenSslCall( BN_set_word( bn, p_word ) );
    RETVAL = bn;
#line 228 "Bignum.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::OpenSSL::Bignum", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__Bignum_new_from_decimal); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__Bignum_new_from_decimal)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "CLASS, p_dec_string");
    {
	char*	p_dec_string = (char *)SvPV_nolen(ST(1))
;
#line 59 "Bignum.xs"
    BIGNUM* bn;
#line 251 "Bignum.c"
	Crypt__OpenSSL__Bignum	RETVAL;
#line 61 "Bignum.xs"
    bn = NULL;
    checkOpenSslCall( BN_dec2bn( &bn, p_dec_string ) );
    RETVAL = bn;
#line 257 "Bignum.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::OpenSSL::Bignum", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__Bignum_new_from_hex); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__Bignum_new_from_hex)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "CLASS, p_hex_string");
    {
	char*	p_hex_string = (char *)SvPV_nolen(ST(1))
;
#line 71 "Bignum.xs"
    BIGNUM* bn;
#line 280 "Bignum.c"
	Crypt__OpenSSL__Bignum	RETVAL;
#line 73 "Bignum.xs"
    bn = NULL;
    checkOpenSslCall( BN_hex2bn( &bn, p_hex_string ) );
    RETVAL = bn;
#line 286 "Bignum.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::OpenSSL::Bignum", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__Bignum_new_from_bin); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__Bignum_new_from_bin)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "CLASS, p_bin_string_SV");
    {
	SV*	p_bin_string_SV = ST(1)
;
#line 83 "Bignum.xs"
    BIGNUM* bn;
    unsigned char* bin;
    STRLEN bin_length;
#line 311 "Bignum.c"
	Crypt__OpenSSL__Bignum	RETVAL;
#line 87 "Bignum.xs"
    bin = (unsigned char*) SvPV( p_bin_string_SV, bin_length );
    checkOpenSslCall( bn = BN_bin2bn( bin, bin_length, NULL ) );
    RETVAL = bn;
#line 317 "Bignum.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::OpenSSL::Bignum", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__Bignum_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__Bignum_new)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "CLASS");
    {
#line 96 "Bignum.xs"
    BIGNUM* bn;
#line 338 "Bignum.c"
	Crypt__OpenSSL__Bignum	RETVAL;
#line 98 "Bignum.xs"
    checkOpenSslCall( bn = BN_new() );
    checkOpenSslCall( BN_set_word( bn, 0 ) );
    RETVAL = bn;
#line 344 "Bignum.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::OpenSSL::Bignum", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__Bignum_zero); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__Bignum_zero)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "CLASS");
    {
#line 107 "Bignum.xs"
    BIGNUM *bn;
#line 365 "Bignum.c"
	Crypt__OpenSSL__Bignum	RETVAL;
#line 109 "Bignum.xs"
    checkOpenSslCall( bn = BN_new() );
    checkOpenSslCall( BN_set_word( bn, 0 ) );
    RETVAL = bn;
#line 371 "Bignum.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::OpenSSL::Bignum", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__Bignum_one); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__Bignum_one)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "CLASS");
    {
#line 118 "Bignum.xs"
    BIGNUM *bn;
#line 392 "Bignum.c"
	Crypt__OpenSSL__Bignum	RETVAL;
#line 120 "Bignum.xs"
    checkOpenSslCall( bn = BN_new() );
    checkOpenSslCall( BN_one( bn ) );
    RETVAL = bn;
#line 398 "Bignum.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::OpenSSL::Bignum", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__Bignum_rand); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__Bignum_rand)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "CLASS, bits, top, bottom");
    {
#line 129 "Bignum.xs"
    BIGNUM* bn;
#line 419 "Bignum.c"
	Crypt__OpenSSL__Bignum	RETVAL;
	int	bits = (int)SvIV(ST(1))
;
	int	top = (int)SvIV(ST(2))
;
	int	bottom = (int)SvIV(ST(3))
;
#line 131 "Bignum.xs"
    checkOpenSslCall( bn = BN_new() );
    checkOpenSslCall( BN_rand( bn, bits, top, bottom) );
    RETVAL = bn;
#line 431 "Bignum.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::OpenSSL::Bignum", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__Bignum_pseudo_rand); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__Bignum_pseudo_rand)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "CLASS, bits, top, bottom");
    {
#line 140 "Bignum.xs"
    BIGNUM* bn;
#line 452 "Bignum.c"
	Crypt__OpenSSL__Bignum	RETVAL;
	int	bits = (int)SvIV(ST(1))
;
	int	top = (int)SvIV(ST(2))
;
	int	bottom = (int)SvIV(ST(3))
;
#line 142 "Bignum.xs"
    checkOpenSslCall( bn = BN_new() );
    checkOpenSslCall( BN_pseudo_rand( bn, bits, top, bottom) );
    RETVAL = bn;
#line 464 "Bignum.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::OpenSSL::Bignum", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__Bignum_rand_range); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__Bignum_rand_range)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "CLASS, r");
    {
#line 151 "Bignum.xs"
    BIGNUM* bn;
#line 485 "Bignum.c"
	Crypt__OpenSSL__Bignum	RETVAL;
	Crypt__OpenSSL__Bignum	r;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "Crypt::OpenSSL::Bignum")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    r = INT2PTR(Crypt__OpenSSL__Bignum,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::OpenSSL::Bignum::rand_range",
			"r", "Crypt::OpenSSL::Bignum",
			refstr, ST(1)
		);
	}
;
#line 153 "Bignum.xs"
    checkOpenSslCall( bn = BN_new() );
    checkOpenSslCall( BN_rand_range( bn, r) );
    RETVAL = bn;
#line 506 "Bignum.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::OpenSSL::Bignum", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__Bignum_bless_pointer); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__Bignum_bless_pointer)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "CLASS, pointer");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	void *	pointer = INT2PTR(void *,SvIV(ST(1)))
;
#line 162 "Bignum.xs"
    ST(0) = new_obj(pointer);
    XSRETURN(1);
#line 532 "Bignum.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__OpenSSL__Bignum_to_decimal); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__Bignum_to_decimal)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	char *	RETVAL;
	dXSTARG;
	Crypt__OpenSSL__Bignum	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::OpenSSL::Bignum")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__OpenSSL__Bignum,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::OpenSSL::Bignum::to_decimal",
			"self", "Crypt::OpenSSL::Bignum",
			refstr, ST(0)
		);
	}
;
#line 168 "Bignum.xs"
    checkOpenSslCall( RETVAL = BN_bn2dec( self ) );
#line 565 "Bignum.c"
	sv_setpv(TARG, RETVAL);
	XSprePUSH;
	PUSHTARG;
#line 172 "Bignum.xs"
    OPENSSL_free( RETVAL );
#line 571 "Bignum.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__Bignum_to_hex); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__Bignum_to_hex)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	char *	RETVAL;
	dXSTARG;
	Crypt__OpenSSL__Bignum	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::OpenSSL::Bignum")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__OpenSSL__Bignum,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::OpenSSL::Bignum::to_hex",
			"self", "Crypt::OpenSSL::Bignum",
			refstr, ST(0)
		);
	}
;
#line 177 "Bignum.xs"
    checkOpenSslCall( RETVAL = BN_bn2hex( self ) );
#line 603 "Bignum.c"
	sv_setpv(TARG, RETVAL);
	XSprePUSH;
	PUSHTARG;
#line 181 "Bignum.xs"
    OPENSSL_free( RETVAL );
#line 609 "Bignum.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__Bignum_to_bin); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__Bignum_to_bin)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
#line 186 "Bignum.xs"
    unsigned char* bin;
    int length;
#line 625 "Bignum.c"
	SV *	RETVAL;
	Crypt__OpenSSL__Bignum	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::OpenSSL::Bignum")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__OpenSSL__Bignum,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::OpenSSL::Bignum::to_bin",
			"self", "Crypt::OpenSSL::Bignum",
			refstr, ST(0)
		);
	}
;
#line 189 "Bignum.xs"
    length = BN_num_bytes( self );
    if (length>0) {
      RETVAL = NEWSV(0, length);
      SvPOK_only(RETVAL);
      SvCUR_set(RETVAL, length);
      bin = (unsigned char *)SvPV_nolen(RETVAL);
      BN_bn2bin( self, bin );
    }
    else {
      RETVAL = newSVpvn("", 0);
    }
#line 654 "Bignum.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__Bignum_get_word); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__Bignum_get_word)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	unsigned long	RETVAL;
	dXSTARG;
	Crypt__OpenSSL__Bignum	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::OpenSSL::Bignum")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__OpenSSL__Bignum,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::OpenSSL::Bignum::get_word",
			"self", "Crypt::OpenSSL::Bignum",
			refstr, ST(0)
		);
	}
;

	RETVAL = BN_get_word(self);
	XSprePUSH;
	PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__Bignum_is_zero); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__Bignum_is_zero)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	int	RETVAL;
	dXSTARG;
	Crypt__OpenSSL__Bignum	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::OpenSSL::Bignum")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__OpenSSL__Bignum,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::OpenSSL::Bignum::is_zero",
			"self", "Crypt::OpenSSL::Bignum",
			refstr, ST(0)
		);
	}
;

	RETVAL = BN_is_zero(self);
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__Bignum_is_one); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__Bignum_is_one)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	int	RETVAL;
	dXSTARG;
	Crypt__OpenSSL__Bignum	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::OpenSSL::Bignum")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__OpenSSL__Bignum,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::OpenSSL::Bignum::is_one",
			"self", "Crypt::OpenSSL::Bignum",
			refstr, ST(0)
		);
	}
;

	RETVAL = BN_is_one(self);
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__Bignum_is_odd); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__Bignum_is_odd)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	int	RETVAL;
	dXSTARG;
	Crypt__OpenSSL__Bignum	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::OpenSSL::Bignum")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__OpenSSL__Bignum,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::OpenSSL::Bignum::is_odd",
			"self", "Crypt::OpenSSL::Bignum",
			refstr, ST(0)
		);
	}
;

	RETVAL = BN_is_odd(self);
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__Bignum_add); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__Bignum_add)
{
    dVAR; dXSARGS;
    if (items < 2)
       croak_xs_usage(cv,  "self, b, ...");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 218 "Bignum.xs"
    BIGNUM *bn;
#line 805 "Bignum.c"
	Crypt__OpenSSL__Bignum	self;
	Crypt__OpenSSL__Bignum	b;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::OpenSSL::Bignum")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__OpenSSL__Bignum,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::OpenSSL::Bignum::add",
			"self", "Crypt::OpenSSL::Bignum",
			refstr, ST(0)
		);
	}
;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "Crypt::OpenSSL::Bignum")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    b = INT2PTR(Crypt__OpenSSL__Bignum,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::OpenSSL::Bignum::add",
			"b", "Crypt::OpenSSL::Bignum",
			refstr, ST(1)
		);
	}
;
#line 220 "Bignum.xs"
    if( items > 3 )
      croak( "usage: $bn->add( $bn2[, $target] )" );
    bn = ( items < 3 ) ? BN_new() : sv2bn( ST(2) );
    checkOpenSslCall( BN_add( bn, self, b ) );
    ST(0) = ( (items < 3 ) ? new_obj( bn ) : ST(2) );
    XSRETURN(1);
#line 843 "Bignum.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__OpenSSL__Bignum_sub); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__Bignum_sub)
{
    dVAR; dXSARGS;
    if (items < 2)
       croak_xs_usage(cv,  "self, b, ...");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 230 "Bignum.xs"
    BIGNUM *bn;
#line 861 "Bignum.c"
	Crypt__OpenSSL__Bignum	self;
	Crypt__OpenSSL__Bignum	b;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::OpenSSL::Bignum")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__OpenSSL__Bignum,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::OpenSSL::Bignum::sub",
			"self", "Crypt::OpenSSL::Bignum",
			refstr, ST(0)
		);
	}
;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "Crypt::OpenSSL::Bignum")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    b = INT2PTR(Crypt__OpenSSL__Bignum,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::OpenSSL::Bignum::sub",
			"b", "Crypt::OpenSSL::Bignum",
			refstr, ST(1)
		);
	}
;
#line 232 "Bignum.xs"
    if( items > 3 )
      croak( "usage: $bn->sub( $bn2[, $target] )" );
    bn = ( items < 3 ) ? BN_new() : sv2bn( ST(2) );
    checkOpenSslCall( BN_sub( bn, self, b ) );
    ST(0) = ( (items < 3 ) ? new_obj( bn ) : ST(2) );
    XSRETURN(1);
#line 899 "Bignum.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__OpenSSL__Bignum_mul); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__Bignum_mul)
{
    dVAR; dXSARGS;
    if (items < 3)
       croak_xs_usage(cv,  "self, b, ctx, ...");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__OpenSSL__Bignum	self;
	Crypt__OpenSSL__Bignum	b;
	Crypt__OpenSSL__Bignum__CTX	ctx;
#line 245 "Bignum.xs"
    BIGNUM* bn;
#line 920 "Bignum.c"

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::OpenSSL::Bignum")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__OpenSSL__Bignum,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::OpenSSL::Bignum::mul",
			"self", "Crypt::OpenSSL::Bignum",
			refstr, ST(0)
		);
	}
;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "Crypt::OpenSSL::Bignum")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    b = INT2PTR(Crypt__OpenSSL__Bignum,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::OpenSSL::Bignum::mul",
			"b", "Crypt::OpenSSL::Bignum",
			refstr, ST(1)
		);
	}
;

	if (SvROK(ST(2)) && sv_derived_from(ST(2), "Crypt::OpenSSL::Bignum::CTX")) {
	    IV tmp = SvIV((SV*)SvRV(ST(2)));
	    ctx = INT2PTR(Crypt__OpenSSL__Bignum__CTX,tmp);
	}
	else {
		const char* refstr = SvROK(ST(2)) ? "" : SvOK(ST(2)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::OpenSSL::Bignum::mul",
			"ctx", "Crypt::OpenSSL::Bignum::CTX",
			refstr, ST(2)
		);
	}
;
#line 247 "Bignum.xs"
    if( items > 4 )
      croak( "usage: $bn->mul( $bn2, $ctx, [, $target] )" );
    bn = ( items < 4 ) ? BN_new() : sv2bn( ST(3) );
    checkOpenSslCall( BN_mul( bn, self, b, ctx ) );
    ST(0) = ( (items < 4 ) ? new_obj( bn ) : ST(3) );
    XSRETURN(1);
#line 970 "Bignum.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__OpenSSL__Bignum_div); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__Bignum_div)
{
    dVAR; dXSARGS;
    if (items < 3)
       croak_xs_usage(cv,  "self, b, ctx, ...");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__OpenSSL__Bignum	self;
	Crypt__OpenSSL__Bignum	b;
	Crypt__OpenSSL__Bignum__CTX	ctx;
#line 260 "Bignum.xs"
    BIGNUM* quotient;
    BIGNUM* remainder;
#line 992 "Bignum.c"

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::OpenSSL::Bignum")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__OpenSSL__Bignum,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::OpenSSL::Bignum::div",
			"self", "Crypt::OpenSSL::Bignum",
			refstr, ST(0)
		);
	}
;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "Crypt::OpenSSL::Bignum")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    b = INT2PTR(Crypt__OpenSSL__Bignum,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::OpenSSL::Bignum::div",
			"b", "Crypt::OpenSSL::Bignum",
			refstr, ST(1)
		);
	}
;

	if (SvROK(ST(2)) && sv_derived_from(ST(2), "Crypt::OpenSSL::Bignum::CTX")) {
	    IV tmp = SvIV((SV*)SvRV(ST(2)));
	    ctx = INT2PTR(Crypt__OpenSSL__Bignum__CTX,tmp);
	}
	else {
		const char* refstr = SvROK(ST(2)) ? "" : SvOK(ST(2)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::OpenSSL::Bignum::div",
			"ctx", "Crypt::OpenSSL::Bignum::CTX",
			refstr, ST(2)
		);
	}
;
#line 263 "Bignum.xs"
    if( items > 5 )
      croak( "usage: $bn->div( $bn2, $ctx, [, $quotient [, $remainder ] ] )" );
    quotient = ( items < 4 ) ? BN_new() : sv2bn( ST(3) );
    remainder = ( items < 5 ) ? BN_new() : sv2bn( ST(4) );
    checkOpenSslCall( BN_div( quotient, remainder, self, b, ctx ) );
    ST(0) = ( (items < 4 ) ? new_obj( quotient ) : ST(3) );
    ST(1) = ( (items < 5 ) ? new_obj( remainder ) : ST(4) );
    XSRETURN(2);
#line 1044 "Bignum.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__OpenSSL__Bignum_sqr); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__Bignum_sqr)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, ctx");
    {
#line 275 "Bignum.xs"
    BIGNUM* bn;
#line 1060 "Bignum.c"
	Crypt__OpenSSL__Bignum	RETVAL;
	Crypt__OpenSSL__Bignum	self;
	Crypt__OpenSSL__Bignum__CTX	ctx;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::OpenSSL::Bignum")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__OpenSSL__Bignum,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::OpenSSL::Bignum::sqr",
			"self", "Crypt::OpenSSL::Bignum",
			refstr, ST(0)
		);
	}
;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "Crypt::OpenSSL::Bignum::CTX")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    ctx = INT2PTR(Crypt__OpenSSL__Bignum__CTX,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::OpenSSL::Bignum::sqr",
			"ctx", "Crypt::OpenSSL::Bignum::CTX",
			refstr, ST(1)
		);
	}
;
#line 277 "Bignum.xs"
    checkOpenSslCall( bn = BN_new() );
    checkOpenSslCall( BN_sqr( bn, self, ctx ) );
    RETVAL = bn;
#line 1096 "Bignum.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::OpenSSL::Bignum", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__Bignum_mod); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__Bignum_mod)
{
    dVAR; dXSARGS;
    if (items < 3)
       croak_xs_usage(cv,  "self, b, ctx, ...");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Crypt__OpenSSL__Bignum	self;
	Crypt__OpenSSL__Bignum	b;
	Crypt__OpenSSL__Bignum__CTX	ctx;
#line 289 "Bignum.xs"
    BIGNUM* bn;
#line 1122 "Bignum.c"

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::OpenSSL::Bignum")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__OpenSSL__Bignum,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::OpenSSL::Bignum::mod",
			"self", "Crypt::OpenSSL::Bignum",
			refstr, ST(0)
		);
	}
;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "Crypt::OpenSSL::Bignum")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    b = INT2PTR(Crypt__OpenSSL__Bignum,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::OpenSSL::Bignum::mod",
			"b", "Crypt::OpenSSL::Bignum",
			refstr, ST(1)
		);
	}
;

	if (SvROK(ST(2)) && sv_derived_from(ST(2), "Crypt::OpenSSL::Bignum::CTX")) {
	    IV tmp = SvIV((SV*)SvRV(ST(2)));
	    ctx = INT2PTR(Crypt__OpenSSL__Bignum__CTX,tmp);
	}
	else {
		const char* refstr = SvROK(ST(2)) ? "" : SvOK(ST(2)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::OpenSSL::Bignum::mod",
			"ctx", "Crypt::OpenSSL::Bignum::CTX",
			refstr, ST(2)
		);
	}
;
#line 291 "Bignum.xs"
    if( items > 4 )
      croak( "usage: $bn->mod( $bn2, $ctx, [, $target] )" );
    bn = ( items < 4 ) ? BN_new() : sv2bn( ST(3) );
    checkOpenSslCall( BN_mod( bn, self, b, ctx ) );
    ST(0) = ( (items < 4 ) ? new_obj( bn ) : ST(3) );
    XSRETURN(1);
#line 1172 "Bignum.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Crypt__OpenSSL__Bignum_mod_mul); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__Bignum_mod_mul)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "self, b, m, ctx");
    {
	Crypt__OpenSSL__Bignum	self;
	Crypt__OpenSSL__Bignum	b;
	Crypt__OpenSSL__Bignum	m;
	Crypt__OpenSSL__Bignum__CTX	ctx;
#line 305 "Bignum.xs"
    BIGNUM* bn;
#line 1192 "Bignum.c"
	Crypt__OpenSSL__Bignum	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::OpenSSL::Bignum")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__OpenSSL__Bignum,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::OpenSSL::Bignum::mod_mul",
			"self", "Crypt::OpenSSL::Bignum",
			refstr, ST(0)
		);
	}
;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "Crypt::OpenSSL::Bignum")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    b = INT2PTR(Crypt__OpenSSL__Bignum,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::OpenSSL::Bignum::mod_mul",
			"b", "Crypt::OpenSSL::Bignum",
			refstr, ST(1)
		);
	}
;

	if (SvROK(ST(2)) && sv_derived_from(ST(2), "Crypt::OpenSSL::Bignum")) {
	    IV tmp = SvIV((SV*)SvRV(ST(2)));
	    m = INT2PTR(Crypt__OpenSSL__Bignum,tmp);
	}
	else {
		const char* refstr = SvROK(ST(2)) ? "" : SvOK(ST(2)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::OpenSSL::Bignum::mod_mul",
			"m", "Crypt::OpenSSL::Bignum",
			refstr, ST(2)
		);
	}
;

	if (SvROK(ST(3)) && sv_derived_from(ST(3), "Crypt::OpenSSL::Bignum::CTX")) {
	    IV tmp = SvIV((SV*)SvRV(ST(3)));
	    ctx = INT2PTR(Crypt__OpenSSL__Bignum__CTX,tmp);
	}
	else {
		const char* refstr = SvROK(ST(3)) ? "" : SvOK(ST(3)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::OpenSSL::Bignum::mod_mul",
			"ctx", "Crypt::OpenSSL::Bignum::CTX",
			refstr, ST(3)
		);
	}
;
#line 307 "Bignum.xs"
    checkOpenSslCall( bn = BN_new() );
    checkOpenSslCall( BN_mod_mul( bn, self, b, m, ctx ) );
    RETVAL = bn;
#line 1254 "Bignum.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::OpenSSL::Bignum", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__Bignum_exp); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__Bignum_exp)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "self, exp, ctx");
    {
	Crypt__OpenSSL__Bignum	self;
	Crypt__OpenSSL__Bignum	exp;
	Crypt__OpenSSL__Bignum__CTX	ctx;
#line 319 "Bignum.xs"
    BIGNUM* bn;
#line 1278 "Bignum.c"
	Crypt__OpenSSL__Bignum	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::OpenSSL::Bignum")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__OpenSSL__Bignum,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::OpenSSL::Bignum::exp",
			"self", "Crypt::OpenSSL::Bignum",
			refstr, ST(0)
		);
	}
;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "Crypt::OpenSSL::Bignum")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    exp = INT2PTR(Crypt__OpenSSL__Bignum,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::OpenSSL::Bignum::exp",
			"exp", "Crypt::OpenSSL::Bignum",
			refstr, ST(1)
		);
	}
;

	if (SvROK(ST(2)) && sv_derived_from(ST(2), "Crypt::OpenSSL::Bignum::CTX")) {
	    IV tmp = SvIV((SV*)SvRV(ST(2)));
	    ctx = INT2PTR(Crypt__OpenSSL__Bignum__CTX,tmp);
	}
	else {
		const char* refstr = SvROK(ST(2)) ? "" : SvOK(ST(2)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::OpenSSL::Bignum::exp",
			"ctx", "Crypt::OpenSSL::Bignum::CTX",
			refstr, ST(2)
		);
	}
;
#line 321 "Bignum.xs"
    checkOpenSslCall( bn = BN_new() );
    checkOpenSslCall( BN_exp( bn, self, exp, ctx ) );
    RETVAL = bn;
#line 1326 "Bignum.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::OpenSSL::Bignum", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__Bignum_mod_exp); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__Bignum_mod_exp)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "self, exp, mod, ctx");
    {
	Crypt__OpenSSL__Bignum	self;
	Crypt__OpenSSL__Bignum	exp;
	Crypt__OpenSSL__Bignum	mod;
	Crypt__OpenSSL__Bignum__CTX	ctx;
#line 334 "Bignum.xs"
    BIGNUM* bn;
#line 1351 "Bignum.c"
	Crypt__OpenSSL__Bignum	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::OpenSSL::Bignum")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__OpenSSL__Bignum,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::OpenSSL::Bignum::mod_exp",
			"self", "Crypt::OpenSSL::Bignum",
			refstr, ST(0)
		);
	}
;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "Crypt::OpenSSL::Bignum")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    exp = INT2PTR(Crypt__OpenSSL__Bignum,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::OpenSSL::Bignum::mod_exp",
			"exp", "Crypt::OpenSSL::Bignum",
			refstr, ST(1)
		);
	}
;

	if (SvROK(ST(2)) && sv_derived_from(ST(2), "Crypt::OpenSSL::Bignum")) {
	    IV tmp = SvIV((SV*)SvRV(ST(2)));
	    mod = INT2PTR(Crypt__OpenSSL__Bignum,tmp);
	}
	else {
		const char* refstr = SvROK(ST(2)) ? "" : SvOK(ST(2)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::OpenSSL::Bignum::mod_exp",
			"mod", "Crypt::OpenSSL::Bignum",
			refstr, ST(2)
		);
	}
;

	if (SvROK(ST(3)) && sv_derived_from(ST(3), "Crypt::OpenSSL::Bignum::CTX")) {
	    IV tmp = SvIV((SV*)SvRV(ST(3)));
	    ctx = INT2PTR(Crypt__OpenSSL__Bignum__CTX,tmp);
	}
	else {
		const char* refstr = SvROK(ST(3)) ? "" : SvOK(ST(3)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::OpenSSL::Bignum::mod_exp",
			"ctx", "Crypt::OpenSSL::Bignum::CTX",
			refstr, ST(3)
		);
	}
;
#line 336 "Bignum.xs"
    checkOpenSslCall( bn = BN_new() );
    checkOpenSslCall( BN_mod_exp( bn, self, exp, mod, ctx ) );
    RETVAL = bn;
#line 1413 "Bignum.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::OpenSSL::Bignum", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__Bignum_mod_inverse); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__Bignum_mod_inverse)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "self, n, ctx");
    {
	Crypt__OpenSSL__Bignum	self;
	Crypt__OpenSSL__Bignum	n;
	Crypt__OpenSSL__Bignum__CTX	ctx;
#line 348 "Bignum.xs"
    BIGNUM* bn;
#line 1437 "Bignum.c"
	Crypt__OpenSSL__Bignum	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::OpenSSL::Bignum")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__OpenSSL__Bignum,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::OpenSSL::Bignum::mod_inverse",
			"self", "Crypt::OpenSSL::Bignum",
			refstr, ST(0)
		);
	}
;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "Crypt::OpenSSL::Bignum")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    n = INT2PTR(Crypt__OpenSSL__Bignum,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::OpenSSL::Bignum::mod_inverse",
			"n", "Crypt::OpenSSL::Bignum",
			refstr, ST(1)
		);
	}
;

	if (SvROK(ST(2)) && sv_derived_from(ST(2), "Crypt::OpenSSL::Bignum::CTX")) {
	    IV tmp = SvIV((SV*)SvRV(ST(2)));
	    ctx = INT2PTR(Crypt__OpenSSL__Bignum__CTX,tmp);
	}
	else {
		const char* refstr = SvROK(ST(2)) ? "" : SvOK(ST(2)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::OpenSSL::Bignum::mod_inverse",
			"ctx", "Crypt::OpenSSL::Bignum::CTX",
			refstr, ST(2)
		);
	}
;
#line 350 "Bignum.xs"
    checkOpenSslCall( bn = BN_new() );
    checkOpenSslCall( BN_mod_inverse( bn, self, n, ctx ) );
    RETVAL = bn;
#line 1485 "Bignum.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::OpenSSL::Bignum", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__Bignum_gcd); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__Bignum_gcd)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "self, b, ctx");
    {
	Crypt__OpenSSL__Bignum	self;
	Crypt__OpenSSL__Bignum	b;
	Crypt__OpenSSL__Bignum__CTX	ctx;
#line 362 "Bignum.xs"
    BIGNUM* bn;
#line 1509 "Bignum.c"
	Crypt__OpenSSL__Bignum	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::OpenSSL::Bignum")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__OpenSSL__Bignum,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::OpenSSL::Bignum::gcd",
			"self", "Crypt::OpenSSL::Bignum",
			refstr, ST(0)
		);
	}
;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "Crypt::OpenSSL::Bignum")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    b = INT2PTR(Crypt__OpenSSL__Bignum,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::OpenSSL::Bignum::gcd",
			"b", "Crypt::OpenSSL::Bignum",
			refstr, ST(1)
		);
	}
;

	if (SvROK(ST(2)) && sv_derived_from(ST(2), "Crypt::OpenSSL::Bignum::CTX")) {
	    IV tmp = SvIV((SV*)SvRV(ST(2)));
	    ctx = INT2PTR(Crypt__OpenSSL__Bignum__CTX,tmp);
	}
	else {
		const char* refstr = SvROK(ST(2)) ? "" : SvOK(ST(2)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::OpenSSL::Bignum::gcd",
			"ctx", "Crypt::OpenSSL::Bignum::CTX",
			refstr, ST(2)
		);
	}
;
#line 364 "Bignum.xs"
    checkOpenSslCall( bn = BN_new() );
    checkOpenSslCall( BN_gcd( bn, self, b, ctx ) );
    RETVAL = bn;
#line 1557 "Bignum.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::OpenSSL::Bignum", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__Bignum_equals); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__Bignum_equals)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, b");
    {
	int	RETVAL;
	dXSTARG;
	Crypt__OpenSSL__Bignum	self;
	Crypt__OpenSSL__Bignum	b;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::OpenSSL::Bignum")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__OpenSSL__Bignum,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::OpenSSL::Bignum::equals",
			"self", "Crypt::OpenSSL::Bignum",
			refstr, ST(0)
		);
	}
;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "Crypt::OpenSSL::Bignum")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    b = INT2PTR(Crypt__OpenSSL__Bignum,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::OpenSSL::Bignum::equals",
			"b", "Crypt::OpenSSL::Bignum",
			refstr, ST(1)
		);
	}
;
#line 373 "Bignum.xs"
    RETVAL = BN_cmp(self, b) == 0 ? 1 : 0;
#line 1610 "Bignum.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__Bignum_cmp); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__Bignum_cmp)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, b");
    {
	int	RETVAL;
	dXSTARG;
	Crypt__OpenSSL__Bignum	self;
	Crypt__OpenSSL__Bignum	b;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::OpenSSL::Bignum")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__OpenSSL__Bignum,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::OpenSSL::Bignum::cmp",
			"self", "Crypt::OpenSSL::Bignum",
			refstr, ST(0)
		);
	}
;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "Crypt::OpenSSL::Bignum")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    b = INT2PTR(Crypt__OpenSSL__Bignum,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::OpenSSL::Bignum::cmp",
			"b", "Crypt::OpenSSL::Bignum",
			refstr, ST(1)
		);
	}
;

	RETVAL = BN_cmp(self, b);
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__Bignum_num_bits); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__Bignum_num_bits)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	int	RETVAL;
	dXSTARG;
	Crypt__OpenSSL__Bignum	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::OpenSSL::Bignum")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__OpenSSL__Bignum,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::OpenSSL::Bignum::num_bits",
			"self", "Crypt::OpenSSL::Bignum",
			refstr, ST(0)
		);
	}
;

	RETVAL = BN_num_bits(self);
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__Bignum_num_bytes); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__Bignum_num_bytes)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	int	RETVAL;
	dXSTARG;
	Crypt__OpenSSL__Bignum	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::OpenSSL::Bignum")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__OpenSSL__Bignum,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::OpenSSL::Bignum::num_bytes",
			"self", "Crypt::OpenSSL::Bignum",
			refstr, ST(0)
		);
	}
;

	RETVAL = BN_num_bytes(self);
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__Bignum_rshift); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__Bignum_rshift)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, n");
    {
#line 389 "Bignum.xs"
    BIGNUM* bn;
#line 1741 "Bignum.c"
	Crypt__OpenSSL__Bignum	RETVAL;
	Crypt__OpenSSL__Bignum	self;
	int	n = (int)SvIV(ST(1))
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::OpenSSL::Bignum")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__OpenSSL__Bignum,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::OpenSSL::Bignum::rshift",
			"self", "Crypt::OpenSSL::Bignum",
			refstr, ST(0)
		);
	}
;
#line 391 "Bignum.xs"
    checkOpenSslCall( bn = BN_new() );
    checkOpenSslCall( BN_rshift( bn, self, n ) );
    RETVAL = bn;
#line 1764 "Bignum.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::OpenSSL::Bignum", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__Bignum_lshift); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__Bignum_lshift)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, n");
    {
#line 400 "Bignum.xs"
    BIGNUM* bn;
#line 1785 "Bignum.c"
	Crypt__OpenSSL__Bignum	RETVAL;
	Crypt__OpenSSL__Bignum	self;
	int	n = (int)SvIV(ST(1))
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::OpenSSL::Bignum")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__OpenSSL__Bignum,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::OpenSSL::Bignum::lshift",
			"self", "Crypt::OpenSSL::Bignum",
			refstr, ST(0)
		);
	}
;
#line 402 "Bignum.xs"
    checkOpenSslCall( bn = BN_new() );
    checkOpenSslCall( BN_lshift( bn, self, n ) );
    RETVAL = bn;
#line 1808 "Bignum.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::OpenSSL::Bignum", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__Bignum_ucmp); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__Bignum_ucmp)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, b");
    {
	int	RETVAL;
	dXSTARG;
	Crypt__OpenSSL__Bignum	self;
	Crypt__OpenSSL__Bignum	b;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::OpenSSL::Bignum")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__OpenSSL__Bignum,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::OpenSSL::Bignum::ucmp",
			"self", "Crypt::OpenSSL::Bignum",
			refstr, ST(0)
		);
	}
;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "Crypt::OpenSSL::Bignum")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    b = INT2PTR(Crypt__OpenSSL__Bignum,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::OpenSSL::Bignum::ucmp",
			"b", "Crypt::OpenSSL::Bignum",
			refstr, ST(1)
		);
	}
;

	RETVAL = BN_ucmp(self, b);
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__Bignum_swap); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__Bignum_swap)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, b");
    {
	Crypt__OpenSSL__Bignum	self;
	Crypt__OpenSSL__Bignum	b;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::OpenSSL::Bignum")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__OpenSSL__Bignum,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::OpenSSL::Bignum::swap",
			"self", "Crypt::OpenSSL::Bignum",
			refstr, ST(0)
		);
	}
;

	if (SvROK(ST(1)) && sv_derived_from(ST(1), "Crypt::OpenSSL::Bignum")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    b = INT2PTR(Crypt__OpenSSL__Bignum,tmp);
	}
	else {
		const char* refstr = SvROK(ST(1)) ? "" : SvOK(ST(1)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::OpenSSL::Bignum::swap",
			"b", "Crypt::OpenSSL::Bignum",
			refstr, ST(1)
		);
	}
;

	BN_swap(self, b);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Crypt__OpenSSL__Bignum_copy); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__Bignum_copy)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Crypt__OpenSSL__Bignum	RETVAL;
	Crypt__OpenSSL__Bignum	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::OpenSSL::Bignum")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__OpenSSL__Bignum,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::OpenSSL::Bignum::copy",
			"self", "Crypt::OpenSSL::Bignum",
			refstr, ST(0)
		);
	}
;
#line 417 "Bignum.xs"
    checkOpenSslCall( RETVAL = BN_dup(self) );
#line 1937 "Bignum.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::OpenSSL::Bignum", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__Bignum_pointer_copy); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__Bignum_pointer_copy)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	IV	RETVAL;
	dXSTARG;
	Crypt__OpenSSL__Bignum	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Crypt::OpenSSL::Bignum")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__OpenSSL__Bignum,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Crypt::OpenSSL::Bignum::pointer_copy",
			"self", "Crypt::OpenSSL::Bignum",
			refstr, ST(0)
		);
	}
;
#line 424 "Bignum.xs"
    checkOpenSslCall( RETVAL = PTR2IV(BN_dup(self)) );
#line 1975 "Bignum.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__Bignum__CTX_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__Bignum__CTX_new)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "CLASS");
    {
	Crypt__OpenSSL__Bignum__CTX	RETVAL;
#line 433 "Bignum.xs"
        RETVAL = BN_CTX_new();
#line 1993 "Bignum.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Crypt::OpenSSL::Bignum::CTX", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__Bignum__CTX_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__Bignum__CTX_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Crypt__OpenSSL__Bignum__CTX	self;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Crypt__OpenSSL__Bignum__CTX,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"Crypt::OpenSSL::Bignum::CTX::DESTROY",
			"self")
;
#line 440 "Bignum.xs"
        BN_CTX_free(self);
#line 2025 "Bignum.c"
    }
    XSRETURN_EMPTY;
}

#ifdef __cplusplus
extern "C"
#endif
XS_EXTERNAL(boot_Crypt__OpenSSL__Bignum); /* prototype to pass -Wmissing-prototypes */
XS_EXTERNAL(boot_Crypt__OpenSSL__Bignum)
{
#if PERL_VERSION_LE(5, 21, 5)
    dVAR; dXSARGS;
#else
    dVAR; dXSBOOTARGSXSAPIVERCHK;
#endif
#if PERL_VERSION_LE(5, 8, 999) /* PERL_VERSION_LT is 5.33+ */
    char* file = __FILE__;
#else
    const char* file = __FILE__;
#endif

    PERL_UNUSED_VAR(file);

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
#if PERL_VERSION_LE(5, 21, 5)
    XS_VERSION_BOOTCHECK;
#  ifdef XS_APIVERSION_BOOTCHECK
    XS_APIVERSION_BOOTCHECK;
#  endif
#endif

        newXS_deffile("Crypt::OpenSSL::Bignum::DESTROY", XS_Crypt__OpenSSL__Bignum_DESTROY);
        newXS_deffile("Crypt::OpenSSL::Bignum::new_from_word", XS_Crypt__OpenSSL__Bignum_new_from_word);
        newXS_deffile("Crypt::OpenSSL::Bignum::new_from_decimal", XS_Crypt__OpenSSL__Bignum_new_from_decimal);
        newXS_deffile("Crypt::OpenSSL::Bignum::new_from_hex", XS_Crypt__OpenSSL__Bignum_new_from_hex);
        newXS_deffile("Crypt::OpenSSL::Bignum::new_from_bin", XS_Crypt__OpenSSL__Bignum_new_from_bin);
        newXS_deffile("Crypt::OpenSSL::Bignum::new", XS_Crypt__OpenSSL__Bignum_new);
        newXS_deffile("Crypt::OpenSSL::Bignum::zero", XS_Crypt__OpenSSL__Bignum_zero);
        newXS_deffile("Crypt::OpenSSL::Bignum::one", XS_Crypt__OpenSSL__Bignum_one);
        newXS_deffile("Crypt::OpenSSL::Bignum::rand", XS_Crypt__OpenSSL__Bignum_rand);
        newXS_deffile("Crypt::OpenSSL::Bignum::pseudo_rand", XS_Crypt__OpenSSL__Bignum_pseudo_rand);
        newXS_deffile("Crypt::OpenSSL::Bignum::rand_range", XS_Crypt__OpenSSL__Bignum_rand_range);
        newXS_deffile("Crypt::OpenSSL::Bignum::bless_pointer", XS_Crypt__OpenSSL__Bignum_bless_pointer);
        newXS_deffile("Crypt::OpenSSL::Bignum::to_decimal", XS_Crypt__OpenSSL__Bignum_to_decimal);
        newXS_deffile("Crypt::OpenSSL::Bignum::to_hex", XS_Crypt__OpenSSL__Bignum_to_hex);
        newXS_deffile("Crypt::OpenSSL::Bignum::to_bin", XS_Crypt__OpenSSL__Bignum_to_bin);
        newXS_deffile("Crypt::OpenSSL::Bignum::get_word", XS_Crypt__OpenSSL__Bignum_get_word);
        newXS_deffile("Crypt::OpenSSL::Bignum::is_zero", XS_Crypt__OpenSSL__Bignum_is_zero);
        newXS_deffile("Crypt::OpenSSL::Bignum::is_one", XS_Crypt__OpenSSL__Bignum_is_one);
        newXS_deffile("Crypt::OpenSSL::Bignum::is_odd", XS_Crypt__OpenSSL__Bignum_is_odd);
        newXS_deffile("Crypt::OpenSSL::Bignum::add", XS_Crypt__OpenSSL__Bignum_add);
        newXS_deffile("Crypt::OpenSSL::Bignum::sub", XS_Crypt__OpenSSL__Bignum_sub);
        newXS_deffile("Crypt::OpenSSL::Bignum::mul", XS_Crypt__OpenSSL__Bignum_mul);
        newXS_deffile("Crypt::OpenSSL::Bignum::div", XS_Crypt__OpenSSL__Bignum_div);
        newXS_deffile("Crypt::OpenSSL::Bignum::sqr", XS_Crypt__OpenSSL__Bignum_sqr);
        newXS_deffile("Crypt::OpenSSL::Bignum::mod", XS_Crypt__OpenSSL__Bignum_mod);
        newXS_deffile("Crypt::OpenSSL::Bignum::mod_mul", XS_Crypt__OpenSSL__Bignum_mod_mul);
        newXS_deffile("Crypt::OpenSSL::Bignum::exp", XS_Crypt__OpenSSL__Bignum_exp);
        newXS_deffile("Crypt::OpenSSL::Bignum::mod_exp", XS_Crypt__OpenSSL__Bignum_mod_exp);
        newXS_deffile("Crypt::OpenSSL::Bignum::mod_inverse", XS_Crypt__OpenSSL__Bignum_mod_inverse);
        newXS_deffile("Crypt::OpenSSL::Bignum::gcd", XS_Crypt__OpenSSL__Bignum_gcd);
        newXS_deffile("Crypt::OpenSSL::Bignum::equals", XS_Crypt__OpenSSL__Bignum_equals);
        newXS_deffile("Crypt::OpenSSL::Bignum::cmp", XS_Crypt__OpenSSL__Bignum_cmp);
        newXS_deffile("Crypt::OpenSSL::Bignum::num_bits", XS_Crypt__OpenSSL__Bignum_num_bits);
        newXS_deffile("Crypt::OpenSSL::Bignum::num_bytes", XS_Crypt__OpenSSL__Bignum_num_bytes);
        newXS_deffile("Crypt::OpenSSL::Bignum::rshift", XS_Crypt__OpenSSL__Bignum_rshift);
        newXS_deffile("Crypt::OpenSSL::Bignum::lshift", XS_Crypt__OpenSSL__Bignum_lshift);
        newXS_deffile("Crypt::OpenSSL::Bignum::ucmp", XS_Crypt__OpenSSL__Bignum_ucmp);
        newXS_deffile("Crypt::OpenSSL::Bignum::swap", XS_Crypt__OpenSSL__Bignum_swap);
        newXS_deffile("Crypt::OpenSSL::Bignum::copy", XS_Crypt__OpenSSL__Bignum_copy);
        newXS_deffile("Crypt::OpenSSL::Bignum::pointer_copy", XS_Crypt__OpenSSL__Bignum_pointer_copy);
        newXS_deffile("Crypt::OpenSSL::Bignum::CTX::new", XS_Crypt__OpenSSL__Bignum__CTX_new);
        newXS_deffile("Crypt::OpenSSL::Bignum::CTX::DESTROY", XS_Crypt__OpenSSL__Bignum__CTX_DESTROY);

    /* Initialisation Section */

#line 32 "Bignum.xs"
#if OPENSSL_VERSION_NUMBER >= 0x10100000L && !defined(LIBRESSL_VERSION_NUMBER)
    OPENSSL_init_crypto(0, NULL);
#else
    ERR_load_crypto_strings();
#endif

#line 2110 "Bignum.c"

    /* End of Initialisation Section */

#if PERL_VERSION_LE(5, 21, 5)
#  if PERL_VERSION_GE(5, 9, 0)
    if (PL_unitcheckav)
        call_list(PL_scopestack_ix, PL_unitcheckav);
#  endif
    XSRETURN_YES;
#else
    Perl_xs_boot_epilog(aTHX_ ax);
#endif
}

