; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 2
; RUN: opt %s -passes=newgvn -S | FileCheck %s
target datalayout = "e-m:e-i64:64-f80:128-n8:16:32:64-S128"
target triple = "x86_64-unknown-linux-gnu"

define ptr @test1(ptr %v0, ptr %v1) {
; CHECK-LABEL: define ptr @test1
; CHECK-SAME: (ptr [[V0:%.*]], ptr [[V1:%.*]]) {
; CHECK-NEXT:  top:
; CHECK-NEXT:    [[V2:%.*]] = load ptr, ptr [[V0]], align 8
; CHECK-NEXT:    store ptr [[V2]], ptr [[V1]], align 8
; CHECK-NEXT:    ret ptr [[V2]]
;
top:
  %v2 = load ptr, ptr %v0, !nonnull !0
  store ptr %v2, ptr %v1
  %v3 = load ptr, ptr %v1
  ret ptr %v3
}

; FIXME: could propagate nonnull to first load?
define ptr @test2(ptr %v0, ptr %v1) {
; CHECK-LABEL: define ptr @test2
; CHECK-SAME: (ptr [[V0:%.*]], ptr [[V1:%.*]]) {
; CHECK-NEXT:  top:
; CHECK-NEXT:    [[V2:%.*]] = load ptr, ptr [[V0]], align 8
; CHECK-NEXT:    store ptr [[V2]], ptr [[V1]], align 8
; CHECK-NEXT:    ret ptr [[V2]]
;
top:
  %v2 = load ptr, ptr %v0
  store ptr %v2, ptr %v1
  %v3 = load ptr, ptr %v1, !nonnull !0
  ret ptr %v3
}

declare void @use1(ptr %a) readonly

define ptr @test3(ptr %v0, i1 %arg) {
; CHECK-LABEL: define ptr @test3
; CHECK-SAME: (ptr [[V0:%.*]], i1 [[ARG:%.*]]) {
; CHECK-NEXT:  top:
; CHECK-NEXT:    [[V1:%.*]] = load ptr, ptr [[V0]], align 8
; CHECK-NEXT:    call void @use1(ptr [[V1]])
; CHECK-NEXT:    br i1 [[ARG]], label [[BB1:%.*]], label [[BB2:%.*]]
; CHECK:       bb1:
; CHECK-NEXT:    ret ptr [[V1]]
; CHECK:       bb2:
; CHECK-NEXT:    ret ptr [[V1]]
;
top:
  %v1 = load ptr, ptr %v0
  call void @use1(ptr %v1)
  br i1 %arg, label %bb1, label %bb2

bb1:
  %v2 = load ptr, ptr %v0, !nonnull !0
  ret ptr %v2

bb2:
  %v3 = load ptr, ptr %v0
  ret ptr %v3
}

define ptr @test4(ptr %v0, i1 %arg) {
; CHECK-LABEL: define ptr @test4
; CHECK-SAME: (ptr [[V0:%.*]], i1 [[ARG:%.*]]) {
; CHECK-NEXT:  top:
; CHECK-NEXT:    [[V1:%.*]] = load ptr, ptr [[V0]], align 8
; CHECK-NEXT:    call void @use1(ptr [[V1]])
; CHECK-NEXT:    br i1 [[ARG]], label [[BB1:%.*]], label [[BB2:%.*]]
; CHECK:       bb1:
; CHECK-NEXT:    ret ptr [[V1]]
; CHECK:       bb2:
; CHECK-NEXT:    ret ptr [[V1]]
;
top:
  %v1 = load ptr, ptr %v0
  call void @use1(ptr %v1)
  br i1 %arg, label %bb1, label %bb2

bb1:
  %v2 = load ptr, ptr %v0
  ret ptr %v2

bb2:
  %v3 = load ptr, ptr %v0, !nonnull !0
  ret ptr %v3
}

define ptr @test5(ptr %v0, i1 %arg) {
; CHECK-LABEL: define ptr @test5
; CHECK-SAME: (ptr [[V0:%.*]], i1 [[ARG:%.*]]) {
; CHECK-NEXT:  top:
; CHECK-NEXT:    [[V1:%.*]] = load ptr, ptr [[V0]], align 8
; CHECK-NEXT:    call void @use1(ptr [[V1]])
; CHECK-NEXT:    br i1 [[ARG]], label [[BB1:%.*]], label [[BB2:%.*]]
; CHECK:       bb1:
; CHECK-NEXT:    ret ptr [[V1]]
; CHECK:       bb2:
; CHECK-NEXT:    ret ptr [[V1]]
;
top:
  %v1 = load ptr, ptr %v0, !nonnull !0
  call void @use1(ptr %v1)
  br i1 %arg, label %bb1, label %bb2

bb1:
  %v2 = load ptr, ptr %v0
  ret ptr %v2

bb2:
  %v3 = load ptr, ptr %v0
  ret ptr %v3
}

define ptr @test6(ptr %v0, ptr %v1, i1 %arg) {
; CHECK-LABEL: define ptr @test6
; CHECK-SAME: (ptr [[V0:%.*]], ptr [[V1:%.*]], i1 [[ARG:%.*]]) {
; CHECK-NEXT:  top:
; CHECK-NEXT:    br i1 [[ARG]], label [[BB1:%.*]], label [[BB2:%.*]]
; CHECK:       bb1:
; CHECK-NEXT:    [[V2:%.*]] = load ptr, ptr [[V0]], align 8
; CHECK-NEXT:    store ptr [[V2]], ptr [[V1]], align 8
; CHECK-NEXT:    ret ptr [[V2]]
; CHECK:       bb2:
; CHECK-NEXT:    [[V4:%.*]] = load ptr, ptr [[V0]], align 8
; CHECK-NEXT:    store ptr [[V4]], ptr [[V1]], align 8
; CHECK-NEXT:    ret ptr [[V4]]
;
top:
  br i1 %arg, label %bb1, label %bb2

bb1:
  %v2 = load ptr, ptr %v0, !nonnull !0
  store ptr %v2, ptr %v1
  %v3 = load ptr, ptr %v1
  ret ptr %v3

bb2:
  %v4 = load ptr, ptr %v0
  store ptr %v4, ptr %v1
  %v5 = load ptr, ptr %v1, !nonnull !0
  ret ptr %v5
}

declare void @use2(ptr %a)

define ptr @test7(ptr %v0, i1 %arg) {
; CHECK-LABEL: define ptr @test7
; CHECK-SAME: (ptr [[V0:%.*]], i1 [[ARG:%.*]]) {
; CHECK-NEXT:  top:
; CHECK-NEXT:    [[V1:%.*]] = load ptr, ptr [[V0]], align 8, !nonnull [[META0:![0-9]+]]
; CHECK-NEXT:    call void @use2(ptr [[V1]])
; CHECK-NEXT:    br i1 [[ARG]], label [[BB1:%.*]], label [[BB2:%.*]]
; CHECK:       bb1:
; CHECK-NEXT:    [[V2:%.*]] = load ptr, ptr [[V0]], align 8
; CHECK-NEXT:    ret ptr [[V2]]
; CHECK:       bb2:
; CHECK-NEXT:    [[V3:%.*]] = load ptr, ptr [[V0]], align 8
; CHECK-NEXT:    ret ptr [[V3]]
;
top:
  %v1 = load ptr, ptr %v0, !nonnull !0
  call void @use2(ptr %v1)
  br i1 %arg, label %bb1, label %bb2

bb1:
  %v2 = load ptr, ptr %v0
  ret ptr %v2

bb2:
  %v3 = load ptr, ptr %v0
  ret ptr %v3
}

!0 = !{}
