; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -S -passes=loop-unroll -unroll-force-peel-count=1 | FileCheck %s

define i32 @invariant_backedge_irreducible(i32 %a, i32 %b) {
; CHECK-LABEL: @invariant_backedge_irreducible(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[HEADER_PEEL_BEGIN:%.*]]
; CHECK:       header.peel.begin:
; CHECK-NEXT:    br label [[HEADER_PEEL:%.*]]
; CHECK:       header.peel:
; CHECK-NEXT:    br i1 false, label [[LATCH_PEEL:%.*]], label [[EXITING_PEEL:%.*]]
; CHECK:       latch.peel:
; CHECK-NEXT:    [[INC_PEEL:%.*]] = add i32 0, 1
; CHECK-NEXT:    [[CMP_PEEL:%.*]] = icmp slt i32 0, 1000
; CHECK-NEXT:    br i1 [[CMP_PEEL]], label [[HEADER_PEEL_NEXT:%.*]], label [[EXITING_PEEL]]
; CHECK:       exiting.peel:
; CHECK-NEXT:    [[CMP_EXITING_PEEL:%.*]] = phi i1 [ false, [[HEADER_PEEL]] ], [ [[CMP_PEEL]], [[LATCH_PEEL]] ]
; CHECK-NEXT:    br i1 [[CMP_EXITING_PEEL]], label [[LATCH_PEEL]], label [[EXIT:%.*]]
; CHECK:       header.peel.next:
; CHECK-NEXT:    br label [[HEADER_PEEL_NEXT1:%.*]]
; CHECK:       header.peel.next1:
; CHECK-NEXT:    br label [[ENTRY_PEEL_NEWPH:%.*]]
; CHECK:       entry.peel.newph:
; CHECK-NEXT:    br label [[HEADER:%.*]]
; CHECK:       header:
; CHECK-NEXT:    [[I:%.*]] = phi i32 [ [[INC_PEEL]], [[ENTRY_PEEL_NEWPH]] ], [ [[INC:%.*]], [[LATCH:%.*]] ]
; CHECK-NEXT:    [[CMP_PHI:%.*]] = phi i1 [ [[CMP_PEEL]], [[ENTRY_PEEL_NEWPH]] ], [ [[CMP:%.*]], [[LATCH]] ]
; CHECK-NEXT:    br i1 [[CMP_PHI]], label [[LATCH]], label [[EXITING:%.*]]
; CHECK:       latch:
; CHECK-NEXT:    [[INC]] = add nsw i32 [[I]], 1
; CHECK-NEXT:    [[CMP]] = icmp slt i32 [[I]], 1000
; CHECK-NEXT:    br i1 [[CMP]], label [[HEADER]], label [[EXITING]], !llvm.loop [[LOOP0:![0-9]+]]
; CHECK:       exiting:
; CHECK-NEXT:    [[CMP_EXITING:%.*]] = phi i1 [ [[CMP_PHI]], [[HEADER]] ], [ [[CMP]], [[LATCH]] ]
; CHECK-NEXT:    br i1 [[CMP_EXITING]], label [[LATCH]], label [[EXIT_LOOPEXIT:%.*]]
; CHECK:       exit.loopexit:
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    ret i32 0
;
entry:
  br label %header

header:
  %i = phi i32 [ 0, %entry ], [ %inc, %latch ]
  %cmp.phi = phi i1 [ false, %entry ], [ %cmp, %latch ]
  br i1 %cmp.phi, label %latch, label %exiting

latch:
  %inc = add i32 %i, 1
  %cmp = icmp slt i32 %i, 1000
  br i1 %cmp, label %header, label %exiting

exiting:
  %cmp.exiting = phi i1 [ %cmp.phi, %header ], [ %cmp, %latch ]
  br i1 %cmp.exiting, label %latch, label %exit

exit:
  ret i32 0
}

