; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

; https://bugs.llvm.org/show_bug.cgi?id=6773

; Pattern:
;   (x | ~m) & (y & m)
; Should be transformed into:
;   (x & m) | (y & ~m)
; And then into:
;   ((x ^ y) & m) ^ y

; ============================================================================ ;
; Most basic positive tests
; ============================================================================ ;

define i32 @p(i32 %x, i32 %y, i32 %m) {
; CHECK-LABEL: @p(
; CHECK-NEXT:    [[NEG:%.*]] = xor i32 [[M:%.*]], -1
; CHECK-NEXT:    [[OR:%.*]] = or i32 [[X:%.*]], [[NEG]]
; CHECK-NEXT:    [[OR1:%.*]] = or i32 [[Y:%.*]], [[M]]
; CHECK-NEXT:    [[RET:%.*]] = and i32 [[OR]], [[OR1]]
; CHECK-NEXT:    ret i32 [[RET]]
;
  %neg = xor i32 %m, -1
  %or = or i32 %neg, %x
  %or1 = or i32 %y, %m
  %ret = and i32 %or, %or1
  ret i32 %ret
}

define <2 x i32> @p_splatvec(<2 x i32> %x, <2 x i32> %y, <2 x i32> %m) {
; CHECK-LABEL: @p_splatvec(
; CHECK-NEXT:    [[NEG:%.*]] = xor <2 x i32> [[M:%.*]], splat (i32 -1)
; CHECK-NEXT:    [[OR:%.*]] = or <2 x i32> [[X:%.*]], [[NEG]]
; CHECK-NEXT:    [[OR1:%.*]] = or <2 x i32> [[Y:%.*]], [[M]]
; CHECK-NEXT:    [[RET:%.*]] = and <2 x i32> [[OR]], [[OR1]]
; CHECK-NEXT:    ret <2 x i32> [[RET]]
;
  %neg = xor <2 x i32> %m, <i32 -1, i32 -1>
  %or = or <2 x i32> %neg, %x
  %or1 = or <2 x i32> %y, %m
  %ret = and <2 x i32> %or, %or1
  ret <2 x i32> %ret
}

define <3 x i32> @p_vec_undef(<3 x i32> %x, <3 x i32> %y, <3 x i32> %m) {
; CHECK-LABEL: @p_vec_undef(
; CHECK-NEXT:    [[NEG:%.*]] = xor <3 x i32> [[M:%.*]], <i32 -1, i32 undef, i32 -1>
; CHECK-NEXT:    [[OR:%.*]] = or <3 x i32> [[NEG]], [[X:%.*]]
; CHECK-NEXT:    [[OR1:%.*]] = or <3 x i32> [[Y:%.*]], [[M]]
; CHECK-NEXT:    [[RET:%.*]] = and <3 x i32> [[OR]], [[OR1]]
; CHECK-NEXT:    ret <3 x i32> [[RET]]
;
  %neg = xor <3 x i32> %m, <i32 -1, i32 undef, i32 -1>
  %or = or <3 x i32> %neg, %x
  %or1 = or <3 x i32> %y, %m
  %ret = and <3 x i32> %or, %or1
  ret <3 x i32> %ret
}

; ============================================================================ ;
; Constant mask.
; ============================================================================ ;

define i32 @p_constmask(i32 %x, i32 %y) {
; CHECK-LABEL: @p_constmask(
; CHECK-NEXT:    [[OR:%.*]] = or i32 [[X:%.*]], -65281
; CHECK-NEXT:    [[OR1:%.*]] = or i32 [[Y:%.*]], 65280
; CHECK-NEXT:    [[RET:%.*]] = and i32 [[OR]], [[OR1]]
; CHECK-NEXT:    ret i32 [[RET]]
;
  %or = or i32 %x, -65281
  %or1 = or i32 %y, 65280
  %ret = and i32 %or, %or1
  ret i32 %ret
}

define <2 x i32> @p_constmask_splatvec(<2 x i32> %x, <2 x i32> %y) {
; CHECK-LABEL: @p_constmask_splatvec(
; CHECK-NEXT:    [[OR:%.*]] = or <2 x i32> [[X:%.*]], splat (i32 -65281)
; CHECK-NEXT:    [[OR1:%.*]] = or <2 x i32> [[Y:%.*]], splat (i32 65280)
; CHECK-NEXT:    [[RET:%.*]] = and <2 x i32> [[OR]], [[OR1]]
; CHECK-NEXT:    ret <2 x i32> [[RET]]
;
  %or = or <2 x i32> %x, <i32 -65281, i32 -65281>
  %or1 = or <2 x i32> %y, <i32 65280, i32 65280>
  %ret = and <2 x i32> %or, %or1
  ret <2 x i32> %ret
}

define <2 x i32> @p_constmask_vec(<2 x i32> %x, <2 x i32> %y) {
; CHECK-LABEL: @p_constmask_vec(
; CHECK-NEXT:    [[OR:%.*]] = or <2 x i32> [[X:%.*]], <i32 -65281, i32 -16776961>
; CHECK-NEXT:    [[OR1:%.*]] = or <2 x i32> [[Y:%.*]], <i32 65280, i32 16776960>
; CHECK-NEXT:    [[RET:%.*]] = and <2 x i32> [[OR]], [[OR1]]
; CHECK-NEXT:    ret <2 x i32> [[RET]]
;
  %or = or <2 x i32> %x, <i32 -65281, i32 -16776961>
  %or1 = or <2 x i32> %y, <i32 65280, i32 16776960>
  %ret = and <2 x i32> %or, %or1
  ret <2 x i32> %ret
}

define <3 x i32> @p_constmask_vec_undef(<3 x i32> %x, <3 x i32> %y) {
; CHECK-LABEL: @p_constmask_vec_undef(
; CHECK-NEXT:    [[OR:%.*]] = or <3 x i32> [[X:%.*]], <i32 -65281, i32 undef, i32 -65281>
; CHECK-NEXT:    [[OR1:%.*]] = or <3 x i32> [[Y:%.*]], <i32 65280, i32 undef, i32 65280>
; CHECK-NEXT:    [[RET:%.*]] = and <3 x i32> [[OR]], [[OR1]]
; CHECK-NEXT:    ret <3 x i32> [[RET]]
;
  %or = or <3 x i32> %x, <i32 -65281, i32 undef, i32 -65281>
  %or1 = or <3 x i32> %y, <i32 65280, i32 undef, i32 65280>
  %ret = and <3 x i32> %or, %or1
  ret <3 x i32> %ret
}

; ============================================================================ ;
; Commutativity.
; ============================================================================ ;

; Used to make sure that the IR complexity sorting does not interfere.
declare i32 @gen32()

define i32 @p_commutative0(i32 %x, i32 %y, i32 %m) {
; CHECK-LABEL: @p_commutative0(
; CHECK-NEXT:    [[NEG:%.*]] = xor i32 [[M:%.*]], -1
; CHECK-NEXT:    [[OR:%.*]] = or i32 [[X:%.*]], [[NEG]]
; CHECK-NEXT:    [[OR1:%.*]] = or i32 [[Y:%.*]], [[M]]
; CHECK-NEXT:    [[RET:%.*]] = and i32 [[OR]], [[OR1]]
; CHECK-NEXT:    ret i32 [[RET]]
;
  %neg = xor i32 %m, -1
  %or = or i32 %x, %neg ; swapped order
  %or1 = or i32 %y, %m
  %ret = and i32 %or, %or1
  ret i32 %ret
}

define i32 @p_commutative1(i32 %x, i32 %m) {
; CHECK-LABEL: @p_commutative1(
; CHECK-NEXT:    [[Y:%.*]] = call i32 @gen32()
; CHECK-NEXT:    [[NEG:%.*]] = xor i32 [[M:%.*]], -1
; CHECK-NEXT:    [[OR:%.*]] = or i32 [[X:%.*]], [[NEG]]
; CHECK-NEXT:    [[OR1:%.*]] = or i32 [[M]], [[Y]]
; CHECK-NEXT:    [[RET:%.*]] = and i32 [[OR]], [[OR1]]
; CHECK-NEXT:    ret i32 [[RET]]
;
  %y = call i32 @gen32()
  %neg = xor i32 %m, -1
  %or = or i32 %neg, %x
  %or1 = or i32 %m, %y; swapped order
  %ret = and i32 %or, %or1
  ret i32 %ret
}

define i32 @p_commutative2(i32 %x, i32 %y, i32 %m) {
; CHECK-LABEL: @p_commutative2(
; CHECK-NEXT:    [[NEG:%.*]] = xor i32 [[M:%.*]], -1
; CHECK-NEXT:    [[OR:%.*]] = or i32 [[X:%.*]], [[NEG]]
; CHECK-NEXT:    [[OR1:%.*]] = or i32 [[Y:%.*]], [[M]]
; CHECK-NEXT:    [[RET:%.*]] = and i32 [[OR1]], [[OR]]
; CHECK-NEXT:    ret i32 [[RET]]
;
  %neg = xor i32 %m, -1
  %or = or i32 %neg, %x
  %or1 = or i32 %y, %m
  %ret = and i32 %or1, %or ; swapped order
  ret i32 %ret
}

define i32 @p_commutative3(i32 %x, i32 %m) {
; CHECK-LABEL: @p_commutative3(
; CHECK-NEXT:    [[Y:%.*]] = call i32 @gen32()
; CHECK-NEXT:    [[NEG:%.*]] = xor i32 [[M:%.*]], -1
; CHECK-NEXT:    [[OR:%.*]] = or i32 [[X:%.*]], [[NEG]]
; CHECK-NEXT:    [[OR1:%.*]] = or i32 [[M]], [[Y]]
; CHECK-NEXT:    [[RET:%.*]] = and i32 [[OR]], [[OR1]]
; CHECK-NEXT:    ret i32 [[RET]]
;
  %y = call i32 @gen32()
  %neg = xor i32 %m, -1
  %or = or i32 %x, %neg ; swapped order
  %or1 = or i32 %m, %y; swapped order
  %ret = and i32 %or, %or1
  ret i32 %ret
}

define i32 @p_commutative4(i32 %x, i32 %y, i32 %m) {
; CHECK-LABEL: @p_commutative4(
; CHECK-NEXT:    [[NEG:%.*]] = xor i32 [[M:%.*]], -1
; CHECK-NEXT:    [[OR:%.*]] = or i32 [[X:%.*]], [[NEG]]
; CHECK-NEXT:    [[OR1:%.*]] = or i32 [[Y:%.*]], [[M]]
; CHECK-NEXT:    [[RET:%.*]] = and i32 [[OR1]], [[OR]]
; CHECK-NEXT:    ret i32 [[RET]]
;
  %neg = xor i32 %m, -1
  %or = or i32 %x, %neg ; swapped order
  %or1 = or i32 %y, %m
  %ret = and i32 %or1, %or ; swapped order
  ret i32 %ret
}

define i32 @p_commutative5(i32 %x, i32 %m) {
; CHECK-LABEL: @p_commutative5(
; CHECK-NEXT:    [[Y:%.*]] = call i32 @gen32()
; CHECK-NEXT:    [[NEG:%.*]] = xor i32 [[M:%.*]], -1
; CHECK-NEXT:    [[OR:%.*]] = or i32 [[X:%.*]], [[NEG]]
; CHECK-NEXT:    [[OR1:%.*]] = or i32 [[M]], [[Y]]
; CHECK-NEXT:    [[RET:%.*]] = and i32 [[OR1]], [[OR]]
; CHECK-NEXT:    ret i32 [[RET]]
;
  %y = call i32 @gen32()
  %neg = xor i32 %m, -1
  %or = or i32 %neg, %x
  %or1 = or i32 %m, %y; swapped order
  %ret = and i32 %or1, %or ; swapped order
  ret i32 %ret
}

define i32 @p_commutative6(i32 %x, i32 %m) {
; CHECK-LABEL: @p_commutative6(
; CHECK-NEXT:    [[Y:%.*]] = call i32 @gen32()
; CHECK-NEXT:    [[NEG:%.*]] = xor i32 [[M:%.*]], -1
; CHECK-NEXT:    [[OR:%.*]] = or i32 [[X:%.*]], [[NEG]]
; CHECK-NEXT:    [[OR1:%.*]] = or i32 [[M]], [[Y]]
; CHECK-NEXT:    [[RET:%.*]] = and i32 [[OR1]], [[OR]]
; CHECK-NEXT:    ret i32 [[RET]]
;
  %y = call i32 @gen32()
  %neg = xor i32 %m, -1
  %or = or i32 %x, %neg ; swapped order
  %or1 = or i32 %m, %y; swapped order
  %ret = and i32 %or1, %or ; swapped order
  ret i32 %ret
}

define i32 @p_constmask_commutative(i32 %x, i32 %y) {
; CHECK-LABEL: @p_constmask_commutative(
; CHECK-NEXT:    [[OR:%.*]] = or i32 [[X:%.*]], -65281
; CHECK-NEXT:    [[OR1:%.*]] = or i32 [[Y:%.*]], 65280
; CHECK-NEXT:    [[RET:%.*]] = and i32 [[OR1]], [[OR]]
; CHECK-NEXT:    ret i32 [[RET]]
;
  %or = or i32 %x, -65281
  %or1 = or i32 %y, 65280
  %ret = and i32 %or1, %or ; swapped order
  ret i32 %ret
}

; ============================================================================ ;
; Negative tests. Should not be folded.
; ============================================================================ ;

; One use only.

declare void @use32(i32)

define i32 @n0_oneuse_of_neg_is_ok_0(i32 %x, i32 %y, i32 %m) {
; CHECK-LABEL: @n0_oneuse_of_neg_is_ok_0(
; CHECK-NEXT:    [[NEG:%.*]] = xor i32 [[M:%.*]], -1
; CHECK-NEXT:    [[OR:%.*]] = or i32 [[X:%.*]], [[NEG]]
; CHECK-NEXT:    [[OR1:%.*]] = or i32 [[Y:%.*]], [[M]]
; CHECK-NEXT:    [[RET:%.*]] = and i32 [[OR]], [[OR1]]
; CHECK-NEXT:    call void @use32(i32 [[NEG]])
; CHECK-NEXT:    ret i32 [[RET]]
;
  %neg = xor i32 %m, -1
  %or = or i32 %neg, %x
  %or1 = or i32 %y, %m
  %ret = and i32 %or, %or1
  call void @use32(i32 %neg)
  ret i32 %ret
}

define i32 @n0_oneuse_1(i32 %x, i32 %y, i32 %m) {
; CHECK-LABEL: @n0_oneuse_1(
; CHECK-NEXT:    [[NEG:%.*]] = xor i32 [[M:%.*]], -1
; CHECK-NEXT:    [[OR:%.*]] = or i32 [[X:%.*]], [[NEG]]
; CHECK-NEXT:    [[OR1:%.*]] = or i32 [[Y:%.*]], [[M]]
; CHECK-NEXT:    [[RET:%.*]] = and i32 [[OR]], [[OR1]]
; CHECK-NEXT:    call void @use32(i32 [[OR]])
; CHECK-NEXT:    ret i32 [[RET]]
;
  %neg = xor i32 %m, -1
  %or = or i32 %neg, %x
  %or1 = or i32 %y, %m
  %ret = and i32 %or, %or1
  call void @use32(i32 %or)
  ret i32 %ret
}

define i32 @n0_oneuse_2(i32 %x, i32 %y, i32 %m) {
; CHECK-LABEL: @n0_oneuse_2(
; CHECK-NEXT:    [[NEG:%.*]] = xor i32 [[M:%.*]], -1
; CHECK-NEXT:    [[OR:%.*]] = or i32 [[X:%.*]], [[NEG]]
; CHECK-NEXT:    [[OR1:%.*]] = or i32 [[Y:%.*]], [[M]]
; CHECK-NEXT:    [[RET:%.*]] = and i32 [[OR]], [[OR1]]
; CHECK-NEXT:    call void @use32(i32 [[OR1]])
; CHECK-NEXT:    ret i32 [[RET]]
;
  %neg = xor i32 %m, -1
  %or = or i32 %neg, %x
  %or1 = or i32 %y, %m
  %ret = and i32 %or, %or1
  call void @use32(i32 %or1)
  ret i32 %ret
}

define i32 @n0_oneuse_3(i32 %x, i32 %y, i32 %m) {
; CHECK-LABEL: @n0_oneuse_3(
; CHECK-NEXT:    [[NEG:%.*]] = xor i32 [[M:%.*]], -1
; CHECK-NEXT:    [[OR:%.*]] = or i32 [[X:%.*]], [[NEG]]
; CHECK-NEXT:    [[OR1:%.*]] = or i32 [[Y:%.*]], [[M]]
; CHECK-NEXT:    [[RET:%.*]] = and i32 [[OR]], [[OR1]]
; CHECK-NEXT:    call void @use32(i32 [[NEG]])
; CHECK-NEXT:    call void @use32(i32 [[OR]])
; CHECK-NEXT:    ret i32 [[RET]]
;
  %neg = xor i32 %m, -1
  %or = or i32 %neg, %x
  %or1 = or i32 %y, %m
  %ret = and i32 %or, %or1
  call void @use32(i32 %neg)
  call void @use32(i32 %or)
  ret i32 %ret
}

define i32 @n0_oneuse_4(i32 %x, i32 %y, i32 %m) {
; CHECK-LABEL: @n0_oneuse_4(
; CHECK-NEXT:    [[NEG:%.*]] = xor i32 [[M:%.*]], -1
; CHECK-NEXT:    [[OR:%.*]] = or i32 [[X:%.*]], [[NEG]]
; CHECK-NEXT:    [[OR1:%.*]] = or i32 [[Y:%.*]], [[M]]
; CHECK-NEXT:    [[RET:%.*]] = and i32 [[OR]], [[OR1]]
; CHECK-NEXT:    call void @use32(i32 [[NEG]])
; CHECK-NEXT:    call void @use32(i32 [[OR1]])
; CHECK-NEXT:    ret i32 [[RET]]
;
  %neg = xor i32 %m, -1
  %or = or i32 %neg, %x
  %or1 = or i32 %y, %m
  %ret = and i32 %or, %or1
  call void @use32(i32 %neg)
  call void @use32(i32 %or1)
  ret i32 %ret
}

define i32 @n0_oneuse_5(i32 %x, i32 %y, i32 %m) {
; CHECK-LABEL: @n0_oneuse_5(
; CHECK-NEXT:    [[NEG:%.*]] = xor i32 [[M:%.*]], -1
; CHECK-NEXT:    [[OR:%.*]] = or i32 [[X:%.*]], [[NEG]]
; CHECK-NEXT:    [[OR1:%.*]] = or i32 [[Y:%.*]], [[M]]
; CHECK-NEXT:    [[RET:%.*]] = and i32 [[OR]], [[OR1]]
; CHECK-NEXT:    call void @use32(i32 [[NEG]])
; CHECK-NEXT:    call void @use32(i32 [[OR]])
; CHECK-NEXT:    call void @use32(i32 [[OR1]])
; CHECK-NEXT:    ret i32 [[RET]]
;
  %neg = xor i32 %m, -1
  %or = or i32 %neg, %x
  %or1 = or i32 %y, %m
  %ret = and i32 %or, %or1
  call void @use32(i32 %neg)
  call void @use32(i32 %or)
  call void @use32(i32 %or1)
  ret i32 %ret
}

define i32 @n0_oneuse_6(i32 %x, i32 %y, i32 %m) {
; CHECK-LABEL: @n0_oneuse_6(
; CHECK-NEXT:    [[NEG:%.*]] = xor i32 [[M:%.*]], -1
; CHECK-NEXT:    [[OR:%.*]] = or i32 [[X:%.*]], [[NEG]]
; CHECK-NEXT:    [[OR1:%.*]] = or i32 [[Y:%.*]], [[M]]
; CHECK-NEXT:    [[RET:%.*]] = and i32 [[OR]], [[OR1]]
; CHECK-NEXT:    call void @use32(i32 [[OR]])
; CHECK-NEXT:    call void @use32(i32 [[OR1]])
; CHECK-NEXT:    ret i32 [[RET]]
;
  %neg = xor i32 %m, -1
  %or = or i32 %neg, %x
  %or1 = or i32 %y, %m
  %ret = and i32 %or, %or1
  call void @use32(i32 %or)
  call void @use32(i32 %or1)
  ret i32 %ret
}

; One-use with constant mask

define i32 @n0_constmask_oneuse_0(i32 %x, i32 %y) {
; CHECK-LABEL: @n0_constmask_oneuse_0(
; CHECK-NEXT:    [[OR:%.*]] = or i32 [[X:%.*]], -65281
; CHECK-NEXT:    [[OR1:%.*]] = or i32 [[Y:%.*]], 65280
; CHECK-NEXT:    [[RET:%.*]] = and i32 [[OR]], [[OR1]]
; CHECK-NEXT:    call void @use32(i32 [[OR]])
; CHECK-NEXT:    ret i32 [[RET]]
;
  %or = or i32 %x, -65281
  %or1 = or i32 %y, 65280
  %ret = and i32 %or, %or1
  call void @use32(i32 %or)
  ret i32 %ret
}

define i32 @n0_constmask_oneuse_1(i32 %x, i32 %y) {
; CHECK-LABEL: @n0_constmask_oneuse_1(
; CHECK-NEXT:    [[OR:%.*]] = or i32 [[X:%.*]], -65281
; CHECK-NEXT:    [[OR1:%.*]] = or i32 [[Y:%.*]], 65280
; CHECK-NEXT:    [[RET:%.*]] = and i32 [[OR]], [[OR1]]
; CHECK-NEXT:    call void @use32(i32 [[OR1]])
; CHECK-NEXT:    ret i32 [[RET]]
;
  %or = or i32 %x, -65281
  %or1 = or i32 %y, 65280
  %ret = and i32 %or, %or1
  call void @use32(i32 %or1)
  ret i32 %ret
}

define i32 @n0_constmask_oneuse_2(i32 %x, i32 %y) {
; CHECK-LABEL: @n0_constmask_oneuse_2(
; CHECK-NEXT:    [[OR:%.*]] = or i32 [[X:%.*]], -65281
; CHECK-NEXT:    [[OR1:%.*]] = or i32 [[Y:%.*]], 65280
; CHECK-NEXT:    [[RET:%.*]] = and i32 [[OR]], [[OR1]]
; CHECK-NEXT:    call void @use32(i32 [[OR]])
; CHECK-NEXT:    call void @use32(i32 [[OR1]])
; CHECK-NEXT:    ret i32 [[RET]]
;
  %or = or i32 %x, -65281
  %or1 = or i32 %y, 65280
  %ret = and i32 %or, %or1
  call void @use32(i32 %or)
  call void @use32(i32 %or1)
  ret i32 %ret
}

; Bad xor constant

define i32 @n1_badxor(i32 %x, i32 %y, i32 %m) {
; CHECK-LABEL: @n1_badxor(
; CHECK-NEXT:    [[NEG:%.*]] = xor i32 [[M:%.*]], 1
; CHECK-NEXT:    [[OR:%.*]] = or i32 [[NEG]], [[X:%.*]]
; CHECK-NEXT:    [[OR1:%.*]] = or i32 [[Y:%.*]], [[M]]
; CHECK-NEXT:    [[RET:%.*]] = and i32 [[OR]], [[OR1]]
; CHECK-NEXT:    ret i32 [[RET]]
;
  %neg = xor i32 %m, 1 ; not -1
  %or = or i32 %neg, %x
  %or1 = or i32 %y, %m
  %ret = and i32 %or, %or1
  ret i32 %ret
}

; Different mask is used

define i32 @n2_badmask(i32 %x, i32 %y, i32 %m1, i32 %m2) {
; CHECK-LABEL: @n2_badmask(
; CHECK-NEXT:    [[NEG:%.*]] = xor i32 [[M2:%.*]], -1
; CHECK-NEXT:    [[OR:%.*]] = or i32 [[X:%.*]], [[NEG]]
; CHECK-NEXT:    [[OR1:%.*]] = or i32 [[M1:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[RET:%.*]] = and i32 [[OR]], [[OR1]]
; CHECK-NEXT:    ret i32 [[RET]]
;
  %neg = xor i32 %m2, -1 ; different mask, not %m1
  %or = or i32 %neg, %x
  %or1 = or i32 %m1, %y
  %ret = and i32 %or, %or1
  ret i32 %ret
}

; Different const mask is used

define i32 @n3_constmask_badmask_set(i32 %x, i32 %y) {
; CHECK-LABEL: @n3_constmask_badmask_set(
; CHECK-NEXT:    [[OR:%.*]] = or i32 [[X:%.*]], -65281
; CHECK-NEXT:    [[OR1:%.*]] = or i32 [[Y:%.*]], 65281
; CHECK-NEXT:    [[RET:%.*]] = and i32 [[OR]], [[OR1]]
; CHECK-NEXT:    ret i32 [[RET]]
;
  %or = or i32 %x, -65281
  %or1 = or i32 %y, 65281 ; not 65280, so they have one common bit
  %ret = and i32 %or, %or1
  ret i32 %ret
}

define i32 @n3_constmask_badmask_unset(i32 %x, i32 %y) {
; CHECK-LABEL: @n3_constmask_badmask_unset(
; CHECK-NEXT:    [[OR:%.*]] = or i32 [[X:%.*]], -65281
; CHECK-NEXT:    [[OR1:%.*]] = or i32 [[Y:%.*]], 65024
; CHECK-NEXT:    [[RET:%.*]] = and i32 [[OR]], [[OR1]]
; CHECK-NEXT:    ret i32 [[RET]]
;
  %or = or i32 %x, -65281
  %or1 = or i32 %y, 65024 ; not 65280, so they have one common unset bit
  %ret = and i32 %or, %or1
  ret i32 %ret
}

define i32 @n3_constmask_samemask(i32 %x, i32 %y) {
; CHECK-LABEL: @n3_constmask_samemask(
; CHECK-NEXT:    [[OR2:%.*]] = and i32 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[RET:%.*]] = or i32 [[OR2]], -65281
; CHECK-NEXT:    ret i32 [[RET]]
;
  %or = or i32 %x, -65281
  %or1 = or i32 %y, -65281 ; both masks are the same
  %ret = and i32 %or, %or1
  ret i32 %ret
}
