// NOTE: Assertions have been autogenerated by utils/update_mc_test_checks.py UTC_ARGS: --version 5
// RUN: not llvm-mc -triple=amdgcn -mcpu=gfx1200 -mattr=+wavefrontsize32,-real-true16 -show-encoding %s | FileCheck --check-prefixes=GFX12,W32 %s
// RUN: not llvm-mc -triple=amdgcn -mcpu=gfx1200 -mattr=+wavefrontsize64,-real-true16 -show-encoding %s | FileCheck --check-prefixes=GFX12,W64 %s
// RUN: not llvm-mc -triple=amdgcn -mcpu=gfx1200 -mattr=+wavefrontsize32,-real-true16 -filetype=null %s 2>&1 | FileCheck --check-prefix=W32-ERR --implicit-check-not=error: %s
// RUN: not llvm-mc -triple=amdgcn -mcpu=gfx1200 -mattr=+wavefrontsize64,-real-true16 -filetype=null %s 2>&1 | FileCheck --check-prefix=W64-ERR --implicit-check-not=error: %s

v_cmp_class_f16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: v_cmp_class_f16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x7d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:25: error: invalid operand for instruction

v_cmp_class_f16_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0]
// W32: v_cmp_class_f16_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x7d,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:25: error: invalid operand for instruction

v_cmp_class_f16_e64_dpp s5, v1, 2.0 quad_perm:[3,2,1,0]
// W32: v_cmp_class_f16_e64_dpp s5, v1, 2.0 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x7d,0xd4,0xfa,0xe8,0x01,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:25: error: invalid operand for instruction

v_cmp_class_f16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: v_cmp_class_f16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x7d,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:25: error: invalid operand for instruction

v_cmp_class_f16_e64_dpp s5, v1, v2 row_mirror
// W32: v_cmp_class_f16_e64_dpp s5, v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x7d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:25: error: invalid operand for instruction

v_cmp_class_f16_e64_dpp s5, v1, v2 row_half_mirror
// W32: v_cmp_class_f16_e64_dpp s5, v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x7d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:25: error: invalid operand for instruction

v_cmp_class_f16_e64_dpp s5, v1, v2 row_shl:1
// W32: v_cmp_class_f16_e64_dpp s5, v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x7d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:25: error: invalid operand for instruction

v_cmp_class_f16_e64_dpp s5, v1, v2 row_shl:15
// W32: v_cmp_class_f16_e64_dpp s5, v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x7d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:25: error: invalid operand for instruction

v_cmp_class_f16_e64_dpp s5, v1, v2 row_shr:1
// W32: v_cmp_class_f16_e64_dpp s5, v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x7d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:25: error: invalid operand for instruction

v_cmp_class_f16_e64_dpp s5, v1, v2 row_shr:15
// W32: v_cmp_class_f16_e64_dpp s5, v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x7d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:25: error: invalid operand for instruction

v_cmp_class_f16_e64_dpp s5, v1, v2 row_ror:1
// W32: v_cmp_class_f16_e64_dpp s5, v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x7d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:25: error: invalid operand for instruction

v_cmp_class_f16_e64_dpp s105, v1, v2 row_ror:15
// W32: v_cmp_class_f16_e64_dpp s105, v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x69,0x00,0x7d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:25: error: invalid operand for instruction

v_cmp_class_f16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: v_cmp_class_f16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x6a,0x00,0x7d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:25: error: invalid operand for instruction

v_cmp_class_f16_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: v_cmp_class_f16_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6b,0x00,0x7d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:25: error: invalid operand for instruction

v_cmp_class_f16_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: v_cmp_class_f16_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7b,0x00,0x7d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:25: error: invalid operand for instruction

v_cmp_class_f16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: v_cmp_class_f16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x7d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:25: error: invalid operand for instruction

v_cmp_class_f16_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0]
// W64: v_cmp_class_f16_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x7d,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:25: error: invalid operand for instruction

v_cmp_class_f16_e64_dpp s[10:11], v1, 2.0 quad_perm:[3,2,1,0]
// W64: v_cmp_class_f16_e64_dpp s[10:11], v1, 2.0 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x7d,0xd4,0xfa,0xe8,0x01,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:25: error: invalid operand for instruction

v_cmp_class_f16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: v_cmp_class_f16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x7d,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:25: error: invalid operand for instruction

v_cmp_class_f16_e64_dpp s[10:11], v1, v2 row_mirror
// W64: v_cmp_class_f16_e64_dpp s[10:11], v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x7d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:25: error: invalid operand for instruction

v_cmp_class_f16_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: v_cmp_class_f16_e64_dpp s[10:11], v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x7d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:25: error: invalid operand for instruction

v_cmp_class_f16_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: v_cmp_class_f16_e64_dpp s[10:11], v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x7d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:25: error: invalid operand for instruction

v_cmp_class_f16_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: v_cmp_class_f16_e64_dpp s[10:11], v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x7d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:25: error: invalid operand for instruction

v_cmp_class_f16_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: v_cmp_class_f16_e64_dpp s[10:11], v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x7d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:25: error: invalid operand for instruction

v_cmp_class_f16_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: v_cmp_class_f16_e64_dpp s[10:11], v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x7d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:25: error: invalid operand for instruction

v_cmp_class_f16_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: v_cmp_class_f16_e64_dpp s[10:11], v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x7d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:25: error: invalid operand for instruction

v_cmp_class_f16_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: v_cmp_class_f16_e64_dpp s[10:11], v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x7d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:25: error: invalid operand for instruction

v_cmp_class_f16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: v_cmp_class_f16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x68,0x00,0x7d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:25: error: invalid operand for instruction

v_cmp_class_f16_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: v_cmp_class_f16_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6a,0x00,0x7d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:25: error: invalid operand for instruction

v_cmp_class_f16_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: v_cmp_class_f16_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7a,0x00,0x7d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:25: error: invalid operand for instruction

v_cmp_class_f16_e64_dpp null, -|v255|, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cmp_class_f16_e64_dpp null, -|v255|, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0x7c,0x01,0x7d,0xd4,0xfa,0xfe,0x03,0x20,0xff,0x6f,0x05,0x30]

v_cmp_class_f32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: v_cmp_class_f32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x7e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:25: error: invalid operand for instruction

v_cmp_class_f32_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0]
// W32: v_cmp_class_f32_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x7e,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:25: error: invalid operand for instruction

v_cmp_class_f32_e64_dpp s5, v1, 2.0 quad_perm:[3,2,1,0]
// W32: v_cmp_class_f32_e64_dpp s5, v1, 2.0 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x7e,0xd4,0xfa,0xe8,0x01,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:25: error: invalid operand for instruction

v_cmp_class_f32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: v_cmp_class_f32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x7e,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:25: error: invalid operand for instruction

v_cmp_class_f32_e64_dpp s5, v1, v2 row_mirror
// W32: v_cmp_class_f32_e64_dpp s5, v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x7e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:25: error: invalid operand for instruction

v_cmp_class_f32_e64_dpp s5, v1, v2 row_half_mirror
// W32: v_cmp_class_f32_e64_dpp s5, v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x7e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:25: error: invalid operand for instruction

v_cmp_class_f32_e64_dpp s5, v1, v2 row_shl:1
// W32: v_cmp_class_f32_e64_dpp s5, v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x7e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:25: error: invalid operand for instruction

v_cmp_class_f32_e64_dpp s5, v1, v2 row_shl:15
// W32: v_cmp_class_f32_e64_dpp s5, v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x7e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:25: error: invalid operand for instruction

v_cmp_class_f32_e64_dpp s5, v1, v2 row_shr:1
// W32: v_cmp_class_f32_e64_dpp s5, v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x7e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:25: error: invalid operand for instruction

v_cmp_class_f32_e64_dpp s5, v1, v2 row_shr:15
// W32: v_cmp_class_f32_e64_dpp s5, v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x7e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:25: error: invalid operand for instruction

v_cmp_class_f32_e64_dpp s5, v1, v2 row_ror:1
// W32: v_cmp_class_f32_e64_dpp s5, v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x7e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:25: error: invalid operand for instruction

v_cmp_class_f32_e64_dpp s105, v1, v2 row_ror:15
// W32: v_cmp_class_f32_e64_dpp s105, v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x69,0x00,0x7e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:25: error: invalid operand for instruction

v_cmp_class_f32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: v_cmp_class_f32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x6a,0x00,0x7e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:25: error: invalid operand for instruction

v_cmp_class_f32_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: v_cmp_class_f32_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6b,0x00,0x7e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:25: error: invalid operand for instruction

v_cmp_class_f32_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: v_cmp_class_f32_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7b,0x00,0x7e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:25: error: invalid operand for instruction

v_cmp_class_f32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: v_cmp_class_f32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x7e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:25: error: invalid operand for instruction

v_cmp_class_f32_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0]
// W64: v_cmp_class_f32_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x7e,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:25: error: invalid operand for instruction

v_cmp_class_f32_e64_dpp s[10:11], v1, 2.0 quad_perm:[3,2,1,0]
// W64: v_cmp_class_f32_e64_dpp s[10:11], v1, 2.0 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x7e,0xd4,0xfa,0xe8,0x01,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:25: error: invalid operand for instruction

v_cmp_class_f32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: v_cmp_class_f32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x7e,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:25: error: invalid operand for instruction

v_cmp_class_f32_e64_dpp s[10:11], v1, v2 row_mirror
// W64: v_cmp_class_f32_e64_dpp s[10:11], v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x7e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:25: error: invalid operand for instruction

v_cmp_class_f32_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: v_cmp_class_f32_e64_dpp s[10:11], v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x7e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:25: error: invalid operand for instruction

v_cmp_class_f32_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: v_cmp_class_f32_e64_dpp s[10:11], v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x7e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:25: error: invalid operand for instruction

v_cmp_class_f32_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: v_cmp_class_f32_e64_dpp s[10:11], v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x7e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:25: error: invalid operand for instruction

v_cmp_class_f32_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: v_cmp_class_f32_e64_dpp s[10:11], v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x7e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:25: error: invalid operand for instruction

v_cmp_class_f32_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: v_cmp_class_f32_e64_dpp s[10:11], v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x7e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:25: error: invalid operand for instruction

v_cmp_class_f32_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: v_cmp_class_f32_e64_dpp s[10:11], v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x7e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:25: error: invalid operand for instruction

v_cmp_class_f32_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: v_cmp_class_f32_e64_dpp s[10:11], v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x7e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:25: error: invalid operand for instruction

v_cmp_class_f32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: v_cmp_class_f32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x68,0x00,0x7e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:25: error: invalid operand for instruction

v_cmp_class_f32_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: v_cmp_class_f32_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6a,0x00,0x7e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:25: error: invalid operand for instruction

v_cmp_class_f32_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: v_cmp_class_f32_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7a,0x00,0x7e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:25: error: invalid operand for instruction

v_cmp_class_f32_e64_dpp null, -|v255|, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cmp_class_f32_e64_dpp null, -|v255|, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0x7c,0x01,0x7e,0xd4,0xfa,0xfe,0x03,0x20,0xff,0x6f,0x05,0x30]

v_cmp_eq_f16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: v_cmp_eq_f16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x02,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_f16_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0]
// W32: v_cmp_eq_f16_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x02,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_f16_e64_dpp s5, v1, 2.0 quad_perm:[3,2,1,0]
// W32: v_cmp_eq_f16_e64_dpp s5, v1, 2.0 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x02,0xd4,0xfa,0xe8,0x01,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_f16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: v_cmp_eq_f16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x02,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_f16_e64_dpp s5, v1, v2 row_mirror
// W32: v_cmp_eq_f16_e64_dpp s5, v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x02,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_f16_e64_dpp s5, v1, v2 row_half_mirror
// W32: v_cmp_eq_f16_e64_dpp s5, v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x02,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_f16_e64_dpp s5, v1, v2 row_shl:1
// W32: v_cmp_eq_f16_e64_dpp s5, v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x02,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_f16_e64_dpp s5, v1, v2 row_shl:15
// W32: v_cmp_eq_f16_e64_dpp s5, v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x02,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_f16_e64_dpp s5, v1, v2 row_shr:1
// W32: v_cmp_eq_f16_e64_dpp s5, v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x02,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_f16_e64_dpp s5, v1, v2 row_shr:15
// W32: v_cmp_eq_f16_e64_dpp s5, v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x02,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_f16_e64_dpp s5, v1, v2 row_ror:1
// W32: v_cmp_eq_f16_e64_dpp s5, v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x02,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_f16_e64_dpp s105, v1, v2 row_ror:15
// W32: v_cmp_eq_f16_e64_dpp s105, v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x69,0x00,0x02,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_f16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: v_cmp_eq_f16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x6a,0x00,0x02,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_f16_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: v_cmp_eq_f16_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6b,0x01,0x02,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_f16_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: v_cmp_eq_f16_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7b,0x02,0x02,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_f16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: v_cmp_eq_f16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x02,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_f16_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0]
// W64: v_cmp_eq_f16_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x02,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_f16_e64_dpp s[10:11], v1, 2.0 quad_perm:[3,2,1,0]
// W64: v_cmp_eq_f16_e64_dpp s[10:11], v1, 2.0 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x02,0xd4,0xfa,0xe8,0x01,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_f16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: v_cmp_eq_f16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x02,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_f16_e64_dpp s[10:11], v1, v2 row_mirror
// W64: v_cmp_eq_f16_e64_dpp s[10:11], v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x02,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_f16_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: v_cmp_eq_f16_e64_dpp s[10:11], v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x02,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_f16_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: v_cmp_eq_f16_e64_dpp s[10:11], v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x02,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_f16_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: v_cmp_eq_f16_e64_dpp s[10:11], v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x02,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_f16_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: v_cmp_eq_f16_e64_dpp s[10:11], v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x02,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_f16_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: v_cmp_eq_f16_e64_dpp s[10:11], v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x02,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_f16_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: v_cmp_eq_f16_e64_dpp s[10:11], v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x02,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_f16_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: v_cmp_eq_f16_e64_dpp s[10:11], v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x02,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_f16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: v_cmp_eq_f16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x68,0x00,0x02,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_f16_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: v_cmp_eq_f16_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6a,0x01,0x02,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_f16_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: v_cmp_eq_f16_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7a,0x02,0x02,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_f16_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cmp_eq_f16_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0x7c,0x83,0x02,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x05,0x30]

v_cmp_eq_f32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: v_cmp_eq_f32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x12,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_f32_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0]
// W32: v_cmp_eq_f32_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x12,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_f32_e64_dpp s5, v1, 2.0 quad_perm:[3,2,1,0]
// W32: v_cmp_eq_f32_e64_dpp s5, v1, 2.0 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x12,0xd4,0xfa,0xe8,0x01,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_f32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: v_cmp_eq_f32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x12,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_f32_e64_dpp s5, v1, v2 row_mirror
// W32: v_cmp_eq_f32_e64_dpp s5, v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x12,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_f32_e64_dpp s5, v1, v2 row_half_mirror
// W32: v_cmp_eq_f32_e64_dpp s5, v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x12,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_f32_e64_dpp s5, v1, v2 row_shl:1
// W32: v_cmp_eq_f32_e64_dpp s5, v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x12,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_f32_e64_dpp s5, v1, v2 row_shl:15
// W32: v_cmp_eq_f32_e64_dpp s5, v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x12,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_f32_e64_dpp s5, v1, v2 row_shr:1
// W32: v_cmp_eq_f32_e64_dpp s5, v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x12,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_f32_e64_dpp s5, v1, v2 row_shr:15
// W32: v_cmp_eq_f32_e64_dpp s5, v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x12,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_f32_e64_dpp s5, v1, v2 row_ror:1
// W32: v_cmp_eq_f32_e64_dpp s5, v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x12,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_f32_e64_dpp s105, v1, v2 row_ror:15
// W32: v_cmp_eq_f32_e64_dpp s105, v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x69,0x00,0x12,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_f32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: v_cmp_eq_f32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x6a,0x00,0x12,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_f32_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: v_cmp_eq_f32_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6b,0x01,0x12,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_f32_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: v_cmp_eq_f32_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7b,0x02,0x12,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_f32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: v_cmp_eq_f32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x12,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_f32_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0]
// W64: v_cmp_eq_f32_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x12,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_f32_e64_dpp s[10:11], v1, 2.0 quad_perm:[3,2,1,0]
// W64: v_cmp_eq_f32_e64_dpp s[10:11], v1, 2.0 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x12,0xd4,0xfa,0xe8,0x01,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_f32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: v_cmp_eq_f32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x12,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_f32_e64_dpp s[10:11], v1, v2 row_mirror
// W64: v_cmp_eq_f32_e64_dpp s[10:11], v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x12,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_f32_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: v_cmp_eq_f32_e64_dpp s[10:11], v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x12,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_f32_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: v_cmp_eq_f32_e64_dpp s[10:11], v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x12,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_f32_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: v_cmp_eq_f32_e64_dpp s[10:11], v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x12,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_f32_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: v_cmp_eq_f32_e64_dpp s[10:11], v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x12,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_f32_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: v_cmp_eq_f32_e64_dpp s[10:11], v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x12,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_f32_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: v_cmp_eq_f32_e64_dpp s[10:11], v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x12,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_f32_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: v_cmp_eq_f32_e64_dpp s[10:11], v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x12,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_f32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: v_cmp_eq_f32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x68,0x00,0x12,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_f32_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: v_cmp_eq_f32_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6a,0x01,0x12,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_f32_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: v_cmp_eq_f32_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7a,0x02,0x12,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_f32_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cmp_eq_f32_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0x7c,0x83,0x12,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x05,0x30]

v_cmp_eq_i16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: v_cmp_eq_i16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x32,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_i16_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0]
// W32: v_cmp_eq_i16_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x32,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_i16_e64_dpp s5, v1, 10 quad_perm:[3,2,1,0]
// W32: v_cmp_eq_i16_e64_dpp s5, v1, 10 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x32,0xd4,0xfa,0x14,0x01,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_i16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: v_cmp_eq_i16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x32,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_i16_e64_dpp s5, v1, v2 row_mirror
// W32: v_cmp_eq_i16_e64_dpp s5, v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x32,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_i16_e64_dpp s5, v1, v2 row_half_mirror
// W32: v_cmp_eq_i16_e64_dpp s5, v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x32,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_i16_e64_dpp s5, v1, v2 row_shl:1
// W32: v_cmp_eq_i16_e64_dpp s5, v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x32,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_i16_e64_dpp s5, v1, v2 row_shl:15
// W32: v_cmp_eq_i16_e64_dpp s5, v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x32,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_i16_e64_dpp s5, v1, v2 row_shr:1
// W32: v_cmp_eq_i16_e64_dpp s5, v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x32,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_i16_e64_dpp s5, v1, v2 row_shr:15
// W32: v_cmp_eq_i16_e64_dpp s5, v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x32,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_i16_e64_dpp s5, v1, v2 row_ror:1
// W32: v_cmp_eq_i16_e64_dpp s5, v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x32,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_i16_e64_dpp s105, v1, v2 row_ror:15
// W32: v_cmp_eq_i16_e64_dpp s105, v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x69,0x00,0x32,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_i16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: v_cmp_eq_i16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x6a,0x00,0x32,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_i16_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: v_cmp_eq_i16_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6b,0x00,0x32,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_i16_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: v_cmp_eq_i16_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7b,0x00,0x32,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_i16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: v_cmp_eq_i16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x32,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_i16_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0]
// W64: v_cmp_eq_i16_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x32,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_i16_e64_dpp s[10:11], v1, 10 quad_perm:[3,2,1,0]
// W64: v_cmp_eq_i16_e64_dpp s[10:11], v1, 10 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x32,0xd4,0xfa,0x14,0x01,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_i16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: v_cmp_eq_i16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x32,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_i16_e64_dpp s[10:11], v1, v2 row_mirror
// W64: v_cmp_eq_i16_e64_dpp s[10:11], v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x32,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_i16_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: v_cmp_eq_i16_e64_dpp s[10:11], v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x32,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_i16_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: v_cmp_eq_i16_e64_dpp s[10:11], v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x32,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_i16_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: v_cmp_eq_i16_e64_dpp s[10:11], v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x32,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_i16_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: v_cmp_eq_i16_e64_dpp s[10:11], v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x32,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_i16_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: v_cmp_eq_i16_e64_dpp s[10:11], v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x32,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_i16_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: v_cmp_eq_i16_e64_dpp s[10:11], v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x32,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_i16_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: v_cmp_eq_i16_e64_dpp s[10:11], v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x32,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_i16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: v_cmp_eq_i16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x68,0x00,0x32,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_i16_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: v_cmp_eq_i16_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6a,0x00,0x32,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_i16_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: v_cmp_eq_i16_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7a,0x00,0x32,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_i16_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cmp_eq_i16_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0x7c,0x00,0x32,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x05,0x30]

v_cmp_eq_i32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: v_cmp_eq_i32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x42,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_i32_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0]
// W32: v_cmp_eq_i32_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x42,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_i32_e64_dpp s5, v1, 10 quad_perm:[3,2,1,0]
// W32: v_cmp_eq_i32_e64_dpp s5, v1, 10 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x42,0xd4,0xfa,0x14,0x01,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_i32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: v_cmp_eq_i32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x42,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_i32_e64_dpp s5, v1, v2 row_mirror
// W32: v_cmp_eq_i32_e64_dpp s5, v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x42,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_i32_e64_dpp s5, v1, v2 row_half_mirror
// W32: v_cmp_eq_i32_e64_dpp s5, v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x42,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_i32_e64_dpp s5, v1, v2 row_shl:1
// W32: v_cmp_eq_i32_e64_dpp s5, v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x42,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_i32_e64_dpp s5, v1, v2 row_shl:15
// W32: v_cmp_eq_i32_e64_dpp s5, v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x42,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_i32_e64_dpp s5, v1, v2 row_shr:1
// W32: v_cmp_eq_i32_e64_dpp s5, v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x42,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_i32_e64_dpp s5, v1, v2 row_shr:15
// W32: v_cmp_eq_i32_e64_dpp s5, v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x42,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_i32_e64_dpp s5, v1, v2 row_ror:1
// W32: v_cmp_eq_i32_e64_dpp s5, v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x42,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_i32_e64_dpp s105, v1, v2 row_ror:15
// W32: v_cmp_eq_i32_e64_dpp s105, v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x69,0x00,0x42,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_i32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: v_cmp_eq_i32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x6a,0x00,0x42,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_i32_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: v_cmp_eq_i32_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6b,0x00,0x42,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_i32_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: v_cmp_eq_i32_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7b,0x00,0x42,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_i32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: v_cmp_eq_i32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x42,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_i32_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0]
// W64: v_cmp_eq_i32_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x42,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_i32_e64_dpp s[10:11], v1, 10 quad_perm:[3,2,1,0]
// W64: v_cmp_eq_i32_e64_dpp s[10:11], v1, 10 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x42,0xd4,0xfa,0x14,0x01,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_i32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: v_cmp_eq_i32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x42,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_i32_e64_dpp s[10:11], v1, v2 row_mirror
// W64: v_cmp_eq_i32_e64_dpp s[10:11], v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x42,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_i32_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: v_cmp_eq_i32_e64_dpp s[10:11], v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x42,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_i32_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: v_cmp_eq_i32_e64_dpp s[10:11], v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x42,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_i32_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: v_cmp_eq_i32_e64_dpp s[10:11], v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x42,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_i32_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: v_cmp_eq_i32_e64_dpp s[10:11], v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x42,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_i32_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: v_cmp_eq_i32_e64_dpp s[10:11], v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x42,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_i32_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: v_cmp_eq_i32_e64_dpp s[10:11], v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x42,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_i32_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: v_cmp_eq_i32_e64_dpp s[10:11], v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x42,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_i32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: v_cmp_eq_i32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x68,0x00,0x42,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_i32_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: v_cmp_eq_i32_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6a,0x00,0x42,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_i32_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: v_cmp_eq_i32_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7a,0x00,0x42,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_i32_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cmp_eq_i32_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0x7c,0x00,0x42,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x05,0x30]

v_cmp_eq_u16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: v_cmp_eq_u16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x3a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_u16_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0]
// W32: v_cmp_eq_u16_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x3a,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_u16_e64_dpp s5, v1, 10 quad_perm:[3,2,1,0]
// W32: v_cmp_eq_u16_e64_dpp s5, v1, 10 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x3a,0xd4,0xfa,0x14,0x01,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_u16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: v_cmp_eq_u16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x3a,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_u16_e64_dpp s5, v1, v2 row_mirror
// W32: v_cmp_eq_u16_e64_dpp s5, v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x3a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_u16_e64_dpp s5, v1, v2 row_half_mirror
// W32: v_cmp_eq_u16_e64_dpp s5, v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x3a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_u16_e64_dpp s5, v1, v2 row_shl:1
// W32: v_cmp_eq_u16_e64_dpp s5, v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x3a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_u16_e64_dpp s5, v1, v2 row_shl:15
// W32: v_cmp_eq_u16_e64_dpp s5, v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x3a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_u16_e64_dpp s5, v1, v2 row_shr:1
// W32: v_cmp_eq_u16_e64_dpp s5, v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x3a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_u16_e64_dpp s5, v1, v2 row_shr:15
// W32: v_cmp_eq_u16_e64_dpp s5, v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x3a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_u16_e64_dpp s5, v1, v2 row_ror:1
// W32: v_cmp_eq_u16_e64_dpp s5, v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x3a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_u16_e64_dpp s105, v1, v2 row_ror:15
// W32: v_cmp_eq_u16_e64_dpp s105, v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x69,0x00,0x3a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_u16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: v_cmp_eq_u16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x6a,0x00,0x3a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_u16_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: v_cmp_eq_u16_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6b,0x00,0x3a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_u16_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: v_cmp_eq_u16_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7b,0x00,0x3a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_u16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: v_cmp_eq_u16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x3a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_u16_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0]
// W64: v_cmp_eq_u16_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x3a,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_u16_e64_dpp s[10:11], v1, 10 quad_perm:[3,2,1,0]
// W64: v_cmp_eq_u16_e64_dpp s[10:11], v1, 10 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x3a,0xd4,0xfa,0x14,0x01,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_u16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: v_cmp_eq_u16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x3a,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_u16_e64_dpp s[10:11], v1, v2 row_mirror
// W64: v_cmp_eq_u16_e64_dpp s[10:11], v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x3a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_u16_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: v_cmp_eq_u16_e64_dpp s[10:11], v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x3a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_u16_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: v_cmp_eq_u16_e64_dpp s[10:11], v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x3a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_u16_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: v_cmp_eq_u16_e64_dpp s[10:11], v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x3a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_u16_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: v_cmp_eq_u16_e64_dpp s[10:11], v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x3a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_u16_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: v_cmp_eq_u16_e64_dpp s[10:11], v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x3a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_u16_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: v_cmp_eq_u16_e64_dpp s[10:11], v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x3a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_u16_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: v_cmp_eq_u16_e64_dpp s[10:11], v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x3a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_u16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: v_cmp_eq_u16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x68,0x00,0x3a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_u16_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: v_cmp_eq_u16_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6a,0x00,0x3a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_u16_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: v_cmp_eq_u16_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7a,0x00,0x3a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_u16_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cmp_eq_u16_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0x7c,0x00,0x3a,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x05,0x30]

v_cmp_eq_u32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: v_cmp_eq_u32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x4a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_u32_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0]
// W32: v_cmp_eq_u32_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x4a,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_u32_e64_dpp s5, v1, 10 quad_perm:[3,2,1,0]
// W32: v_cmp_eq_u32_e64_dpp s5, v1, 10 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x4a,0xd4,0xfa,0x14,0x01,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_u32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: v_cmp_eq_u32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x4a,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_u32_e64_dpp s5, v1, v2 row_mirror
// W32: v_cmp_eq_u32_e64_dpp s5, v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x4a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_u32_e64_dpp s5, v1, v2 row_half_mirror
// W32: v_cmp_eq_u32_e64_dpp s5, v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x4a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_u32_e64_dpp s5, v1, v2 row_shl:1
// W32: v_cmp_eq_u32_e64_dpp s5, v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x4a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_u32_e64_dpp s5, v1, v2 row_shl:15
// W32: v_cmp_eq_u32_e64_dpp s5, v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x4a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_u32_e64_dpp s5, v1, v2 row_shr:1
// W32: v_cmp_eq_u32_e64_dpp s5, v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x4a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_u32_e64_dpp s5, v1, v2 row_shr:15
// W32: v_cmp_eq_u32_e64_dpp s5, v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x4a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_u32_e64_dpp s5, v1, v2 row_ror:1
// W32: v_cmp_eq_u32_e64_dpp s5, v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x4a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_u32_e64_dpp s105, v1, v2 row_ror:15
// W32: v_cmp_eq_u32_e64_dpp s105, v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x69,0x00,0x4a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_u32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: v_cmp_eq_u32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x6a,0x00,0x4a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_u32_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: v_cmp_eq_u32_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6b,0x00,0x4a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_u32_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: v_cmp_eq_u32_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7b,0x00,0x4a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_u32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: v_cmp_eq_u32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x4a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_u32_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0]
// W64: v_cmp_eq_u32_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x4a,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_u32_e64_dpp s[10:11], v1, 10 quad_perm:[3,2,1,0]
// W64: v_cmp_eq_u32_e64_dpp s[10:11], v1, 10 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x4a,0xd4,0xfa,0x14,0x01,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_u32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: v_cmp_eq_u32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x4a,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_u32_e64_dpp s[10:11], v1, v2 row_mirror
// W64: v_cmp_eq_u32_e64_dpp s[10:11], v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x4a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_u32_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: v_cmp_eq_u32_e64_dpp s[10:11], v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x4a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_u32_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: v_cmp_eq_u32_e64_dpp s[10:11], v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x4a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_u32_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: v_cmp_eq_u32_e64_dpp s[10:11], v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x4a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_u32_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: v_cmp_eq_u32_e64_dpp s[10:11], v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x4a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_u32_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: v_cmp_eq_u32_e64_dpp s[10:11], v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x4a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_u32_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: v_cmp_eq_u32_e64_dpp s[10:11], v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x4a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_u32_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: v_cmp_eq_u32_e64_dpp s[10:11], v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x4a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_u32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: v_cmp_eq_u32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x68,0x00,0x4a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_u32_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: v_cmp_eq_u32_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6a,0x00,0x4a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_u32_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: v_cmp_eq_u32_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7a,0x00,0x4a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_eq_u32_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cmp_eq_u32_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0x7c,0x00,0x4a,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x05,0x30]

v_cmp_ge_f16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: v_cmp_ge_f16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x06,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_f16_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0]
// W32: v_cmp_ge_f16_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x06,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_f16_e64_dpp s5, v1, 2.0 quad_perm:[3,2,1,0]
// W32: v_cmp_ge_f16_e64_dpp s5, v1, 2.0 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x06,0xd4,0xfa,0xe8,0x01,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_f16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: v_cmp_ge_f16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x06,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_f16_e64_dpp s5, v1, v2 row_mirror
// W32: v_cmp_ge_f16_e64_dpp s5, v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x06,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_f16_e64_dpp s5, v1, v2 row_half_mirror
// W32: v_cmp_ge_f16_e64_dpp s5, v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x06,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_f16_e64_dpp s5, v1, v2 row_shl:1
// W32: v_cmp_ge_f16_e64_dpp s5, v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x06,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_f16_e64_dpp s5, v1, v2 row_shl:15
// W32: v_cmp_ge_f16_e64_dpp s5, v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x06,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_f16_e64_dpp s5, v1, v2 row_shr:1
// W32: v_cmp_ge_f16_e64_dpp s5, v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x06,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_f16_e64_dpp s5, v1, v2 row_shr:15
// W32: v_cmp_ge_f16_e64_dpp s5, v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x06,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_f16_e64_dpp s5, v1, v2 row_ror:1
// W32: v_cmp_ge_f16_e64_dpp s5, v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x06,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_f16_e64_dpp s105, v1, v2 row_ror:15
// W32: v_cmp_ge_f16_e64_dpp s105, v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x69,0x00,0x06,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_f16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: v_cmp_ge_f16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x6a,0x00,0x06,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_f16_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: v_cmp_ge_f16_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6b,0x01,0x06,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_f16_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: v_cmp_ge_f16_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7b,0x02,0x06,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_f16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: v_cmp_ge_f16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x06,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_f16_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0]
// W64: v_cmp_ge_f16_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x06,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_f16_e64_dpp s[10:11], v1, 2.0 quad_perm:[3,2,1,0]
// W64: v_cmp_ge_f16_e64_dpp s[10:11], v1, 2.0 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x06,0xd4,0xfa,0xe8,0x01,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_f16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: v_cmp_ge_f16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x06,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_f16_e64_dpp s[10:11], v1, v2 row_mirror
// W64: v_cmp_ge_f16_e64_dpp s[10:11], v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x06,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_f16_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: v_cmp_ge_f16_e64_dpp s[10:11], v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x06,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_f16_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: v_cmp_ge_f16_e64_dpp s[10:11], v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x06,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_f16_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: v_cmp_ge_f16_e64_dpp s[10:11], v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x06,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_f16_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: v_cmp_ge_f16_e64_dpp s[10:11], v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x06,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_f16_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: v_cmp_ge_f16_e64_dpp s[10:11], v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x06,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_f16_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: v_cmp_ge_f16_e64_dpp s[10:11], v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x06,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_f16_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: v_cmp_ge_f16_e64_dpp s[10:11], v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x06,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_f16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: v_cmp_ge_f16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x68,0x00,0x06,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_f16_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: v_cmp_ge_f16_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6a,0x01,0x06,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_f16_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: v_cmp_ge_f16_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7a,0x02,0x06,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_f16_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cmp_ge_f16_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0x7c,0x83,0x06,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x05,0x30]

v_cmp_ge_f32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: v_cmp_ge_f32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x16,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_f32_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0]
// W32: v_cmp_ge_f32_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x16,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_f32_e64_dpp s5, v1, 2.0 quad_perm:[3,2,1,0]
// W32: v_cmp_ge_f32_e64_dpp s5, v1, 2.0 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x16,0xd4,0xfa,0xe8,0x01,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_f32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: v_cmp_ge_f32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x16,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_f32_e64_dpp s5, v1, v2 row_mirror
// W32: v_cmp_ge_f32_e64_dpp s5, v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x16,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_f32_e64_dpp s5, v1, v2 row_half_mirror
// W32: v_cmp_ge_f32_e64_dpp s5, v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x16,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_f32_e64_dpp s5, v1, v2 row_shl:1
// W32: v_cmp_ge_f32_e64_dpp s5, v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x16,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_f32_e64_dpp s5, v1, v2 row_shl:15
// W32: v_cmp_ge_f32_e64_dpp s5, v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x16,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_f32_e64_dpp s5, v1, v2 row_shr:1
// W32: v_cmp_ge_f32_e64_dpp s5, v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x16,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_f32_e64_dpp s5, v1, v2 row_shr:15
// W32: v_cmp_ge_f32_e64_dpp s5, v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x16,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_f32_e64_dpp s5, v1, v2 row_ror:1
// W32: v_cmp_ge_f32_e64_dpp s5, v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x16,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_f32_e64_dpp s105, v1, v2 row_ror:15
// W32: v_cmp_ge_f32_e64_dpp s105, v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x69,0x00,0x16,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_f32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: v_cmp_ge_f32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x6a,0x00,0x16,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_f32_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: v_cmp_ge_f32_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6b,0x01,0x16,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_f32_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: v_cmp_ge_f32_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7b,0x02,0x16,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_f32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: v_cmp_ge_f32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x16,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_f32_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0]
// W64: v_cmp_ge_f32_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x16,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_f32_e64_dpp s[10:11], v1, 2.0 quad_perm:[3,2,1,0]
// W64: v_cmp_ge_f32_e64_dpp s[10:11], v1, 2.0 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x16,0xd4,0xfa,0xe8,0x01,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_f32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: v_cmp_ge_f32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x16,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_f32_e64_dpp s[10:11], v1, v2 row_mirror
// W64: v_cmp_ge_f32_e64_dpp s[10:11], v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x16,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_f32_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: v_cmp_ge_f32_e64_dpp s[10:11], v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x16,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_f32_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: v_cmp_ge_f32_e64_dpp s[10:11], v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x16,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_f32_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: v_cmp_ge_f32_e64_dpp s[10:11], v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x16,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_f32_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: v_cmp_ge_f32_e64_dpp s[10:11], v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x16,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_f32_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: v_cmp_ge_f32_e64_dpp s[10:11], v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x16,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_f32_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: v_cmp_ge_f32_e64_dpp s[10:11], v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x16,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_f32_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: v_cmp_ge_f32_e64_dpp s[10:11], v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x16,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_f32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: v_cmp_ge_f32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x68,0x00,0x16,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_f32_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: v_cmp_ge_f32_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6a,0x01,0x16,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_f32_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: v_cmp_ge_f32_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7a,0x02,0x16,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_f32_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cmp_ge_f32_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0x7c,0x83,0x16,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x05,0x30]

v_cmp_ge_i16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: v_cmp_ge_i16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x36,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_i16_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0]
// W32: v_cmp_ge_i16_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x36,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_i16_e64_dpp s5, v1, 10 quad_perm:[3,2,1,0]
// W32: v_cmp_ge_i16_e64_dpp s5, v1, 10 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x36,0xd4,0xfa,0x14,0x01,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_i16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: v_cmp_ge_i16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x36,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_i16_e64_dpp s5, v1, v2 row_mirror
// W32: v_cmp_ge_i16_e64_dpp s5, v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x36,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_i16_e64_dpp s5, v1, v2 row_half_mirror
// W32: v_cmp_ge_i16_e64_dpp s5, v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x36,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_i16_e64_dpp s5, v1, v2 row_shl:1
// W32: v_cmp_ge_i16_e64_dpp s5, v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x36,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_i16_e64_dpp s5, v1, v2 row_shl:15
// W32: v_cmp_ge_i16_e64_dpp s5, v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x36,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_i16_e64_dpp s5, v1, v2 row_shr:1
// W32: v_cmp_ge_i16_e64_dpp s5, v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x36,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_i16_e64_dpp s5, v1, v2 row_shr:15
// W32: v_cmp_ge_i16_e64_dpp s5, v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x36,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_i16_e64_dpp s5, v1, v2 row_ror:1
// W32: v_cmp_ge_i16_e64_dpp s5, v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x36,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_i16_e64_dpp s105, v1, v2 row_ror:15
// W32: v_cmp_ge_i16_e64_dpp s105, v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x69,0x00,0x36,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_i16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: v_cmp_ge_i16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x6a,0x00,0x36,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_i16_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: v_cmp_ge_i16_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6b,0x00,0x36,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_i16_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: v_cmp_ge_i16_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7b,0x00,0x36,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_i16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: v_cmp_ge_i16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x36,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_i16_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0]
// W64: v_cmp_ge_i16_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x36,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_i16_e64_dpp s[10:11], v1, 10 quad_perm:[3,2,1,0]
// W64: v_cmp_ge_i16_e64_dpp s[10:11], v1, 10 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x36,0xd4,0xfa,0x14,0x01,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_i16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: v_cmp_ge_i16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x36,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_i16_e64_dpp s[10:11], v1, v2 row_mirror
// W64: v_cmp_ge_i16_e64_dpp s[10:11], v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x36,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_i16_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: v_cmp_ge_i16_e64_dpp s[10:11], v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x36,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_i16_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: v_cmp_ge_i16_e64_dpp s[10:11], v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x36,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_i16_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: v_cmp_ge_i16_e64_dpp s[10:11], v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x36,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_i16_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: v_cmp_ge_i16_e64_dpp s[10:11], v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x36,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_i16_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: v_cmp_ge_i16_e64_dpp s[10:11], v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x36,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_i16_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: v_cmp_ge_i16_e64_dpp s[10:11], v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x36,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_i16_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: v_cmp_ge_i16_e64_dpp s[10:11], v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x36,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_i16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: v_cmp_ge_i16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x68,0x00,0x36,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_i16_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: v_cmp_ge_i16_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6a,0x00,0x36,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_i16_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: v_cmp_ge_i16_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7a,0x00,0x36,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_i16_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cmp_ge_i16_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0x7c,0x00,0x36,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x05,0x30]

v_cmp_ge_i32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: v_cmp_ge_i32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x46,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_i32_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0]
// W32: v_cmp_ge_i32_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x46,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_i32_e64_dpp s5, v1, 10 quad_perm:[3,2,1,0]
// W32: v_cmp_ge_i32_e64_dpp s5, v1, 10 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x46,0xd4,0xfa,0x14,0x01,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_i32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: v_cmp_ge_i32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x46,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_i32_e64_dpp s5, v1, v2 row_mirror
// W32: v_cmp_ge_i32_e64_dpp s5, v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x46,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_i32_e64_dpp s5, v1, v2 row_half_mirror
// W32: v_cmp_ge_i32_e64_dpp s5, v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x46,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_i32_e64_dpp s5, v1, v2 row_shl:1
// W32: v_cmp_ge_i32_e64_dpp s5, v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x46,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_i32_e64_dpp s5, v1, v2 row_shl:15
// W32: v_cmp_ge_i32_e64_dpp s5, v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x46,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_i32_e64_dpp s5, v1, v2 row_shr:1
// W32: v_cmp_ge_i32_e64_dpp s5, v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x46,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_i32_e64_dpp s5, v1, v2 row_shr:15
// W32: v_cmp_ge_i32_e64_dpp s5, v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x46,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_i32_e64_dpp s5, v1, v2 row_ror:1
// W32: v_cmp_ge_i32_e64_dpp s5, v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x46,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_i32_e64_dpp s105, v1, v2 row_ror:15
// W32: v_cmp_ge_i32_e64_dpp s105, v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x69,0x00,0x46,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_i32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: v_cmp_ge_i32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x6a,0x00,0x46,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_i32_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: v_cmp_ge_i32_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6b,0x00,0x46,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_i32_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: v_cmp_ge_i32_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7b,0x00,0x46,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_i32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: v_cmp_ge_i32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x46,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_i32_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0]
// W64: v_cmp_ge_i32_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x46,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_i32_e64_dpp s[10:11], v1, 10 quad_perm:[3,2,1,0]
// W64: v_cmp_ge_i32_e64_dpp s[10:11], v1, 10 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x46,0xd4,0xfa,0x14,0x01,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_i32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: v_cmp_ge_i32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x46,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_i32_e64_dpp s[10:11], v1, v2 row_mirror
// W64: v_cmp_ge_i32_e64_dpp s[10:11], v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x46,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_i32_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: v_cmp_ge_i32_e64_dpp s[10:11], v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x46,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_i32_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: v_cmp_ge_i32_e64_dpp s[10:11], v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x46,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_i32_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: v_cmp_ge_i32_e64_dpp s[10:11], v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x46,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_i32_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: v_cmp_ge_i32_e64_dpp s[10:11], v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x46,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_i32_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: v_cmp_ge_i32_e64_dpp s[10:11], v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x46,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_i32_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: v_cmp_ge_i32_e64_dpp s[10:11], v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x46,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_i32_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: v_cmp_ge_i32_e64_dpp s[10:11], v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x46,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_i32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: v_cmp_ge_i32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x68,0x00,0x46,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_i32_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: v_cmp_ge_i32_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6a,0x00,0x46,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_i32_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: v_cmp_ge_i32_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7a,0x00,0x46,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_i32_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cmp_ge_i32_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0x7c,0x00,0x46,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x05,0x30]

v_cmp_ge_u16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: v_cmp_ge_u16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x3e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_u16_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0]
// W32: v_cmp_ge_u16_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x3e,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_u16_e64_dpp s5, v1, 10 quad_perm:[3,2,1,0]
// W32: v_cmp_ge_u16_e64_dpp s5, v1, 10 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x3e,0xd4,0xfa,0x14,0x01,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_u16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: v_cmp_ge_u16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x3e,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_u16_e64_dpp s5, v1, v2 row_mirror
// W32: v_cmp_ge_u16_e64_dpp s5, v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x3e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_u16_e64_dpp s5, v1, v2 row_half_mirror
// W32: v_cmp_ge_u16_e64_dpp s5, v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x3e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_u16_e64_dpp s5, v1, v2 row_shl:1
// W32: v_cmp_ge_u16_e64_dpp s5, v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x3e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_u16_e64_dpp s5, v1, v2 row_shl:15
// W32: v_cmp_ge_u16_e64_dpp s5, v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x3e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_u16_e64_dpp s5, v1, v2 row_shr:1
// W32: v_cmp_ge_u16_e64_dpp s5, v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x3e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_u16_e64_dpp s5, v1, v2 row_shr:15
// W32: v_cmp_ge_u16_e64_dpp s5, v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x3e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_u16_e64_dpp s5, v1, v2 row_ror:1
// W32: v_cmp_ge_u16_e64_dpp s5, v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x3e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_u16_e64_dpp s105, v1, v2 row_ror:15
// W32: v_cmp_ge_u16_e64_dpp s105, v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x69,0x00,0x3e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_u16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: v_cmp_ge_u16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x6a,0x00,0x3e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_u16_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: v_cmp_ge_u16_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6b,0x00,0x3e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_u16_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: v_cmp_ge_u16_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7b,0x00,0x3e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_u16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: v_cmp_ge_u16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x3e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_u16_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0]
// W64: v_cmp_ge_u16_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x3e,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_u16_e64_dpp s[10:11], v1, 10 quad_perm:[3,2,1,0]
// W64: v_cmp_ge_u16_e64_dpp s[10:11], v1, 10 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x3e,0xd4,0xfa,0x14,0x01,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_u16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: v_cmp_ge_u16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x3e,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_u16_e64_dpp s[10:11], v1, v2 row_mirror
// W64: v_cmp_ge_u16_e64_dpp s[10:11], v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x3e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_u16_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: v_cmp_ge_u16_e64_dpp s[10:11], v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x3e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_u16_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: v_cmp_ge_u16_e64_dpp s[10:11], v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x3e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_u16_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: v_cmp_ge_u16_e64_dpp s[10:11], v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x3e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_u16_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: v_cmp_ge_u16_e64_dpp s[10:11], v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x3e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_u16_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: v_cmp_ge_u16_e64_dpp s[10:11], v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x3e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_u16_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: v_cmp_ge_u16_e64_dpp s[10:11], v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x3e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_u16_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: v_cmp_ge_u16_e64_dpp s[10:11], v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x3e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_u16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: v_cmp_ge_u16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x68,0x00,0x3e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_u16_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: v_cmp_ge_u16_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6a,0x00,0x3e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_u16_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: v_cmp_ge_u16_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7a,0x00,0x3e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_u16_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cmp_ge_u16_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0x7c,0x00,0x3e,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x05,0x30]

v_cmp_ge_u32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: v_cmp_ge_u32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x4e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_u32_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0]
// W32: v_cmp_ge_u32_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x4e,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_u32_e64_dpp s5, v1, 10 quad_perm:[3,2,1,0]
// W32: v_cmp_ge_u32_e64_dpp s5, v1, 10 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x4e,0xd4,0xfa,0x14,0x01,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_u32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: v_cmp_ge_u32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x4e,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_u32_e64_dpp s5, v1, v2 row_mirror
// W32: v_cmp_ge_u32_e64_dpp s5, v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x4e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_u32_e64_dpp s5, v1, v2 row_half_mirror
// W32: v_cmp_ge_u32_e64_dpp s5, v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x4e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_u32_e64_dpp s5, v1, v2 row_shl:1
// W32: v_cmp_ge_u32_e64_dpp s5, v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x4e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_u32_e64_dpp s5, v1, v2 row_shl:15
// W32: v_cmp_ge_u32_e64_dpp s5, v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x4e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_u32_e64_dpp s5, v1, v2 row_shr:1
// W32: v_cmp_ge_u32_e64_dpp s5, v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x4e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_u32_e64_dpp s5, v1, v2 row_shr:15
// W32: v_cmp_ge_u32_e64_dpp s5, v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x4e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_u32_e64_dpp s5, v1, v2 row_ror:1
// W32: v_cmp_ge_u32_e64_dpp s5, v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x4e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_u32_e64_dpp s105, v1, v2 row_ror:15
// W32: v_cmp_ge_u32_e64_dpp s105, v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x69,0x00,0x4e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_u32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: v_cmp_ge_u32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x6a,0x00,0x4e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_u32_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: v_cmp_ge_u32_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6b,0x00,0x4e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_u32_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: v_cmp_ge_u32_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7b,0x00,0x4e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_u32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: v_cmp_ge_u32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x4e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_u32_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0]
// W64: v_cmp_ge_u32_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x4e,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_u32_e64_dpp s[10:11], v1, 10 quad_perm:[3,2,1,0]
// W64: v_cmp_ge_u32_e64_dpp s[10:11], v1, 10 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x4e,0xd4,0xfa,0x14,0x01,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_u32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: v_cmp_ge_u32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x4e,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_u32_e64_dpp s[10:11], v1, v2 row_mirror
// W64: v_cmp_ge_u32_e64_dpp s[10:11], v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x4e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_u32_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: v_cmp_ge_u32_e64_dpp s[10:11], v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x4e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_u32_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: v_cmp_ge_u32_e64_dpp s[10:11], v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x4e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_u32_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: v_cmp_ge_u32_e64_dpp s[10:11], v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x4e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_u32_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: v_cmp_ge_u32_e64_dpp s[10:11], v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x4e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_u32_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: v_cmp_ge_u32_e64_dpp s[10:11], v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x4e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_u32_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: v_cmp_ge_u32_e64_dpp s[10:11], v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x4e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_u32_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: v_cmp_ge_u32_e64_dpp s[10:11], v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x4e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_u32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: v_cmp_ge_u32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x68,0x00,0x4e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_u32_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: v_cmp_ge_u32_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6a,0x00,0x4e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_u32_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: v_cmp_ge_u32_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7a,0x00,0x4e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ge_u32_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cmp_ge_u32_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0x7c,0x00,0x4e,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x05,0x30]

v_cmp_gt_f16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: v_cmp_gt_f16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x04,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_f16_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0]
// W32: v_cmp_gt_f16_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x04,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_f16_e64_dpp s5, v1, 2.0 quad_perm:[3,2,1,0]
// W32: v_cmp_gt_f16_e64_dpp s5, v1, 2.0 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x04,0xd4,0xfa,0xe8,0x01,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_f16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: v_cmp_gt_f16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x04,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_f16_e64_dpp s5, v1, v2 row_mirror
// W32: v_cmp_gt_f16_e64_dpp s5, v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x04,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_f16_e64_dpp s5, v1, v2 row_half_mirror
// W32: v_cmp_gt_f16_e64_dpp s5, v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x04,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_f16_e64_dpp s5, v1, v2 row_shl:1
// W32: v_cmp_gt_f16_e64_dpp s5, v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x04,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_f16_e64_dpp s5, v1, v2 row_shl:15
// W32: v_cmp_gt_f16_e64_dpp s5, v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x04,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_f16_e64_dpp s5, v1, v2 row_shr:1
// W32: v_cmp_gt_f16_e64_dpp s5, v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x04,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_f16_e64_dpp s5, v1, v2 row_shr:15
// W32: v_cmp_gt_f16_e64_dpp s5, v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x04,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_f16_e64_dpp s5, v1, v2 row_ror:1
// W32: v_cmp_gt_f16_e64_dpp s5, v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x04,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_f16_e64_dpp s105, v1, v2 row_ror:15
// W32: v_cmp_gt_f16_e64_dpp s105, v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x69,0x00,0x04,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_f16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: v_cmp_gt_f16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x6a,0x00,0x04,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_f16_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: v_cmp_gt_f16_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6b,0x01,0x04,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_f16_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: v_cmp_gt_f16_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7b,0x02,0x04,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_f16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: v_cmp_gt_f16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x04,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_f16_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0]
// W64: v_cmp_gt_f16_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x04,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_f16_e64_dpp s[10:11], v1, 2.0 quad_perm:[3,2,1,0]
// W64: v_cmp_gt_f16_e64_dpp s[10:11], v1, 2.0 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x04,0xd4,0xfa,0xe8,0x01,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_f16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: v_cmp_gt_f16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x04,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_f16_e64_dpp s[10:11], v1, v2 row_mirror
// W64: v_cmp_gt_f16_e64_dpp s[10:11], v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x04,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_f16_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: v_cmp_gt_f16_e64_dpp s[10:11], v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x04,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_f16_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: v_cmp_gt_f16_e64_dpp s[10:11], v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x04,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_f16_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: v_cmp_gt_f16_e64_dpp s[10:11], v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x04,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_f16_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: v_cmp_gt_f16_e64_dpp s[10:11], v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x04,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_f16_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: v_cmp_gt_f16_e64_dpp s[10:11], v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x04,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_f16_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: v_cmp_gt_f16_e64_dpp s[10:11], v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x04,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_f16_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: v_cmp_gt_f16_e64_dpp s[10:11], v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x04,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_f16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: v_cmp_gt_f16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x68,0x00,0x04,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_f16_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: v_cmp_gt_f16_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6a,0x01,0x04,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_f16_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: v_cmp_gt_f16_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7a,0x02,0x04,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_f16_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cmp_gt_f16_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0x7c,0x83,0x04,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x05,0x30]

v_cmp_gt_f32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: v_cmp_gt_f32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x14,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_f32_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0]
// W32: v_cmp_gt_f32_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x14,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_f32_e64_dpp s5, v1, 2.0 quad_perm:[3,2,1,0]
// W32: v_cmp_gt_f32_e64_dpp s5, v1, 2.0 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x14,0xd4,0xfa,0xe8,0x01,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_f32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: v_cmp_gt_f32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x14,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_f32_e64_dpp s5, v1, v2 row_mirror
// W32: v_cmp_gt_f32_e64_dpp s5, v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x14,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_f32_e64_dpp s5, v1, v2 row_half_mirror
// W32: v_cmp_gt_f32_e64_dpp s5, v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x14,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_f32_e64_dpp s5, v1, v2 row_shl:1
// W32: v_cmp_gt_f32_e64_dpp s5, v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x14,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_f32_e64_dpp s5, v1, v2 row_shl:15
// W32: v_cmp_gt_f32_e64_dpp s5, v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x14,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_f32_e64_dpp s5, v1, v2 row_shr:1
// W32: v_cmp_gt_f32_e64_dpp s5, v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x14,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_f32_e64_dpp s5, v1, v2 row_shr:15
// W32: v_cmp_gt_f32_e64_dpp s5, v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x14,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_f32_e64_dpp s5, v1, v2 row_ror:1
// W32: v_cmp_gt_f32_e64_dpp s5, v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x14,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_f32_e64_dpp s105, v1, v2 row_ror:15
// W32: v_cmp_gt_f32_e64_dpp s105, v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x69,0x00,0x14,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_f32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: v_cmp_gt_f32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x6a,0x00,0x14,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_f32_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: v_cmp_gt_f32_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6b,0x01,0x14,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_f32_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: v_cmp_gt_f32_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7b,0x02,0x14,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_f32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: v_cmp_gt_f32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x14,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_f32_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0]
// W64: v_cmp_gt_f32_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x14,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_f32_e64_dpp s[10:11], v1, 2.0 quad_perm:[3,2,1,0]
// W64: v_cmp_gt_f32_e64_dpp s[10:11], v1, 2.0 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x14,0xd4,0xfa,0xe8,0x01,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_f32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: v_cmp_gt_f32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x14,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_f32_e64_dpp s[10:11], v1, v2 row_mirror
// W64: v_cmp_gt_f32_e64_dpp s[10:11], v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x14,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_f32_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: v_cmp_gt_f32_e64_dpp s[10:11], v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x14,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_f32_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: v_cmp_gt_f32_e64_dpp s[10:11], v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x14,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_f32_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: v_cmp_gt_f32_e64_dpp s[10:11], v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x14,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_f32_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: v_cmp_gt_f32_e64_dpp s[10:11], v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x14,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_f32_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: v_cmp_gt_f32_e64_dpp s[10:11], v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x14,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_f32_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: v_cmp_gt_f32_e64_dpp s[10:11], v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x14,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_f32_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: v_cmp_gt_f32_e64_dpp s[10:11], v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x14,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_f32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: v_cmp_gt_f32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x68,0x00,0x14,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_f32_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: v_cmp_gt_f32_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6a,0x01,0x14,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_f32_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: v_cmp_gt_f32_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7a,0x02,0x14,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_f32_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cmp_gt_f32_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0x7c,0x83,0x14,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x05,0x30]

v_cmp_gt_i16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: v_cmp_gt_i16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x34,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_i16_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0]
// W32: v_cmp_gt_i16_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x34,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_i16_e64_dpp s5, v1, 10 quad_perm:[3,2,1,0]
// W32: v_cmp_gt_i16_e64_dpp s5, v1, 10 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x34,0xd4,0xfa,0x14,0x01,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_i16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: v_cmp_gt_i16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x34,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_i16_e64_dpp s5, v1, v2 row_mirror
// W32: v_cmp_gt_i16_e64_dpp s5, v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x34,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_i16_e64_dpp s5, v1, v2 row_half_mirror
// W32: v_cmp_gt_i16_e64_dpp s5, v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x34,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_i16_e64_dpp s5, v1, v2 row_shl:1
// W32: v_cmp_gt_i16_e64_dpp s5, v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x34,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_i16_e64_dpp s5, v1, v2 row_shl:15
// W32: v_cmp_gt_i16_e64_dpp s5, v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x34,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_i16_e64_dpp s5, v1, v2 row_shr:1
// W32: v_cmp_gt_i16_e64_dpp s5, v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x34,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_i16_e64_dpp s5, v1, v2 row_shr:15
// W32: v_cmp_gt_i16_e64_dpp s5, v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x34,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_i16_e64_dpp s5, v1, v2 row_ror:1
// W32: v_cmp_gt_i16_e64_dpp s5, v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x34,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_i16_e64_dpp s105, v1, v2 row_ror:15
// W32: v_cmp_gt_i16_e64_dpp s105, v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x69,0x00,0x34,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_i16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: v_cmp_gt_i16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x6a,0x00,0x34,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_i16_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: v_cmp_gt_i16_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6b,0x00,0x34,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_i16_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: v_cmp_gt_i16_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7b,0x00,0x34,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_i16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: v_cmp_gt_i16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x34,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_i16_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0]
// W64: v_cmp_gt_i16_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x34,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_i16_e64_dpp s[10:11], v1, 10 quad_perm:[3,2,1,0]
// W64: v_cmp_gt_i16_e64_dpp s[10:11], v1, 10 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x34,0xd4,0xfa,0x14,0x01,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_i16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: v_cmp_gt_i16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x34,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_i16_e64_dpp s[10:11], v1, v2 row_mirror
// W64: v_cmp_gt_i16_e64_dpp s[10:11], v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x34,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_i16_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: v_cmp_gt_i16_e64_dpp s[10:11], v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x34,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_i16_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: v_cmp_gt_i16_e64_dpp s[10:11], v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x34,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_i16_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: v_cmp_gt_i16_e64_dpp s[10:11], v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x34,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_i16_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: v_cmp_gt_i16_e64_dpp s[10:11], v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x34,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_i16_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: v_cmp_gt_i16_e64_dpp s[10:11], v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x34,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_i16_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: v_cmp_gt_i16_e64_dpp s[10:11], v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x34,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_i16_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: v_cmp_gt_i16_e64_dpp s[10:11], v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x34,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_i16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: v_cmp_gt_i16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x68,0x00,0x34,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_i16_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: v_cmp_gt_i16_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6a,0x00,0x34,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_i16_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: v_cmp_gt_i16_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7a,0x00,0x34,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_i16_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cmp_gt_i16_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0x7c,0x00,0x34,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x05,0x30]

v_cmp_gt_i32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: v_cmp_gt_i32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x44,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_i32_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0]
// W32: v_cmp_gt_i32_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x44,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_i32_e64_dpp s5, v1, 10 quad_perm:[3,2,1,0]
// W32: v_cmp_gt_i32_e64_dpp s5, v1, 10 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x44,0xd4,0xfa,0x14,0x01,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_i32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: v_cmp_gt_i32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x44,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_i32_e64_dpp s5, v1, v2 row_mirror
// W32: v_cmp_gt_i32_e64_dpp s5, v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x44,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_i32_e64_dpp s5, v1, v2 row_half_mirror
// W32: v_cmp_gt_i32_e64_dpp s5, v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x44,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_i32_e64_dpp s5, v1, v2 row_shl:1
// W32: v_cmp_gt_i32_e64_dpp s5, v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x44,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_i32_e64_dpp s5, v1, v2 row_shl:15
// W32: v_cmp_gt_i32_e64_dpp s5, v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x44,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_i32_e64_dpp s5, v1, v2 row_shr:1
// W32: v_cmp_gt_i32_e64_dpp s5, v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x44,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_i32_e64_dpp s5, v1, v2 row_shr:15
// W32: v_cmp_gt_i32_e64_dpp s5, v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x44,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_i32_e64_dpp s5, v1, v2 row_ror:1
// W32: v_cmp_gt_i32_e64_dpp s5, v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x44,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_i32_e64_dpp s105, v1, v2 row_ror:15
// W32: v_cmp_gt_i32_e64_dpp s105, v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x69,0x00,0x44,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_i32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: v_cmp_gt_i32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x6a,0x00,0x44,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_i32_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: v_cmp_gt_i32_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6b,0x00,0x44,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_i32_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: v_cmp_gt_i32_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7b,0x00,0x44,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_i32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: v_cmp_gt_i32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x44,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_i32_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0]
// W64: v_cmp_gt_i32_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x44,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_i32_e64_dpp s[10:11], v1, 10 quad_perm:[3,2,1,0]
// W64: v_cmp_gt_i32_e64_dpp s[10:11], v1, 10 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x44,0xd4,0xfa,0x14,0x01,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_i32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: v_cmp_gt_i32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x44,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_i32_e64_dpp s[10:11], v1, v2 row_mirror
// W64: v_cmp_gt_i32_e64_dpp s[10:11], v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x44,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_i32_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: v_cmp_gt_i32_e64_dpp s[10:11], v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x44,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_i32_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: v_cmp_gt_i32_e64_dpp s[10:11], v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x44,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_i32_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: v_cmp_gt_i32_e64_dpp s[10:11], v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x44,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_i32_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: v_cmp_gt_i32_e64_dpp s[10:11], v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x44,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_i32_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: v_cmp_gt_i32_e64_dpp s[10:11], v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x44,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_i32_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: v_cmp_gt_i32_e64_dpp s[10:11], v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x44,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_i32_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: v_cmp_gt_i32_e64_dpp s[10:11], v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x44,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_i32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: v_cmp_gt_i32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x68,0x00,0x44,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_i32_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: v_cmp_gt_i32_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6a,0x00,0x44,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_i32_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: v_cmp_gt_i32_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7a,0x00,0x44,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_i32_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cmp_gt_i32_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0x7c,0x00,0x44,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x05,0x30]

v_cmp_gt_u16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: v_cmp_gt_u16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x3c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_u16_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0]
// W32: v_cmp_gt_u16_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x3c,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_u16_e64_dpp s5, v1, 10 quad_perm:[3,2,1,0]
// W32: v_cmp_gt_u16_e64_dpp s5, v1, 10 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x3c,0xd4,0xfa,0x14,0x01,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_u16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: v_cmp_gt_u16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x3c,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_u16_e64_dpp s5, v1, v2 row_mirror
// W32: v_cmp_gt_u16_e64_dpp s5, v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x3c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_u16_e64_dpp s5, v1, v2 row_half_mirror
// W32: v_cmp_gt_u16_e64_dpp s5, v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x3c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_u16_e64_dpp s5, v1, v2 row_shl:1
// W32: v_cmp_gt_u16_e64_dpp s5, v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x3c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_u16_e64_dpp s5, v1, v2 row_shl:15
// W32: v_cmp_gt_u16_e64_dpp s5, v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x3c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_u16_e64_dpp s5, v1, v2 row_shr:1
// W32: v_cmp_gt_u16_e64_dpp s5, v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x3c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_u16_e64_dpp s5, v1, v2 row_shr:15
// W32: v_cmp_gt_u16_e64_dpp s5, v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x3c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_u16_e64_dpp s5, v1, v2 row_ror:1
// W32: v_cmp_gt_u16_e64_dpp s5, v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x3c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_u16_e64_dpp s105, v1, v2 row_ror:15
// W32: v_cmp_gt_u16_e64_dpp s105, v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x69,0x00,0x3c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_u16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: v_cmp_gt_u16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x6a,0x00,0x3c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_u16_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: v_cmp_gt_u16_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6b,0x00,0x3c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_u16_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: v_cmp_gt_u16_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7b,0x00,0x3c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_u16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: v_cmp_gt_u16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x3c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_u16_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0]
// W64: v_cmp_gt_u16_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x3c,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_u16_e64_dpp s[10:11], v1, 10 quad_perm:[3,2,1,0]
// W64: v_cmp_gt_u16_e64_dpp s[10:11], v1, 10 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x3c,0xd4,0xfa,0x14,0x01,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_u16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: v_cmp_gt_u16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x3c,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_u16_e64_dpp s[10:11], v1, v2 row_mirror
// W64: v_cmp_gt_u16_e64_dpp s[10:11], v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x3c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_u16_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: v_cmp_gt_u16_e64_dpp s[10:11], v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x3c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_u16_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: v_cmp_gt_u16_e64_dpp s[10:11], v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x3c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_u16_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: v_cmp_gt_u16_e64_dpp s[10:11], v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x3c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_u16_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: v_cmp_gt_u16_e64_dpp s[10:11], v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x3c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_u16_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: v_cmp_gt_u16_e64_dpp s[10:11], v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x3c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_u16_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: v_cmp_gt_u16_e64_dpp s[10:11], v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x3c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_u16_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: v_cmp_gt_u16_e64_dpp s[10:11], v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x3c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_u16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: v_cmp_gt_u16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x68,0x00,0x3c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_u16_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: v_cmp_gt_u16_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6a,0x00,0x3c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_u16_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: v_cmp_gt_u16_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7a,0x00,0x3c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_u16_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cmp_gt_u16_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0x7c,0x00,0x3c,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x05,0x30]

v_cmp_gt_u32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: v_cmp_gt_u32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x4c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_u32_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0]
// W32: v_cmp_gt_u32_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x4c,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_u32_e64_dpp s5, v1, 10 quad_perm:[3,2,1,0]
// W32: v_cmp_gt_u32_e64_dpp s5, v1, 10 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x4c,0xd4,0xfa,0x14,0x01,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_u32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: v_cmp_gt_u32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x4c,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_u32_e64_dpp s5, v1, v2 row_mirror
// W32: v_cmp_gt_u32_e64_dpp s5, v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x4c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_u32_e64_dpp s5, v1, v2 row_half_mirror
// W32: v_cmp_gt_u32_e64_dpp s5, v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x4c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_u32_e64_dpp s5, v1, v2 row_shl:1
// W32: v_cmp_gt_u32_e64_dpp s5, v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x4c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_u32_e64_dpp s5, v1, v2 row_shl:15
// W32: v_cmp_gt_u32_e64_dpp s5, v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x4c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_u32_e64_dpp s5, v1, v2 row_shr:1
// W32: v_cmp_gt_u32_e64_dpp s5, v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x4c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_u32_e64_dpp s5, v1, v2 row_shr:15
// W32: v_cmp_gt_u32_e64_dpp s5, v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x4c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_u32_e64_dpp s5, v1, v2 row_ror:1
// W32: v_cmp_gt_u32_e64_dpp s5, v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x4c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_u32_e64_dpp s105, v1, v2 row_ror:15
// W32: v_cmp_gt_u32_e64_dpp s105, v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x69,0x00,0x4c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_u32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: v_cmp_gt_u32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x6a,0x00,0x4c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_u32_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: v_cmp_gt_u32_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6b,0x00,0x4c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_u32_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: v_cmp_gt_u32_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7b,0x00,0x4c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_u32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: v_cmp_gt_u32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x4c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_u32_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0]
// W64: v_cmp_gt_u32_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x4c,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_u32_e64_dpp s[10:11], v1, 10 quad_perm:[3,2,1,0]
// W64: v_cmp_gt_u32_e64_dpp s[10:11], v1, 10 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x4c,0xd4,0xfa,0x14,0x01,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_u32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: v_cmp_gt_u32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x4c,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_u32_e64_dpp s[10:11], v1, v2 row_mirror
// W64: v_cmp_gt_u32_e64_dpp s[10:11], v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x4c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_u32_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: v_cmp_gt_u32_e64_dpp s[10:11], v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x4c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_u32_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: v_cmp_gt_u32_e64_dpp s[10:11], v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x4c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_u32_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: v_cmp_gt_u32_e64_dpp s[10:11], v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x4c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_u32_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: v_cmp_gt_u32_e64_dpp s[10:11], v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x4c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_u32_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: v_cmp_gt_u32_e64_dpp s[10:11], v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x4c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_u32_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: v_cmp_gt_u32_e64_dpp s[10:11], v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x4c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_u32_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: v_cmp_gt_u32_e64_dpp s[10:11], v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x4c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_u32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: v_cmp_gt_u32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x68,0x00,0x4c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_u32_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: v_cmp_gt_u32_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6a,0x00,0x4c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_u32_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: v_cmp_gt_u32_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7a,0x00,0x4c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_gt_u32_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cmp_gt_u32_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0x7c,0x00,0x4c,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x05,0x30]

v_cmp_le_f16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: v_cmp_le_f16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x03,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_f16_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0]
// W32: v_cmp_le_f16_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x03,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_f16_e64_dpp s5, v1, 2.0 quad_perm:[3,2,1,0]
// W32: v_cmp_le_f16_e64_dpp s5, v1, 2.0 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x03,0xd4,0xfa,0xe8,0x01,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_f16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: v_cmp_le_f16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x03,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_f16_e64_dpp s5, v1, v2 row_mirror
// W32: v_cmp_le_f16_e64_dpp s5, v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x03,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_f16_e64_dpp s5, v1, v2 row_half_mirror
// W32: v_cmp_le_f16_e64_dpp s5, v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x03,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_f16_e64_dpp s5, v1, v2 row_shl:1
// W32: v_cmp_le_f16_e64_dpp s5, v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x03,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_f16_e64_dpp s5, v1, v2 row_shl:15
// W32: v_cmp_le_f16_e64_dpp s5, v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x03,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_f16_e64_dpp s5, v1, v2 row_shr:1
// W32: v_cmp_le_f16_e64_dpp s5, v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x03,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_f16_e64_dpp s5, v1, v2 row_shr:15
// W32: v_cmp_le_f16_e64_dpp s5, v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x03,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_f16_e64_dpp s5, v1, v2 row_ror:1
// W32: v_cmp_le_f16_e64_dpp s5, v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x03,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_f16_e64_dpp s105, v1, v2 row_ror:15
// W32: v_cmp_le_f16_e64_dpp s105, v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x69,0x00,0x03,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_f16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: v_cmp_le_f16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x6a,0x00,0x03,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_f16_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: v_cmp_le_f16_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6b,0x01,0x03,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_f16_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: v_cmp_le_f16_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7b,0x02,0x03,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_f16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: v_cmp_le_f16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x03,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_f16_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0]
// W64: v_cmp_le_f16_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x03,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_f16_e64_dpp s[10:11], v1, 2.0 quad_perm:[3,2,1,0]
// W64: v_cmp_le_f16_e64_dpp s[10:11], v1, 2.0 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x03,0xd4,0xfa,0xe8,0x01,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_f16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: v_cmp_le_f16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x03,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_f16_e64_dpp s[10:11], v1, v2 row_mirror
// W64: v_cmp_le_f16_e64_dpp s[10:11], v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x03,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_f16_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: v_cmp_le_f16_e64_dpp s[10:11], v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x03,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_f16_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: v_cmp_le_f16_e64_dpp s[10:11], v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x03,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_f16_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: v_cmp_le_f16_e64_dpp s[10:11], v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x03,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_f16_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: v_cmp_le_f16_e64_dpp s[10:11], v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x03,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_f16_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: v_cmp_le_f16_e64_dpp s[10:11], v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x03,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_f16_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: v_cmp_le_f16_e64_dpp s[10:11], v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x03,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_f16_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: v_cmp_le_f16_e64_dpp s[10:11], v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x03,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_f16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: v_cmp_le_f16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x68,0x00,0x03,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_f16_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: v_cmp_le_f16_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6a,0x01,0x03,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_f16_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: v_cmp_le_f16_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7a,0x02,0x03,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_f16_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cmp_le_f16_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0x7c,0x83,0x03,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x05,0x30]

v_cmp_le_f32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: v_cmp_le_f32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x13,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_f32_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0]
// W32: v_cmp_le_f32_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x13,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_f32_e64_dpp s5, v1, 2.0 quad_perm:[3,2,1,0]
// W32: v_cmp_le_f32_e64_dpp s5, v1, 2.0 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x13,0xd4,0xfa,0xe8,0x01,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_f32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: v_cmp_le_f32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x13,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_f32_e64_dpp s5, v1, v2 row_mirror
// W32: v_cmp_le_f32_e64_dpp s5, v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x13,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_f32_e64_dpp s5, v1, v2 row_half_mirror
// W32: v_cmp_le_f32_e64_dpp s5, v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x13,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_f32_e64_dpp s5, v1, v2 row_shl:1
// W32: v_cmp_le_f32_e64_dpp s5, v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x13,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_f32_e64_dpp s5, v1, v2 row_shl:15
// W32: v_cmp_le_f32_e64_dpp s5, v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x13,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_f32_e64_dpp s5, v1, v2 row_shr:1
// W32: v_cmp_le_f32_e64_dpp s5, v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x13,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_f32_e64_dpp s5, v1, v2 row_shr:15
// W32: v_cmp_le_f32_e64_dpp s5, v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x13,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_f32_e64_dpp s5, v1, v2 row_ror:1
// W32: v_cmp_le_f32_e64_dpp s5, v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x13,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_f32_e64_dpp s105, v1, v2 row_ror:15
// W32: v_cmp_le_f32_e64_dpp s105, v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x69,0x00,0x13,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_f32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: v_cmp_le_f32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x6a,0x00,0x13,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_f32_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: v_cmp_le_f32_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6b,0x01,0x13,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_f32_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: v_cmp_le_f32_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7b,0x02,0x13,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_f32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: v_cmp_le_f32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x13,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_f32_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0]
// W64: v_cmp_le_f32_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x13,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_f32_e64_dpp s[10:11], v1, 2.0 quad_perm:[3,2,1,0]
// W64: v_cmp_le_f32_e64_dpp s[10:11], v1, 2.0 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x13,0xd4,0xfa,0xe8,0x01,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_f32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: v_cmp_le_f32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x13,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_f32_e64_dpp s[10:11], v1, v2 row_mirror
// W64: v_cmp_le_f32_e64_dpp s[10:11], v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x13,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_f32_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: v_cmp_le_f32_e64_dpp s[10:11], v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x13,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_f32_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: v_cmp_le_f32_e64_dpp s[10:11], v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x13,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_f32_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: v_cmp_le_f32_e64_dpp s[10:11], v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x13,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_f32_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: v_cmp_le_f32_e64_dpp s[10:11], v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x13,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_f32_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: v_cmp_le_f32_e64_dpp s[10:11], v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x13,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_f32_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: v_cmp_le_f32_e64_dpp s[10:11], v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x13,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_f32_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: v_cmp_le_f32_e64_dpp s[10:11], v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x13,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_f32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: v_cmp_le_f32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x68,0x00,0x13,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_f32_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: v_cmp_le_f32_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6a,0x01,0x13,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_f32_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: v_cmp_le_f32_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7a,0x02,0x13,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_f32_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cmp_le_f32_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0x7c,0x83,0x13,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x05,0x30]

v_cmp_le_i16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: v_cmp_le_i16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x33,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_i16_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0]
// W32: v_cmp_le_i16_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x33,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_i16_e64_dpp s5, v1, 10 quad_perm:[3,2,1,0]
// W32: v_cmp_le_i16_e64_dpp s5, v1, 10 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x33,0xd4,0xfa,0x14,0x01,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_i16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: v_cmp_le_i16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x33,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_i16_e64_dpp s5, v1, v2 row_mirror
// W32: v_cmp_le_i16_e64_dpp s5, v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x33,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_i16_e64_dpp s5, v1, v2 row_half_mirror
// W32: v_cmp_le_i16_e64_dpp s5, v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x33,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_i16_e64_dpp s5, v1, v2 row_shl:1
// W32: v_cmp_le_i16_e64_dpp s5, v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x33,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_i16_e64_dpp s5, v1, v2 row_shl:15
// W32: v_cmp_le_i16_e64_dpp s5, v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x33,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_i16_e64_dpp s5, v1, v2 row_shr:1
// W32: v_cmp_le_i16_e64_dpp s5, v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x33,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_i16_e64_dpp s5, v1, v2 row_shr:15
// W32: v_cmp_le_i16_e64_dpp s5, v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x33,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_i16_e64_dpp s5, v1, v2 row_ror:1
// W32: v_cmp_le_i16_e64_dpp s5, v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x33,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_i16_e64_dpp s105, v1, v2 row_ror:15
// W32: v_cmp_le_i16_e64_dpp s105, v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x69,0x00,0x33,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_i16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: v_cmp_le_i16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x6a,0x00,0x33,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_i16_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: v_cmp_le_i16_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6b,0x00,0x33,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_i16_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: v_cmp_le_i16_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7b,0x00,0x33,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_i16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: v_cmp_le_i16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x33,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_i16_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0]
// W64: v_cmp_le_i16_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x33,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_i16_e64_dpp s[10:11], v1, 10 quad_perm:[3,2,1,0]
// W64: v_cmp_le_i16_e64_dpp s[10:11], v1, 10 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x33,0xd4,0xfa,0x14,0x01,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_i16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: v_cmp_le_i16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x33,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_i16_e64_dpp s[10:11], v1, v2 row_mirror
// W64: v_cmp_le_i16_e64_dpp s[10:11], v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x33,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_i16_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: v_cmp_le_i16_e64_dpp s[10:11], v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x33,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_i16_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: v_cmp_le_i16_e64_dpp s[10:11], v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x33,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_i16_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: v_cmp_le_i16_e64_dpp s[10:11], v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x33,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_i16_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: v_cmp_le_i16_e64_dpp s[10:11], v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x33,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_i16_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: v_cmp_le_i16_e64_dpp s[10:11], v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x33,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_i16_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: v_cmp_le_i16_e64_dpp s[10:11], v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x33,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_i16_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: v_cmp_le_i16_e64_dpp s[10:11], v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x33,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_i16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: v_cmp_le_i16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x68,0x00,0x33,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_i16_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: v_cmp_le_i16_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6a,0x00,0x33,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_i16_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: v_cmp_le_i16_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7a,0x00,0x33,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_i16_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cmp_le_i16_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0x7c,0x00,0x33,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x05,0x30]

v_cmp_le_i32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: v_cmp_le_i32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x43,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_i32_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0]
// W32: v_cmp_le_i32_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x43,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_i32_e64_dpp s5, v1, 10 quad_perm:[3,2,1,0]
// W32: v_cmp_le_i32_e64_dpp s5, v1, 10 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x43,0xd4,0xfa,0x14,0x01,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_i32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: v_cmp_le_i32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x43,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_i32_e64_dpp s5, v1, v2 row_mirror
// W32: v_cmp_le_i32_e64_dpp s5, v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x43,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_i32_e64_dpp s5, v1, v2 row_half_mirror
// W32: v_cmp_le_i32_e64_dpp s5, v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x43,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_i32_e64_dpp s5, v1, v2 row_shl:1
// W32: v_cmp_le_i32_e64_dpp s5, v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x43,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_i32_e64_dpp s5, v1, v2 row_shl:15
// W32: v_cmp_le_i32_e64_dpp s5, v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x43,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_i32_e64_dpp s5, v1, v2 row_shr:1
// W32: v_cmp_le_i32_e64_dpp s5, v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x43,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_i32_e64_dpp s5, v1, v2 row_shr:15
// W32: v_cmp_le_i32_e64_dpp s5, v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x43,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_i32_e64_dpp s5, v1, v2 row_ror:1
// W32: v_cmp_le_i32_e64_dpp s5, v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x43,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_i32_e64_dpp s105, v1, v2 row_ror:15
// W32: v_cmp_le_i32_e64_dpp s105, v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x69,0x00,0x43,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_i32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: v_cmp_le_i32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x6a,0x00,0x43,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_i32_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: v_cmp_le_i32_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6b,0x00,0x43,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_i32_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: v_cmp_le_i32_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7b,0x00,0x43,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_i32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: v_cmp_le_i32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x43,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_i32_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0]
// W64: v_cmp_le_i32_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x43,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_i32_e64_dpp s[10:11], v1, 10 quad_perm:[3,2,1,0]
// W64: v_cmp_le_i32_e64_dpp s[10:11], v1, 10 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x43,0xd4,0xfa,0x14,0x01,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_i32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: v_cmp_le_i32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x43,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_i32_e64_dpp s[10:11], v1, v2 row_mirror
// W64: v_cmp_le_i32_e64_dpp s[10:11], v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x43,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_i32_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: v_cmp_le_i32_e64_dpp s[10:11], v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x43,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_i32_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: v_cmp_le_i32_e64_dpp s[10:11], v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x43,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_i32_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: v_cmp_le_i32_e64_dpp s[10:11], v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x43,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_i32_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: v_cmp_le_i32_e64_dpp s[10:11], v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x43,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_i32_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: v_cmp_le_i32_e64_dpp s[10:11], v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x43,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_i32_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: v_cmp_le_i32_e64_dpp s[10:11], v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x43,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_i32_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: v_cmp_le_i32_e64_dpp s[10:11], v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x43,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_i32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: v_cmp_le_i32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x68,0x00,0x43,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_i32_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: v_cmp_le_i32_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6a,0x00,0x43,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_i32_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: v_cmp_le_i32_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7a,0x00,0x43,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_i32_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cmp_le_i32_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0x7c,0x00,0x43,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x05,0x30]

v_cmp_le_u16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: v_cmp_le_u16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x3b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_u16_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0]
// W32: v_cmp_le_u16_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x3b,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_u16_e64_dpp s5, v1, 10 quad_perm:[3,2,1,0]
// W32: v_cmp_le_u16_e64_dpp s5, v1, 10 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x3b,0xd4,0xfa,0x14,0x01,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_u16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: v_cmp_le_u16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x3b,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_u16_e64_dpp s5, v1, v2 row_mirror
// W32: v_cmp_le_u16_e64_dpp s5, v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x3b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_u16_e64_dpp s5, v1, v2 row_half_mirror
// W32: v_cmp_le_u16_e64_dpp s5, v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x3b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_u16_e64_dpp s5, v1, v2 row_shl:1
// W32: v_cmp_le_u16_e64_dpp s5, v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x3b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_u16_e64_dpp s5, v1, v2 row_shl:15
// W32: v_cmp_le_u16_e64_dpp s5, v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x3b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_u16_e64_dpp s5, v1, v2 row_shr:1
// W32: v_cmp_le_u16_e64_dpp s5, v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x3b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_u16_e64_dpp s5, v1, v2 row_shr:15
// W32: v_cmp_le_u16_e64_dpp s5, v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x3b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_u16_e64_dpp s5, v1, v2 row_ror:1
// W32: v_cmp_le_u16_e64_dpp s5, v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x3b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_u16_e64_dpp s105, v1, v2 row_ror:15
// W32: v_cmp_le_u16_e64_dpp s105, v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x69,0x00,0x3b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_u16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: v_cmp_le_u16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x6a,0x00,0x3b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_u16_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: v_cmp_le_u16_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6b,0x00,0x3b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_u16_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: v_cmp_le_u16_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7b,0x00,0x3b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_u16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: v_cmp_le_u16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x3b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_u16_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0]
// W64: v_cmp_le_u16_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x3b,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_u16_e64_dpp s[10:11], v1, 10 quad_perm:[3,2,1,0]
// W64: v_cmp_le_u16_e64_dpp s[10:11], v1, 10 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x3b,0xd4,0xfa,0x14,0x01,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_u16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: v_cmp_le_u16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x3b,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_u16_e64_dpp s[10:11], v1, v2 row_mirror
// W64: v_cmp_le_u16_e64_dpp s[10:11], v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x3b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_u16_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: v_cmp_le_u16_e64_dpp s[10:11], v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x3b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_u16_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: v_cmp_le_u16_e64_dpp s[10:11], v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x3b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_u16_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: v_cmp_le_u16_e64_dpp s[10:11], v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x3b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_u16_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: v_cmp_le_u16_e64_dpp s[10:11], v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x3b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_u16_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: v_cmp_le_u16_e64_dpp s[10:11], v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x3b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_u16_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: v_cmp_le_u16_e64_dpp s[10:11], v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x3b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_u16_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: v_cmp_le_u16_e64_dpp s[10:11], v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x3b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_u16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: v_cmp_le_u16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x68,0x00,0x3b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_u16_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: v_cmp_le_u16_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6a,0x00,0x3b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_u16_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: v_cmp_le_u16_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7a,0x00,0x3b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_u16_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cmp_le_u16_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0x7c,0x00,0x3b,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x05,0x30]

v_cmp_le_u32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: v_cmp_le_u32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x4b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_u32_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0]
// W32: v_cmp_le_u32_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x4b,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_u32_e64_dpp s5, v1, 10 quad_perm:[3,2,1,0]
// W32: v_cmp_le_u32_e64_dpp s5, v1, 10 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x4b,0xd4,0xfa,0x14,0x01,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_u32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: v_cmp_le_u32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x4b,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_u32_e64_dpp s5, v1, v2 row_mirror
// W32: v_cmp_le_u32_e64_dpp s5, v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x4b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_u32_e64_dpp s5, v1, v2 row_half_mirror
// W32: v_cmp_le_u32_e64_dpp s5, v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x4b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_u32_e64_dpp s5, v1, v2 row_shl:1
// W32: v_cmp_le_u32_e64_dpp s5, v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x4b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_u32_e64_dpp s5, v1, v2 row_shl:15
// W32: v_cmp_le_u32_e64_dpp s5, v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x4b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_u32_e64_dpp s5, v1, v2 row_shr:1
// W32: v_cmp_le_u32_e64_dpp s5, v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x4b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_u32_e64_dpp s5, v1, v2 row_shr:15
// W32: v_cmp_le_u32_e64_dpp s5, v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x4b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_u32_e64_dpp s5, v1, v2 row_ror:1
// W32: v_cmp_le_u32_e64_dpp s5, v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x4b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_u32_e64_dpp s105, v1, v2 row_ror:15
// W32: v_cmp_le_u32_e64_dpp s105, v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x69,0x00,0x4b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_u32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: v_cmp_le_u32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x6a,0x00,0x4b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_u32_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: v_cmp_le_u32_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6b,0x00,0x4b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_u32_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: v_cmp_le_u32_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7b,0x00,0x4b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_u32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: v_cmp_le_u32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x4b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_u32_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0]
// W64: v_cmp_le_u32_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x4b,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_u32_e64_dpp s[10:11], v1, 10 quad_perm:[3,2,1,0]
// W64: v_cmp_le_u32_e64_dpp s[10:11], v1, 10 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x4b,0xd4,0xfa,0x14,0x01,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_u32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: v_cmp_le_u32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x4b,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_u32_e64_dpp s[10:11], v1, v2 row_mirror
// W64: v_cmp_le_u32_e64_dpp s[10:11], v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x4b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_u32_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: v_cmp_le_u32_e64_dpp s[10:11], v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x4b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_u32_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: v_cmp_le_u32_e64_dpp s[10:11], v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x4b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_u32_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: v_cmp_le_u32_e64_dpp s[10:11], v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x4b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_u32_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: v_cmp_le_u32_e64_dpp s[10:11], v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x4b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_u32_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: v_cmp_le_u32_e64_dpp s[10:11], v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x4b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_u32_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: v_cmp_le_u32_e64_dpp s[10:11], v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x4b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_u32_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: v_cmp_le_u32_e64_dpp s[10:11], v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x4b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_u32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: v_cmp_le_u32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x68,0x00,0x4b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_u32_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: v_cmp_le_u32_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6a,0x00,0x4b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_u32_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: v_cmp_le_u32_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7a,0x00,0x4b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_le_u32_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cmp_le_u32_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0x7c,0x00,0x4b,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x05,0x30]

v_cmp_lg_f16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: v_cmp_lg_f16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x05,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lg_f16_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0]
// W32: v_cmp_lg_f16_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x05,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lg_f16_e64_dpp s5, v1, 2.0 quad_perm:[3,2,1,0]
// W32: v_cmp_lg_f16_e64_dpp s5, v1, 2.0 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x05,0xd4,0xfa,0xe8,0x01,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lg_f16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: v_cmp_lg_f16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x05,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lg_f16_e64_dpp s5, v1, v2 row_mirror
// W32: v_cmp_lg_f16_e64_dpp s5, v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x05,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lg_f16_e64_dpp s5, v1, v2 row_half_mirror
// W32: v_cmp_lg_f16_e64_dpp s5, v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x05,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lg_f16_e64_dpp s5, v1, v2 row_shl:1
// W32: v_cmp_lg_f16_e64_dpp s5, v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x05,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lg_f16_e64_dpp s5, v1, v2 row_shl:15
// W32: v_cmp_lg_f16_e64_dpp s5, v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x05,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lg_f16_e64_dpp s5, v1, v2 row_shr:1
// W32: v_cmp_lg_f16_e64_dpp s5, v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x05,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lg_f16_e64_dpp s5, v1, v2 row_shr:15
// W32: v_cmp_lg_f16_e64_dpp s5, v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x05,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lg_f16_e64_dpp s5, v1, v2 row_ror:1
// W32: v_cmp_lg_f16_e64_dpp s5, v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x05,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lg_f16_e64_dpp s105, v1, v2 row_ror:15
// W32: v_cmp_lg_f16_e64_dpp s105, v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x69,0x00,0x05,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lg_f16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: v_cmp_lg_f16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x6a,0x00,0x05,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lg_f16_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: v_cmp_lg_f16_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6b,0x01,0x05,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lg_f16_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: v_cmp_lg_f16_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7b,0x02,0x05,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lg_f16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: v_cmp_lg_f16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x05,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lg_f16_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0]
// W64: v_cmp_lg_f16_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x05,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lg_f16_e64_dpp s[10:11], v1, 2.0 quad_perm:[3,2,1,0]
// W64: v_cmp_lg_f16_e64_dpp s[10:11], v1, 2.0 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x05,0xd4,0xfa,0xe8,0x01,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lg_f16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: v_cmp_lg_f16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x05,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lg_f16_e64_dpp s[10:11], v1, v2 row_mirror
// W64: v_cmp_lg_f16_e64_dpp s[10:11], v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x05,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lg_f16_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: v_cmp_lg_f16_e64_dpp s[10:11], v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x05,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lg_f16_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: v_cmp_lg_f16_e64_dpp s[10:11], v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x05,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lg_f16_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: v_cmp_lg_f16_e64_dpp s[10:11], v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x05,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lg_f16_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: v_cmp_lg_f16_e64_dpp s[10:11], v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x05,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lg_f16_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: v_cmp_lg_f16_e64_dpp s[10:11], v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x05,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lg_f16_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: v_cmp_lg_f16_e64_dpp s[10:11], v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x05,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lg_f16_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: v_cmp_lg_f16_e64_dpp s[10:11], v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x05,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lg_f16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: v_cmp_lg_f16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x68,0x00,0x05,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lg_f16_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: v_cmp_lg_f16_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6a,0x01,0x05,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lg_f16_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: v_cmp_lg_f16_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7a,0x02,0x05,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lg_f16_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cmp_lg_f16_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0x7c,0x83,0x05,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x05,0x30]

v_cmp_lg_f32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: v_cmp_lg_f32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x15,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lg_f32_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0]
// W32: v_cmp_lg_f32_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x15,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lg_f32_e64_dpp s5, v1, 2.0 quad_perm:[3,2,1,0]
// W32: v_cmp_lg_f32_e64_dpp s5, v1, 2.0 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x15,0xd4,0xfa,0xe8,0x01,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lg_f32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: v_cmp_lg_f32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x15,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lg_f32_e64_dpp s5, v1, v2 row_mirror
// W32: v_cmp_lg_f32_e64_dpp s5, v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x15,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lg_f32_e64_dpp s5, v1, v2 row_half_mirror
// W32: v_cmp_lg_f32_e64_dpp s5, v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x15,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lg_f32_e64_dpp s5, v1, v2 row_shl:1
// W32: v_cmp_lg_f32_e64_dpp s5, v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x15,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lg_f32_e64_dpp s5, v1, v2 row_shl:15
// W32: v_cmp_lg_f32_e64_dpp s5, v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x15,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lg_f32_e64_dpp s5, v1, v2 row_shr:1
// W32: v_cmp_lg_f32_e64_dpp s5, v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x15,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lg_f32_e64_dpp s5, v1, v2 row_shr:15
// W32: v_cmp_lg_f32_e64_dpp s5, v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x15,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lg_f32_e64_dpp s5, v1, v2 row_ror:1
// W32: v_cmp_lg_f32_e64_dpp s5, v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x15,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lg_f32_e64_dpp s105, v1, v2 row_ror:15
// W32: v_cmp_lg_f32_e64_dpp s105, v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x69,0x00,0x15,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lg_f32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: v_cmp_lg_f32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x6a,0x00,0x15,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lg_f32_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: v_cmp_lg_f32_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6b,0x01,0x15,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lg_f32_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: v_cmp_lg_f32_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7b,0x02,0x15,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lg_f32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: v_cmp_lg_f32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x15,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lg_f32_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0]
// W64: v_cmp_lg_f32_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x15,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lg_f32_e64_dpp s[10:11], v1, 2.0 quad_perm:[3,2,1,0]
// W64: v_cmp_lg_f32_e64_dpp s[10:11], v1, 2.0 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x15,0xd4,0xfa,0xe8,0x01,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lg_f32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: v_cmp_lg_f32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x15,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lg_f32_e64_dpp s[10:11], v1, v2 row_mirror
// W64: v_cmp_lg_f32_e64_dpp s[10:11], v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x15,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lg_f32_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: v_cmp_lg_f32_e64_dpp s[10:11], v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x15,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lg_f32_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: v_cmp_lg_f32_e64_dpp s[10:11], v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x15,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lg_f32_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: v_cmp_lg_f32_e64_dpp s[10:11], v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x15,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lg_f32_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: v_cmp_lg_f32_e64_dpp s[10:11], v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x15,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lg_f32_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: v_cmp_lg_f32_e64_dpp s[10:11], v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x15,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lg_f32_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: v_cmp_lg_f32_e64_dpp s[10:11], v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x15,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lg_f32_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: v_cmp_lg_f32_e64_dpp s[10:11], v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x15,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lg_f32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: v_cmp_lg_f32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x68,0x00,0x15,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lg_f32_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: v_cmp_lg_f32_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6a,0x01,0x15,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lg_f32_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: v_cmp_lg_f32_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7a,0x02,0x15,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lg_f32_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cmp_lg_f32_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0x7c,0x83,0x15,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x05,0x30]

v_cmp_lt_f16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: v_cmp_lt_f16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x01,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_f16_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0]
// W32: v_cmp_lt_f16_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x01,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_f16_e64_dpp s5, v1, 2.0 quad_perm:[3,2,1,0]
// W32: v_cmp_lt_f16_e64_dpp s5, v1, 2.0 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x01,0xd4,0xfa,0xe8,0x01,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_f16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: v_cmp_lt_f16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x01,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_f16_e64_dpp s5, v1, v2 row_mirror
// W32: v_cmp_lt_f16_e64_dpp s5, v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x01,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_f16_e64_dpp s5, v1, v2 row_half_mirror
// W32: v_cmp_lt_f16_e64_dpp s5, v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x01,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_f16_e64_dpp s5, v1, v2 row_shl:1
// W32: v_cmp_lt_f16_e64_dpp s5, v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x01,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_f16_e64_dpp s5, v1, v2 row_shl:15
// W32: v_cmp_lt_f16_e64_dpp s5, v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x01,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_f16_e64_dpp s5, v1, v2 row_shr:1
// W32: v_cmp_lt_f16_e64_dpp s5, v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x01,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_f16_e64_dpp s5, v1, v2 row_shr:15
// W32: v_cmp_lt_f16_e64_dpp s5, v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x01,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_f16_e64_dpp s5, v1, v2 row_ror:1
// W32: v_cmp_lt_f16_e64_dpp s5, v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x01,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_f16_e64_dpp s105, v1, v2 row_ror:15
// W32: v_cmp_lt_f16_e64_dpp s105, v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x69,0x00,0x01,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_f16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: v_cmp_lt_f16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x6a,0x00,0x01,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_f16_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: v_cmp_lt_f16_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6b,0x01,0x01,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_f16_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: v_cmp_lt_f16_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7b,0x02,0x01,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_f16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: v_cmp_lt_f16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x01,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_f16_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0]
// W64: v_cmp_lt_f16_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x01,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_f16_e64_dpp s[10:11], v1, 2.0 quad_perm:[3,2,1,0]
// W64: v_cmp_lt_f16_e64_dpp s[10:11], v1, 2.0 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x01,0xd4,0xfa,0xe8,0x01,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_f16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: v_cmp_lt_f16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x01,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_f16_e64_dpp s[10:11], v1, v2 row_mirror
// W64: v_cmp_lt_f16_e64_dpp s[10:11], v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x01,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_f16_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: v_cmp_lt_f16_e64_dpp s[10:11], v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x01,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_f16_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: v_cmp_lt_f16_e64_dpp s[10:11], v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x01,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_f16_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: v_cmp_lt_f16_e64_dpp s[10:11], v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x01,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_f16_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: v_cmp_lt_f16_e64_dpp s[10:11], v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x01,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_f16_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: v_cmp_lt_f16_e64_dpp s[10:11], v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x01,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_f16_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: v_cmp_lt_f16_e64_dpp s[10:11], v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x01,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_f16_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: v_cmp_lt_f16_e64_dpp s[10:11], v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x01,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_f16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: v_cmp_lt_f16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x68,0x00,0x01,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_f16_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: v_cmp_lt_f16_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6a,0x01,0x01,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_f16_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: v_cmp_lt_f16_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7a,0x02,0x01,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_f16_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cmp_lt_f16_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0x7c,0x83,0x01,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x05,0x30]

v_cmp_lt_f32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: v_cmp_lt_f32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x11,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_f32_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0]
// W32: v_cmp_lt_f32_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x11,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_f32_e64_dpp s5, v1, 2.0 quad_perm:[3,2,1,0]
// W32: v_cmp_lt_f32_e64_dpp s5, v1, 2.0 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x11,0xd4,0xfa,0xe8,0x01,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_f32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: v_cmp_lt_f32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x11,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_f32_e64_dpp s5, v1, v2 row_mirror
// W32: v_cmp_lt_f32_e64_dpp s5, v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x11,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_f32_e64_dpp s5, v1, v2 row_half_mirror
// W32: v_cmp_lt_f32_e64_dpp s5, v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x11,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_f32_e64_dpp s5, v1, v2 row_shl:1
// W32: v_cmp_lt_f32_e64_dpp s5, v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x11,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_f32_e64_dpp s5, v1, v2 row_shl:15
// W32: v_cmp_lt_f32_e64_dpp s5, v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x11,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_f32_e64_dpp s5, v1, v2 row_shr:1
// W32: v_cmp_lt_f32_e64_dpp s5, v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x11,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_f32_e64_dpp s5, v1, v2 row_shr:15
// W32: v_cmp_lt_f32_e64_dpp s5, v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x11,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_f32_e64_dpp s5, v1, v2 row_ror:1
// W32: v_cmp_lt_f32_e64_dpp s5, v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x11,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_f32_e64_dpp s105, v1, v2 row_ror:15
// W32: v_cmp_lt_f32_e64_dpp s105, v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x69,0x00,0x11,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_f32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: v_cmp_lt_f32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x6a,0x00,0x11,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_f32_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: v_cmp_lt_f32_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6b,0x01,0x11,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_f32_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: v_cmp_lt_f32_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7b,0x02,0x11,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_f32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: v_cmp_lt_f32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x11,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_f32_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0]
// W64: v_cmp_lt_f32_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x11,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_f32_e64_dpp s[10:11], v1, 2.0 quad_perm:[3,2,1,0]
// W64: v_cmp_lt_f32_e64_dpp s[10:11], v1, 2.0 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x11,0xd4,0xfa,0xe8,0x01,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_f32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: v_cmp_lt_f32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x11,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_f32_e64_dpp s[10:11], v1, v2 row_mirror
// W64: v_cmp_lt_f32_e64_dpp s[10:11], v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x11,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_f32_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: v_cmp_lt_f32_e64_dpp s[10:11], v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x11,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_f32_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: v_cmp_lt_f32_e64_dpp s[10:11], v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x11,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_f32_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: v_cmp_lt_f32_e64_dpp s[10:11], v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x11,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_f32_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: v_cmp_lt_f32_e64_dpp s[10:11], v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x11,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_f32_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: v_cmp_lt_f32_e64_dpp s[10:11], v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x11,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_f32_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: v_cmp_lt_f32_e64_dpp s[10:11], v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x11,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_f32_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: v_cmp_lt_f32_e64_dpp s[10:11], v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x11,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_f32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: v_cmp_lt_f32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x68,0x00,0x11,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_f32_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: v_cmp_lt_f32_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6a,0x01,0x11,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_f32_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: v_cmp_lt_f32_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7a,0x02,0x11,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_f32_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cmp_lt_f32_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0x7c,0x83,0x11,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x05,0x30]

v_cmp_lt_i16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: v_cmp_lt_i16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x31,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_i16_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0]
// W32: v_cmp_lt_i16_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x31,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_i16_e64_dpp s5, v1, 10 quad_perm:[3,2,1,0]
// W32: v_cmp_lt_i16_e64_dpp s5, v1, 10 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x31,0xd4,0xfa,0x14,0x01,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_i16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: v_cmp_lt_i16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x31,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_i16_e64_dpp s5, v1, v2 row_mirror
// W32: v_cmp_lt_i16_e64_dpp s5, v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x31,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_i16_e64_dpp s5, v1, v2 row_half_mirror
// W32: v_cmp_lt_i16_e64_dpp s5, v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x31,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_i16_e64_dpp s5, v1, v2 row_shl:1
// W32: v_cmp_lt_i16_e64_dpp s5, v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x31,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_i16_e64_dpp s5, v1, v2 row_shl:15
// W32: v_cmp_lt_i16_e64_dpp s5, v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x31,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_i16_e64_dpp s5, v1, v2 row_shr:1
// W32: v_cmp_lt_i16_e64_dpp s5, v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x31,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_i16_e64_dpp s5, v1, v2 row_shr:15
// W32: v_cmp_lt_i16_e64_dpp s5, v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x31,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_i16_e64_dpp s5, v1, v2 row_ror:1
// W32: v_cmp_lt_i16_e64_dpp s5, v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x31,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_i16_e64_dpp s105, v1, v2 row_ror:15
// W32: v_cmp_lt_i16_e64_dpp s105, v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x69,0x00,0x31,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_i16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: v_cmp_lt_i16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x6a,0x00,0x31,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_i16_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: v_cmp_lt_i16_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6b,0x00,0x31,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_i16_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: v_cmp_lt_i16_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7b,0x00,0x31,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_i16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: v_cmp_lt_i16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x31,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_i16_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0]
// W64: v_cmp_lt_i16_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x31,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_i16_e64_dpp s[10:11], v1, 10 quad_perm:[3,2,1,0]
// W64: v_cmp_lt_i16_e64_dpp s[10:11], v1, 10 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x31,0xd4,0xfa,0x14,0x01,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_i16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: v_cmp_lt_i16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x31,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_i16_e64_dpp s[10:11], v1, v2 row_mirror
// W64: v_cmp_lt_i16_e64_dpp s[10:11], v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x31,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_i16_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: v_cmp_lt_i16_e64_dpp s[10:11], v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x31,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_i16_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: v_cmp_lt_i16_e64_dpp s[10:11], v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x31,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_i16_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: v_cmp_lt_i16_e64_dpp s[10:11], v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x31,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_i16_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: v_cmp_lt_i16_e64_dpp s[10:11], v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x31,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_i16_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: v_cmp_lt_i16_e64_dpp s[10:11], v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x31,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_i16_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: v_cmp_lt_i16_e64_dpp s[10:11], v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x31,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_i16_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: v_cmp_lt_i16_e64_dpp s[10:11], v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x31,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_i16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: v_cmp_lt_i16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x68,0x00,0x31,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_i16_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: v_cmp_lt_i16_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6a,0x00,0x31,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_i16_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: v_cmp_lt_i16_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7a,0x00,0x31,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_i16_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cmp_lt_i16_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0x7c,0x00,0x31,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x05,0x30]

v_cmp_lt_i32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: v_cmp_lt_i32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x41,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_i32_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0]
// W32: v_cmp_lt_i32_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x41,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_i32_e64_dpp s5, v1, 10 quad_perm:[3,2,1,0]
// W32: v_cmp_lt_i32_e64_dpp s5, v1, 10 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x41,0xd4,0xfa,0x14,0x01,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_i32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: v_cmp_lt_i32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x41,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_i32_e64_dpp s5, v1, v2 row_mirror
// W32: v_cmp_lt_i32_e64_dpp s5, v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x41,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_i32_e64_dpp s5, v1, v2 row_half_mirror
// W32: v_cmp_lt_i32_e64_dpp s5, v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x41,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_i32_e64_dpp s5, v1, v2 row_shl:1
// W32: v_cmp_lt_i32_e64_dpp s5, v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x41,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_i32_e64_dpp s5, v1, v2 row_shl:15
// W32: v_cmp_lt_i32_e64_dpp s5, v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x41,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_i32_e64_dpp s5, v1, v2 row_shr:1
// W32: v_cmp_lt_i32_e64_dpp s5, v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x41,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_i32_e64_dpp s5, v1, v2 row_shr:15
// W32: v_cmp_lt_i32_e64_dpp s5, v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x41,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_i32_e64_dpp s5, v1, v2 row_ror:1
// W32: v_cmp_lt_i32_e64_dpp s5, v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x41,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_i32_e64_dpp s105, v1, v2 row_ror:15
// W32: v_cmp_lt_i32_e64_dpp s105, v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x69,0x00,0x41,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_i32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: v_cmp_lt_i32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x6a,0x00,0x41,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_i32_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: v_cmp_lt_i32_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6b,0x00,0x41,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_i32_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: v_cmp_lt_i32_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7b,0x00,0x41,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_i32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: v_cmp_lt_i32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x41,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_i32_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0]
// W64: v_cmp_lt_i32_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x41,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_i32_e64_dpp s[10:11], v1, 10 quad_perm:[3,2,1,0]
// W64: v_cmp_lt_i32_e64_dpp s[10:11], v1, 10 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x41,0xd4,0xfa,0x14,0x01,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_i32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: v_cmp_lt_i32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x41,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_i32_e64_dpp s[10:11], v1, v2 row_mirror
// W64: v_cmp_lt_i32_e64_dpp s[10:11], v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x41,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_i32_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: v_cmp_lt_i32_e64_dpp s[10:11], v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x41,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_i32_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: v_cmp_lt_i32_e64_dpp s[10:11], v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x41,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_i32_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: v_cmp_lt_i32_e64_dpp s[10:11], v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x41,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_i32_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: v_cmp_lt_i32_e64_dpp s[10:11], v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x41,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_i32_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: v_cmp_lt_i32_e64_dpp s[10:11], v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x41,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_i32_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: v_cmp_lt_i32_e64_dpp s[10:11], v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x41,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_i32_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: v_cmp_lt_i32_e64_dpp s[10:11], v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x41,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_i32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: v_cmp_lt_i32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x68,0x00,0x41,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_i32_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: v_cmp_lt_i32_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6a,0x00,0x41,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_i32_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: v_cmp_lt_i32_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7a,0x00,0x41,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_i32_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cmp_lt_i32_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0x7c,0x00,0x41,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x05,0x30]

v_cmp_lt_u16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: v_cmp_lt_u16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x39,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_u16_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0]
// W32: v_cmp_lt_u16_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x39,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_u16_e64_dpp s5, v1, 10 quad_perm:[3,2,1,0]
// W32: v_cmp_lt_u16_e64_dpp s5, v1, 10 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x39,0xd4,0xfa,0x14,0x01,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_u16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: v_cmp_lt_u16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x39,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_u16_e64_dpp s5, v1, v2 row_mirror
// W32: v_cmp_lt_u16_e64_dpp s5, v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x39,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_u16_e64_dpp s5, v1, v2 row_half_mirror
// W32: v_cmp_lt_u16_e64_dpp s5, v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x39,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_u16_e64_dpp s5, v1, v2 row_shl:1
// W32: v_cmp_lt_u16_e64_dpp s5, v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x39,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_u16_e64_dpp s5, v1, v2 row_shl:15
// W32: v_cmp_lt_u16_e64_dpp s5, v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x39,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_u16_e64_dpp s5, v1, v2 row_shr:1
// W32: v_cmp_lt_u16_e64_dpp s5, v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x39,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_u16_e64_dpp s5, v1, v2 row_shr:15
// W32: v_cmp_lt_u16_e64_dpp s5, v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x39,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_u16_e64_dpp s5, v1, v2 row_ror:1
// W32: v_cmp_lt_u16_e64_dpp s5, v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x39,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_u16_e64_dpp s105, v1, v2 row_ror:15
// W32: v_cmp_lt_u16_e64_dpp s105, v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x69,0x00,0x39,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_u16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: v_cmp_lt_u16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x6a,0x00,0x39,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_u16_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: v_cmp_lt_u16_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6b,0x00,0x39,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_u16_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: v_cmp_lt_u16_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7b,0x00,0x39,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_u16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: v_cmp_lt_u16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x39,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_u16_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0]
// W64: v_cmp_lt_u16_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x39,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_u16_e64_dpp s[10:11], v1, 10 quad_perm:[3,2,1,0]
// W64: v_cmp_lt_u16_e64_dpp s[10:11], v1, 10 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x39,0xd4,0xfa,0x14,0x01,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_u16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: v_cmp_lt_u16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x39,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_u16_e64_dpp s[10:11], v1, v2 row_mirror
// W64: v_cmp_lt_u16_e64_dpp s[10:11], v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x39,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_u16_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: v_cmp_lt_u16_e64_dpp s[10:11], v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x39,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_u16_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: v_cmp_lt_u16_e64_dpp s[10:11], v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x39,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_u16_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: v_cmp_lt_u16_e64_dpp s[10:11], v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x39,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_u16_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: v_cmp_lt_u16_e64_dpp s[10:11], v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x39,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_u16_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: v_cmp_lt_u16_e64_dpp s[10:11], v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x39,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_u16_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: v_cmp_lt_u16_e64_dpp s[10:11], v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x39,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_u16_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: v_cmp_lt_u16_e64_dpp s[10:11], v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x39,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_u16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: v_cmp_lt_u16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x68,0x00,0x39,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_u16_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: v_cmp_lt_u16_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6a,0x00,0x39,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_u16_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: v_cmp_lt_u16_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7a,0x00,0x39,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_u16_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cmp_lt_u16_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0x7c,0x00,0x39,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x05,0x30]

v_cmp_lt_u32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: v_cmp_lt_u32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x49,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_u32_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0]
// W32: v_cmp_lt_u32_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x49,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_u32_e64_dpp s5, v1, 10 quad_perm:[3,2,1,0]
// W32: v_cmp_lt_u32_e64_dpp s5, v1, 10 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x49,0xd4,0xfa,0x14,0x01,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_u32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: v_cmp_lt_u32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x49,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_u32_e64_dpp s5, v1, v2 row_mirror
// W32: v_cmp_lt_u32_e64_dpp s5, v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x49,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_u32_e64_dpp s5, v1, v2 row_half_mirror
// W32: v_cmp_lt_u32_e64_dpp s5, v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x49,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_u32_e64_dpp s5, v1, v2 row_shl:1
// W32: v_cmp_lt_u32_e64_dpp s5, v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x49,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_u32_e64_dpp s5, v1, v2 row_shl:15
// W32: v_cmp_lt_u32_e64_dpp s5, v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x49,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_u32_e64_dpp s5, v1, v2 row_shr:1
// W32: v_cmp_lt_u32_e64_dpp s5, v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x49,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_u32_e64_dpp s5, v1, v2 row_shr:15
// W32: v_cmp_lt_u32_e64_dpp s5, v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x49,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_u32_e64_dpp s5, v1, v2 row_ror:1
// W32: v_cmp_lt_u32_e64_dpp s5, v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x49,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_u32_e64_dpp s105, v1, v2 row_ror:15
// W32: v_cmp_lt_u32_e64_dpp s105, v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x69,0x00,0x49,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_u32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: v_cmp_lt_u32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x6a,0x00,0x49,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_u32_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: v_cmp_lt_u32_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6b,0x00,0x49,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_u32_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: v_cmp_lt_u32_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7b,0x00,0x49,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_u32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: v_cmp_lt_u32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x49,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_u32_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0]
// W64: v_cmp_lt_u32_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x49,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_u32_e64_dpp s[10:11], v1, 10 quad_perm:[3,2,1,0]
// W64: v_cmp_lt_u32_e64_dpp s[10:11], v1, 10 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x49,0xd4,0xfa,0x14,0x01,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_u32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: v_cmp_lt_u32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x49,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_u32_e64_dpp s[10:11], v1, v2 row_mirror
// W64: v_cmp_lt_u32_e64_dpp s[10:11], v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x49,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_u32_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: v_cmp_lt_u32_e64_dpp s[10:11], v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x49,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_u32_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: v_cmp_lt_u32_e64_dpp s[10:11], v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x49,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_u32_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: v_cmp_lt_u32_e64_dpp s[10:11], v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x49,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_u32_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: v_cmp_lt_u32_e64_dpp s[10:11], v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x49,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_u32_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: v_cmp_lt_u32_e64_dpp s[10:11], v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x49,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_u32_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: v_cmp_lt_u32_e64_dpp s[10:11], v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x49,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_u32_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: v_cmp_lt_u32_e64_dpp s[10:11], v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x49,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_u32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: v_cmp_lt_u32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x68,0x00,0x49,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_u32_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: v_cmp_lt_u32_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6a,0x00,0x49,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_u32_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: v_cmp_lt_u32_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7a,0x00,0x49,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_lt_u32_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cmp_lt_u32_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0x7c,0x00,0x49,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x05,0x30]

v_cmp_ne_i16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: v_cmp_ne_i16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x35,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_i16_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0]
// W32: v_cmp_ne_i16_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x35,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_i16_e64_dpp s5, v1, 10 quad_perm:[3,2,1,0]
// W32: v_cmp_ne_i16_e64_dpp s5, v1, 10 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x35,0xd4,0xfa,0x14,0x01,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_i16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: v_cmp_ne_i16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x35,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_i16_e64_dpp s5, v1, v2 row_mirror
// W32: v_cmp_ne_i16_e64_dpp s5, v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x35,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_i16_e64_dpp s5, v1, v2 row_half_mirror
// W32: v_cmp_ne_i16_e64_dpp s5, v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x35,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_i16_e64_dpp s5, v1, v2 row_shl:1
// W32: v_cmp_ne_i16_e64_dpp s5, v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x35,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_i16_e64_dpp s5, v1, v2 row_shl:15
// W32: v_cmp_ne_i16_e64_dpp s5, v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x35,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_i16_e64_dpp s5, v1, v2 row_shr:1
// W32: v_cmp_ne_i16_e64_dpp s5, v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x35,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_i16_e64_dpp s5, v1, v2 row_shr:15
// W32: v_cmp_ne_i16_e64_dpp s5, v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x35,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_i16_e64_dpp s5, v1, v2 row_ror:1
// W32: v_cmp_ne_i16_e64_dpp s5, v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x35,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_i16_e64_dpp s105, v1, v2 row_ror:15
// W32: v_cmp_ne_i16_e64_dpp s105, v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x69,0x00,0x35,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_i16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: v_cmp_ne_i16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x6a,0x00,0x35,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_i16_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: v_cmp_ne_i16_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6b,0x00,0x35,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_i16_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: v_cmp_ne_i16_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7b,0x00,0x35,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_i16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: v_cmp_ne_i16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x35,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_i16_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0]
// W64: v_cmp_ne_i16_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x35,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_i16_e64_dpp s[10:11], v1, 10 quad_perm:[3,2,1,0]
// W64: v_cmp_ne_i16_e64_dpp s[10:11], v1, 10 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x35,0xd4,0xfa,0x14,0x01,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_i16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: v_cmp_ne_i16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x35,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_i16_e64_dpp s[10:11], v1, v2 row_mirror
// W64: v_cmp_ne_i16_e64_dpp s[10:11], v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x35,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_i16_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: v_cmp_ne_i16_e64_dpp s[10:11], v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x35,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_i16_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: v_cmp_ne_i16_e64_dpp s[10:11], v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x35,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_i16_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: v_cmp_ne_i16_e64_dpp s[10:11], v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x35,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_i16_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: v_cmp_ne_i16_e64_dpp s[10:11], v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x35,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_i16_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: v_cmp_ne_i16_e64_dpp s[10:11], v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x35,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_i16_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: v_cmp_ne_i16_e64_dpp s[10:11], v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x35,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_i16_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: v_cmp_ne_i16_e64_dpp s[10:11], v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x35,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_i16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: v_cmp_ne_i16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x68,0x00,0x35,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_i16_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: v_cmp_ne_i16_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6a,0x00,0x35,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_i16_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: v_cmp_ne_i16_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7a,0x00,0x35,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_i16_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cmp_ne_i16_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0x7c,0x00,0x35,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x05,0x30]

v_cmp_ne_i32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: v_cmp_ne_i32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x45,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_i32_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0]
// W32: v_cmp_ne_i32_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x45,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_i32_e64_dpp s5, v1, 10 quad_perm:[3,2,1,0]
// W32: v_cmp_ne_i32_e64_dpp s5, v1, 10 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x45,0xd4,0xfa,0x14,0x01,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_i32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: v_cmp_ne_i32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x45,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_i32_e64_dpp s5, v1, v2 row_mirror
// W32: v_cmp_ne_i32_e64_dpp s5, v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x45,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_i32_e64_dpp s5, v1, v2 row_half_mirror
// W32: v_cmp_ne_i32_e64_dpp s5, v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x45,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_i32_e64_dpp s5, v1, v2 row_shl:1
// W32: v_cmp_ne_i32_e64_dpp s5, v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x45,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_i32_e64_dpp s5, v1, v2 row_shl:15
// W32: v_cmp_ne_i32_e64_dpp s5, v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x45,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_i32_e64_dpp s5, v1, v2 row_shr:1
// W32: v_cmp_ne_i32_e64_dpp s5, v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x45,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_i32_e64_dpp s5, v1, v2 row_shr:15
// W32: v_cmp_ne_i32_e64_dpp s5, v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x45,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_i32_e64_dpp s5, v1, v2 row_ror:1
// W32: v_cmp_ne_i32_e64_dpp s5, v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x45,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_i32_e64_dpp s105, v1, v2 row_ror:15
// W32: v_cmp_ne_i32_e64_dpp s105, v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x69,0x00,0x45,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_i32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: v_cmp_ne_i32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x6a,0x00,0x45,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_i32_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: v_cmp_ne_i32_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6b,0x00,0x45,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_i32_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: v_cmp_ne_i32_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7b,0x00,0x45,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_i32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: v_cmp_ne_i32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x45,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_i32_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0]
// W64: v_cmp_ne_i32_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x45,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_i32_e64_dpp s[10:11], v1, 10 quad_perm:[3,2,1,0]
// W64: v_cmp_ne_i32_e64_dpp s[10:11], v1, 10 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x45,0xd4,0xfa,0x14,0x01,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_i32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: v_cmp_ne_i32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x45,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_i32_e64_dpp s[10:11], v1, v2 row_mirror
// W64: v_cmp_ne_i32_e64_dpp s[10:11], v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x45,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_i32_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: v_cmp_ne_i32_e64_dpp s[10:11], v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x45,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_i32_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: v_cmp_ne_i32_e64_dpp s[10:11], v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x45,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_i32_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: v_cmp_ne_i32_e64_dpp s[10:11], v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x45,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_i32_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: v_cmp_ne_i32_e64_dpp s[10:11], v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x45,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_i32_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: v_cmp_ne_i32_e64_dpp s[10:11], v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x45,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_i32_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: v_cmp_ne_i32_e64_dpp s[10:11], v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x45,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_i32_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: v_cmp_ne_i32_e64_dpp s[10:11], v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x45,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_i32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: v_cmp_ne_i32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x68,0x00,0x45,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_i32_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: v_cmp_ne_i32_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6a,0x00,0x45,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_i32_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: v_cmp_ne_i32_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7a,0x00,0x45,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_i32_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cmp_ne_i32_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0x7c,0x00,0x45,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x05,0x30]

v_cmp_ne_u16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: v_cmp_ne_u16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x3d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_u16_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0]
// W32: v_cmp_ne_u16_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x3d,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_u16_e64_dpp s5, v1, 10 quad_perm:[3,2,1,0]
// W32: v_cmp_ne_u16_e64_dpp s5, v1, 10 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x3d,0xd4,0xfa,0x14,0x01,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_u16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: v_cmp_ne_u16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x3d,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_u16_e64_dpp s5, v1, v2 row_mirror
// W32: v_cmp_ne_u16_e64_dpp s5, v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x3d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_u16_e64_dpp s5, v1, v2 row_half_mirror
// W32: v_cmp_ne_u16_e64_dpp s5, v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x3d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_u16_e64_dpp s5, v1, v2 row_shl:1
// W32: v_cmp_ne_u16_e64_dpp s5, v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x3d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_u16_e64_dpp s5, v1, v2 row_shl:15
// W32: v_cmp_ne_u16_e64_dpp s5, v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x3d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_u16_e64_dpp s5, v1, v2 row_shr:1
// W32: v_cmp_ne_u16_e64_dpp s5, v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x3d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_u16_e64_dpp s5, v1, v2 row_shr:15
// W32: v_cmp_ne_u16_e64_dpp s5, v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x3d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_u16_e64_dpp s5, v1, v2 row_ror:1
// W32: v_cmp_ne_u16_e64_dpp s5, v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x3d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_u16_e64_dpp s105, v1, v2 row_ror:15
// W32: v_cmp_ne_u16_e64_dpp s105, v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x69,0x00,0x3d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_u16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: v_cmp_ne_u16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x6a,0x00,0x3d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_u16_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: v_cmp_ne_u16_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6b,0x00,0x3d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_u16_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: v_cmp_ne_u16_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7b,0x00,0x3d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_u16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: v_cmp_ne_u16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x3d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_u16_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0]
// W64: v_cmp_ne_u16_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x3d,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_u16_e64_dpp s[10:11], v1, 10 quad_perm:[3,2,1,0]
// W64: v_cmp_ne_u16_e64_dpp s[10:11], v1, 10 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x3d,0xd4,0xfa,0x14,0x01,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_u16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: v_cmp_ne_u16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x3d,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_u16_e64_dpp s[10:11], v1, v2 row_mirror
// W64: v_cmp_ne_u16_e64_dpp s[10:11], v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x3d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_u16_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: v_cmp_ne_u16_e64_dpp s[10:11], v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x3d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_u16_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: v_cmp_ne_u16_e64_dpp s[10:11], v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x3d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_u16_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: v_cmp_ne_u16_e64_dpp s[10:11], v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x3d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_u16_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: v_cmp_ne_u16_e64_dpp s[10:11], v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x3d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_u16_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: v_cmp_ne_u16_e64_dpp s[10:11], v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x3d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_u16_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: v_cmp_ne_u16_e64_dpp s[10:11], v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x3d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_u16_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: v_cmp_ne_u16_e64_dpp s[10:11], v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x3d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_u16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: v_cmp_ne_u16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x68,0x00,0x3d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_u16_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: v_cmp_ne_u16_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6a,0x00,0x3d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_u16_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: v_cmp_ne_u16_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7a,0x00,0x3d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_u16_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cmp_ne_u16_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0x7c,0x00,0x3d,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x05,0x30]

v_cmp_ne_u32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: v_cmp_ne_u32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x4d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_u32_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0]
// W32: v_cmp_ne_u32_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x4d,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_u32_e64_dpp s5, v1, 10 quad_perm:[3,2,1,0]
// W32: v_cmp_ne_u32_e64_dpp s5, v1, 10 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x4d,0xd4,0xfa,0x14,0x01,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_u32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: v_cmp_ne_u32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x4d,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_u32_e64_dpp s5, v1, v2 row_mirror
// W32: v_cmp_ne_u32_e64_dpp s5, v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x4d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_u32_e64_dpp s5, v1, v2 row_half_mirror
// W32: v_cmp_ne_u32_e64_dpp s5, v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x4d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_u32_e64_dpp s5, v1, v2 row_shl:1
// W32: v_cmp_ne_u32_e64_dpp s5, v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x4d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_u32_e64_dpp s5, v1, v2 row_shl:15
// W32: v_cmp_ne_u32_e64_dpp s5, v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x4d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_u32_e64_dpp s5, v1, v2 row_shr:1
// W32: v_cmp_ne_u32_e64_dpp s5, v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x4d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_u32_e64_dpp s5, v1, v2 row_shr:15
// W32: v_cmp_ne_u32_e64_dpp s5, v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x4d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_u32_e64_dpp s5, v1, v2 row_ror:1
// W32: v_cmp_ne_u32_e64_dpp s5, v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x4d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_u32_e64_dpp s105, v1, v2 row_ror:15
// W32: v_cmp_ne_u32_e64_dpp s105, v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x69,0x00,0x4d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_u32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: v_cmp_ne_u32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x6a,0x00,0x4d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_u32_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: v_cmp_ne_u32_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6b,0x00,0x4d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_u32_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: v_cmp_ne_u32_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7b,0x00,0x4d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_u32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: v_cmp_ne_u32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x4d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_u32_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0]
// W64: v_cmp_ne_u32_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x4d,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_u32_e64_dpp s[10:11], v1, 10 quad_perm:[3,2,1,0]
// W64: v_cmp_ne_u32_e64_dpp s[10:11], v1, 10 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x4d,0xd4,0xfa,0x14,0x01,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_u32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: v_cmp_ne_u32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x4d,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_u32_e64_dpp s[10:11], v1, v2 row_mirror
// W64: v_cmp_ne_u32_e64_dpp s[10:11], v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x4d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_u32_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: v_cmp_ne_u32_e64_dpp s[10:11], v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x4d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_u32_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: v_cmp_ne_u32_e64_dpp s[10:11], v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x4d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_u32_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: v_cmp_ne_u32_e64_dpp s[10:11], v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x4d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_u32_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: v_cmp_ne_u32_e64_dpp s[10:11], v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x4d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_u32_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: v_cmp_ne_u32_e64_dpp s[10:11], v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x4d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_u32_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: v_cmp_ne_u32_e64_dpp s[10:11], v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x4d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_u32_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: v_cmp_ne_u32_e64_dpp s[10:11], v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x4d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_u32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: v_cmp_ne_u32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x68,0x00,0x4d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_u32_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: v_cmp_ne_u32_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6a,0x00,0x4d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_u32_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: v_cmp_ne_u32_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7a,0x00,0x4d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:22: error: invalid operand for instruction

v_cmp_ne_u32_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cmp_ne_u32_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0x7c,0x00,0x4d,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x05,0x30]

v_cmp_neq_f16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: v_cmp_neq_f16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x0d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_neq_f16_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0]
// W32: v_cmp_neq_f16_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x0d,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_neq_f16_e64_dpp s5, v1, 2.0 quad_perm:[3,2,1,0]
// W32: v_cmp_neq_f16_e64_dpp s5, v1, 2.0 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x0d,0xd4,0xfa,0xe8,0x01,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_neq_f16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: v_cmp_neq_f16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x0d,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_neq_f16_e64_dpp s5, v1, v2 row_mirror
// W32: v_cmp_neq_f16_e64_dpp s5, v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x0d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_neq_f16_e64_dpp s5, v1, v2 row_half_mirror
// W32: v_cmp_neq_f16_e64_dpp s5, v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x0d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_neq_f16_e64_dpp s5, v1, v2 row_shl:1
// W32: v_cmp_neq_f16_e64_dpp s5, v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x0d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_neq_f16_e64_dpp s5, v1, v2 row_shl:15
// W32: v_cmp_neq_f16_e64_dpp s5, v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x0d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_neq_f16_e64_dpp s5, v1, v2 row_shr:1
// W32: v_cmp_neq_f16_e64_dpp s5, v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x0d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_neq_f16_e64_dpp s5, v1, v2 row_shr:15
// W32: v_cmp_neq_f16_e64_dpp s5, v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x0d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_neq_f16_e64_dpp s5, v1, v2 row_ror:1
// W32: v_cmp_neq_f16_e64_dpp s5, v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x0d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_neq_f16_e64_dpp s105, v1, v2 row_ror:15
// W32: v_cmp_neq_f16_e64_dpp s105, v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x69,0x00,0x0d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_neq_f16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: v_cmp_neq_f16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x6a,0x00,0x0d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_neq_f16_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: v_cmp_neq_f16_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6b,0x01,0x0d,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_neq_f16_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: v_cmp_neq_f16_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7b,0x02,0x0d,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_neq_f16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: v_cmp_neq_f16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x0d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_neq_f16_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0]
// W64: v_cmp_neq_f16_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x0d,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_neq_f16_e64_dpp s[10:11], v1, 2.0 quad_perm:[3,2,1,0]
// W64: v_cmp_neq_f16_e64_dpp s[10:11], v1, 2.0 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x0d,0xd4,0xfa,0xe8,0x01,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_neq_f16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: v_cmp_neq_f16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x0d,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_neq_f16_e64_dpp s[10:11], v1, v2 row_mirror
// W64: v_cmp_neq_f16_e64_dpp s[10:11], v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x0d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_neq_f16_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: v_cmp_neq_f16_e64_dpp s[10:11], v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x0d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_neq_f16_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: v_cmp_neq_f16_e64_dpp s[10:11], v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x0d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_neq_f16_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: v_cmp_neq_f16_e64_dpp s[10:11], v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x0d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_neq_f16_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: v_cmp_neq_f16_e64_dpp s[10:11], v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x0d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_neq_f16_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: v_cmp_neq_f16_e64_dpp s[10:11], v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x0d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_neq_f16_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: v_cmp_neq_f16_e64_dpp s[10:11], v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x0d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_neq_f16_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: v_cmp_neq_f16_e64_dpp s[10:11], v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x0d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_neq_f16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: v_cmp_neq_f16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x68,0x00,0x0d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_neq_f16_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: v_cmp_neq_f16_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6a,0x01,0x0d,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_neq_f16_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: v_cmp_neq_f16_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7a,0x02,0x0d,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_neq_f16_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cmp_neq_f16_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0x7c,0x83,0x0d,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x05,0x30]

v_cmp_neq_f32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: v_cmp_neq_f32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x1d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_neq_f32_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0]
// W32: v_cmp_neq_f32_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x1d,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_neq_f32_e64_dpp s5, v1, 2.0 quad_perm:[3,2,1,0]
// W32: v_cmp_neq_f32_e64_dpp s5, v1, 2.0 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x1d,0xd4,0xfa,0xe8,0x01,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_neq_f32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: v_cmp_neq_f32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x1d,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_neq_f32_e64_dpp s5, v1, v2 row_mirror
// W32: v_cmp_neq_f32_e64_dpp s5, v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x1d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_neq_f32_e64_dpp s5, v1, v2 row_half_mirror
// W32: v_cmp_neq_f32_e64_dpp s5, v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x1d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_neq_f32_e64_dpp s5, v1, v2 row_shl:1
// W32: v_cmp_neq_f32_e64_dpp s5, v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x1d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_neq_f32_e64_dpp s5, v1, v2 row_shl:15
// W32: v_cmp_neq_f32_e64_dpp s5, v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x1d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_neq_f32_e64_dpp s5, v1, v2 row_shr:1
// W32: v_cmp_neq_f32_e64_dpp s5, v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x1d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_neq_f32_e64_dpp s5, v1, v2 row_shr:15
// W32: v_cmp_neq_f32_e64_dpp s5, v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x1d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_neq_f32_e64_dpp s5, v1, v2 row_ror:1
// W32: v_cmp_neq_f32_e64_dpp s5, v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x1d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_neq_f32_e64_dpp s105, v1, v2 row_ror:15
// W32: v_cmp_neq_f32_e64_dpp s105, v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x69,0x00,0x1d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_neq_f32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: v_cmp_neq_f32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x6a,0x00,0x1d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_neq_f32_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: v_cmp_neq_f32_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6b,0x01,0x1d,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_neq_f32_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: v_cmp_neq_f32_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7b,0x02,0x1d,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_neq_f32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: v_cmp_neq_f32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x1d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_neq_f32_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0]
// W64: v_cmp_neq_f32_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x1d,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_neq_f32_e64_dpp s[10:11], v1, 2.0 quad_perm:[3,2,1,0]
// W64: v_cmp_neq_f32_e64_dpp s[10:11], v1, 2.0 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x1d,0xd4,0xfa,0xe8,0x01,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_neq_f32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: v_cmp_neq_f32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x1d,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_neq_f32_e64_dpp s[10:11], v1, v2 row_mirror
// W64: v_cmp_neq_f32_e64_dpp s[10:11], v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x1d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_neq_f32_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: v_cmp_neq_f32_e64_dpp s[10:11], v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x1d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_neq_f32_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: v_cmp_neq_f32_e64_dpp s[10:11], v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x1d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_neq_f32_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: v_cmp_neq_f32_e64_dpp s[10:11], v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x1d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_neq_f32_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: v_cmp_neq_f32_e64_dpp s[10:11], v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x1d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_neq_f32_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: v_cmp_neq_f32_e64_dpp s[10:11], v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x1d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_neq_f32_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: v_cmp_neq_f32_e64_dpp s[10:11], v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x1d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_neq_f32_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: v_cmp_neq_f32_e64_dpp s[10:11], v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x1d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_neq_f32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: v_cmp_neq_f32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x68,0x00,0x1d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_neq_f32_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: v_cmp_neq_f32_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6a,0x01,0x1d,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_neq_f32_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: v_cmp_neq_f32_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7a,0x02,0x1d,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_neq_f32_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cmp_neq_f32_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0x7c,0x83,0x1d,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x05,0x30]

v_cmp_nge_f16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: v_cmp_nge_f16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x09,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nge_f16_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0]
// W32: v_cmp_nge_f16_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x09,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nge_f16_e64_dpp s5, v1, 2.0 quad_perm:[3,2,1,0]
// W32: v_cmp_nge_f16_e64_dpp s5, v1, 2.0 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x09,0xd4,0xfa,0xe8,0x01,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nge_f16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: v_cmp_nge_f16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x09,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nge_f16_e64_dpp s5, v1, v2 row_mirror
// W32: v_cmp_nge_f16_e64_dpp s5, v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x09,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nge_f16_e64_dpp s5, v1, v2 row_half_mirror
// W32: v_cmp_nge_f16_e64_dpp s5, v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x09,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nge_f16_e64_dpp s5, v1, v2 row_shl:1
// W32: v_cmp_nge_f16_e64_dpp s5, v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x09,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nge_f16_e64_dpp s5, v1, v2 row_shl:15
// W32: v_cmp_nge_f16_e64_dpp s5, v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x09,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nge_f16_e64_dpp s5, v1, v2 row_shr:1
// W32: v_cmp_nge_f16_e64_dpp s5, v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x09,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nge_f16_e64_dpp s5, v1, v2 row_shr:15
// W32: v_cmp_nge_f16_e64_dpp s5, v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x09,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nge_f16_e64_dpp s5, v1, v2 row_ror:1
// W32: v_cmp_nge_f16_e64_dpp s5, v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x09,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nge_f16_e64_dpp s105, v1, v2 row_ror:15
// W32: v_cmp_nge_f16_e64_dpp s105, v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x69,0x00,0x09,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nge_f16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: v_cmp_nge_f16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x6a,0x00,0x09,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nge_f16_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: v_cmp_nge_f16_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6b,0x01,0x09,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nge_f16_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: v_cmp_nge_f16_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7b,0x02,0x09,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nge_f16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: v_cmp_nge_f16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x09,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nge_f16_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0]
// W64: v_cmp_nge_f16_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x09,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nge_f16_e64_dpp s[10:11], v1, 2.0 quad_perm:[3,2,1,0]
// W64: v_cmp_nge_f16_e64_dpp s[10:11], v1, 2.0 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x09,0xd4,0xfa,0xe8,0x01,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nge_f16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: v_cmp_nge_f16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x09,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nge_f16_e64_dpp s[10:11], v1, v2 row_mirror
// W64: v_cmp_nge_f16_e64_dpp s[10:11], v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x09,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nge_f16_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: v_cmp_nge_f16_e64_dpp s[10:11], v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x09,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nge_f16_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: v_cmp_nge_f16_e64_dpp s[10:11], v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x09,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nge_f16_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: v_cmp_nge_f16_e64_dpp s[10:11], v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x09,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nge_f16_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: v_cmp_nge_f16_e64_dpp s[10:11], v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x09,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nge_f16_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: v_cmp_nge_f16_e64_dpp s[10:11], v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x09,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nge_f16_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: v_cmp_nge_f16_e64_dpp s[10:11], v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x09,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nge_f16_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: v_cmp_nge_f16_e64_dpp s[10:11], v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x09,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nge_f16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: v_cmp_nge_f16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x68,0x00,0x09,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nge_f16_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: v_cmp_nge_f16_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6a,0x01,0x09,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nge_f16_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: v_cmp_nge_f16_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7a,0x02,0x09,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nge_f16_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cmp_nge_f16_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0x7c,0x83,0x09,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x05,0x30]

v_cmp_nge_f32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: v_cmp_nge_f32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x19,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nge_f32_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0]
// W32: v_cmp_nge_f32_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x19,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nge_f32_e64_dpp s5, v1, 2.0 quad_perm:[3,2,1,0]
// W32: v_cmp_nge_f32_e64_dpp s5, v1, 2.0 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x19,0xd4,0xfa,0xe8,0x01,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nge_f32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: v_cmp_nge_f32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x19,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nge_f32_e64_dpp s5, v1, v2 row_mirror
// W32: v_cmp_nge_f32_e64_dpp s5, v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x19,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nge_f32_e64_dpp s5, v1, v2 row_half_mirror
// W32: v_cmp_nge_f32_e64_dpp s5, v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x19,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nge_f32_e64_dpp s5, v1, v2 row_shl:1
// W32: v_cmp_nge_f32_e64_dpp s5, v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x19,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nge_f32_e64_dpp s5, v1, v2 row_shl:15
// W32: v_cmp_nge_f32_e64_dpp s5, v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x19,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nge_f32_e64_dpp s5, v1, v2 row_shr:1
// W32: v_cmp_nge_f32_e64_dpp s5, v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x19,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nge_f32_e64_dpp s5, v1, v2 row_shr:15
// W32: v_cmp_nge_f32_e64_dpp s5, v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x19,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nge_f32_e64_dpp s5, v1, v2 row_ror:1
// W32: v_cmp_nge_f32_e64_dpp s5, v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x19,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nge_f32_e64_dpp s105, v1, v2 row_ror:15
// W32: v_cmp_nge_f32_e64_dpp s105, v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x69,0x00,0x19,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nge_f32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: v_cmp_nge_f32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x6a,0x00,0x19,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nge_f32_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: v_cmp_nge_f32_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6b,0x01,0x19,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nge_f32_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: v_cmp_nge_f32_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7b,0x02,0x19,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nge_f32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: v_cmp_nge_f32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x19,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nge_f32_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0]
// W64: v_cmp_nge_f32_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x19,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nge_f32_e64_dpp s[10:11], v1, 2.0 quad_perm:[3,2,1,0]
// W64: v_cmp_nge_f32_e64_dpp s[10:11], v1, 2.0 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x19,0xd4,0xfa,0xe8,0x01,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nge_f32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: v_cmp_nge_f32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x19,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nge_f32_e64_dpp s[10:11], v1, v2 row_mirror
// W64: v_cmp_nge_f32_e64_dpp s[10:11], v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x19,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nge_f32_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: v_cmp_nge_f32_e64_dpp s[10:11], v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x19,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nge_f32_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: v_cmp_nge_f32_e64_dpp s[10:11], v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x19,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nge_f32_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: v_cmp_nge_f32_e64_dpp s[10:11], v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x19,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nge_f32_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: v_cmp_nge_f32_e64_dpp s[10:11], v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x19,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nge_f32_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: v_cmp_nge_f32_e64_dpp s[10:11], v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x19,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nge_f32_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: v_cmp_nge_f32_e64_dpp s[10:11], v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x19,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nge_f32_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: v_cmp_nge_f32_e64_dpp s[10:11], v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x19,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nge_f32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: v_cmp_nge_f32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x68,0x00,0x19,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nge_f32_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: v_cmp_nge_f32_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6a,0x01,0x19,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nge_f32_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: v_cmp_nge_f32_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7a,0x02,0x19,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nge_f32_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cmp_nge_f32_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0x7c,0x83,0x19,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x05,0x30]

v_cmp_ngt_f16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: v_cmp_ngt_f16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x0b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_ngt_f16_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0]
// W32: v_cmp_ngt_f16_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x0b,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_ngt_f16_e64_dpp s5, v1, 2.0 quad_perm:[3,2,1,0]
// W32: v_cmp_ngt_f16_e64_dpp s5, v1, 2.0 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x0b,0xd4,0xfa,0xe8,0x01,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_ngt_f16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: v_cmp_ngt_f16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x0b,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_ngt_f16_e64_dpp s5, v1, v2 row_mirror
// W32: v_cmp_ngt_f16_e64_dpp s5, v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x0b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_ngt_f16_e64_dpp s5, v1, v2 row_half_mirror
// W32: v_cmp_ngt_f16_e64_dpp s5, v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x0b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_ngt_f16_e64_dpp s5, v1, v2 row_shl:1
// W32: v_cmp_ngt_f16_e64_dpp s5, v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x0b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_ngt_f16_e64_dpp s5, v1, v2 row_shl:15
// W32: v_cmp_ngt_f16_e64_dpp s5, v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x0b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_ngt_f16_e64_dpp s5, v1, v2 row_shr:1
// W32: v_cmp_ngt_f16_e64_dpp s5, v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x0b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_ngt_f16_e64_dpp s5, v1, v2 row_shr:15
// W32: v_cmp_ngt_f16_e64_dpp s5, v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x0b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_ngt_f16_e64_dpp s5, v1, v2 row_ror:1
// W32: v_cmp_ngt_f16_e64_dpp s5, v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x0b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_ngt_f16_e64_dpp s105, v1, v2 row_ror:15
// W32: v_cmp_ngt_f16_e64_dpp s105, v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x69,0x00,0x0b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_ngt_f16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: v_cmp_ngt_f16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x6a,0x00,0x0b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_ngt_f16_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: v_cmp_ngt_f16_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6b,0x01,0x0b,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_ngt_f16_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: v_cmp_ngt_f16_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7b,0x02,0x0b,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_ngt_f16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: v_cmp_ngt_f16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x0b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_ngt_f16_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0]
// W64: v_cmp_ngt_f16_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x0b,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_ngt_f16_e64_dpp s[10:11], v1, 2.0 quad_perm:[3,2,1,0]
// W64: v_cmp_ngt_f16_e64_dpp s[10:11], v1, 2.0 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x0b,0xd4,0xfa,0xe8,0x01,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_ngt_f16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: v_cmp_ngt_f16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x0b,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_ngt_f16_e64_dpp s[10:11], v1, v2 row_mirror
// W64: v_cmp_ngt_f16_e64_dpp s[10:11], v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x0b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_ngt_f16_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: v_cmp_ngt_f16_e64_dpp s[10:11], v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x0b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_ngt_f16_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: v_cmp_ngt_f16_e64_dpp s[10:11], v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x0b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_ngt_f16_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: v_cmp_ngt_f16_e64_dpp s[10:11], v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x0b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_ngt_f16_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: v_cmp_ngt_f16_e64_dpp s[10:11], v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x0b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_ngt_f16_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: v_cmp_ngt_f16_e64_dpp s[10:11], v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x0b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_ngt_f16_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: v_cmp_ngt_f16_e64_dpp s[10:11], v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x0b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_ngt_f16_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: v_cmp_ngt_f16_e64_dpp s[10:11], v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x0b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_ngt_f16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: v_cmp_ngt_f16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x68,0x00,0x0b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_ngt_f16_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: v_cmp_ngt_f16_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6a,0x01,0x0b,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_ngt_f16_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: v_cmp_ngt_f16_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7a,0x02,0x0b,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_ngt_f16_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cmp_ngt_f16_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0x7c,0x83,0x0b,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x05,0x30]

v_cmp_ngt_f32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: v_cmp_ngt_f32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x1b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_ngt_f32_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0]
// W32: v_cmp_ngt_f32_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x1b,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_ngt_f32_e64_dpp s5, v1, 2.0 quad_perm:[3,2,1,0]
// W32: v_cmp_ngt_f32_e64_dpp s5, v1, 2.0 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x1b,0xd4,0xfa,0xe8,0x01,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_ngt_f32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: v_cmp_ngt_f32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x1b,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_ngt_f32_e64_dpp s5, v1, v2 row_mirror
// W32: v_cmp_ngt_f32_e64_dpp s5, v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x1b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_ngt_f32_e64_dpp s5, v1, v2 row_half_mirror
// W32: v_cmp_ngt_f32_e64_dpp s5, v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x1b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_ngt_f32_e64_dpp s5, v1, v2 row_shl:1
// W32: v_cmp_ngt_f32_e64_dpp s5, v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x1b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_ngt_f32_e64_dpp s5, v1, v2 row_shl:15
// W32: v_cmp_ngt_f32_e64_dpp s5, v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x1b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_ngt_f32_e64_dpp s5, v1, v2 row_shr:1
// W32: v_cmp_ngt_f32_e64_dpp s5, v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x1b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_ngt_f32_e64_dpp s5, v1, v2 row_shr:15
// W32: v_cmp_ngt_f32_e64_dpp s5, v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x1b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_ngt_f32_e64_dpp s5, v1, v2 row_ror:1
// W32: v_cmp_ngt_f32_e64_dpp s5, v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x1b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_ngt_f32_e64_dpp s105, v1, v2 row_ror:15
// W32: v_cmp_ngt_f32_e64_dpp s105, v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x69,0x00,0x1b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_ngt_f32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: v_cmp_ngt_f32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x6a,0x00,0x1b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_ngt_f32_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: v_cmp_ngt_f32_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6b,0x01,0x1b,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_ngt_f32_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: v_cmp_ngt_f32_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7b,0x02,0x1b,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_ngt_f32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: v_cmp_ngt_f32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x1b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_ngt_f32_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0]
// W64: v_cmp_ngt_f32_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x1b,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_ngt_f32_e64_dpp s[10:11], v1, 2.0 quad_perm:[3,2,1,0]
// W64: v_cmp_ngt_f32_e64_dpp s[10:11], v1, 2.0 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x1b,0xd4,0xfa,0xe8,0x01,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_ngt_f32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: v_cmp_ngt_f32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x1b,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_ngt_f32_e64_dpp s[10:11], v1, v2 row_mirror
// W64: v_cmp_ngt_f32_e64_dpp s[10:11], v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x1b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_ngt_f32_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: v_cmp_ngt_f32_e64_dpp s[10:11], v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x1b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_ngt_f32_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: v_cmp_ngt_f32_e64_dpp s[10:11], v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x1b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_ngt_f32_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: v_cmp_ngt_f32_e64_dpp s[10:11], v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x1b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_ngt_f32_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: v_cmp_ngt_f32_e64_dpp s[10:11], v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x1b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_ngt_f32_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: v_cmp_ngt_f32_e64_dpp s[10:11], v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x1b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_ngt_f32_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: v_cmp_ngt_f32_e64_dpp s[10:11], v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x1b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_ngt_f32_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: v_cmp_ngt_f32_e64_dpp s[10:11], v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x1b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_ngt_f32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: v_cmp_ngt_f32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x68,0x00,0x1b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_ngt_f32_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: v_cmp_ngt_f32_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6a,0x01,0x1b,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_ngt_f32_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: v_cmp_ngt_f32_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7a,0x02,0x1b,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_ngt_f32_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cmp_ngt_f32_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0x7c,0x83,0x1b,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x05,0x30]

v_cmp_nle_f16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: v_cmp_nle_f16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x0c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nle_f16_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0]
// W32: v_cmp_nle_f16_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x0c,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nle_f16_e64_dpp s5, v1, 2.0 quad_perm:[3,2,1,0]
// W32: v_cmp_nle_f16_e64_dpp s5, v1, 2.0 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x0c,0xd4,0xfa,0xe8,0x01,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nle_f16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: v_cmp_nle_f16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x0c,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nle_f16_e64_dpp s5, v1, v2 row_mirror
// W32: v_cmp_nle_f16_e64_dpp s5, v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x0c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nle_f16_e64_dpp s5, v1, v2 row_half_mirror
// W32: v_cmp_nle_f16_e64_dpp s5, v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x0c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nle_f16_e64_dpp s5, v1, v2 row_shl:1
// W32: v_cmp_nle_f16_e64_dpp s5, v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x0c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nle_f16_e64_dpp s5, v1, v2 row_shl:15
// W32: v_cmp_nle_f16_e64_dpp s5, v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x0c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nle_f16_e64_dpp s5, v1, v2 row_shr:1
// W32: v_cmp_nle_f16_e64_dpp s5, v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x0c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nle_f16_e64_dpp s5, v1, v2 row_shr:15
// W32: v_cmp_nle_f16_e64_dpp s5, v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x0c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nle_f16_e64_dpp s5, v1, v2 row_ror:1
// W32: v_cmp_nle_f16_e64_dpp s5, v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x0c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nle_f16_e64_dpp s105, v1, v2 row_ror:15
// W32: v_cmp_nle_f16_e64_dpp s105, v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x69,0x00,0x0c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nle_f16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: v_cmp_nle_f16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x6a,0x00,0x0c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nle_f16_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: v_cmp_nle_f16_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6b,0x01,0x0c,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nle_f16_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: v_cmp_nle_f16_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7b,0x02,0x0c,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nle_f16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: v_cmp_nle_f16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x0c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nle_f16_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0]
// W64: v_cmp_nle_f16_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x0c,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nle_f16_e64_dpp s[10:11], v1, 2.0 quad_perm:[3,2,1,0]
// W64: v_cmp_nle_f16_e64_dpp s[10:11], v1, 2.0 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x0c,0xd4,0xfa,0xe8,0x01,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nle_f16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: v_cmp_nle_f16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x0c,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nle_f16_e64_dpp s[10:11], v1, v2 row_mirror
// W64: v_cmp_nle_f16_e64_dpp s[10:11], v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x0c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nle_f16_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: v_cmp_nle_f16_e64_dpp s[10:11], v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x0c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nle_f16_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: v_cmp_nle_f16_e64_dpp s[10:11], v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x0c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nle_f16_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: v_cmp_nle_f16_e64_dpp s[10:11], v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x0c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nle_f16_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: v_cmp_nle_f16_e64_dpp s[10:11], v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x0c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nle_f16_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: v_cmp_nle_f16_e64_dpp s[10:11], v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x0c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nle_f16_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: v_cmp_nle_f16_e64_dpp s[10:11], v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x0c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nle_f16_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: v_cmp_nle_f16_e64_dpp s[10:11], v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x0c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nle_f16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: v_cmp_nle_f16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x68,0x00,0x0c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nle_f16_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: v_cmp_nle_f16_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6a,0x01,0x0c,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nle_f16_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: v_cmp_nle_f16_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7a,0x02,0x0c,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nle_f16_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cmp_nle_f16_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0x7c,0x83,0x0c,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x05,0x30]

v_cmp_nle_f32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: v_cmp_nle_f32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x1c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nle_f32_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0]
// W32: v_cmp_nle_f32_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x1c,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nle_f32_e64_dpp s5, v1, 2.0 quad_perm:[3,2,1,0]
// W32: v_cmp_nle_f32_e64_dpp s5, v1, 2.0 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x1c,0xd4,0xfa,0xe8,0x01,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nle_f32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: v_cmp_nle_f32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x1c,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nle_f32_e64_dpp s5, v1, v2 row_mirror
// W32: v_cmp_nle_f32_e64_dpp s5, v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x1c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nle_f32_e64_dpp s5, v1, v2 row_half_mirror
// W32: v_cmp_nle_f32_e64_dpp s5, v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x1c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nle_f32_e64_dpp s5, v1, v2 row_shl:1
// W32: v_cmp_nle_f32_e64_dpp s5, v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x1c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nle_f32_e64_dpp s5, v1, v2 row_shl:15
// W32: v_cmp_nle_f32_e64_dpp s5, v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x1c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nle_f32_e64_dpp s5, v1, v2 row_shr:1
// W32: v_cmp_nle_f32_e64_dpp s5, v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x1c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nle_f32_e64_dpp s5, v1, v2 row_shr:15
// W32: v_cmp_nle_f32_e64_dpp s5, v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x1c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nle_f32_e64_dpp s5, v1, v2 row_ror:1
// W32: v_cmp_nle_f32_e64_dpp s5, v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x1c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nle_f32_e64_dpp s105, v1, v2 row_ror:15
// W32: v_cmp_nle_f32_e64_dpp s105, v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x69,0x00,0x1c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nle_f32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: v_cmp_nle_f32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x6a,0x00,0x1c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nle_f32_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: v_cmp_nle_f32_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6b,0x01,0x1c,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nle_f32_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: v_cmp_nle_f32_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7b,0x02,0x1c,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nle_f32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: v_cmp_nle_f32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x1c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nle_f32_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0]
// W64: v_cmp_nle_f32_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x1c,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nle_f32_e64_dpp s[10:11], v1, 2.0 quad_perm:[3,2,1,0]
// W64: v_cmp_nle_f32_e64_dpp s[10:11], v1, 2.0 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x1c,0xd4,0xfa,0xe8,0x01,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nle_f32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: v_cmp_nle_f32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x1c,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nle_f32_e64_dpp s[10:11], v1, v2 row_mirror
// W64: v_cmp_nle_f32_e64_dpp s[10:11], v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x1c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nle_f32_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: v_cmp_nle_f32_e64_dpp s[10:11], v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x1c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nle_f32_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: v_cmp_nle_f32_e64_dpp s[10:11], v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x1c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nle_f32_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: v_cmp_nle_f32_e64_dpp s[10:11], v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x1c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nle_f32_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: v_cmp_nle_f32_e64_dpp s[10:11], v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x1c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nle_f32_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: v_cmp_nle_f32_e64_dpp s[10:11], v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x1c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nle_f32_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: v_cmp_nle_f32_e64_dpp s[10:11], v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x1c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nle_f32_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: v_cmp_nle_f32_e64_dpp s[10:11], v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x1c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nle_f32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: v_cmp_nle_f32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x68,0x00,0x1c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nle_f32_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: v_cmp_nle_f32_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6a,0x01,0x1c,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nle_f32_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: v_cmp_nle_f32_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7a,0x02,0x1c,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nle_f32_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cmp_nle_f32_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0x7c,0x83,0x1c,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x05,0x30]

v_cmp_nlg_f16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: v_cmp_nlg_f16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x0a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlg_f16_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0]
// W32: v_cmp_nlg_f16_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x0a,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlg_f16_e64_dpp s5, v1, 2.0 quad_perm:[3,2,1,0]
// W32: v_cmp_nlg_f16_e64_dpp s5, v1, 2.0 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x0a,0xd4,0xfa,0xe8,0x01,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlg_f16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: v_cmp_nlg_f16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x0a,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlg_f16_e64_dpp s5, v1, v2 row_mirror
// W32: v_cmp_nlg_f16_e64_dpp s5, v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x0a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlg_f16_e64_dpp s5, v1, v2 row_half_mirror
// W32: v_cmp_nlg_f16_e64_dpp s5, v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x0a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlg_f16_e64_dpp s5, v1, v2 row_shl:1
// W32: v_cmp_nlg_f16_e64_dpp s5, v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x0a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlg_f16_e64_dpp s5, v1, v2 row_shl:15
// W32: v_cmp_nlg_f16_e64_dpp s5, v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x0a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlg_f16_e64_dpp s5, v1, v2 row_shr:1
// W32: v_cmp_nlg_f16_e64_dpp s5, v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x0a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlg_f16_e64_dpp s5, v1, v2 row_shr:15
// W32: v_cmp_nlg_f16_e64_dpp s5, v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x0a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlg_f16_e64_dpp s5, v1, v2 row_ror:1
// W32: v_cmp_nlg_f16_e64_dpp s5, v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x0a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlg_f16_e64_dpp s105, v1, v2 row_ror:15
// W32: v_cmp_nlg_f16_e64_dpp s105, v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x69,0x00,0x0a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlg_f16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: v_cmp_nlg_f16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x6a,0x00,0x0a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlg_f16_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: v_cmp_nlg_f16_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6b,0x01,0x0a,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlg_f16_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: v_cmp_nlg_f16_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7b,0x02,0x0a,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlg_f16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: v_cmp_nlg_f16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x0a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlg_f16_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0]
// W64: v_cmp_nlg_f16_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x0a,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlg_f16_e64_dpp s[10:11], v1, 2.0 quad_perm:[3,2,1,0]
// W64: v_cmp_nlg_f16_e64_dpp s[10:11], v1, 2.0 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x0a,0xd4,0xfa,0xe8,0x01,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlg_f16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: v_cmp_nlg_f16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x0a,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlg_f16_e64_dpp s[10:11], v1, v2 row_mirror
// W64: v_cmp_nlg_f16_e64_dpp s[10:11], v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x0a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlg_f16_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: v_cmp_nlg_f16_e64_dpp s[10:11], v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x0a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlg_f16_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: v_cmp_nlg_f16_e64_dpp s[10:11], v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x0a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlg_f16_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: v_cmp_nlg_f16_e64_dpp s[10:11], v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x0a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlg_f16_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: v_cmp_nlg_f16_e64_dpp s[10:11], v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x0a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlg_f16_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: v_cmp_nlg_f16_e64_dpp s[10:11], v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x0a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlg_f16_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: v_cmp_nlg_f16_e64_dpp s[10:11], v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x0a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlg_f16_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: v_cmp_nlg_f16_e64_dpp s[10:11], v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x0a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlg_f16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: v_cmp_nlg_f16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x68,0x00,0x0a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlg_f16_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: v_cmp_nlg_f16_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6a,0x01,0x0a,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlg_f16_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: v_cmp_nlg_f16_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7a,0x02,0x0a,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlg_f16_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cmp_nlg_f16_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0x7c,0x83,0x0a,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x05,0x30]

v_cmp_nlg_f32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: v_cmp_nlg_f32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x1a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlg_f32_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0]
// W32: v_cmp_nlg_f32_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x1a,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlg_f32_e64_dpp s5, v1, 2.0 quad_perm:[3,2,1,0]
// W32: v_cmp_nlg_f32_e64_dpp s5, v1, 2.0 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x1a,0xd4,0xfa,0xe8,0x01,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlg_f32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: v_cmp_nlg_f32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x1a,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlg_f32_e64_dpp s5, v1, v2 row_mirror
// W32: v_cmp_nlg_f32_e64_dpp s5, v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x1a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlg_f32_e64_dpp s5, v1, v2 row_half_mirror
// W32: v_cmp_nlg_f32_e64_dpp s5, v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x1a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlg_f32_e64_dpp s5, v1, v2 row_shl:1
// W32: v_cmp_nlg_f32_e64_dpp s5, v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x1a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlg_f32_e64_dpp s5, v1, v2 row_shl:15
// W32: v_cmp_nlg_f32_e64_dpp s5, v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x1a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlg_f32_e64_dpp s5, v1, v2 row_shr:1
// W32: v_cmp_nlg_f32_e64_dpp s5, v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x1a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlg_f32_e64_dpp s5, v1, v2 row_shr:15
// W32: v_cmp_nlg_f32_e64_dpp s5, v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x1a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlg_f32_e64_dpp s5, v1, v2 row_ror:1
// W32: v_cmp_nlg_f32_e64_dpp s5, v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x1a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlg_f32_e64_dpp s105, v1, v2 row_ror:15
// W32: v_cmp_nlg_f32_e64_dpp s105, v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x69,0x00,0x1a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlg_f32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: v_cmp_nlg_f32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x6a,0x00,0x1a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlg_f32_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: v_cmp_nlg_f32_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6b,0x01,0x1a,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlg_f32_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: v_cmp_nlg_f32_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7b,0x02,0x1a,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlg_f32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: v_cmp_nlg_f32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x1a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlg_f32_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0]
// W64: v_cmp_nlg_f32_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x1a,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlg_f32_e64_dpp s[10:11], v1, 2.0 quad_perm:[3,2,1,0]
// W64: v_cmp_nlg_f32_e64_dpp s[10:11], v1, 2.0 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x1a,0xd4,0xfa,0xe8,0x01,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlg_f32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: v_cmp_nlg_f32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x1a,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlg_f32_e64_dpp s[10:11], v1, v2 row_mirror
// W64: v_cmp_nlg_f32_e64_dpp s[10:11], v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x1a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlg_f32_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: v_cmp_nlg_f32_e64_dpp s[10:11], v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x1a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlg_f32_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: v_cmp_nlg_f32_e64_dpp s[10:11], v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x1a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlg_f32_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: v_cmp_nlg_f32_e64_dpp s[10:11], v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x1a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlg_f32_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: v_cmp_nlg_f32_e64_dpp s[10:11], v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x1a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlg_f32_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: v_cmp_nlg_f32_e64_dpp s[10:11], v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x1a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlg_f32_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: v_cmp_nlg_f32_e64_dpp s[10:11], v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x1a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlg_f32_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: v_cmp_nlg_f32_e64_dpp s[10:11], v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x1a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlg_f32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: v_cmp_nlg_f32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x68,0x00,0x1a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlg_f32_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: v_cmp_nlg_f32_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6a,0x01,0x1a,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlg_f32_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: v_cmp_nlg_f32_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7a,0x02,0x1a,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlg_f32_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cmp_nlg_f32_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0x7c,0x83,0x1a,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x05,0x30]

v_cmp_nlt_f16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: v_cmp_nlt_f16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x0e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlt_f16_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0]
// W32: v_cmp_nlt_f16_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x0e,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlt_f16_e64_dpp s5, v1, 2.0 quad_perm:[3,2,1,0]
// W32: v_cmp_nlt_f16_e64_dpp s5, v1, 2.0 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x0e,0xd4,0xfa,0xe8,0x01,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlt_f16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: v_cmp_nlt_f16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x0e,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlt_f16_e64_dpp s5, v1, v2 row_mirror
// W32: v_cmp_nlt_f16_e64_dpp s5, v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x0e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlt_f16_e64_dpp s5, v1, v2 row_half_mirror
// W32: v_cmp_nlt_f16_e64_dpp s5, v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x0e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlt_f16_e64_dpp s5, v1, v2 row_shl:1
// W32: v_cmp_nlt_f16_e64_dpp s5, v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x0e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlt_f16_e64_dpp s5, v1, v2 row_shl:15
// W32: v_cmp_nlt_f16_e64_dpp s5, v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x0e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlt_f16_e64_dpp s5, v1, v2 row_shr:1
// W32: v_cmp_nlt_f16_e64_dpp s5, v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x0e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlt_f16_e64_dpp s5, v1, v2 row_shr:15
// W32: v_cmp_nlt_f16_e64_dpp s5, v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x0e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlt_f16_e64_dpp s5, v1, v2 row_ror:1
// W32: v_cmp_nlt_f16_e64_dpp s5, v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x0e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlt_f16_e64_dpp s105, v1, v2 row_ror:15
// W32: v_cmp_nlt_f16_e64_dpp s105, v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x69,0x00,0x0e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlt_f16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: v_cmp_nlt_f16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x6a,0x00,0x0e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlt_f16_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: v_cmp_nlt_f16_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6b,0x01,0x0e,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlt_f16_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: v_cmp_nlt_f16_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7b,0x02,0x0e,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlt_f16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: v_cmp_nlt_f16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x0e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlt_f16_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0]
// W64: v_cmp_nlt_f16_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x0e,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlt_f16_e64_dpp s[10:11], v1, 2.0 quad_perm:[3,2,1,0]
// W64: v_cmp_nlt_f16_e64_dpp s[10:11], v1, 2.0 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x0e,0xd4,0xfa,0xe8,0x01,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlt_f16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: v_cmp_nlt_f16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x0e,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlt_f16_e64_dpp s[10:11], v1, v2 row_mirror
// W64: v_cmp_nlt_f16_e64_dpp s[10:11], v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x0e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlt_f16_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: v_cmp_nlt_f16_e64_dpp s[10:11], v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x0e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlt_f16_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: v_cmp_nlt_f16_e64_dpp s[10:11], v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x0e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlt_f16_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: v_cmp_nlt_f16_e64_dpp s[10:11], v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x0e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlt_f16_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: v_cmp_nlt_f16_e64_dpp s[10:11], v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x0e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlt_f16_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: v_cmp_nlt_f16_e64_dpp s[10:11], v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x0e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlt_f16_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: v_cmp_nlt_f16_e64_dpp s[10:11], v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x0e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlt_f16_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: v_cmp_nlt_f16_e64_dpp s[10:11], v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x0e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlt_f16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: v_cmp_nlt_f16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x68,0x00,0x0e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlt_f16_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: v_cmp_nlt_f16_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6a,0x01,0x0e,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlt_f16_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: v_cmp_nlt_f16_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7a,0x02,0x0e,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlt_f16_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cmp_nlt_f16_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0x7c,0x83,0x0e,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x05,0x30]

v_cmp_nlt_f32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: v_cmp_nlt_f32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x1e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlt_f32_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0]
// W32: v_cmp_nlt_f32_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x1e,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlt_f32_e64_dpp s5, v1, 2.0 quad_perm:[3,2,1,0]
// W32: v_cmp_nlt_f32_e64_dpp s5, v1, 2.0 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x1e,0xd4,0xfa,0xe8,0x01,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlt_f32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: v_cmp_nlt_f32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x1e,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlt_f32_e64_dpp s5, v1, v2 row_mirror
// W32: v_cmp_nlt_f32_e64_dpp s5, v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x1e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlt_f32_e64_dpp s5, v1, v2 row_half_mirror
// W32: v_cmp_nlt_f32_e64_dpp s5, v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x1e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlt_f32_e64_dpp s5, v1, v2 row_shl:1
// W32: v_cmp_nlt_f32_e64_dpp s5, v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x1e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlt_f32_e64_dpp s5, v1, v2 row_shl:15
// W32: v_cmp_nlt_f32_e64_dpp s5, v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x1e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlt_f32_e64_dpp s5, v1, v2 row_shr:1
// W32: v_cmp_nlt_f32_e64_dpp s5, v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x1e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlt_f32_e64_dpp s5, v1, v2 row_shr:15
// W32: v_cmp_nlt_f32_e64_dpp s5, v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x1e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlt_f32_e64_dpp s5, v1, v2 row_ror:1
// W32: v_cmp_nlt_f32_e64_dpp s5, v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x1e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlt_f32_e64_dpp s105, v1, v2 row_ror:15
// W32: v_cmp_nlt_f32_e64_dpp s105, v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x69,0x00,0x1e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlt_f32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: v_cmp_nlt_f32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x6a,0x00,0x1e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlt_f32_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: v_cmp_nlt_f32_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6b,0x01,0x1e,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlt_f32_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: v_cmp_nlt_f32_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7b,0x02,0x1e,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlt_f32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: v_cmp_nlt_f32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x1e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlt_f32_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0]
// W64: v_cmp_nlt_f32_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x1e,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlt_f32_e64_dpp s[10:11], v1, 2.0 quad_perm:[3,2,1,0]
// W64: v_cmp_nlt_f32_e64_dpp s[10:11], v1, 2.0 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x1e,0xd4,0xfa,0xe8,0x01,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlt_f32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: v_cmp_nlt_f32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x1e,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlt_f32_e64_dpp s[10:11], v1, v2 row_mirror
// W64: v_cmp_nlt_f32_e64_dpp s[10:11], v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x1e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlt_f32_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: v_cmp_nlt_f32_e64_dpp s[10:11], v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x1e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlt_f32_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: v_cmp_nlt_f32_e64_dpp s[10:11], v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x1e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlt_f32_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: v_cmp_nlt_f32_e64_dpp s[10:11], v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x1e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlt_f32_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: v_cmp_nlt_f32_e64_dpp s[10:11], v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x1e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlt_f32_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: v_cmp_nlt_f32_e64_dpp s[10:11], v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x1e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlt_f32_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: v_cmp_nlt_f32_e64_dpp s[10:11], v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x1e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlt_f32_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: v_cmp_nlt_f32_e64_dpp s[10:11], v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x1e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlt_f32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: v_cmp_nlt_f32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x68,0x00,0x1e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlt_f32_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: v_cmp_nlt_f32_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6a,0x01,0x1e,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlt_f32_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: v_cmp_nlt_f32_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7a,0x02,0x1e,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:23: error: invalid operand for instruction

v_cmp_nlt_f32_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cmp_nlt_f32_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0x7c,0x83,0x1e,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x05,0x30]

v_cmp_o_f16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: v_cmp_o_f16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x07,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_o_f16_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0]
// W32: v_cmp_o_f16_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x07,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_o_f16_e64_dpp s5, v1, 2.0 quad_perm:[3,2,1,0]
// W32: v_cmp_o_f16_e64_dpp s5, v1, 2.0 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x07,0xd4,0xfa,0xe8,0x01,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_o_f16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: v_cmp_o_f16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x07,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_o_f16_e64_dpp s5, v1, v2 row_mirror
// W32: v_cmp_o_f16_e64_dpp s5, v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x07,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_o_f16_e64_dpp s5, v1, v2 row_half_mirror
// W32: v_cmp_o_f16_e64_dpp s5, v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x07,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_o_f16_e64_dpp s5, v1, v2 row_shl:1
// W32: v_cmp_o_f16_e64_dpp s5, v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x07,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_o_f16_e64_dpp s5, v1, v2 row_shl:15
// W32: v_cmp_o_f16_e64_dpp s5, v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x07,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_o_f16_e64_dpp s5, v1, v2 row_shr:1
// W32: v_cmp_o_f16_e64_dpp s5, v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x07,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_o_f16_e64_dpp s5, v1, v2 row_shr:15
// W32: v_cmp_o_f16_e64_dpp s5, v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x07,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_o_f16_e64_dpp s5, v1, v2 row_ror:1
// W32: v_cmp_o_f16_e64_dpp s5, v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x07,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_o_f16_e64_dpp s105, v1, v2 row_ror:15
// W32: v_cmp_o_f16_e64_dpp s105, v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x69,0x00,0x07,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_o_f16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: v_cmp_o_f16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x6a,0x00,0x07,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_o_f16_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: v_cmp_o_f16_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6b,0x01,0x07,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_o_f16_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: v_cmp_o_f16_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7b,0x02,0x07,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_o_f16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: v_cmp_o_f16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x07,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_o_f16_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0]
// W64: v_cmp_o_f16_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x07,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_o_f16_e64_dpp s[10:11], v1, 2.0 quad_perm:[3,2,1,0]
// W64: v_cmp_o_f16_e64_dpp s[10:11], v1, 2.0 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x07,0xd4,0xfa,0xe8,0x01,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_o_f16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: v_cmp_o_f16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x07,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_o_f16_e64_dpp s[10:11], v1, v2 row_mirror
// W64: v_cmp_o_f16_e64_dpp s[10:11], v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x07,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_o_f16_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: v_cmp_o_f16_e64_dpp s[10:11], v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x07,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_o_f16_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: v_cmp_o_f16_e64_dpp s[10:11], v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x07,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_o_f16_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: v_cmp_o_f16_e64_dpp s[10:11], v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x07,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_o_f16_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: v_cmp_o_f16_e64_dpp s[10:11], v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x07,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_o_f16_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: v_cmp_o_f16_e64_dpp s[10:11], v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x07,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_o_f16_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: v_cmp_o_f16_e64_dpp s[10:11], v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x07,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_o_f16_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: v_cmp_o_f16_e64_dpp s[10:11], v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x07,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_o_f16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: v_cmp_o_f16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x68,0x00,0x07,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_o_f16_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: v_cmp_o_f16_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6a,0x01,0x07,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_o_f16_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: v_cmp_o_f16_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7a,0x02,0x07,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_o_f16_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cmp_o_f16_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0x7c,0x83,0x07,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x05,0x30]

v_cmp_o_f32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: v_cmp_o_f32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x17,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_o_f32_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0]
// W32: v_cmp_o_f32_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x17,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_o_f32_e64_dpp s5, v1, 2.0 quad_perm:[3,2,1,0]
// W32: v_cmp_o_f32_e64_dpp s5, v1, 2.0 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x17,0xd4,0xfa,0xe8,0x01,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_o_f32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: v_cmp_o_f32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x17,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_o_f32_e64_dpp s5, v1, v2 row_mirror
// W32: v_cmp_o_f32_e64_dpp s5, v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x17,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_o_f32_e64_dpp s5, v1, v2 row_half_mirror
// W32: v_cmp_o_f32_e64_dpp s5, v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x17,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_o_f32_e64_dpp s5, v1, v2 row_shl:1
// W32: v_cmp_o_f32_e64_dpp s5, v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x17,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_o_f32_e64_dpp s5, v1, v2 row_shl:15
// W32: v_cmp_o_f32_e64_dpp s5, v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x17,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_o_f32_e64_dpp s5, v1, v2 row_shr:1
// W32: v_cmp_o_f32_e64_dpp s5, v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x17,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_o_f32_e64_dpp s5, v1, v2 row_shr:15
// W32: v_cmp_o_f32_e64_dpp s5, v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x17,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_o_f32_e64_dpp s5, v1, v2 row_ror:1
// W32: v_cmp_o_f32_e64_dpp s5, v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x17,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_o_f32_e64_dpp s105, v1, v2 row_ror:15
// W32: v_cmp_o_f32_e64_dpp s105, v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x69,0x00,0x17,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_o_f32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: v_cmp_o_f32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x6a,0x00,0x17,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_o_f32_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: v_cmp_o_f32_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6b,0x01,0x17,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_o_f32_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: v_cmp_o_f32_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7b,0x02,0x17,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_o_f32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: v_cmp_o_f32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x17,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_o_f32_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0]
// W64: v_cmp_o_f32_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x17,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_o_f32_e64_dpp s[10:11], v1, 2.0 quad_perm:[3,2,1,0]
// W64: v_cmp_o_f32_e64_dpp s[10:11], v1, 2.0 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x17,0xd4,0xfa,0xe8,0x01,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_o_f32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: v_cmp_o_f32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x17,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_o_f32_e64_dpp s[10:11], v1, v2 row_mirror
// W64: v_cmp_o_f32_e64_dpp s[10:11], v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x17,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_o_f32_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: v_cmp_o_f32_e64_dpp s[10:11], v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x17,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_o_f32_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: v_cmp_o_f32_e64_dpp s[10:11], v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x17,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_o_f32_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: v_cmp_o_f32_e64_dpp s[10:11], v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x17,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_o_f32_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: v_cmp_o_f32_e64_dpp s[10:11], v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x17,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_o_f32_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: v_cmp_o_f32_e64_dpp s[10:11], v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x17,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_o_f32_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: v_cmp_o_f32_e64_dpp s[10:11], v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x17,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_o_f32_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: v_cmp_o_f32_e64_dpp s[10:11], v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x17,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_o_f32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: v_cmp_o_f32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x68,0x00,0x17,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_o_f32_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: v_cmp_o_f32_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6a,0x01,0x17,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_o_f32_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: v_cmp_o_f32_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7a,0x02,0x17,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_o_f32_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cmp_o_f32_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0x7c,0x83,0x17,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x05,0x30]

v_cmp_u_f16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: v_cmp_u_f16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x08,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_u_f16_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0]
// W32: v_cmp_u_f16_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x08,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_u_f16_e64_dpp s5, v1, 2.0 quad_perm:[3,2,1,0]
// W32: v_cmp_u_f16_e64_dpp s5, v1, 2.0 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x08,0xd4,0xfa,0xe8,0x01,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_u_f16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: v_cmp_u_f16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x08,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_u_f16_e64_dpp s5, v1, v2 row_mirror
// W32: v_cmp_u_f16_e64_dpp s5, v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x08,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_u_f16_e64_dpp s5, v1, v2 row_half_mirror
// W32: v_cmp_u_f16_e64_dpp s5, v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x08,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_u_f16_e64_dpp s5, v1, v2 row_shl:1
// W32: v_cmp_u_f16_e64_dpp s5, v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x08,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_u_f16_e64_dpp s5, v1, v2 row_shl:15
// W32: v_cmp_u_f16_e64_dpp s5, v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x08,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_u_f16_e64_dpp s5, v1, v2 row_shr:1
// W32: v_cmp_u_f16_e64_dpp s5, v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x08,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_u_f16_e64_dpp s5, v1, v2 row_shr:15
// W32: v_cmp_u_f16_e64_dpp s5, v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x08,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_u_f16_e64_dpp s5, v1, v2 row_ror:1
// W32: v_cmp_u_f16_e64_dpp s5, v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x08,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_u_f16_e64_dpp s105, v1, v2 row_ror:15
// W32: v_cmp_u_f16_e64_dpp s105, v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x69,0x00,0x08,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_u_f16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: v_cmp_u_f16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x6a,0x00,0x08,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_u_f16_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: v_cmp_u_f16_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6b,0x01,0x08,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_u_f16_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: v_cmp_u_f16_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7b,0x02,0x08,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_u_f16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: v_cmp_u_f16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x08,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_u_f16_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0]
// W64: v_cmp_u_f16_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x08,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_u_f16_e64_dpp s[10:11], v1, 2.0 quad_perm:[3,2,1,0]
// W64: v_cmp_u_f16_e64_dpp s[10:11], v1, 2.0 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x08,0xd4,0xfa,0xe8,0x01,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_u_f16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: v_cmp_u_f16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x08,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_u_f16_e64_dpp s[10:11], v1, v2 row_mirror
// W64: v_cmp_u_f16_e64_dpp s[10:11], v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x08,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_u_f16_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: v_cmp_u_f16_e64_dpp s[10:11], v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x08,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_u_f16_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: v_cmp_u_f16_e64_dpp s[10:11], v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x08,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_u_f16_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: v_cmp_u_f16_e64_dpp s[10:11], v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x08,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_u_f16_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: v_cmp_u_f16_e64_dpp s[10:11], v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x08,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_u_f16_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: v_cmp_u_f16_e64_dpp s[10:11], v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x08,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_u_f16_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: v_cmp_u_f16_e64_dpp s[10:11], v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x08,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_u_f16_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: v_cmp_u_f16_e64_dpp s[10:11], v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x08,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_u_f16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: v_cmp_u_f16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x68,0x00,0x08,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_u_f16_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: v_cmp_u_f16_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6a,0x01,0x08,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_u_f16_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: v_cmp_u_f16_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7a,0x02,0x08,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_u_f16_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cmp_u_f16_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0x7c,0x83,0x08,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x05,0x30]

v_cmp_u_f32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: v_cmp_u_f32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x18,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_u_f32_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0]
// W32: v_cmp_u_f32_e64_dpp s5, v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x18,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_u_f32_e64_dpp s5, v1, 2.0 quad_perm:[3,2,1,0]
// W32: v_cmp_u_f32_e64_dpp s5, v1, 2.0 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x18,0xd4,0xfa,0xe8,0x01,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_u_f32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: v_cmp_u_f32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x18,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_u_f32_e64_dpp s5, v1, v2 row_mirror
// W32: v_cmp_u_f32_e64_dpp s5, v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x18,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_u_f32_e64_dpp s5, v1, v2 row_half_mirror
// W32: v_cmp_u_f32_e64_dpp s5, v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x18,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_u_f32_e64_dpp s5, v1, v2 row_shl:1
// W32: v_cmp_u_f32_e64_dpp s5, v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x18,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_u_f32_e64_dpp s5, v1, v2 row_shl:15
// W32: v_cmp_u_f32_e64_dpp s5, v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x18,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_u_f32_e64_dpp s5, v1, v2 row_shr:1
// W32: v_cmp_u_f32_e64_dpp s5, v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x18,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_u_f32_e64_dpp s5, v1, v2 row_shr:15
// W32: v_cmp_u_f32_e64_dpp s5, v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x18,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_u_f32_e64_dpp s5, v1, v2 row_ror:1
// W32: v_cmp_u_f32_e64_dpp s5, v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x18,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_u_f32_e64_dpp s105, v1, v2 row_ror:15
// W32: v_cmp_u_f32_e64_dpp s105, v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x69,0x00,0x18,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_u_f32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: v_cmp_u_f32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x6a,0x00,0x18,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_u_f32_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: v_cmp_u_f32_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6b,0x01,0x18,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_u_f32_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: v_cmp_u_f32_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7b,0x02,0x18,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_u_f32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: v_cmp_u_f32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x18,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_u_f32_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0]
// W64: v_cmp_u_f32_e64_dpp s[10:11], v1, s2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x18,0xd4,0xfa,0x04,0x00,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_u_f32_e64_dpp s[10:11], v1, 2.0 quad_perm:[3,2,1,0]
// W64: v_cmp_u_f32_e64_dpp s[10:11], v1, 2.0 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x18,0xd4,0xfa,0xe8,0x01,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_u_f32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: v_cmp_u_f32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x18,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_u_f32_e64_dpp s[10:11], v1, v2 row_mirror
// W64: v_cmp_u_f32_e64_dpp s[10:11], v1, v2 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x18,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_u_f32_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: v_cmp_u_f32_e64_dpp s[10:11], v1, v2 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x18,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_u_f32_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: v_cmp_u_f32_e64_dpp s[10:11], v1, v2 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x18,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_u_f32_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: v_cmp_u_f32_e64_dpp s[10:11], v1, v2 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x18,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_u_f32_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: v_cmp_u_f32_e64_dpp s[10:11], v1, v2 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x18,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_u_f32_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: v_cmp_u_f32_e64_dpp s[10:11], v1, v2 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x18,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_u_f32_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: v_cmp_u_f32_e64_dpp s[10:11], v1, v2 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x18,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_u_f32_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: v_cmp_u_f32_e64_dpp s[10:11], v1, v2 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x0a,0x00,0x18,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_u_f32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: v_cmp_u_f32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x68,0x00,0x18,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_u_f32_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: v_cmp_u_f32_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x6a,0x01,0x18,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_u_f32_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: v_cmp_u_f32_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x7a,0x02,0x18,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:21: error: invalid operand for instruction

v_cmp_u_f32_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cmp_u_f32_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0x7c,0x83,0x18,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x05,0x30]
