; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc < %s -mtriple=i686-linux-gnu -global-isel=0 | FileCheck %s --check-prefixes=X86,SDAG-X86
; RUN: llc < %s -mtriple=x86_64-unknown-linux-gnu -global-isel=0 | FileCheck %s --check-prefixes=SDAG-X64
; RUN: llc < %s -mtriple=i686-linux-gnu -global-isel -global-isel-abort=1 | FileCheck %s --check-prefixes=X86,GISEL-X86
; RUN: llc < %s -mtriple=x86_64-linux-gnu -global-isel -global-isel-abort=1 | FileCheck %s --check-prefixes=GISEL-X64

define float @test_sin_f32(float %Val) nounwind {
; SDAG-X86-LABEL: test_sin_f32:
; SDAG-X86:       # %bb.0:
; SDAG-X86-NEXT:    subl $12, %esp
; SDAG-X86-NEXT:    flds {{[0-9]+}}(%esp)
; SDAG-X86-NEXT:    fstps (%esp)
; SDAG-X86-NEXT:    calll sinf
; SDAG-X86-NEXT:    addl $12, %esp
; SDAG-X86-NEXT:    retl
;
; SDAG-X64-LABEL: test_sin_f32:
; SDAG-X64:       # %bb.0:
; SDAG-X64-NEXT:    jmp sinf@PLT # TAILCALL
;
; GISEL-X86-LABEL: test_sin_f32:
; GISEL-X86:       # %bb.0:
; GISEL-X86-NEXT:    subl $12, %esp
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL-X86-NEXT:    movl %eax, (%esp)
; GISEL-X86-NEXT:    calll sinf
; GISEL-X86-NEXT:    addl $12, %esp
; GISEL-X86-NEXT:    retl
;
; GISEL-X64-LABEL: test_sin_f32:
; GISEL-X64:       # %bb.0:
; GISEL-X64-NEXT:    pushq %rax
; GISEL-X64-NEXT:    callq sinf
; GISEL-X64-NEXT:    popq %rax
; GISEL-X64-NEXT:    retq
  %res = call float @llvm.sin.f32(float %Val)
  ret float %res
}

define double @test_sin_f64(double %Val) nounwind {
; SDAG-X86-LABEL: test_sin_f64:
; SDAG-X86:       # %bb.0:
; SDAG-X86-NEXT:    subl $12, %esp
; SDAG-X86-NEXT:    fldl {{[0-9]+}}(%esp)
; SDAG-X86-NEXT:    fstpl (%esp)
; SDAG-X86-NEXT:    calll sin
; SDAG-X86-NEXT:    addl $12, %esp
; SDAG-X86-NEXT:    retl
;
; SDAG-X64-LABEL: test_sin_f64:
; SDAG-X64:       # %bb.0:
; SDAG-X64-NEXT:    jmp sin@PLT # TAILCALL
;
; GISEL-X86-LABEL: test_sin_f64:
; GISEL-X86:       # %bb.0:
; GISEL-X86-NEXT:    subl $12, %esp
; GISEL-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GISEL-X86-NEXT:    movl 4(%eax), %eax
; GISEL-X86-NEXT:    xorl %edx, %edx
; GISEL-X86-NEXT:    addl %esp, %edx
; GISEL-X86-NEXT:    movl %ecx, (%esp)
; GISEL-X86-NEXT:    movl %eax, 4(%edx)
; GISEL-X86-NEXT:    calll sin
; GISEL-X86-NEXT:    addl $12, %esp
; GISEL-X86-NEXT:    retl
;
; GISEL-X64-LABEL: test_sin_f64:
; GISEL-X64:       # %bb.0:
; GISEL-X64-NEXT:    pushq %rax
; GISEL-X64-NEXT:    callq sin
; GISEL-X64-NEXT:    popq %rax
; GISEL-X64-NEXT:    retq
  %res = call double @llvm.sin.f64(double %Val)
  ret double %res
}

define x86_fp80 @test_sin_f80(x86_fp80 %Val) nounwind {
; X86-LABEL: test_sin_f80:
; X86:       # %bb.0:
; X86-NEXT:    subl $12, %esp
; X86-NEXT:    fldt {{[0-9]+}}(%esp)
; X86-NEXT:    fstpt (%esp)
; X86-NEXT:    calll sinl
; X86-NEXT:    addl $12, %esp
; X86-NEXT:    retl
;
; SDAG-X64-LABEL: test_sin_f80:
; SDAG-X64:       # %bb.0:
; SDAG-X64-NEXT:    subq $24, %rsp
; SDAG-X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; SDAG-X64-NEXT:    fstpt (%rsp)
; SDAG-X64-NEXT:    callq sinl@PLT
; SDAG-X64-NEXT:    addq $24, %rsp
; SDAG-X64-NEXT:    retq
;
; GISEL-X64-LABEL: test_sin_f80:
; GISEL-X64:       # %bb.0:
; GISEL-X64-NEXT:    subq $24, %rsp
; GISEL-X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    fstpt (%rsp)
; GISEL-X64-NEXT:    callq sinl
; GISEL-X64-NEXT:    addq $24, %rsp
; GISEL-X64-NEXT:    retq
  %res = call x86_fp80 @llvm.sin.f80(x86_fp80 %Val)
  ret x86_fp80 %res
}
