; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc -mtriple=x86_64-linux-gnu -mattr=+sse,-sse2  %s -o - | FileCheck %s --check-prefixes SSE-X64
; RUN: llc -mtriple=x86_64-linux-gnu -mattr=+sse,-sse2 -fast-isel %s -o - | FileCheck %s --check-prefixes SSE-X64
; RUN: llc -mtriple=x86_64-linux-gnu -mattr=+sse,-sse2 -global-isel -global-isel-abort=1 %s -o - | FileCheck %s --check-prefixes SSE-X64-GISEL
; RUN: llc -mtriple=i686-linux-gnu -mattr=+sse,-sse2  %s -o - | FileCheck %s --check-prefixes SSE-X86
; RUN: llc -mtriple=i686-linux-gnu -mattr=+sse,-sse2 -fast-isel %s -o - | FileCheck %s --check-prefixes SSE-X86
; RUN: llc -mtriple=i686-linux-gnu -mattr=+sse,-sse2 -global-isel -global-isel-abort=1 %s -o - | FileCheck %s --check-prefixes SSE-X86-GISEL

define <8 x i32> @test_vector_v8i32() {
; SSE-X64-LABEL: test_vector_v8i32:
; SSE-X64:       # %bb.0:
; SSE-X64-NEXT:    movq %rdi, %rax
; SSE-X64-NEXT:    movabsq $3043555126665690671, %rcx # imm = 0x2A3CE143233A3E2F
; SSE-X64-NEXT:    movq %rcx, 24(%rdi)
; SSE-X64-NEXT:    movabsq $-2720818644236378031, %rcx # imm = 0xDA3DB5DBCC07E051
; SSE-X64-NEXT:    movq %rcx, 16(%rdi)
; SSE-X64-NEXT:    movabsq $3043545045377446960, %rcx # imm = 0x2A3CD817E79F7430
; SSE-X64-NEXT:    movq %rcx, 8(%rdi)
; SSE-X64-NEXT:    movabsq $-2715530310134355376, %rcx # imm = 0xDA507F9207A2AA50
; SSE-X64-NEXT:    movq %rcx, (%rdi)
; SSE-X64-NEXT:    retq
;
; SSE-X64-GISEL-LABEL: test_vector_v8i32:
; SSE-X64-GISEL:       # %bb.0:
; SSE-X64-GISEL-NEXT:    movq %rdi, %rax
; SSE-X64-GISEL-NEXT:    movl $128100944, (%rdi) # imm = 0x7A2AA50
; SSE-X64-GISEL-NEXT:    movl $-632258670, 4(%rdi) # imm = 0xDA507F92
; SSE-X64-GISEL-NEXT:    movl $-408980432, 8(%rdi) # imm = 0xE79F7430
; SSE-X64-GISEL-NEXT:    movl $708630551, 12(%rdi) # imm = 0x2A3CD817
; SSE-X64-GISEL-NEXT:    movl $-871899055, 16(%rdi) # imm = 0xCC07E051
; SSE-X64-GISEL-NEXT:    movl $-633489957, 20(%rdi) # imm = 0xDA3DB5DB
; SSE-X64-GISEL-NEXT:    movl $591019567, 24(%rdi) # imm = 0x233A3E2F
; SSE-X64-GISEL-NEXT:    movl $708632899, 28(%rdi) # imm = 0x2A3CE143
; SSE-X64-GISEL-NEXT:    retq
;
; SSE-X86-LABEL: test_vector_v8i32:
; SSE-X86:       # %bb.0:
; SSE-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SSE-X86-NEXT:    movl $708632899, 28(%eax) # imm = 0x2A3CE143
; SSE-X86-NEXT:    movl $591019567, 24(%eax) # imm = 0x233A3E2F
; SSE-X86-NEXT:    movl $-633489957, 20(%eax) # imm = 0xDA3DB5DB
; SSE-X86-NEXT:    movl $-871899055, 16(%eax) # imm = 0xCC07E051
; SSE-X86-NEXT:    movl $708630551, 12(%eax) # imm = 0x2A3CD817
; SSE-X86-NEXT:    movl $-408980432, 8(%eax) # imm = 0xE79F7430
; SSE-X86-NEXT:    movl $-632258670, 4(%eax) # imm = 0xDA507F92
; SSE-X86-NEXT:    movl $128100944, (%eax) # imm = 0x7A2AA50
; SSE-X86-NEXT:    retl $4
;
; SSE-X86-GISEL-LABEL: test_vector_v8i32:
; SSE-X86-GISEL:       # %bb.0:
; SSE-X86-GISEL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SSE-X86-GISEL-NEXT:    movl $128100944, (%eax) # imm = 0x7A2AA50
; SSE-X86-GISEL-NEXT:    movl $-632258670, 4(%eax) # imm = 0xDA507F92
; SSE-X86-GISEL-NEXT:    movl $-408980432, 8(%eax) # imm = 0xE79F7430
; SSE-X86-GISEL-NEXT:    movl $708630551, 12(%eax) # imm = 0x2A3CD817
; SSE-X86-GISEL-NEXT:    movl $-871899055, 16(%eax) # imm = 0xCC07E051
; SSE-X86-GISEL-NEXT:    movl $-633489957, 20(%eax) # imm = 0xDA3DB5DB
; SSE-X86-GISEL-NEXT:    movl $591019567, 24(%eax) # imm = 0x233A3E2F
; SSE-X86-GISEL-NEXT:    movl $708632899, 28(%eax) # imm = 0x2A3CE143
; SSE-X86-GISEL-NEXT:    retl
  ret <8 x i32> <i32 128100944, i32 3662708626, i32 3885986864, i32 708630551, i32 -871899055, i32 3661477339, i32 4885986863, i32 708632899>
}

define <4 x i32> @test_vector_v4i32() {
; SSE-X64-LABEL: test_vector_v4i32:
; SSE-X64:       # %bb.0:
; SSE-X64-NEXT:    movq %rdi, %rax
; SSE-X64-NEXT:    movabsq $3043545045377446960, %rcx # imm = 0x2A3CD817E79F7430
; SSE-X64-NEXT:    movq %rcx, 8(%rdi)
; SSE-X64-NEXT:    movabsq $-2715530310134355376, %rcx # imm = 0xDA507F9207A2AA50
; SSE-X64-NEXT:    movq %rcx, (%rdi)
; SSE-X64-NEXT:    retq
;
; SSE-X64-GISEL-LABEL: test_vector_v4i32:
; SSE-X64-GISEL:       # %bb.0:
; SSE-X64-GISEL-NEXT:    movq %rdi, %rax
; SSE-X64-GISEL-NEXT:    movaps {{.*#+}} xmm0 = [128100944,3662708626,3885986864,708630551]
; SSE-X64-GISEL-NEXT:    movaps %xmm0, (%rdi)
; SSE-X64-GISEL-NEXT:    retq
;
; SSE-X86-LABEL: test_vector_v4i32:
; SSE-X86:       # %bb.0:
; SSE-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SSE-X86-NEXT:    movl $708630551, 12(%eax) # imm = 0x2A3CD817
; SSE-X86-NEXT:    movl $-408980432, 8(%eax) # imm = 0xE79F7430
; SSE-X86-NEXT:    movl $-632258670, 4(%eax) # imm = 0xDA507F92
; SSE-X86-NEXT:    movl $128100944, (%eax) # imm = 0x7A2AA50
; SSE-X86-NEXT:    retl $4
;
; SSE-X86-GISEL-LABEL: test_vector_v4i32:
; SSE-X86-GISEL:       # %bb.0:
; SSE-X86-GISEL-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SSE-X86-GISEL-NEXT:    movaps {{.*#+}} xmm0 = [128100944,3662708626,3885986864,708630551]
; SSE-X86-GISEL-NEXT:    movaps %xmm0, (%eax)
; SSE-X86-GISEL-NEXT:    retl
  ret <4 x i32> <i32 128100944, i32 3662708626, i32 3885986864, i32 708630551>
}

define <3 x i32> @test_vector_v3i32() {
; SSE-X64-LABEL: test_vector_v3i32:
; SSE-X64:       # %bb.0:
; SSE-X64-NEXT:    movl $128100944, %eax # imm = 0x7A2AA50
; SSE-X64-NEXT:    movl $-632258670, %edx # imm = 0xDA507F92
; SSE-X64-NEXT:    movl $-408980432, %ecx # imm = 0xE79F7430
; SSE-X64-NEXT:    retq
;
; SSE-X64-GISEL-LABEL: test_vector_v3i32:
; SSE-X64-GISEL:       # %bb.0:
; SSE-X64-GISEL-NEXT:    movl $128100944, %eax # imm = 0x7A2AA50
; SSE-X64-GISEL-NEXT:    movl $-632258670, %edx # imm = 0xDA507F92
; SSE-X64-GISEL-NEXT:    movl $-408980432, %ecx # imm = 0xE79F7430
; SSE-X64-GISEL-NEXT:    retq
;
; SSE-X86-LABEL: test_vector_v3i32:
; SSE-X86:       # %bb.0:
; SSE-X86-NEXT:    movl $128100944, %eax # imm = 0x7A2AA50
; SSE-X86-NEXT:    movl $-632258670, %edx # imm = 0xDA507F92
; SSE-X86-NEXT:    movl $-408980432, %ecx # imm = 0xE79F7430
; SSE-X86-NEXT:    retl
;
; SSE-X86-GISEL-LABEL: test_vector_v3i32:
; SSE-X86-GISEL:       # %bb.0:
; SSE-X86-GISEL-NEXT:    movl $128100944, %eax # imm = 0x7A2AA50
; SSE-X86-GISEL-NEXT:    movl $-632258670, %edx # imm = 0xDA507F92
; SSE-X86-GISEL-NEXT:    movl $-408980432, %ecx # imm = 0xE79F7430
; SSE-X86-GISEL-NEXT:    retl
  ret <3 x i32> <i32 128100944, i32 3662708626, i32 3885986864>
}

