; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=i686-unknown-linux-gnu -mattr=-sse -verify-machineinstrs < %s | FileCheck %s --check-prefixes=X86,SDAG-X86
; RUN: llc -mtriple=i686-unknown-linux-gnu -mattr=-sse2 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=X86,SDAG-X86
; RUN: llc -mtriple=x86_64-unknown-linux-gnu -verify-machineinstrs < %s | FileCheck %s --check-prefixes=X64,SDAG-X64
; RUN: llc -mtriple=i686-unknown-linux-gnu   -global-isel=1 -global-isel-abort=1 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=X86,GISEL-X86
; RUN: llc -mtriple=x86_64-unknown-linux-gnu -global-isel=1 -global-isel-abort=1 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=X64,GISEL-X64

declare i32 @llvm.get.rounding()

define i32 @test_flt_rounds() nounwind {
; X86-LABEL: test_flt_rounds:
; X86:       # %bb.0:
; X86-NEXT:    subl $2, %esp
; X86-NEXT:    fnstcw (%esp)
; X86-NEXT:    movzwl (%esp), %ecx
; X86-NEXT:    shrl $9, %ecx
; X86-NEXT:    andb $6, %cl
; X86-NEXT:    movl $45, %eax
; X86-NEXT:    # kill: def $cl killed $cl killed $ecx
; X86-NEXT:    shrl %cl, %eax
; X86-NEXT:    andl $3, %eax
; X86-NEXT:    addl $2, %esp
; X86-NEXT:    retl
;
; X64-LABEL: test_flt_rounds:
; X64:       # %bb.0:
; X64-NEXT:    fnstcw -{{[0-9]+}}(%rsp)
; X64-NEXT:    movzwl -{{[0-9]+}}(%rsp), %ecx
; X64-NEXT:    shrl $9, %ecx
; X64-NEXT:    andb $6, %cl
; X64-NEXT:    movl $45, %eax
; X64-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-NEXT:    shrl %cl, %eax
; X64-NEXT:    andl $3, %eax
; X64-NEXT:    retq
  %1 = call i32 @llvm.get.rounding()
  ret i32 %1
}

; Make sure we preserve order with fesetround.
define i32 @multiple_flt_rounds() nounwind {
; SDAG-X86-LABEL: multiple_flt_rounds:
; SDAG-X86:       # %bb.0: # %entry
; SDAG-X86-NEXT:    pushl %ebx
; SDAG-X86-NEXT:    pushl %esi
; SDAG-X86-NEXT:    subl $20, %esp
; SDAG-X86-NEXT:    movl $1024, (%esp) # imm = 0x400
; SDAG-X86-NEXT:    calll fesetround
; SDAG-X86-NEXT:    fnstcw {{[0-9]+}}(%esp)
; SDAG-X86-NEXT:    movzwl {{[0-9]+}}(%esp), %ecx
; SDAG-X86-NEXT:    shrl $9, %ecx
; SDAG-X86-NEXT:    andb $6, %cl
; SDAG-X86-NEXT:    movl $45, %esi
; SDAG-X86-NEXT:    movl $45, %eax
; SDAG-X86-NEXT:    # kill: def $cl killed $cl killed $ecx
; SDAG-X86-NEXT:    shrl %cl, %eax
; SDAG-X86-NEXT:    andl $3, %eax
; SDAG-X86-NEXT:    xorl %ebx, %ebx
; SDAG-X86-NEXT:    cmpl $3, %eax
; SDAG-X86-NEXT:    setne %bl
; SDAG-X86-NEXT:    movl $0, (%esp)
; SDAG-X86-NEXT:    calll fesetround
; SDAG-X86-NEXT:    fnstcw {{[0-9]+}}(%esp)
; SDAG-X86-NEXT:    movzwl {{[0-9]+}}(%esp), %ecx
; SDAG-X86-NEXT:    shrl $9, %ecx
; SDAG-X86-NEXT:    andb $6, %cl
; SDAG-X86-NEXT:    movl $45, %eax
; SDAG-X86-NEXT:    # kill: def $cl killed $cl killed $ecx
; SDAG-X86-NEXT:    shrl %cl, %eax
; SDAG-X86-NEXT:    andl $3, %eax
; SDAG-X86-NEXT:    cmpl $1, %eax
; SDAG-X86-NEXT:    je .LBB1_2
; SDAG-X86-NEXT:  # %bb.1: # %entry
; SDAG-X86-NEXT:    incl %ebx
; SDAG-X86-NEXT:  .LBB1_2: # %entry
; SDAG-X86-NEXT:    movl $3072, (%esp) # imm = 0xC00
; SDAG-X86-NEXT:    calll fesetround
; SDAG-X86-NEXT:    fnstcw {{[0-9]+}}(%esp)
; SDAG-X86-NEXT:    movzwl {{[0-9]+}}(%esp), %ecx
; SDAG-X86-NEXT:    shrl $9, %ecx
; SDAG-X86-NEXT:    andb $6, %cl
; SDAG-X86-NEXT:    movl $45, %eax
; SDAG-X86-NEXT:    # kill: def $cl killed $cl killed $ecx
; SDAG-X86-NEXT:    shrl %cl, %eax
; SDAG-X86-NEXT:    andl $3, %eax
; SDAG-X86-NEXT:    cmpl $1, %eax
; SDAG-X86-NEXT:    sbbl $-1, %ebx
; SDAG-X86-NEXT:    movl $2048, (%esp) # imm = 0x800
; SDAG-X86-NEXT:    calll fesetround
; SDAG-X86-NEXT:    fnstcw {{[0-9]+}}(%esp)
; SDAG-X86-NEXT:    movzwl {{[0-9]+}}(%esp), %ecx
; SDAG-X86-NEXT:    shrl $9, %ecx
; SDAG-X86-NEXT:    andb $6, %cl
; SDAG-X86-NEXT:    # kill: def $cl killed $cl killed $ecx
; SDAG-X86-NEXT:    shrl %cl, %esi
; SDAG-X86-NEXT:    andl $3, %esi
; SDAG-X86-NEXT:    xorl %ecx, %ecx
; SDAG-X86-NEXT:    cmpl $2, %esi
; SDAG-X86-NEXT:    setne %cl
; SDAG-X86-NEXT:    negl %ecx
; SDAG-X86-NEXT:    xorl %eax, %eax
; SDAG-X86-NEXT:    cmpl %ecx, %ebx
; SDAG-X86-NEXT:    setne %al
; SDAG-X86-NEXT:    addl $20, %esp
; SDAG-X86-NEXT:    popl %esi
; SDAG-X86-NEXT:    popl %ebx
; SDAG-X86-NEXT:    retl
;
; SDAG-X64-LABEL: multiple_flt_rounds:
; SDAG-X64:       # %bb.0: # %entry
; SDAG-X64-NEXT:    pushq %rbp
; SDAG-X64-NEXT:    pushq %r14
; SDAG-X64-NEXT:    pushq %rbx
; SDAG-X64-NEXT:    subq $16, %rsp
; SDAG-X64-NEXT:    movl $1024, %edi # imm = 0x400
; SDAG-X64-NEXT:    callq fesetround
; SDAG-X64-NEXT:    fnstcw {{[0-9]+}}(%rsp)
; SDAG-X64-NEXT:    movzwl {{[0-9]+}}(%rsp), %ecx
; SDAG-X64-NEXT:    shrl $9, %ecx
; SDAG-X64-NEXT:    andb $6, %cl
; SDAG-X64-NEXT:    movl $45, %ebx
; SDAG-X64-NEXT:    movl $45, %eax
; SDAG-X64-NEXT:    # kill: def $cl killed $cl killed $ecx
; SDAG-X64-NEXT:    shrl %cl, %eax
; SDAG-X64-NEXT:    andl $3, %eax
; SDAG-X64-NEXT:    xorl %r14d, %r14d
; SDAG-X64-NEXT:    cmpl $3, %eax
; SDAG-X64-NEXT:    setne %r14b
; SDAG-X64-NEXT:    xorl %edi, %edi
; SDAG-X64-NEXT:    callq fesetround
; SDAG-X64-NEXT:    fnstcw {{[0-9]+}}(%rsp)
; SDAG-X64-NEXT:    movzwl {{[0-9]+}}(%rsp), %ecx
; SDAG-X64-NEXT:    shrl $9, %ecx
; SDAG-X64-NEXT:    andb $6, %cl
; SDAG-X64-NEXT:    movl $45, %eax
; SDAG-X64-NEXT:    # kill: def $cl killed $cl killed $ecx
; SDAG-X64-NEXT:    shrl %cl, %eax
; SDAG-X64-NEXT:    andl $3, %eax
; SDAG-X64-NEXT:    leal 1(%r14), %ebp
; SDAG-X64-NEXT:    cmpl $1, %eax
; SDAG-X64-NEXT:    cmovel %r14d, %ebp
; SDAG-X64-NEXT:    movl $3072, %edi # imm = 0xC00
; SDAG-X64-NEXT:    callq fesetround
; SDAG-X64-NEXT:    fnstcw {{[0-9]+}}(%rsp)
; SDAG-X64-NEXT:    movzwl {{[0-9]+}}(%rsp), %ecx
; SDAG-X64-NEXT:    shrl $9, %ecx
; SDAG-X64-NEXT:    andb $6, %cl
; SDAG-X64-NEXT:    movl $45, %eax
; SDAG-X64-NEXT:    # kill: def $cl killed $cl killed $ecx
; SDAG-X64-NEXT:    shrl %cl, %eax
; SDAG-X64-NEXT:    andl $3, %eax
; SDAG-X64-NEXT:    cmpl $1, %eax
; SDAG-X64-NEXT:    sbbl $-1, %ebp
; SDAG-X64-NEXT:    movl $2048, %edi # imm = 0x800
; SDAG-X64-NEXT:    callq fesetround
; SDAG-X64-NEXT:    fnstcw {{[0-9]+}}(%rsp)
; SDAG-X64-NEXT:    movzwl {{[0-9]+}}(%rsp), %ecx
; SDAG-X64-NEXT:    shrl $9, %ecx
; SDAG-X64-NEXT:    andb $6, %cl
; SDAG-X64-NEXT:    # kill: def $cl killed $cl killed $ecx
; SDAG-X64-NEXT:    shrl %cl, %ebx
; SDAG-X64-NEXT:    andl $3, %ebx
; SDAG-X64-NEXT:    xorl %ecx, %ecx
; SDAG-X64-NEXT:    cmpl $2, %ebx
; SDAG-X64-NEXT:    setne %cl
; SDAG-X64-NEXT:    negl %ecx
; SDAG-X64-NEXT:    xorl %eax, %eax
; SDAG-X64-NEXT:    cmpl %ecx, %ebp
; SDAG-X64-NEXT:    setne %al
; SDAG-X64-NEXT:    addq $16, %rsp
; SDAG-X64-NEXT:    popq %rbx
; SDAG-X64-NEXT:    popq %r14
; SDAG-X64-NEXT:    popq %rbp
; SDAG-X64-NEXT:    retq
;
; GISEL-X86-LABEL: multiple_flt_rounds:
; GISEL-X86:       # %bb.0: # %entry
; GISEL-X86-NEXT:    pushl %ebp
; GISEL-X86-NEXT:    pushl %ebx
; GISEL-X86-NEXT:    pushl %edi
; GISEL-X86-NEXT:    pushl %esi
; GISEL-X86-NEXT:    subl $12, %esp
; GISEL-X86-NEXT:    movl $1, %ebp
; GISEL-X86-NEXT:    movl $1024, (%esp) # imm = 0x400
; GISEL-X86-NEXT:    calll fesetround
; GISEL-X86-NEXT:    fnstcw {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    movzwl {{[0-9]+}}(%esp), %ecx
; GISEL-X86-NEXT:    shrl $9, %ecx
; GISEL-X86-NEXT:    andb $6, %cl
; GISEL-X86-NEXT:    movl $45, %edi
; GISEL-X86-NEXT:    movl $45, %eax
; GISEL-X86-NEXT:    # kill: def $cl killed $cl killed $ecx
; GISEL-X86-NEXT:    shrl %cl, %eax
; GISEL-X86-NEXT:    andl $3, %eax
; GISEL-X86-NEXT:    xorl %ebx, %ebx
; GISEL-X86-NEXT:    cmpl $3, %eax
; GISEL-X86-NEXT:    setne %bl
; GISEL-X86-NEXT:    andl $1, %ebx
; GISEL-X86-NEXT:    movl $0, (%esp)
; GISEL-X86-NEXT:    calll fesetround
; GISEL-X86-NEXT:    fnstcw {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    movzwl {{[0-9]+}}(%esp), %ecx
; GISEL-X86-NEXT:    shrl $9, %ecx
; GISEL-X86-NEXT:    andb $6, %cl
; GISEL-X86-NEXT:    movl $45, %edx
; GISEL-X86-NEXT:    # kill: def $cl killed $cl killed $ecx
; GISEL-X86-NEXT:    shrl %cl, %edx
; GISEL-X86-NEXT:    andl $3, %edx
; GISEL-X86-NEXT:    xorl %eax, %eax
; GISEL-X86-NEXT:    cmpl $1, %edx
; GISEL-X86-NEXT:    sete %cl
; GISEL-X86-NEXT:    testl %ebx, %ebx
; GISEL-X86-NEXT:    je .LBB1_2
; GISEL-X86-NEXT:  # %bb.1: # %entry
; GISEL-X86-NEXT:    movl $2, %ebp
; GISEL-X86-NEXT:  .LBB1_2: # %entry
; GISEL-X86-NEXT:    xorl %esi, %esi
; GISEL-X86-NEXT:    movb %cl, %al
; GISEL-X86-NEXT:    andl $1, %eax
; GISEL-X86-NEXT:    je .LBB1_4
; GISEL-X86-NEXT:  # %bb.3: # %entry
; GISEL-X86-NEXT:    movl %ebx, %ebp
; GISEL-X86-NEXT:  .LBB1_4: # %entry
; GISEL-X86-NEXT:    movl $3072, (%esp) # imm = 0xC00
; GISEL-X86-NEXT:    calll fesetround
; GISEL-X86-NEXT:    fnstcw {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    movzwl {{[0-9]+}}(%esp), %ecx
; GISEL-X86-NEXT:    shrl $9, %ecx
; GISEL-X86-NEXT:    andb $6, %cl
; GISEL-X86-NEXT:    movl $45, %eax
; GISEL-X86-NEXT:    # kill: def $cl killed $cl killed $ecx
; GISEL-X86-NEXT:    shrl %cl, %eax
; GISEL-X86-NEXT:    andl $3, %eax
; GISEL-X86-NEXT:    xorl %ebx, %ebx
; GISEL-X86-NEXT:    cmpl %esi, %eax
; GISEL-X86-NEXT:    setne %bl
; GISEL-X86-NEXT:    andl $1, %ebx
; GISEL-X86-NEXT:    addl %ebp, %ebx
; GISEL-X86-NEXT:    movl $2048, (%esp) # imm = 0x800
; GISEL-X86-NEXT:    calll fesetround
; GISEL-X86-NEXT:    fnstcw {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    movzwl {{[0-9]+}}(%esp), %ecx
; GISEL-X86-NEXT:    shrl $9, %ecx
; GISEL-X86-NEXT:    andb $6, %cl
; GISEL-X86-NEXT:    # kill: def $cl killed $cl killed $ecx
; GISEL-X86-NEXT:    shrl %cl, %edi
; GISEL-X86-NEXT:    andl $3, %edi
; GISEL-X86-NEXT:    xorl %ecx, %ecx
; GISEL-X86-NEXT:    movl $2, %eax
; GISEL-X86-NEXT:    cmpl %eax, %edi
; GISEL-X86-NEXT:    setne %cl
; GISEL-X86-NEXT:    shll $31, %ecx
; GISEL-X86-NEXT:    sarl $31, %ecx
; GISEL-X86-NEXT:    xorl %eax, %eax
; GISEL-X86-NEXT:    cmpl %ecx, %ebx
; GISEL-X86-NEXT:    setne %al
; GISEL-X86-NEXT:    andl $1, %eax
; GISEL-X86-NEXT:    addl $12, %esp
; GISEL-X86-NEXT:    popl %esi
; GISEL-X86-NEXT:    popl %edi
; GISEL-X86-NEXT:    popl %ebx
; GISEL-X86-NEXT:    popl %ebp
; GISEL-X86-NEXT:    retl
;
; GISEL-X64-LABEL: multiple_flt_rounds:
; GISEL-X64:       # %bb.0: # %entry
; GISEL-X64-NEXT:    pushq %rbp
; GISEL-X64-NEXT:    pushq %r15
; GISEL-X64-NEXT:    pushq %r14
; GISEL-X64-NEXT:    pushq %rbx
; GISEL-X64-NEXT:    pushq %rax
; GISEL-X64-NEXT:    movl $1, %r14d
; GISEL-X64-NEXT:    movl $2, %ebp
; GISEL-X64-NEXT:    movl $1024, %edi # imm = 0x400
; GISEL-X64-NEXT:    callq fesetround
; GISEL-X64-NEXT:    fnstcw (%rsp)
; GISEL-X64-NEXT:    movzwl (%rsp), %ecx
; GISEL-X64-NEXT:    shrl $9, %ecx
; GISEL-X64-NEXT:    andb $6, %cl
; GISEL-X64-NEXT:    movl $45, %ebx
; GISEL-X64-NEXT:    movl $45, %eax
; GISEL-X64-NEXT:    # kill: def $cl killed $cl killed $ecx
; GISEL-X64-NEXT:    shrl %cl, %eax
; GISEL-X64-NEXT:    andl $3, %eax
; GISEL-X64-NEXT:    xorl %r15d, %r15d
; GISEL-X64-NEXT:    cmpl $3, %eax
; GISEL-X64-NEXT:    setne %r15b
; GISEL-X64-NEXT:    andl $1, %r15d
; GISEL-X64-NEXT:    xorl %edi, %edi
; GISEL-X64-NEXT:    callq fesetround
; GISEL-X64-NEXT:    fnstcw {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    movzwl {{[0-9]+}}(%rsp), %ecx
; GISEL-X64-NEXT:    shrl $9, %ecx
; GISEL-X64-NEXT:    andb $6, %cl
; GISEL-X64-NEXT:    movl $45, %eax
; GISEL-X64-NEXT:    # kill: def $cl killed $cl killed $ecx
; GISEL-X64-NEXT:    shrl %cl, %eax
; GISEL-X64-NEXT:    andl $3, %eax
; GISEL-X64-NEXT:    xorl %ecx, %ecx
; GISEL-X64-NEXT:    cmpl $1, %eax
; GISEL-X64-NEXT:    sete %cl
; GISEL-X64-NEXT:    testl %r15d, %r15d
; GISEL-X64-NEXT:    cmovel %r14d, %ebp
; GISEL-X64-NEXT:    andl $1, %ecx
; GISEL-X64-NEXT:    cmovnel %r15d, %ebp
; GISEL-X64-NEXT:    movl $3072, %edi # imm = 0xC00
; GISEL-X64-NEXT:    callq fesetround
; GISEL-X64-NEXT:    fnstcw {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    movzwl {{[0-9]+}}(%rsp), %ecx
; GISEL-X64-NEXT:    shrl $9, %ecx
; GISEL-X64-NEXT:    andb $6, %cl
; GISEL-X64-NEXT:    movl $45, %eax
; GISEL-X64-NEXT:    # kill: def $cl killed $cl killed $ecx
; GISEL-X64-NEXT:    shrl %cl, %eax
; GISEL-X64-NEXT:    andl $3, %eax
; GISEL-X64-NEXT:    xorl %r14d, %r14d
; GISEL-X64-NEXT:    cmpl $0, %eax
; GISEL-X64-NEXT:    setne %r14b
; GISEL-X64-NEXT:    andl $1, %r14d
; GISEL-X64-NEXT:    addl %ebp, %r14d
; GISEL-X64-NEXT:    movl $2048, %edi # imm = 0x800
; GISEL-X64-NEXT:    callq fesetround
; GISEL-X64-NEXT:    fnstcw {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    movzwl {{[0-9]+}}(%rsp), %ecx
; GISEL-X64-NEXT:    shrl $9, %ecx
; GISEL-X64-NEXT:    andb $6, %cl
; GISEL-X64-NEXT:    # kill: def $cl killed $cl killed $ecx
; GISEL-X64-NEXT:    shrl %cl, %ebx
; GISEL-X64-NEXT:    andl $3, %ebx
; GISEL-X64-NEXT:    xorl %ecx, %ecx
; GISEL-X64-NEXT:    cmpl $2, %ebx
; GISEL-X64-NEXT:    setne %cl
; GISEL-X64-NEXT:    shll $31, %ecx
; GISEL-X64-NEXT:    sarl $31, %ecx
; GISEL-X64-NEXT:    xorl %eax, %eax
; GISEL-X64-NEXT:    cmpl %ecx, %r14d
; GISEL-X64-NEXT:    setne %al
; GISEL-X64-NEXT:    andl $1, %eax
; GISEL-X64-NEXT:    addq $8, %rsp
; GISEL-X64-NEXT:    popq %rbx
; GISEL-X64-NEXT:    popq %r14
; GISEL-X64-NEXT:    popq %r15
; GISEL-X64-NEXT:    popq %rbp
; GISEL-X64-NEXT:    retq
entry:
  %call = tail call i32 @fesetround(i32 1024)
  %0 = tail call i32 @llvm.get.rounding()
  %cmp = icmp ne i32 %0, 3
  %spec.select = zext i1 %cmp to i32
  %call1 = tail call i32 @fesetround(i32 0)
  %1 = tail call i32 @llvm.get.rounding()
  %cmp2 = icmp eq i32 %1, 1
  %inc4 = select i1 %cmp, i32 2, i32 1
  %errs.1 = select i1 %cmp2, i32 %spec.select, i32 %inc4
  %call6 = tail call i32 @fesetround(i32 3072)
  %2 = tail call i32 @llvm.get.rounding()
  %cmp7 = icmp ne i32 %2, 0
  %inc9 = zext i1 %cmp7 to i32
  %spec.select22 = add nuw nsw i32 %errs.1, %inc9
  %call11 = tail call i32 @fesetround(i32 2048)
  %3 = tail call i32 @llvm.get.rounding()
  %cmp12 = icmp ne i32 %3, 2
  %inc14.neg = sext i1 %cmp12 to i32
  %cmp16 = icmp ne i32 %spec.select22, %inc14.neg
  %cond = zext i1 %cmp16 to i32
  ret i32 %cond
}

; Function Attrs: nounwind
declare dso_local i32 @fesetround(i32) local_unnamed_addr #1
