; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; Test reduction of vector comparisons
;
; RUN: llc < %s -mtriple=s390x-linux-gnu -mcpu=z16 | FileCheck %s

define zeroext i1 @vec_all_eq_vsc(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: vec_all_eq_vsc:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp ne <16 x i8> %a, %b
  %1 = bitcast <16 x i1> %0 to i16
  %2 = icmp eq i16 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_eq_vsc(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: vec_any_eq_vsc:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp eq <16 x i8> %a, %b
  %0 = bitcast <16 x i1> %cmp to i16
  %1 = icmp ne i16 %0, 0
  ret i1 %1
}

define zeroext i1 @not_vec_all_eq_vsc(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: not_vec_all_eq_vsc:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp ne <16 x i8> %a, %b
  %1 = bitcast <16 x i1> %0 to i16
  %2 = icmp ne i16 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_eq_vsc(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: not_vec_any_eq_vsc:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp eq <16 x i8> %a, %b
  %0 = bitcast <16 x i1> %cmp to i16
  %.not = icmp eq i16 %0, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_eq_vuc(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: vec_all_eq_vuc:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp ne <16 x i8> %a, %b
  %1 = bitcast <16 x i1> %0 to i16
  %2 = icmp eq i16 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_eq_vuc(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: vec_any_eq_vuc:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp eq <16 x i8> %a, %b
  %0 = bitcast <16 x i1> %cmp to i16
  %1 = icmp ne i16 %0, 0
  ret i1 %1
}

define zeroext i1 @not_vec_all_eq_vuc(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: not_vec_all_eq_vuc:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp ne <16 x i8> %a, %b
  %1 = bitcast <16 x i1> %0 to i16
  %2 = icmp ne i16 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_eq_vuc(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: not_vec_any_eq_vuc:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp eq <16 x i8> %a, %b
  %0 = bitcast <16 x i1> %cmp to i16
  %.not = icmp eq i16 %0, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_eq_vss(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: vec_all_eq_vss:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqhs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp ne <8 x i16> %a, %b
  %1 = bitcast <8 x i1> %0 to i8
  %2 = icmp eq i8 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_eq_vss(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: vec_any_eq_vss:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqhs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp eq <8 x i16> %a, %b
  %0 = bitcast <8 x i1> %cmp to i8
  %1 = icmp ne i8 %0, 0
  ret i1 %1
}

define zeroext i1 @not_vec_all_eq_vss(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: not_vec_all_eq_vss:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqhs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp ne <8 x i16> %a, %b
  %1 = bitcast <8 x i1> %0 to i8
  %2 = icmp ne i8 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_eq_vss(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: not_vec_any_eq_vss:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqhs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp eq <8 x i16> %a, %b
  %0 = bitcast <8 x i1> %cmp to i8
  %.not = icmp eq i8 %0, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_eq_vus(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: vec_all_eq_vus:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqhs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp ne <8 x i16> %a, %b
  %1 = bitcast <8 x i1> %0 to i8
  %2 = icmp eq i8 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_eq_vus(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: vec_any_eq_vus:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqhs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp eq <8 x i16> %a, %b
  %0 = bitcast <8 x i1> %cmp to i8
  %1 = icmp ne i8 %0, 0
  ret i1 %1
}

define zeroext i1 @not_vec_all_eq_vus(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: not_vec_all_eq_vus:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqhs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp ne <8 x i16> %a, %b
  %1 = bitcast <8 x i1> %0 to i8
  %2 = icmp ne i8 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_eq_vus(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: not_vec_any_eq_vus:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqhs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp eq <8 x i16> %a, %b
  %0 = bitcast <8 x i1> %cmp to i8
  %.not = icmp eq i8 %0, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_eq_vsi(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: vec_all_eq_vsi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqfs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp ne <4 x i32> %a, %b
  %1 = bitcast <4 x i1> %0 to i4
  %2 = icmp eq i4 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_eq_vsi(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: vec_any_eq_vsi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqfs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp eq <4 x i32> %a, %b
  %0 = bitcast <4 x i1> %cmp to i4
  %1 = icmp ne i4 %0, 0
  ret i1 %1
}

define zeroext i1 @not_vec_all_eq_vsi(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: not_vec_all_eq_vsi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqfs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp ne <4 x i32> %a, %b
  %1 = bitcast <4 x i1> %0 to i4
  %2 = icmp ne i4 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_eq_vsi(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: not_vec_any_eq_vsi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqfs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp eq <4 x i32> %a, %b
  %0 = bitcast <4 x i1> %cmp to i4
  %.not = icmp eq i4 %0, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_eq_vui(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: vec_all_eq_vui:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqfs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp ne <4 x i32> %a, %b
  %1 = bitcast <4 x i1> %0 to i4
  %2 = icmp eq i4 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_eq_vui(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: vec_any_eq_vui:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqfs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp eq <4 x i32> %a, %b
  %0 = bitcast <4 x i1> %cmp to i4
  %1 = icmp ne i4 %0, 0
  ret i1 %1
}

define zeroext i1 @not_vec_all_eq_vui(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: not_vec_all_eq_vui:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqfs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp ne <4 x i32> %a, %b
  %1 = bitcast <4 x i1> %0 to i4
  %2 = icmp ne i4 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_eq_vui(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: not_vec_any_eq_vui:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqfs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp eq <4 x i32> %a, %b
  %0 = bitcast <4 x i1> %cmp to i4
  %.not = icmp eq i4 %0, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_eq_vsl(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: vec_all_eq_vsl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqgs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp ne <2 x i64> %a, %b
  %1 = bitcast <2 x i1> %0 to i2
  %2 = icmp eq i2 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_eq_vsl(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: vec_any_eq_vsl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqgs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp eq <2 x i64> %a, %b
  %0 = bitcast <2 x i1> %cmp to i2
  %1 = icmp ne i2 %0, 0
  ret i1 %1
}

define zeroext i1 @not_vec_all_eq_vsl(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: not_vec_all_eq_vsl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqgs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp ne <2 x i64> %a, %b
  %1 = bitcast <2 x i1> %0 to i2
  %2 = icmp ne i2 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_eq_vsl(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: not_vec_any_eq_vsl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqgs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp eq <2 x i64> %a, %b
  %0 = bitcast <2 x i1> %cmp to i2
  %.not = icmp eq i2 %0, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_eq_vul(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: vec_all_eq_vul:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqgs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp ne <2 x i64> %a, %b
  %1 = bitcast <2 x i1> %0 to i2
  %2 = icmp eq i2 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_eq_vul(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: vec_any_eq_vul:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqgs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp eq <2 x i64> %a, %b
  %0 = bitcast <2 x i1> %cmp to i2
  %1 = icmp ne i2 %0, 0
  ret i1 %1
}

define zeroext i1 @not_vec_all_eq_vul(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: not_vec_all_eq_vul:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqgs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp ne <2 x i64> %a, %b
  %1 = bitcast <2 x i1> %0 to i2
  %2 = icmp ne i2 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_eq_vul(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: not_vec_any_eq_vul:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqgs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp eq <2 x i64> %a, %b
  %0 = bitcast <2 x i1> %cmp to i2
  %.not = icmp eq i2 %0, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_eq_vf(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: vec_all_eq_vf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfcesbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = fcmp une <4 x float> %a, %b
  %1 = bitcast <4 x i1> %0 to i4
  %2 = icmp eq i4 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_eq_vf(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: vec_any_eq_vf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfcesbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = fcmp oeq <4 x float> %a, %b
  %0 = bitcast <4 x i1> %cmp to i4
  %1 = icmp ne i4 %0, 0
  ret i1 %1
}

define zeroext i1 @not_vec_all_eq_vf(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: not_vec_all_eq_vf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfcesbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = fcmp une <4 x float> %a, %b
  %1 = bitcast <4 x i1> %0 to i4
  %2 = icmp ne i4 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_eq_vf(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: not_vec_any_eq_vf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfcesbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = fcmp oeq <4 x float> %a, %b
  %0 = bitcast <4 x i1> %cmp to i4
  %.not = icmp eq i4 %0, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_eq_vd(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: vec_all_eq_vd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfcedbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = fcmp une <2 x double> %a, %b
  %1 = bitcast <2 x i1> %0 to i2
  %2 = icmp eq i2 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_eq_vd(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: vec_any_eq_vd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfcedbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = fcmp oeq <2 x double> %a, %b
  %0 = bitcast <2 x i1> %cmp to i2
  %1 = icmp ne i2 %0, 0
  ret i1 %1
}

define zeroext i1 @not_vec_all_eq_vd(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: not_vec_all_eq_vd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfcedbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = fcmp une <2 x double> %a, %b
  %1 = bitcast <2 x i1> %0 to i2
  %2 = icmp ne i2 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_eq_vd(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: not_vec_any_eq_vd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfcedbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = fcmp oeq <2 x double> %a, %b
  %0 = bitcast <2 x i1> %cmp to i2
  %.not = icmp eq i2 %0, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_ne_vsc(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: vec_all_ne_vsc:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp eq <16 x i8> %a, %b
  %1 = bitcast <16 x i1> %0 to i16
  %2 = icmp eq i16 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_ne_vsc(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: vec_any_ne_vsc:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp ne <16 x i8> %a, %b
  %0 = bitcast <16 x i1> %cmp to i16
  %1 = icmp ne i16 %0, 0
  ret i1 %1
}

define zeroext i1 @not_vec_all_ne_vsc(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: not_vec_all_ne_vsc:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp eq <16 x i8> %a, %b
  %1 = bitcast <16 x i1> %0 to i16
  %2 = icmp ne i16 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_ne_vsc(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: not_vec_any_ne_vsc:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp ne <16 x i8> %a, %b
  %0 = bitcast <16 x i1> %cmp to i16
  %.not = icmp eq i16 %0, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_ne_vuc(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: vec_all_ne_vuc:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp eq <16 x i8> %a, %b
  %1 = bitcast <16 x i1> %0 to i16
  %2 = icmp eq i16 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_ne_vuc(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: vec_any_ne_vuc:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp ne <16 x i8> %a, %b
  %0 = bitcast <16 x i1> %cmp to i16
  %1 = icmp ne i16 %0, 0
  ret i1 %1
}

define zeroext i1 @not_vec_all_ne_vuc(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: not_vec_all_ne_vuc:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp eq <16 x i8> %a, %b
  %1 = bitcast <16 x i1> %0 to i16
  %2 = icmp ne i16 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_ne_vuc(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: not_vec_any_ne_vuc:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp ne <16 x i8> %a, %b
  %0 = bitcast <16 x i1> %cmp to i16
  %.not = icmp eq i16 %0, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_ne_vss(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: vec_all_ne_vss:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqhs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp eq <8 x i16> %a, %b
  %1 = bitcast <8 x i1> %0 to i8
  %2 = icmp eq i8 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_ne_vss(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: vec_any_ne_vss:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqhs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp ne <8 x i16> %a, %b
  %0 = bitcast <8 x i1> %cmp to i8
  %1 = icmp ne i8 %0, 0
  ret i1 %1
}

define zeroext i1 @not_vec_all_ne_vss(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: not_vec_all_ne_vss:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqhs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp eq <8 x i16> %a, %b
  %1 = bitcast <8 x i1> %0 to i8
  %2 = icmp ne i8 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_ne_vss(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: not_vec_any_ne_vss:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqhs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp ne <8 x i16> %a, %b
  %0 = bitcast <8 x i1> %cmp to i8
  %.not = icmp eq i8 %0, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_ne_vus(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: vec_all_ne_vus:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqhs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp eq <8 x i16> %a, %b
  %1 = bitcast <8 x i1> %0 to i8
  %2 = icmp eq i8 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_ne_vus(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: vec_any_ne_vus:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqhs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp ne <8 x i16> %a, %b
  %0 = bitcast <8 x i1> %cmp to i8
  %1 = icmp ne i8 %0, 0
  ret i1 %1
}

define zeroext i1 @not_vec_all_ne_vus(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: not_vec_all_ne_vus:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqhs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp eq <8 x i16> %a, %b
  %1 = bitcast <8 x i1> %0 to i8
  %2 = icmp ne i8 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_ne_vus(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: not_vec_any_ne_vus:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqhs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp ne <8 x i16> %a, %b
  %0 = bitcast <8 x i1> %cmp to i8
  %.not = icmp eq i8 %0, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_ne_vsi(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: vec_all_ne_vsi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqfs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp eq <4 x i32> %a, %b
  %1 = bitcast <4 x i1> %0 to i4
  %2 = icmp eq i4 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_ne_vsi(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: vec_any_ne_vsi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqfs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp ne <4 x i32> %a, %b
  %0 = bitcast <4 x i1> %cmp to i4
  %1 = icmp ne i4 %0, 0
  ret i1 %1
}

define zeroext i1 @not_vec_all_ne_vsi(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: not_vec_all_ne_vsi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqfs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp eq <4 x i32> %a, %b
  %1 = bitcast <4 x i1> %0 to i4
  %2 = icmp ne i4 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_ne_vsi(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: not_vec_any_ne_vsi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqfs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp ne <4 x i32> %a, %b
  %0 = bitcast <4 x i1> %cmp to i4
  %.not = icmp eq i4 %0, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_ne_vui(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: vec_all_ne_vui:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqfs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp eq <4 x i32> %a, %b
  %1 = bitcast <4 x i1> %0 to i4
  %2 = icmp eq i4 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_ne_vui(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: vec_any_ne_vui:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqfs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp ne <4 x i32> %a, %b
  %0 = bitcast <4 x i1> %cmp to i4
  %1 = icmp ne i4 %0, 0
  ret i1 %1
}

define zeroext i1 @not_vec_all_ne_vui(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: not_vec_all_ne_vui:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqfs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp eq <4 x i32> %a, %b
  %1 = bitcast <4 x i1> %0 to i4
  %2 = icmp ne i4 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_ne_vui(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: not_vec_any_ne_vui:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqfs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp ne <4 x i32> %a, %b
  %0 = bitcast <4 x i1> %cmp to i4
  %.not = icmp eq i4 %0, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_ne_vsl(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: vec_all_ne_vsl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqgs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp eq <2 x i64> %a, %b
  %1 = bitcast <2 x i1> %0 to i2
  %2 = icmp eq i2 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_ne_vsl(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: vec_any_ne_vsl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqgs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp ne <2 x i64> %a, %b
  %0 = bitcast <2 x i1> %cmp to i2
  %1 = icmp ne i2 %0, 0
  ret i1 %1
}

define zeroext i1 @not_vec_all_ne_vsl(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: not_vec_all_ne_vsl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqgs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp eq <2 x i64> %a, %b
  %1 = bitcast <2 x i1> %0 to i2
  %2 = icmp ne i2 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_ne_vsl(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: not_vec_any_ne_vsl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqgs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp ne <2 x i64> %a, %b
  %0 = bitcast <2 x i1> %cmp to i2
  %.not = icmp eq i2 %0, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_ne_vul(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: vec_all_ne_vul:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqgs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp eq <2 x i64> %a, %b
  %1 = bitcast <2 x i1> %0 to i2
  %2 = icmp eq i2 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_ne_vul(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: vec_any_ne_vul:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqgs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp ne <2 x i64> %a, %b
  %0 = bitcast <2 x i1> %cmp to i2
  %1 = icmp ne i2 %0, 0
  ret i1 %1
}

define zeroext i1 @not_vec_all_ne_vul(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: not_vec_all_ne_vul:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqgs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp eq <2 x i64> %a, %b
  %1 = bitcast <2 x i1> %0 to i2
  %2 = icmp ne i2 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_ne_vul(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: not_vec_any_ne_vul:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vceqgs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp ne <2 x i64> %a, %b
  %0 = bitcast <2 x i1> %cmp to i2
  %.not = icmp eq i2 %0, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_ne_vf(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: vec_all_ne_vf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfcesbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = fcmp oeq <4 x float> %a, %b
  %1 = bitcast <4 x i1> %0 to i4
  %2 = icmp eq i4 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_ne_vf(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: vec_any_ne_vf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfcesbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = fcmp une <4 x float> %a, %b
  %0 = bitcast <4 x i1> %cmp to i4
  %1 = icmp ne i4 %0, 0
  ret i1 %1
}

define zeroext i1 @not_vec_all_ne_vf(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: not_vec_all_ne_vf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfcesbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = fcmp oeq <4 x float> %a, %b
  %1 = bitcast <4 x i1> %0 to i4
  %2 = icmp ne i4 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_ne_vf(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: not_vec_any_ne_vf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfcesbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = fcmp une <4 x float> %a, %b
  %0 = bitcast <4 x i1> %cmp to i4
  %.not = icmp eq i4 %0, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_ne_vd(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: vec_all_ne_vd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfcedbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = fcmp oeq <2 x double> %a, %b
  %1 = bitcast <2 x i1> %0 to i2
  %2 = icmp eq i2 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_ne_vd(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: vec_any_ne_vd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfcedbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = fcmp une <2 x double> %a, %b
  %0 = bitcast <2 x i1> %cmp to i2
  %1 = icmp ne i2 %0, 0
  ret i1 %1
}

define zeroext i1 @not_vec_all_ne_vd(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: not_vec_all_ne_vd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfcedbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = fcmp oeq <2 x double> %a, %b
  %1 = bitcast <2 x i1> %0 to i2
  %2 = icmp ne i2 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_ne_vd(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: not_vec_any_ne_vd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfcedbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = fcmp une <2 x double> %a, %b
  %0 = bitcast <2 x i1> %cmp to i2
  %.not = icmp eq i2 %0, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_lt_vsc(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: vec_all_lt_vsc:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchbs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp sge <16 x i8> %a, %b
  %1 = bitcast <16 x i1> %0 to i16
  %2 = icmp eq i16 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_lt_vsc(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: vec_any_lt_vsc:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchbs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp slt <16 x i8> %a, %b
  %0 = bitcast <16 x i1> %cmp to i16
  %1 = icmp ne i16 %0, 0
  ret i1 %1
}

define zeroext i1 @not_vec_all_lt_vsc(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: not_vec_all_lt_vsc:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchbs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp sge <16 x i8> %a, %b
  %1 = bitcast <16 x i1> %0 to i16
  %2 = icmp ne i16 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_lt_vsc(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: not_vec_any_lt_vsc:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchbs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp slt <16 x i8> %a, %b
  %0 = bitcast <16 x i1> %cmp to i16
  %.not = icmp eq i16 %0, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_lt_vuc(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: vec_all_lt_vuc:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlbs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp uge <16 x i8> %a, %b
  %1 = bitcast <16 x i1> %0 to i16
  %2 = icmp eq i16 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_lt_vuc(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: vec_any_lt_vuc:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlbs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp ult <16 x i8> %a, %b
  %0 = bitcast <16 x i1> %cmp to i16
  %1 = icmp ne i16 %0, 0
  ret i1 %1
}

define zeroext i1 @not_vec_all_lt_vuc(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: not_vec_all_lt_vuc:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlbs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp uge <16 x i8> %a, %b
  %1 = bitcast <16 x i1> %0 to i16
  %2 = icmp ne i16 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_lt_vuc(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: not_vec_any_lt_vuc:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlbs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp ult <16 x i8> %a, %b
  %0 = bitcast <16 x i1> %cmp to i16
  %.not = icmp eq i16 %0, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_lt_vss(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: vec_all_lt_vss:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchhs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp sge <8 x i16> %a, %b
  %1 = bitcast <8 x i1> %0 to i8
  %2 = icmp eq i8 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_lt_vss(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: vec_any_lt_vss:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchhs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp slt <8 x i16> %a, %b
  %0 = bitcast <8 x i1> %cmp to i8
  %1 = icmp ne i8 %0, 0
  ret i1 %1
}

define zeroext i1 @not_vec_all_lt_vss(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: not_vec_all_lt_vss:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchhs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp sge <8 x i16> %a, %b
  %1 = bitcast <8 x i1> %0 to i8
  %2 = icmp ne i8 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_lt_vss(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: not_vec_any_lt_vss:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchhs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp slt <8 x i16> %a, %b
  %0 = bitcast <8 x i1> %cmp to i8
  %.not = icmp eq i8 %0, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_lt_vus(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: vec_all_lt_vus:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlhs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp uge <8 x i16> %a, %b
  %1 = bitcast <8 x i1> %0 to i8
  %2 = icmp eq i8 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_lt_vus(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: vec_any_lt_vus:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlhs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp ult <8 x i16> %a, %b
  %0 = bitcast <8 x i1> %cmp to i8
  %1 = icmp ne i8 %0, 0
  ret i1 %1
}

define zeroext i1 @not_vec_all_lt_vus(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: not_vec_all_lt_vus:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlhs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp uge <8 x i16> %a, %b
  %1 = bitcast <8 x i1> %0 to i8
  %2 = icmp ne i8 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_lt_vus(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: not_vec_any_lt_vus:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlhs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp ult <8 x i16> %a, %b
  %0 = bitcast <8 x i1> %cmp to i8
  %.not = icmp eq i8 %0, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_lt_vsi(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: vec_all_lt_vsi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchfs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp sge <4 x i32> %a, %b
  %1 = bitcast <4 x i1> %0 to i4
  %2 = icmp eq i4 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_lt_vsi(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: vec_any_lt_vsi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchfs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp slt <4 x i32> %a, %b
  %0 = bitcast <4 x i1> %cmp to i4
  %1 = icmp ne i4 %0, 0
  ret i1 %1
}

define zeroext i1 @not_vec_all_lt_vsi(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: not_vec_all_lt_vsi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchfs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp sge <4 x i32> %a, %b
  %1 = bitcast <4 x i1> %0 to i4
  %2 = icmp ne i4 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_lt_vsi(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: not_vec_any_lt_vsi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchfs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp slt <4 x i32> %a, %b
  %0 = bitcast <4 x i1> %cmp to i4
  %.not = icmp eq i4 %0, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_lt_vui(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: vec_all_lt_vui:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlfs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp uge <4 x i32> %a, %b
  %1 = bitcast <4 x i1> %0 to i4
  %2 = icmp eq i4 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_lt_vui(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: vec_any_lt_vui:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlfs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp ult <4 x i32> %a, %b
  %0 = bitcast <4 x i1> %cmp to i4
  %1 = icmp ne i4 %0, 0
  ret i1 %1
}

define zeroext i1 @not_vec_all_lt_vui(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: not_vec_all_lt_vui:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlfs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp uge <4 x i32> %a, %b
  %1 = bitcast <4 x i1> %0 to i4
  %2 = icmp ne i4 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_lt_vui(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: not_vec_any_lt_vui:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlfs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp ult <4 x i32> %a, %b
  %0 = bitcast <4 x i1> %cmp to i4
  %.not = icmp eq i4 %0, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_lt_vsl(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: vec_all_lt_vsl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchgs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp sge <2 x i64> %a, %b
  %1 = bitcast <2 x i1> %0 to i2
  %2 = icmp eq i2 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_lt_vsl(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: vec_any_lt_vsl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchgs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp slt <2 x i64> %a, %b
  %0 = bitcast <2 x i1> %cmp to i2
  %1 = icmp ne i2 %0, 0
  ret i1 %1
}

define zeroext i1 @not_vec_all_lt_vsl(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: not_vec_all_lt_vsl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchgs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp sge <2 x i64> %a, %b
  %1 = bitcast <2 x i1> %0 to i2
  %2 = icmp ne i2 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_lt_vsl(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: not_vec_any_lt_vsl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchgs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp slt <2 x i64> %a, %b
  %0 = bitcast <2 x i1> %cmp to i2
  %.not = icmp eq i2 %0, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_lt_vul(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: vec_all_lt_vul:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlgs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp uge <2 x i64> %a, %b
  %1 = bitcast <2 x i1> %0 to i2
  %2 = icmp eq i2 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_lt_vul(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: vec_any_lt_vul:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlgs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp ult <2 x i64> %a, %b
  %0 = bitcast <2 x i1> %cmp to i2
  %1 = icmp ne i2 %0, 0
  ret i1 %1
}

define zeroext i1 @not_vec_all_lt_vul(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: not_vec_all_lt_vul:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlgs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp uge <2 x i64> %a, %b
  %1 = bitcast <2 x i1> %0 to i2
  %2 = icmp ne i2 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_lt_vul(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: not_vec_any_lt_vul:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlgs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp ult <2 x i64> %a, %b
  %0 = bitcast <2 x i1> %cmp to i2
  %.not = icmp eq i2 %0, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_lt_vf(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: vec_all_lt_vf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchsbs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = fcmp uge <4 x float> %a, %b
  %1 = bitcast <4 x i1> %0 to i4
  %2 = icmp eq i4 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_lt_vf(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: vec_any_lt_vf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchsbs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = fcmp olt <4 x float> %a, %b
  %0 = bitcast <4 x i1> %cmp to i4
  %1 = icmp ne i4 %0, 0
  ret i1 %1
}

define zeroext i1 @not_vec_all_lt_vf(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: not_vec_all_lt_vf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchsbs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = fcmp uge <4 x float> %a, %b
  %1 = bitcast <4 x i1> %0 to i4
  %2 = icmp ne i4 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_lt_vf(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: not_vec_any_lt_vf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchsbs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = fcmp olt <4 x float> %a, %b
  %0 = bitcast <4 x i1> %cmp to i4
  %.not = icmp eq i4 %0, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_lt_vd(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: vec_all_lt_vd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchdbs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = fcmp uge <2 x double> %a, %b
  %1 = bitcast <2 x i1> %0 to i2
  %2 = icmp eq i2 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_lt_vd(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: vec_any_lt_vd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchdbs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = fcmp olt <2 x double> %a, %b
  %0 = bitcast <2 x i1> %cmp to i2
  %1 = icmp ne i2 %0, 0
  ret i1 %1
}

define zeroext i1 @not_vec_all_lt_vd(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: not_vec_all_lt_vd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchdbs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = fcmp uge <2 x double> %a, %b
  %1 = bitcast <2 x i1> %0 to i2
  %2 = icmp ne i2 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_lt_vd(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: not_vec_any_lt_vd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchdbs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = fcmp olt <2 x double> %a, %b
  %0 = bitcast <2 x i1> %cmp to i2
  %.not = icmp eq i2 %0, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_le_vsc(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: vec_all_le_vsc:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp sgt <16 x i8> %a, %b
  %1 = bitcast <16 x i1> %0 to i16
  %2 = icmp eq i16 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_le_vsc(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: vec_any_le_vsc:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp sle <16 x i8> %a, %b
  %0 = bitcast <16 x i1> %cmp to i16
  %1 = icmp ne i16 %0, 0
  ret i1 %1
}

define zeroext i1 @not_vec_all_le_vsc(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: not_vec_all_le_vsc:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp sgt <16 x i8> %a, %b
  %1 = bitcast <16 x i1> %0 to i16
  %2 = icmp ne i16 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_le_vsc(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: not_vec_any_le_vsc:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp sle <16 x i8> %a, %b
  %0 = bitcast <16 x i1> %cmp to i16
  %.not = icmp eq i16 %0, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_le_vuc(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: vec_all_le_vuc:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp ugt <16 x i8> %a, %b
  %1 = bitcast <16 x i1> %0 to i16
  %2 = icmp eq i16 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_le_vuc(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: vec_any_le_vuc:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp ule <16 x i8> %a, %b
  %0 = bitcast <16 x i1> %cmp to i16
  %1 = icmp ne i16 %0, 0
  ret i1 %1
}

define zeroext i1 @not_vec_all_le_vuc(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: not_vec_all_le_vuc:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp ugt <16 x i8> %a, %b
  %1 = bitcast <16 x i1> %0 to i16
  %2 = icmp ne i16 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_le_vuc(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: not_vec_any_le_vuc:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp ule <16 x i8> %a, %b
  %0 = bitcast <16 x i1> %cmp to i16
  %.not = icmp eq i16 %0, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_le_vss(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: vec_all_le_vss:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchhs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp sgt <8 x i16> %a, %b
  %1 = bitcast <8 x i1> %0 to i8
  %2 = icmp eq i8 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_le_vss(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: vec_any_le_vss:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchhs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp sle <8 x i16> %a, %b
  %0 = bitcast <8 x i1> %cmp to i8
  %1 = icmp ne i8 %0, 0
  ret i1 %1
}

define zeroext i1 @not_vec_all_le_vss(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: not_vec_all_le_vss:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchhs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp sgt <8 x i16> %a, %b
  %1 = bitcast <8 x i1> %0 to i8
  %2 = icmp ne i8 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_le_vss(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: not_vec_any_le_vss:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchhs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp sle <8 x i16> %a, %b
  %0 = bitcast <8 x i1> %cmp to i8
  %.not = icmp eq i8 %0, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_le_vus(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: vec_all_le_vus:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlhs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp ugt <8 x i16> %a, %b
  %1 = bitcast <8 x i1> %0 to i8
  %2 = icmp eq i8 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_le_vus(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: vec_any_le_vus:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlhs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp ule <8 x i16> %a, %b
  %0 = bitcast <8 x i1> %cmp to i8
  %1 = icmp ne i8 %0, 0
  ret i1 %1
}

define zeroext i1 @not_vec_all_le_vus(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: not_vec_all_le_vus:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlhs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp ugt <8 x i16> %a, %b
  %1 = bitcast <8 x i1> %0 to i8
  %2 = icmp ne i8 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_le_vus(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: not_vec_any_le_vus:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlhs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp ule <8 x i16> %a, %b
  %0 = bitcast <8 x i1> %cmp to i8
  %.not = icmp eq i8 %0, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_le_vsi(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: vec_all_le_vsi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchfs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp sgt <4 x i32> %a, %b
  %1 = bitcast <4 x i1> %0 to i4
  %2 = icmp eq i4 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_le_vsi(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: vec_any_le_vsi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchfs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp sle <4 x i32> %a, %b
  %0 = bitcast <4 x i1> %cmp to i4
  %1 = icmp ne i4 %0, 0
  ret i1 %1
}

define zeroext i1 @not_vec_all_le_vsi(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: not_vec_all_le_vsi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchfs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp sgt <4 x i32> %a, %b
  %1 = bitcast <4 x i1> %0 to i4
  %2 = icmp ne i4 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_le_vsi(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: not_vec_any_le_vsi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchfs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp sle <4 x i32> %a, %b
  %0 = bitcast <4 x i1> %cmp to i4
  %.not = icmp eq i4 %0, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_le_vui(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: vec_all_le_vui:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlfs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp ugt <4 x i32> %a, %b
  %1 = bitcast <4 x i1> %0 to i4
  %2 = icmp eq i4 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_le_vui(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: vec_any_le_vui:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlfs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp ule <4 x i32> %a, %b
  %0 = bitcast <4 x i1> %cmp to i4
  %1 = icmp ne i4 %0, 0
  ret i1 %1
}

define zeroext i1 @not_vec_all_le_vui(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: not_vec_all_le_vui:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlfs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp ugt <4 x i32> %a, %b
  %1 = bitcast <4 x i1> %0 to i4
  %2 = icmp ne i4 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_le_vui(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: not_vec_any_le_vui:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlfs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp ule <4 x i32> %a, %b
  %0 = bitcast <4 x i1> %cmp to i4
  %.not = icmp eq i4 %0, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_le_vsl(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: vec_all_le_vsl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchgs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp sgt <2 x i64> %a, %b
  %1 = bitcast <2 x i1> %0 to i2
  %2 = icmp eq i2 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_le_vsl(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: vec_any_le_vsl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchgs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp sle <2 x i64> %a, %b
  %0 = bitcast <2 x i1> %cmp to i2
  %1 = icmp ne i2 %0, 0
  ret i1 %1
}

define zeroext i1 @not_vec_all_le_vsl(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: not_vec_all_le_vsl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchgs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp sgt <2 x i64> %a, %b
  %1 = bitcast <2 x i1> %0 to i2
  %2 = icmp ne i2 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_le_vsl(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: not_vec_any_le_vsl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchgs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp sle <2 x i64> %a, %b
  %0 = bitcast <2 x i1> %cmp to i2
  %.not = icmp eq i2 %0, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_le_vul(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: vec_all_le_vul:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlgs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp ugt <2 x i64> %a, %b
  %1 = bitcast <2 x i1> %0 to i2
  %2 = icmp eq i2 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_le_vul(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: vec_any_le_vul:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlgs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp ule <2 x i64> %a, %b
  %0 = bitcast <2 x i1> %cmp to i2
  %1 = icmp ne i2 %0, 0
  ret i1 %1
}

define zeroext i1 @not_vec_all_le_vul(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: not_vec_all_le_vul:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlgs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp ugt <2 x i64> %a, %b
  %1 = bitcast <2 x i1> %0 to i2
  %2 = icmp ne i2 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_le_vul(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: not_vec_any_le_vul:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlgs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp ule <2 x i64> %a, %b
  %0 = bitcast <2 x i1> %cmp to i2
  %.not = icmp eq i2 %0, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_le_vf(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: vec_all_le_vf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchesbs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = fcmp ugt <4 x float> %a, %b
  %1 = bitcast <4 x i1> %0 to i4
  %2 = icmp eq i4 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_le_vf(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: vec_any_le_vf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchesbs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = fcmp ole <4 x float> %a, %b
  %0 = bitcast <4 x i1> %cmp to i4
  %1 = icmp ne i4 %0, 0
  ret i1 %1
}

define zeroext i1 @not_vec_all_le_vf(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: not_vec_all_le_vf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchesbs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = fcmp ugt <4 x float> %a, %b
  %1 = bitcast <4 x i1> %0 to i4
  %2 = icmp ne i4 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_le_vf(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: not_vec_any_le_vf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchesbs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = fcmp ole <4 x float> %a, %b
  %0 = bitcast <4 x i1> %cmp to i4
  %.not = icmp eq i4 %0, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_le_vd(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: vec_all_le_vd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchedbs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = fcmp ugt <2 x double> %a, %b
  %1 = bitcast <2 x i1> %0 to i2
  %2 = icmp eq i2 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_le_vd(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: vec_any_le_vd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchedbs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = fcmp ole <2 x double> %a, %b
  %0 = bitcast <2 x i1> %cmp to i2
  %1 = icmp ne i2 %0, 0
  ret i1 %1
}

define zeroext i1 @not_vec_all_le_vd(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: not_vec_all_le_vd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchedbs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = fcmp ugt <2 x double> %a, %b
  %1 = bitcast <2 x i1> %0 to i2
  %2 = icmp ne i2 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_le_vd(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: not_vec_any_le_vd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchedbs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = fcmp ole <2 x double> %a, %b
  %0 = bitcast <2 x i1> %cmp to i2
  %.not = icmp eq i2 %0, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_gt_vsc(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: vec_all_gt_vsc:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp sle <16 x i8> %a, %b
  %1 = bitcast <16 x i1> %0 to i16
  %2 = icmp eq i16 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_gt_vsc(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: vec_any_gt_vsc:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp sgt <16 x i8> %a, %b
  %0 = bitcast <16 x i1> %cmp to i16
  %1 = icmp ne i16 %0, 0
  ret i1 %1
}

define zeroext i1 @not_vec_all_gt_vsc(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: not_vec_all_gt_vsc:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp sle <16 x i8> %a, %b
  %1 = bitcast <16 x i1> %0 to i16
  %2 = icmp ne i16 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_gt_vsc(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: not_vec_any_gt_vsc:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp sgt <16 x i8> %a, %b
  %0 = bitcast <16 x i1> %cmp to i16
  %.not = icmp eq i16 %0, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_gt_vuc(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: vec_all_gt_vuc:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp ule <16 x i8> %a, %b
  %1 = bitcast <16 x i1> %0 to i16
  %2 = icmp eq i16 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_gt_vuc(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: vec_any_gt_vuc:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp ugt <16 x i8> %a, %b
  %0 = bitcast <16 x i1> %cmp to i16
  %1 = icmp ne i16 %0, 0
  ret i1 %1
}

define zeroext i1 @not_vec_all_gt_vuc(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: not_vec_all_gt_vuc:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp ule <16 x i8> %a, %b
  %1 = bitcast <16 x i1> %0 to i16
  %2 = icmp ne i16 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_gt_vuc(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: not_vec_any_gt_vuc:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp ugt <16 x i8> %a, %b
  %0 = bitcast <16 x i1> %cmp to i16
  %.not = icmp eq i16 %0, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_gt_vss(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: vec_all_gt_vss:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchhs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp sle <8 x i16> %a, %b
  %1 = bitcast <8 x i1> %0 to i8
  %2 = icmp eq i8 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_gt_vss(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: vec_any_gt_vss:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchhs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp sgt <8 x i16> %a, %b
  %0 = bitcast <8 x i1> %cmp to i8
  %1 = icmp ne i8 %0, 0
  ret i1 %1
}

define zeroext i1 @not_vec_all_gt_vss(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: not_vec_all_gt_vss:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchhs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp sle <8 x i16> %a, %b
  %1 = bitcast <8 x i1> %0 to i8
  %2 = icmp ne i8 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_gt_vss(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: not_vec_any_gt_vss:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchhs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp sgt <8 x i16> %a, %b
  %0 = bitcast <8 x i1> %cmp to i8
  %.not = icmp eq i8 %0, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_gt_vus(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: vec_all_gt_vus:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlhs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp ule <8 x i16> %a, %b
  %1 = bitcast <8 x i1> %0 to i8
  %2 = icmp eq i8 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_gt_vus(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: vec_any_gt_vus:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlhs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp ugt <8 x i16> %a, %b
  %0 = bitcast <8 x i1> %cmp to i8
  %1 = icmp ne i8 %0, 0
  ret i1 %1
}

define zeroext i1 @not_vec_all_gt_vus(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: not_vec_all_gt_vus:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlhs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp ule <8 x i16> %a, %b
  %1 = bitcast <8 x i1> %0 to i8
  %2 = icmp ne i8 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_gt_vus(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: not_vec_any_gt_vus:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlhs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp ugt <8 x i16> %a, %b
  %0 = bitcast <8 x i1> %cmp to i8
  %.not = icmp eq i8 %0, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_gt_vsi(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: vec_all_gt_vsi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchfs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp sle <4 x i32> %a, %b
  %1 = bitcast <4 x i1> %0 to i4
  %2 = icmp eq i4 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_gt_vsi(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: vec_any_gt_vsi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchfs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp sgt <4 x i32> %a, %b
  %0 = bitcast <4 x i1> %cmp to i4
  %1 = icmp ne i4 %0, 0
  ret i1 %1
}

define zeroext i1 @not_vec_all_gt_vsi(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: not_vec_all_gt_vsi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchfs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp sle <4 x i32> %a, %b
  %1 = bitcast <4 x i1> %0 to i4
  %2 = icmp ne i4 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_gt_vsi(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: not_vec_any_gt_vsi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchfs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp sgt <4 x i32> %a, %b
  %0 = bitcast <4 x i1> %cmp to i4
  %.not = icmp eq i4 %0, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_gt_vui(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: vec_all_gt_vui:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlfs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp ule <4 x i32> %a, %b
  %1 = bitcast <4 x i1> %0 to i4
  %2 = icmp eq i4 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_gt_vui(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: vec_any_gt_vui:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlfs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp ugt <4 x i32> %a, %b
  %0 = bitcast <4 x i1> %cmp to i4
  %1 = icmp ne i4 %0, 0
  ret i1 %1
}

define zeroext i1 @not_vec_all_gt_vui(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: not_vec_all_gt_vui:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlfs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp ule <4 x i32> %a, %b
  %1 = bitcast <4 x i1> %0 to i4
  %2 = icmp ne i4 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_gt_vui(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: not_vec_any_gt_vui:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlfs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp ugt <4 x i32> %a, %b
  %0 = bitcast <4 x i1> %cmp to i4
  %.not = icmp eq i4 %0, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_gt_vsl(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: vec_all_gt_vsl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchgs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp sle <2 x i64> %a, %b
  %1 = bitcast <2 x i1> %0 to i2
  %2 = icmp eq i2 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_gt_vsl(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: vec_any_gt_vsl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchgs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp sgt <2 x i64> %a, %b
  %0 = bitcast <2 x i1> %cmp to i2
  %1 = icmp ne i2 %0, 0
  ret i1 %1
}

define zeroext i1 @not_vec_all_gt_vsl(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: not_vec_all_gt_vsl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchgs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp sle <2 x i64> %a, %b
  %1 = bitcast <2 x i1> %0 to i2
  %2 = icmp ne i2 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_gt_vsl(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: not_vec_any_gt_vsl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchgs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp sgt <2 x i64> %a, %b
  %0 = bitcast <2 x i1> %cmp to i2
  %.not = icmp eq i2 %0, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_gt_vul(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: vec_all_gt_vul:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlgs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp ule <2 x i64> %a, %b
  %1 = bitcast <2 x i1> %0 to i2
  %2 = icmp eq i2 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_gt_vul(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: vec_any_gt_vul:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlgs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp ugt <2 x i64> %a, %b
  %0 = bitcast <2 x i1> %cmp to i2
  %1 = icmp ne i2 %0, 0
  ret i1 %1
}

define zeroext i1 @not_vec_all_gt_vul(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: not_vec_all_gt_vul:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlgs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp ule <2 x i64> %a, %b
  %1 = bitcast <2 x i1> %0 to i2
  %2 = icmp ne i2 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_gt_vul(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: not_vec_any_gt_vul:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlgs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp ugt <2 x i64> %a, %b
  %0 = bitcast <2 x i1> %cmp to i2
  %.not = icmp eq i2 %0, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_gt_vf(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: vec_all_gt_vf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchsbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = fcmp ule <4 x float> %a, %b
  %1 = bitcast <4 x i1> %0 to i4
  %2 = icmp eq i4 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_gt_vf(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: vec_any_gt_vf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchsbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = fcmp ogt <4 x float> %a, %b
  %0 = bitcast <4 x i1> %cmp to i4
  %1 = icmp ne i4 %0, 0
  ret i1 %1
}

define zeroext i1 @not_vec_all_gt_vf(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: not_vec_all_gt_vf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchsbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = fcmp ule <4 x float> %a, %b
  %1 = bitcast <4 x i1> %0 to i4
  %2 = icmp ne i4 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_gt_vf(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: not_vec_any_gt_vf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchsbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = fcmp ogt <4 x float> %a, %b
  %0 = bitcast <4 x i1> %cmp to i4
  %.not = icmp eq i4 %0, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_gt_vd(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: vec_all_gt_vd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchdbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = fcmp ule <2 x double> %a, %b
  %1 = bitcast <2 x i1> %0 to i2
  %2 = icmp eq i2 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_gt_vd(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: vec_any_gt_vd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchdbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = fcmp ogt <2 x double> %a, %b
  %0 = bitcast <2 x i1> %cmp to i2
  %1 = icmp ne i2 %0, 0
  ret i1 %1
}

define zeroext i1 @not_vec_all_gt_vd(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: not_vec_all_gt_vd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchdbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = fcmp ule <2 x double> %a, %b
  %1 = bitcast <2 x i1> %0 to i2
  %2 = icmp ne i2 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_gt_vd(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: not_vec_any_gt_vd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchdbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = fcmp ogt <2 x double> %a, %b
  %0 = bitcast <2 x i1> %cmp to i2
  %.not = icmp eq i2 %0, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_ge_vsc(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: vec_all_ge_vsc:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchbs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp slt <16 x i8> %a, %b
  %1 = bitcast <16 x i1> %0 to i16
  %2 = icmp eq i16 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_ge_vsc(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: vec_any_ge_vsc:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchbs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp sge <16 x i8> %a, %b
  %0 = bitcast <16 x i1> %cmp to i16
  %1 = icmp ne i16 %0, 0
  ret i1 %1
}

define zeroext i1 @not_vec_all_ge_vsc(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: not_vec_all_ge_vsc:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchbs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp slt <16 x i8> %a, %b
  %1 = bitcast <16 x i1> %0 to i16
  %2 = icmp ne i16 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_ge_vsc(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: not_vec_any_ge_vsc:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchbs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp sge <16 x i8> %a, %b
  %0 = bitcast <16 x i1> %cmp to i16
  %.not = icmp eq i16 %0, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_ge_vuc(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: vec_all_ge_vuc:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlbs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp ult <16 x i8> %a, %b
  %1 = bitcast <16 x i1> %0 to i16
  %2 = icmp eq i16 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_ge_vuc(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: vec_any_ge_vuc:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlbs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp uge <16 x i8> %a, %b
  %0 = bitcast <16 x i1> %cmp to i16
  %1 = icmp ne i16 %0, 0
  ret i1 %1
}

define zeroext i1 @not_vec_all_ge_vuc(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: not_vec_all_ge_vuc:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlbs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp ult <16 x i8> %a, %b
  %1 = bitcast <16 x i1> %0 to i16
  %2 = icmp ne i16 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_ge_vuc(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: not_vec_any_ge_vuc:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlbs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp uge <16 x i8> %a, %b
  %0 = bitcast <16 x i1> %cmp to i16
  %.not = icmp eq i16 %0, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_ge_vss(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: vec_all_ge_vss:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchhs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp slt <8 x i16> %a, %b
  %1 = bitcast <8 x i1> %0 to i8
  %2 = icmp eq i8 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_ge_vss(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: vec_any_ge_vss:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchhs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp sge <8 x i16> %a, %b
  %0 = bitcast <8 x i1> %cmp to i8
  %1 = icmp ne i8 %0, 0
  ret i1 %1
}

define zeroext i1 @not_vec_all_ge_vss(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: not_vec_all_ge_vss:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchhs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp slt <8 x i16> %a, %b
  %1 = bitcast <8 x i1> %0 to i8
  %2 = icmp ne i8 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_ge_vss(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: not_vec_any_ge_vss:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchhs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp sge <8 x i16> %a, %b
  %0 = bitcast <8 x i1> %cmp to i8
  %.not = icmp eq i8 %0, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_ge_vus(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: vec_all_ge_vus:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlhs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp ult <8 x i16> %a, %b
  %1 = bitcast <8 x i1> %0 to i8
  %2 = icmp eq i8 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_ge_vus(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: vec_any_ge_vus:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlhs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp uge <8 x i16> %a, %b
  %0 = bitcast <8 x i1> %cmp to i8
  %1 = icmp ne i8 %0, 0
  ret i1 %1
}

define zeroext i1 @not_vec_all_ge_vus(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: not_vec_all_ge_vus:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlhs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp ult <8 x i16> %a, %b
  %1 = bitcast <8 x i1> %0 to i8
  %2 = icmp ne i8 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_ge_vus(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: not_vec_any_ge_vus:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlhs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp uge <8 x i16> %a, %b
  %0 = bitcast <8 x i1> %cmp to i8
  %.not = icmp eq i8 %0, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_ge_vsi(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: vec_all_ge_vsi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchfs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp slt <4 x i32> %a, %b
  %1 = bitcast <4 x i1> %0 to i4
  %2 = icmp eq i4 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_ge_vsi(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: vec_any_ge_vsi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchfs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp sge <4 x i32> %a, %b
  %0 = bitcast <4 x i1> %cmp to i4
  %1 = icmp ne i4 %0, 0
  ret i1 %1
}

define zeroext i1 @not_vec_all_ge_vsi(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: not_vec_all_ge_vsi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchfs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp slt <4 x i32> %a, %b
  %1 = bitcast <4 x i1> %0 to i4
  %2 = icmp ne i4 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_ge_vsi(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: not_vec_any_ge_vsi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchfs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp sge <4 x i32> %a, %b
  %0 = bitcast <4 x i1> %cmp to i4
  %.not = icmp eq i4 %0, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_ge_vui(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: vec_all_ge_vui:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlfs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp ult <4 x i32> %a, %b
  %1 = bitcast <4 x i1> %0 to i4
  %2 = icmp eq i4 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_ge_vui(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: vec_any_ge_vui:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlfs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp uge <4 x i32> %a, %b
  %0 = bitcast <4 x i1> %cmp to i4
  %1 = icmp ne i4 %0, 0
  ret i1 %1
}

define zeroext i1 @not_vec_all_ge_vui(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: not_vec_all_ge_vui:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlfs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp ult <4 x i32> %a, %b
  %1 = bitcast <4 x i1> %0 to i4
  %2 = icmp ne i4 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_ge_vui(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: not_vec_any_ge_vui:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlfs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp uge <4 x i32> %a, %b
  %0 = bitcast <4 x i1> %cmp to i4
  %.not = icmp eq i4 %0, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_ge_vsl(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: vec_all_ge_vsl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchgs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp slt <2 x i64> %a, %b
  %1 = bitcast <2 x i1> %0 to i2
  %2 = icmp eq i2 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_ge_vsl(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: vec_any_ge_vsl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchgs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp sge <2 x i64> %a, %b
  %0 = bitcast <2 x i1> %cmp to i2
  %1 = icmp ne i2 %0, 0
  ret i1 %1
}

define zeroext i1 @not_vec_all_ge_vsl(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: not_vec_all_ge_vsl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchgs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp slt <2 x i64> %a, %b
  %1 = bitcast <2 x i1> %0 to i2
  %2 = icmp ne i2 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_ge_vsl(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: not_vec_any_ge_vsl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchgs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp sge <2 x i64> %a, %b
  %0 = bitcast <2 x i1> %cmp to i2
  %.not = icmp eq i2 %0, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_ge_vul(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: vec_all_ge_vul:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlgs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp ult <2 x i64> %a, %b
  %1 = bitcast <2 x i1> %0 to i2
  %2 = icmp eq i2 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_ge_vul(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: vec_any_ge_vul:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlgs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp uge <2 x i64> %a, %b
  %0 = bitcast <2 x i1> %cmp to i2
  %1 = icmp ne i2 %0, 0
  ret i1 %1
}

define zeroext i1 @not_vec_all_ge_vul(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: not_vec_all_ge_vul:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlgs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = icmp ult <2 x i64> %a, %b
  %1 = bitcast <2 x i1> %0 to i2
  %2 = icmp ne i2 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_ge_vul(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: not_vec_any_ge_vul:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vchlgs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = icmp uge <2 x i64> %a, %b
  %0 = bitcast <2 x i1> %cmp to i2
  %.not = icmp eq i2 %0, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_ge_vf(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: vec_all_ge_vf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchesbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = fcmp ult <4 x float> %a, %b
  %1 = bitcast <4 x i1> %0 to i4
  %2 = icmp eq i4 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_ge_vf(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: vec_any_ge_vf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchesbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = fcmp oge <4 x float> %a, %b
  %0 = bitcast <4 x i1> %cmp to i4
  %1 = icmp ne i4 %0, 0
  ret i1 %1
}

define zeroext i1 @not_vec_all_ge_vf(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: not_vec_all_ge_vf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchesbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = fcmp ult <4 x float> %a, %b
  %1 = bitcast <4 x i1> %0 to i4
  %2 = icmp ne i4 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_ge_vf(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: not_vec_any_ge_vf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchesbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = fcmp oge <4 x float> %a, %b
  %0 = bitcast <4 x i1> %cmp to i4
  %.not = icmp eq i4 %0, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_ge_vd(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: vec_all_ge_vd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchedbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = fcmp ult <2 x double> %a, %b
  %1 = bitcast <2 x i1> %0 to i2
  %2 = icmp eq i2 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_ge_vd(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: vec_any_ge_vd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchedbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = fcmp oge <2 x double> %a, %b
  %0 = bitcast <2 x i1> %cmp to i2
  %1 = icmp ne i2 %0, 0
  ret i1 %1
}

define zeroext i1 @not_vec_all_ge_vd(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: not_vec_all_ge_vd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchedbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = fcmp ult <2 x double> %a, %b
  %1 = bitcast <2 x i1> %0 to i2
  %2 = icmp ne i2 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_ge_vd(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: not_vec_any_ge_vd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchedbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %cmp = fcmp oge <2 x double> %a, %b
  %0 = bitcast <2 x i1> %cmp to i2
  %.not = icmp eq i2 %0, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_nlt_vf(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: vec_all_nlt_vf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchsbs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = fcmp olt <4 x float> %a, %b
  %1 = bitcast <4 x i1> %0 to i4
  %2 = icmp eq i4 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_nlt_vf(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: vec_any_nlt_vf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchsbs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = fcmp uge <4 x float> %a, %b
  %1 = bitcast <4 x i1> %0 to i4
  %2 = icmp ne i4 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_all_nlt_vf(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: not_vec_all_nlt_vf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchsbs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = fcmp olt <4 x float> %a, %b
  %1 = bitcast <4 x i1> %0 to i4
  %2 = icmp ne i4 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_nlt_vf(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: not_vec_any_nlt_vf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchsbs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = fcmp uge <4 x float> %a, %b
  %1 = bitcast <4 x i1> %0 to i4
  %.not = icmp eq i4 %1, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_nlt_vd(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: vec_all_nlt_vd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchdbs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = fcmp olt <2 x double> %a, %b
  %1 = bitcast <2 x i1> %0 to i2
  %2 = icmp eq i2 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_nlt_vd(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: vec_any_nlt_vd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchdbs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = fcmp uge <2 x double> %a, %b
  %1 = bitcast <2 x i1> %0 to i2
  %2 = icmp ne i2 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_all_nlt_vd(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: not_vec_all_nlt_vd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchdbs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = fcmp olt <2 x double> %a, %b
  %1 = bitcast <2 x i1> %0 to i2
  %2 = icmp ne i2 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_nlt_vd(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: not_vec_any_nlt_vd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchdbs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = fcmp uge <2 x double> %a, %b
  %1 = bitcast <2 x i1> %0 to i2
  %.not = icmp eq i2 %1, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_nle_vf(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: vec_all_nle_vf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchesbs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = fcmp ole <4 x float> %a, %b
  %1 = bitcast <4 x i1> %0 to i4
  %2 = icmp eq i4 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_nle_vf(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: vec_any_nle_vf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchesbs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = fcmp ugt <4 x float> %a, %b
  %1 = bitcast <4 x i1> %0 to i4
  %2 = icmp ne i4 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_all_nle_vf(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: not_vec_all_nle_vf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchesbs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = fcmp ole <4 x float> %a, %b
  %1 = bitcast <4 x i1> %0 to i4
  %2 = icmp ne i4 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_nle_vf(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: not_vec_any_nle_vf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchesbs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = fcmp ugt <4 x float> %a, %b
  %1 = bitcast <4 x i1> %0 to i4
  %.not = icmp eq i4 %1, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_nle_vd(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: vec_all_nle_vd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchedbs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = fcmp ole <2 x double> %a, %b
  %1 = bitcast <2 x i1> %0 to i2
  %2 = icmp eq i2 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_nle_vd(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: vec_any_nle_vd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchedbs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = fcmp ugt <2 x double> %a, %b
  %1 = bitcast <2 x i1> %0 to i2
  %2 = icmp ne i2 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_all_nle_vd(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: not_vec_all_nle_vd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchedbs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = fcmp ole <2 x double> %a, %b
  %1 = bitcast <2 x i1> %0 to i2
  %2 = icmp ne i2 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_nle_vd(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: not_vec_any_nle_vd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchedbs %v0, %v26, %v24
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = fcmp ugt <2 x double> %a, %b
  %1 = bitcast <2 x i1> %0 to i2
  %.not = icmp eq i2 %1, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_ngt_vf(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: vec_all_ngt_vf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchsbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = fcmp ogt <4 x float> %a, %b
  %1 = bitcast <4 x i1> %0 to i4
  %2 = icmp eq i4 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_ngt_vf(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: vec_any_ngt_vf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchsbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = fcmp ule <4 x float> %a, %b
  %1 = bitcast <4 x i1> %0 to i4
  %2 = icmp ne i4 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_all_ngt_vf(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: not_vec_all_ngt_vf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchsbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = fcmp ogt <4 x float> %a, %b
  %1 = bitcast <4 x i1> %0 to i4
  %2 = icmp ne i4 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_ngt_vf(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: not_vec_any_ngt_vf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchsbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = fcmp ule <4 x float> %a, %b
  %1 = bitcast <4 x i1> %0 to i4
  %.not = icmp eq i4 %1, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_ngt_vd(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: vec_all_ngt_vd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchdbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = fcmp ogt <2 x double> %a, %b
  %1 = bitcast <2 x i1> %0 to i2
  %2 = icmp eq i2 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_ngt_vd(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: vec_any_ngt_vd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchdbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = fcmp ule <2 x double> %a, %b
  %1 = bitcast <2 x i1> %0 to i2
  %2 = icmp ne i2 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_all_ngt_vd(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: not_vec_all_ngt_vd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchdbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = fcmp ogt <2 x double> %a, %b
  %1 = bitcast <2 x i1> %0 to i2
  %2 = icmp ne i2 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_ngt_vd(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: not_vec_any_ngt_vd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchdbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = fcmp ule <2 x double> %a, %b
  %1 = bitcast <2 x i1> %0 to i2
  %.not = icmp eq i2 %1, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_nge_vf(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: vec_all_nge_vf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchesbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = fcmp oge <4 x float> %a, %b
  %1 = bitcast <4 x i1> %0 to i4
  %2 = icmp eq i4 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_nge_vf(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: vec_any_nge_vf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchesbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = fcmp ult <4 x float> %a, %b
  %1 = bitcast <4 x i1> %0 to i4
  %2 = icmp ne i4 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_all_nge_vf(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: not_vec_all_nge_vf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchesbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = fcmp oge <4 x float> %a, %b
  %1 = bitcast <4 x i1> %0 to i4
  %2 = icmp ne i4 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_nge_vf(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: not_vec_any_nge_vf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchesbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = fcmp ult <4 x float> %a, %b
  %1 = bitcast <4 x i1> %0 to i4
  %.not = icmp eq i4 %1, 0
  ret i1 %.not
}

define zeroext i1 @vec_all_nge_vd(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: vec_all_nge_vd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchedbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghio %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = fcmp oge <2 x double> %a, %b
  %1 = bitcast <2 x i1> %0 to i2
  %2 = icmp eq i2 %1, 0
  ret i1 %2
}

define zeroext i1 @vec_any_nge_vd(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: vec_any_nge_vd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchedbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghinhe %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = fcmp ult <2 x double> %a, %b
  %1 = bitcast <2 x i1> %0 to i2
  %2 = icmp ne i2 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_all_nge_vd(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: not_vec_all_nge_vd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchedbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghile %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = fcmp oge <2 x double> %a, %b
  %1 = bitcast <2 x i1> %0 to i2
  %2 = icmp ne i2 %1, 0
  ret i1 %2
}

define zeroext i1 @not_vec_any_nge_vd(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: not_vec_any_nge_vd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfchedbs %v0, %v24, %v26
; CHECK-NEXT:    lghi %r2, 0
; CHECK-NEXT:    locghie %r2, 1
; CHECK-NEXT:    br %r14
entry:
  %0 = fcmp ult <2 x double> %a, %b
  %1 = bitcast <2 x i1> %0 to i2
  %.not = icmp eq i2 %1, 0
  ret i1 %.not
}
