; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple=nvptx64 -mcpu=sm_20 -fp-contract=fast | FileCheck %s -check-prefix=CHECK
; RUN: llc < %s -mtriple=nvptx64 -mcpu=sm_20 -fp-contract=fast -enable-unsafe-fp-math | FileCheck %s -check-prefix=CHECK -check-prefix=CHECK-UNSAFE
; RUN: %if ptxas %{ llc < %s -mtriple=nvptx64 -mcpu=sm_20 -fp-contract=fast | %ptxas-verify %}
; RUN: %if ptxas %{ llc < %s -mtriple=nvptx64 -mcpu=sm_20 -fp-contract=fast -enable-unsafe-fp-math | %ptxas-verify %}

define ptx_device float @t1_f32(float %x, float %y, float %z,
; CHECK-UNSAFE-LABEL: t1_f32(
; CHECK-UNSAFE:       {
; CHECK-UNSAFE-NEXT:    .reg .b32 %r<8>;
; CHECK-UNSAFE-EMPTY:
; CHECK-UNSAFE-NEXT:  // %bb.0:
; CHECK-UNSAFE-NEXT:    ld.param.b32 %r1, [t1_f32_param_0];
; CHECK-UNSAFE-NEXT:    ld.param.b32 %r2, [t1_f32_param_1];
; CHECK-UNSAFE-NEXT:    ld.param.b32 %r3, [t1_f32_param_2];
; CHECK-UNSAFE-NEXT:    ld.param.b32 %r4, [t1_f32_param_3];
; CHECK-UNSAFE-NEXT:    ld.param.b32 %r5, [t1_f32_param_4];
; CHECK-UNSAFE-NEXT:    fma.rn.f32 %r6, %r4, %r5, %r3;
; CHECK-UNSAFE-NEXT:    fma.rn.f32 %r7, %r1, %r2, %r6;
; CHECK-UNSAFE-NEXT:    st.param.b32 [func_retval0], %r7;
; CHECK-UNSAFE-NEXT:    ret;
                                float %u, float %v) {
  %a = fmul float %x, %y
  %b = fmul float %u, %v
  %c = fadd float %a, %b
  %d = fadd float %c, %z
  ret float %d
}

define ptx_device double @t1_f64(double %x, double %y, double %z,
; CHECK-UNSAFE-LABEL: t1_f64(
; CHECK-UNSAFE:       {
; CHECK-UNSAFE-NEXT:    .reg .b64 %rd<8>;
; CHECK-UNSAFE-EMPTY:
; CHECK-UNSAFE-NEXT:  // %bb.0:
; CHECK-UNSAFE-NEXT:    ld.param.b64 %rd1, [t1_f64_param_0];
; CHECK-UNSAFE-NEXT:    ld.param.b64 %rd2, [t1_f64_param_1];
; CHECK-UNSAFE-NEXT:    ld.param.b64 %rd3, [t1_f64_param_2];
; CHECK-UNSAFE-NEXT:    ld.param.b64 %rd4, [t1_f64_param_3];
; CHECK-UNSAFE-NEXT:    ld.param.b64 %rd5, [t1_f64_param_4];
; CHECK-UNSAFE-NEXT:    fma.rn.f64 %rd6, %rd4, %rd5, %rd3;
; CHECK-UNSAFE-NEXT:    fma.rn.f64 %rd7, %rd1, %rd2, %rd6;
; CHECK-UNSAFE-NEXT:    st.param.b64 [func_retval0], %rd7;
; CHECK-UNSAFE-NEXT:    ret;
                                 double %u, double %v) {
  %a = fmul double %x, %y
  %b = fmul double %u, %v
  %c = fadd double %a, %b
  %d = fadd double %c, %z
  ret double %d
}

define double @two_choices(double %val1, double %val2) {
; CHECK-LABEL: two_choices(
; CHECK:       {
; CHECK-NEXT:    .reg .b64 %rd<5>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b64 %rd1, [two_choices_param_0];
; CHECK-NEXT:    ld.param.b64 %rd2, [two_choices_param_1];
; CHECK-NEXT:    mul.f64 %rd3, %rd1, %rd2;
; CHECK-NEXT:    fma.rn.f64 %rd4, %rd3, %rd3, %rd3;
; CHECK-NEXT:    st.param.b64 [func_retval0], %rd4;
; CHECK-NEXT:    ret;
  %1 = fmul double %val1, %val2
  %2 = fmul double %1, %1
  %3 = fadd double %1, %2

  ret double %3
}

