; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc --mtriple=loongarch64 -mattr=+lsx --verify-machineinstrs < %s \
; RUN:   | FileCheck %s

declare <16 x i8> @llvm.bitreverse.v16i8(<16 x i8>)

define <16 x i8> @test_bitreverse_v16i8(<16 x i8> %a) nounwind {
; CHECK-LABEL: test_bitreverse_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpickve2gr.d $a0, $vr0, 0
; CHECK-NEXT:    bitrev.8b $a0, $a0
; CHECK-NEXT:    vinsgr2vr.d $vr1, $a0, 0
; CHECK-NEXT:    vpickve2gr.d $a0, $vr0, 1
; CHECK-NEXT:    bitrev.8b $a0, $a0
; CHECK-NEXT:    vinsgr2vr.d $vr1, $a0, 1
; CHECK-NEXT:    vori.b $vr0, $vr1, 0
; CHECK-NEXT:    ret
  %b = call <16 x i8> @llvm.bitreverse.v16i8(<16 x i8> %a)
  ret <16 x i8> %b
}

declare <8 x i16> @llvm.bitreverse.v8i16(<8 x i16>)

define <8 x i16> @test_bitreverse_v8i16(<8 x i16> %a) nounwind {
; CHECK-LABEL: test_bitreverse_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpickve2gr.d $a0, $vr0, 0
; CHECK-NEXT:    bitrev.d $a0, $a0
; CHECK-NEXT:    vinsgr2vr.d $vr1, $a0, 0
; CHECK-NEXT:    vpickve2gr.d $a0, $vr0, 1
; CHECK-NEXT:    bitrev.d $a0, $a0
; CHECK-NEXT:    vinsgr2vr.d $vr1, $a0, 1
; CHECK-NEXT:    vshuf4i.h $vr0, $vr1, 27
; CHECK-NEXT:    ret
  %b = call <8 x i16> @llvm.bitreverse.v8i16(<8 x i16> %a)
  ret <8 x i16> %b
}

declare <4 x i32> @llvm.bitreverse.v4i32(<4 x i32>)

define <4 x i32> @test_bitreverse_v4i32(<4 x i32> %a) nounwind {
; CHECK-LABEL: test_bitreverse_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpickve2gr.d $a0, $vr0, 0
; CHECK-NEXT:    bitrev.d $a0, $a0
; CHECK-NEXT:    vinsgr2vr.d $vr1, $a0, 0
; CHECK-NEXT:    vpickve2gr.d $a0, $vr0, 1
; CHECK-NEXT:    bitrev.d $a0, $a0
; CHECK-NEXT:    vinsgr2vr.d $vr1, $a0, 1
; CHECK-NEXT:    vshuf4i.w $vr0, $vr1, 177
; CHECK-NEXT:    ret
  %b = call <4 x i32> @llvm.bitreverse.v4i32(<4 x i32> %a)
  ret <4 x i32> %b
}

declare <2 x i64> @llvm.bitreverse.v2i64(<2 x i64>)

define <2 x i64> @test_bitreverse_v2i64(<2 x i64> %a) nounwind {
; CHECK-LABEL: test_bitreverse_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpickve2gr.d $a0, $vr0, 0
; CHECK-NEXT:    bitrev.d $a0, $a0
; CHECK-NEXT:    vinsgr2vr.d $vr1, $a0, 0
; CHECK-NEXT:    vpickve2gr.d $a0, $vr0, 1
; CHECK-NEXT:    bitrev.d $a0, $a0
; CHECK-NEXT:    vinsgr2vr.d $vr1, $a0, 1
; CHECK-NEXT:    vori.b $vr0, $vr1, 0
; CHECK-NEXT:    ret
  %b = call <2 x i64> @llvm.bitreverse.v2i64(<2 x i64> %a)
  ret <2 x i64> %b
}
