; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -float-abi hard -mattr=+bf16,+fullfp16 < %s | FileCheck %s --check-prefix=HARD
; RUN: llc -float-abi soft -mattr=+bf16,+fullfp16 < %s | FileCheck %s --check-prefix=SOFT

target datalayout = "e-m:e-p:32:32-Fi8-i64:64-v128:64:128-a:0:32-n32-S64"
target triple = "armv8.6a-arm-none-eabi"

define bfloat @load_scalar_bf(ptr %addr) {
; HARD-LABEL: load_scalar_bf:
; HARD:       @ %bb.0: @ %entry
; HARD-NEXT:    vldr.16 s0, [r0]
; HARD-NEXT:    bx lr
;
; SOFT-LABEL: load_scalar_bf:
; SOFT:       @ %bb.0: @ %entry
; SOFT-NEXT:    vldr.16 s0, [r0]
; SOFT-NEXT:    vmov r0, s0
; SOFT-NEXT:    bx lr
entry:
  %0 = load bfloat, ptr %addr, align 2
  ret bfloat %0
}

define void @store_scalar_bf(bfloat %v, ptr %addr) {
; HARD-LABEL: store_scalar_bf:
; HARD:       @ %bb.0: @ %entry
; HARD-NEXT:    vstr.16 s0, [r0]
; HARD-NEXT:    bx lr
;
; SOFT-LABEL: store_scalar_bf:
; SOFT:       @ %bb.0: @ %entry
; SOFT-NEXT:    vmov.f16 s0, r0
; SOFT-NEXT:    vstr.16 s0, [r1]
; SOFT-NEXT:    bx lr
entry:
  store bfloat %v, ptr %addr, align 2
  ret void
}

define <4 x bfloat> @load_vector4_bf(ptr %addr) {
; HARD-LABEL: load_vector4_bf:
; HARD:       @ %bb.0: @ %entry
; HARD-NEXT:    vldr d0, [r0]
; HARD-NEXT:    bx lr
;
; SOFT-LABEL: load_vector4_bf:
; SOFT:       @ %bb.0: @ %entry
; SOFT-NEXT:    vldr d16, [r0]
; SOFT-NEXT:    vmov r0, r1, d16
; SOFT-NEXT:    bx lr
entry:
  %0 = load <4 x bfloat>, ptr %addr, align 8
  ret <4 x bfloat> %0
}

define void @store_vector4_bf(<4 x bfloat> %v, ptr %addr) {
; HARD-LABEL: store_vector4_bf:
; HARD:       @ %bb.0: @ %entry
; HARD-NEXT:    vstr d0, [r0]
; HARD-NEXT:    bx lr
;
; SOFT-LABEL: store_vector4_bf:
; SOFT:       @ %bb.0: @ %entry
; SOFT-NEXT:    strd r0, r1, [r2]
; SOFT-NEXT:    bx lr
entry:
  store <4 x bfloat> %v, ptr %addr, align 8
  ret void
}

define <8 x bfloat> @load_vector8_bf(ptr %addr) {
; HARD-LABEL: load_vector8_bf:
; HARD:       @ %bb.0: @ %entry
; HARD-NEXT:    vld1.64 {d0, d1}, [r0]
; HARD-NEXT:    bx lr
;
; SOFT-LABEL: load_vector8_bf:
; SOFT:       @ %bb.0: @ %entry
; SOFT-NEXT:    vld1.64 {d16, d17}, [r0]
; SOFT-NEXT:    vmov r0, r1, d16
; SOFT-NEXT:    vmov r2, r3, d17
; SOFT-NEXT:    bx lr
entry:
  %0 = load <8 x bfloat>, ptr %addr, align 8
  ret <8 x bfloat> %0
}

define void @store_vector8_bf(<8 x bfloat> %v, ptr %addr) {
; HARD-LABEL: store_vector8_bf:
; HARD:       @ %bb.0: @ %entry
; HARD-NEXT:    vst1.64 {d0, d1}, [r0]
; HARD-NEXT:    bx lr
;
; SOFT-LABEL: store_vector8_bf:
; SOFT:       @ %bb.0: @ %entry
; SOFT-NEXT:    vmov d17, r2, r3
; SOFT-NEXT:    ldr r12, [sp]
; SOFT-NEXT:    vmov d16, r0, r1
; SOFT-NEXT:    vst1.64 {d16, d17}, [r12]
; SOFT-NEXT:    bx lr
entry:
  store <8 x bfloat> %v, ptr %addr, align 8
  ret void
}


