; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-- | FileCheck %s --check-prefixes=SSE2
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-- -mattr=+ssse3 | FileCheck %s --check-prefixes=SSSE3
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-- -mattr=+sse4.2 | FileCheck %s --check-prefixes=SSE42
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-- -mattr=+avx | FileCheck %s --check-prefixes=AVX1
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-- -mattr=+avx2 | FileCheck %s --check-prefixes=AVX2
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-- -mattr=+avx512f | FileCheck %s --check-prefixes=AVX512F
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-- -mattr=+avx512f,+avx512bw | FileCheck %s --check-prefixes=AVX512BW
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-- -mattr=+avx512f,+avx512dq | FileCheck %s --check-prefixes=AVX512DQ
;
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-- -mcpu=slm | FileCheck %s --check-prefixes=SLM
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-- -mcpu=goldmont | FileCheck %s --check-prefixes=GLM
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-- -mcpu=btver2 | FileCheck %s --check-prefixes=BTVER2

declare i64        @llvm.sadd.sat.i64(i64, i64)
declare <2 x i64>  @llvm.sadd.sat.v2i64(<2 x i64>, <2 x i64>)
declare <4 x i64>  @llvm.sadd.sat.v4i64(<4 x i64>, <4 x i64>)
declare <8 x i64>  @llvm.sadd.sat.v8i64(<8 x i64>, <8 x i64>)

declare i32        @llvm.sadd.sat.i32(i32, i32)
declare <4 x i32>  @llvm.sadd.sat.v4i32(<4 x i32>, <4 x i32>)
declare <8 x i32>  @llvm.sadd.sat.v8i32(<8 x i32>, <8 x i32>)
declare <16 x i32> @llvm.sadd.sat.v16i32(<16 x i32>, <16 x i32>)

declare i16        @llvm.sadd.sat.i16(i16, i16)
declare <8 x i16>  @llvm.sadd.sat.v8i16(<8 x i16>, <8 x i16>)
declare <16 x i16> @llvm.sadd.sat.v16i16(<16 x i16>, <16 x i16>)
declare <32 x i16> @llvm.sadd.sat.v32i16(<32 x i16>, <32 x i16>)

declare i8         @llvm.sadd.sat.i8(i8,  i8)
declare <16 x i8>  @llvm.sadd.sat.v16i8(<16 x i8>, <16 x i8>)
declare <32 x i8>  @llvm.sadd.sat.v32i8(<32 x i8>, <32 x i8>)
declare <64 x i8>  @llvm.sadd.sat.v64i8(<64 x i8>, <64 x i8>)

define i32 @add(i32 %arg) {
; SSE2-LABEL: 'add'
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:7 Lat:4 SizeLat:10 for: %I64 = call i64 @llvm.sadd.sat.i64(i64 undef, i64 undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:24 Lat:14 SizeLat:24 for: %V2I64 = call <2 x i64> @llvm.sadd.sat.v2i64(<2 x i64> undef, <2 x i64> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:48 Lat:28 SizeLat:48 for: %V4I64 = call <4 x i64> @llvm.sadd.sat.v4i64(<4 x i64> undef, <4 x i64> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:96 Lat:56 SizeLat:96 for: %V8I64 = call <8 x i64> @llvm.sadd.sat.v8i64(<8 x i64> undef, <8 x i64> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:6 Lat:4 SizeLat:9 for: %I32 = call i32 @llvm.sadd.sat.i32(i32 undef, i32 undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:11 Lat:11 SizeLat:12 for: %V4I32 = call <4 x i32> @llvm.sadd.sat.v4i32(<4 x i32> undef, <4 x i32> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:22 Lat:22 SizeLat:24 for: %V8I32 = call <8 x i32> @llvm.sadd.sat.v8i32(<8 x i32> undef, <8 x i32> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:44 Lat:44 SizeLat:48 for: %V16I32 = call <16 x i32> @llvm.sadd.sat.v16i32(<16 x i32> undef, <16 x i32> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:7 Lat:4 SizeLat:10 for: %I16 = call i16 @llvm.sadd.sat.i16(i16 undef, i16 undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V8I16 = call <8 x i16> @llvm.sadd.sat.v8i16(<8 x i16> undef, <8 x i16> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:2 for: %V16I16 = call <16 x i16> @llvm.sadd.sat.v16i16(<16 x i16> undef, <16 x i16> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:4 for: %V32I16 = call <32 x i16> @llvm.sadd.sat.v32i16(<32 x i16> undef, <32 x i16> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:8 Lat:5 SizeLat:11 for: %I8 = call i8 @llvm.sadd.sat.i8(i8 undef, i8 undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V16I8 = call <16 x i8> @llvm.sadd.sat.v16i8(<16 x i8> undef, <16 x i8> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:2 for: %V32I8 = call <32 x i8> @llvm.sadd.sat.v32i8(<32 x i8> undef, <32 x i8> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:4 for: %V64I8 = call <64 x i8> @llvm.sadd.sat.v64i8(<64 x i8> undef, <64 x i8> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSSE3-LABEL: 'add'
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:7 Lat:4 SizeLat:10 for: %I64 = call i64 @llvm.sadd.sat.i64(i64 undef, i64 undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:24 Lat:14 SizeLat:24 for: %V2I64 = call <2 x i64> @llvm.sadd.sat.v2i64(<2 x i64> undef, <2 x i64> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:48 Lat:28 SizeLat:48 for: %V4I64 = call <4 x i64> @llvm.sadd.sat.v4i64(<4 x i64> undef, <4 x i64> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:96 Lat:56 SizeLat:96 for: %V8I64 = call <8 x i64> @llvm.sadd.sat.v8i64(<8 x i64> undef, <8 x i64> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:6 Lat:4 SizeLat:9 for: %I32 = call i32 @llvm.sadd.sat.i32(i32 undef, i32 undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:11 Lat:11 SizeLat:12 for: %V4I32 = call <4 x i32> @llvm.sadd.sat.v4i32(<4 x i32> undef, <4 x i32> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:22 Lat:22 SizeLat:24 for: %V8I32 = call <8 x i32> @llvm.sadd.sat.v8i32(<8 x i32> undef, <8 x i32> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:44 Lat:44 SizeLat:48 for: %V16I32 = call <16 x i32> @llvm.sadd.sat.v16i32(<16 x i32> undef, <16 x i32> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:7 Lat:4 SizeLat:10 for: %I16 = call i16 @llvm.sadd.sat.i16(i16 undef, i16 undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V8I16 = call <8 x i16> @llvm.sadd.sat.v8i16(<8 x i16> undef, <8 x i16> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:2 for: %V16I16 = call <16 x i16> @llvm.sadd.sat.v16i16(<16 x i16> undef, <16 x i16> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:4 for: %V32I16 = call <32 x i16> @llvm.sadd.sat.v32i16(<32 x i16> undef, <32 x i16> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:8 Lat:5 SizeLat:11 for: %I8 = call i8 @llvm.sadd.sat.i8(i8 undef, i8 undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V16I8 = call <16 x i8> @llvm.sadd.sat.v16i8(<16 x i8> undef, <16 x i8> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:2 for: %V32I8 = call <32 x i8> @llvm.sadd.sat.v32i8(<32 x i8> undef, <32 x i8> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:4 for: %V64I8 = call <64 x i8> @llvm.sadd.sat.v64i8(<64 x i8> undef, <64 x i8> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'add'
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:7 Lat:4 SizeLat:10 for: %I64 = call i64 @llvm.sadd.sat.i64(i64 undef, i64 undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:17 Lat:14 SizeLat:21 for: %V2I64 = call <2 x i64> @llvm.sadd.sat.v2i64(<2 x i64> undef, <2 x i64> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:34 Lat:28 SizeLat:42 for: %V4I64 = call <4 x i64> @llvm.sadd.sat.v4i64(<4 x i64> undef, <4 x i64> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:68 Lat:56 SizeLat:84 for: %V8I64 = call <8 x i64> @llvm.sadd.sat.v8i64(<8 x i64> undef, <8 x i64> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:6 Lat:4 SizeLat:9 for: %I32 = call i32 @llvm.sadd.sat.i32(i32 undef, i32 undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:8 Lat:11 SizeLat:10 for: %V4I32 = call <4 x i32> @llvm.sadd.sat.v4i32(<4 x i32> undef, <4 x i32> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:16 Lat:22 SizeLat:20 for: %V8I32 = call <8 x i32> @llvm.sadd.sat.v8i32(<8 x i32> undef, <8 x i32> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:32 Lat:44 SizeLat:40 for: %V16I32 = call <16 x i32> @llvm.sadd.sat.v16i32(<16 x i32> undef, <16 x i32> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:7 Lat:4 SizeLat:10 for: %I16 = call i16 @llvm.sadd.sat.i16(i16 undef, i16 undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V8I16 = call <8 x i16> @llvm.sadd.sat.v8i16(<8 x i16> undef, <8 x i16> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:2 for: %V16I16 = call <16 x i16> @llvm.sadd.sat.v16i16(<16 x i16> undef, <16 x i16> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:4 for: %V32I16 = call <32 x i16> @llvm.sadd.sat.v32i16(<32 x i16> undef, <32 x i16> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:8 Lat:5 SizeLat:11 for: %I8 = call i8 @llvm.sadd.sat.i8(i8 undef, i8 undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V16I8 = call <16 x i8> @llvm.sadd.sat.v16i8(<16 x i8> undef, <16 x i8> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:2 for: %V32I8 = call <32 x i8> @llvm.sadd.sat.v32i8(<32 x i8> undef, <32 x i8> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:4 for: %V64I8 = call <64 x i8> @llvm.sadd.sat.v64i8(<64 x i8> undef, <64 x i8> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'add'
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:7 Lat:4 SizeLat:10 for: %I64 = call i64 @llvm.sadd.sat.i64(i64 undef, i64 undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:8 Lat:13 SizeLat:11 for: %V2I64 = call <2 x i64> @llvm.sadd.sat.v2i64(<2 x i64> undef, <2 x i64> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:13 CodeSize:15 Lat:20 SizeLat:25 for: %V4I64 = call <4 x i64> @llvm.sadd.sat.v4i64(<4 x i64> undef, <4 x i64> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:26 CodeSize:30 Lat:40 SizeLat:50 for: %V8I64 = call <8 x i64> @llvm.sadd.sat.v8i64(<8 x i64> undef, <8 x i64> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:6 Lat:4 SizeLat:9 for: %I32 = call i32 @llvm.sadd.sat.i32(i32 undef, i32 undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:8 Lat:11 SizeLat:10 for: %V4I32 = call <4 x i32> @llvm.sadd.sat.v4i32(<4 x i32> undef, <4 x i32> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:14 Lat:18 SizeLat:24 for: %V8I32 = call <8 x i32> @llvm.sadd.sat.v8i32(<8 x i32> undef, <8 x i32> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:28 Lat:36 SizeLat:48 for: %V16I32 = call <16 x i32> @llvm.sadd.sat.v16i32(<16 x i32> undef, <16 x i32> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:7 Lat:4 SizeLat:10 for: %I16 = call i16 @llvm.sadd.sat.i16(i16 undef, i16 undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V8I16 = call <8 x i16> @llvm.sadd.sat.v8i16(<8 x i16> undef, <8 x i16> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:3 SizeLat:6 for: %V16I16 = call <16 x i16> @llvm.sadd.sat.v16i16(<16 x i16> undef, <16 x i16> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:10 Lat:6 SizeLat:12 for: %V32I16 = call <32 x i16> @llvm.sadd.sat.v32i16(<32 x i16> undef, <32 x i16> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:8 Lat:5 SizeLat:11 for: %I8 = call i8 @llvm.sadd.sat.i8(i8 undef, i8 undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V16I8 = call <16 x i8> @llvm.sadd.sat.v16i8(<16 x i8> undef, <16 x i8> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:3 SizeLat:6 for: %V32I8 = call <32 x i8> @llvm.sadd.sat.v32i8(<32 x i8> undef, <32 x i8> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:10 Lat:6 SizeLat:12 for: %V64I8 = call <64 x i8> @llvm.sadd.sat.v64i8(<64 x i8> undef, <64 x i8> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'add'
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:7 Lat:4 SizeLat:10 for: %I64 = call i64 @llvm.sadd.sat.i64(i64 undef, i64 undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:8 Lat:13 SizeLat:11 for: %V2I64 = call <2 x i64> @llvm.sadd.sat.v2i64(<2 x i64> undef, <2 x i64> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:8 Lat:10 SizeLat:12 for: %V4I64 = call <4 x i64> @llvm.sadd.sat.v4i64(<4 x i64> undef, <4 x i64> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:16 Lat:20 SizeLat:24 for: %V8I64 = call <8 x i64> @llvm.sadd.sat.v8i64(<8 x i64> undef, <8 x i64> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:6 Lat:4 SizeLat:9 for: %I32 = call i32 @llvm.sadd.sat.i32(i32 undef, i32 undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:7 Lat:6 SizeLat:9 for: %V4I32 = call <4 x i32> @llvm.sadd.sat.v4i32(<4 x i32> undef, <4 x i32> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:7 Lat:6 SizeLat:13 for: %V8I32 = call <8 x i32> @llvm.sadd.sat.v8i32(<8 x i32> undef, <8 x i32> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:14 Lat:12 SizeLat:26 for: %V16I32 = call <16 x i32> @llvm.sadd.sat.v16i32(<16 x i32> undef, <16 x i32> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:7 Lat:4 SizeLat:10 for: %I16 = call i16 @llvm.sadd.sat.i16(i16 undef, i16 undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V8I16 = call <8 x i16> @llvm.sadd.sat.v8i16(<8 x i16> undef, <8 x i16> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V16I16 = call <16 x i16> @llvm.sadd.sat.v16i16(<16 x i16> undef, <16 x i16> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V32I16 = call <32 x i16> @llvm.sadd.sat.v32i16(<32 x i16> undef, <32 x i16> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:8 Lat:5 SizeLat:11 for: %I8 = call i8 @llvm.sadd.sat.i8(i8 undef, i8 undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V16I8 = call <16 x i8> @llvm.sadd.sat.v16i8(<16 x i8> undef, <16 x i8> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I8 = call <32 x i8> @llvm.sadd.sat.v32i8(<32 x i8> undef, <32 x i8> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V64I8 = call <64 x i8> @llvm.sadd.sat.v64i8(<64 x i8> undef, <64 x i8> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512F-LABEL: 'add'
; AVX512F-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:7 Lat:4 SizeLat:10 for: %I64 = call i64 @llvm.sadd.sat.i64(i64 undef, i64 undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:8 Lat:3 SizeLat:9 for: %V2I64 = call <2 x i64> @llvm.sadd.sat.v2i64(<2 x i64> undef, <2 x i64> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:6 Lat:2 SizeLat:7 for: %V4I64 = call <4 x i64> @llvm.sadd.sat.v4i64(<4 x i64> undef, <4 x i64> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:6 Lat:3 SizeLat:7 for: %V8I64 = call <8 x i64> @llvm.sadd.sat.v8i64(<8 x i64> undef, <8 x i64> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:6 Lat:4 SizeLat:9 for: %I32 = call i32 @llvm.sadd.sat.i32(i32 undef, i32 undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:6 Lat:2 SizeLat:7 for: %V4I32 = call <4 x i32> @llvm.sadd.sat.v4i32(<4 x i32> undef, <4 x i32> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:6 Lat:2 SizeLat:7 for: %V8I32 = call <8 x i32> @llvm.sadd.sat.v8i32(<8 x i32> undef, <8 x i32> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:6 Lat:3 SizeLat:7 for: %V16I32 = call <16 x i32> @llvm.sadd.sat.v16i32(<16 x i32> undef, <16 x i32> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:7 Lat:4 SizeLat:10 for: %I16 = call i16 @llvm.sadd.sat.i16(i16 undef, i16 undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V8I16 = call <8 x i16> @llvm.sadd.sat.v8i16(<8 x i16> undef, <8 x i16> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V16I16 = call <16 x i16> @llvm.sadd.sat.v16i16(<16 x i16> undef, <16 x i16> undef)
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V32I16 = call <32 x i16> @llvm.sadd.sat.v32i16(<32 x i16> undef, <32 x i16> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:8 Lat:5 SizeLat:11 for: %I8 = call i8 @llvm.sadd.sat.i8(i8 undef, i8 undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V16I8 = call <16 x i8> @llvm.sadd.sat.v16i8(<16 x i8> undef, <16 x i8> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I8 = call <32 x i8> @llvm.sadd.sat.v32i8(<32 x i8> undef, <32 x i8> undef)
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V64I8 = call <64 x i8> @llvm.sadd.sat.v64i8(<64 x i8> undef, <64 x i8> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512BW-LABEL: 'add'
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:7 Lat:4 SizeLat:10 for: %I64 = call i64 @llvm.sadd.sat.i64(i64 undef, i64 undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:8 Lat:3 SizeLat:9 for: %V2I64 = call <2 x i64> @llvm.sadd.sat.v2i64(<2 x i64> undef, <2 x i64> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:6 Lat:2 SizeLat:7 for: %V4I64 = call <4 x i64> @llvm.sadd.sat.v4i64(<4 x i64> undef, <4 x i64> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:6 Lat:3 SizeLat:7 for: %V8I64 = call <8 x i64> @llvm.sadd.sat.v8i64(<8 x i64> undef, <8 x i64> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:6 Lat:4 SizeLat:9 for: %I32 = call i32 @llvm.sadd.sat.i32(i32 undef, i32 undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:6 Lat:2 SizeLat:7 for: %V4I32 = call <4 x i32> @llvm.sadd.sat.v4i32(<4 x i32> undef, <4 x i32> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:6 Lat:2 SizeLat:7 for: %V8I32 = call <8 x i32> @llvm.sadd.sat.v8i32(<8 x i32> undef, <8 x i32> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:6 Lat:3 SizeLat:7 for: %V16I32 = call <16 x i32> @llvm.sadd.sat.v16i32(<16 x i32> undef, <16 x i32> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:7 Lat:4 SizeLat:10 for: %I16 = call i16 @llvm.sadd.sat.i16(i16 undef, i16 undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V8I16 = call <8 x i16> @llvm.sadd.sat.v8i16(<8 x i16> undef, <8 x i16> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V16I16 = call <16 x i16> @llvm.sadd.sat.v16i16(<16 x i16> undef, <16 x i16> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32I16 = call <32 x i16> @llvm.sadd.sat.v32i16(<32 x i16> undef, <32 x i16> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:8 Lat:5 SizeLat:11 for: %I8 = call i8 @llvm.sadd.sat.i8(i8 undef, i8 undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V16I8 = call <16 x i8> @llvm.sadd.sat.v16i8(<16 x i8> undef, <16 x i8> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I8 = call <32 x i8> @llvm.sadd.sat.v32i8(<32 x i8> undef, <32 x i8> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V64I8 = call <64 x i8> @llvm.sadd.sat.v64i8(<64 x i8> undef, <64 x i8> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512DQ-LABEL: 'add'
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:7 Lat:4 SizeLat:10 for: %I64 = call i64 @llvm.sadd.sat.i64(i64 undef, i64 undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:8 Lat:3 SizeLat:9 for: %V2I64 = call <2 x i64> @llvm.sadd.sat.v2i64(<2 x i64> undef, <2 x i64> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:6 Lat:2 SizeLat:7 for: %V4I64 = call <4 x i64> @llvm.sadd.sat.v4i64(<4 x i64> undef, <4 x i64> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:6 Lat:3 SizeLat:7 for: %V8I64 = call <8 x i64> @llvm.sadd.sat.v8i64(<8 x i64> undef, <8 x i64> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:6 Lat:4 SizeLat:9 for: %I32 = call i32 @llvm.sadd.sat.i32(i32 undef, i32 undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:6 Lat:2 SizeLat:7 for: %V4I32 = call <4 x i32> @llvm.sadd.sat.v4i32(<4 x i32> undef, <4 x i32> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:6 Lat:2 SizeLat:7 for: %V8I32 = call <8 x i32> @llvm.sadd.sat.v8i32(<8 x i32> undef, <8 x i32> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:6 Lat:3 SizeLat:7 for: %V16I32 = call <16 x i32> @llvm.sadd.sat.v16i32(<16 x i32> undef, <16 x i32> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:7 Lat:4 SizeLat:10 for: %I16 = call i16 @llvm.sadd.sat.i16(i16 undef, i16 undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V8I16 = call <8 x i16> @llvm.sadd.sat.v8i16(<8 x i16> undef, <8 x i16> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V16I16 = call <16 x i16> @llvm.sadd.sat.v16i16(<16 x i16> undef, <16 x i16> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of 2 for: %V32I16 = call <32 x i16> @llvm.sadd.sat.v32i16(<32 x i16> undef, <32 x i16> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:8 Lat:5 SizeLat:11 for: %I8 = call i8 @llvm.sadd.sat.i8(i8 undef, i8 undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V16I8 = call <16 x i8> @llvm.sadd.sat.v16i8(<16 x i8> undef, <16 x i8> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I8 = call <32 x i8> @llvm.sadd.sat.v32i8(<32 x i8> undef, <32 x i8> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of 2 for: %V64I8 = call <64 x i8> @llvm.sadd.sat.v64i8(<64 x i8> undef, <64 x i8> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SLM-LABEL: 'add'
; SLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:7 Lat:4 SizeLat:10 for: %I64 = call i64 @llvm.sadd.sat.i64(i64 undef, i64 undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:17 Lat:14 SizeLat:21 for: %V2I64 = call <2 x i64> @llvm.sadd.sat.v2i64(<2 x i64> undef, <2 x i64> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:34 Lat:28 SizeLat:42 for: %V4I64 = call <4 x i64> @llvm.sadd.sat.v4i64(<4 x i64> undef, <4 x i64> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:68 Lat:56 SizeLat:84 for: %V8I64 = call <8 x i64> @llvm.sadd.sat.v8i64(<8 x i64> undef, <8 x i64> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:6 Lat:4 SizeLat:9 for: %I32 = call i32 @llvm.sadd.sat.i32(i32 undef, i32 undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:8 Lat:11 SizeLat:10 for: %V4I32 = call <4 x i32> @llvm.sadd.sat.v4i32(<4 x i32> undef, <4 x i32> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:16 Lat:22 SizeLat:20 for: %V8I32 = call <8 x i32> @llvm.sadd.sat.v8i32(<8 x i32> undef, <8 x i32> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:32 Lat:44 SizeLat:40 for: %V16I32 = call <16 x i32> @llvm.sadd.sat.v16i32(<16 x i32> undef, <16 x i32> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:7 Lat:4 SizeLat:10 for: %I16 = call i16 @llvm.sadd.sat.i16(i16 undef, i16 undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V8I16 = call <8 x i16> @llvm.sadd.sat.v8i16(<8 x i16> undef, <8 x i16> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:2 for: %V16I16 = call <16 x i16> @llvm.sadd.sat.v16i16(<16 x i16> undef, <16 x i16> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:4 for: %V32I16 = call <32 x i16> @llvm.sadd.sat.v32i16(<32 x i16> undef, <32 x i16> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:8 Lat:5 SizeLat:11 for: %I8 = call i8 @llvm.sadd.sat.i8(i8 undef, i8 undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V16I8 = call <16 x i8> @llvm.sadd.sat.v16i8(<16 x i8> undef, <16 x i8> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:2 for: %V32I8 = call <32 x i8> @llvm.sadd.sat.v32i8(<32 x i8> undef, <32 x i8> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:4 for: %V64I8 = call <64 x i8> @llvm.sadd.sat.v64i8(<64 x i8> undef, <64 x i8> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; GLM-LABEL: 'add'
; GLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:7 Lat:4 SizeLat:10 for: %I64 = call i64 @llvm.sadd.sat.i64(i64 undef, i64 undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:17 Lat:14 SizeLat:21 for: %V2I64 = call <2 x i64> @llvm.sadd.sat.v2i64(<2 x i64> undef, <2 x i64> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:34 Lat:28 SizeLat:42 for: %V4I64 = call <4 x i64> @llvm.sadd.sat.v4i64(<4 x i64> undef, <4 x i64> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:68 Lat:56 SizeLat:84 for: %V8I64 = call <8 x i64> @llvm.sadd.sat.v8i64(<8 x i64> undef, <8 x i64> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:6 Lat:4 SizeLat:9 for: %I32 = call i32 @llvm.sadd.sat.i32(i32 undef, i32 undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:8 Lat:11 SizeLat:10 for: %V4I32 = call <4 x i32> @llvm.sadd.sat.v4i32(<4 x i32> undef, <4 x i32> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:16 Lat:22 SizeLat:20 for: %V8I32 = call <8 x i32> @llvm.sadd.sat.v8i32(<8 x i32> undef, <8 x i32> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:32 Lat:44 SizeLat:40 for: %V16I32 = call <16 x i32> @llvm.sadd.sat.v16i32(<16 x i32> undef, <16 x i32> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:7 Lat:4 SizeLat:10 for: %I16 = call i16 @llvm.sadd.sat.i16(i16 undef, i16 undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V8I16 = call <8 x i16> @llvm.sadd.sat.v8i16(<8 x i16> undef, <8 x i16> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:2 for: %V16I16 = call <16 x i16> @llvm.sadd.sat.v16i16(<16 x i16> undef, <16 x i16> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:4 for: %V32I16 = call <32 x i16> @llvm.sadd.sat.v32i16(<32 x i16> undef, <32 x i16> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:8 Lat:5 SizeLat:11 for: %I8 = call i8 @llvm.sadd.sat.i8(i8 undef, i8 undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V16I8 = call <16 x i8> @llvm.sadd.sat.v16i8(<16 x i8> undef, <16 x i8> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:2 for: %V32I8 = call <32 x i8> @llvm.sadd.sat.v32i8(<32 x i8> undef, <32 x i8> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:4 for: %V64I8 = call <64 x i8> @llvm.sadd.sat.v64i8(<64 x i8> undef, <64 x i8> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; BTVER2-LABEL: 'add'
; BTVER2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:7 Lat:4 SizeLat:10 for: %I64 = call i64 @llvm.sadd.sat.i64(i64 undef, i64 undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:8 Lat:13 SizeLat:11 for: %V2I64 = call <2 x i64> @llvm.sadd.sat.v2i64(<2 x i64> undef, <2 x i64> undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:13 CodeSize:15 Lat:20 SizeLat:25 for: %V4I64 = call <4 x i64> @llvm.sadd.sat.v4i64(<4 x i64> undef, <4 x i64> undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:26 CodeSize:30 Lat:40 SizeLat:50 for: %V8I64 = call <8 x i64> @llvm.sadd.sat.v8i64(<8 x i64> undef, <8 x i64> undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:6 Lat:4 SizeLat:9 for: %I32 = call i32 @llvm.sadd.sat.i32(i32 undef, i32 undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:8 Lat:11 SizeLat:10 for: %V4I32 = call <4 x i32> @llvm.sadd.sat.v4i32(<4 x i32> undef, <4 x i32> undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:14 Lat:18 SizeLat:24 for: %V8I32 = call <8 x i32> @llvm.sadd.sat.v8i32(<8 x i32> undef, <8 x i32> undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:28 Lat:36 SizeLat:48 for: %V16I32 = call <16 x i32> @llvm.sadd.sat.v16i32(<16 x i32> undef, <16 x i32> undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:7 Lat:4 SizeLat:10 for: %I16 = call i16 @llvm.sadd.sat.i16(i16 undef, i16 undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V8I16 = call <8 x i16> @llvm.sadd.sat.v8i16(<8 x i16> undef, <8 x i16> undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:3 SizeLat:6 for: %V16I16 = call <16 x i16> @llvm.sadd.sat.v16i16(<16 x i16> undef, <16 x i16> undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:10 Lat:6 SizeLat:12 for: %V32I16 = call <32 x i16> @llvm.sadd.sat.v32i16(<32 x i16> undef, <32 x i16> undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:8 Lat:5 SizeLat:11 for: %I8 = call i8 @llvm.sadd.sat.i8(i8 undef, i8 undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V16I8 = call <16 x i8> @llvm.sadd.sat.v16i8(<16 x i8> undef, <16 x i8> undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:3 SizeLat:6 for: %V32I8 = call <32 x i8> @llvm.sadd.sat.v32i8(<32 x i8> undef, <32 x i8> undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:10 Lat:6 SizeLat:12 for: %V64I8 = call <64 x i8> @llvm.sadd.sat.v64i8(<64 x i8> undef, <64 x i8> undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %I64 = call i64 @llvm.sadd.sat.i64(i64 undef, i64 undef)
  %V2I64 = call <2 x i64> @llvm.sadd.sat.v2i64(<2 x i64> undef, <2 x i64> undef)
  %V4I64 = call <4 x i64> @llvm.sadd.sat.v4i64(<4 x i64> undef, <4 x i64> undef)
  %V8I64 = call <8 x i64> @llvm.sadd.sat.v8i64(<8 x i64> undef, <8 x i64> undef)

  %I32 = call i32 @llvm.sadd.sat.i32(i32 undef, i32 undef)
  %V4I32  = call <4 x i32>  @llvm.sadd.sat.v4i32(<4 x i32> undef, <4 x i32> undef)
  %V8I32  = call <8 x i32>  @llvm.sadd.sat.v8i32(<8 x i32> undef, <8 x i32> undef)
  %V16I32 = call <16 x i32> @llvm.sadd.sat.v16i32(<16 x i32> undef, <16 x i32> undef)

  %I16 = call i16 @llvm.sadd.sat.i16(i16 undef, i16 undef)
  %V8I16  = call <8 x i16>  @llvm.sadd.sat.v8i16(<8 x i16> undef, <8 x i16> undef)
  %V16I16 = call <16 x i16> @llvm.sadd.sat.v16i16(<16 x i16> undef, <16 x i16> undef)
  %V32I16 = call <32 x i16> @llvm.sadd.sat.v32i16(<32 x i16> undef, <32 x i16> undef)

  %I8 = call i8 @llvm.sadd.sat.i8(i8 undef, i8 undef)
  %V16I8 = call <16 x i8> @llvm.sadd.sat.v16i8(<16 x i8> undef, <16 x i8> undef)
  %V32I8 = call <32 x i8> @llvm.sadd.sat.v32i8(<32 x i8> undef, <32 x i8> undef)
  %V64I8 = call <64 x i8> @llvm.sadd.sat.v64i8(<64 x i8> undef, <64 x i8> undef)

  ret i32 undef
}

declare i64        @llvm.ssub.sat.i64(i64, i64)
declare <2 x i64>  @llvm.ssub.sat.v2i64(<2 x i64>, <2 x i64>)
declare <4 x i64>  @llvm.ssub.sat.v4i64(<4 x i64>, <4 x i64>)
declare <8 x i64>  @llvm.ssub.sat.v8i64(<8 x i64>, <8 x i64>)

declare i32        @llvm.ssub.sat.i32(i32, i32)
declare <4 x i32>  @llvm.ssub.sat.v4i32(<4 x i32>, <4 x i32>)
declare <8 x i32>  @llvm.ssub.sat.v8i32(<8 x i32>, <8 x i32>)
declare <16 x i32> @llvm.ssub.sat.v16i32(<16 x i32>, <16 x i32>)

declare i16        @llvm.ssub.sat.i16(i16, i16)
declare <8 x i16>  @llvm.ssub.sat.v8i16(<8 x i16>, <8 x i16>)
declare <16 x i16> @llvm.ssub.sat.v16i16(<16 x i16>, <16 x i16>)
declare <32 x i16> @llvm.ssub.sat.v32i16(<32 x i16>, <32 x i16>)

declare i8         @llvm.ssub.sat.i8(i8,  i8)
declare <16 x i8>  @llvm.ssub.sat.v16i8(<16 x i8>, <16 x i8>)
declare <32 x i8>  @llvm.ssub.sat.v32i8(<32 x i8>, <32 x i8>)
declare <64 x i8>  @llvm.ssub.sat.v64i8(<64 x i8>, <64 x i8>)

define i32 @sub(i32 %arg) {
; SSE2-LABEL: 'sub'
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:8 Lat:5 SizeLat:11 for: %I64 = call i64 @llvm.ssub.sat.i64(i64 undef, i64 undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:31 Lat:19 SizeLat:31 for: %V2I64 = call <2 x i64> @llvm.ssub.sat.v2i64(<2 x i64> undef, <2 x i64> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:62 Lat:38 SizeLat:62 for: %V4I64 = call <4 x i64> @llvm.ssub.sat.v4i64(<4 x i64> undef, <4 x i64> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:124 Lat:76 SizeLat:124 for: %V8I64 = call <8 x i64> @llvm.ssub.sat.v8i64(<8 x i64> undef, <8 x i64> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:7 Lat:4 SizeLat:10 for: %I32 = call i32 @llvm.ssub.sat.i32(i32 undef, i32 undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:12 Lat:14 SizeLat:13 for: %V4I32 = call <4 x i32> @llvm.ssub.sat.v4i32(<4 x i32> undef, <4 x i32> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:24 Lat:28 SizeLat:26 for: %V8I32 = call <8 x i32> @llvm.ssub.sat.v8i32(<8 x i32> undef, <8 x i32> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:48 Lat:56 SizeLat:52 for: %V16I32 = call <16 x i32> @llvm.ssub.sat.v16i32(<16 x i32> undef, <16 x i32> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:7 Lat:4 SizeLat:10 for: %I16 = call i16 @llvm.ssub.sat.i16(i16 undef, i16 undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V8I16 = call <8 x i16> @llvm.ssub.sat.v8i16(<8 x i16> undef, <8 x i16> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:2 for: %V16I16 = call <16 x i16> @llvm.ssub.sat.v16i16(<16 x i16> undef, <16 x i16> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:4 for: %V32I16 = call <32 x i16> @llvm.ssub.sat.v32i16(<32 x i16> undef, <32 x i16> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:8 Lat:5 SizeLat:11 for: %I8 = call i8 @llvm.ssub.sat.i8(i8 undef, i8 undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V16I8 = call <16 x i8> @llvm.ssub.sat.v16i8(<16 x i8> undef, <16 x i8> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:2 for: %V32I8 = call <32 x i8> @llvm.ssub.sat.v32i8(<32 x i8> undef, <32 x i8> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:4 for: %V64I8 = call <64 x i8> @llvm.ssub.sat.v64i8(<64 x i8> undef, <64 x i8> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSSE3-LABEL: 'sub'
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:8 Lat:5 SizeLat:11 for: %I64 = call i64 @llvm.ssub.sat.i64(i64 undef, i64 undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:31 Lat:19 SizeLat:31 for: %V2I64 = call <2 x i64> @llvm.ssub.sat.v2i64(<2 x i64> undef, <2 x i64> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:62 Lat:38 SizeLat:62 for: %V4I64 = call <4 x i64> @llvm.ssub.sat.v4i64(<4 x i64> undef, <4 x i64> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:124 Lat:76 SizeLat:124 for: %V8I64 = call <8 x i64> @llvm.ssub.sat.v8i64(<8 x i64> undef, <8 x i64> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:7 Lat:4 SizeLat:10 for: %I32 = call i32 @llvm.ssub.sat.i32(i32 undef, i32 undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:12 Lat:14 SizeLat:13 for: %V4I32 = call <4 x i32> @llvm.ssub.sat.v4i32(<4 x i32> undef, <4 x i32> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:24 Lat:28 SizeLat:26 for: %V8I32 = call <8 x i32> @llvm.ssub.sat.v8i32(<8 x i32> undef, <8 x i32> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:48 Lat:56 SizeLat:52 for: %V16I32 = call <16 x i32> @llvm.ssub.sat.v16i32(<16 x i32> undef, <16 x i32> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:7 Lat:4 SizeLat:10 for: %I16 = call i16 @llvm.ssub.sat.i16(i16 undef, i16 undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V8I16 = call <8 x i16> @llvm.ssub.sat.v8i16(<8 x i16> undef, <8 x i16> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:2 for: %V16I16 = call <16 x i16> @llvm.ssub.sat.v16i16(<16 x i16> undef, <16 x i16> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:4 for: %V32I16 = call <32 x i16> @llvm.ssub.sat.v32i16(<32 x i16> undef, <32 x i16> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:8 Lat:5 SizeLat:11 for: %I8 = call i8 @llvm.ssub.sat.i8(i8 undef, i8 undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V16I8 = call <16 x i8> @llvm.ssub.sat.v16i8(<16 x i8> undef, <16 x i8> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:2 for: %V32I8 = call <32 x i8> @llvm.ssub.sat.v32i8(<32 x i8> undef, <32 x i8> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:4 for: %V64I8 = call <64 x i8> @llvm.ssub.sat.v64i8(<64 x i8> undef, <64 x i8> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'sub'
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:8 Lat:5 SizeLat:11 for: %I64 = call i64 @llvm.ssub.sat.i64(i64 undef, i64 undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:25 Lat:19 SizeLat:29 for: %V2I64 = call <2 x i64> @llvm.ssub.sat.v2i64(<2 x i64> undef, <2 x i64> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:50 Lat:38 SizeLat:58 for: %V4I64 = call <4 x i64> @llvm.ssub.sat.v4i64(<4 x i64> undef, <4 x i64> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:100 Lat:76 SizeLat:116 for: %V8I64 = call <8 x i64> @llvm.ssub.sat.v8i64(<8 x i64> undef, <8 x i64> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:7 Lat:4 SizeLat:10 for: %I32 = call i32 @llvm.ssub.sat.i32(i32 undef, i32 undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:10 Lat:14 SizeLat:12 for: %V4I32 = call <4 x i32> @llvm.ssub.sat.v4i32(<4 x i32> undef, <4 x i32> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:20 Lat:28 SizeLat:24 for: %V8I32 = call <8 x i32> @llvm.ssub.sat.v8i32(<8 x i32> undef, <8 x i32> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:40 Lat:56 SizeLat:48 for: %V16I32 = call <16 x i32> @llvm.ssub.sat.v16i32(<16 x i32> undef, <16 x i32> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:7 Lat:4 SizeLat:10 for: %I16 = call i16 @llvm.ssub.sat.i16(i16 undef, i16 undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V8I16 = call <8 x i16> @llvm.ssub.sat.v8i16(<8 x i16> undef, <8 x i16> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:2 for: %V16I16 = call <16 x i16> @llvm.ssub.sat.v16i16(<16 x i16> undef, <16 x i16> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:4 for: %V32I16 = call <32 x i16> @llvm.ssub.sat.v32i16(<32 x i16> undef, <32 x i16> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:8 Lat:5 SizeLat:11 for: %I8 = call i8 @llvm.ssub.sat.i8(i8 undef, i8 undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V16I8 = call <16 x i8> @llvm.ssub.sat.v16i8(<16 x i8> undef, <16 x i8> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:2 for: %V32I8 = call <32 x i8> @llvm.ssub.sat.v32i8(<32 x i8> undef, <32 x i8> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:4 for: %V64I8 = call <64 x i8> @llvm.ssub.sat.v64i8(<64 x i8> undef, <64 x i8> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'sub'
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:8 Lat:5 SizeLat:11 for: %I64 = call i64 @llvm.ssub.sat.i64(i64 undef, i64 undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:9 Lat:13 SizeLat:13 for: %V2I64 = call <2 x i64> @llvm.ssub.sat.v2i64(<2 x i64> undef, <2 x i64> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:15 CodeSize:18 Lat:21 SizeLat:29 for: %V4I64 = call <4 x i64> @llvm.ssub.sat.v4i64(<4 x i64> undef, <4 x i64> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:30 CodeSize:36 Lat:42 SizeLat:58 for: %V8I64 = call <8 x i64> @llvm.ssub.sat.v8i64(<8 x i64> undef, <8 x i64> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:7 Lat:4 SizeLat:10 for: %I32 = call i32 @llvm.ssub.sat.i32(i32 undef, i32 undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:10 Lat:14 SizeLat:12 for: %V4I32 = call <4 x i32> @llvm.ssub.sat.v4i32(<4 x i32> undef, <4 x i32> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:15 CodeSize:18 Lat:19 SizeLat:29 for: %V8I32 = call <8 x i32> @llvm.ssub.sat.v8i32(<8 x i32> undef, <8 x i32> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:30 CodeSize:36 Lat:38 SizeLat:58 for: %V16I32 = call <16 x i32> @llvm.ssub.sat.v16i32(<16 x i32> undef, <16 x i32> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:7 Lat:4 SizeLat:10 for: %I16 = call i16 @llvm.ssub.sat.i16(i16 undef, i16 undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V8I16 = call <8 x i16> @llvm.ssub.sat.v8i16(<8 x i16> undef, <8 x i16> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:3 SizeLat:6 for: %V16I16 = call <16 x i16> @llvm.ssub.sat.v16i16(<16 x i16> undef, <16 x i16> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:10 Lat:6 SizeLat:12 for: %V32I16 = call <32 x i16> @llvm.ssub.sat.v32i16(<32 x i16> undef, <32 x i16> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:8 Lat:5 SizeLat:11 for: %I8 = call i8 @llvm.ssub.sat.i8(i8 undef, i8 undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V16I8 = call <16 x i8> @llvm.ssub.sat.v16i8(<16 x i8> undef, <16 x i8> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:3 SizeLat:6 for: %V32I8 = call <32 x i8> @llvm.ssub.sat.v32i8(<32 x i8> undef, <32 x i8> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:10 Lat:6 SizeLat:12 for: %V64I8 = call <64 x i8> @llvm.ssub.sat.v64i8(<64 x i8> undef, <64 x i8> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'sub'
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:8 Lat:5 SizeLat:11 for: %I64 = call i64 @llvm.ssub.sat.i64(i64 undef, i64 undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:9 Lat:13 SizeLat:13 for: %V2I64 = call <2 x i64> @llvm.ssub.sat.v2i64(<2 x i64> undef, <2 x i64> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:9 Lat:15 SizeLat:13 for: %V4I64 = call <4 x i64> @llvm.ssub.sat.v4i64(<4 x i64> undef, <4 x i64> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:18 Lat:30 SizeLat:26 for: %V8I64 = call <8 x i64> @llvm.ssub.sat.v8i64(<8 x i64> undef, <8 x i64> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:7 Lat:4 SizeLat:10 for: %I32 = call i32 @llvm.ssub.sat.i32(i32 undef, i32 undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:9 Lat:14 SizeLat:11 for: %V4I32 = call <4 x i32> @llvm.ssub.sat.v4i32(<4 x i32> undef, <4 x i32> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:9 Lat:15 SizeLat:16 for: %V8I32 = call <8 x i32> @llvm.ssub.sat.v8i32(<8 x i32> undef, <8 x i32> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:18 Lat:30 SizeLat:32 for: %V16I32 = call <16 x i32> @llvm.ssub.sat.v16i32(<16 x i32> undef, <16 x i32> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:7 Lat:4 SizeLat:10 for: %I16 = call i16 @llvm.ssub.sat.i16(i16 undef, i16 undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V8I16 = call <8 x i16> @llvm.ssub.sat.v8i16(<8 x i16> undef, <8 x i16> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V16I16 = call <16 x i16> @llvm.ssub.sat.v16i16(<16 x i16> undef, <16 x i16> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V32I16 = call <32 x i16> @llvm.ssub.sat.v32i16(<32 x i16> undef, <32 x i16> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:8 Lat:5 SizeLat:11 for: %I8 = call i8 @llvm.ssub.sat.i8(i8 undef, i8 undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V16I8 = call <16 x i8> @llvm.ssub.sat.v16i8(<16 x i8> undef, <16 x i8> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I8 = call <32 x i8> @llvm.ssub.sat.v32i8(<32 x i8> undef, <32 x i8> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V64I8 = call <64 x i8> @llvm.ssub.sat.v64i8(<64 x i8> undef, <64 x i8> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512F-LABEL: 'sub'
; AVX512F-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:8 Lat:5 SizeLat:11 for: %I64 = call i64 @llvm.ssub.sat.i64(i64 undef, i64 undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:9 Lat:13 SizeLat:10 for: %V2I64 = call <2 x i64> @llvm.ssub.sat.v2i64(<2 x i64> undef, <2 x i64> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:7 Lat:15 SizeLat:8 for: %V4I64 = call <4 x i64> @llvm.ssub.sat.v4i64(<4 x i64> undef, <4 x i64> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:7 Lat:14 SizeLat:8 for: %V8I64 = call <8 x i64> @llvm.ssub.sat.v8i64(<8 x i64> undef, <8 x i64> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:7 Lat:4 SizeLat:10 for: %I32 = call i32 @llvm.ssub.sat.i32(i32 undef, i32 undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:7 Lat:14 SizeLat:8 for: %V4I32 = call <4 x i32> @llvm.ssub.sat.v4i32(<4 x i32> undef, <4 x i32> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:7 Lat:15 SizeLat:8 for: %V8I32 = call <8 x i32> @llvm.ssub.sat.v8i32(<8 x i32> undef, <8 x i32> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:7 Lat:14 SizeLat:8 for: %V16I32 = call <16 x i32> @llvm.ssub.sat.v16i32(<16 x i32> undef, <16 x i32> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:7 Lat:4 SizeLat:10 for: %I16 = call i16 @llvm.ssub.sat.i16(i16 undef, i16 undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V8I16 = call <8 x i16> @llvm.ssub.sat.v8i16(<8 x i16> undef, <8 x i16> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V16I16 = call <16 x i16> @llvm.ssub.sat.v16i16(<16 x i16> undef, <16 x i16> undef)
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V32I16 = call <32 x i16> @llvm.ssub.sat.v32i16(<32 x i16> undef, <32 x i16> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:8 Lat:5 SizeLat:11 for: %I8 = call i8 @llvm.ssub.sat.i8(i8 undef, i8 undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V16I8 = call <16 x i8> @llvm.ssub.sat.v16i8(<16 x i8> undef, <16 x i8> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I8 = call <32 x i8> @llvm.ssub.sat.v32i8(<32 x i8> undef, <32 x i8> undef)
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V64I8 = call <64 x i8> @llvm.ssub.sat.v64i8(<64 x i8> undef, <64 x i8> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512BW-LABEL: 'sub'
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:8 Lat:5 SizeLat:11 for: %I64 = call i64 @llvm.ssub.sat.i64(i64 undef, i64 undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:9 Lat:13 SizeLat:10 for: %V2I64 = call <2 x i64> @llvm.ssub.sat.v2i64(<2 x i64> undef, <2 x i64> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:7 Lat:15 SizeLat:8 for: %V4I64 = call <4 x i64> @llvm.ssub.sat.v4i64(<4 x i64> undef, <4 x i64> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:7 Lat:14 SizeLat:8 for: %V8I64 = call <8 x i64> @llvm.ssub.sat.v8i64(<8 x i64> undef, <8 x i64> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:7 Lat:4 SizeLat:10 for: %I32 = call i32 @llvm.ssub.sat.i32(i32 undef, i32 undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:7 Lat:14 SizeLat:8 for: %V4I32 = call <4 x i32> @llvm.ssub.sat.v4i32(<4 x i32> undef, <4 x i32> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:7 Lat:15 SizeLat:8 for: %V8I32 = call <8 x i32> @llvm.ssub.sat.v8i32(<8 x i32> undef, <8 x i32> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:7 Lat:14 SizeLat:8 for: %V16I32 = call <16 x i32> @llvm.ssub.sat.v16i32(<16 x i32> undef, <16 x i32> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:7 Lat:4 SizeLat:10 for: %I16 = call i16 @llvm.ssub.sat.i16(i16 undef, i16 undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V8I16 = call <8 x i16> @llvm.ssub.sat.v8i16(<8 x i16> undef, <8 x i16> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V16I16 = call <16 x i16> @llvm.ssub.sat.v16i16(<16 x i16> undef, <16 x i16> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32I16 = call <32 x i16> @llvm.ssub.sat.v32i16(<32 x i16> undef, <32 x i16> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:8 Lat:5 SizeLat:11 for: %I8 = call i8 @llvm.ssub.sat.i8(i8 undef, i8 undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V16I8 = call <16 x i8> @llvm.ssub.sat.v16i8(<16 x i8> undef, <16 x i8> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I8 = call <32 x i8> @llvm.ssub.sat.v32i8(<32 x i8> undef, <32 x i8> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V64I8 = call <64 x i8> @llvm.ssub.sat.v64i8(<64 x i8> undef, <64 x i8> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512DQ-LABEL: 'sub'
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:8 Lat:5 SizeLat:11 for: %I64 = call i64 @llvm.ssub.sat.i64(i64 undef, i64 undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:9 Lat:13 SizeLat:10 for: %V2I64 = call <2 x i64> @llvm.ssub.sat.v2i64(<2 x i64> undef, <2 x i64> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:7 Lat:15 SizeLat:8 for: %V4I64 = call <4 x i64> @llvm.ssub.sat.v4i64(<4 x i64> undef, <4 x i64> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:7 Lat:14 SizeLat:8 for: %V8I64 = call <8 x i64> @llvm.ssub.sat.v8i64(<8 x i64> undef, <8 x i64> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:7 Lat:4 SizeLat:10 for: %I32 = call i32 @llvm.ssub.sat.i32(i32 undef, i32 undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:7 Lat:14 SizeLat:8 for: %V4I32 = call <4 x i32> @llvm.ssub.sat.v4i32(<4 x i32> undef, <4 x i32> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:7 Lat:15 SizeLat:8 for: %V8I32 = call <8 x i32> @llvm.ssub.sat.v8i32(<8 x i32> undef, <8 x i32> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:7 Lat:14 SizeLat:8 for: %V16I32 = call <16 x i32> @llvm.ssub.sat.v16i32(<16 x i32> undef, <16 x i32> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:7 Lat:4 SizeLat:10 for: %I16 = call i16 @llvm.ssub.sat.i16(i16 undef, i16 undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V8I16 = call <8 x i16> @llvm.ssub.sat.v8i16(<8 x i16> undef, <8 x i16> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V16I16 = call <16 x i16> @llvm.ssub.sat.v16i16(<16 x i16> undef, <16 x i16> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of 2 for: %V32I16 = call <32 x i16> @llvm.ssub.sat.v32i16(<32 x i16> undef, <32 x i16> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:8 Lat:5 SizeLat:11 for: %I8 = call i8 @llvm.ssub.sat.i8(i8 undef, i8 undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V16I8 = call <16 x i8> @llvm.ssub.sat.v16i8(<16 x i8> undef, <16 x i8> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I8 = call <32 x i8> @llvm.ssub.sat.v32i8(<32 x i8> undef, <32 x i8> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of 2 for: %V64I8 = call <64 x i8> @llvm.ssub.sat.v64i8(<64 x i8> undef, <64 x i8> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SLM-LABEL: 'sub'
; SLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:8 Lat:5 SizeLat:11 for: %I64 = call i64 @llvm.ssub.sat.i64(i64 undef, i64 undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:25 Lat:19 SizeLat:29 for: %V2I64 = call <2 x i64> @llvm.ssub.sat.v2i64(<2 x i64> undef, <2 x i64> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:50 Lat:38 SizeLat:58 for: %V4I64 = call <4 x i64> @llvm.ssub.sat.v4i64(<4 x i64> undef, <4 x i64> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:100 Lat:76 SizeLat:116 for: %V8I64 = call <8 x i64> @llvm.ssub.sat.v8i64(<8 x i64> undef, <8 x i64> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:7 Lat:4 SizeLat:10 for: %I32 = call i32 @llvm.ssub.sat.i32(i32 undef, i32 undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:10 Lat:14 SizeLat:12 for: %V4I32 = call <4 x i32> @llvm.ssub.sat.v4i32(<4 x i32> undef, <4 x i32> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:20 Lat:28 SizeLat:24 for: %V8I32 = call <8 x i32> @llvm.ssub.sat.v8i32(<8 x i32> undef, <8 x i32> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:40 Lat:56 SizeLat:48 for: %V16I32 = call <16 x i32> @llvm.ssub.sat.v16i32(<16 x i32> undef, <16 x i32> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:7 Lat:4 SizeLat:10 for: %I16 = call i16 @llvm.ssub.sat.i16(i16 undef, i16 undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V8I16 = call <8 x i16> @llvm.ssub.sat.v8i16(<8 x i16> undef, <8 x i16> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:2 for: %V16I16 = call <16 x i16> @llvm.ssub.sat.v16i16(<16 x i16> undef, <16 x i16> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:4 for: %V32I16 = call <32 x i16> @llvm.ssub.sat.v32i16(<32 x i16> undef, <32 x i16> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:8 Lat:5 SizeLat:11 for: %I8 = call i8 @llvm.ssub.sat.i8(i8 undef, i8 undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V16I8 = call <16 x i8> @llvm.ssub.sat.v16i8(<16 x i8> undef, <16 x i8> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:2 for: %V32I8 = call <32 x i8> @llvm.ssub.sat.v32i8(<32 x i8> undef, <32 x i8> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:4 for: %V64I8 = call <64 x i8> @llvm.ssub.sat.v64i8(<64 x i8> undef, <64 x i8> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; GLM-LABEL: 'sub'
; GLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:8 Lat:5 SizeLat:11 for: %I64 = call i64 @llvm.ssub.sat.i64(i64 undef, i64 undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:25 Lat:19 SizeLat:29 for: %V2I64 = call <2 x i64> @llvm.ssub.sat.v2i64(<2 x i64> undef, <2 x i64> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:50 Lat:38 SizeLat:58 for: %V4I64 = call <4 x i64> @llvm.ssub.sat.v4i64(<4 x i64> undef, <4 x i64> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:100 Lat:76 SizeLat:116 for: %V8I64 = call <8 x i64> @llvm.ssub.sat.v8i64(<8 x i64> undef, <8 x i64> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:7 Lat:4 SizeLat:10 for: %I32 = call i32 @llvm.ssub.sat.i32(i32 undef, i32 undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:10 Lat:14 SizeLat:12 for: %V4I32 = call <4 x i32> @llvm.ssub.sat.v4i32(<4 x i32> undef, <4 x i32> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:20 Lat:28 SizeLat:24 for: %V8I32 = call <8 x i32> @llvm.ssub.sat.v8i32(<8 x i32> undef, <8 x i32> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:40 Lat:56 SizeLat:48 for: %V16I32 = call <16 x i32> @llvm.ssub.sat.v16i32(<16 x i32> undef, <16 x i32> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:7 Lat:4 SizeLat:10 for: %I16 = call i16 @llvm.ssub.sat.i16(i16 undef, i16 undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V8I16 = call <8 x i16> @llvm.ssub.sat.v8i16(<8 x i16> undef, <8 x i16> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:2 for: %V16I16 = call <16 x i16> @llvm.ssub.sat.v16i16(<16 x i16> undef, <16 x i16> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:4 for: %V32I16 = call <32 x i16> @llvm.ssub.sat.v32i16(<32 x i16> undef, <32 x i16> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:8 Lat:5 SizeLat:11 for: %I8 = call i8 @llvm.ssub.sat.i8(i8 undef, i8 undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V16I8 = call <16 x i8> @llvm.ssub.sat.v16i8(<16 x i8> undef, <16 x i8> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:2 for: %V32I8 = call <32 x i8> @llvm.ssub.sat.v32i8(<32 x i8> undef, <32 x i8> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:4 for: %V64I8 = call <64 x i8> @llvm.ssub.sat.v64i8(<64 x i8> undef, <64 x i8> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; BTVER2-LABEL: 'sub'
; BTVER2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:8 Lat:5 SizeLat:11 for: %I64 = call i64 @llvm.ssub.sat.i64(i64 undef, i64 undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:9 Lat:13 SizeLat:13 for: %V2I64 = call <2 x i64> @llvm.ssub.sat.v2i64(<2 x i64> undef, <2 x i64> undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:15 CodeSize:18 Lat:21 SizeLat:29 for: %V4I64 = call <4 x i64> @llvm.ssub.sat.v4i64(<4 x i64> undef, <4 x i64> undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:30 CodeSize:36 Lat:42 SizeLat:58 for: %V8I64 = call <8 x i64> @llvm.ssub.sat.v8i64(<8 x i64> undef, <8 x i64> undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:7 Lat:4 SizeLat:10 for: %I32 = call i32 @llvm.ssub.sat.i32(i32 undef, i32 undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:10 Lat:14 SizeLat:12 for: %V4I32 = call <4 x i32> @llvm.ssub.sat.v4i32(<4 x i32> undef, <4 x i32> undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:15 CodeSize:18 Lat:19 SizeLat:29 for: %V8I32 = call <8 x i32> @llvm.ssub.sat.v8i32(<8 x i32> undef, <8 x i32> undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:30 CodeSize:36 Lat:38 SizeLat:58 for: %V16I32 = call <16 x i32> @llvm.ssub.sat.v16i32(<16 x i32> undef, <16 x i32> undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:7 Lat:4 SizeLat:10 for: %I16 = call i16 @llvm.ssub.sat.i16(i16 undef, i16 undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V8I16 = call <8 x i16> @llvm.ssub.sat.v8i16(<8 x i16> undef, <8 x i16> undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:3 SizeLat:6 for: %V16I16 = call <16 x i16> @llvm.ssub.sat.v16i16(<16 x i16> undef, <16 x i16> undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:10 Lat:6 SizeLat:12 for: %V32I16 = call <32 x i16> @llvm.ssub.sat.v32i16(<32 x i16> undef, <32 x i16> undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:8 Lat:5 SizeLat:11 for: %I8 = call i8 @llvm.ssub.sat.i8(i8 undef, i8 undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V16I8 = call <16 x i8> @llvm.ssub.sat.v16i8(<16 x i8> undef, <16 x i8> undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:3 SizeLat:6 for: %V32I8 = call <32 x i8> @llvm.ssub.sat.v32i8(<32 x i8> undef, <32 x i8> undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:10 Lat:6 SizeLat:12 for: %V64I8 = call <64 x i8> @llvm.ssub.sat.v64i8(<64 x i8> undef, <64 x i8> undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %I64 = call i64 @llvm.ssub.sat.i64(i64 undef, i64 undef)
  %V2I64 = call <2 x i64> @llvm.ssub.sat.v2i64(<2 x i64> undef, <2 x i64> undef)
  %V4I64 = call <4 x i64> @llvm.ssub.sat.v4i64(<4 x i64> undef, <4 x i64> undef)
  %V8I64 = call <8 x i64> @llvm.ssub.sat.v8i64(<8 x i64> undef, <8 x i64> undef)

  %I32 = call i32 @llvm.ssub.sat.i32(i32 undef, i32 undef)
  %V4I32  = call <4 x i32>  @llvm.ssub.sat.v4i32(<4 x i32> undef, <4 x i32> undef)
  %V8I32  = call <8 x i32>  @llvm.ssub.sat.v8i32(<8 x i32> undef, <8 x i32> undef)
  %V16I32 = call <16 x i32> @llvm.ssub.sat.v16i32(<16 x i32> undef, <16 x i32> undef)

  %I16 = call i16 @llvm.ssub.sat.i16(i16 undef, i16 undef)
  %V8I16  = call <8 x i16>  @llvm.ssub.sat.v8i16(<8 x i16> undef, <8 x i16> undef)
  %V16I16 = call <16 x i16> @llvm.ssub.sat.v16i16(<16 x i16> undef, <16 x i16> undef)
  %V32I16 = call <32 x i16> @llvm.ssub.sat.v32i16(<32 x i16> undef, <32 x i16> undef)

  %I8 = call i8 @llvm.ssub.sat.i8(i8 undef, i8 undef)
  %V16I8 = call <16 x i8> @llvm.ssub.sat.v16i8(<16 x i8> undef, <16 x i8> undef)
  %V32I8 = call <32 x i8> @llvm.ssub.sat.v32i8(<32 x i8> undef, <32 x i8> undef)
  %V64I8 = call <64 x i8> @llvm.ssub.sat.v64i8(<64 x i8> undef, <64 x i8> undef)

  ret i32 undef
}
