/* encoding.c generated by valac 0.40.8, the Vala compiler
 * generated from encoding.vala, do not modify */

/*
 * Copyright (C) 2011-2018 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2011-2018 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>


#define SKK_TYPE_ENCODING_CONVERTER (skk_encoding_converter_get_type ())
#define SKK_ENCODING_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_ENCODING_CONVERTER, SkkEncodingConverter))
#define SKK_ENCODING_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_ENCODING_CONVERTER, SkkEncodingConverterClass))
#define SKK_IS_ENCODING_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_ENCODING_CONVERTER))
#define SKK_IS_ENCODING_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_ENCODING_CONVERTER))
#define SKK_ENCODING_CONVERTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_ENCODING_CONVERTER, SkkEncodingConverterClass))

typedef struct _SkkEncodingConverter SkkEncodingConverter;
typedef struct _SkkEncodingConverterClass SkkEncodingConverterClass;
typedef struct _SkkEncodingConverterPrivate SkkEncodingConverterPrivate;
enum  {
	SKK_ENCODING_CONVERTER_0_PROPERTY,
	SKK_ENCODING_CONVERTER_ENCODING_PROPERTY,
	SKK_ENCODING_CONVERTER_NUM_PROPERTIES
};
static GParamSpec* skk_encoding_converter_properties[SKK_ENCODING_CONVERTER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define SKK_TYPE_ENTRY (skk_entry_get_type ())
typedef struct _SkkEntry SkkEntry;
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _SkkEncodingConverter {
	GObject parent_instance;
	SkkEncodingConverterPrivate * priv;
};

struct _SkkEncodingConverterClass {
	GObjectClass parent_class;
};

struct _SkkEncodingConverterPrivate {
	gchar* _encoding;
	GCharsetConverter* encoder;
	GCharsetConverter* decoder;
};

struct _SkkEntry {
	gpointer key;
	gpointer value;
};


static gpointer skk_encoding_converter_parent_class = NULL;
static GRegex* skk_encoding_converter_coding_cookie_regex;
static GRegex* skk_encoding_converter_coding_cookie_regex = NULL;

GType skk_encoding_converter_get_type (void) G_GNUC_CONST;
#define SKK_ENCODING_CONVERTER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SKK_TYPE_ENCODING_CONVERTER, SkkEncodingConverterPrivate))
#define SKK_ENCODING_CONVERTER_BUFSIZ 4096
#define SKK_ENCODING_CONVERTER_INTERNAL_ENCODING "UTF-8"
GType skk_entry_get_type (void) G_GNUC_CONST;
SkkEntry* skk_entry_dup (const SkkEntry* self);
void skk_entry_free (SkkEntry* self);
void skk_entry_copy (const SkkEntry* self,
                     SkkEntry* dest);
void skk_entry_destroy (SkkEntry* self);
gchar* skk_encoding_converter_extract_coding_system (const gchar* line);
gchar* skk_encoding_converter_get_coding_system (SkkEncodingConverter* self);
const gchar* skk_encoding_converter_get_encoding (SkkEncodingConverter* self);
SkkEncodingConverter* skk_encoding_converter_new (const gchar* encoding,
                                                  GError** error);
SkkEncodingConverter* skk_encoding_converter_construct (GType object_type,
                                                        const gchar* encoding,
                                                        GError** error);
static void skk_encoding_converter_set_encoding (SkkEncodingConverter* self,
                                          const gchar* value);
SkkEncodingConverter* skk_encoding_converter_new_from_coding_system (const gchar* coding,
                                                                     GError** error);
SkkEncodingConverter* skk_encoding_converter_construct_from_coding_system (GType object_type,
                                                                           const gchar* coding,
                                                                           GError** error);
static gchar* skk_encoding_converter_convert (SkkEncodingConverter* self,
                                       GCharsetConverter* converter,
                                       const gchar* str,
                                       GError** error);
static guint8* _vala_array_dup1 (guint8* self,
                          int length);
gchar* skk_encoding_converter_encode (SkkEncodingConverter* self,
                                      const gchar* internal_str,
                                      GError** error);
gchar* skk_encoding_converter_decode (SkkEncodingConverter* self,
                                      const gchar* external_str,
                                      GError** error);
static void skk_encoding_converter_finalize (GObject * obj);
static void _vala_skk_encoding_converter_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_skk_encoding_converter_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);

static const SkkEntry SKK_ENCODING_CONVERTER_ENCODING_TO_CODING_SYSTEM_RULE[7] = {{"UTF-8", "utf-8"}, {"EUC-JP", "euc-jp"}, {"Shift_JIS", "shift_jis"}, {"ISO-2022-JP", "iso-2022-jp"}, {"EUC-JISX0213", "euc-jisx0213"}, {"EUC-JISX0213", "euc-jis-2004"}, {"SHIFT_JISX0213", "shift_jis-2004"}};

gchar*
skk_encoding_converter_extract_coding_system (const gchar* line)
{
	gchar* result = NULL;
	GMatchInfo* info = NULL;
	GRegex* _tmp0_;
	GMatchInfo* _tmp1_ = NULL;
	gboolean _tmp2_;
	g_return_val_if_fail (line != NULL, NULL);
	info = NULL;
	_tmp0_ = skk_encoding_converter_coding_cookie_regex;
	_tmp2_ = g_regex_match (_tmp0_, line, 0, &_tmp1_);
	_g_match_info_unref0 (info);
	info = _tmp1_;
	if (_tmp2_) {
		GMatchInfo* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = info;
		_tmp4_ = g_match_info_fetch (_tmp3_, 1);
		result = _tmp4_;
		_g_match_info_unref0 (info);
		return result;
	}
	result = NULL;
	_g_match_info_unref0 (info);
	return result;
}


gchar*
skk_encoding_converter_get_coding_system (SkkEncodingConverter* self)
{
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	{
		SkkEntry* entry_collection = NULL;
		gint entry_collection_length1 = 0;
		gint _entry_collection_size_ = 0;
		gint entry_it = 0;
		entry_collection = SKK_ENCODING_CONVERTER_ENCODING_TO_CODING_SYSTEM_RULE;
		entry_collection_length1 = G_N_ELEMENTS (SKK_ENCODING_CONVERTER_ENCODING_TO_CODING_SYSTEM_RULE);
		for (entry_it = 0; entry_it < G_N_ELEMENTS (SKK_ENCODING_CONVERTER_ENCODING_TO_CODING_SYSTEM_RULE); entry_it = entry_it + 1) {
			SkkEntry entry = {0};
			entry = entry_collection[entry_it];
			{
				SkkEntry _tmp0_;
				gconstpointer _tmp1_;
				const gchar* _tmp2_;
				_tmp0_ = entry;
				_tmp1_ = _tmp0_.key;
				_tmp2_ = self->priv->_encoding;
				if (g_strcmp0 ((const gchar*) _tmp1_, _tmp2_) == 0) {
					SkkEntry _tmp3_;
					gconstpointer _tmp4_;
					gchar* _tmp5_;
					_tmp3_ = entry;
					_tmp4_ = _tmp3_.value;
					_tmp5_ = g_strdup ((const gchar*) _tmp4_);
					result = _tmp5_;
					return result;
				}
			}
		}
	}
	result = NULL;
	return result;
}


SkkEncodingConverter*
skk_encoding_converter_construct (GType object_type,
                                  const gchar* encoding,
                                  GError** error)
{
	SkkEncodingConverter * self = NULL;
	GCharsetConverter* _tmp0_ = NULL;
	GCharsetConverter* _tmp1_;
	GCharsetConverter* _tmp2_;
	GCharsetConverter* _tmp3_ = NULL;
	GCharsetConverter* _tmp4_;
	GCharsetConverter* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (encoding != NULL, NULL);
	self = (SkkEncodingConverter*) g_object_new (object_type, NULL);
	skk_encoding_converter_set_encoding (self, encoding);
	_tmp1_ = g_charset_converter_new (encoding, SKK_ENCODING_CONVERTER_INTERNAL_ENCODING, &_inner_error_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	_g_object_unref0 (self->priv->encoder);
	self->priv->encoder = _tmp2_;
	_tmp4_ = g_charset_converter_new (SKK_ENCODING_CONVERTER_INTERNAL_ENCODING, encoding, &_inner_error_);
	_tmp3_ = _tmp4_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (_tmp0_);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp5_ = _tmp3_;
	_tmp3_ = NULL;
	_g_object_unref0 (self->priv->decoder);
	self->priv->decoder = _tmp5_;
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (_tmp0_);
	return self;
}


SkkEncodingConverter*
skk_encoding_converter_new (const gchar* encoding,
                            GError** error)
{
	return skk_encoding_converter_construct (SKK_TYPE_ENCODING_CONVERTER, encoding, error);
}


SkkEncodingConverter*
skk_encoding_converter_construct_from_coding_system (GType object_type,
                                                     const gchar* coding,
                                                     GError** error)
{
	SkkEncodingConverter * self = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (coding != NULL, NULL);
	{
		SkkEntry* entry_collection = NULL;
		gint entry_collection_length1 = 0;
		gint _entry_collection_size_ = 0;
		gint entry_it = 0;
		entry_collection = SKK_ENCODING_CONVERTER_ENCODING_TO_CODING_SYSTEM_RULE;
		entry_collection_length1 = G_N_ELEMENTS (SKK_ENCODING_CONVERTER_ENCODING_TO_CODING_SYSTEM_RULE);
		for (entry_it = 0; entry_it < G_N_ELEMENTS (SKK_ENCODING_CONVERTER_ENCODING_TO_CODING_SYSTEM_RULE); entry_it = entry_it + 1) {
			SkkEntry entry = {0};
			entry = entry_collection[entry_it];
			{
				SkkEntry _tmp0_;
				gconstpointer _tmp1_;
				_tmp0_ = entry;
				_tmp1_ = _tmp0_.value;
				if (g_strcmp0 ((const gchar*) _tmp1_, coding) == 0) {
					SkkEntry _tmp2_;
					gconstpointer _tmp3_;
					_tmp2_ = entry;
					_tmp3_ = _tmp2_.key;
					self = (SkkEncodingConverter*) skk_encoding_converter_construct (object_type, (const gchar*) _tmp3_, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						g_propagate_error (error, _inner_error_);
						_g_object_unref0 (self);
						return NULL;
					}
					return self;
				}
			}
		}
	}
	g_assert_not_reached ();
	return self;
}


SkkEncodingConverter*
skk_encoding_converter_new_from_coding_system (const gchar* coding,
                                               GError** error)
{
	return skk_encoding_converter_construct_from_coding_system (SKK_TYPE_ENCODING_CONVERTER, coding, error);
}


static guint8*
string_get_data (const gchar* self,
                 int* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


static guint8*
_vala_array_dup1 (guint8* self,
                  int length)
{
	return g_memdup (self, length * sizeof (guint8));
}


static gchar*
skk_encoding_converter_convert (SkkEncodingConverter* self,
                                GCharsetConverter* converter,
                                const gchar* str,
                                GError** error)
{
	gchar* result = NULL;
	guint8* inbuf = NULL;
	guint8* _tmp0_;
	gint _tmp0__length1;
	guint8* _tmp1_;
	gint _tmp1__length1;
	guint8* _tmp2_;
	gint _tmp2__length1;
	gint inbuf_length1;
	gint _inbuf_size_;
	guint8* outbuf = NULL;
	guint8* _tmp3_;
	gint outbuf_length1;
	gint _outbuf_size_;
	GString* builder = NULL;
	GString* _tmp4_;
	gsize total_bytes_read = 0UL;
	GString* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (converter != NULL, NULL);
	g_return_val_if_fail (str != NULL, NULL);
	_tmp0_ = string_get_data (str, &_tmp0__length1);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	_tmp2_ = (_tmp1_ != NULL) ? _vala_array_dup1 (_tmp1_, _tmp1__length1) : ((gpointer) _tmp1_);
	_tmp2__length1 = _tmp1__length1;
	inbuf = _tmp2_;
	inbuf_length1 = _tmp2__length1;
	_inbuf_size_ = inbuf_length1;
	_tmp3_ = g_new0 (guint8, SKK_ENCODING_CONVERTER_BUFSIZ);
	outbuf = _tmp3_;
	outbuf_length1 = SKK_ENCODING_CONVERTER_BUFSIZ;
	_outbuf_size_ = outbuf_length1;
	_tmp4_ = g_string_new ("");
	builder = _tmp4_;
	total_bytes_read = (gsize) 0;
	while (TRUE) {
		gsize _tmp5_;
		guint8* _tmp6_;
		gint _tmp6__length1;
		gsize bytes_read = 0UL;
		gsize bytes_written = 0UL;
		guint8* _tmp7_;
		gint _tmp7__length1;
		gsize _tmp8_;
		guint8* _tmp9_;
		gint _tmp9__length1;
		guint8* _tmp10_;
		gint _tmp10__length1;
		gsize _tmp11_ = 0UL;
		gsize _tmp12_ = 0UL;
		gsize _tmp21_;
		gsize _tmp22_;
		_tmp5_ = total_bytes_read;
		_tmp6_ = inbuf;
		_tmp6__length1 = inbuf_length1;
		if (!(_tmp5_ < ((gsize) _tmp6__length1))) {
			break;
		}
		_tmp7_ = inbuf;
		_tmp7__length1 = inbuf_length1;
		_tmp8_ = total_bytes_read;
		_tmp9_ = inbuf;
		_tmp9__length1 = inbuf_length1;
		_tmp10_ = outbuf;
		_tmp10__length1 = outbuf_length1;
		g_converter_convert ((GConverter*) converter, _tmp7_ + ((gint) _tmp8_), (gsize) (_tmp9__length1 - ((gint) _tmp8_)), _tmp10_, (gsize) _tmp10__length1, G_CONVERTER_INPUT_AT_END, &_tmp11_, &_tmp12_, &_inner_error_);
		bytes_read = _tmp11_;
		bytes_written = _tmp12_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_string_free0 (builder);
			outbuf = (g_free (outbuf), NULL);
			inbuf = (g_free (inbuf), NULL);
			return NULL;
		}
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp13_ = FALSE;
				_tmp13_ = TRUE;
				while (TRUE) {
					gint _tmp15_;
					gsize _tmp16_;
					GString* _tmp17_;
					guint8* _tmp18_;
					gint _tmp18__length1;
					gint _tmp19_;
					guint8 _tmp20_;
					if (!_tmp13_) {
						gint _tmp14_;
						_tmp14_ = i;
						i = _tmp14_ + 1;
					}
					_tmp13_ = FALSE;
					_tmp15_ = i;
					_tmp16_ = bytes_written;
					if (!(((gsize) _tmp15_) < _tmp16_)) {
						break;
					}
					_tmp17_ = builder;
					_tmp18_ = outbuf;
					_tmp18__length1 = outbuf_length1;
					_tmp19_ = i;
					_tmp20_ = _tmp18_[_tmp19_];
					g_string_append_c (_tmp17_, (gchar) _tmp20_);
				}
			}
		}
		_tmp21_ = total_bytes_read;
		_tmp22_ = bytes_read;
		total_bytes_read = _tmp21_ + _tmp22_;
	}
	_tmp23_ = builder;
	_tmp24_ = _tmp23_->str;
	_tmp25_ = g_strdup (_tmp24_);
	result = _tmp25_;
	_g_string_free0 (builder);
	outbuf = (g_free (outbuf), NULL);
	inbuf = (g_free (inbuf), NULL);
	return result;
}


gchar*
skk_encoding_converter_encode (SkkEncodingConverter* self,
                               const gchar* internal_str,
                               GError** error)
{
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	GCharsetConverter* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (internal_str != NULL, NULL);
	_tmp1_ = self->priv->encoder;
	_tmp2_ = skk_encoding_converter_convert (self, _tmp1_, internal_str, &_inner_error_);
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp3_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp3_;
	_g_free0 (_tmp0_);
	return result;
}


gchar*
skk_encoding_converter_decode (SkkEncodingConverter* self,
                               const gchar* external_str,
                               GError** error)
{
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	GCharsetConverter* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (external_str != NULL, NULL);
	_tmp1_ = self->priv->decoder;
	_tmp2_ = skk_encoding_converter_convert (self, _tmp1_, external_str, &_inner_error_);
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp3_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp3_;
	_g_free0 (_tmp0_);
	return result;
}


const gchar*
skk_encoding_converter_get_encoding (SkkEncodingConverter* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_encoding;
	result = _tmp0_;
	return result;
}


static void
skk_encoding_converter_set_encoding (SkkEncodingConverter* self,
                                     const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, skk_encoding_converter_get_encoding (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_encoding);
		self->priv->_encoding = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, skk_encoding_converter_properties[SKK_ENCODING_CONVERTER_ENCODING_PROPERTY]);
	}
}


static void
skk_encoding_converter_class_init (SkkEncodingConverterClass * klass)
{
	GError * _inner_error_ = NULL;
	skk_encoding_converter_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SkkEncodingConverterPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_skk_encoding_converter_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_skk_encoding_converter_set_property;
	G_OBJECT_CLASS (klass)->finalize = skk_encoding_converter_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SKK_ENCODING_CONVERTER_ENCODING_PROPERTY, skk_encoding_converter_properties[SKK_ENCODING_CONVERTER_ENCODING_PROPERTY] = g_param_spec_string ("encoding", "encoding", "encoding", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	{
		GRegex* _tmp0_ = NULL;
		GRegex* _tmp1_;
		GRegex* _tmp2_;
		_tmp1_ = g_regex_new ("-\\*-.*[ \t]coding:[ \t]*([^ \t;]+?)[ \t;].*-\\*-", 0, 0, &_inner_error_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch1_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_regex_unref0 (skk_encoding_converter_coding_cookie_regex);
		skk_encoding_converter_coding_cookie_regex = _tmp2_;
		_g_regex_unref0 (_tmp0_);
	}
	goto __finally1;
	__catch1_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
}


static void
skk_encoding_converter_instance_init (SkkEncodingConverter * self)
{
	self->priv = SKK_ENCODING_CONVERTER_GET_PRIVATE (self);
}


static void
skk_encoding_converter_finalize (GObject * obj)
{
	SkkEncodingConverter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SKK_TYPE_ENCODING_CONVERTER, SkkEncodingConverter);
	_g_free0 (self->priv->_encoding);
	_g_object_unref0 (self->priv->encoder);
	_g_object_unref0 (self->priv->decoder);
	G_OBJECT_CLASS (skk_encoding_converter_parent_class)->finalize (obj);
}


GType
skk_encoding_converter_get_type (void)
{
	static volatile gsize skk_encoding_converter_type_id__volatile = 0;
	if (g_once_init_enter (&skk_encoding_converter_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SkkEncodingConverterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_encoding_converter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkEncodingConverter), 0, (GInstanceInitFunc) skk_encoding_converter_instance_init, NULL };
		GType skk_encoding_converter_type_id;
		skk_encoding_converter_type_id = g_type_register_static (G_TYPE_OBJECT, "SkkEncodingConverter", &g_define_type_info, 0);
		g_once_init_leave (&skk_encoding_converter_type_id__volatile, skk_encoding_converter_type_id);
	}
	return skk_encoding_converter_type_id__volatile;
}


static void
_vala_skk_encoding_converter_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	SkkEncodingConverter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SKK_TYPE_ENCODING_CONVERTER, SkkEncodingConverter);
	switch (property_id) {
		case SKK_ENCODING_CONVERTER_ENCODING_PROPERTY:
		g_value_set_string (value, skk_encoding_converter_get_encoding (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_skk_encoding_converter_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	SkkEncodingConverter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SKK_TYPE_ENCODING_CONVERTER, SkkEncodingConverter);
	switch (property_id) {
		case SKK_ENCODING_CONVERTER_ENCODING_PROPERTY:
		skk_encoding_converter_set_encoding (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



