// Copyright 2010 the V8 project authors. All rights reserved.
// ------------ GENERATED FILE ----------------
// command used:
//  tools/generate-ten-powers --from -308 --to 342 --mantissa-size 64 --round round -o src/powers-ten.h  // NOLINT

// This file is intended to be included inside another .h or .cc files
// with the following defines set:
//  GRISU_CACHE_STRUCT: should expand to the name of a struct that will
//   hold the cached powers of ten. Each entry will hold a 64-bit
//   significand, a 16-bit signed binary exponent, and a 16-bit
//   signed decimal exponent. Each entry will be constructed as follows:
//      { significand, binary_exponent, decimal_exponent }.
//  GRISU_CACHE_NAME(i): generates the name for the different caches.
//   The parameter i will be a number in the range 1-20. A cache will
//   hold every i'th element of a full cache. GRISU_CACHE_NAME(1) will
//   thus hold all elements. The higher i the fewer elements it has.
//   Ideally the user should only reference one cache and let the
//   compiler remove the unused ones.
//  GRISU_CACHE_MAX_DISTANCE(i): generates the name for the maximum
//   binary exponent distance between all elements of a given cache.
//  GRISU_CACHE_OFFSET: is used as variable name for the decimal
//   exponent offset. It is equal to -cache[0].decimal_exponent.
//  GRISU_UINT64_C: used to construct 64-bit values in a platform
//   independent way. In order to encode 0x123456789ABCDEF0 the macro
//   will be invoked as follows: GRISU_UINT64_C(0x12345678,9ABCDEF0).


static const GRISU_CACHE_STRUCT GRISU_CACHE_NAME(1)[] = {
  {GRISU_UINT64_C(0xe61acf03, 3d1a45df), -1087, -308},
  {GRISU_UINT64_C(0x8fd0c162, 06306bac), -1083, -307},
  {GRISU_UINT64_C(0xb3c4f1ba, 87bc8697), -1080, -306},
  {GRISU_UINT64_C(0xe0b62e29, 29aba83c), -1077, -305},
  {GRISU_UINT64_C(0x8c71dcd9, ba0b4926), -1073, -304},
  {GRISU_UINT64_C(0xaf8e5410, 288e1b6f), -1070, -303},
  {GRISU_UINT64_C(0xdb71e914, 32b1a24b), -1067, -302},
  {GRISU_UINT64_C(0x892731ac, 9faf056f), -1063, -301},
  {GRISU_UINT64_C(0xab70fe17, c79ac6ca), -1060, -300},
  {GRISU_UINT64_C(0xd64d3d9d, b981787d), -1057, -299},
  {GRISU_UINT64_C(0x85f04682, 93f0eb4e), -1053, -298},
  {GRISU_UINT64_C(0xa76c5823, 38ed2622), -1050, -297},
  {GRISU_UINT64_C(0xd1476e2c, 07286faa), -1047, -296},
  {GRISU_UINT64_C(0x82cca4db, 847945ca), -1043, -295},
  {GRISU_UINT64_C(0xa37fce12, 6597973d), -1040, -294},
  {GRISU_UINT64_C(0xcc5fc196, fefd7d0c), -1037, -293},
  {GRISU_UINT64_C(0xff77b1fc, bebcdc4f), -1034, -292},
  {GRISU_UINT64_C(0x9faacf3d, f73609b1), -1030, -291},
  {GRISU_UINT64_C(0xc795830d, 75038c1e), -1027, -290},
  {GRISU_UINT64_C(0xf97ae3d0, d2446f25), -1024, -289},
  {GRISU_UINT64_C(0x9becce62, 836ac577), -1020, -288},
  {GRISU_UINT64_C(0xc2e801fb, 244576d5), -1017, -287},
  {GRISU_UINT64_C(0xf3a20279, ed56d48a), -1014, -286},
  {GRISU_UINT64_C(0x9845418c, 345644d7), -1010, -285},
  {GRISU_UINT64_C(0xbe5691ef, 416bd60c), -1007, -284},
  {GRISU_UINT64_C(0xedec366b, 11c6cb8f), -1004, -283},
  {GRISU_UINT64_C(0x94b3a202, eb1c3f39), -1000, -282},
  {GRISU_UINT64_C(0xb9e08a83, a5e34f08), -997, -281},
  {GRISU_UINT64_C(0xe858ad24, 8f5c22ca), -994, -280},
  {GRISU_UINT64_C(0x91376c36, d99995be), -990, -279},
  {GRISU_UINT64_C(0xb5854744, 8ffffb2e), -987, -278},
  {GRISU_UINT64_C(0xe2e69915, b3fff9f9), -984, -277},
  {GRISU_UINT64_C(0x8dd01fad, 907ffc3c), -980, -276},
  {GRISU_UINT64_C(0xb1442798, f49ffb4b), -977, -275},
  {GRISU_UINT64_C(0xdd95317f, 31c7fa1d), -974, -274},
  {GRISU_UINT64_C(0x8a7d3eef, 7f1cfc52), -970, -273},
  {GRISU_UINT64_C(0xad1c8eab, 5ee43b67), -967, -272},
  {GRISU_UINT64_C(0xd863b256, 369d4a41), -964, -271},
  {GRISU_UINT64_C(0x873e4f75, e2224e68), -960, -270},
  {GRISU_UINT64_C(0xa90de353, 5aaae202), -957, -269},
  {GRISU_UINT64_C(0xd3515c28, 31559a83), -954, -268},
  {GRISU_UINT64_C(0x8412d999, 1ed58092), -950, -267},
  {GRISU_UINT64_C(0xa5178fff, 668ae0b6), -947, -266},
  {GRISU_UINT64_C(0xce5d73ff, 402d98e4), -944, -265},
  {GRISU_UINT64_C(0x80fa687f, 881c7f8e), -940, -264},
  {GRISU_UINT64_C(0xa139029f, 6a239f72), -937, -263},
  {GRISU_UINT64_C(0xc9874347, 44ac874f), -934, -262},
  {GRISU_UINT64_C(0xfbe91419, 15d7a922), -931, -261},
  {GRISU_UINT64_C(0x9d71ac8f, ada6c9b5), -927, -260},
  {GRISU_UINT64_C(0xc4ce17b3, 99107c23), -924, -259},
  {GRISU_UINT64_C(0xf6019da0, 7f549b2b), -921, -258},
  {GRISU_UINT64_C(0x99c10284, 4f94e0fb), -917, -257},
  {GRISU_UINT64_C(0xc0314325, 637a193a), -914, -256},
  {GRISU_UINT64_C(0xf03d93ee, bc589f88), -911, -255},
  {GRISU_UINT64_C(0x96267c75, 35b763b5), -907, -254},
  {GRISU_UINT64_C(0xbbb01b92, 83253ca3), -904, -253},
  {GRISU_UINT64_C(0xea9c2277, 23ee8bcb), -901, -252},
  {GRISU_UINT64_C(0x92a1958a, 7675175f), -897, -251},
  {GRISU_UINT64_C(0xb749faed, 14125d37), -894, -250},
  {GRISU_UINT64_C(0xe51c79a8, 5916f485), -891, -249},
  {GRISU_UINT64_C(0x8f31cc09, 37ae58d3), -887, -248},
  {GRISU_UINT64_C(0xb2fe3f0b, 8599ef08), -884, -247},
  {GRISU_UINT64_C(0xdfbdcece, 67006ac9), -881, -246},
  {GRISU_UINT64_C(0x8bd6a141, 006042be), -877, -245},
  {GRISU_UINT64_C(0xaecc4991, 4078536d), -874, -244},
  {GRISU_UINT64_C(0xda7f5bf5, 90966849), -871, -243},
  {GRISU_UINT64_C(0x888f9979, 7a5e012d), -867, -242},
  {GRISU_UINT64_C(0xaab37fd7, d8f58179), -864, -241},
  {GRISU_UINT64_C(0xd5605fcd, cf32e1d7), -861, -240},
  {GRISU_UINT64_C(0x855c3be0, a17fcd26), -857, -239},
  {GRISU_UINT64_C(0xa6b34ad8, c9dfc070), -854, -238},
  {GRISU_UINT64_C(0xd0601d8e, fc57b08c), -851, -237},
  {GRISU_UINT64_C(0x823c1279, 5db6ce57), -847, -236},
  {GRISU_UINT64_C(0xa2cb1717, b52481ed), -844, -235},
  {GRISU_UINT64_C(0xcb7ddcdd, a26da269), -841, -234},
  {GRISU_UINT64_C(0xfe5d5415, 0b090b03), -838, -233},
  {GRISU_UINT64_C(0x9efa548d, 26e5a6e2), -834, -232},
  {GRISU_UINT64_C(0xc6b8e9b0, 709f109a), -831, -231},
  {GRISU_UINT64_C(0xf867241c, 8cc6d4c1), -828, -230},
  {GRISU_UINT64_C(0x9b407691, d7fc44f8), -824, -229},
  {GRISU_UINT64_C(0xc2109436, 4dfb5637), -821, -228},
  {GRISU_UINT64_C(0xf294b943, e17a2bc4), -818, -227},
  {GRISU_UINT64_C(0x979cf3ca, 6cec5b5b), -814, -226},
  {GRISU_UINT64_C(0xbd8430bd, 08277231), -811, -225},
  {GRISU_UINT64_C(0xece53cec, 4a314ebe), -808, -224},
  {GRISU_UINT64_C(0x940f4613, ae5ed137), -804, -223},
  {GRISU_UINT64_C(0xb9131798, 99f68584), -801, -222},
  {GRISU_UINT64_C(0xe757dd7e, c07426e5), -798, -221},
  {GRISU_UINT64_C(0x9096ea6f, 3848984f), -794, -220},
  {GRISU_UINT64_C(0xb4bca50b, 065abe63), -791, -219},
  {GRISU_UINT64_C(0xe1ebce4d, c7f16dfc), -788, -218},
  {GRISU_UINT64_C(0x8d3360f0, 9cf6e4bd), -784, -217},
  {GRISU_UINT64_C(0xb080392c, c4349ded), -781, -216},
  {GRISU_UINT64_C(0xdca04777, f541c568), -778, -215},
  {GRISU_UINT64_C(0x89e42caa, f9491b61), -774, -214},
  {GRISU_UINT64_C(0xac5d37d5, b79b6239), -771, -213},
  {GRISU_UINT64_C(0xd77485cb, 25823ac7), -768, -212},
  {GRISU_UINT64_C(0x86a8d39e, f77164bd), -764, -211},
  {GRISU_UINT64_C(0xa8530886, b54dbdec), -761, -210},
  {GRISU_UINT64_C(0xd267caa8, 62a12d67), -758, -209},
  {GRISU_UINT64_C(0x8380dea9, 3da4bc60), -754, -208},
  {GRISU_UINT64_C(0xa4611653, 8d0deb78), -751, -207},
  {GRISU_UINT64_C(0xcd795be8, 70516656), -748, -206},
  {GRISU_UINT64_C(0x806bd971, 4632dff6), -744, -205},
  {GRISU_UINT64_C(0xa086cfcd, 97bf97f4), -741, -204},
  {GRISU_UINT64_C(0xc8a883c0, fdaf7df0), -738, -203},
  {GRISU_UINT64_C(0xfad2a4b1, 3d1b5d6c), -735, -202},
  {GRISU_UINT64_C(0x9cc3a6ee, c6311a64), -731, -201},
  {GRISU_UINT64_C(0xc3f490aa, 77bd60fd), -728, -200},
  {GRISU_UINT64_C(0xf4f1b4d5, 15acb93c), -725, -199},
  {GRISU_UINT64_C(0x99171105, 2d8bf3c5), -721, -198},
  {GRISU_UINT64_C(0xbf5cd546, 78eef0b7), -718, -197},
  {GRISU_UINT64_C(0xef340a98, 172aace5), -715, -196},
  {GRISU_UINT64_C(0x9580869f, 0e7aac0f), -711, -195},
  {GRISU_UINT64_C(0xbae0a846, d2195713), -708, -194},
  {GRISU_UINT64_C(0xe998d258, 869facd7), -705, -193},
  {GRISU_UINT64_C(0x91ff8377, 5423cc06), -701, -192},
  {GRISU_UINT64_C(0xb67f6455, 292cbf08), -698, -191},
  {GRISU_UINT64_C(0xe41f3d6a, 7377eeca), -695, -190},
  {GRISU_UINT64_C(0x8e938662, 882af53e), -691, -189},
  {GRISU_UINT64_C(0xb23867fb, 2a35b28e), -688, -188},
  {GRISU_UINT64_C(0xdec681f9, f4c31f31), -685, -187},
  {GRISU_UINT64_C(0x8b3c113c, 38f9f37f), -681, -186},
  {GRISU_UINT64_C(0xae0b158b, 4738705f), -678, -185},
  {GRISU_UINT64_C(0xd98ddaee, 19068c76), -675, -184},
  {GRISU_UINT64_C(0x87f8a8d4, cfa417ca), -671, -183},
  {GRISU_UINT64_C(0xa9f6d30a, 038d1dbc), -668, -182},
  {GRISU_UINT64_C(0xd47487cc, 8470652b), -665, -181},
  {GRISU_UINT64_C(0x84c8d4df, d2c63f3b), -661, -180},
  {GRISU_UINT64_C(0xa5fb0a17, c777cf0a), -658, -179},
  {GRISU_UINT64_C(0xcf79cc9d, b955c2cc), -655, -178},
  {GRISU_UINT64_C(0x81ac1fe2, 93d599c0), -651, -177},
  {GRISU_UINT64_C(0xa21727db, 38cb0030), -648, -176},
  {GRISU_UINT64_C(0xca9cf1d2, 06fdc03c), -645, -175},
  {GRISU_UINT64_C(0xfd442e46, 88bd304b), -642, -174},
  {GRISU_UINT64_C(0x9e4a9cec, 15763e2f), -638, -173},
  {GRISU_UINT64_C(0xc5dd4427, 1ad3cdba), -635, -172},
  {GRISU_UINT64_C(0xf7549530, e188c129), -632, -171},
  {GRISU_UINT64_C(0x9a94dd3e, 8cf578ba), -628, -170},
  {GRISU_UINT64_C(0xc13a148e, 3032d6e8), -625, -169},
  {GRISU_UINT64_C(0xf18899b1, bc3f8ca2), -622, -168},
  {GRISU_UINT64_C(0x96f5600f, 15a7b7e5), -618, -167},
  {GRISU_UINT64_C(0xbcb2b812, db11a5de), -615, -166},
  {GRISU_UINT64_C(0xebdf6617, 91d60f56), -612, -165},
  {GRISU_UINT64_C(0x936b9fce, bb25c996), -608, -164},
  {GRISU_UINT64_C(0xb84687c2, 69ef3bfb), -605, -163},
  {GRISU_UINT64_C(0xe65829b3, 046b0afa), -602, -162},
  {GRISU_UINT64_C(0x8ff71a0f, e2c2e6dc), -598, -161},
  {GRISU_UINT64_C(0xb3f4e093, db73a093), -595, -160},
  {GRISU_UINT64_C(0xe0f218b8, d25088b8), -592, -159},
  {GRISU_UINT64_C(0x8c974f73, 83725573), -588, -158},
  {GRISU_UINT64_C(0xafbd2350, 644eead0), -585, -157},
  {GRISU_UINT64_C(0xdbac6c24, 7d62a584), -582, -156},
  {GRISU_UINT64_C(0x894bc396, ce5da772), -578, -155},
  {GRISU_UINT64_C(0xab9eb47c, 81f5114f), -575, -154},
  {GRISU_UINT64_C(0xd686619b, a27255a3), -572, -153},
  {GRISU_UINT64_C(0x8613fd01, 45877586), -568, -152},
  {GRISU_UINT64_C(0xa798fc41, 96e952e7), -565, -151},
  {GRISU_UINT64_C(0xd17f3b51, fca3a7a1), -562, -150},
  {GRISU_UINT64_C(0x82ef8513, 3de648c5), -558, -149},
  {GRISU_UINT64_C(0xa3ab6658, 0d5fdaf6), -555, -148},
  {GRISU_UINT64_C(0xcc963fee, 10b7d1b3), -552, -147},
  {GRISU_UINT64_C(0xffbbcfe9, 94e5c620), -549, -146},
  {GRISU_UINT64_C(0x9fd561f1, fd0f9bd4), -545, -145},
  {GRISU_UINT64_C(0xc7caba6e, 7c5382c9), -542, -144},
  {GRISU_UINT64_C(0xf9bd690a, 1b68637b), -539, -143},
  {GRISU_UINT64_C(0x9c1661a6, 51213e2d), -535, -142},
  {GRISU_UINT64_C(0xc31bfa0f, e5698db8), -532, -141},
  {GRISU_UINT64_C(0xf3e2f893, dec3f126), -529, -140},
  {GRISU_UINT64_C(0x986ddb5c, 6b3a76b8), -525, -139},
  {GRISU_UINT64_C(0xbe895233, 86091466), -522, -138},
  {GRISU_UINT64_C(0xee2ba6c0, 678b597f), -519, -137},
  {GRISU_UINT64_C(0x94db4838, 40b717f0), -515, -136},
  {GRISU_UINT64_C(0xba121a46, 50e4ddec), -512, -135},
  {GRISU_UINT64_C(0xe896a0d7, e51e1566), -509, -134},
  {GRISU_UINT64_C(0x915e2486, ef32cd60), -505, -133},
  {GRISU_UINT64_C(0xb5b5ada8, aaff80b8), -502, -132},
  {GRISU_UINT64_C(0xe3231912, d5bf60e6), -499, -131},
  {GRISU_UINT64_C(0x8df5efab, c5979c90), -495, -130},
  {GRISU_UINT64_C(0xb1736b96, b6fd83b4), -492, -129},
  {GRISU_UINT64_C(0xddd0467c, 64bce4a1), -489, -128},
  {GRISU_UINT64_C(0x8aa22c0d, bef60ee4), -485, -127},
  {GRISU_UINT64_C(0xad4ab711, 2eb3929e), -482, -126},
  {GRISU_UINT64_C(0xd89d64d5, 7a607745), -479, -125},
  {GRISU_UINT64_C(0x87625f05, 6c7c4a8b), -475, -124},
  {GRISU_UINT64_C(0xa93af6c6, c79b5d2e), -472, -123},
  {GRISU_UINT64_C(0xd389b478, 79823479), -469, -122},
  {GRISU_UINT64_C(0x843610cb, 4bf160cc), -465, -121},
  {GRISU_UINT64_C(0xa54394fe, 1eedb8ff), -462, -120},
  {GRISU_UINT64_C(0xce947a3d, a6a9273e), -459, -119},
  {GRISU_UINT64_C(0x811ccc66, 8829b887), -455, -118},
  {GRISU_UINT64_C(0xa163ff80, 2a3426a9), -452, -117},
  {GRISU_UINT64_C(0xc9bcff60, 34c13053), -449, -116},
  {GRISU_UINT64_C(0xfc2c3f38, 41f17c68), -446, -115},
  {GRISU_UINT64_C(0x9d9ba783, 2936edc1), -442, -114},
  {GRISU_UINT64_C(0xc5029163, f384a931), -439, -113},
  {GRISU_UINT64_C(0xf64335bc, f065d37d), -436, -112},
  {GRISU_UINT64_C(0x99ea0196, 163fa42e), -432, -111},
  {GRISU_UINT64_C(0xc06481fb, 9bcf8d3a), -429, -110},
  {GRISU_UINT64_C(0xf07da27a, 82c37088), -426, -109},
  {GRISU_UINT64_C(0x964e858c, 91ba2655), -422, -108},
  {GRISU_UINT64_C(0xbbe226ef, b628afeb), -419, -107},
  {GRISU_UINT64_C(0xeadab0ab, a3b2dbe5), -416, -106},
  {GRISU_UINT64_C(0x92c8ae6b, 464fc96f), -412, -105},
  {GRISU_UINT64_C(0xb77ada06, 17e3bbcb), -409, -104},
  {GRISU_UINT64_C(0xe5599087, 9ddcaabe), -406, -103},
  {GRISU_UINT64_C(0x8f57fa54, c2a9eab7), -402, -102},
  {GRISU_UINT64_C(0xb32df8e9, f3546564), -399, -101},
  {GRISU_UINT64_C(0xdff97724, 70297ebd), -396, -100},
  {GRISU_UINT64_C(0x8bfbea76, c619ef36), -392, -99},
  {GRISU_UINT64_C(0xaefae514, 77a06b04), -389, -98},
  {GRISU_UINT64_C(0xdab99e59, 958885c5), -386, -97},
  {GRISU_UINT64_C(0x88b402f7, fd75539b), -382, -96},
  {GRISU_UINT64_C(0xaae103b5, fcd2a882), -379, -95},
  {GRISU_UINT64_C(0xd59944a3, 7c0752a2), -376, -94},
  {GRISU_UINT64_C(0x857fcae6, 2d8493a5), -372, -93},
  {GRISU_UINT64_C(0xa6dfbd9f, b8e5b88f), -369, -92},
  {GRISU_UINT64_C(0xd097ad07, a71f26b2), -366, -91},
  {GRISU_UINT64_C(0x825ecc24, c8737830), -362, -90},
  {GRISU_UINT64_C(0xa2f67f2d, fa90563b), -359, -89},
  {GRISU_UINT64_C(0xcbb41ef9, 79346bca), -356, -88},
  {GRISU_UINT64_C(0xfea126b7, d78186bd), -353, -87},
  {GRISU_UINT64_C(0x9f24b832, e6b0f436), -349, -86},
  {GRISU_UINT64_C(0xc6ede63f, a05d3144), -346, -85},
  {GRISU_UINT64_C(0xf8a95fcf, 88747d94), -343, -84},
  {GRISU_UINT64_C(0x9b69dbe1, b548ce7d), -339, -83},
  {GRISU_UINT64_C(0xc24452da, 229b021c), -336, -82},
  {GRISU_UINT64_C(0xf2d56790, ab41c2a3), -333, -81},
  {GRISU_UINT64_C(0x97c560ba, 6b0919a6), -329, -80},
  {GRISU_UINT64_C(0xbdb6b8e9, 05cb600f), -326, -79},
  {GRISU_UINT64_C(0xed246723, 473e3813), -323, -78},
  {GRISU_UINT64_C(0x9436c076, 0c86e30c), -319, -77},
  {GRISU_UINT64_C(0xb9447093, 8fa89bcf), -316, -76},
  {GRISU_UINT64_C(0xe7958cb8, 7392c2c3), -313, -75},
  {GRISU_UINT64_C(0x90bd77f3, 483bb9ba), -309, -74},
  {GRISU_UINT64_C(0xb4ecd5f0, 1a4aa828), -306, -73},
  {GRISU_UINT64_C(0xe2280b6c, 20dd5232), -303, -72},
  {GRISU_UINT64_C(0x8d590723, 948a535f), -299, -71},
  {GRISU_UINT64_C(0xb0af48ec, 79ace837), -296, -70},
  {GRISU_UINT64_C(0xdcdb1b27, 98182245), -293, -69},
  {GRISU_UINT64_C(0x8a08f0f8, bf0f156b), -289, -68},
  {GRISU_UINT64_C(0xac8b2d36, eed2dac6), -286, -67},
  {GRISU_UINT64_C(0xd7adf884, aa879177), -283, -66},
  {GRISU_UINT64_C(0x86ccbb52, ea94baeb), -279, -65},
  {GRISU_UINT64_C(0xa87fea27, a539e9a5), -276, -64},
  {GRISU_UINT64_C(0xd29fe4b1, 8e88640f), -273, -63},
  {GRISU_UINT64_C(0x83a3eeee, f9153e89), -269, -62},
  {GRISU_UINT64_C(0xa48ceaaa, b75a8e2b), -266, -61},
  {GRISU_UINT64_C(0xcdb02555, 653131b6), -263, -60},
  {GRISU_UINT64_C(0x808e1755, 5f3ebf12), -259, -59},
  {GRISU_UINT64_C(0xa0b19d2a, b70e6ed6), -256, -58},
  {GRISU_UINT64_C(0xc8de0475, 64d20a8c), -253, -57},
  {GRISU_UINT64_C(0xfb158592, be068d2f), -250, -56},
  {GRISU_UINT64_C(0x9ced737b, b6c4183d), -246, -55},
  {GRISU_UINT64_C(0xc428d05a, a4751e4d), -243, -54},
  {GRISU_UINT64_C(0xf5330471, 4d9265e0), -240, -53},
  {GRISU_UINT64_C(0x993fe2c6, d07b7fac), -236, -52},
  {GRISU_UINT64_C(0xbf8fdb78, 849a5f97), -233, -51},
  {GRISU_UINT64_C(0xef73d256, a5c0f77d), -230, -50},
  {GRISU_UINT64_C(0x95a86376, 27989aae), -226, -49},
  {GRISU_UINT64_C(0xbb127c53, b17ec159), -223, -48},
  {GRISU_UINT64_C(0xe9d71b68, 9dde71b0), -220, -47},
  {GRISU_UINT64_C(0x92267121, 62ab070e), -216, -46},
  {GRISU_UINT64_C(0xb6b00d69, bb55c8d1), -213, -45},
  {GRISU_UINT64_C(0xe45c10c4, 2a2b3b06), -210, -44},
  {GRISU_UINT64_C(0x8eb98a7a, 9a5b04e3), -206, -43},
  {GRISU_UINT64_C(0xb267ed19, 40f1c61c), -203, -42},
  {GRISU_UINT64_C(0xdf01e85f, 912e37a3), -200, -41},
  {GRISU_UINT64_C(0x8b61313b, babce2c6), -196, -40},
  {GRISU_UINT64_C(0xae397d8a, a96c1b78), -193, -39},
  {GRISU_UINT64_C(0xd9c7dced, 53c72256), -190, -38},
  {GRISU_UINT64_C(0x881cea14, 545c7575), -186, -37},
  {GRISU_UINT64_C(0xaa242499, 697392d3), -183, -36},
  {GRISU_UINT64_C(0xd4ad2dbf, c3d07788), -180, -35},
  {GRISU_UINT64_C(0x84ec3c97, da624ab5), -176, -34},
  {GRISU_UINT64_C(0xa6274bbd, d0fadd62), -173, -33},
  {GRISU_UINT64_C(0xcfb11ead, 453994ba), -170, -32},
  {GRISU_UINT64_C(0x81ceb32c, 4b43fcf5), -166, -31},
  {GRISU_UINT64_C(0xa2425ff7, 5e14fc32), -163, -30},
  {GRISU_UINT64_C(0xcad2f7f5, 359a3b3e), -160, -29},
  {GRISU_UINT64_C(0xfd87b5f2, 8300ca0e), -157, -28},
  {GRISU_UINT64_C(0x9e74d1b7, 91e07e48), -153, -27},
  {GRISU_UINT64_C(0xc6120625, 76589ddb), -150, -26},
  {GRISU_UINT64_C(0xf79687ae, d3eec551), -147, -25},
  {GRISU_UINT64_C(0x9abe14cd, 44753b53), -143, -24},
  {GRISU_UINT64_C(0xc16d9a00, 95928a27), -140, -23},
  {GRISU_UINT64_C(0xf1c90080, baf72cb1), -137, -22},
  {GRISU_UINT64_C(0x971da050, 74da7bef), -133, -21},
  {GRISU_UINT64_C(0xbce50864, 92111aeb), -130, -20},
  {GRISU_UINT64_C(0xec1e4a7d, b69561a5), -127, -19},
  {GRISU_UINT64_C(0x9392ee8e, 921d5d07), -123, -18},
  {GRISU_UINT64_C(0xb877aa32, 36a4b449), -120, -17},
  {GRISU_UINT64_C(0xe69594be, c44de15b), -117, -16},
  {GRISU_UINT64_C(0x901d7cf7, 3ab0acd9), -113, -15},
  {GRISU_UINT64_C(0xb424dc35, 095cd80f), -110, -14},
  {GRISU_UINT64_C(0xe12e1342, 4bb40e13), -107, -13},
  {GRISU_UINT64_C(0x8cbccc09, 6f5088cc), -103, -12},
  {GRISU_UINT64_C(0xafebff0b, cb24aaff), -100, -11},
  {GRISU_UINT64_C(0xdbe6fece, bdedd5bf), -97, -10},
  {GRISU_UINT64_C(0x89705f41, 36b4a597), -93, -9},
  {GRISU_UINT64_C(0xabcc7711, 8461cefd), -90, -8},
  {GRISU_UINT64_C(0xd6bf94d5, e57a42bc), -87, -7},
  {GRISU_UINT64_C(0x8637bd05, af6c69b6), -83, -6},
  {GRISU_UINT64_C(0xa7c5ac47, 1b478423), -80, -5},
  {GRISU_UINT64_C(0xd1b71758, e219652c), -77, -4},
  {GRISU_UINT64_C(0x83126e97, 8d4fdf3b), -73, -3},
  {GRISU_UINT64_C(0xa3d70a3d, 70a3d70a), -70, -2},
  {GRISU_UINT64_C(0xcccccccc, cccccccd), -67, -1},
  {GRISU_UINT64_C(0x80000000, 00000000), -63, 0},
  {GRISU_UINT64_C(0xa0000000, 00000000), -60, 1},
  {GRISU_UINT64_C(0xc8000000, 00000000), -57, 2},
  {GRISU_UINT64_C(0xfa000000, 00000000), -54, 3},
  {GRISU_UINT64_C(0x9c400000, 00000000), -50, 4},
  {GRISU_UINT64_C(0xc3500000, 00000000), -47, 5},
  {GRISU_UINT64_C(0xf4240000, 00000000), -44, 6},
  {GRISU_UINT64_C(0x98968000, 00000000), -40, 7},
  {GRISU_UINT64_C(0xbebc2000, 00000000), -37, 8},
  {GRISU_UINT64_C(0xee6b2800, 00000000), -34, 9},
  {GRISU_UINT64_C(0x9502f900, 00000000), -30, 10},
  {GRISU_UINT64_C(0xba43b740, 00000000), -27, 11},
  {GRISU_UINT64_C(0xe8d4a510, 00000000), -24, 12},
  {GRISU_UINT64_C(0x9184e72a, 00000000), -20, 13},
  {GRISU_UINT64_C(0xb5e620f4, 80000000), -17, 14},
  {GRISU_UINT64_C(0xe35fa931, a0000000), -14, 15},
  {GRISU_UINT64_C(0x8e1bc9bf, 04000000), -10, 16},
  {GRISU_UINT64_C(0xb1a2bc2e, c5000000), -7, 17},
  {GRISU_UINT64_C(0xde0b6b3a, 76400000), -4, 18},
  {GRISU_UINT64_C(0x8ac72304, 89e80000), 0, 19},
  {GRISU_UINT64_C(0xad78ebc5, ac620000), 3, 20},
  {GRISU_UINT64_C(0xd8d726b7, 177a8000), 6, 21},
  {GRISU_UINT64_C(0x87867832, 6eac9000), 10, 22},
  {GRISU_UINT64_C(0xa968163f, 0a57b400), 13, 23},
  {GRISU_UINT64_C(0xd3c21bce, cceda100), 16, 24},
  {GRISU_UINT64_C(0x84595161, 401484a0), 20, 25},
  {GRISU_UINT64_C(0xa56fa5b9, 9019a5c8), 23, 26},
  {GRISU_UINT64_C(0xcecb8f27, f4200f3a), 26, 27},
  {GRISU_UINT64_C(0x813f3978, f8940984), 30, 28},
  {GRISU_UINT64_C(0xa18f07d7, 36b90be5), 33, 29},
  {GRISU_UINT64_C(0xc9f2c9cd, 04674edf), 36, 30},
  {GRISU_UINT64_C(0xfc6f7c40, 45812296), 39, 31},
  {GRISU_UINT64_C(0x9dc5ada8, 2b70b59e), 43, 32},
  {GRISU_UINT64_C(0xc5371912, 364ce305), 46, 33},
  {GRISU_UINT64_C(0xf684df56, c3e01bc7), 49, 34},
  {GRISU_UINT64_C(0x9a130b96, 3a6c115c), 53, 35},
  {GRISU_UINT64_C(0xc097ce7b, c90715b3), 56, 36},
  {GRISU_UINT64_C(0xf0bdc21a, bb48db20), 59, 37},
  {GRISU_UINT64_C(0x96769950, b50d88f4), 63, 38},
  {GRISU_UINT64_C(0xbc143fa4, e250eb31), 66, 39},
  {GRISU_UINT64_C(0xeb194f8e, 1ae525fd), 69, 40},
  {GRISU_UINT64_C(0x92efd1b8, d0cf37be), 73, 41},
  {GRISU_UINT64_C(0xb7abc627, 050305ae), 76, 42},
  {GRISU_UINT64_C(0xe596b7b0, c643c719), 79, 43},
  {GRISU_UINT64_C(0x8f7e32ce, 7bea5c70), 83, 44},
  {GRISU_UINT64_C(0xb35dbf82, 1ae4f38c), 86, 45},
  {GRISU_UINT64_C(0xe0352f62, a19e306f), 89, 46},
  {GRISU_UINT64_C(0x8c213d9d, a502de45), 93, 47},
  {GRISU_UINT64_C(0xaf298d05, 0e4395d7), 96, 48},
  {GRISU_UINT64_C(0xdaf3f046, 51d47b4c), 99, 49},
  {GRISU_UINT64_C(0x88d8762b, f324cd10), 103, 50},
  {GRISU_UINT64_C(0xab0e93b6, efee0054), 106, 51},
  {GRISU_UINT64_C(0xd5d238a4, abe98068), 109, 52},
  {GRISU_UINT64_C(0x85a36366, eb71f041), 113, 53},
  {GRISU_UINT64_C(0xa70c3c40, a64e6c52), 116, 54},
  {GRISU_UINT64_C(0xd0cf4b50, cfe20766), 119, 55},
  {GRISU_UINT64_C(0x82818f12, 81ed44a0), 123, 56},
  {GRISU_UINT64_C(0xa321f2d7, 226895c8), 126, 57},
  {GRISU_UINT64_C(0xcbea6f8c, eb02bb3a), 129, 58},
  {GRISU_UINT64_C(0xfee50b70, 25c36a08), 132, 59},
  {GRISU_UINT64_C(0x9f4f2726, 179a2245), 136, 60},
  {GRISU_UINT64_C(0xc722f0ef, 9d80aad6), 139, 61},
  {GRISU_UINT64_C(0xf8ebad2b, 84e0d58c), 142, 62},
  {GRISU_UINT64_C(0x9b934c3b, 330c8577), 146, 63},
  {GRISU_UINT64_C(0xc2781f49, ffcfa6d5), 149, 64},
  {GRISU_UINT64_C(0xf316271c, 7fc3908b), 152, 65},
  {GRISU_UINT64_C(0x97edd871, cfda3a57), 156, 66},
  {GRISU_UINT64_C(0xbde94e8e, 43d0c8ec), 159, 67},
  {GRISU_UINT64_C(0xed63a231, d4c4fb27), 162, 68},
  {GRISU_UINT64_C(0x945e455f, 24fb1cf9), 166, 69},
  {GRISU_UINT64_C(0xb975d6b6, ee39e437), 169, 70},
  {GRISU_UINT64_C(0xe7d34c64, a9c85d44), 172, 71},
  {GRISU_UINT64_C(0x90e40fbe, ea1d3a4b), 176, 72},
  {GRISU_UINT64_C(0xb51d13ae, a4a488dd), 179, 73},
  {GRISU_UINT64_C(0xe264589a, 4dcdab15), 182, 74},
  {GRISU_UINT64_C(0x8d7eb760, 70a08aed), 186, 75},
  {GRISU_UINT64_C(0xb0de6538, 8cc8ada8), 189, 76},
  {GRISU_UINT64_C(0xdd15fe86, affad912), 192, 77},
  {GRISU_UINT64_C(0x8a2dbf14, 2dfcc7ab), 196, 78},
  {GRISU_UINT64_C(0xacb92ed9, 397bf996), 199, 79},
  {GRISU_UINT64_C(0xd7e77a8f, 87daf7fc), 202, 80},
  {GRISU_UINT64_C(0x86f0ac99, b4e8dafd), 206, 81},
  {GRISU_UINT64_C(0xa8acd7c0, 222311bd), 209, 82},
  {GRISU_UINT64_C(0xd2d80db0, 2aabd62c), 212, 83},
  {GRISU_UINT64_C(0x83c7088e, 1aab65db), 216, 84},
  {GRISU_UINT64_C(0xa4b8cab1, a1563f52), 219, 85},
  {GRISU_UINT64_C(0xcde6fd5e, 09abcf27), 222, 86},
  {GRISU_UINT64_C(0x80b05e5a, c60b6178), 226, 87},
  {GRISU_UINT64_C(0xa0dc75f1, 778e39d6), 229, 88},
  {GRISU_UINT64_C(0xc913936d, d571c84c), 232, 89},
  {GRISU_UINT64_C(0xfb587849, 4ace3a5f), 235, 90},
  {GRISU_UINT64_C(0x9d174b2d, cec0e47b), 239, 91},
  {GRISU_UINT64_C(0xc45d1df9, 42711d9a), 242, 92},
  {GRISU_UINT64_C(0xf5746577, 930d6501), 245, 93},
  {GRISU_UINT64_C(0x9968bf6a, bbe85f20), 249, 94},
  {GRISU_UINT64_C(0xbfc2ef45, 6ae276e9), 252, 95},
  {GRISU_UINT64_C(0xefb3ab16, c59b14a3), 255, 96},
  {GRISU_UINT64_C(0x95d04aee, 3b80ece6), 259, 97},
  {GRISU_UINT64_C(0xbb445da9, ca61281f), 262, 98},
  {GRISU_UINT64_C(0xea157514, 3cf97227), 265, 99},
  {GRISU_UINT64_C(0x924d692c, a61be758), 269, 100},
  {GRISU_UINT64_C(0xb6e0c377, cfa2e12e), 272, 101},
  {GRISU_UINT64_C(0xe498f455, c38b997a), 275, 102},
  {GRISU_UINT64_C(0x8edf98b5, 9a373fec), 279, 103},
  {GRISU_UINT64_C(0xb2977ee3, 00c50fe7), 282, 104},
  {GRISU_UINT64_C(0xdf3d5e9b, c0f653e1), 285, 105},
  {GRISU_UINT64_C(0x8b865b21, 5899f46d), 289, 106},
  {GRISU_UINT64_C(0xae67f1e9, aec07188), 292, 107},
  {GRISU_UINT64_C(0xda01ee64, 1a708dea), 295, 108},
  {GRISU_UINT64_C(0x884134fe, 908658b2), 299, 109},
  {GRISU_UINT64_C(0xaa51823e, 34a7eedf), 302, 110},
  {GRISU_UINT64_C(0xd4e5e2cd, c1d1ea96), 305, 111},
  {GRISU_UINT64_C(0x850fadc0, 9923329e), 309, 112},
  {GRISU_UINT64_C(0xa6539930, bf6bff46), 312, 113},
  {GRISU_UINT64_C(0xcfe87f7c, ef46ff17), 315, 114},
  {GRISU_UINT64_C(0x81f14fae, 158c5f6e), 319, 115},
  {GRISU_UINT64_C(0xa26da399, 9aef774a), 322, 116},
  {GRISU_UINT64_C(0xcb090c80, 01ab551c), 325, 117},
  {GRISU_UINT64_C(0xfdcb4fa0, 02162a63), 328, 118},
  {GRISU_UINT64_C(0x9e9f11c4, 014dda7e), 332, 119},
  {GRISU_UINT64_C(0xc646d635, 01a1511e), 335, 120},
  {GRISU_UINT64_C(0xf7d88bc2, 4209a565), 338, 121},
  {GRISU_UINT64_C(0x9ae75759, 6946075f), 342, 122},
  {GRISU_UINT64_C(0xc1a12d2f, c3978937), 345, 123},
  {GRISU_UINT64_C(0xf209787b, b47d6b85), 348, 124},
  {GRISU_UINT64_C(0x9745eb4d, 50ce6333), 352, 125},
  {GRISU_UINT64_C(0xbd176620, a501fc00), 355, 126},
  {GRISU_UINT64_C(0xec5d3fa8, ce427b00), 358, 127},
  {GRISU_UINT64_C(0x93ba47c9, 80e98ce0), 362, 128},
  {GRISU_UINT64_C(0xb8a8d9bb, e123f018), 365, 129},
  {GRISU_UINT64_C(0xe6d3102a, d96cec1e), 368, 130},
  {GRISU_UINT64_C(0x9043ea1a, c7e41393), 372, 131},
  {GRISU_UINT64_C(0xb454e4a1, 79dd1877), 375, 132},
  {GRISU_UINT64_C(0xe16a1dc9, d8545e95), 378, 133},
  {GRISU_UINT64_C(0x8ce2529e, 2734bb1d), 382, 134},
  {GRISU_UINT64_C(0xb01ae745, b101e9e4), 385, 135},
  {GRISU_UINT64_C(0xdc21a117, 1d42645d), 388, 136},
  {GRISU_UINT64_C(0x899504ae, 72497eba), 392, 137},
  {GRISU_UINT64_C(0xabfa45da, 0edbde69), 395, 138},
  {GRISU_UINT64_C(0xd6f8d750, 9292d603), 398, 139},
  {GRISU_UINT64_C(0x865b8692, 5b9bc5c2), 402, 140},
  {GRISU_UINT64_C(0xa7f26836, f282b733), 405, 141},
  {GRISU_UINT64_C(0xd1ef0244, af2364ff), 408, 142},
  {GRISU_UINT64_C(0x8335616a, ed761f1f), 412, 143},
  {GRISU_UINT64_C(0xa402b9c5, a8d3a6e7), 415, 144},
  {GRISU_UINT64_C(0xcd036837, 130890a1), 418, 145},
  {GRISU_UINT64_C(0x80222122, 6be55a65), 422, 146},
  {GRISU_UINT64_C(0xa02aa96b, 06deb0fe), 425, 147},
  {GRISU_UINT64_C(0xc83553c5, c8965d3d), 428, 148},
  {GRISU_UINT64_C(0xfa42a8b7, 3abbf48d), 431, 149},
  {GRISU_UINT64_C(0x9c69a972, 84b578d8), 435, 150},
  {GRISU_UINT64_C(0xc38413cf, 25e2d70e), 438, 151},
  {GRISU_UINT64_C(0xf46518c2, ef5b8cd1), 441, 152},
  {GRISU_UINT64_C(0x98bf2f79, d5993803), 445, 153},
  {GRISU_UINT64_C(0xbeeefb58, 4aff8604), 448, 154},
  {GRISU_UINT64_C(0xeeaaba2e, 5dbf6785), 451, 155},
  {GRISU_UINT64_C(0x952ab45c, fa97a0b3), 455, 156},
  {GRISU_UINT64_C(0xba756174, 393d88e0), 458, 157},
  {GRISU_UINT64_C(0xe912b9d1, 478ceb17), 461, 158},
  {GRISU_UINT64_C(0x91abb422, ccb812ef), 465, 159},
  {GRISU_UINT64_C(0xb616a12b, 7fe617aa), 468, 160},
  {GRISU_UINT64_C(0xe39c4976, 5fdf9d95), 471, 161},
  {GRISU_UINT64_C(0x8e41ade9, fbebc27d), 475, 162},
  {GRISU_UINT64_C(0xb1d21964, 7ae6b31c), 478, 163},
  {GRISU_UINT64_C(0xde469fbd, 99a05fe3), 481, 164},
  {GRISU_UINT64_C(0x8aec23d6, 80043bee), 485, 165},
  {GRISU_UINT64_C(0xada72ccc, 20054aea), 488, 166},
  {GRISU_UINT64_C(0xd910f7ff, 28069da4), 491, 167},
  {GRISU_UINT64_C(0x87aa9aff, 79042287), 495, 168},
  {GRISU_UINT64_C(0xa99541bf, 57452b28), 498, 169},
  {GRISU_UINT64_C(0xd3fa922f, 2d1675f2), 501, 170},
  {GRISU_UINT64_C(0x847c9b5d, 7c2e09b7), 505, 171},
  {GRISU_UINT64_C(0xa59bc234, db398c25), 508, 172},
  {GRISU_UINT64_C(0xcf02b2c2, 1207ef2f), 511, 173},
  {GRISU_UINT64_C(0x8161afb9, 4b44f57d), 515, 174},
  {GRISU_UINT64_C(0xa1ba1ba7, 9e1632dc), 518, 175},
  {GRISU_UINT64_C(0xca28a291, 859bbf93), 521, 176},
  {GRISU_UINT64_C(0xfcb2cb35, e702af78), 524, 177},
  {GRISU_UINT64_C(0x9defbf01, b061adab), 528, 178},
  {GRISU_UINT64_C(0xc56baec2, 1c7a1916), 531, 179},
  {GRISU_UINT64_C(0xf6c69a72, a3989f5c), 534, 180},
  {GRISU_UINT64_C(0x9a3c2087, a63f6399), 538, 181},
  {GRISU_UINT64_C(0xc0cb28a9, 8fcf3c80), 541, 182},
  {GRISU_UINT64_C(0xf0fdf2d3, f3c30b9f), 544, 183},
  {GRISU_UINT64_C(0x969eb7c4, 7859e744), 548, 184},
  {GRISU_UINT64_C(0xbc4665b5, 96706115), 551, 185},
  {GRISU_UINT64_C(0xeb57ff22, fc0c795a), 554, 186},
  {GRISU_UINT64_C(0x9316ff75, dd87cbd8), 558, 187},
  {GRISU_UINT64_C(0xb7dcbf53, 54e9bece), 561, 188},
  {GRISU_UINT64_C(0xe5d3ef28, 2a242e82), 564, 189},
  {GRISU_UINT64_C(0x8fa47579, 1a569d11), 568, 190},
  {GRISU_UINT64_C(0xb38d92d7, 60ec4455), 571, 191},
  {GRISU_UINT64_C(0xe070f78d, 3927556b), 574, 192},
  {GRISU_UINT64_C(0x8c469ab8, 43b89563), 578, 193},
  {GRISU_UINT64_C(0xaf584166, 54a6babb), 581, 194},
  {GRISU_UINT64_C(0xdb2e51bf, e9d0696a), 584, 195},
  {GRISU_UINT64_C(0x88fcf317, f22241e2), 588, 196},
  {GRISU_UINT64_C(0xab3c2fdd, eeaad25b), 591, 197},
  {GRISU_UINT64_C(0xd60b3bd5, 6a5586f2), 594, 198},
  {GRISU_UINT64_C(0x85c70565, 62757457), 598, 199},
  {GRISU_UINT64_C(0xa738c6be, bb12d16d), 601, 200},
  {GRISU_UINT64_C(0xd106f86e, 69d785c8), 604, 201},
  {GRISU_UINT64_C(0x82a45b45, 0226b39d), 608, 202},
  {GRISU_UINT64_C(0xa34d7216, 42b06084), 611, 203},
  {GRISU_UINT64_C(0xcc20ce9b, d35c78a5), 614, 204},
  {GRISU_UINT64_C(0xff290242, c83396ce), 617, 205},
  {GRISU_UINT64_C(0x9f79a169, bd203e41), 621, 206},
  {GRISU_UINT64_C(0xc75809c4, 2c684dd1), 624, 207},
  {GRISU_UINT64_C(0xf92e0c35, 37826146), 627, 208},
  {GRISU_UINT64_C(0x9bbcc7a1, 42b17ccc), 631, 209},
  {GRISU_UINT64_C(0xc2abf989, 935ddbfe), 634, 210},
  {GRISU_UINT64_C(0xf356f7eb, f83552fe), 637, 211},
  {GRISU_UINT64_C(0x98165af3, 7b2153df), 641, 212},
  {GRISU_UINT64_C(0xbe1bf1b0, 59e9a8d6), 644, 213},
  {GRISU_UINT64_C(0xeda2ee1c, 7064130c), 647, 214},
  {GRISU_UINT64_C(0x9485d4d1, c63e8be8), 651, 215},
  {GRISU_UINT64_C(0xb9a74a06, 37ce2ee1), 654, 216},
  {GRISU_UINT64_C(0xe8111c87, c5c1ba9a), 657, 217},
  {GRISU_UINT64_C(0x910ab1d4, db9914a0), 661, 218},
  {GRISU_UINT64_C(0xb54d5e4a, 127f59c8), 664, 219},
  {GRISU_UINT64_C(0xe2a0b5dc, 971f303a), 667, 220},
  {GRISU_UINT64_C(0x8da471a9, de737e24), 671, 221},
  {GRISU_UINT64_C(0xb10d8e14, 56105dad), 674, 222},
  {GRISU_UINT64_C(0xdd50f199, 6b947519), 677, 223},
  {GRISU_UINT64_C(0x8a5296ff, e33cc930), 681, 224},
  {GRISU_UINT64_C(0xace73cbf, dc0bfb7b), 684, 225},
  {GRISU_UINT64_C(0xd8210bef, d30efa5a), 687, 226},
  {GRISU_UINT64_C(0x8714a775, e3e95c78), 691, 227},
  {GRISU_UINT64_C(0xa8d9d153, 5ce3b396), 694, 228},
  {GRISU_UINT64_C(0xd31045a8, 341ca07c), 697, 229},
  {GRISU_UINT64_C(0x83ea2b89, 2091e44e), 701, 230},
  {GRISU_UINT64_C(0xa4e4b66b, 68b65d61), 704, 231},
  {GRISU_UINT64_C(0xce1de406, 42e3f4b9), 707, 232},
  {GRISU_UINT64_C(0x80d2ae83, e9ce78f4), 711, 233},
  {GRISU_UINT64_C(0xa1075a24, e4421731), 714, 234},
  {GRISU_UINT64_C(0xc94930ae, 1d529cfd), 717, 235},
  {GRISU_UINT64_C(0xfb9b7cd9, a4a7443c), 720, 236},
  {GRISU_UINT64_C(0x9d412e08, 06e88aa6), 724, 237},
  {GRISU_UINT64_C(0xc491798a, 08a2ad4f), 727, 238},
  {GRISU_UINT64_C(0xf5b5d7ec, 8acb58a3), 730, 239},
  {GRISU_UINT64_C(0x9991a6f3, d6bf1766), 734, 240},
  {GRISU_UINT64_C(0xbff610b0, cc6edd3f), 737, 241},
  {GRISU_UINT64_C(0xeff394dc, ff8a948f), 740, 242},
  {GRISU_UINT64_C(0x95f83d0a, 1fb69cd9), 744, 243},
  {GRISU_UINT64_C(0xbb764c4c, a7a44410), 747, 244},
  {GRISU_UINT64_C(0xea53df5f, d18d5514), 750, 245},
  {GRISU_UINT64_C(0x92746b9b, e2f8552c), 754, 246},
  {GRISU_UINT64_C(0xb7118682, dbb66a77), 757, 247},
  {GRISU_UINT64_C(0xe4d5e823, 92a40515), 760, 248},
  {GRISU_UINT64_C(0x8f05b116, 3ba6832d), 764, 249},
  {GRISU_UINT64_C(0xb2c71d5b, ca9023f8), 767, 250},
  {GRISU_UINT64_C(0xdf78e4b2, bd342cf7), 770, 251},
  {GRISU_UINT64_C(0x8bab8eef, b6409c1a), 774, 252},
  {GRISU_UINT64_C(0xae9672ab, a3d0c321), 777, 253},
  {GRISU_UINT64_C(0xda3c0f56, 8cc4f3e9), 780, 254},
  {GRISU_UINT64_C(0x88658996, 17fb1871), 784, 255},
  {GRISU_UINT64_C(0xaa7eebfb, 9df9de8e), 787, 256},
  {GRISU_UINT64_C(0xd51ea6fa, 85785631), 790, 257},
  {GRISU_UINT64_C(0x8533285c, 936b35df), 794, 258},
  {GRISU_UINT64_C(0xa67ff273, b8460357), 797, 259},
  {GRISU_UINT64_C(0xd01fef10, a657842c), 800, 260},
  {GRISU_UINT64_C(0x8213f56a, 67f6b29c), 804, 261},
  {GRISU_UINT64_C(0xa298f2c5, 01f45f43), 807, 262},
  {GRISU_UINT64_C(0xcb3f2f76, 42717713), 810, 263},
  {GRISU_UINT64_C(0xfe0efb53, d30dd4d8), 813, 264},
  {GRISU_UINT64_C(0x9ec95d14, 63e8a507), 817, 265},
  {GRISU_UINT64_C(0xc67bb459, 7ce2ce49), 820, 266},
  {GRISU_UINT64_C(0xf81aa16f, dc1b81db), 823, 267},
  {GRISU_UINT64_C(0x9b10a4e5, e9913129), 827, 268},
  {GRISU_UINT64_C(0xc1d4ce1f, 63f57d73), 830, 269},
  {GRISU_UINT64_C(0xf24a01a7, 3cf2dcd0), 833, 270},
  {GRISU_UINT64_C(0x976e4108, 8617ca02), 837, 271},
  {GRISU_UINT64_C(0xbd49d14a, a79dbc82), 840, 272},
  {GRISU_UINT64_C(0xec9c459d, 51852ba3), 843, 273},
  {GRISU_UINT64_C(0x93e1ab82, 52f33b46), 847, 274},
  {GRISU_UINT64_C(0xb8da1662, e7b00a17), 850, 275},
  {GRISU_UINT64_C(0xe7109bfb, a19c0c9d), 853, 276},
  {GRISU_UINT64_C(0x906a617d, 450187e2), 857, 277},
  {GRISU_UINT64_C(0xb484f9dc, 9641e9db), 860, 278},
  {GRISU_UINT64_C(0xe1a63853, bbd26451), 863, 279},
  {GRISU_UINT64_C(0x8d07e334, 55637eb3), 867, 280},
  {GRISU_UINT64_C(0xb049dc01, 6abc5e60), 870, 281},
  {GRISU_UINT64_C(0xdc5c5301, c56b75f7), 873, 282},
  {GRISU_UINT64_C(0x89b9b3e1, 1b6329bb), 877, 283},
  {GRISU_UINT64_C(0xac2820d9, 623bf429), 880, 284},
  {GRISU_UINT64_C(0xd732290f, bacaf134), 883, 285},
  {GRISU_UINT64_C(0x867f59a9, d4bed6c0), 887, 286},
  {GRISU_UINT64_C(0xa81f3014, 49ee8c70), 890, 287},
  {GRISU_UINT64_C(0xd226fc19, 5c6a2f8c), 893, 288},
  {GRISU_UINT64_C(0x83585d8f, d9c25db8), 897, 289},
  {GRISU_UINT64_C(0xa42e74f3, d032f526), 900, 290},
  {GRISU_UINT64_C(0xcd3a1230, c43fb26f), 903, 291},
  {GRISU_UINT64_C(0x80444b5e, 7aa7cf85), 907, 292},
  {GRISU_UINT64_C(0xa0555e36, 1951c367), 910, 293},
  {GRISU_UINT64_C(0xc86ab5c3, 9fa63441), 913, 294},
  {GRISU_UINT64_C(0xfa856334, 878fc151), 916, 295},
  {GRISU_UINT64_C(0x9c935e00, d4b9d8d2), 920, 296},
  {GRISU_UINT64_C(0xc3b83581, 09e84f07), 923, 297},
  {GRISU_UINT64_C(0xf4a642e1, 4c6262c9), 926, 298},
  {GRISU_UINT64_C(0x98e7e9cc, cfbd7dbe), 930, 299},
  {GRISU_UINT64_C(0xbf21e440, 03acdd2d), 933, 300},
  {GRISU_UINT64_C(0xeeea5d50, 04981478), 936, 301},
  {GRISU_UINT64_C(0x95527a52, 02df0ccb), 940, 302},
  {GRISU_UINT64_C(0xbaa718e6, 8396cffe), 943, 303},
  {GRISU_UINT64_C(0xe950df20, 247c83fd), 946, 304},
  {GRISU_UINT64_C(0x91d28b74, 16cdd27e), 950, 305},
  {GRISU_UINT64_C(0xb6472e51, 1c81471e), 953, 306},
  {GRISU_UINT64_C(0xe3d8f9e5, 63a198e5), 956, 307},
  {GRISU_UINT64_C(0x8e679c2f, 5e44ff8f), 960, 308},
  {GRISU_UINT64_C(0xb201833b, 35d63f73), 963, 309},
  {GRISU_UINT64_C(0xde81e40a, 034bcf50), 966, 310},
  {GRISU_UINT64_C(0x8b112e86, 420f6192), 970, 311},
  {GRISU_UINT64_C(0xadd57a27, d29339f6), 973, 312},
  {GRISU_UINT64_C(0xd94ad8b1, c7380874), 976, 313},
  {GRISU_UINT64_C(0x87cec76f, 1c830549), 980, 314},
  {GRISU_UINT64_C(0xa9c2794a, e3a3c69b), 983, 315},
  {GRISU_UINT64_C(0xd433179d, 9c8cb841), 986, 316},
  {GRISU_UINT64_C(0x849feec2, 81d7f329), 990, 317},
  {GRISU_UINT64_C(0xa5c7ea73, 224deff3), 993, 318},
  {GRISU_UINT64_C(0xcf39e50f, eae16bf0), 996, 319},
  {GRISU_UINT64_C(0x81842f29, f2cce376), 1000, 320},
  {GRISU_UINT64_C(0xa1e53af4, 6f801c53), 1003, 321},
  {GRISU_UINT64_C(0xca5e89b1, 8b602368), 1006, 322},
  {GRISU_UINT64_C(0xfcf62c1d, ee382c42), 1009, 323},
  {GRISU_UINT64_C(0x9e19db92, b4e31ba9), 1013, 324},
  {GRISU_UINT64_C(0xc5a05277, 621be294), 1016, 325},
  {GRISU_UINT64_C(0xf7086715, 3aa2db39), 1019, 326},
  {GRISU_UINT64_C(0x9a65406d, 44a5c903), 1023, 327},
  {GRISU_UINT64_C(0xc0fe9088, 95cf3b44), 1026, 328},
  {GRISU_UINT64_C(0xf13e34aa, bb430a15), 1029, 329},
  {GRISU_UINT64_C(0x96c6e0ea, b509e64d), 1033, 330},
  {GRISU_UINT64_C(0xbc789925, 624c5fe1), 1036, 331},
  {GRISU_UINT64_C(0xeb96bf6e, badf77d9), 1039, 332},
  {GRISU_UINT64_C(0x933e37a5, 34cbaae8), 1043, 333},
  {GRISU_UINT64_C(0xb80dc58e, 81fe95a1), 1046, 334},
  {GRISU_UINT64_C(0xe61136f2, 227e3b0a), 1049, 335},
  {GRISU_UINT64_C(0x8fcac257, 558ee4e6), 1053, 336},
  {GRISU_UINT64_C(0xb3bd72ed, 2af29e20), 1056, 337},
  {GRISU_UINT64_C(0xe0accfa8, 75af45a8), 1059, 338},
  {GRISU_UINT64_C(0x8c6c01c9, 498d8b89), 1063, 339},
  {GRISU_UINT64_C(0xaf87023b, 9bf0ee6b), 1066, 340},
  {GRISU_UINT64_C(0xdb68c2ca, 82ed2a06), 1069, 341},
  {GRISU_UINT64_C(0x892179be, 91d43a44), 1073, 342},
  };
static const int GRISU_CACHE_MAX_DISTANCE(1) = 4;
// nb elements (1): 651
static const GRISU_CACHE_STRUCT GRISU_CACHE_NAME(2)[] = {
  {GRISU_UINT64_C(0xe61acf03, 3d1a45df), -1087, -308},
  {GRISU_UINT64_C(0xb3c4f1ba, 87bc8697), -1080, -306},
  {GRISU_UINT64_C(0x8c71dcd9, ba0b4926), -1073, -304},
  {GRISU_UINT64_C(0xdb71e914, 32b1a24b), -1067, -302},
  {GRISU_UINT64_C(0xab70fe17, c79ac6ca), -1060, -300},
  {GRISU_UINT64_C(0x85f04682, 93f0eb4e), -1053, -298},
  {GRISU_UINT64_C(0xd1476e2c, 07286faa), -1047, -296},
  {GRISU_UINT64_C(0xa37fce12, 6597973d), -1040, -294},
  {GRISU_UINT64_C(0xff77b1fc, bebcdc4f), -1034, -292},
  {GRISU_UINT64_C(0xc795830d, 75038c1e), -1027, -290},
  {GRISU_UINT64_C(0x9becce62, 836ac577), -1020, -288},
  {GRISU_UINT64_C(0xf3a20279, ed56d48a), -1014, -286},
  {GRISU_UINT64_C(0xbe5691ef, 416bd60c), -1007, -284},
  {GRISU_UINT64_C(0x94b3a202, eb1c3f39), -1000, -282},
  {GRISU_UINT64_C(0xe858ad24, 8f5c22ca), -994, -280},
  {GRISU_UINT64_C(0xb5854744, 8ffffb2e), -987, -278},
  {GRISU_UINT64_C(0x8dd01fad, 907ffc3c), -980, -276},
  {GRISU_UINT64_C(0xdd95317f, 31c7fa1d), -974, -274},
  {GRISU_UINT64_C(0xad1c8eab, 5ee43b67), -967, -272},
  {GRISU_UINT64_C(0x873e4f75, e2224e68), -960, -270},
  {GRISU_UINT64_C(0xd3515c28, 31559a83), -954, -268},
  {GRISU_UINT64_C(0xa5178fff, 668ae0b6), -947, -266},
  {GRISU_UINT64_C(0x80fa687f, 881c7f8e), -940, -264},
  {GRISU_UINT64_C(0xc9874347, 44ac874f), -934, -262},
  {GRISU_UINT64_C(0x9d71ac8f, ada6c9b5), -927, -260},
  {GRISU_UINT64_C(0xf6019da0, 7f549b2b), -921, -258},
  {GRISU_UINT64_C(0xc0314325, 637a193a), -914, -256},
  {GRISU_UINT64_C(0x96267c75, 35b763b5), -907, -254},
  {GRISU_UINT64_C(0xea9c2277, 23ee8bcb), -901, -252},
  {GRISU_UINT64_C(0xb749faed, 14125d37), -894, -250},
  {GRISU_UINT64_C(0x8f31cc09, 37ae58d3), -887, -248},
  {GRISU_UINT64_C(0xdfbdcece, 67006ac9), -881, -246},
  {GRISU_UINT64_C(0xaecc4991, 4078536d), -874, -244},
  {GRISU_UINT64_C(0x888f9979, 7a5e012d), -867, -242},
  {GRISU_UINT64_C(0xd5605fcd, cf32e1d7), -861, -240},
  {GRISU_UINT64_C(0xa6b34ad8, c9dfc070), -854, -238},
  {GRISU_UINT64_C(0x823c1279, 5db6ce57), -847, -236},
  {GRISU_UINT64_C(0xcb7ddcdd, a26da269), -841, -234},
  {GRISU_UINT64_C(0x9efa548d, 26e5a6e2), -834, -232},
  {GRISU_UINT64_C(0xf867241c, 8cc6d4c1), -828, -230},
  {GRISU_UINT64_C(0xc2109436, 4dfb5637), -821, -228},
  {GRISU_UINT64_C(0x979cf3ca, 6cec5b5b), -814, -226},
  {GRISU_UINT64_C(0xece53cec, 4a314ebe), -808, -224},
  {GRISU_UINT64_C(0xb9131798, 99f68584), -801, -222},
  {GRISU_UINT64_C(0x9096ea6f, 3848984f), -794, -220},
  {GRISU_UINT64_C(0xe1ebce4d, c7f16dfc), -788, -218},
  {GRISU_UINT64_C(0xb080392c, c4349ded), -781, -216},
  {GRISU_UINT64_C(0x89e42caa, f9491b61), -774, -214},
  {GRISU_UINT64_C(0xd77485cb, 25823ac7), -768, -212},
  {GRISU_UINT64_C(0xa8530886, b54dbdec), -761, -210},
  {GRISU_UINT64_C(0x8380dea9, 3da4bc60), -754, -208},
  {GRISU_UINT64_C(0xcd795be8, 70516656), -748, -206},
  {GRISU_UINT64_C(0xa086cfcd, 97bf97f4), -741, -204},
  {GRISU_UINT64_C(0xfad2a4b1, 3d1b5d6c), -735, -202},
  {GRISU_UINT64_C(0xc3f490aa, 77bd60fd), -728, -200},
  {GRISU_UINT64_C(0x99171105, 2d8bf3c5), -721, -198},
  {GRISU_UINT64_C(0xef340a98, 172aace5), -715, -196},
  {GRISU_UINT64_C(0xbae0a846, d2195713), -708, -194},
  {GRISU_UINT64_C(0x91ff8377, 5423cc06), -701, -192},
  {GRISU_UINT64_C(0xe41f3d6a, 7377eeca), -695, -190},
  {GRISU_UINT64_C(0xb23867fb, 2a35b28e), -688, -188},
  {GRISU_UINT64_C(0x8b3c113c, 38f9f37f), -681, -186},
  {GRISU_UINT64_C(0xd98ddaee, 19068c76), -675, -184},
  {GRISU_UINT64_C(0xa9f6d30a, 038d1dbc), -668, -182},
  {GRISU_UINT64_C(0x84c8d4df, d2c63f3b), -661, -180},
  {GRISU_UINT64_C(0xcf79cc9d, b955c2cc), -655, -178},
  {GRISU_UINT64_C(0xa21727db, 38cb0030), -648, -176},
  {GRISU_UINT64_C(0xfd442e46, 88bd304b), -642, -174},
  {GRISU_UINT64_C(0xc5dd4427, 1ad3cdba), -635, -172},
  {GRISU_UINT64_C(0x9a94dd3e, 8cf578ba), -628, -170},
  {GRISU_UINT64_C(0xf18899b1, bc3f8ca2), -622, -168},
  {GRISU_UINT64_C(0xbcb2b812, db11a5de), -615, -166},
  {GRISU_UINT64_C(0x936b9fce, bb25c996), -608, -164},
  {GRISU_UINT64_C(0xe65829b3, 046b0afa), -602, -162},
  {GRISU_UINT64_C(0xb3f4e093, db73a093), -595, -160},
  {GRISU_UINT64_C(0x8c974f73, 83725573), -588, -158},
  {GRISU_UINT64_C(0xdbac6c24, 7d62a584), -582, -156},
  {GRISU_UINT64_C(0xab9eb47c, 81f5114f), -575, -154},
  {GRISU_UINT64_C(0x8613fd01, 45877586), -568, -152},
  {GRISU_UINT64_C(0xd17f3b51, fca3a7a1), -562, -150},
  {GRISU_UINT64_C(0xa3ab6658, 0d5fdaf6), -555, -148},
  {GRISU_UINT64_C(0xffbbcfe9, 94e5c620), -549, -146},
  {GRISU_UINT64_C(0xc7caba6e, 7c5382c9), -542, -144},
  {GRISU_UINT64_C(0x9c1661a6, 51213e2d), -535, -142},
  {GRISU_UINT64_C(0xf3e2f893, dec3f126), -529, -140},
  {GRISU_UINT64_C(0xbe895233, 86091466), -522, -138},
  {GRISU_UINT64_C(0x94db4838, 40b717f0), -515, -136},
  {GRISU_UINT64_C(0xe896a0d7, e51e1566), -509, -134},
  {GRISU_UINT64_C(0xb5b5ada8, aaff80b8), -502, -132},
  {GRISU_UINT64_C(0x8df5efab, c5979c90), -495, -130},
  {GRISU_UINT64_C(0xddd0467c, 64bce4a1), -489, -128},
  {GRISU_UINT64_C(0xad4ab711, 2eb3929e), -482, -126},
  {GRISU_UINT64_C(0x87625f05, 6c7c4a8b), -475, -124},
  {GRISU_UINT64_C(0xd389b478, 79823479), -469, -122},
  {GRISU_UINT64_C(0xa54394fe, 1eedb8ff), -462, -120},
  {GRISU_UINT64_C(0x811ccc66, 8829b887), -455, -118},
  {GRISU_UINT64_C(0xc9bcff60, 34c13053), -449, -116},
  {GRISU_UINT64_C(0x9d9ba783, 2936edc1), -442, -114},
  {GRISU_UINT64_C(0xf64335bc, f065d37d), -436, -112},
  {GRISU_UINT64_C(0xc06481fb, 9bcf8d3a), -429, -110},
  {GRISU_UINT64_C(0x964e858c, 91ba2655), -422, -108},
  {GRISU_UINT64_C(0xeadab0ab, a3b2dbe5), -416, -106},
  {GRISU_UINT64_C(0xb77ada06, 17e3bbcb), -409, -104},
  {GRISU_UINT64_C(0x8f57fa54, c2a9eab7), -402, -102},
  {GRISU_UINT64_C(0xdff97724, 70297ebd), -396, -100},
  {GRISU_UINT64_C(0xaefae514, 77a06b04), -389, -98},
  {GRISU_UINT64_C(0x88b402f7, fd75539b), -382, -96},
  {GRISU_UINT64_C(0xd59944a3, 7c0752a2), -376, -94},
  {GRISU_UINT64_C(0xa6dfbd9f, b8e5b88f), -369, -92},
  {GRISU_UINT64_C(0x825ecc24, c8737830), -362, -90},
  {GRISU_UINT64_C(0xcbb41ef9, 79346bca), -356, -88},
  {GRISU_UINT64_C(0x9f24b832, e6b0f436), -349, -86},
  {GRISU_UINT64_C(0xf8a95fcf, 88747d94), -343, -84},
  {GRISU_UINT64_C(0xc24452da, 229b021c), -336, -82},
  {GRISU_UINT64_C(0x97c560ba, 6b0919a6), -329, -80},
  {GRISU_UINT64_C(0xed246723, 473e3813), -323, -78},
  {GRISU_UINT64_C(0xb9447093, 8fa89bcf), -316, -76},
  {GRISU_UINT64_C(0x90bd77f3, 483bb9ba), -309, -74},
  {GRISU_UINT64_C(0xe2280b6c, 20dd5232), -303, -72},
  {GRISU_UINT64_C(0xb0af48ec, 79ace837), -296, -70},
  {GRISU_UINT64_C(0x8a08f0f8, bf0f156b), -289, -68},
  {GRISU_UINT64_C(0xd7adf884, aa879177), -283, -66},
  {GRISU_UINT64_C(0xa87fea27, a539e9a5), -276, -64},
  {GRISU_UINT64_C(0x83a3eeee, f9153e89), -269, -62},
  {GRISU_UINT64_C(0xcdb02555, 653131b6), -263, -60},
  {GRISU_UINT64_C(0xa0b19d2a, b70e6ed6), -256, -58},
  {GRISU_UINT64_C(0xfb158592, be068d2f), -250, -56},
  {GRISU_UINT64_C(0xc428d05a, a4751e4d), -243, -54},
  {GRISU_UINT64_C(0x993fe2c6, d07b7fac), -236, -52},
  {GRISU_UINT64_C(0xef73d256, a5c0f77d), -230, -50},
  {GRISU_UINT64_C(0xbb127c53, b17ec159), -223, -48},
  {GRISU_UINT64_C(0x92267121, 62ab070e), -216, -46},
  {GRISU_UINT64_C(0xe45c10c4, 2a2b3b06), -210, -44},
  {GRISU_UINT64_C(0xb267ed19, 40f1c61c), -203, -42},
  {GRISU_UINT64_C(0x8b61313b, babce2c6), -196, -40},
  {GRISU_UINT64_C(0xd9c7dced, 53c72256), -190, -38},
  {GRISU_UINT64_C(0xaa242499, 697392d3), -183, -36},
  {GRISU_UINT64_C(0x84ec3c97, da624ab5), -176, -34},
  {GRISU_UINT64_C(0xcfb11ead, 453994ba), -170, -32},
  {GRISU_UINT64_C(0xa2425ff7, 5e14fc32), -163, -30},
  {GRISU_UINT64_C(0xfd87b5f2, 8300ca0e), -157, -28},
  {GRISU_UINT64_C(0xc6120625, 76589ddb), -150, -26},
  {GRISU_UINT64_C(0x9abe14cd, 44753b53), -143, -24},
  {GRISU_UINT64_C(0xf1c90080, baf72cb1), -137, -22},
  {GRISU_UINT64_C(0xbce50864, 92111aeb), -130, -20},
  {GRISU_UINT64_C(0x9392ee8e, 921d5d07), -123, -18},
  {GRISU_UINT64_C(0xe69594be, c44de15b), -117, -16},
  {GRISU_UINT64_C(0xb424dc35, 095cd80f), -110, -14},
  {GRISU_UINT64_C(0x8cbccc09, 6f5088cc), -103, -12},
  {GRISU_UINT64_C(0xdbe6fece, bdedd5bf), -97, -10},
  {GRISU_UINT64_C(0xabcc7711, 8461cefd), -90, -8},
  {GRISU_UINT64_C(0x8637bd05, af6c69b6), -83, -6},
  {GRISU_UINT64_C(0xd1b71758, e219652c), -77, -4},
  {GRISU_UINT64_C(0xa3d70a3d, 70a3d70a), -70, -2},
  {GRISU_UINT64_C(0x80000000, 00000000), -63, 0},
  {GRISU_UINT64_C(0xc8000000, 00000000), -57, 2},
  {GRISU_UINT64_C(0x9c400000, 00000000), -50, 4},
  {GRISU_UINT64_C(0xf4240000, 00000000), -44, 6},
  {GRISU_UINT64_C(0xbebc2000, 00000000), -37, 8},
  {GRISU_UINT64_C(0x9502f900, 00000000), -30, 10},
  {GRISU_UINT64_C(0xe8d4a510, 00000000), -24, 12},
  {GRISU_UINT64_C(0xb5e620f4, 80000000), -17, 14},
  {GRISU_UINT64_C(0x8e1bc9bf, 04000000), -10, 16},
  {GRISU_UINT64_C(0xde0b6b3a, 76400000), -4, 18},
  {GRISU_UINT64_C(0xad78ebc5, ac620000), 3, 20},
  {GRISU_UINT64_C(0x87867832, 6eac9000), 10, 22},
  {GRISU_UINT64_C(0xd3c21bce, cceda100), 16, 24},
  {GRISU_UINT64_C(0xa56fa5b9, 9019a5c8), 23, 26},
  {GRISU_UINT64_C(0x813f3978, f8940984), 30, 28},
  {GRISU_UINT64_C(0xc9f2c9cd, 04674edf), 36, 30},
  {GRISU_UINT64_C(0x9dc5ada8, 2b70b59e), 43, 32},
  {GRISU_UINT64_C(0xf684df56, c3e01bc7), 49, 34},
  {GRISU_UINT64_C(0xc097ce7b, c90715b3), 56, 36},
  {GRISU_UINT64_C(0x96769950, b50d88f4), 63, 38},
  {GRISU_UINT64_C(0xeb194f8e, 1ae525fd), 69, 40},
  {GRISU_UINT64_C(0xb7abc627, 050305ae), 76, 42},
  {GRISU_UINT64_C(0x8f7e32ce, 7bea5c70), 83, 44},
  {GRISU_UINT64_C(0xe0352f62, a19e306f), 89, 46},
  {GRISU_UINT64_C(0xaf298d05, 0e4395d7), 96, 48},
  {GRISU_UINT64_C(0x88d8762b, f324cd10), 103, 50},
  {GRISU_UINT64_C(0xd5d238a4, abe98068), 109, 52},
  {GRISU_UINT64_C(0xa70c3c40, a64e6c52), 116, 54},
  {GRISU_UINT64_C(0x82818f12, 81ed44a0), 123, 56},
  {GRISU_UINT64_C(0xcbea6f8c, eb02bb3a), 129, 58},
  {GRISU_UINT64_C(0x9f4f2726, 179a2245), 136, 60},
  {GRISU_UINT64_C(0xf8ebad2b, 84e0d58c), 142, 62},
  {GRISU_UINT64_C(0xc2781f49, ffcfa6d5), 149, 64},
  {GRISU_UINT64_C(0x97edd871, cfda3a57), 156, 66},
  {GRISU_UINT64_C(0xed63a231, d4c4fb27), 162, 68},
  {GRISU_UINT64_C(0xb975d6b6, ee39e437), 169, 70},
  {GRISU_UINT64_C(0x90e40fbe, ea1d3a4b), 176, 72},
  {GRISU_UINT64_C(0xe264589a, 4dcdab15), 182, 74},
  {GRISU_UINT64_C(0xb0de6538, 8cc8ada8), 189, 76},
  {GRISU_UINT64_C(0x8a2dbf14, 2dfcc7ab), 196, 78},
  {GRISU_UINT64_C(0xd7e77a8f, 87daf7fc), 202, 80},
  {GRISU_UINT64_C(0xa8acd7c0, 222311bd), 209, 82},
  {GRISU_UINT64_C(0x83c7088e, 1aab65db), 216, 84},
  {GRISU_UINT64_C(0xcde6fd5e, 09abcf27), 222, 86},
  {GRISU_UINT64_C(0xa0dc75f1, 778e39d6), 229, 88},
  {GRISU_UINT64_C(0xfb587849, 4ace3a5f), 235, 90},
  {GRISU_UINT64_C(0xc45d1df9, 42711d9a), 242, 92},
  {GRISU_UINT64_C(0x9968bf6a, bbe85f20), 249, 94},
  {GRISU_UINT64_C(0xefb3ab16, c59b14a3), 255, 96},
  {GRISU_UINT64_C(0xbb445da9, ca61281f), 262, 98},
  {GRISU_UINT64_C(0x924d692c, a61be758), 269, 100},
  {GRISU_UINT64_C(0xe498f455, c38b997a), 275, 102},
  {GRISU_UINT64_C(0xb2977ee3, 00c50fe7), 282, 104},
  {GRISU_UINT64_C(0x8b865b21, 5899f46d), 289, 106},
  {GRISU_UINT64_C(0xda01ee64, 1a708dea), 295, 108},
  {GRISU_UINT64_C(0xaa51823e, 34a7eedf), 302, 110},
  {GRISU_UINT64_C(0x850fadc0, 9923329e), 309, 112},
  {GRISU_UINT64_C(0xcfe87f7c, ef46ff17), 315, 114},
  {GRISU_UINT64_C(0xa26da399, 9aef774a), 322, 116},
  {GRISU_UINT64_C(0xfdcb4fa0, 02162a63), 328, 118},
  {GRISU_UINT64_C(0xc646d635, 01a1511e), 335, 120},
  {GRISU_UINT64_C(0x9ae75759, 6946075f), 342, 122},
  {GRISU_UINT64_C(0xf209787b, b47d6b85), 348, 124},
  {GRISU_UINT64_C(0xbd176620, a501fc00), 355, 126},
  {GRISU_UINT64_C(0x93ba47c9, 80e98ce0), 362, 128},
  {GRISU_UINT64_C(0xe6d3102a, d96cec1e), 368, 130},
  {GRISU_UINT64_C(0xb454e4a1, 79dd1877), 375, 132},
  {GRISU_UINT64_C(0x8ce2529e, 2734bb1d), 382, 134},
  {GRISU_UINT64_C(0xdc21a117, 1d42645d), 388, 136},
  {GRISU_UINT64_C(0xabfa45da, 0edbde69), 395, 138},
  {GRISU_UINT64_C(0x865b8692, 5b9bc5c2), 402, 140},
  {GRISU_UINT64_C(0xd1ef0244, af2364ff), 408, 142},
  {GRISU_UINT64_C(0xa402b9c5, a8d3a6e7), 415, 144},
  {GRISU_UINT64_C(0x80222122, 6be55a65), 422, 146},
  {GRISU_UINT64_C(0xc83553c5, c8965d3d), 428, 148},
  {GRISU_UINT64_C(0x9c69a972, 84b578d8), 435, 150},
  {GRISU_UINT64_C(0xf46518c2, ef5b8cd1), 441, 152},
  {GRISU_UINT64_C(0xbeeefb58, 4aff8604), 448, 154},
  {GRISU_UINT64_C(0x952ab45c, fa97a0b3), 455, 156},
  {GRISU_UINT64_C(0xe912b9d1, 478ceb17), 461, 158},
  {GRISU_UINT64_C(0xb616a12b, 7fe617aa), 468, 160},
  {GRISU_UINT64_C(0x8e41ade9, fbebc27d), 475, 162},
  {GRISU_UINT64_C(0xde469fbd, 99a05fe3), 481, 164},
  {GRISU_UINT64_C(0xada72ccc, 20054aea), 488, 166},
  {GRISU_UINT64_C(0x87aa9aff, 79042287), 495, 168},
  {GRISU_UINT64_C(0xd3fa922f, 2d1675f2), 501, 170},
  {GRISU_UINT64_C(0xa59bc234, db398c25), 508, 172},
  {GRISU_UINT64_C(0x8161afb9, 4b44f57d), 515, 174},
  {GRISU_UINT64_C(0xca28a291, 859bbf93), 521, 176},
  {GRISU_UINT64_C(0x9defbf01, b061adab), 528, 178},
  {GRISU_UINT64_C(0xf6c69a72, a3989f5c), 534, 180},
  {GRISU_UINT64_C(0xc0cb28a9, 8fcf3c80), 541, 182},
  {GRISU_UINT64_C(0x969eb7c4, 7859e744), 548, 184},
  {GRISU_UINT64_C(0xeb57ff22, fc0c795a), 554, 186},
  {GRISU_UINT64_C(0xb7dcbf53, 54e9bece), 561, 188},
  {GRISU_UINT64_C(0x8fa47579, 1a569d11), 568, 190},
  {GRISU_UINT64_C(0xe070f78d, 3927556b), 574, 192},
  {GRISU_UINT64_C(0xaf584166, 54a6babb), 581, 194},
  {GRISU_UINT64_C(0x88fcf317, f22241e2), 588, 196},
  {GRISU_UINT64_C(0xd60b3bd5, 6a5586f2), 594, 198},
  {GRISU_UINT64_C(0xa738c6be, bb12d16d), 601, 200},
  {GRISU_UINT64_C(0x82a45b45, 0226b39d), 608, 202},
  {GRISU_UINT64_C(0xcc20ce9b, d35c78a5), 614, 204},
  {GRISU_UINT64_C(0x9f79a169, bd203e41), 621, 206},
  {GRISU_UINT64_C(0xf92e0c35, 37826146), 627, 208},
  {GRISU_UINT64_C(0xc2abf989, 935ddbfe), 634, 210},
  {GRISU_UINT64_C(0x98165af3, 7b2153df), 641, 212},
  {GRISU_UINT64_C(0xeda2ee1c, 7064130c), 647, 214},
  {GRISU_UINT64_C(0xb9a74a06, 37ce2ee1), 654, 216},
  {GRISU_UINT64_C(0x910ab1d4, db9914a0), 661, 218},
  {GRISU_UINT64_C(0xe2a0b5dc, 971f303a), 667, 220},
  {GRISU_UINT64_C(0xb10d8e14, 56105dad), 674, 222},
  {GRISU_UINT64_C(0x8a5296ff, e33cc930), 681, 224},
  {GRISU_UINT64_C(0xd8210bef, d30efa5a), 687, 226},
  {GRISU_UINT64_C(0xa8d9d153, 5ce3b396), 694, 228},
  {GRISU_UINT64_C(0x83ea2b89, 2091e44e), 701, 230},
  {GRISU_UINT64_C(0xce1de406, 42e3f4b9), 707, 232},
  {GRISU_UINT64_C(0xa1075a24, e4421731), 714, 234},
  {GRISU_UINT64_C(0xfb9b7cd9, a4a7443c), 720, 236},
  {GRISU_UINT64_C(0xc491798a, 08a2ad4f), 727, 238},
  {GRISU_UINT64_C(0x9991a6f3, d6bf1766), 734, 240},
  {GRISU_UINT64_C(0xeff394dc, ff8a948f), 740, 242},
  {GRISU_UINT64_C(0xbb764c4c, a7a44410), 747, 244},
  {GRISU_UINT64_C(0x92746b9b, e2f8552c), 754, 246},
  {GRISU_UINT64_C(0xe4d5e823, 92a40515), 760, 248},
  {GRISU_UINT64_C(0xb2c71d5b, ca9023f8), 767, 250},
  {GRISU_UINT64_C(0x8bab8eef, b6409c1a), 774, 252},
  {GRISU_UINT64_C(0xda3c0f56, 8cc4f3e9), 780, 254},
  {GRISU_UINT64_C(0xaa7eebfb, 9df9de8e), 787, 256},
  {GRISU_UINT64_C(0x8533285c, 936b35df), 794, 258},
  {GRISU_UINT64_C(0xd01fef10, a657842c), 800, 260},
  {GRISU_UINT64_C(0xa298f2c5, 01f45f43), 807, 262},
  {GRISU_UINT64_C(0xfe0efb53, d30dd4d8), 813, 264},
  {GRISU_UINT64_C(0xc67bb459, 7ce2ce49), 820, 266},
  {GRISU_UINT64_C(0x9b10a4e5, e9913129), 827, 268},
  {GRISU_UINT64_C(0xf24a01a7, 3cf2dcd0), 833, 270},
  {GRISU_UINT64_C(0xbd49d14a, a79dbc82), 840, 272},
  {GRISU_UINT64_C(0x93e1ab82, 52f33b46), 847, 274},
  {GRISU_UINT64_C(0xe7109bfb, a19c0c9d), 853, 276},
  {GRISU_UINT64_C(0xb484f9dc, 9641e9db), 860, 278},
  {GRISU_UINT64_C(0x8d07e334, 55637eb3), 867, 280},
  {GRISU_UINT64_C(0xdc5c5301, c56b75f7), 873, 282},
  {GRISU_UINT64_C(0xac2820d9, 623bf429), 880, 284},
  {GRISU_UINT64_C(0x867f59a9, d4bed6c0), 887, 286},
  {GRISU_UINT64_C(0xd226fc19, 5c6a2f8c), 893, 288},
  {GRISU_UINT64_C(0xa42e74f3, d032f526), 900, 290},
  {GRISU_UINT64_C(0x80444b5e, 7aa7cf85), 907, 292},
  {GRISU_UINT64_C(0xc86ab5c3, 9fa63441), 913, 294},
  {GRISU_UINT64_C(0x9c935e00, d4b9d8d2), 920, 296},
  {GRISU_UINT64_C(0xf4a642e1, 4c6262c9), 926, 298},
  {GRISU_UINT64_C(0xbf21e440, 03acdd2d), 933, 300},
  {GRISU_UINT64_C(0x95527a52, 02df0ccb), 940, 302},
  {GRISU_UINT64_C(0xe950df20, 247c83fd), 946, 304},
  {GRISU_UINT64_C(0xb6472e51, 1c81471e), 953, 306},
  {GRISU_UINT64_C(0x8e679c2f, 5e44ff8f), 960, 308},
  {GRISU_UINT64_C(0xde81e40a, 034bcf50), 966, 310},
  {GRISU_UINT64_C(0xadd57a27, d29339f6), 973, 312},
  {GRISU_UINT64_C(0x87cec76f, 1c830549), 980, 314},
  {GRISU_UINT64_C(0xd433179d, 9c8cb841), 986, 316},
  {GRISU_UINT64_C(0xa5c7ea73, 224deff3), 993, 318},
  {GRISU_UINT64_C(0x81842f29, f2cce376), 1000, 320},
  {GRISU_UINT64_C(0xca5e89b1, 8b602368), 1006, 322},
  {GRISU_UINT64_C(0x9e19db92, b4e31ba9), 1013, 324},
  {GRISU_UINT64_C(0xf7086715, 3aa2db39), 1019, 326},
  {GRISU_UINT64_C(0xc0fe9088, 95cf3b44), 1026, 328},
  {GRISU_UINT64_C(0x96c6e0ea, b509e64d), 1033, 330},
  {GRISU_UINT64_C(0xeb96bf6e, badf77d9), 1039, 332},
  {GRISU_UINT64_C(0xb80dc58e, 81fe95a1), 1046, 334},
  {GRISU_UINT64_C(0x8fcac257, 558ee4e6), 1053, 336},
  {GRISU_UINT64_C(0xe0accfa8, 75af45a8), 1059, 338},
  {GRISU_UINT64_C(0xaf87023b, 9bf0ee6b), 1066, 340},
  {GRISU_UINT64_C(0x892179be, 91d43a44), 1073, 342},
  };
static const int GRISU_CACHE_MAX_DISTANCE(2) = 7;
// nb elements (2): 326
static const GRISU_CACHE_STRUCT GRISU_CACHE_NAME(3)[] = {
  {GRISU_UINT64_C(0xe61acf03, 3d1a45df), -1087, -308},
  {GRISU_UINT64_C(0xe0b62e29, 29aba83c), -1077, -305},
  {GRISU_UINT64_C(0xdb71e914, 32b1a24b), -1067, -302},
  {GRISU_UINT64_C(0xd64d3d9d, b981787d), -1057, -299},
  {GRISU_UINT64_C(0xd1476e2c, 07286faa), -1047, -296},
  {GRISU_UINT64_C(0xcc5fc196, fefd7d0c), -1037, -293},
  {GRISU_UINT64_C(0xc795830d, 75038c1e), -1027, -290},
  {GRISU_UINT64_C(0xc2e801fb, 244576d5), -1017, -287},
  {GRISU_UINT64_C(0xbe5691ef, 416bd60c), -1007, -284},
  {GRISU_UINT64_C(0xb9e08a83, a5e34f08), -997, -281},
  {GRISU_UINT64_C(0xb5854744, 8ffffb2e), -987, -278},
  {GRISU_UINT64_C(0xb1442798, f49ffb4b), -977, -275},
  {GRISU_UINT64_C(0xad1c8eab, 5ee43b67), -967, -272},
  {GRISU_UINT64_C(0xa90de353, 5aaae202), -957, -269},
  {GRISU_UINT64_C(0xa5178fff, 668ae0b6), -947, -266},
  {GRISU_UINT64_C(0xa139029f, 6a239f72), -937, -263},
  {GRISU_UINT64_C(0x9d71ac8f, ada6c9b5), -927, -260},
  {GRISU_UINT64_C(0x99c10284, 4f94e0fb), -917, -257},
  {GRISU_UINT64_C(0x96267c75, 35b763b5), -907, -254},
  {GRISU_UINT64_C(0x92a1958a, 7675175f), -897, -251},
  {GRISU_UINT64_C(0x8f31cc09, 37ae58d3), -887, -248},
  {GRISU_UINT64_C(0x8bd6a141, 006042be), -877, -245},
  {GRISU_UINT64_C(0x888f9979, 7a5e012d), -867, -242},
  {GRISU_UINT64_C(0x855c3be0, a17fcd26), -857, -239},
  {GRISU_UINT64_C(0x823c1279, 5db6ce57), -847, -236},
  {GRISU_UINT64_C(0xfe5d5415, 0b090b03), -838, -233},
  {GRISU_UINT64_C(0xf867241c, 8cc6d4c1), -828, -230},
  {GRISU_UINT64_C(0xf294b943, e17a2bc4), -818, -227},
  {GRISU_UINT64_C(0xece53cec, 4a314ebe), -808, -224},
  {GRISU_UINT64_C(0xe757dd7e, c07426e5), -798, -221},
  {GRISU_UINT64_C(0xe1ebce4d, c7f16dfc), -788, -218},
  {GRISU_UINT64_C(0xdca04777, f541c568), -778, -215},
  {GRISU_UINT64_C(0xd77485cb, 25823ac7), -768, -212},
  {GRISU_UINT64_C(0xd267caa8, 62a12d67), -758, -209},
  {GRISU_UINT64_C(0xcd795be8, 70516656), -748, -206},
  {GRISU_UINT64_C(0xc8a883c0, fdaf7df0), -738, -203},
  {GRISU_UINT64_C(0xc3f490aa, 77bd60fd), -728, -200},
  {GRISU_UINT64_C(0xbf5cd546, 78eef0b7), -718, -197},
  {GRISU_UINT64_C(0xbae0a846, d2195713), -708, -194},
  {GRISU_UINT64_C(0xb67f6455, 292cbf08), -698, -191},
  {GRISU_UINT64_C(0xb23867fb, 2a35b28e), -688, -188},
  {GRISU_UINT64_C(0xae0b158b, 4738705f), -678, -185},
  {GRISU_UINT64_C(0xa9f6d30a, 038d1dbc), -668, -182},
  {GRISU_UINT64_C(0xa5fb0a17, c777cf0a), -658, -179},
  {GRISU_UINT64_C(0xa21727db, 38cb0030), -648, -176},
  {GRISU_UINT64_C(0x9e4a9cec, 15763e2f), -638, -173},
  {GRISU_UINT64_C(0x9a94dd3e, 8cf578ba), -628, -170},
  {GRISU_UINT64_C(0x96f5600f, 15a7b7e5), -618, -167},
  {GRISU_UINT64_C(0x936b9fce, bb25c996), -608, -164},
  {GRISU_UINT64_C(0x8ff71a0f, e2c2e6dc), -598, -161},
  {GRISU_UINT64_C(0x8c974f73, 83725573), -588, -158},
  {GRISU_UINT64_C(0x894bc396, ce5da772), -578, -155},
  {GRISU_UINT64_C(0x8613fd01, 45877586), -568, -152},
  {GRISU_UINT64_C(0x82ef8513, 3de648c5), -558, -149},
  {GRISU_UINT64_C(0xffbbcfe9, 94e5c620), -549, -146},
  {GRISU_UINT64_C(0xf9bd690a, 1b68637b), -539, -143},
  {GRISU_UINT64_C(0xf3e2f893, dec3f126), -529, -140},
  {GRISU_UINT64_C(0xee2ba6c0, 678b597f), -519, -137},
  {GRISU_UINT64_C(0xe896a0d7, e51e1566), -509, -134},
  {GRISU_UINT64_C(0xe3231912, d5bf60e6), -499, -131},
  {GRISU_UINT64_C(0xddd0467c, 64bce4a1), -489, -128},
  {GRISU_UINT64_C(0xd89d64d5, 7a607745), -479, -125},
  {GRISU_UINT64_C(0xd389b478, 79823479), -469, -122},
  {GRISU_UINT64_C(0xce947a3d, a6a9273e), -459, -119},
  {GRISU_UINT64_C(0xc9bcff60, 34c13053), -449, -116},
  {GRISU_UINT64_C(0xc5029163, f384a931), -439, -113},
  {GRISU_UINT64_C(0xc06481fb, 9bcf8d3a), -429, -110},
  {GRISU_UINT64_C(0xbbe226ef, b628afeb), -419, -107},
  {GRISU_UINT64_C(0xb77ada06, 17e3bbcb), -409, -104},
  {GRISU_UINT64_C(0xb32df8e9, f3546564), -399, -101},
  {GRISU_UINT64_C(0xaefae514, 77a06b04), -389, -98},
  {GRISU_UINT64_C(0xaae103b5, fcd2a882), -379, -95},
  {GRISU_UINT64_C(0xa6dfbd9f, b8e5b88f), -369, -92},
  {GRISU_UINT64_C(0xa2f67f2d, fa90563b), -359, -89},
  {GRISU_UINT64_C(0x9f24b832, e6b0f436), -349, -86},
  {GRISU_UINT64_C(0x9b69dbe1, b548ce7d), -339, -83},
  {GRISU_UINT64_C(0x97c560ba, 6b0919a6), -329, -80},
  {GRISU_UINT64_C(0x9436c076, 0c86e30c), -319, -77},
  {GRISU_UINT64_C(0x90bd77f3, 483bb9ba), -309, -74},
  {GRISU_UINT64_C(0x8d590723, 948a535f), -299, -71},
  {GRISU_UINT64_C(0x8a08f0f8, bf0f156b), -289, -68},
  {GRISU_UINT64_C(0x86ccbb52, ea94baeb), -279, -65},
  {GRISU_UINT64_C(0x83a3eeee, f9153e89), -269, -62},
  {GRISU_UINT64_C(0x808e1755, 5f3ebf12), -259, -59},
  {GRISU_UINT64_C(0xfb158592, be068d2f), -250, -56},
  {GRISU_UINT64_C(0xf5330471, 4d9265e0), -240, -53},
  {GRISU_UINT64_C(0xef73d256, a5c0f77d), -230, -50},
  {GRISU_UINT64_C(0xe9d71b68, 9dde71b0), -220, -47},
  {GRISU_UINT64_C(0xe45c10c4, 2a2b3b06), -210, -44},
  {GRISU_UINT64_C(0xdf01e85f, 912e37a3), -200, -41},
  {GRISU_UINT64_C(0xd9c7dced, 53c72256), -190, -38},
  {GRISU_UINT64_C(0xd4ad2dbf, c3d07788), -180, -35},
  {GRISU_UINT64_C(0xcfb11ead, 453994ba), -170, -32},
  {GRISU_UINT64_C(0xcad2f7f5, 359a3b3e), -160, -29},
  {GRISU_UINT64_C(0xc6120625, 76589ddb), -150, -26},
  {GRISU_UINT64_C(0xc16d9a00, 95928a27), -140, -23},
  {GRISU_UINT64_C(0xbce50864, 92111aeb), -130, -20},
  {GRISU_UINT64_C(0xb877aa32, 36a4b449), -120, -17},
  {GRISU_UINT64_C(0xb424dc35, 095cd80f), -110, -14},
  {GRISU_UINT64_C(0xafebff0b, cb24aaff), -100, -11},
  {GRISU_UINT64_C(0xabcc7711, 8461cefd), -90, -8},
  {GRISU_UINT64_C(0xa7c5ac47, 1b478423), -80, -5},
  {GRISU_UINT64_C(0xa3d70a3d, 70a3d70a), -70, -2},
  {GRISU_UINT64_C(0xa0000000, 00000000), -60, 1},
  {GRISU_UINT64_C(0x9c400000, 00000000), -50, 4},
  {GRISU_UINT64_C(0x98968000, 00000000), -40, 7},
  {GRISU_UINT64_C(0x9502f900, 00000000), -30, 10},
  {GRISU_UINT64_C(0x9184e72a, 00000000), -20, 13},
  {GRISU_UINT64_C(0x8e1bc9bf, 04000000), -10, 16},
  {GRISU_UINT64_C(0x8ac72304, 89e80000), 0, 19},
  {GRISU_UINT64_C(0x87867832, 6eac9000), 10, 22},
  {GRISU_UINT64_C(0x84595161, 401484a0), 20, 25},
  {GRISU_UINT64_C(0x813f3978, f8940984), 30, 28},
  {GRISU_UINT64_C(0xfc6f7c40, 45812296), 39, 31},
  {GRISU_UINT64_C(0xf684df56, c3e01bc7), 49, 34},
  {GRISU_UINT64_C(0xf0bdc21a, bb48db20), 59, 37},
  {GRISU_UINT64_C(0xeb194f8e, 1ae525fd), 69, 40},
  {GRISU_UINT64_C(0xe596b7b0, c643c719), 79, 43},
  {GRISU_UINT64_C(0xe0352f62, a19e306f), 89, 46},
  {GRISU_UINT64_C(0xdaf3f046, 51d47b4c), 99, 49},
  {GRISU_UINT64_C(0xd5d238a4, abe98068), 109, 52},
  {GRISU_UINT64_C(0xd0cf4b50, cfe20766), 119, 55},
  {GRISU_UINT64_C(0xcbea6f8c, eb02bb3a), 129, 58},
  {GRISU_UINT64_C(0xc722f0ef, 9d80aad6), 139, 61},
  {GRISU_UINT64_C(0xc2781f49, ffcfa6d5), 149, 64},
  {GRISU_UINT64_C(0xbde94e8e, 43d0c8ec), 159, 67},
  {GRISU_UINT64_C(0xb975d6b6, ee39e437), 169, 70},
  {GRISU_UINT64_C(0xb51d13ae, a4a488dd), 179, 73},
  {GRISU_UINT64_C(0xb0de6538, 8cc8ada8), 189, 76},
  {GRISU_UINT64_C(0xacb92ed9, 397bf996), 199, 79},
  {GRISU_UINT64_C(0xa8acd7c0, 222311bd), 209, 82},
  {GRISU_UINT64_C(0xa4b8cab1, a1563f52), 219, 85},
  {GRISU_UINT64_C(0xa0dc75f1, 778e39d6), 229, 88},
  {GRISU_UINT64_C(0x9d174b2d, cec0e47b), 239, 91},
  {GRISU_UINT64_C(0x9968bf6a, bbe85f20), 249, 94},
  {GRISU_UINT64_C(0x95d04aee, 3b80ece6), 259, 97},
  {GRISU_UINT64_C(0x924d692c, a61be758), 269, 100},
  {GRISU_UINT64_C(0x8edf98b5, 9a373fec), 279, 103},
  {GRISU_UINT64_C(0x8b865b21, 5899f46d), 289, 106},
  {GRISU_UINT64_C(0x884134fe, 908658b2), 299, 109},
  {GRISU_UINT64_C(0x850fadc0, 9923329e), 309, 112},
  {GRISU_UINT64_C(0x81f14fae, 158c5f6e), 319, 115},
  {GRISU_UINT64_C(0xfdcb4fa0, 02162a63), 328, 118},
  {GRISU_UINT64_C(0xf7d88bc2, 4209a565), 338, 121},
  {GRISU_UINT64_C(0xf209787b, b47d6b85), 348, 124},
  {GRISU_UINT64_C(0xec5d3fa8, ce427b00), 358, 127},
  {GRISU_UINT64_C(0xe6d3102a, d96cec1e), 368, 130},
  {GRISU_UINT64_C(0xe16a1dc9, d8545e95), 378, 133},
  {GRISU_UINT64_C(0xdc21a117, 1d42645d), 388, 136},
  {GRISU_UINT64_C(0xd6f8d750, 9292d603), 398, 139},
  {GRISU_UINT64_C(0xd1ef0244, af2364ff), 408, 142},
  {GRISU_UINT64_C(0xcd036837, 130890a1), 418, 145},
  {GRISU_UINT64_C(0xc83553c5, c8965d3d), 428, 148},
  {GRISU_UINT64_C(0xc38413cf, 25e2d70e), 438, 151},
  {GRISU_UINT64_C(0xbeeefb58, 4aff8604), 448, 154},
  {GRISU_UINT64_C(0xba756174, 393d88e0), 458, 157},
  {GRISU_UINT64_C(0xb616a12b, 7fe617aa), 468, 160},
  {GRISU_UINT64_C(0xb1d21964, 7ae6b31c), 478, 163},
  {GRISU_UINT64_C(0xada72ccc, 20054aea), 488, 166},
  {GRISU_UINT64_C(0xa99541bf, 57452b28), 498, 169},
  {GRISU_UINT64_C(0xa59bc234, db398c25), 508, 172},
  {GRISU_UINT64_C(0xa1ba1ba7, 9e1632dc), 518, 175},
  {GRISU_UINT64_C(0x9defbf01, b061adab), 528, 178},
  {GRISU_UINT64_C(0x9a3c2087, a63f6399), 538, 181},
  {GRISU_UINT64_C(0x969eb7c4, 7859e744), 548, 184},
  {GRISU_UINT64_C(0x9316ff75, dd87cbd8), 558, 187},
  {GRISU_UINT64_C(0x8fa47579, 1a569d11), 568, 190},
  {GRISU_UINT64_C(0x8c469ab8, 43b89563), 578, 193},
  {GRISU_UINT64_C(0x88fcf317, f22241e2), 588, 196},
  {GRISU_UINT64_C(0x85c70565, 62757457), 598, 199},
  {GRISU_UINT64_C(0x82a45b45, 0226b39d), 608, 202},
  {GRISU_UINT64_C(0xff290242, c83396ce), 617, 205},
  {GRISU_UINT64_C(0xf92e0c35, 37826146), 627, 208},
  {GRISU_UINT64_C(0xf356f7eb, f83552fe), 637, 211},
  {GRISU_UINT64_C(0xeda2ee1c, 7064130c), 647, 214},
  {GRISU_UINT64_C(0xe8111c87, c5c1ba9a), 657, 217},
  {GRISU_UINT64_C(0xe2a0b5dc, 971f303a), 667, 220},
  {GRISU_UINT64_C(0xdd50f199, 6b947519), 677, 223},
  {GRISU_UINT64_C(0xd8210bef, d30efa5a), 687, 226},
  {GRISU_UINT64_C(0xd31045a8, 341ca07c), 697, 229},
  {GRISU_UINT64_C(0xce1de406, 42e3f4b9), 707, 232},
  {GRISU_UINT64_C(0xc94930ae, 1d529cfd), 717, 235},
  {GRISU_UINT64_C(0xc491798a, 08a2ad4f), 727, 238},
  {GRISU_UINT64_C(0xbff610b0, cc6edd3f), 737, 241},
  {GRISU_UINT64_C(0xbb764c4c, a7a44410), 747, 244},
  {GRISU_UINT64_C(0xb7118682, dbb66a77), 757, 247},
  {GRISU_UINT64_C(0xb2c71d5b, ca9023f8), 767, 250},
  {GRISU_UINT64_C(0xae9672ab, a3d0c321), 777, 253},
  {GRISU_UINT64_C(0xaa7eebfb, 9df9de8e), 787, 256},
  {GRISU_UINT64_C(0xa67ff273, b8460357), 797, 259},
  {GRISU_UINT64_C(0xa298f2c5, 01f45f43), 807, 262},
  {GRISU_UINT64_C(0x9ec95d14, 63e8a507), 817, 265},
  {GRISU_UINT64_C(0x9b10a4e5, e9913129), 827, 268},
  {GRISU_UINT64_C(0x976e4108, 8617ca02), 837, 271},
  {GRISU_UINT64_C(0x93e1ab82, 52f33b46), 847, 274},
  {GRISU_UINT64_C(0x906a617d, 450187e2), 857, 277},
  {GRISU_UINT64_C(0x8d07e334, 55637eb3), 867, 280},
  {GRISU_UINT64_C(0x89b9b3e1, 1b6329bb), 877, 283},
  {GRISU_UINT64_C(0x867f59a9, d4bed6c0), 887, 286},
  {GRISU_UINT64_C(0x83585d8f, d9c25db8), 897, 289},
  {GRISU_UINT64_C(0x80444b5e, 7aa7cf85), 907, 292},
  {GRISU_UINT64_C(0xfa856334, 878fc151), 916, 295},
  {GRISU_UINT64_C(0xf4a642e1, 4c6262c9), 926, 298},
  {GRISU_UINT64_C(0xeeea5d50, 04981478), 936, 301},
  {GRISU_UINT64_C(0xe950df20, 247c83fd), 946, 304},
  {GRISU_UINT64_C(0xe3d8f9e5, 63a198e5), 956, 307},
  {GRISU_UINT64_C(0xde81e40a, 034bcf50), 966, 310},
  {GRISU_UINT64_C(0xd94ad8b1, c7380874), 976, 313},
  {GRISU_UINT64_C(0xd433179d, 9c8cb841), 986, 316},
  {GRISU_UINT64_C(0xcf39e50f, eae16bf0), 996, 319},
  {GRISU_UINT64_C(0xca5e89b1, 8b602368), 1006, 322},
  {GRISU_UINT64_C(0xc5a05277, 621be294), 1016, 325},
  {GRISU_UINT64_C(0xc0fe9088, 95cf3b44), 1026, 328},
  {GRISU_UINT64_C(0xbc789925, 624c5fe1), 1036, 331},
  {GRISU_UINT64_C(0xb80dc58e, 81fe95a1), 1046, 334},
  {GRISU_UINT64_C(0xb3bd72ed, 2af29e20), 1056, 337},
  {GRISU_UINT64_C(0xaf87023b, 9bf0ee6b), 1066, 340},
  };
static const int GRISU_CACHE_MAX_DISTANCE(3) = 10;
// nb elements (3): 217
static const GRISU_CACHE_STRUCT GRISU_CACHE_NAME(4)[] = {
  {GRISU_UINT64_C(0xe61acf03, 3d1a45df), -1087, -308},
  {GRISU_UINT64_C(0x8c71dcd9, ba0b4926), -1073, -304},
  {GRISU_UINT64_C(0xab70fe17, c79ac6ca), -1060, -300},
  {GRISU_UINT64_C(0xd1476e2c, 07286faa), -1047, -296},
  {GRISU_UINT64_C(0xff77b1fc, bebcdc4f), -1034, -292},
  {GRISU_UINT64_C(0x9becce62, 836ac577), -1020, -288},
  {GRISU_UINT64_C(0xbe5691ef, 416bd60c), -1007, -284},
  {GRISU_UINT64_C(0xe858ad24, 8f5c22ca), -994, -280},
  {GRISU_UINT64_C(0x8dd01fad, 907ffc3c), -980, -276},
  {GRISU_UINT64_C(0xad1c8eab, 5ee43b67), -967, -272},
  {GRISU_UINT64_C(0xd3515c28, 31559a83), -954, -268},
  {GRISU_UINT64_C(0x80fa687f, 881c7f8e), -940, -264},
  {GRISU_UINT64_C(0x9d71ac8f, ada6c9b5), -927, -260},
  {GRISU_UINT64_C(0xc0314325, 637a193a), -914, -256},
  {GRISU_UINT64_C(0xea9c2277, 23ee8bcb), -901, -252},
  {GRISU_UINT64_C(0x8f31cc09, 37ae58d3), -887, -248},
  {GRISU_UINT64_C(0xaecc4991, 4078536d), -874, -244},
  {GRISU_UINT64_C(0xd5605fcd, cf32e1d7), -861, -240},
  {GRISU_UINT64_C(0x823c1279, 5db6ce57), -847, -236},
  {GRISU_UINT64_C(0x9efa548d, 26e5a6e2), -834, -232},
  {GRISU_UINT64_C(0xc2109436, 4dfb5637), -821, -228},
  {GRISU_UINT64_C(0xece53cec, 4a314ebe), -808, -224},
  {GRISU_UINT64_C(0x9096ea6f, 3848984f), -794, -220},
  {GRISU_UINT64_C(0xb080392c, c4349ded), -781, -216},
  {GRISU_UINT64_C(0xd77485cb, 25823ac7), -768, -212},
  {GRISU_UINT64_C(0x8380dea9, 3da4bc60), -754, -208},
  {GRISU_UINT64_C(0xa086cfcd, 97bf97f4), -741, -204},
  {GRISU_UINT64_C(0xc3f490aa, 77bd60fd), -728, -200},
  {GRISU_UINT64_C(0xef340a98, 172aace5), -715, -196},
  {GRISU_UINT64_C(0x91ff8377, 5423cc06), -701, -192},
  {GRISU_UINT64_C(0xb23867fb, 2a35b28e), -688, -188},
  {GRISU_UINT64_C(0xd98ddaee, 19068c76), -675, -184},
  {GRISU_UINT64_C(0x84c8d4df, d2c63f3b), -661, -180},
  {GRISU_UINT64_C(0xa21727db, 38cb0030), -648, -176},
  {GRISU_UINT64_C(0xc5dd4427, 1ad3cdba), -635, -172},
  {GRISU_UINT64_C(0xf18899b1, bc3f8ca2), -622, -168},
  {GRISU_UINT64_C(0x936b9fce, bb25c996), -608, -164},
  {GRISU_UINT64_C(0xb3f4e093, db73a093), -595, -160},
  {GRISU_UINT64_C(0xdbac6c24, 7d62a584), -582, -156},
  {GRISU_UINT64_C(0x8613fd01, 45877586), -568, -152},
  {GRISU_UINT64_C(0xa3ab6658, 0d5fdaf6), -555, -148},
  {GRISU_UINT64_C(0xc7caba6e, 7c5382c9), -542, -144},
  {GRISU_UINT64_C(0xf3e2f893, dec3f126), -529, -140},
  {GRISU_UINT64_C(0x94db4838, 40b717f0), -515, -136},
  {GRISU_UINT64_C(0xb5b5ada8, aaff80b8), -502, -132},
  {GRISU_UINT64_C(0xddd0467c, 64bce4a1), -489, -128},
  {GRISU_UINT64_C(0x87625f05, 6c7c4a8b), -475, -124},
  {GRISU_UINT64_C(0xa54394fe, 1eedb8ff), -462, -120},
  {GRISU_UINT64_C(0xc9bcff60, 34c13053), -449, -116},
  {GRISU_UINT64_C(0xf64335bc, f065d37d), -436, -112},
  {GRISU_UINT64_C(0x964e858c, 91ba2655), -422, -108},
  {GRISU_UINT64_C(0xb77ada06, 17e3bbcb), -409, -104},
  {GRISU_UINT64_C(0xdff97724, 70297ebd), -396, -100},
  {GRISU_UINT64_C(0x88b402f7, fd75539b), -382, -96},
  {GRISU_UINT64_C(0xa6dfbd9f, b8e5b88f), -369, -92},
  {GRISU_UINT64_C(0xcbb41ef9, 79346bca), -356, -88},
  {GRISU_UINT64_C(0xf8a95fcf, 88747d94), -343, -84},
  {GRISU_UINT64_C(0x97c560ba, 6b0919a6), -329, -80},
  {GRISU_UINT64_C(0xb9447093, 8fa89bcf), -316, -76},
  {GRISU_UINT64_C(0xe2280b6c, 20dd5232), -303, -72},
  {GRISU_UINT64_C(0x8a08f0f8, bf0f156b), -289, -68},
  {GRISU_UINT64_C(0xa87fea27, a539e9a5), -276, -64},
  {GRISU_UINT64_C(0xcdb02555, 653131b6), -263, -60},
  {GRISU_UINT64_C(0xfb158592, be068d2f), -250, -56},
  {GRISU_UINT64_C(0x993fe2c6, d07b7fac), -236, -52},
  {GRISU_UINT64_C(0xbb127c53, b17ec159), -223, -48},
  {GRISU_UINT64_C(0xe45c10c4, 2a2b3b06), -210, -44},
  {GRISU_UINT64_C(0x8b61313b, babce2c6), -196, -40},
  {GRISU_UINT64_C(0xaa242499, 697392d3), -183, -36},
  {GRISU_UINT64_C(0xcfb11ead, 453994ba), -170, -32},
  {GRISU_UINT64_C(0xfd87b5f2, 8300ca0e), -157, -28},
  {GRISU_UINT64_C(0x9abe14cd, 44753b53), -143, -24},
  {GRISU_UINT64_C(0xbce50864, 92111aeb), -130, -20},
  {GRISU_UINT64_C(0xe69594be, c44de15b), -117, -16},
  {GRISU_UINT64_C(0x8cbccc09, 6f5088cc), -103, -12},
  {GRISU_UINT64_C(0xabcc7711, 8461cefd), -90, -8},
  {GRISU_UINT64_C(0xd1b71758, e219652c), -77, -4},
  {GRISU_UINT64_C(0x80000000, 00000000), -63, 0},
  {GRISU_UINT64_C(0x9c400000, 00000000), -50, 4},
  {GRISU_UINT64_C(0xbebc2000, 00000000), -37, 8},
  {GRISU_UINT64_C(0xe8d4a510, 00000000), -24, 12},
  {GRISU_UINT64_C(0x8e1bc9bf, 04000000), -10, 16},
  {GRISU_UINT64_C(0xad78ebc5, ac620000), 3, 20},
  {GRISU_UINT64_C(0xd3c21bce, cceda100), 16, 24},
  {GRISU_UINT64_C(0x813f3978, f8940984), 30, 28},
  {GRISU_UINT64_C(0x9dc5ada8, 2b70b59e), 43, 32},
  {GRISU_UINT64_C(0xc097ce7b, c90715b3), 56, 36},
  {GRISU_UINT64_C(0xeb194f8e, 1ae525fd), 69, 40},
  {GRISU_UINT64_C(0x8f7e32ce, 7bea5c70), 83, 44},
  {GRISU_UINT64_C(0xaf298d05, 0e4395d7), 96, 48},
  {GRISU_UINT64_C(0xd5d238a4, abe98068), 109, 52},
  {GRISU_UINT64_C(0x82818f12, 81ed44a0), 123, 56},
  {GRISU_UINT64_C(0x9f4f2726, 179a2245), 136, 60},
  {GRISU_UINT64_C(0xc2781f49, ffcfa6d5), 149, 64},
  {GRISU_UINT64_C(0xed63a231, d4c4fb27), 162, 68},
  {GRISU_UINT64_C(0x90e40fbe, ea1d3a4b), 176, 72},
  {GRISU_UINT64_C(0xb0de6538, 8cc8ada8), 189, 76},
  {GRISU_UINT64_C(0xd7e77a8f, 87daf7fc), 202, 80},
  {GRISU_UINT64_C(0x83c7088e, 1aab65db), 216, 84},
  {GRISU_UINT64_C(0xa0dc75f1, 778e39d6), 229, 88},
  {GRISU_UINT64_C(0xc45d1df9, 42711d9a), 242, 92},
  {GRISU_UINT64_C(0xefb3ab16, c59b14a3), 255, 96},
  {GRISU_UINT64_C(0x924d692c, a61be758), 269, 100},
  {GRISU_UINT64_C(0xb2977ee3, 00c50fe7), 282, 104},
  {GRISU_UINT64_C(0xda01ee64, 1a708dea), 295, 108},
  {GRISU_UINT64_C(0x850fadc0, 9923329e), 309, 112},
  {GRISU_UINT64_C(0xa26da399, 9aef774a), 322, 116},
  {GRISU_UINT64_C(0xc646d635, 01a1511e), 335, 120},
  {GRISU_UINT64_C(0xf209787b, b47d6b85), 348, 124},
  {GRISU_UINT64_C(0x93ba47c9, 80e98ce0), 362, 128},
  {GRISU_UINT64_C(0xb454e4a1, 79dd1877), 375, 132},
  {GRISU_UINT64_C(0xdc21a117, 1d42645d), 388, 136},
  {GRISU_UINT64_C(0x865b8692, 5b9bc5c2), 402, 140},
  {GRISU_UINT64_C(0xa402b9c5, a8d3a6e7), 415, 144},
  {GRISU_UINT64_C(0xc83553c5, c8965d3d), 428, 148},
  {GRISU_UINT64_C(0xf46518c2, ef5b8cd1), 441, 152},
  {GRISU_UINT64_C(0x952ab45c, fa97a0b3), 455, 156},
  {GRISU_UINT64_C(0xb616a12b, 7fe617aa), 468, 160},
  {GRISU_UINT64_C(0xde469fbd, 99a05fe3), 481, 164},
  {GRISU_UINT64_C(0x87aa9aff, 79042287), 495, 168},
  {GRISU_UINT64_C(0xa59bc234, db398c25), 508, 172},
  {GRISU_UINT64_C(0xca28a291, 859bbf93), 521, 176},
  {GRISU_UINT64_C(0xf6c69a72, a3989f5c), 534, 180},
  {GRISU_UINT64_C(0x969eb7c4, 7859e744), 548, 184},
  {GRISU_UINT64_C(0xb7dcbf53, 54e9bece), 561, 188},
  {GRISU_UINT64_C(0xe070f78d, 3927556b), 574, 192},
  {GRISU_UINT64_C(0x88fcf317, f22241e2), 588, 196},
  {GRISU_UINT64_C(0xa738c6be, bb12d16d), 601, 200},
  {GRISU_UINT64_C(0xcc20ce9b, d35c78a5), 614, 204},
  {GRISU_UINT64_C(0xf92e0c35, 37826146), 627, 208},
  {GRISU_UINT64_C(0x98165af3, 7b2153df), 641, 212},
  {GRISU_UINT64_C(0xb9a74a06, 37ce2ee1), 654, 216},
  {GRISU_UINT64_C(0xe2a0b5dc, 971f303a), 667, 220},
  {GRISU_UINT64_C(0x8a5296ff, e33cc930), 681, 224},
  {GRISU_UINT64_C(0xa8d9d153, 5ce3b396), 694, 228},
  {GRISU_UINT64_C(0xce1de406, 42e3f4b9), 707, 232},
  {GRISU_UINT64_C(0xfb9b7cd9, a4a7443c), 720, 236},
  {GRISU_UINT64_C(0x9991a6f3, d6bf1766), 734, 240},
  {GRISU_UINT64_C(0xbb764c4c, a7a44410), 747, 244},
  {GRISU_UINT64_C(0xe4d5e823, 92a40515), 760, 248},
  {GRISU_UINT64_C(0x8bab8eef, b6409c1a), 774, 252},
  {GRISU_UINT64_C(0xaa7eebfb, 9df9de8e), 787, 256},
  {GRISU_UINT64_C(0xd01fef10, a657842c), 800, 260},
  {GRISU_UINT64_C(0xfe0efb53, d30dd4d8), 813, 264},
  {GRISU_UINT64_C(0x9b10a4e5, e9913129), 827, 268},
  {GRISU_UINT64_C(0xbd49d14a, a79dbc82), 840, 272},
  {GRISU_UINT64_C(0xe7109bfb, a19c0c9d), 853, 276},
  {GRISU_UINT64_C(0x8d07e334, 55637eb3), 867, 280},
  {GRISU_UINT64_C(0xac2820d9, 623bf429), 880, 284},
  {GRISU_UINT64_C(0xd226fc19, 5c6a2f8c), 893, 288},
  {GRISU_UINT64_C(0x80444b5e, 7aa7cf85), 907, 292},
  {GRISU_UINT64_C(0x9c935e00, d4b9d8d2), 920, 296},
  {GRISU_UINT64_C(0xbf21e440, 03acdd2d), 933, 300},
  {GRISU_UINT64_C(0xe950df20, 247c83fd), 946, 304},
  {GRISU_UINT64_C(0x8e679c2f, 5e44ff8f), 960, 308},
  {GRISU_UINT64_C(0xadd57a27, d29339f6), 973, 312},
  {GRISU_UINT64_C(0xd433179d, 9c8cb841), 986, 316},
  {GRISU_UINT64_C(0x81842f29, f2cce376), 1000, 320},
  {GRISU_UINT64_C(0x9e19db92, b4e31ba9), 1013, 324},
  {GRISU_UINT64_C(0xc0fe9088, 95cf3b44), 1026, 328},
  {GRISU_UINT64_C(0xeb96bf6e, badf77d9), 1039, 332},
  {GRISU_UINT64_C(0x8fcac257, 558ee4e6), 1053, 336},
  {GRISU_UINT64_C(0xaf87023b, 9bf0ee6b), 1066, 340},
  };
static const int GRISU_CACHE_MAX_DISTANCE(4) = 14;
// nb elements (4): 163
static const GRISU_CACHE_STRUCT GRISU_CACHE_NAME(5)[] = {
  {GRISU_UINT64_C(0xe61acf03, 3d1a45df), -1087, -308},
  {GRISU_UINT64_C(0xaf8e5410, 288e1b6f), -1070, -303},
  {GRISU_UINT64_C(0x85f04682, 93f0eb4e), -1053, -298},
  {GRISU_UINT64_C(0xcc5fc196, fefd7d0c), -1037, -293},
  {GRISU_UINT64_C(0x9becce62, 836ac577), -1020, -288},
  {GRISU_UINT64_C(0xedec366b, 11c6cb8f), -1004, -283},
  {GRISU_UINT64_C(0xb5854744, 8ffffb2e), -987, -278},
  {GRISU_UINT64_C(0x8a7d3eef, 7f1cfc52), -970, -273},
  {GRISU_UINT64_C(0xd3515c28, 31559a83), -954, -268},
  {GRISU_UINT64_C(0xa139029f, 6a239f72), -937, -263},
  {GRISU_UINT64_C(0xf6019da0, 7f549b2b), -921, -258},
  {GRISU_UINT64_C(0xbbb01b92, 83253ca3), -904, -253},
  {GRISU_UINT64_C(0x8f31cc09, 37ae58d3), -887, -248},
  {GRISU_UINT64_C(0xda7f5bf5, 90966849), -871, -243},
  {GRISU_UINT64_C(0xa6b34ad8, c9dfc070), -854, -238},
  {GRISU_UINT64_C(0xfe5d5415, 0b090b03), -838, -233},
  {GRISU_UINT64_C(0xc2109436, 4dfb5637), -821, -228},
  {GRISU_UINT64_C(0x940f4613, ae5ed137), -804, -223},
  {GRISU_UINT64_C(0xe1ebce4d, c7f16dfc), -788, -218},
  {GRISU_UINT64_C(0xac5d37d5, b79b6239), -771, -213},
  {GRISU_UINT64_C(0x8380dea9, 3da4bc60), -754, -208},
  {GRISU_UINT64_C(0xc8a883c0, fdaf7df0), -738, -203},
  {GRISU_UINT64_C(0x99171105, 2d8bf3c5), -721, -198},
  {GRISU_UINT64_C(0xe998d258, 869facd7), -705, -193},
  {GRISU_UINT64_C(0xb23867fb, 2a35b28e), -688, -188},
  {GRISU_UINT64_C(0x87f8a8d4, cfa417ca), -671, -183},
  {GRISU_UINT64_C(0xcf79cc9d, b955c2cc), -655, -178},
  {GRISU_UINT64_C(0x9e4a9cec, 15763e2f), -638, -173},
  {GRISU_UINT64_C(0xf18899b1, bc3f8ca2), -622, -168},
  {GRISU_UINT64_C(0xb84687c2, 69ef3bfb), -605, -163},
  {GRISU_UINT64_C(0x8c974f73, 83725573), -588, -158},
  {GRISU_UINT64_C(0xd686619b, a27255a3), -572, -153},
  {GRISU_UINT64_C(0xa3ab6658, 0d5fdaf6), -555, -148},
  {GRISU_UINT64_C(0xf9bd690a, 1b68637b), -539, -143},
  {GRISU_UINT64_C(0xbe895233, 86091466), -522, -138},
  {GRISU_UINT64_C(0x915e2486, ef32cd60), -505, -133},
  {GRISU_UINT64_C(0xddd0467c, 64bce4a1), -489, -128},
  {GRISU_UINT64_C(0xa93af6c6, c79b5d2e), -472, -123},
  {GRISU_UINT64_C(0x811ccc66, 8829b887), -455, -118},
  {GRISU_UINT64_C(0xc5029163, f384a931), -439, -113},
  {GRISU_UINT64_C(0x964e858c, 91ba2655), -422, -108},
  {GRISU_UINT64_C(0xe5599087, 9ddcaabe), -406, -103},
  {GRISU_UINT64_C(0xaefae514, 77a06b04), -389, -98},
  {GRISU_UINT64_C(0x857fcae6, 2d8493a5), -372, -93},
  {GRISU_UINT64_C(0xcbb41ef9, 79346bca), -356, -88},
  {GRISU_UINT64_C(0x9b69dbe1, b548ce7d), -339, -83},
  {GRISU_UINT64_C(0xed246723, 473e3813), -323, -78},
  {GRISU_UINT64_C(0xb4ecd5f0, 1a4aa828), -306, -73},
  {GRISU_UINT64_C(0x8a08f0f8, bf0f156b), -289, -68},
  {GRISU_UINT64_C(0xd29fe4b1, 8e88640f), -273, -63},
  {GRISU_UINT64_C(0xa0b19d2a, b70e6ed6), -256, -58},
  {GRISU_UINT64_C(0xf5330471, 4d9265e0), -240, -53},
  {GRISU_UINT64_C(0xbb127c53, b17ec159), -223, -48},
  {GRISU_UINT64_C(0x8eb98a7a, 9a5b04e3), -206, -43},
  {GRISU_UINT64_C(0xd9c7dced, 53c72256), -190, -38},
  {GRISU_UINT64_C(0xa6274bbd, d0fadd62), -173, -33},
  {GRISU_UINT64_C(0xfd87b5f2, 8300ca0e), -157, -28},
  {GRISU_UINT64_C(0xc16d9a00, 95928a27), -140, -23},
  {GRISU_UINT64_C(0x9392ee8e, 921d5d07), -123, -18},
  {GRISU_UINT64_C(0xe12e1342, 4bb40e13), -107, -13},
  {GRISU_UINT64_C(0xabcc7711, 8461cefd), -90, -8},
  {GRISU_UINT64_C(0x83126e97, 8d4fdf3b), -73, -3},
  {GRISU_UINT64_C(0xc8000000, 00000000), -57, 2},
  {GRISU_UINT64_C(0x98968000, 00000000), -40, 7},
  {GRISU_UINT64_C(0xe8d4a510, 00000000), -24, 12},
  {GRISU_UINT64_C(0xb1a2bc2e, c5000000), -7, 17},
  {GRISU_UINT64_C(0x87867832, 6eac9000), 10, 22},
  {GRISU_UINT64_C(0xcecb8f27, f4200f3a), 26, 27},
  {GRISU_UINT64_C(0x9dc5ada8, 2b70b59e), 43, 32},
  {GRISU_UINT64_C(0xf0bdc21a, bb48db20), 59, 37},
  {GRISU_UINT64_C(0xb7abc627, 050305ae), 76, 42},
  {GRISU_UINT64_C(0x8c213d9d, a502de45), 93, 47},
  {GRISU_UINT64_C(0xd5d238a4, abe98068), 109, 52},
  {GRISU_UINT64_C(0xa321f2d7, 226895c8), 126, 57},
  {GRISU_UINT64_C(0xf8ebad2b, 84e0d58c), 142, 62},
  {GRISU_UINT64_C(0xbde94e8e, 43d0c8ec), 159, 67},
  {GRISU_UINT64_C(0x90e40fbe, ea1d3a4b), 176, 72},
  {GRISU_UINT64_C(0xdd15fe86, affad912), 192, 77},
  {GRISU_UINT64_C(0xa8acd7c0, 222311bd), 209, 82},
  {GRISU_UINT64_C(0x80b05e5a, c60b6178), 226, 87},
  {GRISU_UINT64_C(0xc45d1df9, 42711d9a), 242, 92},
  {GRISU_UINT64_C(0x95d04aee, 3b80ece6), 259, 97},
  {GRISU_UINT64_C(0xe498f455, c38b997a), 275, 102},
  {GRISU_UINT64_C(0xae67f1e9, aec07188), 292, 107},
  {GRISU_UINT64_C(0x850fadc0, 9923329e), 309, 112},
  {GRISU_UINT64_C(0xcb090c80, 01ab551c), 325, 117},
  {GRISU_UINT64_C(0x9ae75759, 6946075f), 342, 122},
  {GRISU_UINT64_C(0xec5d3fa8, ce427b00), 358, 127},
  {GRISU_UINT64_C(0xb454e4a1, 79dd1877), 375, 132},
  {GRISU_UINT64_C(0x899504ae, 72497eba), 392, 137},
  {GRISU_UINT64_C(0xd1ef0244, af2364ff), 408, 142},
  {GRISU_UINT64_C(0xa02aa96b, 06deb0fe), 425, 147},
  {GRISU_UINT64_C(0xf46518c2, ef5b8cd1), 441, 152},
  {GRISU_UINT64_C(0xba756174, 393d88e0), 458, 157},
  {GRISU_UINT64_C(0x8e41ade9, fbebc27d), 475, 162},
  {GRISU_UINT64_C(0xd910f7ff, 28069da4), 491, 167},
  {GRISU_UINT64_C(0xa59bc234, db398c25), 508, 172},
  {GRISU_UINT64_C(0xfcb2cb35, e702af78), 524, 177},
  {GRISU_UINT64_C(0xc0cb28a9, 8fcf3c80), 541, 182},
  {GRISU_UINT64_C(0x9316ff75, dd87cbd8), 558, 187},
  {GRISU_UINT64_C(0xe070f78d, 3927556b), 574, 192},
  {GRISU_UINT64_C(0xab3c2fdd, eeaad25b), 591, 197},
  {GRISU_UINT64_C(0x82a45b45, 0226b39d), 608, 202},
  {GRISU_UINT64_C(0xc75809c4, 2c684dd1), 624, 207},
  {GRISU_UINT64_C(0x98165af3, 7b2153df), 641, 212},
  {GRISU_UINT64_C(0xe8111c87, c5c1ba9a), 657, 217},
  {GRISU_UINT64_C(0xb10d8e14, 56105dad), 674, 222},
  {GRISU_UINT64_C(0x8714a775, e3e95c78), 691, 227},
  {GRISU_UINT64_C(0xce1de406, 42e3f4b9), 707, 232},
  {GRISU_UINT64_C(0x9d412e08, 06e88aa6), 724, 237},
  {GRISU_UINT64_C(0xeff394dc, ff8a948f), 740, 242},
  {GRISU_UINT64_C(0xb7118682, dbb66a77), 757, 247},
  {GRISU_UINT64_C(0x8bab8eef, b6409c1a), 774, 252},
  {GRISU_UINT64_C(0xd51ea6fa, 85785631), 790, 257},
  {GRISU_UINT64_C(0xa298f2c5, 01f45f43), 807, 262},
  {GRISU_UINT64_C(0xf81aa16f, dc1b81db), 823, 267},
  {GRISU_UINT64_C(0xbd49d14a, a79dbc82), 840, 272},
  {GRISU_UINT64_C(0x906a617d, 450187e2), 857, 277},
  {GRISU_UINT64_C(0xdc5c5301, c56b75f7), 873, 282},
  {GRISU_UINT64_C(0xa81f3014, 49ee8c70), 890, 287},
  {GRISU_UINT64_C(0x80444b5e, 7aa7cf85), 907, 292},
  {GRISU_UINT64_C(0xc3b83581, 09e84f07), 923, 297},
  {GRISU_UINT64_C(0x95527a52, 02df0ccb), 940, 302},
  {GRISU_UINT64_C(0xe3d8f9e5, 63a198e5), 956, 307},
  {GRISU_UINT64_C(0xadd57a27, d29339f6), 973, 312},
  {GRISU_UINT64_C(0x849feec2, 81d7f329), 990, 317},
  {GRISU_UINT64_C(0xca5e89b1, 8b602368), 1006, 322},
  {GRISU_UINT64_C(0x9a65406d, 44a5c903), 1023, 327},
  {GRISU_UINT64_C(0xeb96bf6e, badf77d9), 1039, 332},
  {GRISU_UINT64_C(0xb3bd72ed, 2af29e20), 1056, 337},
  {GRISU_UINT64_C(0x892179be, 91d43a44), 1073, 342},
  };
static const int GRISU_CACHE_MAX_DISTANCE(5) = 17;
// nb elements (5): 131
static const GRISU_CACHE_STRUCT GRISU_CACHE_NAME(6)[] = {
  {GRISU_UINT64_C(0xe61acf03, 3d1a45df), -1087, -308},
  {GRISU_UINT64_C(0xdb71e914, 32b1a24b), -1067, -302},
  {GRISU_UINT64_C(0xd1476e2c, 07286faa), -1047, -296},
  {GRISU_UINT64_C(0xc795830d, 75038c1e), -1027, -290},
  {GRISU_UINT64_C(0xbe5691ef, 416bd60c), -1007, -284},
  {GRISU_UINT64_C(0xb5854744, 8ffffb2e), -987, -278},
  {GRISU_UINT64_C(0xad1c8eab, 5ee43b67), -967, -272},
  {GRISU_UINT64_C(0xa5178fff, 668ae0b6), -947, -266},
  {GRISU_UINT64_C(0x9d71ac8f, ada6c9b5), -927, -260},
  {GRISU_UINT64_C(0x96267c75, 35b763b5), -907, -254},
  {GRISU_UINT64_C(0x8f31cc09, 37ae58d3), -887, -248},
  {GRISU_UINT64_C(0x888f9979, 7a5e012d), -867, -242},
  {GRISU_UINT64_C(0x823c1279, 5db6ce57), -847, -236},
  {GRISU_UINT64_C(0xf867241c, 8cc6d4c1), -828, -230},
  {GRISU_UINT64_C(0xece53cec, 4a314ebe), -808, -224},
  {GRISU_UINT64_C(0xe1ebce4d, c7f16dfc), -788, -218},
  {GRISU_UINT64_C(0xd77485cb, 25823ac7), -768, -212},
  {GRISU_UINT64_C(0xcd795be8, 70516656), -748, -206},
  {GRISU_UINT64_C(0xc3f490aa, 77bd60fd), -728, -200},
  {GRISU_UINT64_C(0xbae0a846, d2195713), -708, -194},
  {GRISU_UINT64_C(0xb23867fb, 2a35b28e), -688, -188},
  {GRISU_UINT64_C(0xa9f6d30a, 038d1dbc), -668, -182},
  {GRISU_UINT64_C(0xa21727db, 38cb0030), -648, -176},
  {GRISU_UINT64_C(0x9a94dd3e, 8cf578ba), -628, -170},
  {GRISU_UINT64_C(0x936b9fce, bb25c996), -608, -164},
  {GRISU_UINT64_C(0x8c974f73, 83725573), -588, -158},
  {GRISU_UINT64_C(0x8613fd01, 45877586), -568, -152},
  {GRISU_UINT64_C(0xffbbcfe9, 94e5c620), -549, -146},
  {GRISU_UINT64_C(0xf3e2f893, dec3f126), -529, -140},
  {GRISU_UINT64_C(0xe896a0d7, e51e1566), -509, -134},
  {GRISU_UINT64_C(0xddd0467c, 64bce4a1), -489, -128},
  {GRISU_UINT64_C(0xd389b478, 79823479), -469, -122},
  {GRISU_UINT64_C(0xc9bcff60, 34c13053), -449, -116},
  {GRISU_UINT64_C(0xc06481fb, 9bcf8d3a), -429, -110},
  {GRISU_UINT64_C(0xb77ada06, 17e3bbcb), -409, -104},
  {GRISU_UINT64_C(0xaefae514, 77a06b04), -389, -98},
  {GRISU_UINT64_C(0xa6dfbd9f, b8e5b88f), -369, -92},
  {GRISU_UINT64_C(0x9f24b832, e6b0f436), -349, -86},
  {GRISU_UINT64_C(0x97c560ba, 6b0919a6), -329, -80},
  {GRISU_UINT64_C(0x90bd77f3, 483bb9ba), -309, -74},
  {GRISU_UINT64_C(0x8a08f0f8, bf0f156b), -289, -68},
  {GRISU_UINT64_C(0x83a3eeee, f9153e89), -269, -62},
  {GRISU_UINT64_C(0xfb158592, be068d2f), -250, -56},
  {GRISU_UINT64_C(0xef73d256, a5c0f77d), -230, -50},
  {GRISU_UINT64_C(0xe45c10c4, 2a2b3b06), -210, -44},
  {GRISU_UINT64_C(0xd9c7dced, 53c72256), -190, -38},
  {GRISU_UINT64_C(0xcfb11ead, 453994ba), -170, -32},
  {GRISU_UINT64_C(0xc6120625, 76589ddb), -150, -26},
  {GRISU_UINT64_C(0xbce50864, 92111aeb), -130, -20},
  {GRISU_UINT64_C(0xb424dc35, 095cd80f), -110, -14},
  {GRISU_UINT64_C(0xabcc7711, 8461cefd), -90, -8},
  {GRISU_UINT64_C(0xa3d70a3d, 70a3d70a), -70, -2},
  {GRISU_UINT64_C(0x9c400000, 00000000), -50, 4},
  {GRISU_UINT64_C(0x9502f900, 00000000), -30, 10},
  {GRISU_UINT64_C(0x8e1bc9bf, 04000000), -10, 16},
  {GRISU_UINT64_C(0x87867832, 6eac9000), 10, 22},
  {GRISU_UINT64_C(0x813f3978, f8940984), 30, 28},
  {GRISU_UINT64_C(0xf684df56, c3e01bc7), 49, 34},
  {GRISU_UINT64_C(0xeb194f8e, 1ae525fd), 69, 40},
  {GRISU_UINT64_C(0xe0352f62, a19e306f), 89, 46},
  {GRISU_UINT64_C(0xd5d238a4, abe98068), 109, 52},
  {GRISU_UINT64_C(0xcbea6f8c, eb02bb3a), 129, 58},
  {GRISU_UINT64_C(0xc2781f49, ffcfa6d5), 149, 64},
  {GRISU_UINT64_C(0xb975d6b6, ee39e437), 169, 70},
  {GRISU_UINT64_C(0xb0de6538, 8cc8ada8), 189, 76},
  {GRISU_UINT64_C(0xa8acd7c0, 222311bd), 209, 82},
  {GRISU_UINT64_C(0xa0dc75f1, 778e39d6), 229, 88},
  {GRISU_UINT64_C(0x9968bf6a, bbe85f20), 249, 94},
  {GRISU_UINT64_C(0x924d692c, a61be758), 269, 100},
  {GRISU_UINT64_C(0x8b865b21, 5899f46d), 289, 106},
  {GRISU_UINT64_C(0x850fadc0, 9923329e), 309, 112},
  {GRISU_UINT64_C(0xfdcb4fa0, 02162a63), 328, 118},
  {GRISU_UINT64_C(0xf209787b, b47d6b85), 348, 124},
  {GRISU_UINT64_C(0xe6d3102a, d96cec1e), 368, 130},
  {GRISU_UINT64_C(0xdc21a117, 1d42645d), 388, 136},
  {GRISU_UINT64_C(0xd1ef0244, af2364ff), 408, 142},
  {GRISU_UINT64_C(0xc83553c5, c8965d3d), 428, 148},
  {GRISU_UINT64_C(0xbeeefb58, 4aff8604), 448, 154},
  {GRISU_UINT64_C(0xb616a12b, 7fe617aa), 468, 160},
  {GRISU_UINT64_C(0xada72ccc, 20054aea), 488, 166},
  {GRISU_UINT64_C(0xa59bc234, db398c25), 508, 172},
  {GRISU_UINT64_C(0x9defbf01, b061adab), 528, 178},
  {GRISU_UINT64_C(0x969eb7c4, 7859e744), 548, 184},
  {GRISU_UINT64_C(0x8fa47579, 1a569d11), 568, 190},
  {GRISU_UINT64_C(0x88fcf317, f22241e2), 588, 196},
  {GRISU_UINT64_C(0x82a45b45, 0226b39d), 608, 202},
  {GRISU_UINT64_C(0xf92e0c35, 37826146), 627, 208},
  {GRISU_UINT64_C(0xeda2ee1c, 7064130c), 647, 214},
  {GRISU_UINT64_C(0xe2a0b5dc, 971f303a), 667, 220},
  {GRISU_UINT64_C(0xd8210bef, d30efa5a), 687, 226},
  {GRISU_UINT64_C(0xce1de406, 42e3f4b9), 707, 232},
  {GRISU_UINT64_C(0xc491798a, 08a2ad4f), 727, 238},
  {GRISU_UINT64_C(0xbb764c4c, a7a44410), 747, 244},
  {GRISU_UINT64_C(0xb2c71d5b, ca9023f8), 767, 250},
  {GRISU_UINT64_C(0xaa7eebfb, 9df9de8e), 787, 256},
  {GRISU_UINT64_C(0xa298f2c5, 01f45f43), 807, 262},
  {GRISU_UINT64_C(0x9b10a4e5, e9913129), 827, 268},
  {GRISU_UINT64_C(0x93e1ab82, 52f33b46), 847, 274},
  {GRISU_UINT64_C(0x8d07e334, 55637eb3), 867, 280},
  {GRISU_UINT64_C(0x867f59a9, d4bed6c0), 887, 286},
  {GRISU_UINT64_C(0x80444b5e, 7aa7cf85), 907, 292},
  {GRISU_UINT64_C(0xf4a642e1, 4c6262c9), 926, 298},
  {GRISU_UINT64_C(0xe950df20, 247c83fd), 946, 304},
  {GRISU_UINT64_C(0xde81e40a, 034bcf50), 966, 310},
  {GRISU_UINT64_C(0xd433179d, 9c8cb841), 986, 316},
  {GRISU_UINT64_C(0xca5e89b1, 8b602368), 1006, 322},
  {GRISU_UINT64_C(0xc0fe9088, 95cf3b44), 1026, 328},
  {GRISU_UINT64_C(0xb80dc58e, 81fe95a1), 1046, 334},
  {GRISU_UINT64_C(0xaf87023b, 9bf0ee6b), 1066, 340},
  };
static const int GRISU_CACHE_MAX_DISTANCE(6) = 20;
// nb elements (6): 109
static const GRISU_CACHE_STRUCT GRISU_CACHE_NAME(7)[] = {
  {GRISU_UINT64_C(0xe61acf03, 3d1a45df), -1087, -308},
  {GRISU_UINT64_C(0x892731ac, 9faf056f), -1063, -301},
  {GRISU_UINT64_C(0xa37fce12, 6597973d), -1040, -294},
  {GRISU_UINT64_C(0xc2e801fb, 244576d5), -1017, -287},
  {GRISU_UINT64_C(0xe858ad24, 8f5c22ca), -994, -280},
  {GRISU_UINT64_C(0x8a7d3eef, 7f1cfc52), -970, -273},
  {GRISU_UINT64_C(0xa5178fff, 668ae0b6), -947, -266},
  {GRISU_UINT64_C(0xc4ce17b3, 99107c23), -924, -259},
  {GRISU_UINT64_C(0xea9c2277, 23ee8bcb), -901, -252},
  {GRISU_UINT64_C(0x8bd6a141, 006042be), -877, -245},
  {GRISU_UINT64_C(0xa6b34ad8, c9dfc070), -854, -238},
  {GRISU_UINT64_C(0xc6b8e9b0, 709f109a), -831, -231},
  {GRISU_UINT64_C(0xece53cec, 4a314ebe), -808, -224},
  {GRISU_UINT64_C(0x8d3360f0, 9cf6e4bd), -784, -217},
  {GRISU_UINT64_C(0xa8530886, b54dbdec), -761, -210},
  {GRISU_UINT64_C(0xc8a883c0, fdaf7df0), -738, -203},
  {GRISU_UINT64_C(0xef340a98, 172aace5), -715, -196},
  {GRISU_UINT64_C(0x8e938662, 882af53e), -691, -189},
  {GRISU_UINT64_C(0xa9f6d30a, 038d1dbc), -668, -182},
  {GRISU_UINT64_C(0xca9cf1d2, 06fdc03c), -645, -175},
  {GRISU_UINT64_C(0xf18899b1, bc3f8ca2), -622, -168},
  {GRISU_UINT64_C(0x8ff71a0f, e2c2e6dc), -598, -161},
  {GRISU_UINT64_C(0xab9eb47c, 81f5114f), -575, -154},
  {GRISU_UINT64_C(0xcc963fee, 10b7d1b3), -552, -147},
  {GRISU_UINT64_C(0xf3e2f893, dec3f126), -529, -140},
  {GRISU_UINT64_C(0x915e2486, ef32cd60), -505, -133},
  {GRISU_UINT64_C(0xad4ab711, 2eb3929e), -482, -126},
  {GRISU_UINT64_C(0xce947a3d, a6a9273e), -459, -119},
  {GRISU_UINT64_C(0xf64335bc, f065d37d), -436, -112},
  {GRISU_UINT64_C(0x92c8ae6b, 464fc96f), -412, -105},
  {GRISU_UINT64_C(0xaefae514, 77a06b04), -389, -98},
  {GRISU_UINT64_C(0xd097ad07, a71f26b2), -366, -91},
  {GRISU_UINT64_C(0xf8a95fcf, 88747d94), -343, -84},
  {GRISU_UINT64_C(0x9436c076, 0c86e30c), -319, -77},
  {GRISU_UINT64_C(0xb0af48ec, 79ace837), -296, -70},
  {GRISU_UINT64_C(0xd29fe4b1, 8e88640f), -273, -63},
  {GRISU_UINT64_C(0xfb158592, be068d2f), -250, -56},
  {GRISU_UINT64_C(0x95a86376, 27989aae), -226, -49},
  {GRISU_UINT64_C(0xb267ed19, 40f1c61c), -203, -42},
  {GRISU_UINT64_C(0xd4ad2dbf, c3d07788), -180, -35},
  {GRISU_UINT64_C(0xfd87b5f2, 8300ca0e), -157, -28},
  {GRISU_UINT64_C(0x971da050, 74da7bef), -133, -21},
  {GRISU_UINT64_C(0xb424dc35, 095cd80f), -110, -14},
  {GRISU_UINT64_C(0xd6bf94d5, e57a42bc), -87, -7},
  {GRISU_UINT64_C(0x80000000, 00000000), -63, 0},
  {GRISU_UINT64_C(0x98968000, 00000000), -40, 7},
  {GRISU_UINT64_C(0xb5e620f4, 80000000), -17, 14},
  {GRISU_UINT64_C(0xd8d726b7, 177a8000), 6, 21},
  {GRISU_UINT64_C(0x813f3978, f8940984), 30, 28},
  {GRISU_UINT64_C(0x9a130b96, 3a6c115c), 53, 35},
  {GRISU_UINT64_C(0xb7abc627, 050305ae), 76, 42},
  {GRISU_UINT64_C(0xdaf3f046, 51d47b4c), 99, 49},
  {GRISU_UINT64_C(0x82818f12, 81ed44a0), 123, 56},
  {GRISU_UINT64_C(0x9b934c3b, 330c8577), 146, 63},
  {GRISU_UINT64_C(0xb975d6b6, ee39e437), 169, 70},
  {GRISU_UINT64_C(0xdd15fe86, affad912), 192, 77},
  {GRISU_UINT64_C(0x83c7088e, 1aab65db), 216, 84},
  {GRISU_UINT64_C(0x9d174b2d, cec0e47b), 239, 91},
  {GRISU_UINT64_C(0xbb445da9, ca61281f), 262, 98},
  {GRISU_UINT64_C(0xdf3d5e9b, c0f653e1), 285, 105},
  {GRISU_UINT64_C(0x850fadc0, 9923329e), 309, 112},
  {GRISU_UINT64_C(0x9e9f11c4, 014dda7e), 332, 119},
  {GRISU_UINT64_C(0xbd176620, a501fc00), 355, 126},
  {GRISU_UINT64_C(0xe16a1dc9, d8545e95), 378, 133},
  {GRISU_UINT64_C(0x865b8692, 5b9bc5c2), 402, 140},
  {GRISU_UINT64_C(0xa02aa96b, 06deb0fe), 425, 147},
  {GRISU_UINT64_C(0xbeeefb58, 4aff8604), 448, 154},
  {GRISU_UINT64_C(0xe39c4976, 5fdf9d95), 471, 161},
  {GRISU_UINT64_C(0x87aa9aff, 79042287), 495, 168},
  {GRISU_UINT64_C(0xa1ba1ba7, 9e1632dc), 518, 175},
  {GRISU_UINT64_C(0xc0cb28a9, 8fcf3c80), 541, 182},
  {GRISU_UINT64_C(0xe5d3ef28, 2a242e82), 564, 189},
  {GRISU_UINT64_C(0x88fcf317, f22241e2), 588, 196},
  {GRISU_UINT64_C(0xa34d7216, 42b06084), 611, 203},
  {GRISU_UINT64_C(0xc2abf989, 935ddbfe), 634, 210},
  {GRISU_UINT64_C(0xe8111c87, c5c1ba9a), 657, 217},
  {GRISU_UINT64_C(0x8a5296ff, e33cc930), 681, 224},
  {GRISU_UINT64_C(0xa4e4b66b, 68b65d61), 704, 231},
  {GRISU_UINT64_C(0xc491798a, 08a2ad4f), 727, 238},
  {GRISU_UINT64_C(0xea53df5f, d18d5514), 750, 245},
  {GRISU_UINT64_C(0x8bab8eef, b6409c1a), 774, 252},
  {GRISU_UINT64_C(0xa67ff273, b8460357), 797, 259},
  {GRISU_UINT64_C(0xc67bb459, 7ce2ce49), 820, 266},
  {GRISU_UINT64_C(0xec9c459d, 51852ba3), 843, 273},
  {GRISU_UINT64_C(0x8d07e334, 55637eb3), 867, 280},
  {GRISU_UINT64_C(0xa81f3014, 49ee8c70), 890, 287},
  {GRISU_UINT64_C(0xc86ab5c3, 9fa63441), 913, 294},
  {GRISU_UINT64_C(0xeeea5d50, 04981478), 936, 301},
  {GRISU_UINT64_C(0x8e679c2f, 5e44ff8f), 960, 308},
  {GRISU_UINT64_C(0xa9c2794a, e3a3c69b), 983, 315},
  {GRISU_UINT64_C(0xca5e89b1, 8b602368), 1006, 322},
  {GRISU_UINT64_C(0xf13e34aa, bb430a15), 1029, 329},
  {GRISU_UINT64_C(0x8fcac257, 558ee4e6), 1053, 336},
  };
static const int GRISU_CACHE_MAX_DISTANCE(7) = 24;
// nb elements (7): 93
static const GRISU_CACHE_STRUCT GRISU_CACHE_NAME(8)[] = {
  {GRISU_UINT64_C(0xe61acf03, 3d1a45df), -1087, -308},
  {GRISU_UINT64_C(0xab70fe17, c79ac6ca), -1060, -300},
  {GRISU_UINT64_C(0xff77b1fc, bebcdc4f), -1034, -292},
  {GRISU_UINT64_C(0xbe5691ef, 416bd60c), -1007, -284},
  {GRISU_UINT64_C(0x8dd01fad, 907ffc3c), -980, -276},
  {GRISU_UINT64_C(0xd3515c28, 31559a83), -954, -268},
  {GRISU_UINT64_C(0x9d71ac8f, ada6c9b5), -927, -260},
  {GRISU_UINT64_C(0xea9c2277, 23ee8bcb), -901, -252},
  {GRISU_UINT64_C(0xaecc4991, 4078536d), -874, -244},
  {GRISU_UINT64_C(0x823c1279, 5db6ce57), -847, -236},
  {GRISU_UINT64_C(0xc2109436, 4dfb5637), -821, -228},
  {GRISU_UINT64_C(0x9096ea6f, 3848984f), -794, -220},
  {GRISU_UINT64_C(0xd77485cb, 25823ac7), -768, -212},
  {GRISU_UINT64_C(0xa086cfcd, 97bf97f4), -741, -204},
  {GRISU_UINT64_C(0xef340a98, 172aace5), -715, -196},
  {GRISU_UINT64_C(0xb23867fb, 2a35b28e), -688, -188},
  {GRISU_UINT64_C(0x84c8d4df, d2c63f3b), -661, -180},
  {GRISU_UINT64_C(0xc5dd4427, 1ad3cdba), -635, -172},
  {GRISU_UINT64_C(0x936b9fce, bb25c996), -608, -164},
  {GRISU_UINT64_C(0xdbac6c24, 7d62a584), -582, -156},
  {GRISU_UINT64_C(0xa3ab6658, 0d5fdaf6), -555, -148},
  {GRISU_UINT64_C(0xf3e2f893, dec3f126), -529, -140},
  {GRISU_UINT64_C(0xb5b5ada8, aaff80b8), -502, -132},
  {GRISU_UINT64_C(0x87625f05, 6c7c4a8b), -475, -124},
  {GRISU_UINT64_C(0xc9bcff60, 34c13053), -449, -116},
  {GRISU_UINT64_C(0x964e858c, 91ba2655), -422, -108},
  {GRISU_UINT64_C(0xdff97724, 70297ebd), -396, -100},
  {GRISU_UINT64_C(0xa6dfbd9f, b8e5b88f), -369, -92},
  {GRISU_UINT64_C(0xf8a95fcf, 88747d94), -343, -84},
  {GRISU_UINT64_C(0xb9447093, 8fa89bcf), -316, -76},
  {GRISU_UINT64_C(0x8a08f0f8, bf0f156b), -289, -68},
  {GRISU_UINT64_C(0xcdb02555, 653131b6), -263, -60},
  {GRISU_UINT64_C(0x993fe2c6, d07b7fac), -236, -52},
  {GRISU_UINT64_C(0xe45c10c4, 2a2b3b06), -210, -44},
  {GRISU_UINT64_C(0xaa242499, 697392d3), -183, -36},
  {GRISU_UINT64_C(0xfd87b5f2, 8300ca0e), -157, -28},
  {GRISU_UINT64_C(0xbce50864, 92111aeb), -130, -20},
  {GRISU_UINT64_C(0x8cbccc09, 6f5088cc), -103, -12},
  {GRISU_UINT64_C(0xd1b71758, e219652c), -77, -4},
  {GRISU_UINT64_C(0x9c400000, 00000000), -50, 4},
  {GRISU_UINT64_C(0xe8d4a510, 00000000), -24, 12},
  {GRISU_UINT64_C(0xad78ebc5, ac620000), 3, 20},
  {GRISU_UINT64_C(0x813f3978, f8940984), 30, 28},
  {GRISU_UINT64_C(0xc097ce7b, c90715b3), 56, 36},
  {GRISU_UINT64_C(0x8f7e32ce, 7bea5c70), 83, 44},
  {GRISU_UINT64_C(0xd5d238a4, abe98068), 109, 52},
  {GRISU_UINT64_C(0x9f4f2726, 179a2245), 136, 60},
  {GRISU_UINT64_C(0xed63a231, d4c4fb27), 162, 68},
  {GRISU_UINT64_C(0xb0de6538, 8cc8ada8), 189, 76},
  {GRISU_UINT64_C(0x83c7088e, 1aab65db), 216, 84},
  {GRISU_UINT64_C(0xc45d1df9, 42711d9a), 242, 92},
  {GRISU_UINT64_C(0x924d692c, a61be758), 269, 100},
  {GRISU_UINT64_C(0xda01ee64, 1a708dea), 295, 108},
  {GRISU_UINT64_C(0xa26da399, 9aef774a), 322, 116},
  {GRISU_UINT64_C(0xf209787b, b47d6b85), 348, 124},
  {GRISU_UINT64_C(0xb454e4a1, 79dd1877), 375, 132},
  {GRISU_UINT64_C(0x865b8692, 5b9bc5c2), 402, 140},
  {GRISU_UINT64_C(0xc83553c5, c8965d3d), 428, 148},
  {GRISU_UINT64_C(0x952ab45c, fa97a0b3), 455, 156},
  {GRISU_UINT64_C(0xde469fbd, 99a05fe3), 481, 164},
  {GRISU_UINT64_C(0xa59bc234, db398c25), 508, 172},
  {GRISU_UINT64_C(0xf6c69a72, a3989f5c), 534, 180},
  {GRISU_UINT64_C(0xb7dcbf53, 54e9bece), 561, 188},
  {GRISU_UINT64_C(0x88fcf317, f22241e2), 588, 196},
  {GRISU_UINT64_C(0xcc20ce9b, d35c78a5), 614, 204},
  {GRISU_UINT64_C(0x98165af3, 7b2153df), 641, 212},
  {GRISU_UINT64_C(0xe2a0b5dc, 971f303a), 667, 220},
  {GRISU_UINT64_C(0xa8d9d153, 5ce3b396), 694, 228},
  {GRISU_UINT64_C(0xfb9b7cd9, a4a7443c), 720, 236},
  {GRISU_UINT64_C(0xbb764c4c, a7a44410), 747, 244},
  {GRISU_UINT64_C(0x8bab8eef, b6409c1a), 774, 252},
  {GRISU_UINT64_C(0xd01fef10, a657842c), 800, 260},
  {GRISU_UINT64_C(0x9b10a4e5, e9913129), 827, 268},
  {GRISU_UINT64_C(0xe7109bfb, a19c0c9d), 853, 276},
  {GRISU_UINT64_C(0xac2820d9, 623bf429), 880, 284},
  {GRISU_UINT64_C(0x80444b5e, 7aa7cf85), 907, 292},
  {GRISU_UINT64_C(0xbf21e440, 03acdd2d), 933, 300},
  {GRISU_UINT64_C(0x8e679c2f, 5e44ff8f), 960, 308},
  {GRISU_UINT64_C(0xd433179d, 9c8cb841), 986, 316},
  {GRISU_UINT64_C(0x9e19db92, b4e31ba9), 1013, 324},
  {GRISU_UINT64_C(0xeb96bf6e, badf77d9), 1039, 332},
  {GRISU_UINT64_C(0xaf87023b, 9bf0ee6b), 1066, 340},
  };
static const int GRISU_CACHE_MAX_DISTANCE(8) = 27;
// nb elements (8): 82
static const GRISU_CACHE_STRUCT GRISU_CACHE_NAME(9)[] = {
  {GRISU_UINT64_C(0xe61acf03, 3d1a45df), -1087, -308},
  {GRISU_UINT64_C(0xd64d3d9d, b981787d), -1057, -299},
  {GRISU_UINT64_C(0xc795830d, 75038c1e), -1027, -290},
  {GRISU_UINT64_C(0xb9e08a83, a5e34f08), -997, -281},
  {GRISU_UINT64_C(0xad1c8eab, 5ee43b67), -967, -272},
  {GRISU_UINT64_C(0xa139029f, 6a239f72), -937, -263},
  {GRISU_UINT64_C(0x96267c75, 35b763b5), -907, -254},
  {GRISU_UINT64_C(0x8bd6a141, 006042be), -877, -245},
  {GRISU_UINT64_C(0x823c1279, 5db6ce57), -847, -236},
  {GRISU_UINT64_C(0xf294b943, e17a2bc4), -818, -227},
  {GRISU_UINT64_C(0xe1ebce4d, c7f16dfc), -788, -218},
  {GRISU_UINT64_C(0xd267caa8, 62a12d67), -758, -209},
  {GRISU_UINT64_C(0xc3f490aa, 77bd60fd), -728, -200},
  {GRISU_UINT64_C(0xb67f6455, 292cbf08), -698, -191},
  {GRISU_UINT64_C(0xa9f6d30a, 038d1dbc), -668, -182},
  {GRISU_UINT64_C(0x9e4a9cec, 15763e2f), -638, -173},
  {GRISU_UINT64_C(0x936b9fce, bb25c996), -608, -164},
  {GRISU_UINT64_C(0x894bc396, ce5da772), -578, -155},
  {GRISU_UINT64_C(0xffbbcfe9, 94e5c620), -549, -146},
  {GRISU_UINT64_C(0xee2ba6c0, 678b597f), -519, -137},
  {GRISU_UINT64_C(0xddd0467c, 64bce4a1), -489, -128},
  {GRISU_UINT64_C(0xce947a3d, a6a9273e), -459, -119},
  {GRISU_UINT64_C(0xc06481fb, 9bcf8d3a), -429, -110},
  {GRISU_UINT64_C(0xb32df8e9, f3546564), -399, -101},
  {GRISU_UINT64_C(0xa6dfbd9f, b8e5b88f), -369, -92},
  {GRISU_UINT64_C(0x9b69dbe1, b548ce7d), -339, -83},
  {GRISU_UINT64_C(0x90bd77f3, 483bb9ba), -309, -74},
  {GRISU_UINT64_C(0x86ccbb52, ea94baeb), -279, -65},
  {GRISU_UINT64_C(0xfb158592, be068d2f), -250, -56},
  {GRISU_UINT64_C(0xe9d71b68, 9dde71b0), -220, -47},
  {GRISU_UINT64_C(0xd9c7dced, 53c72256), -190, -38},
  {GRISU_UINT64_C(0xcad2f7f5, 359a3b3e), -160, -29},
  {GRISU_UINT64_C(0xbce50864, 92111aeb), -130, -20},
  {GRISU_UINT64_C(0xafebff0b, cb24aaff), -100, -11},
  {GRISU_UINT64_C(0xa3d70a3d, 70a3d70a), -70, -2},
  {GRISU_UINT64_C(0x98968000, 00000000), -40, 7},
  {GRISU_UINT64_C(0x8e1bc9bf, 04000000), -10, 16},
  {GRISU_UINT64_C(0x84595161, 401484a0), 20, 25},
  {GRISU_UINT64_C(0xf684df56, c3e01bc7), 49, 34},
  {GRISU_UINT64_C(0xe596b7b0, c643c719), 79, 43},
  {GRISU_UINT64_C(0xd5d238a4, abe98068), 109, 52},
  {GRISU_UINT64_C(0xc722f0ef, 9d80aad6), 139, 61},
  {GRISU_UINT64_C(0xb975d6b6, ee39e437), 169, 70},
  {GRISU_UINT64_C(0xacb92ed9, 397bf996), 199, 79},
  {GRISU_UINT64_C(0xa0dc75f1, 778e39d6), 229, 88},
  {GRISU_UINT64_C(0x95d04aee, 3b80ece6), 259, 97},
  {GRISU_UINT64_C(0x8b865b21, 5899f46d), 289, 106},
  {GRISU_UINT64_C(0x81f14fae, 158c5f6e), 319, 115},
  {GRISU_UINT64_C(0xf209787b, b47d6b85), 348, 124},
  {GRISU_UINT64_C(0xe16a1dc9, d8545e95), 378, 133},
  {GRISU_UINT64_C(0xd1ef0244, af2364ff), 408, 142},
  {GRISU_UINT64_C(0xc38413cf, 25e2d70e), 438, 151},
  {GRISU_UINT64_C(0xb616a12b, 7fe617aa), 468, 160},
  {GRISU_UINT64_C(0xa99541bf, 57452b28), 498, 169},
  {GRISU_UINT64_C(0x9defbf01, b061adab), 528, 178},
  {GRISU_UINT64_C(0x9316ff75, dd87cbd8), 558, 187},
  {GRISU_UINT64_C(0x88fcf317, f22241e2), 588, 196},
  {GRISU_UINT64_C(0xff290242, c83396ce), 617, 205},
  {GRISU_UINT64_C(0xeda2ee1c, 7064130c), 647, 214},
  {GRISU_UINT64_C(0xdd50f199, 6b947519), 677, 223},
  {GRISU_UINT64_C(0xce1de406, 42e3f4b9), 707, 232},
  {GRISU_UINT64_C(0xbff610b0, cc6edd3f), 737, 241},
  {GRISU_UINT64_C(0xb2c71d5b, ca9023f8), 767, 250},
  {GRISU_UINT64_C(0xa67ff273, b8460357), 797, 259},
  {GRISU_UINT64_C(0x9b10a4e5, e9913129), 827, 268},
  {GRISU_UINT64_C(0x906a617d, 450187e2), 857, 277},
  {GRISU_UINT64_C(0x867f59a9, d4bed6c0), 887, 286},
  {GRISU_UINT64_C(0xfa856334, 878fc151), 916, 295},
  {GRISU_UINT64_C(0xe950df20, 247c83fd), 946, 304},
  {GRISU_UINT64_C(0xd94ad8b1, c7380874), 976, 313},
  {GRISU_UINT64_C(0xca5e89b1, 8b602368), 1006, 322},
  {GRISU_UINT64_C(0xbc789925, 624c5fe1), 1036, 331},
  {GRISU_UINT64_C(0xaf87023b, 9bf0ee6b), 1066, 340},
  };
static const int GRISU_CACHE_MAX_DISTANCE(9) = 30;
// nb elements (9): 73
static const GRISU_CACHE_STRUCT GRISU_CACHE_NAME(10)[] = {
  {GRISU_UINT64_C(0xe61acf03, 3d1a45df), -1087, -308},
  {GRISU_UINT64_C(0x85f04682, 93f0eb4e), -1053, -298},
  {GRISU_UINT64_C(0x9becce62, 836ac577), -1020, -288},
  {GRISU_UINT64_C(0xb5854744, 8ffffb2e), -987, -278},
  {GRISU_UINT64_C(0xd3515c28, 31559a83), -954, -268},
  {GRISU_UINT64_C(0xf6019da0, 7f549b2b), -921, -258},
  {GRISU_UINT64_C(0x8f31cc09, 37ae58d3), -887, -248},
  {GRISU_UINT64_C(0xa6b34ad8, c9dfc070), -854, -238},
  {GRISU_UINT64_C(0xc2109436, 4dfb5637), -821, -228},
  {GRISU_UINT64_C(0xe1ebce4d, c7f16dfc), -788, -218},
  {GRISU_UINT64_C(0x8380dea9, 3da4bc60), -754, -208},
  {GRISU_UINT64_C(0x99171105, 2d8bf3c5), -721, -198},
  {GRISU_UINT64_C(0xb23867fb, 2a35b28e), -688, -188},
  {GRISU_UINT64_C(0xcf79cc9d, b955c2cc), -655, -178},
  {GRISU_UINT64_C(0xf18899b1, bc3f8ca2), -622, -168},
  {GRISU_UINT64_C(0x8c974f73, 83725573), -588, -158},
  {GRISU_UINT64_C(0xa3ab6658, 0d5fdaf6), -555, -148},
  {GRISU_UINT64_C(0xbe895233, 86091466), -522, -138},
  {GRISU_UINT64_C(0xddd0467c, 64bce4a1), -489, -128},
  {GRISU_UINT64_C(0x811ccc66, 8829b887), -455, -118},
  {GRISU_UINT64_C(0x964e858c, 91ba2655), -422, -108},
  {GRISU_UINT64_C(0xaefae514, 77a06b04), -389, -98},
  {GRISU_UINT64_C(0xcbb41ef9, 79346bca), -356, -88},
  {GRISU_UINT64_C(0xed246723, 473e3813), -323, -78},
  {GRISU_UINT64_C(0x8a08f0f8, bf0f156b), -289, -68},
  {GRISU_UINT64_C(0xa0b19d2a, b70e6ed6), -256, -58},
  {GRISU_UINT64_C(0xbb127c53, b17ec159), -223, -48},
  {GRISU_UINT64_C(0xd9c7dced, 53c72256), -190, -38},
  {GRISU_UINT64_C(0xfd87b5f2, 8300ca0e), -157, -28},
  {GRISU_UINT64_C(0x9392ee8e, 921d5d07), -123, -18},
  {GRISU_UINT64_C(0xabcc7711, 8461cefd), -90, -8},
  {GRISU_UINT64_C(0xc8000000, 00000000), -57, 2},
  {GRISU_UINT64_C(0xe8d4a510, 00000000), -24, 12},
  {GRISU_UINT64_C(0x87867832, 6eac9000), 10, 22},
  {GRISU_UINT64_C(0x9dc5ada8, 2b70b59e), 43, 32},
  {GRISU_UINT64_C(0xb7abc627, 050305ae), 76, 42},
  {GRISU_UINT64_C(0xd5d238a4, abe98068), 109, 52},
  {GRISU_UINT64_C(0xf8ebad2b, 84e0d58c), 142, 62},
  {GRISU_UINT64_C(0x90e40fbe, ea1d3a4b), 176, 72},
  {GRISU_UINT64_C(0xa8acd7c0, 222311bd), 209, 82},
  {GRISU_UINT64_C(0xc45d1df9, 42711d9a), 242, 92},
  {GRISU_UINT64_C(0xe498f455, c38b997a), 275, 102},
  {GRISU_UINT64_C(0x850fadc0, 9923329e), 309, 112},
  {GRISU_UINT64_C(0x9ae75759, 6946075f), 342, 122},
  {GRISU_UINT64_C(0xb454e4a1, 79dd1877), 375, 132},
  {GRISU_UINT64_C(0xd1ef0244, af2364ff), 408, 142},
  {GRISU_UINT64_C(0xf46518c2, ef5b8cd1), 441, 152},
  {GRISU_UINT64_C(0x8e41ade9, fbebc27d), 475, 162},
  {GRISU_UINT64_C(0xa59bc234, db398c25), 508, 172},
  {GRISU_UINT64_C(0xc0cb28a9, 8fcf3c80), 541, 182},
  {GRISU_UINT64_C(0xe070f78d, 3927556b), 574, 192},
  {GRISU_UINT64_C(0x82a45b45, 0226b39d), 608, 202},
  {GRISU_UINT64_C(0x98165af3, 7b2153df), 641, 212},
  {GRISU_UINT64_C(0xb10d8e14, 56105dad), 674, 222},
  {GRISU_UINT64_C(0xce1de406, 42e3f4b9), 707, 232},
  {GRISU_UINT64_C(0xeff394dc, ff8a948f), 740, 242},
  {GRISU_UINT64_C(0x8bab8eef, b6409c1a), 774, 252},
  {GRISU_UINT64_C(0xa298f2c5, 01f45f43), 807, 262},
  {GRISU_UINT64_C(0xbd49d14a, a79dbc82), 840, 272},
  {GRISU_UINT64_C(0xdc5c5301, c56b75f7), 873, 282},
  {GRISU_UINT64_C(0x80444b5e, 7aa7cf85), 907, 292},
  {GRISU_UINT64_C(0x95527a52, 02df0ccb), 940, 302},
  {GRISU_UINT64_C(0xadd57a27, d29339f6), 973, 312},
  {GRISU_UINT64_C(0xca5e89b1, 8b602368), 1006, 322},
  {GRISU_UINT64_C(0xeb96bf6e, badf77d9), 1039, 332},
  {GRISU_UINT64_C(0x892179be, 91d43a44), 1073, 342},
  };
static const int GRISU_CACHE_MAX_DISTANCE(10) = 34;
// nb elements (10): 66
static const GRISU_CACHE_STRUCT GRISU_CACHE_NAME(11)[] = {
  {GRISU_UINT64_C(0xe61acf03, 3d1a45df), -1087, -308},
  {GRISU_UINT64_C(0xa76c5823, 38ed2622), -1050, -297},
  {GRISU_UINT64_C(0xf3a20279, ed56d48a), -1014, -286},
  {GRISU_UINT64_C(0xb1442798, f49ffb4b), -977, -275},
  {GRISU_UINT64_C(0x80fa687f, 881c7f8e), -940, -264},
  {GRISU_UINT64_C(0xbbb01b92, 83253ca3), -904, -253},
  {GRISU_UINT64_C(0x888f9979, 7a5e012d), -867, -242},
  {GRISU_UINT64_C(0xc6b8e9b0, 709f109a), -831, -231},
  {GRISU_UINT64_C(0x9096ea6f, 3848984f), -794, -220},
  {GRISU_UINT64_C(0xd267caa8, 62a12d67), -758, -209},
  {GRISU_UINT64_C(0x99171105, 2d8bf3c5), -721, -198},
  {GRISU_UINT64_C(0xdec681f9, f4c31f31), -685, -187},
  {GRISU_UINT64_C(0xa21727db, 38cb0030), -648, -176},
  {GRISU_UINT64_C(0xebdf6617, 91d60f56), -612, -165},
  {GRISU_UINT64_C(0xab9eb47c, 81f5114f), -575, -154},
  {GRISU_UINT64_C(0xf9bd690a, 1b68637b), -539, -143},
  {GRISU_UINT64_C(0xb5b5ada8, aaff80b8), -502, -132},
  {GRISU_UINT64_C(0x843610cb, 4bf160cc), -465, -121},
  {GRISU_UINT64_C(0xc06481fb, 9bcf8d3a), -429, -110},
  {GRISU_UINT64_C(0x8bfbea76, c619ef36), -392, -99},
  {GRISU_UINT64_C(0xcbb41ef9, 79346bca), -356, -88},
  {GRISU_UINT64_C(0x9436c076, 0c86e30c), -319, -77},
  {GRISU_UINT64_C(0xd7adf884, aa879177), -283, -66},
  {GRISU_UINT64_C(0x9ced737b, b6c4183d), -246, -55},
  {GRISU_UINT64_C(0xe45c10c4, 2a2b3b06), -210, -44},
  {GRISU_UINT64_C(0xa6274bbd, d0fadd62), -173, -33},
  {GRISU_UINT64_C(0xf1c90080, baf72cb1), -137, -22},
  {GRISU_UINT64_C(0xafebff0b, cb24aaff), -100, -11},
  {GRISU_UINT64_C(0x80000000, 00000000), -63, 0},
  {GRISU_UINT64_C(0xba43b740, 00000000), -27, 11},
  {GRISU_UINT64_C(0x87867832, 6eac9000), 10, 22},
  {GRISU_UINT64_C(0xc5371912, 364ce305), 46, 33},
  {GRISU_UINT64_C(0x8f7e32ce, 7bea5c70), 83, 44},
  {GRISU_UINT64_C(0xd0cf4b50, cfe20766), 119, 55},
  {GRISU_UINT64_C(0x97edd871, cfda3a57), 156, 66},
  {GRISU_UINT64_C(0xdd15fe86, affad912), 192, 77},
  {GRISU_UINT64_C(0xa0dc75f1, 778e39d6), 229, 88},
  {GRISU_UINT64_C(0xea157514, 3cf97227), 265, 99},
  {GRISU_UINT64_C(0xaa51823e, 34a7eedf), 302, 110},
  {GRISU_UINT64_C(0xf7d88bc2, 4209a565), 338, 121},
  {GRISU_UINT64_C(0xb454e4a1, 79dd1877), 375, 132},
  {GRISU_UINT64_C(0x8335616a, ed761f1f), 412, 143},
  {GRISU_UINT64_C(0xbeeefb58, 4aff8604), 448, 154},
  {GRISU_UINT64_C(0x8aec23d6, 80043bee), 485, 165},
  {GRISU_UINT64_C(0xca28a291, 859bbf93), 521, 176},
  {GRISU_UINT64_C(0x9316ff75, dd87cbd8), 558, 187},
  {GRISU_UINT64_C(0xd60b3bd5, 6a5586f2), 594, 198},
  {GRISU_UINT64_C(0x9bbcc7a1, 42b17ccc), 631, 209},
  {GRISU_UINT64_C(0xe2a0b5dc, 971f303a), 667, 220},
  {GRISU_UINT64_C(0xa4e4b66b, 68b65d61), 704, 231},
  {GRISU_UINT64_C(0xeff394dc, ff8a948f), 740, 242},
  {GRISU_UINT64_C(0xae9672ab, a3d0c321), 777, 253},
  {GRISU_UINT64_C(0xfe0efb53, d30dd4d8), 813, 264},
  {GRISU_UINT64_C(0xb8da1662, e7b00a17), 850, 275},
  {GRISU_UINT64_C(0x867f59a9, d4bed6c0), 887, 286},
  {GRISU_UINT64_C(0xc3b83581, 09e84f07), 923, 297},
  {GRISU_UINT64_C(0x8e679c2f, 5e44ff8f), 960, 308},
  {GRISU_UINT64_C(0xcf39e50f, eae16bf0), 996, 319},
  {GRISU_UINT64_C(0x96c6e0ea, b509e64d), 1033, 330},
  {GRISU_UINT64_C(0xdb68c2ca, 82ed2a06), 1069, 341},
  };
static const int GRISU_CACHE_MAX_DISTANCE(11) = 37;
// nb elements (11): 60
static const GRISU_CACHE_STRUCT GRISU_CACHE_NAME(12)[] = {
  {GRISU_UINT64_C(0xe61acf03, 3d1a45df), -1087, -308},
  {GRISU_UINT64_C(0xd1476e2c, 07286faa), -1047, -296},
  {GRISU_UINT64_C(0xbe5691ef, 416bd60c), -1007, -284},
  {GRISU_UINT64_C(0xad1c8eab, 5ee43b67), -967, -272},
  {GRISU_UINT64_C(0x9d71ac8f, ada6c9b5), -927, -260},
  {GRISU_UINT64_C(0x8f31cc09, 37ae58d3), -887, -248},
  {GRISU_UINT64_C(0x823c1279, 5db6ce57), -847, -236},
  {GRISU_UINT64_C(0xece53cec, 4a314ebe), -808, -224},
  {GRISU_UINT64_C(0xd77485cb, 25823ac7), -768, -212},
  {GRISU_UINT64_C(0xc3f490aa, 77bd60fd), -728, -200},
  {GRISU_UINT64_C(0xb23867fb, 2a35b28e), -688, -188},
  {GRISU_UINT64_C(0xa21727db, 38cb0030), -648, -176},
  {GRISU_UINT64_C(0x936b9fce, bb25c996), -608, -164},
  {GRISU_UINT64_C(0x8613fd01, 45877586), -568, -152},
  {GRISU_UINT64_C(0xf3e2f893, dec3f126), -529, -140},
  {GRISU_UINT64_C(0xddd0467c, 64bce4a1), -489, -128},
  {GRISU_UINT64_C(0xc9bcff60, 34c13053), -449, -116},
  {GRISU_UINT64_C(0xb77ada06, 17e3bbcb), -409, -104},
  {GRISU_UINT64_C(0xa6dfbd9f, b8e5b88f), -369, -92},
  {GRISU_UINT64_C(0x97c560ba, 6b0919a6), -329, -80},
  {GRISU_UINT64_C(0x8a08f0f8, bf0f156b), -289, -68},
  {GRISU_UINT64_C(0xfb158592, be068d2f), -250, -56},
  {GRISU_UINT64_C(0xe45c10c4, 2a2b3b06), -210, -44},
  {GRISU_UINT64_C(0xcfb11ead, 453994ba), -170, -32},
  {GRISU_UINT64_C(0xbce50864, 92111aeb), -130, -20},
  {GRISU_UINT64_C(0xabcc7711, 8461cefd), -90, -8},
  {GRISU_UINT64_C(0x9c400000, 00000000), -50, 4},
  {GRISU_UINT64_C(0x8e1bc9bf, 04000000), -10, 16},
  {GRISU_UINT64_C(0x813f3978, f8940984), 30, 28},
  {GRISU_UINT64_C(0xeb194f8e, 1ae525fd), 69, 40},
  {GRISU_UINT64_C(0xd5d238a4, abe98068), 109, 52},
  {GRISU_UINT64_C(0xc2781f49, ffcfa6d5), 149, 64},
  {GRISU_UINT64_C(0xb0de6538, 8cc8ada8), 189, 76},
  {GRISU_UINT64_C(0xa0dc75f1, 778e39d6), 229, 88},
  {GRISU_UINT64_C(0x924d692c, a61be758), 269, 100},
  {GRISU_UINT64_C(0x850fadc0, 9923329e), 309, 112},
  {GRISU_UINT64_C(0xf209787b, b47d6b85), 348, 124},
  {GRISU_UINT64_C(0xdc21a117, 1d42645d), 388, 136},
  {GRISU_UINT64_C(0xc83553c5, c8965d3d), 428, 148},
  {GRISU_UINT64_C(0xb616a12b, 7fe617aa), 468, 160},
  {GRISU_UINT64_C(0xa59bc234, db398c25), 508, 172},
  {GRISU_UINT64_C(0x969eb7c4, 7859e744), 548, 184},
  {GRISU_UINT64_C(0x88fcf317, f22241e2), 588, 196},
  {GRISU_UINT64_C(0xf92e0c35, 37826146), 627, 208},
  {GRISU_UINT64_C(0xe2a0b5dc, 971f303a), 667, 220},
  {GRISU_UINT64_C(0xce1de406, 42e3f4b9), 707, 232},
  {GRISU_UINT64_C(0xbb764c4c, a7a44410), 747, 244},
  {GRISU_UINT64_C(0xaa7eebfb, 9df9de8e), 787, 256},
  {GRISU_UINT64_C(0x9b10a4e5, e9913129), 827, 268},
  {GRISU_UINT64_C(0x8d07e334, 55637eb3), 867, 280},
  {GRISU_UINT64_C(0x80444b5e, 7aa7cf85), 907, 292},
  {GRISU_UINT64_C(0xe950df20, 247c83fd), 946, 304},
  {GRISU_UINT64_C(0xd433179d, 9c8cb841), 986, 316},
  {GRISU_UINT64_C(0xc0fe9088, 95cf3b44), 1026, 328},
  {GRISU_UINT64_C(0xaf87023b, 9bf0ee6b), 1066, 340},
  };
static const int GRISU_CACHE_MAX_DISTANCE(12) = 40;
// nb elements (12): 55
static const GRISU_CACHE_STRUCT GRISU_CACHE_NAME(13)[] = {
  {GRISU_UINT64_C(0xe61acf03, 3d1a45df), -1087, -308},
  {GRISU_UINT64_C(0x82cca4db, 847945ca), -1043, -295},
  {GRISU_UINT64_C(0x94b3a202, eb1c3f39), -1000, -282},
  {GRISU_UINT64_C(0xa90de353, 5aaae202), -957, -269},
  {GRISU_UINT64_C(0xc0314325, 637a193a), -914, -256},
  {GRISU_UINT64_C(0xda7f5bf5, 90966849), -871, -243},
  {GRISU_UINT64_C(0xf867241c, 8cc6d4c1), -828, -230},
  {GRISU_UINT64_C(0x8d3360f0, 9cf6e4bd), -784, -217},
  {GRISU_UINT64_C(0xa086cfcd, 97bf97f4), -741, -204},
  {GRISU_UINT64_C(0xb67f6455, 292cbf08), -698, -191},
  {GRISU_UINT64_C(0xcf79cc9d, b955c2cc), -655, -178},
  {GRISU_UINT64_C(0xebdf6617, 91d60f56), -612, -165},
  {GRISU_UINT64_C(0x8613fd01, 45877586), -568, -152},
  {GRISU_UINT64_C(0x986ddb5c, 6b3a76b8), -525, -139},
  {GRISU_UINT64_C(0xad4ab711, 2eb3929e), -482, -126},
  {GRISU_UINT64_C(0xc5029163, f384a931), -439, -113},
  {GRISU_UINT64_C(0xdff97724, 70297ebd), -396, -100},
  {GRISU_UINT64_C(0xfea126b7, d78186bd), -353, -87},
  {GRISU_UINT64_C(0x90bd77f3, 483bb9ba), -309, -74},
  {GRISU_UINT64_C(0xa48ceaaa, b75a8e2b), -266, -61},
  {GRISU_UINT64_C(0xbb127c53, b17ec159), -223, -48},
  {GRISU_UINT64_C(0xd4ad2dbf, c3d07788), -180, -35},
  {GRISU_UINT64_C(0xf1c90080, baf72cb1), -137, -22},
  {GRISU_UINT64_C(0x89705f41, 36b4a597), -93, -9},
  {GRISU_UINT64_C(0x9c400000, 00000000), -50, 4},
  {GRISU_UINT64_C(0xb1a2bc2e, c5000000), -7, 17},
  {GRISU_UINT64_C(0xc9f2c9cd, 04674edf), 36, 30},
  {GRISU_UINT64_C(0xe596b7b0, c643c719), 79, 43},
  {GRISU_UINT64_C(0x82818f12, 81ed44a0), 123, 56},
  {GRISU_UINT64_C(0x945e455f, 24fb1cf9), 166, 69},
  {GRISU_UINT64_C(0xa8acd7c0, 222311bd), 209, 82},
  {GRISU_UINT64_C(0xbfc2ef45, 6ae276e9), 252, 95},
  {GRISU_UINT64_C(0xda01ee64, 1a708dea), 295, 108},
  {GRISU_UINT64_C(0xf7d88bc2, 4209a565), 338, 121},
  {GRISU_UINT64_C(0x8ce2529e, 2734bb1d), 382, 134},
  {GRISU_UINT64_C(0xa02aa96b, 06deb0fe), 425, 147},
  {GRISU_UINT64_C(0xb616a12b, 7fe617aa), 468, 160},
  {GRISU_UINT64_C(0xcf02b2c2, 1207ef2f), 511, 173},
  {GRISU_UINT64_C(0xeb57ff22, fc0c795a), 554, 186},
  {GRISU_UINT64_C(0x85c70565, 62757457), 598, 199},
  {GRISU_UINT64_C(0x98165af3, 7b2153df), 641, 212},
  {GRISU_UINT64_C(0xace73cbf, dc0bfb7b), 684, 225},
  {GRISU_UINT64_C(0xc491798a, 08a2ad4f), 727, 238},
  {GRISU_UINT64_C(0xdf78e4b2, bd342cf7), 770, 251},
  {GRISU_UINT64_C(0xfe0efb53, d30dd4d8), 813, 264},
  {GRISU_UINT64_C(0x906a617d, 450187e2), 857, 277},
  {GRISU_UINT64_C(0xa42e74f3, d032f526), 900, 290},
  {GRISU_UINT64_C(0xbaa718e6, 8396cffe), 943, 303},
  {GRISU_UINT64_C(0xd433179d, 9c8cb841), 986, 316},
  {GRISU_UINT64_C(0xf13e34aa, bb430a15), 1029, 329},
  {GRISU_UINT64_C(0x892179be, 91d43a44), 1073, 342},
  };
static const int GRISU_CACHE_MAX_DISTANCE(13) = 44;
// nb elements (13): 51
static const GRISU_CACHE_STRUCT GRISU_CACHE_NAME(14)[] = {
  {GRISU_UINT64_C(0xe61acf03, 3d1a45df), -1087, -308},
  {GRISU_UINT64_C(0xa37fce12, 6597973d), -1040, -294},
  {GRISU_UINT64_C(0xe858ad24, 8f5c22ca), -994, -280},
  {GRISU_UINT64_C(0xa5178fff, 668ae0b6), -947, -266},
  {GRISU_UINT64_C(0xea9c2277, 23ee8bcb), -901, -252},
  {GRISU_UINT64_C(0xa6b34ad8, c9dfc070), -854, -238},
  {GRISU_UINT64_C(0xece53cec, 4a314ebe), -808, -224},
  {GRISU_UINT64_C(0xa8530886, b54dbdec), -761, -210},
  {GRISU_UINT64_C(0xef340a98, 172aace5), -715, -196},
  {GRISU_UINT64_C(0xa9f6d30a, 038d1dbc), -668, -182},
  {GRISU_UINT64_C(0xf18899b1, bc3f8ca2), -622, -168},
  {GRISU_UINT64_C(0xab9eb47c, 81f5114f), -575, -154},
  {GRISU_UINT64_C(0xf3e2f893, dec3f126), -529, -140},
  {GRISU_UINT64_C(0xad4ab711, 2eb3929e), -482, -126},
  {GRISU_UINT64_C(0xf64335bc, f065d37d), -436, -112},
  {GRISU_UINT64_C(0xaefae514, 77a06b04), -389, -98},
  {GRISU_UINT64_C(0xf8a95fcf, 88747d94), -343, -84},
  {GRISU_UINT64_C(0xb0af48ec, 79ace837), -296, -70},
  {GRISU_UINT64_C(0xfb158592, be068d2f), -250, -56},
  {GRISU_UINT64_C(0xb267ed19, 40f1c61c), -203, -42},
  {GRISU_UINT64_C(0xfd87b5f2, 8300ca0e), -157, -28},
  {GRISU_UINT64_C(0xb424dc35, 095cd80f), -110, -14},
  {GRISU_UINT64_C(0x80000000, 00000000), -63, 0},
  {GRISU_UINT64_C(0xb5e620f4, 80000000), -17, 14},
  {GRISU_UINT64_C(0x813f3978, f8940984), 30, 28},
  {GRISU_UINT64_C(0xb7abc627, 050305ae), 76, 42},
  {GRISU_UINT64_C(0x82818f12, 81ed44a0), 123, 56},
  {GRISU_UINT64_C(0xb975d6b6, ee39e437), 169, 70},
  {GRISU_UINT64_C(0x83c7088e, 1aab65db), 216, 84},
  {GRISU_UINT64_C(0xbb445da9, ca61281f), 262, 98},
  {GRISU_UINT64_C(0x850fadc0, 9923329e), 309, 112},
  {GRISU_UINT64_C(0xbd176620, a501fc00), 355, 126},
  {GRISU_UINT64_C(0x865b8692, 5b9bc5c2), 402, 140},
  {GRISU_UINT64_C(0xbeeefb58, 4aff8604), 448, 154},
  {GRISU_UINT64_C(0x87aa9aff, 79042287), 495, 168},
  {GRISU_UINT64_C(0xc0cb28a9, 8fcf3c80), 541, 182},
  {GRISU_UINT64_C(0x88fcf317, f22241e2), 588, 196},
  {GRISU_UINT64_C(0xc2abf989, 935ddbfe), 634, 210},
  {GRISU_UINT64_C(0x8a5296ff, e33cc930), 681, 224},
  {GRISU_UINT64_C(0xc491798a, 08a2ad4f), 727, 238},
  {GRISU_UINT64_C(0x8bab8eef, b6409c1a), 774, 252},
  {GRISU_UINT64_C(0xc67bb459, 7ce2ce49), 820, 266},
  {GRISU_UINT64_C(0x8d07e334, 55637eb3), 867, 280},
  {GRISU_UINT64_C(0xc86ab5c3, 9fa63441), 913, 294},
  {GRISU_UINT64_C(0x8e679c2f, 5e44ff8f), 960, 308},
  {GRISU_UINT64_C(0xca5e89b1, 8b602368), 1006, 322},
  {GRISU_UINT64_C(0x8fcac257, 558ee4e6), 1053, 336},
  };
static const int GRISU_CACHE_MAX_DISTANCE(14) = 47;
// nb elements (14): 47
static const GRISU_CACHE_STRUCT GRISU_CACHE_NAME(15)[] = {
  {GRISU_UINT64_C(0xe61acf03, 3d1a45df), -1087, -308},
  {GRISU_UINT64_C(0xcc5fc196, fefd7d0c), -1037, -293},
  {GRISU_UINT64_C(0xb5854744, 8ffffb2e), -987, -278},
  {GRISU_UINT64_C(0xa139029f, 6a239f72), -937, -263},
  {GRISU_UINT64_C(0x8f31cc09, 37ae58d3), -887, -248},
  {GRISU_UINT64_C(0xfe5d5415, 0b090b03), -838, -233},
  {GRISU_UINT64_C(0xe1ebce4d, c7f16dfc), -788, -218},
  {GRISU_UINT64_C(0xc8a883c0, fdaf7df0), -738, -203},
  {GRISU_UINT64_C(0xb23867fb, 2a35b28e), -688, -188},
  {GRISU_UINT64_C(0x9e4a9cec, 15763e2f), -638, -173},
  {GRISU_UINT64_C(0x8c974f73, 83725573), -588, -158},
  {GRISU_UINT64_C(0xf9bd690a, 1b68637b), -539, -143},
  {GRISU_UINT64_C(0xddd0467c, 64bce4a1), -489, -128},
  {GRISU_UINT64_C(0xc5029163, f384a931), -439, -113},
  {GRISU_UINT64_C(0xaefae514, 77a06b04), -389, -98},
  {GRISU_UINT64_C(0x9b69dbe1, b548ce7d), -339, -83},
  {GRISU_UINT64_C(0x8a08f0f8, bf0f156b), -289, -68},
  {GRISU_UINT64_C(0xf5330471, 4d9265e0), -240, -53},
  {GRISU_UINT64_C(0xd9c7dced, 53c72256), -190, -38},
  {GRISU_UINT64_C(0xc16d9a00, 95928a27), -140, -23},
  {GRISU_UINT64_C(0xabcc7711, 8461cefd), -90, -8},
  {GRISU_UINT64_C(0x98968000, 00000000), -40, 7},
  {GRISU_UINT64_C(0x87867832, 6eac9000), 10, 22},
  {GRISU_UINT64_C(0xf0bdc21a, bb48db20), 59, 37},
  {GRISU_UINT64_C(0xd5d238a4, abe98068), 109, 52},
  {GRISU_UINT64_C(0xbde94e8e, 43d0c8ec), 159, 67},
  {GRISU_UINT64_C(0xa8acd7c0, 222311bd), 209, 82},
  {GRISU_UINT64_C(0x95d04aee, 3b80ece6), 259, 97},
  {GRISU_UINT64_C(0x850fadc0, 9923329e), 309, 112},
  {GRISU_UINT64_C(0xec5d3fa8, ce427b00), 358, 127},
  {GRISU_UINT64_C(0xd1ef0244, af2364ff), 408, 142},
  {GRISU_UINT64_C(0xba756174, 393d88e0), 458, 157},
  {GRISU_UINT64_C(0xa59bc234, db398c25), 508, 172},
  {GRISU_UINT64_C(0x9316ff75, dd87cbd8), 558, 187},
  {GRISU_UINT64_C(0x82a45b45, 0226b39d), 608, 202},
  {GRISU_UINT64_C(0xe8111c87, c5c1ba9a), 657, 217},
  {GRISU_UINT64_C(0xce1de406, 42e3f4b9), 707, 232},
  {GRISU_UINT64_C(0xb7118682, dbb66a77), 757, 247},
  {GRISU_UINT64_C(0xa298f2c5, 01f45f43), 807, 262},
  {GRISU_UINT64_C(0x906a617d, 450187e2), 857, 277},
  {GRISU_UINT64_C(0x80444b5e, 7aa7cf85), 907, 292},
  {GRISU_UINT64_C(0xe3d8f9e5, 63a198e5), 956, 307},
  {GRISU_UINT64_C(0xca5e89b1, 8b602368), 1006, 322},
  {GRISU_UINT64_C(0xb3bd72ed, 2af29e20), 1056, 337},
  };
static const int GRISU_CACHE_MAX_DISTANCE(15) = 50;
// nb elements (15): 44
static const GRISU_CACHE_STRUCT GRISU_CACHE_NAME(16)[] = {
  {GRISU_UINT64_C(0xe61acf03, 3d1a45df), -1087, -308},
  {GRISU_UINT64_C(0xff77b1fc, bebcdc4f), -1034, -292},
  {GRISU_UINT64_C(0x8dd01fad, 907ffc3c), -980, -276},
  {GRISU_UINT64_C(0x9d71ac8f, ada6c9b5), -927, -260},
  {GRISU_UINT64_C(0xaecc4991, 4078536d), -874, -244},
  {GRISU_UINT64_C(0xc2109436, 4dfb5637), -821, -228},
  {GRISU_UINT64_C(0xd77485cb, 25823ac7), -768, -212},
  {GRISU_UINT64_C(0xef340a98, 172aace5), -715, -196},
  {GRISU_UINT64_C(0x84c8d4df, d2c63f3b), -661, -180},
  {GRISU_UINT64_C(0x936b9fce, bb25c996), -608, -164},
  {GRISU_UINT64_C(0xa3ab6658, 0d5fdaf6), -555, -148},
  {GRISU_UINT64_C(0xb5b5ada8, aaff80b8), -502, -132},
  {GRISU_UINT64_C(0xc9bcff60, 34c13053), -449, -116},
  {GRISU_UINT64_C(0xdff97724, 70297ebd), -396, -100},
  {GRISU_UINT64_C(0xf8a95fcf, 88747d94), -343, -84},
  {GRISU_UINT64_C(0x8a08f0f8, bf0f156b), -289, -68},
  {GRISU_UINT64_C(0x993fe2c6, d07b7fac), -236, -52},
  {GRISU_UINT64_C(0xaa242499, 697392d3), -183, -36},
  {GRISU_UINT64_C(0xbce50864, 92111aeb), -130, -20},
  {GRISU_UINT64_C(0xd1b71758, e219652c), -77, -4},
  {GRISU_UINT64_C(0xe8d4a510, 00000000), -24, 12},
  {GRISU_UINT64_C(0x813f3978, f8940984), 30, 28},
  {GRISU_UINT64_C(0x8f7e32ce, 7bea5c70), 83, 44},
  {GRISU_UINT64_C(0x9f4f2726, 179a2245), 136, 60},
  {GRISU_UINT64_C(0xb0de6538, 8cc8ada8), 189, 76},
  {GRISU_UINT64_C(0xc45d1df9, 42711d9a), 242, 92},
  {GRISU_UINT64_C(0xda01ee64, 1a708dea), 295, 108},
  {GRISU_UINT64_C(0xf209787b, b47d6b85), 348, 124},
  {GRISU_UINT64_C(0x865b8692, 5b9bc5c2), 402, 140},
  {GRISU_UINT64_C(0x952ab45c, fa97a0b3), 455, 156},
  {GRISU_UINT64_C(0xa59bc234, db398c25), 508, 172},
  {GRISU_UINT64_C(0xb7dcbf53, 54e9bece), 561, 188},
  {GRISU_UINT64_C(0xcc20ce9b, d35c78a5), 614, 204},
  {GRISU_UINT64_C(0xe2a0b5dc, 971f303a), 667, 220},
  {GRISU_UINT64_C(0xfb9b7cd9, a4a7443c), 720, 236},
  {GRISU_UINT64_C(0x8bab8eef, b6409c1a), 774, 252},
  {GRISU_UINT64_C(0x9b10a4e5, e9913129), 827, 268},
  {GRISU_UINT64_C(0xac2820d9, 623bf429), 880, 284},
  {GRISU_UINT64_C(0xbf21e440, 03acdd2d), 933, 300},
  {GRISU_UINT64_C(0xd433179d, 9c8cb841), 986, 316},
  {GRISU_UINT64_C(0xeb96bf6e, badf77d9), 1039, 332},
  };
static const int GRISU_CACHE_MAX_DISTANCE(16) = 54;
// nb elements (16): 41
static const GRISU_CACHE_STRUCT GRISU_CACHE_NAME(17)[] = {
  {GRISU_UINT64_C(0xe61acf03, 3d1a45df), -1087, -308},
  {GRISU_UINT64_C(0x9faacf3d, f73609b1), -1030, -291},
  {GRISU_UINT64_C(0xdd95317f, 31c7fa1d), -974, -274},
  {GRISU_UINT64_C(0x99c10284, 4f94e0fb), -917, -257},
  {GRISU_UINT64_C(0xd5605fcd, cf32e1d7), -861, -240},
  {GRISU_UINT64_C(0x940f4613, ae5ed137), -804, -223},
  {GRISU_UINT64_C(0xcd795be8, 70516656), -748, -206},
  {GRISU_UINT64_C(0x8e938662, 882af53e), -691, -189},
  {GRISU_UINT64_C(0xc5dd4427, 1ad3cdba), -635, -172},
  {GRISU_UINT64_C(0x894bc396, ce5da772), -578, -155},
  {GRISU_UINT64_C(0xbe895233, 86091466), -522, -138},
  {GRISU_UINT64_C(0x843610cb, 4bf160cc), -465, -121},
  {GRISU_UINT64_C(0xb77ada06, 17e3bbcb), -409, -104},
  {GRISU_UINT64_C(0xfea126b7, d78186bd), -353, -87},
  {GRISU_UINT64_C(0xb0af48ec, 79ace837), -296, -70},
  {GRISU_UINT64_C(0xf5330471, 4d9265e0), -240, -53},
  {GRISU_UINT64_C(0xaa242499, 697392d3), -183, -36},
  {GRISU_UINT64_C(0xec1e4a7d, b69561a5), -127, -19},
  {GRISU_UINT64_C(0xa3d70a3d, 70a3d70a), -70, -2},
  {GRISU_UINT64_C(0xe35fa931, a0000000), -14, 15},
  {GRISU_UINT64_C(0x9dc5ada8, 2b70b59e), 43, 32},
  {GRISU_UINT64_C(0xdaf3f046, 51d47b4c), 99, 49},
  {GRISU_UINT64_C(0x97edd871, cfda3a57), 156, 66},
  {GRISU_UINT64_C(0xd2d80db0, 2aabd62c), 212, 83},
  {GRISU_UINT64_C(0x924d692c, a61be758), 269, 100},
  {GRISU_UINT64_C(0xcb090c80, 01ab551c), 325, 117},
  {GRISU_UINT64_C(0x8ce2529e, 2734bb1d), 382, 134},
  {GRISU_UINT64_C(0xc38413cf, 25e2d70e), 438, 151},
  {GRISU_UINT64_C(0x87aa9aff, 79042287), 495, 168},
  {GRISU_UINT64_C(0xbc4665b5, 96706115), 551, 185},
  {GRISU_UINT64_C(0x82a45b45, 0226b39d), 608, 202},
  {GRISU_UINT64_C(0xb54d5e4a, 127f59c8), 664, 219},
  {GRISU_UINT64_C(0xfb9b7cd9, a4a7443c), 720, 236},
  {GRISU_UINT64_C(0xae9672ab, a3d0c321), 777, 253},
  {GRISU_UINT64_C(0xf24a01a7, 3cf2dcd0), 833, 270},
  {GRISU_UINT64_C(0xa81f3014, 49ee8c70), 890, 287},
  {GRISU_UINT64_C(0xe950df20, 247c83fd), 946, 304},
  {GRISU_UINT64_C(0xa1e53af4, 6f801c53), 1003, 321},
  {GRISU_UINT64_C(0xe0accfa8, 75af45a8), 1059, 338},
  };
static const int GRISU_CACHE_MAX_DISTANCE(17) = 57;
// nb elements (17): 39
static const GRISU_CACHE_STRUCT GRISU_CACHE_NAME(18)[] = {
  {GRISU_UINT64_C(0xe61acf03, 3d1a45df), -1087, -308},
  {GRISU_UINT64_C(0xc795830d, 75038c1e), -1027, -290},
  {GRISU_UINT64_C(0xad1c8eab, 5ee43b67), -967, -272},
  {GRISU_UINT64_C(0x96267c75, 35b763b5), -907, -254},
  {GRISU_UINT64_C(0x823c1279, 5db6ce57), -847, -236},
  {GRISU_UINT64_C(0xe1ebce4d, c7f16dfc), -788, -218},
  {GRISU_UINT64_C(0xc3f490aa, 77bd60fd), -728, -200},
  {GRISU_UINT64_C(0xa9f6d30a, 038d1dbc), -668, -182},
  {GRISU_UINT64_C(0x936b9fce, bb25c996), -608, -164},
  {GRISU_UINT64_C(0xffbbcfe9, 94e5c620), -549, -146},
  {GRISU_UINT64_C(0xddd0467c, 64bce4a1), -489, -128},
  {GRISU_UINT64_C(0xc06481fb, 9bcf8d3a), -429, -110},
  {GRISU_UINT64_C(0xa6dfbd9f, b8e5b88f), -369, -92},
  {GRISU_UINT64_C(0x90bd77f3, 483bb9ba), -309, -74},
  {GRISU_UINT64_C(0xfb158592, be068d2f), -250, -56},
  {GRISU_UINT64_C(0xd9c7dced, 53c72256), -190, -38},
  {GRISU_UINT64_C(0xbce50864, 92111aeb), -130, -20},
  {GRISU_UINT64_C(0xa3d70a3d, 70a3d70a), -70, -2},
  {GRISU_UINT64_C(0x8e1bc9bf, 04000000), -10, 16},
  {GRISU_UINT64_C(0xf684df56, c3e01bc7), 49, 34},
  {GRISU_UINT64_C(0xd5d238a4, abe98068), 109, 52},
  {GRISU_UINT64_C(0xb975d6b6, ee39e437), 169, 70},
  {GRISU_UINT64_C(0xa0dc75f1, 778e39d6), 229, 88},
  {GRISU_UINT64_C(0x8b865b21, 5899f46d), 289, 106},
  {GRISU_UINT64_C(0xf209787b, b47d6b85), 348, 124},
  {GRISU_UINT64_C(0xd1ef0244, af2364ff), 408, 142},
  {GRISU_UINT64_C(0xb616a12b, 7fe617aa), 468, 160},
  {GRISU_UINT64_C(0x9defbf01, b061adab), 528, 178},
  {GRISU_UINT64_C(0x88fcf317, f22241e2), 588, 196},
  {GRISU_UINT64_C(0xeda2ee1c, 7064130c), 647, 214},
  {GRISU_UINT64_C(0xce1de406, 42e3f4b9), 707, 232},
  {GRISU_UINT64_C(0xb2c71d5b, ca9023f8), 767, 250},
  {GRISU_UINT64_C(0x9b10a4e5, e9913129), 827, 268},
  {GRISU_UINT64_C(0x867f59a9, d4bed6c0), 887, 286},
  {GRISU_UINT64_C(0xe950df20, 247c83fd), 946, 304},
  {GRISU_UINT64_C(0xca5e89b1, 8b602368), 1006, 322},
  {GRISU_UINT64_C(0xaf87023b, 9bf0ee6b), 1066, 340},
  };
static const int GRISU_CACHE_MAX_DISTANCE(18) = 60;
// nb elements (18): 37
static const GRISU_CACHE_STRUCT GRISU_CACHE_NAME(19)[] = {
  {GRISU_UINT64_C(0xe61acf03, 3d1a45df), -1087, -308},
  {GRISU_UINT64_C(0xf97ae3d0, d2446f25), -1024, -289},
  {GRISU_UINT64_C(0x873e4f75, e2224e68), -960, -270},
  {GRISU_UINT64_C(0x92a1958a, 7675175f), -897, -251},
  {GRISU_UINT64_C(0x9efa548d, 26e5a6e2), -834, -232},
  {GRISU_UINT64_C(0xac5d37d5, b79b6239), -771, -213},
  {GRISU_UINT64_C(0xbae0a846, d2195713), -708, -194},
  {GRISU_UINT64_C(0xca9cf1d2, 06fdc03c), -645, -175},
  {GRISU_UINT64_C(0xdbac6c24, 7d62a584), -582, -156},
  {GRISU_UINT64_C(0xee2ba6c0, 678b597f), -519, -137},
  {GRISU_UINT64_C(0x811ccc66, 8829b887), -455, -118},
  {GRISU_UINT64_C(0x8bfbea76, c619ef36), -392, -99},
  {GRISU_UINT64_C(0x97c560ba, 6b0919a6), -329, -80},
  {GRISU_UINT64_C(0xa48ceaaa, b75a8e2b), -266, -61},
  {GRISU_UINT64_C(0xb267ed19, 40f1c61c), -203, -42},
  {GRISU_UINT64_C(0xc16d9a00, 95928a27), -140, -23},
  {GRISU_UINT64_C(0xd1b71758, e219652c), -77, -4},
  {GRISU_UINT64_C(0xe35fa931, a0000000), -14, 15},
  {GRISU_UINT64_C(0xf684df56, c3e01bc7), 49, 34},
  {GRISU_UINT64_C(0x85a36366, eb71f041), 113, 53},
  {GRISU_UINT64_C(0x90e40fbe, ea1d3a4b), 176, 72},
  {GRISU_UINT64_C(0x9d174b2d, cec0e47b), 239, 91},
  {GRISU_UINT64_C(0xaa51823e, 34a7eedf), 302, 110},
  {GRISU_UINT64_C(0xb8a8d9bb, e123f018), 365, 129},
  {GRISU_UINT64_C(0xc83553c5, c8965d3d), 428, 148},
  {GRISU_UINT64_C(0xd910f7ff, 28069da4), 491, 167},
  {GRISU_UINT64_C(0xeb57ff22, fc0c795a), 554, 186},
  {GRISU_UINT64_C(0xff290242, c83396ce), 617, 205},
  {GRISU_UINT64_C(0x8a5296ff, e33cc930), 681, 224},
  {GRISU_UINT64_C(0x95f83d0a, 1fb69cd9), 744, 243},
  {GRISU_UINT64_C(0xa298f2c5, 01f45f43), 807, 262},
  {GRISU_UINT64_C(0xb049dc01, 6abc5e60), 870, 281},
  {GRISU_UINT64_C(0xbf21e440, 03acdd2d), 933, 300},
  {GRISU_UINT64_C(0xcf39e50f, eae16bf0), 996, 319},
  {GRISU_UINT64_C(0xe0accfa8, 75af45a8), 1059, 338},
  };
static const int GRISU_CACHE_MAX_DISTANCE(19) = 64;
// nb elements (19): 35
static const GRISU_CACHE_STRUCT GRISU_CACHE_NAME(20)[] = {
  {GRISU_UINT64_C(0xe61acf03, 3d1a45df), -1087, -308},
  {GRISU_UINT64_C(0x9becce62, 836ac577), -1020, -288},
  {GRISU_UINT64_C(0xd3515c28, 31559a83), -954, -268},
  {GRISU_UINT64_C(0x8f31cc09, 37ae58d3), -887, -248},
  {GRISU_UINT64_C(0xc2109436, 4dfb5637), -821, -228},
  {GRISU_UINT64_C(0x8380dea9, 3da4bc60), -754, -208},
  {GRISU_UINT64_C(0xb23867fb, 2a35b28e), -688, -188},
  {GRISU_UINT64_C(0xf18899b1, bc3f8ca2), -622, -168},
  {GRISU_UINT64_C(0xa3ab6658, 0d5fdaf6), -555, -148},
  {GRISU_UINT64_C(0xddd0467c, 64bce4a1), -489, -128},
  {GRISU_UINT64_C(0x964e858c, 91ba2655), -422, -108},
  {GRISU_UINT64_C(0xcbb41ef9, 79346bca), -356, -88},
  {GRISU_UINT64_C(0x8a08f0f8, bf0f156b), -289, -68},
  {GRISU_UINT64_C(0xbb127c53, b17ec159), -223, -48},
  {GRISU_UINT64_C(0xfd87b5f2, 8300ca0e), -157, -28},
  {GRISU_UINT64_C(0xabcc7711, 8461cefd), -90, -8},
  {GRISU_UINT64_C(0xe8d4a510, 00000000), -24, 12},
  {GRISU_UINT64_C(0x9dc5ada8, 2b70b59e), 43, 32},
  {GRISU_UINT64_C(0xd5d238a4, abe98068), 109, 52},
  {GRISU_UINT64_C(0x90e40fbe, ea1d3a4b), 176, 72},
  {GRISU_UINT64_C(0xc45d1df9, 42711d9a), 242, 92},
  {GRISU_UINT64_C(0x850fadc0, 9923329e), 309, 112},
  {GRISU_UINT64_C(0xb454e4a1, 79dd1877), 375, 132},
  {GRISU_UINT64_C(0xf46518c2, ef5b8cd1), 441, 152},
  {GRISU_UINT64_C(0xa59bc234, db398c25), 508, 172},
  {GRISU_UINT64_C(0xe070f78d, 3927556b), 574, 192},
  {GRISU_UINT64_C(0x98165af3, 7b2153df), 641, 212},
  {GRISU_UINT64_C(0xce1de406, 42e3f4b9), 707, 232},
  {GRISU_UINT64_C(0x8bab8eef, b6409c1a), 774, 252},
  {GRISU_UINT64_C(0xbd49d14a, a79dbc82), 840, 272},
  {GRISU_UINT64_C(0x80444b5e, 7aa7cf85), 907, 292},
  {GRISU_UINT64_C(0xadd57a27, d29339f6), 973, 312},
  {GRISU_UINT64_C(0xeb96bf6e, badf77d9), 1039, 332},
  };
static const int GRISU_CACHE_MAX_DISTANCE(20) = 67;
// nb elements (20): 33
static const int GRISU_CACHE_OFFSET = 308;
