/* diagnostics.c generated by valac 0.36.4, the Vala compiler
 * generated from diagnostics.vala, do not modify */

/*
 * This file is part of gnome-code-assistance.
 *
 * Copyright (C) 2013 - Melissa Wen <melissa.srw@gmail.com>
 * Copyright (C) 2013 - Jesse van den Kieboom <jessevdk@gnome.org>
 *
 * gnome-code-assistance is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * gnome-code-assistance is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gnome-code-assistance.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include "backends/vala/libvalashared.h"


#define TYPE_DIAGNOSTICS (diagnostics_get_type ())
#define DIAGNOSTICS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DIAGNOSTICS, Diagnostics))
#define DIAGNOSTICS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DIAGNOSTICS, DiagnosticsClass))
#define IS_DIAGNOSTICS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DIAGNOSTICS))
#define IS_DIAGNOSTICS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DIAGNOSTICS))
#define DIAGNOSTICS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DIAGNOSTICS, DiagnosticsClass))

typedef struct _Diagnostics Diagnostics;
typedef struct _DiagnosticsClass DiagnosticsClass;
typedef struct _DiagnosticsPrivate DiagnosticsPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_Diagnostic_free0(var) ((var == NULL) ? NULL : (var = (_vala_Diagnostic_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _Diagnostics {
	ValaReport parent_instance;
	DiagnosticsPrivate * priv;
};

struct _DiagnosticsClass {
	ValaReportClass parent_class;
};

struct _DiagnosticsPrivate {
	GeeHashMap* d_diagnostics;
};


static gpointer diagnostics_parent_class = NULL;

GType diagnostics_get_type (void) G_GNUC_CONST;
#define DIAGNOSTICS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DIAGNOSTICS, DiagnosticsPrivate))
enum  {
	DIAGNOSTICS_DUMMY_PROPERTY
};
Diagnostics* diagnostics_new (void);
Diagnostics* diagnostics_construct (GType object_type);
Diagnostic* diagnostics_diagnostics_for_path (Diagnostics* self, const gchar* path, int* result_length1);
static void _vala_array_add1 (Diagnostic* * array, int* length, int* size, const Diagnostic* value);
static void _vala_Diagnostic_free (Diagnostic* self);
static void _vala_Diagnostic_array_free (Diagnostic * array, gint array_length);
static void diagnostics_diags_report (Diagnostics* self, ValaSourceReference* source, const gchar* message, Severity severity);
static Diagnostic* _diagnostic_dup (Diagnostic* self);
static void _vala_Fixit_array_free (Fixit * array, gint array_length);
static void diagnostics_real_err (ValaReport* base, ValaSourceReference* source, const gchar* message);
static void diagnostics_real_warn (ValaReport* base, ValaSourceReference* source, const gchar* message);
static void diagnostics_real_depr (ValaReport* base, ValaSourceReference* source, const gchar* message);
static void diagnostics_real_note (ValaReport* base, ValaSourceReference* source, const gchar* message);
static void diagnostics_finalize (GObject * obj);


Diagnostics* diagnostics_construct (GType object_type) {
	Diagnostics * self = NULL;
	GeeHashMap* _tmp0_;
	self = (Diagnostics*) vala_report_construct (object_type);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->d_diagnostics);
	self->priv->d_diagnostics = _tmp0_;
	return self;
}


Diagnostics* diagnostics_new (void) {
	return diagnostics_construct (TYPE_DIAGNOSTICS);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _vala_array_add1 (Diagnostic* * array, int* length, int* size, const Diagnostic* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (Diagnostic, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static void _vala_Diagnostic_free (Diagnostic* self) {
	diagnostic_destroy (self);
	g_free (self);
}


static void _vala_Diagnostic_array_free (Diagnostic * array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			diagnostic_destroy (&array[i]);
		}
	}
	g_free (array);
}


Diagnostic* diagnostics_diagnostics_for_path (Diagnostics* self, const gchar* path, int* result_length1) {
	Diagnostic* result = NULL;
	GeeArrayList* diagnostics = NULL;
	GeeHashMap* _tmp0_;
	const gchar* _tmp1_;
	gpointer _tmp2_;
	GeeArrayList* _tmp3_;
	Diagnostic* ret = NULL;
	GeeArrayList* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	Diagnostic* _tmp9_;
	gint ret_length1;
	gint _ret_size_;
	gint _tmp10_;
	Diagnostic* _tmp25_;
	gint _tmp25__length1;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = self->priv->d_diagnostics;
	_tmp1_ = path;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, _tmp1_);
	diagnostics = (GeeArrayList*) _tmp2_;
	_tmp3_ = diagnostics;
	if (_tmp3_ == NULL) {
		Diagnostic* _tmp4_;
		Diagnostic* _tmp5_;
		gint _tmp5__length1;
		_tmp4_ = g_new0 (Diagnostic, 0);
		_tmp5_ = _tmp4_;
		_tmp5__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp5__length1;
		}
		result = _tmp5_;
		_g_object_unref0 (diagnostics);
		return result;
	}
	_tmp6_ = diagnostics;
	_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_new0 (Diagnostic, _tmp8_);
	ret = _tmp9_;
	ret_length1 = _tmp8_;
	_ret_size_ = ret_length1;
	ret_length1 = 0;
	_tmp10_ = ret_length1;
	{
		GeeArrayList* _d_list = NULL;
		GeeArrayList* _tmp11_;
		GeeArrayList* _tmp12_;
		gint _d_size = 0;
		GeeArrayList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _d_index = 0;
		_tmp11_ = diagnostics;
		_tmp12_ = _g_object_ref0 (_tmp11_);
		_d_list = _tmp12_;
		_tmp13_ = _d_list;
		_tmp14_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_d_size = _tmp15_;
		_d_index = -1;
		while (TRUE) {
			gint _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			Diagnostic* d = NULL;
			GeeArrayList* _tmp19_;
			gint _tmp20_;
			gpointer _tmp21_;
			Diagnostic* _tmp22_;
			gint _tmp22__length1;
			Diagnostic* _tmp23_;
			Diagnostic _tmp24_ = {0};
			_tmp16_ = _d_index;
			_d_index = _tmp16_ + 1;
			_tmp17_ = _d_index;
			_tmp18_ = _d_size;
			if (!(_tmp17_ < _tmp18_)) {
				break;
			}
			_tmp19_ = _d_list;
			_tmp20_ = _d_index;
			_tmp21_ = gee_abstract_list_get ((GeeAbstractList*) _tmp19_, _tmp20_);
			d = (Diagnostic*) _tmp21_;
			_tmp22_ = ret;
			_tmp22__length1 = ret_length1;
			_tmp23_ = d;
			diagnostic_copy (_tmp23_, &_tmp24_);
			_vala_array_add1 (&ret, &ret_length1, &_ret_size_, &_tmp24_);
			__vala_Diagnostic_free0 (d);
		}
		_g_object_unref0 (_d_list);
	}
	_tmp25_ = ret;
	_tmp25__length1 = ret_length1;
	if (result_length1) {
		*result_length1 = _tmp25__length1;
	}
	result = _tmp25_;
	_g_object_unref0 (diagnostics);
	return result;
}


static Diagnostic* _diagnostic_dup (Diagnostic* self) {
	Diagnostic* dup;
	dup = g_new0 (Diagnostic, 1);
	diagnostic_copy (self, dup);
	return dup;
}


static void _vala_Fixit_array_free (Fixit * array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			fixit_destroy (&array[i]);
		}
	}
	g_free (array);
}


static void diagnostics_diags_report (Diagnostics* self, ValaSourceReference* source, const gchar* message, Severity severity) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaSourceReference* _tmp2_;
	GeeArrayList* diagnostics = NULL;
	GeeHashMap* _tmp11_;
	ValaSourceReference* _tmp12_;
	ValaSourceFile* _tmp13_;
	ValaSourceFile* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gpointer _tmp17_;
	GeeArrayList* _tmp18_;
	SourceLocation start = {0};
	ValaSourceReference* _tmp27_;
	ValaSourceLocation _tmp28_ = {0};
	ValaSourceLocation _tmp29_;
	gint _tmp30_;
	ValaSourceReference* _tmp31_;
	ValaSourceLocation _tmp32_ = {0};
	ValaSourceLocation _tmp33_;
	gint _tmp34_;
	SourceLocation _tmp35_ = {0};
	SourceLocation end = {0};
	ValaSourceReference* _tmp36_;
	ValaSourceLocation _tmp37_ = {0};
	ValaSourceLocation _tmp38_;
	gint _tmp39_;
	ValaSourceReference* _tmp40_;
	ValaSourceLocation _tmp41_ = {0};
	ValaSourceLocation _tmp42_;
	gint _tmp43_;
	SourceLocation _tmp44_ = {0};
	SourceLocation _tmp45_;
	gint _tmp46_;
	SourceRange range = {0};
	SourceLocation _tmp50_;
	SourceLocation _tmp51_;
	SourceRange _tmp52_ = {0};
	GeeArrayList* _tmp53_;
	Severity _tmp54_;
	Fixit* _tmp55_;
	SourceRange _tmp56_;
	SourceRange* _tmp57_;
	const gchar* _tmp58_;
	gchar* _tmp59_;
	Diagnostic _tmp60_ = {0};
	Diagnostic _tmp61_;
	Diagnostic _tmp62_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_tmp2_ = source;
	if (_tmp2_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaSourceReference* _tmp3_;
		ValaSourceFile* _tmp4_;
		ValaSourceFile* _tmp5_;
		_tmp3_ = source;
		_tmp4_ = vala_source_reference_get_file (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp1_ = _tmp5_ == NULL;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		ValaSourceReference* _tmp6_;
		ValaSourceFile* _tmp7_;
		ValaSourceFile* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		_tmp6_ = source;
		_tmp7_ = vala_source_reference_get_file (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_source_file_get_filename (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp0_ = _tmp10_ == NULL;
	}
	if (_tmp0_) {
		return;
	}
	_tmp11_ = self->priv->d_diagnostics;
	_tmp12_ = source;
	_tmp13_ = vala_source_reference_get_file (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = vala_source_file_get_filename (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp11_, _tmp16_);
	diagnostics = (GeeArrayList*) _tmp17_;
	_tmp18_ = diagnostics;
	if (_tmp18_ == NULL) {
		GeeArrayList* _tmp19_;
		GeeHashMap* _tmp20_;
		ValaSourceReference* _tmp21_;
		ValaSourceFile* _tmp22_;
		ValaSourceFile* _tmp23_;
		const gchar* _tmp24_;
		const gchar* _tmp25_;
		GeeArrayList* _tmp26_;
		_tmp19_ = gee_array_list_new (TYPE_DIAGNOSTIC, (GBoxedCopyFunc) _diagnostic_dup, (GDestroyNotify) _vala_Diagnostic_free, NULL, NULL, NULL);
		_g_object_unref0 (diagnostics);
		diagnostics = _tmp19_;
		_tmp20_ = self->priv->d_diagnostics;
		_tmp21_ = source;
		_tmp22_ = vala_source_reference_get_file (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = vala_source_file_get_filename (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = diagnostics;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp20_, _tmp25_, _tmp26_);
	}
	_tmp27_ = source;
	vala_source_reference_get_begin (_tmp27_, &_tmp28_);
	_tmp29_ = _tmp28_;
	_tmp30_ = _tmp29_.line;
	_tmp31_ = source;
	vala_source_reference_get_begin (_tmp31_, &_tmp32_);
	_tmp33_ = _tmp32_;
	_tmp34_ = _tmp33_.column;
	memset (&_tmp35_, 0, sizeof (SourceLocation));
	_tmp35_.line = (gint64) _tmp30_;
	_tmp35_.column = (gint64) _tmp34_;
	start = _tmp35_;
	_tmp36_ = source;
	vala_source_reference_get_end (_tmp36_, &_tmp37_);
	_tmp38_ = _tmp37_;
	_tmp39_ = _tmp38_.line;
	_tmp40_ = source;
	vala_source_reference_get_end (_tmp40_, &_tmp41_);
	_tmp42_ = _tmp41_;
	_tmp43_ = _tmp42_.column;
	memset (&_tmp44_, 0, sizeof (SourceLocation));
	_tmp44_.line = (gint64) _tmp39_;
	_tmp44_.column = (gint64) _tmp43_;
	end = _tmp44_;
	_tmp45_ = end;
	_tmp46_ = source_location_compare_to (&start, &_tmp45_);
	if (_tmp46_ > 0) {
		SourceLocation tmp = {0};
		SourceLocation _tmp47_;
		SourceLocation _tmp48_;
		SourceLocation _tmp49_;
		_tmp47_ = end;
		tmp = _tmp47_;
		_tmp48_ = start;
		end = _tmp48_;
		_tmp49_ = tmp;
		start = _tmp49_;
	}
	_tmp50_ = start;
	_tmp51_ = end;
	memset (&_tmp52_, 0, sizeof (SourceRange));
	_tmp52_.file = (gint64) 0;
	_tmp52_.start = _tmp50_;
	_tmp52_.end = _tmp51_;
	range = _tmp52_;
	_tmp53_ = diagnostics;
	_tmp54_ = severity;
	_tmp55_ = g_new0 (Fixit, 0);
	_tmp56_ = range;
	_tmp57_ = g_new0 (SourceRange, 1);
	_tmp57_[0] = _tmp56_;
	_tmp58_ = message;
	_tmp59_ = g_strdup (_tmp58_);
	memset (&_tmp60_, 0, sizeof (Diagnostic));
	_tmp60_.severity = (guint32) _tmp54_;
	_tmp60_.fixits = (_vala_Fixit_array_free (_tmp60_.fixits, _tmp60_.fixits_length1), NULL);
	_tmp60_.fixits = _tmp55_;
	_tmp60_.fixits_length1 = 0;
	_tmp60_.locations = (g_free (_tmp60_.locations), NULL);
	_tmp60_.locations = _tmp57_;
	_tmp60_.locations_length1 = 1;
	_g_free0 (_tmp60_.message);
	_tmp60_.message = _tmp59_;
	_tmp61_ = _tmp60_;
	_tmp62_ = _tmp61_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp53_, &_tmp62_);
	diagnostic_destroy (&_tmp61_);
	_g_object_unref0 (diagnostics);
}


static void diagnostics_real_err (ValaReport* base, ValaSourceReference* source, const gchar* message) {
	Diagnostics * self;
	const gchar* _tmp0_;
	ValaSourceReference* _tmp1_;
	const gchar* _tmp2_;
	self = (Diagnostics*) base;
	g_return_if_fail (message != NULL);
	_tmp0_ = message;
	g_log ("GcaVala", G_LOG_LEVEL_DEBUG, "diagnostics.vala:103: [err]: %s", _tmp0_);
	_tmp1_ = source;
	_tmp2_ = message;
	diagnostics_diags_report (self, _tmp1_, _tmp2_, SEVERITY_ERROR);
}


static void diagnostics_real_warn (ValaReport* base, ValaSourceReference* source, const gchar* message) {
	Diagnostics * self;
	const gchar* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ValaSourceReference* _tmp3_;
	const gchar* _tmp4_;
	self = (Diagnostics*) base;
	g_return_if_fail (message != NULL);
	_tmp0_ = message;
	g_log ("GcaVala", G_LOG_LEVEL_DEBUG, "diagnostics.vala:110: [warn]: %s", _tmp0_);
	_tmp1_ = vala_report_get_enable_warnings ((ValaReport*) self);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = source;
	_tmp4_ = message;
	diagnostics_diags_report (self, _tmp3_, _tmp4_, SEVERITY_WARNING);
}


static void diagnostics_real_depr (ValaReport* base, ValaSourceReference* source, const gchar* message) {
	Diagnostics * self;
	const gchar* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ValaSourceReference* _tmp3_;
	const gchar* _tmp4_;
	self = (Diagnostics*) base;
	g_return_if_fail (message != NULL);
	_tmp0_ = message;
	g_log ("GcaVala", G_LOG_LEVEL_DEBUG, "diagnostics.vala:122: [depr]: %s", _tmp0_);
	_tmp1_ = vala_report_get_enable_warnings ((ValaReport*) self);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = source;
	_tmp4_ = message;
	diagnostics_diags_report (self, _tmp3_, _tmp4_, SEVERITY_DEPRECATED);
}


static void diagnostics_real_note (ValaReport* base, ValaSourceReference* source, const gchar* message) {
	Diagnostics * self;
	const gchar* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ValaSourceReference* _tmp3_;
	const gchar* _tmp4_;
	self = (Diagnostics*) base;
	g_return_if_fail (message != NULL);
	_tmp0_ = message;
	g_log ("GcaVala", G_LOG_LEVEL_DEBUG, "diagnostics.vala:134: [note]: %s", _tmp0_);
	_tmp1_ = vala_report_get_enable_warnings ((ValaReport*) self);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = source;
	_tmp4_ = message;
	diagnostics_diags_report (self, _tmp3_, _tmp4_, SEVERITY_INFO);
}


static void diagnostics_class_init (DiagnosticsClass * klass) {
	diagnostics_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DiagnosticsPrivate));
	((ValaReportClass *) klass)->err = (void (*) (ValaReport *, ValaSourceReference*, const gchar*)) diagnostics_real_err;
	((ValaReportClass *) klass)->warn = (void (*) (ValaReport *, ValaSourceReference*, const gchar*)) diagnostics_real_warn;
	((ValaReportClass *) klass)->depr = (void (*) (ValaReport *, ValaSourceReference*, const gchar*)) diagnostics_real_depr;
	((ValaReportClass *) klass)->note = (void (*) (ValaReport *, ValaSourceReference*, const gchar*)) diagnostics_real_note;
	G_OBJECT_CLASS (klass)->finalize = diagnostics_finalize;
}


static void diagnostics_instance_init (Diagnostics * self) {
	self->priv = DIAGNOSTICS_GET_PRIVATE (self);
}


static void diagnostics_finalize (GObject * obj) {
	Diagnostics * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DIAGNOSTICS, Diagnostics);
	_g_object_unref0 (self->priv->d_diagnostics);
	G_OBJECT_CLASS (diagnostics_parent_class)->finalize (obj);
}


GType diagnostics_get_type (void) {
	static volatile gsize diagnostics_type_id__volatile = 0;
	if (g_once_init_enter (&diagnostics_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DiagnosticsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) diagnostics_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Diagnostics), 0, (GInstanceInitFunc) diagnostics_instance_init, NULL };
		GType diagnostics_type_id;
		diagnostics_type_id = g_type_register_static (VALA_TYPE_REPORT, "Diagnostics", &g_define_type_info, 0);
		g_once_init_leave (&diagnostics_type_id__volatile, diagnostics_type_id);
	}
	return diagnostics_type_id__volatile;
}



