/* DMManager.c generated by valac 0.34.6, the Vala compiler
 * generated from DMManager.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <rest/oauth-proxy.h>
#include "CbUserCounter.h"
#include "CbFilter.h"
#include <stdlib.h>
#include <string.h>
#include "CbTypes.h"
#include <cairo.h>
#include <gio/gio.h>
#include <rest/rest-proxy-call.h>
#include <rest/rest-proxy.h>
#include <json-glib/json-glib.h>
#include "CbTextTransform.h"


#define TYPE_DM_MANAGER (dm_manager_get_type ())
#define DM_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DM_MANAGER, DMManager))
#define DM_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DM_MANAGER, DMManagerClass))
#define IS_DM_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DM_MANAGER))
#define IS_DM_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DM_MANAGER))
#define DM_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DM_MANAGER, DMManagerClass))

typedef struct _DMManager DMManager;
typedef struct _DMManagerClass DMManagerClass;
typedef struct _DMManagerPrivate DMManagerPrivate;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_DM_THREADS_MODEL (dm_threads_model_get_type ())
#define DM_THREADS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DM_THREADS_MODEL, DMThreadsModel))
#define DM_THREADS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DM_THREADS_MODEL, DMThreadsModelClass))
#define IS_DM_THREADS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DM_THREADS_MODEL))
#define IS_DM_THREADS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DM_THREADS_MODEL))
#define DM_THREADS_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DM_THREADS_MODEL, DMThreadsModelClass))

typedef struct _DMThreadsModel DMThreadsModel;
typedef struct _DMThreadsModelClass DMThreadsModelClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _AccountPrivate AccountPrivate;

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define TYPE_USER_STREAM (user_stream_get_type ())
#define USER_STREAM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_STREAM, UserStream))
#define USER_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_STREAM, UserStreamClass))
#define IS_USER_STREAM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_STREAM))
#define IS_USER_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_STREAM))
#define USER_STREAM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_STREAM, UserStreamClass))

typedef struct _UserStream UserStream;
typedef struct _UserStreamClass UserStreamClass;

#define TYPE_NOTIFICATION_MANAGER (notification_manager_get_type ())
#define NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManager))
#define NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))
#define IS_NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATION_MANAGER))
#define IS_NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATION_MANAGER))
#define NOTIFICATION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))

typedef struct _NotificationManager NotificationManager;
typedef struct _NotificationManagerClass NotificationManagerClass;

#define SQL_TYPE_SELECT_STATEMENT (sql_select_statement_get_type ())
#define SQL_SELECT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_SELECT_STATEMENT, SqlSelectStatement))
#define SQL_SELECT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_SELECT_STATEMENT, SqlSelectStatementClass))
#define SQL_IS_SELECT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_SELECT_STATEMENT))
#define SQL_IS_SELECT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_SELECT_STATEMENT))
#define SQL_SELECT_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_SELECT_STATEMENT, SqlSelectStatementClass))

typedef struct _SqlSelectStatement SqlSelectStatement;
typedef struct _SqlSelectStatementClass SqlSelectStatementClass;

#define TYPE_DM_THREAD (dm_thread_get_type ())
#define DM_THREAD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DM_THREAD, DMThread))
#define DM_THREAD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DM_THREAD, DMThreadClass))
#define IS_DM_THREAD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DM_THREAD))
#define IS_DM_THREAD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DM_THREAD))
#define DM_THREAD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DM_THREAD, DMThreadClass))

typedef struct _DMThread DMThread;
typedef struct _DMThreadClass DMThreadClass;
typedef struct _DMThreadPrivate DMThreadPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_COLLECT (collect_get_type ())
#define COLLECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COLLECT, Collect))
#define COLLECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COLLECT, CollectClass))
#define IS_COLLECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COLLECT))
#define IS_COLLECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COLLECT))
#define COLLECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COLLECT, CollectClass))

typedef struct _Collect Collect;
typedef struct _CollectClass CollectClass;
typedef struct _Block39Data Block39Data;
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _DmManagerLoadNewestDmsData DmManagerLoadNewestDmsData;
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
typedef struct _Block40Data Block40Data;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define SQL_TYPE_INSERT_STATEMENT (sql_insert_statement_get_type ())
#define SQL_INSERT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_INSERT_STATEMENT, SqlInsertStatement))
#define SQL_INSERT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_INSERT_STATEMENT, SqlInsertStatementClass))
#define SQL_IS_INSERT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_INSERT_STATEMENT))
#define SQL_IS_INSERT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_INSERT_STATEMENT))
#define SQL_INSERT_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_INSERT_STATEMENT, SqlInsertStatementClass))

typedef struct _SqlInsertStatement SqlInsertStatement;
typedef struct _SqlInsertStatementClass SqlInsertStatementClass;

#define SQL_TYPE_UPDATE_STATEMENT (sql_update_statement_get_type ())
#define SQL_UPDATE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_UPDATE_STATEMENT, SqlUpdateStatement))
#define SQL_UPDATE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_UPDATE_STATEMENT, SqlUpdateStatementClass))
#define SQL_IS_UPDATE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_UPDATE_STATEMENT))
#define SQL_IS_UPDATE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_UPDATE_STATEMENT))
#define SQL_UPDATE_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_UPDATE_STATEMENT, SqlUpdateStatementClass))

typedef struct _SqlUpdateStatement SqlUpdateStatement;
typedef struct _SqlUpdateStatementClass SqlUpdateStatementClass;
typedef struct _Block41Data Block41Data;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _DMManager {
	GObject parent_instance;
	DMManagerPrivate * priv;
};

struct _DMManagerClass {
	GObjectClass parent_class;
};

struct _DMManagerPrivate {
	Account* account;
	DMThreadsModel* threads_model;
};

struct _Account {
	GObject parent_instance;
	AccountPrivate * priv;
	gint64 id;
	SqlDatabase* db;
	OAuthProxy* proxy;
	UserStream* user_stream;
	CbUserCounter* user_counter;
	NotificationManager* notifications;
	gint64* friends;
	gint friends_length1;
	gint64* blocked;
	gint blocked_length1;
	gint64* muted;
	gint muted_length1;
	gint64* disabled_rts;
	gint disabled_rts_length1;
	GPtrArray* filters;
};

struct _AccountClass {
	GObjectClass parent_class;
};

typedef gboolean (*SqlSelectCallback) (gchar** vals, int vals_length1, void* user_data);
struct _DMThread {
	GObject parent_instance;
	DMThreadPrivate * priv;
	CbUserIdentity user;
	gint64 last_message_id;
	gchar* last_message;
	gint unread_count;
	gchar* notification_id;
	cairo_surface_t* avatar_surface;
};

struct _DMThreadClass {
	GObjectClass parent_class;
};

struct _Block39Data {
	int _ref_count_;
	DMManager* self;
	Collect* collect_obj;
	gpointer _async_data_;
};

struct _DmManagerLoadNewestDmsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DMManager* self;
	Block39Data* _data39_;
	Collect* _tmp0_;
	gint64 max_received_id;
	Account* _tmp1_;
	SqlDatabase* _tmp2_;
	SqlSelectStatement* _tmp3_;
	SqlSelectStatement* _tmp4_;
	SqlSelectStatement* _tmp5_;
	SqlSelectStatement* _tmp6_;
	Account* _tmp7_;
	gint64 _tmp8_;
	SqlSelectStatement* _tmp9_;
	SqlSelectStatement* _tmp10_;
	SqlSelectStatement* _tmp11_;
	SqlSelectStatement* _tmp12_;
	SqlSelectStatement* _tmp13_;
	SqlSelectStatement* _tmp14_;
	gint64 _tmp15_;
	gint64 _tmp16_;
	gint64 max_sent_id;
	Account* _tmp17_;
	SqlDatabase* _tmp18_;
	SqlSelectStatement* _tmp19_;
	SqlSelectStatement* _tmp20_;
	SqlSelectStatement* _tmp21_;
	SqlSelectStatement* _tmp22_;
	Account* _tmp23_;
	gint64 _tmp24_;
	SqlSelectStatement* _tmp25_;
	SqlSelectStatement* _tmp26_;
	SqlSelectStatement* _tmp27_;
	SqlSelectStatement* _tmp28_;
	SqlSelectStatement* _tmp29_;
	SqlSelectStatement* _tmp30_;
	gint64 _tmp31_;
	gint64 _tmp32_;
	RestProxyCall* call;
	Account* _tmp33_;
	OAuthProxy* _tmp34_;
	RestProxyCall* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	RestProxyCall* sent_call;
	Account* _tmp38_;
	OAuthProxy* _tmp39_;
	RestProxyCall* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
};

struct _Block40Data {
	int _ref_count_;
	DMManager* self;
	CbTextEntity* url_list;
	gint url_list_length1;
	gint _url_list_size_;
};

struct _Block41Data {
	int _ref_count_;
	DMManager* self;
	CbTextEntity* url_list;
	gint url_list_length1;
	gint _url_list_size_;
};


static gpointer dm_manager_parent_class = NULL;

GType dm_manager_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
GType dm_threads_model_get_type (void) G_GNUC_CONST;
#define DM_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DM_MANAGER, DMManagerPrivate))
enum  {
	DM_MANAGER_DUMMY_PROPERTY,
	DM_MANAGER_EMPTY
};
DMManager* dm_manager_new_for_account (Account* account);
DMManager* dm_manager_construct_for_account (GType object_type, Account* account);
DMThreadsModel* dm_threads_model_new (void);
DMThreadsModel* dm_threads_model_construct (GType object_type);
void dm_manager_load_cached_threads (DMManager* self);
GType sql_database_get_type (void) G_GNUC_CONST;
GType user_stream_get_type (void) G_GNUC_CONST;
GType notification_manager_get_type (void) G_GNUC_CONST;
GType sql_select_statement_get_type (void) G_GNUC_CONST;
SqlSelectStatement* sql_database_select (SqlDatabase* self, const gchar* table_name);
SqlSelectStatement* sql_select_statement_cols (SqlSelectStatement* self, const gchar* first, ...);
SqlSelectStatement* sql_select_statement_order (SqlSelectStatement* self, const gchar* order_by);
gint sql_select_statement_run (SqlSelectStatement* self, SqlSelectCallback callback, void* callback_target);
static gboolean __lambda85_ (DMManager* self, gchar** vals, int vals_length1);
GType dm_thread_get_type (void) G_GNUC_CONST;
DMThread* dm_thread_new (void);
DMThread* dm_thread_construct (GType object_type);
void dm_threads_model_add (DMThreadsModel* self, DMThread* thread);
static gboolean ___lambda85__sql_select_callback (gchar** vals, int vals_length1, gpointer self);
GListModel* dm_manager_get_threads_model (DMManager* self);
gboolean dm_manager_has_thread (DMManager* self, gint64 user_id);
gboolean dm_threads_model_has_thread (DMThreadsModel* self, gint64 user_id);
gint dm_manager_reset_unread_count (DMManager* self, gint64 user_id);
gint dm_threads_model_reset_unread_count (DMThreadsModel* self, gint64 user_id);
DMThread* dm_threads_model_get_thread (DMThreadsModel* self, gint64 user_id);
gchar* dm_manager_reset_notification_id (DMManager* self, gint64 user_id);
gchar* dm_threads_model_reset_notification_id (DMThreadsModel* self, gint64 user_id);
static void dm_manager_load_newest_dms_data_free (gpointer _data);
void dm_manager_load_newest_dms (DMManager* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void dm_manager_load_newest_dms_finish (DMManager* self, GAsyncResult* _res_);
static gboolean dm_manager_load_newest_dms_co (DmManagerLoadNewestDmsData* _data_);
GType collect_get_type (void) G_GNUC_CONST;
static Block39Data* block39_data_ref (Block39Data* _data39_);
static void block39_data_unref (void * _userdata_);
Collect* collect_new (gint max);
Collect* collect_construct (GType object_type, gint max);
static void __lambda86_ (Block39Data* _data39_);
static void ___lambda86__collect_finished (Collect* _sender, GError* _error_, gpointer self);
SqlSelectStatement* sql_select_statement_where_eqi (SqlSelectStatement* self, const gchar* w, gint64 v);
SqlSelectStatement* sql_select_statement_limit (SqlSelectStatement* self, gint limit);
gint64 sql_select_statement_once_i64 (SqlSelectStatement* self);
void tweet_utils_load_threaded (RestProxyCall* call, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
JsonNode* tweet_utils_load_threaded_finish (GAsyncResult* _res_, GError** error);
static void __lambda87_ (Block39Data* _data39_, GObject* obj, GAsyncResult* res);
static void dm_manager_on_dm_result (DMManager* self, JsonNode* root);
static void _vala_JsonNode_free (JsonNode* self);
void collect_emit (Collect* self, GError* _error_);
static void ___lambda87__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void __lambda91_ (Block39Data* _data39_, GObject* obj, GAsyncResult* res);
static void ___lambda91__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
void sql_database_begin_transaction (SqlDatabase* self);
static void ___lambda88_ (DMManager* self, JsonArray* arr, guint pos, JsonNode* node);
static void dm_manager_save_message (DMManager* self, JsonObject* dm_obj, gboolean initial);
static void dm_manager_update_thread (DMManager* self, JsonObject* dm_obj, gboolean initial);
static void ____lambda88__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
void sql_database_end_transaction (SqlDatabase* self);
void dm_manager_insert_message (DMManager* self, JsonObject* dm_obj);
static Block40Data* block40_data_ref (Block40Data* _data40_);
static void _vala_CbTextEntity_array_free (CbTextEntity* array, gint array_length);
static void block40_data_unref (void * _userdata_);
static void __lambda90_ (Block40Data* _data40_, JsonArray* arr, guint index, JsonNode* node);
static void ___lambda90__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
GType sql_insert_statement_get_type (void) G_GNUC_CONST;
SqlInsertStatement* sql_database_insert (SqlDatabase* self, const gchar* table_name);
SqlInsertStatement* sql_insert_statement_vali64 (SqlInsertStatement* self, const gchar* col_name, gint64 col_value);
SqlInsertStatement* sql_insert_statement_val (SqlInsertStatement* self, const gchar* col_name, const gchar* col_value);
gint64 sql_insert_statement_run (SqlInsertStatement* self);
void dm_threads_model_update_last_message (DMThreadsModel* self, gint64 sender_id, gint64 message_id, const gchar* message_text);
GType sql_update_statement_get_type (void) G_GNUC_CONST;
SqlUpdateStatement* sql_database_update (SqlDatabase* self, const gchar* table_name);
SqlUpdateStatement* sql_update_statement_val (SqlUpdateStatement* self, const gchar* col_name, const gchar* col_value);
SqlUpdateStatement* sql_update_statement_vali64 (SqlUpdateStatement* self, const gchar* col_name, gint64 col_value);
SqlUpdateStatement* sql_update_statement_where_eqi (SqlUpdateStatement* self, const gchar* col, gint64 iv);
gint64 sql_update_statement_run (SqlUpdateStatement* self);
static Block41Data* block41_data_ref (Block41Data* _data41_);
static void block41_data_unref (void * _userdata_);
static void ___lambda89_ (Block41Data* _data41_, JsonArray* arr, guint index, JsonNode* node);
static void ____lambda89__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
GDateTime* utils_parse_date (const gchar* input);
void dm_threads_model_increase_unread_count (DMThreadsModel* self, gint64 user_id, gint amount);
DMManager* dm_manager_new (void);
DMManager* dm_manager_construct (GType object_type);
gboolean dm_manager_get_empty (DMManager* self);
static void g_cclosure_user_marshal_VOID__OBJECT_STRING_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void dm_manager_finalize (GObject* obj);
static void _vala_dm_manager_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


DMManager* dm_manager_construct_for_account (GType object_type, Account* account) {
	DMManager * self = NULL;
	Account* _tmp0_ = NULL;
	DMThreadsModel* _tmp1_ = NULL;
	g_return_val_if_fail (IS_ACCOUNT (account), NULL);
	self = (DMManager*) g_object_new (object_type, NULL);
	_tmp0_ = account;
	self->priv->account = _tmp0_;
	_tmp1_ = dm_threads_model_new ();
	_g_object_unref0 (self->priv->threads_model);
	self->priv->threads_model = _tmp1_;
	return self;
}


DMManager* dm_manager_new_for_account (Account* account) {
	return dm_manager_construct_for_account (TYPE_DM_MANAGER, account);
}


static gint64 int64_parse (const gchar* str) {
	gint64 result = 0LL;
	const gchar* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	g_return_val_if_fail (str != NULL, 0LL);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtoll (_tmp0_, NULL, (guint) 0);
	result = _tmp1_;
	return result;
}


static gboolean __lambda85_ (DMManager* self, gchar** vals, int vals_length1) {
	gboolean result = FALSE;
	DMThread* thread = NULL;
	DMThread* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	const gchar* _tmp2_ = NULL;
	gint64 _tmp3_ = 0LL;
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	const gchar* _tmp11_ = NULL;
	gint64 _tmp12_ = 0LL;
	gchar** _tmp13_ = NULL;
	gint _tmp13__length1 = 0;
	const gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	DMThreadsModel* _tmp16_ = NULL;
	_tmp0_ = dm_thread_new ();
	thread = _tmp0_;
	_tmp1_ = vals;
	_tmp1__length1 = vals_length1;
	_tmp2_ = _tmp1_[0];
	_tmp3_ = int64_parse (_tmp2_);
	thread->user.id = _tmp3_;
	_tmp4_ = vals;
	_tmp4__length1 = vals_length1;
	_tmp5_ = _tmp4_[1];
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (thread->user.screen_name);
	thread->user.screen_name = _tmp6_;
	_tmp7_ = vals;
	_tmp7__length1 = vals_length1;
	_tmp8_ = _tmp7_[2];
	_tmp9_ = g_strdup (_tmp8_);
	_g_free0 (thread->user.user_name);
	thread->user.user_name = _tmp9_;
	_tmp10_ = vals;
	_tmp10__length1 = vals_length1;
	_tmp11_ = _tmp10_[4];
	_tmp12_ = int64_parse (_tmp11_);
	thread->last_message_id = _tmp12_;
	_tmp13_ = vals;
	_tmp13__length1 = vals_length1;
	_tmp14_ = _tmp13_[3];
	_tmp15_ = g_strdup (_tmp14_);
	_g_free0 (thread->last_message);
	thread->last_message = _tmp15_;
	_tmp16_ = self->priv->threads_model;
	dm_threads_model_add (_tmp16_, thread);
	result = TRUE;
	_g_object_unref0 (thread);
	return result;
}


static gboolean ___lambda85__sql_select_callback (gchar** vals, int vals_length1, gpointer self) {
	gboolean result;
	result = __lambda85_ ((DMManager*) self, vals, vals_length1);
	return result;
}


void dm_manager_load_cached_threads (DMManager* self) {
	Account* _tmp0_ = NULL;
	SqlDatabase* _tmp1_ = NULL;
	SqlSelectStatement* _tmp2_ = NULL;
	SqlSelectStatement* _tmp3_ = NULL;
	SqlSelectStatement* _tmp4_ = NULL;
	SqlSelectStatement* _tmp5_ = NULL;
	SqlSelectStatement* _tmp6_ = NULL;
	SqlSelectStatement* _tmp7_ = NULL;
	g_return_if_fail (IS_DM_MANAGER (self));
	_tmp0_ = self->priv->account;
	_tmp1_ = _tmp0_->db;
	_tmp2_ = sql_database_select (_tmp1_, "dm_threads");
	_tmp3_ = _tmp2_;
	_tmp4_ = sql_select_statement_cols (_tmp3_, "user_id", "screen_name", "name", "last_message", "last_message_id", NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = sql_select_statement_order (_tmp5_, "last_message_id");
	_tmp7_ = _tmp6_;
	sql_select_statement_run (_tmp7_, ___lambda85__sql_select_callback, self);
	_g_object_unref0 (_tmp7_);
	_g_object_unref0 (_tmp5_);
	_g_object_unref0 (_tmp3_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


GListModel* dm_manager_get_threads_model (DMManager* self) {
	GListModel* result = NULL;
	DMThreadsModel* _tmp0_ = NULL;
	GListModel* _tmp1_ = NULL;
	g_return_val_if_fail (IS_DM_MANAGER (self), NULL);
	_tmp0_ = self->priv->threads_model;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_list_model_get_type (), GListModel));
	result = _tmp1_;
	return result;
}


gboolean dm_manager_has_thread (DMManager* self, gint64 user_id) {
	gboolean result = FALSE;
	DMThreadsModel* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (IS_DM_MANAGER (self), FALSE);
	_tmp0_ = self->priv->threads_model;
	_tmp1_ = user_id;
	_tmp2_ = dm_threads_model_has_thread (_tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


gint dm_manager_reset_unread_count (DMManager* self, gint64 user_id) {
	gint result = 0;
	DMThreadsModel* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	gboolean _tmp2_ = FALSE;
	gint prev_count = 0;
	DMThreadsModel* _tmp6_ = NULL;
	gint64 _tmp7_ = 0LL;
	gint _tmp8_ = 0;
	DMThreadsModel* _tmp9_ = NULL;
	gint64 _tmp10_ = 0LL;
	DMThread* _tmp11_ = NULL;
	DMThread* _tmp12_ = NULL;
	g_return_val_if_fail (IS_DM_MANAGER (self), 0);
	_tmp0_ = self->priv->threads_model;
	_tmp1_ = user_id;
	_tmp2_ = dm_threads_model_has_thread (_tmp0_, _tmp1_);
	if (!_tmp2_) {
		gint64 _tmp3_ = 0LL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		_tmp3_ = user_id;
		_tmp4_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp3_);
		_tmp5_ = _tmp4_;
		g_debug ("DMManager.vala:63: No thread found for user id %s", _tmp5_);
		_g_free0 (_tmp5_);
		result = 0;
		return result;
	}
	_tmp6_ = self->priv->threads_model;
	_tmp7_ = user_id;
	_tmp8_ = dm_threads_model_reset_unread_count (_tmp6_, _tmp7_);
	prev_count = _tmp8_;
	_tmp9_ = self->priv->threads_model;
	_tmp10_ = user_id;
	_tmp11_ = dm_threads_model_get_thread (_tmp9_, _tmp10_);
	_tmp12_ = _tmp11_;
	g_signal_emit_by_name (self, "thread-changed", _tmp12_);
	_g_object_unref0 (_tmp12_);
	result = prev_count;
	return result;
}


gchar* dm_manager_reset_notification_id (DMManager* self, gint64 user_id) {
	gchar* result = NULL;
	DMThreadsModel* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	gboolean _tmp2_ = FALSE;
	DMThreadsModel* _tmp6_ = NULL;
	gint64 _tmp7_ = 0LL;
	gchar* _tmp8_ = NULL;
	g_return_val_if_fail (IS_DM_MANAGER (self), NULL);
	_tmp0_ = self->priv->threads_model;
	_tmp1_ = user_id;
	_tmp2_ = dm_threads_model_has_thread (_tmp0_, _tmp1_);
	if (!_tmp2_) {
		gint64 _tmp3_ = 0LL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		_tmp3_ = user_id;
		_tmp4_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp3_);
		_tmp5_ = _tmp4_;
		g_debug ("DMManager.vala:76: No thread found for user id %s", _tmp5_);
		_g_free0 (_tmp5_);
		result = NULL;
		return result;
	}
	_tmp6_ = self->priv->threads_model;
	_tmp7_ = user_id;
	_tmp8_ = dm_threads_model_reset_notification_id (_tmp6_, _tmp7_);
	result = _tmp8_;
	return result;
}


static void dm_manager_load_newest_dms_data_free (gpointer _data) {
	DmManagerLoadNewestDmsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DmManagerLoadNewestDmsData, _data_);
}


void dm_manager_load_newest_dms (DMManager* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DmManagerLoadNewestDmsData* _data_;
	DMManager* _tmp0_ = NULL;
	_data_ = g_slice_new0 (DmManagerLoadNewestDmsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, dm_manager_load_newest_dms);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, dm_manager_load_newest_dms_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	dm_manager_load_newest_dms_co (_data_);
}


void dm_manager_load_newest_dms_finish (DMManager* self, GAsyncResult* _res_) {
	DmManagerLoadNewestDmsData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static Block39Data* block39_data_ref (Block39Data* _data39_) {
	g_atomic_int_inc (&_data39_->_ref_count_);
	return _data39_;
}


static void block39_data_unref (void * _userdata_) {
	Block39Data* _data39_;
	_data39_ = (Block39Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data39_->_ref_count_)) {
		DMManager* self;
		self = _data39_->self;
		_g_object_unref0 (_data39_->collect_obj);
		_g_object_unref0 (self);
		g_slice_free (Block39Data, _data39_);
	}
}


static void __lambda86_ (Block39Data* _data39_) {
	DMManager* self;
	self = _data39_->self;
	dm_manager_load_newest_dms_co (_data39_->_async_data_);
}


static void ___lambda86__collect_finished (Collect* _sender, GError* _error_, gpointer self) {
	__lambda86_ (self);
}


static void _vala_JsonNode_free (JsonNode* self) {
	g_boxed_free (json_node_get_type (), self);
}


static void __lambda87_ (Block39Data* _data39_, GObject* obj, GAsyncResult* res) {
	DMManager* self;
	GError * _inner_error_ = NULL;
	self = _data39_->self;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		JsonNode* root = NULL;
		GAsyncResult* _tmp0_ = NULL;
		JsonNode* _tmp1_ = NULL;
		_tmp0_ = res;
		_tmp1_ = tweet_utils_load_threaded_finish (_tmp0_, &_inner_error_);
		root = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch42_g_error;
		}
		dm_manager_on_dm_result (self, root);
		__vala_JsonNode_free0 (root);
	}
	goto __finally42;
	__catch42_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("DMManager.vala:109: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally42:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	collect_emit (_data39_->collect_obj, NULL);
}


static void ___lambda87__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda87_ (self, source_object, res);
	block39_data_unref (self);
}


static void __lambda91_ (Block39Data* _data39_, GObject* obj, GAsyncResult* res) {
	DMManager* self;
	GError * _inner_error_ = NULL;
	self = _data39_->self;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		JsonNode* root = NULL;
		GAsyncResult* _tmp0_ = NULL;
		JsonNode* _tmp1_ = NULL;
		_tmp0_ = res;
		_tmp1_ = tweet_utils_load_threaded_finish (_tmp0_, &_inner_error_);
		root = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch43_g_error;
		}
		dm_manager_on_dm_result (self, root);
		__vala_JsonNode_free0 (root);
	}
	goto __finally43;
	__catch43_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("DMManager.vala:126: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally43:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	collect_emit (_data39_->collect_obj, NULL);
}


static void ___lambda91__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda91_ (self, source_object, res);
	block39_data_unref (self);
}


static gboolean dm_manager_load_newest_dms_co (DmManagerLoadNewestDmsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data39_ = g_slice_new0 (Block39Data);
	_data_->_data39_->_ref_count_ = 1;
	_data_->_data39_->self = g_object_ref (_data_->self);
	_data_->_data39_->_async_data_ = _data_;
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = collect_new (2);
	_data_->_data39_->collect_obj = _data_->_tmp0_;
	g_signal_connect_data (_data_->_data39_->collect_obj, "finished", (GCallback) ___lambda86__collect_finished, block39_data_ref (_data_->_data39_), (GClosureNotify) block39_data_unref, 0);
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->self->priv->account;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->_tmp1_->db;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = sql_database_select (_data_->_tmp2_, "dms");
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = sql_select_statement_cols (_data_->_tmp4_, "id", NULL);
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _data_->self->priv->account;
	_data_->_tmp8_ = 0LL;
	_data_->_tmp8_ = _data_->_tmp7_->id;
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = sql_select_statement_where_eqi (_data_->_tmp6_, "to_id", _data_->_tmp8_);
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = _data_->_tmp9_;
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = sql_select_statement_order (_data_->_tmp10_, "id DESC");
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = _data_->_tmp11_;
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = sql_select_statement_limit (_data_->_tmp12_, 1);
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = _data_->_tmp13_;
	_data_->_tmp15_ = 0LL;
	_data_->_tmp15_ = sql_select_statement_once_i64 (_data_->_tmp14_);
	_data_->_tmp16_ = 0LL;
	_data_->_tmp16_ = _data_->_tmp15_;
	_g_object_unref0 (_data_->_tmp14_);
	_g_object_unref0 (_data_->_tmp12_);
	_g_object_unref0 (_data_->_tmp10_);
	_g_object_unref0 (_data_->_tmp6_);
	_g_object_unref0 (_data_->_tmp4_);
	_data_->max_received_id = _data_->_tmp16_;
	_data_->_tmp17_ = NULL;
	_data_->_tmp17_ = _data_->self->priv->account;
	_data_->_tmp18_ = NULL;
	_data_->_tmp18_ = _data_->_tmp17_->db;
	_data_->_tmp19_ = NULL;
	_data_->_tmp19_ = sql_database_select (_data_->_tmp18_, "dms");
	_data_->_tmp20_ = NULL;
	_data_->_tmp20_ = _data_->_tmp19_;
	_data_->_tmp21_ = NULL;
	_data_->_tmp21_ = sql_select_statement_cols (_data_->_tmp20_, "id", NULL);
	_data_->_tmp22_ = NULL;
	_data_->_tmp22_ = _data_->_tmp21_;
	_data_->_tmp23_ = NULL;
	_data_->_tmp23_ = _data_->self->priv->account;
	_data_->_tmp24_ = 0LL;
	_data_->_tmp24_ = _data_->_tmp23_->id;
	_data_->_tmp25_ = NULL;
	_data_->_tmp25_ = sql_select_statement_where_eqi (_data_->_tmp22_, "from_id", _data_->_tmp24_);
	_data_->_tmp26_ = NULL;
	_data_->_tmp26_ = _data_->_tmp25_;
	_data_->_tmp27_ = NULL;
	_data_->_tmp27_ = sql_select_statement_order (_data_->_tmp26_, "id DESC");
	_data_->_tmp28_ = NULL;
	_data_->_tmp28_ = _data_->_tmp27_;
	_data_->_tmp29_ = NULL;
	_data_->_tmp29_ = sql_select_statement_limit (_data_->_tmp28_, 1);
	_data_->_tmp30_ = NULL;
	_data_->_tmp30_ = _data_->_tmp29_;
	_data_->_tmp31_ = 0LL;
	_data_->_tmp31_ = sql_select_statement_once_i64 (_data_->_tmp30_);
	_data_->_tmp32_ = 0LL;
	_data_->_tmp32_ = _data_->_tmp31_;
	_g_object_unref0 (_data_->_tmp30_);
	_g_object_unref0 (_data_->_tmp28_);
	_g_object_unref0 (_data_->_tmp26_);
	_g_object_unref0 (_data_->_tmp22_);
	_g_object_unref0 (_data_->_tmp20_);
	_data_->max_sent_id = _data_->_tmp32_;
	_data_->_tmp33_ = NULL;
	_data_->_tmp33_ = _data_->self->priv->account;
	_data_->_tmp34_ = NULL;
	_data_->_tmp34_ = _data_->_tmp33_->proxy;
	_data_->_tmp35_ = NULL;
	_data_->_tmp35_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp34_, rest_proxy_get_type (), RestProxy));
	_data_->call = _data_->_tmp35_;
	rest_proxy_call_set_function (_data_->call, "1.1/direct_messages.json");
	rest_proxy_call_set_method (_data_->call, "GET");
	rest_proxy_call_add_param (_data_->call, "skip_status", "true");
	_data_->_tmp36_ = NULL;
	_data_->_tmp36_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->max_received_id);
	_data_->_tmp37_ = NULL;
	_data_->_tmp37_ = _data_->_tmp36_;
	rest_proxy_call_add_param (_data_->call, "since_id", _data_->_tmp37_);
	_g_free0 (_data_->_tmp37_);
	rest_proxy_call_add_param (_data_->call, "count", "200");
	rest_proxy_call_add_param (_data_->call, "full_text", "true");
	tweet_utils_load_threaded (_data_->call, NULL, ___lambda87__gasync_ready_callback, block39_data_ref (_data_->_data39_));
	_data_->_tmp38_ = NULL;
	_data_->_tmp38_ = _data_->self->priv->account;
	_data_->_tmp39_ = NULL;
	_data_->_tmp39_ = _data_->_tmp38_->proxy;
	_data_->_tmp40_ = NULL;
	_data_->_tmp40_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp39_, rest_proxy_get_type (), RestProxy));
	_data_->sent_call = _data_->_tmp40_;
	rest_proxy_call_set_function (_data_->sent_call, "1.1/direct_messages/sent.json");
	rest_proxy_call_add_param (_data_->sent_call, "skip_status", "true");
	_data_->_tmp41_ = NULL;
	_data_->_tmp41_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->max_sent_id);
	_data_->_tmp42_ = NULL;
	_data_->_tmp42_ = _data_->_tmp41_;
	rest_proxy_call_add_param (_data_->sent_call, "since_id", _data_->_tmp42_);
	_g_free0 (_data_->_tmp42_);
	rest_proxy_call_add_param (_data_->sent_call, "count", "200");
	rest_proxy_call_add_param (_data_->sent_call, "full_text", "true");
	rest_proxy_call_set_method (_data_->sent_call, "GET");
	tweet_utils_load_threaded (_data_->sent_call, NULL, ___lambda91__gasync_ready_callback, block39_data_ref (_data_->_data39_));
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_g_object_unref0 (_data_->sent_call);
	_g_object_unref0 (_data_->call);
	block39_data_unref (_data_->_data39_);
	_data_->_data39_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gpointer _json_array_ref0 (gpointer self) {
	return self ? json_array_ref (self) : NULL;
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


static void ___lambda88_ (DMManager* self, JsonArray* arr, guint pos, JsonNode* node) {
	JsonObject* dm_obj = NULL;
	JsonNode* _tmp0_ = NULL;
	JsonObject* _tmp1_ = NULL;
	JsonObject* _tmp2_ = NULL;
	JsonObject* _tmp3_ = NULL;
	gint64 _tmp4_ = 0LL;
	Account* _tmp5_ = NULL;
	gint64 _tmp6_ = 0LL;
	g_return_if_fail (arr != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node;
	_tmp1_ = json_node_get_object (_tmp0_);
	_tmp2_ = _json_object_ref0 (_tmp1_);
	dm_obj = _tmp2_;
	_tmp3_ = dm_obj;
	_tmp4_ = json_object_get_int_member (_tmp3_, "sender_id");
	_tmp5_ = self->priv->account;
	_tmp6_ = _tmp5_->id;
	if (_tmp4_ == _tmp6_) {
		JsonObject* _tmp7_ = NULL;
		_tmp7_ = dm_obj;
		dm_manager_save_message (self, _tmp7_, TRUE);
	} else {
		JsonObject* _tmp8_ = NULL;
		_tmp8_ = dm_obj;
		dm_manager_update_thread (self, _tmp8_, TRUE);
	}
	_json_object_unref0 (dm_obj);
}


static void ____lambda88__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	___lambda88_ ((DMManager*) self, array, index_, element_node);
}


static void dm_manager_on_dm_result (DMManager* self, JsonNode* root) {
	JsonArray* root_arr = NULL;
	JsonNode* _tmp0_ = NULL;
	JsonArray* _tmp1_ = NULL;
	JsonArray* _tmp2_ = NULL;
	JsonArray* _tmp3_ = NULL;
	guint _tmp4_ = 0U;
	JsonArray* _tmp5_ = NULL;
	guint _tmp6_ = 0U;
	g_return_if_fail (IS_DM_MANAGER (self));
	_tmp0_ = root;
	_tmp1_ = json_node_get_array (_tmp0_);
	_tmp2_ = _json_array_ref0 (_tmp1_);
	root_arr = _tmp2_;
	_tmp3_ = root_arr;
	_tmp4_ = json_array_get_length (_tmp3_);
	g_debug ("DMManager.vala:136: sent: %u", _tmp4_);
	_tmp5_ = root_arr;
	_tmp6_ = json_array_get_length (_tmp5_);
	if (_tmp6_ > ((guint) 0)) {
		Account* _tmp7_ = NULL;
		SqlDatabase* _tmp8_ = NULL;
		JsonArray* _tmp9_ = NULL;
		Account* _tmp10_ = NULL;
		SqlDatabase* _tmp11_ = NULL;
		_tmp7_ = self->priv->account;
		_tmp8_ = _tmp7_->db;
		sql_database_begin_transaction (_tmp8_);
		_tmp9_ = root_arr;
		json_array_foreach_element (_tmp9_, ____lambda88__json_array_foreach, self);
		_tmp10_ = self->priv->account;
		_tmp11_ = _tmp10_->db;
		sql_database_end_transaction (_tmp11_);
	}
	_json_array_unref0 (root_arr);
}


void dm_manager_insert_message (DMManager* self, JsonObject* dm_obj) {
	JsonObject* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	Account* _tmp2_ = NULL;
	gint64 _tmp3_ = 0LL;
	g_return_if_fail (IS_DM_MANAGER (self));
	g_return_if_fail (dm_obj != NULL);
	_tmp0_ = dm_obj;
	_tmp1_ = json_object_get_int_member (_tmp0_, "sender_id");
	_tmp2_ = self->priv->account;
	_tmp3_ = _tmp2_->id;
	if (_tmp1_ == _tmp3_) {
		JsonObject* _tmp4_ = NULL;
		_tmp4_ = dm_obj;
		dm_manager_save_message (self, _tmp4_, FALSE);
	} else {
		JsonObject* _tmp5_ = NULL;
		_tmp5_ = dm_obj;
		dm_manager_update_thread (self, _tmp5_, FALSE);
	}
}


static Block40Data* block40_data_ref (Block40Data* _data40_) {
	g_atomic_int_inc (&_data40_->_ref_count_);
	return _data40_;
}


static void _vala_CbTextEntity_array_free (CbTextEntity* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			cb_text_entity_free (&array[i]);
		}
	}
	g_free (array);
}


static void block40_data_unref (void * _userdata_) {
	Block40Data* _data40_;
	_data40_ = (Block40Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data40_->_ref_count_)) {
		DMManager* self;
		self = _data40_->self;
		_data40_->url_list = (_vala_CbTextEntity_array_free (_data40_->url_list, _data40_->url_list_length1), NULL);
		_g_object_unref0 (self);
		g_slice_free (Block40Data, _data40_);
	}
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch44_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = regex;
		_tmp7_ = replacement;
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) -1, 0, _tmp7_, 0, &_inner_error_);
		_tmp5_ = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch44_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp9_ = _tmp5_;
		_tmp5_ = NULL;
		result = _tmp9_;
		_g_free0 (_tmp5_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally44;
	__catch44_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally44:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void __lambda90_ (Block40Data* _data40_, JsonArray* arr, guint index, JsonNode* node) {
	DMManager* self;
	JsonObject* url = NULL;
	JsonNode* _tmp0_ = NULL;
	JsonObject* _tmp1_ = NULL;
	JsonObject* _tmp2_ = NULL;
	gchar* expanded_url = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	JsonArray* indices = NULL;
	JsonArray* _tmp5_ = NULL;
	JsonArray* _tmp6_ = NULL;
	CbTextEntity* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	guint _tmp8_ = 0U;
	gint64 _tmp9_ = 0LL;
	gint64 _tmp10_ = 0LL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	CbTextEntity _tmp15_ = {0};
	CbTextEntity _tmp16_ = {0};
	self = _data40_->self;
	g_return_if_fail (arr != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node;
	_tmp1_ = json_node_get_object (_tmp0_);
	_tmp2_ = _json_object_ref0 (_tmp1_);
	url = _tmp2_;
	_tmp3_ = json_object_get_string_member (url, "expanded_url");
	_tmp4_ = g_strdup (_tmp3_);
	expanded_url = _tmp4_;
	_tmp5_ = json_object_get_array_member (url, "indices");
	_tmp6_ = _json_array_ref0 (_tmp5_);
	indices = _tmp6_;
	_tmp7_ = _data40_->url_list;
	_tmp7__length1 = _data40_->url_list_length1;
	_tmp8_ = index;
	_tmp9_ = json_array_get_int_element (indices, (guint) 0);
	_tmp10_ = json_array_get_int_element (indices, (guint) 1);
	_tmp11_ = json_object_get_string_member (url, "display_url");
	_tmp12_ = g_strdup (_tmp11_);
	_tmp13_ = string_replace (expanded_url, "&", "&amp;");
	_tmp14_ = g_strdup (expanded_url);
	memset (&_tmp15_, 0, sizeof (CbTextEntity));
	_tmp15_.from = (guint) _tmp9_;
	_tmp15_.to = (guint) _tmp10_;
	_g_free0 (_tmp15_.display_text);
	_tmp15_.display_text = _tmp12_;
	_g_free0 (_tmp15_.target);
	_tmp15_.target = _tmp13_;
	_g_free0 (_tmp15_.tooltip_text);
	_tmp15_.tooltip_text = _tmp14_;
	cb_text_entity_free (&_tmp7_[_tmp8_]);
	_tmp7_[_tmp8_] = _tmp15_;
	_tmp16_ = _tmp7_[_tmp8_];
	_json_array_unref0 (indices);
	_g_free0 (expanded_url);
	_json_object_unref0 (url);
}


static void ___lambda90__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	__lambda90_ (self, array, index_, element_node);
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static void dm_manager_update_thread (DMManager* self, JsonObject* dm_obj, gboolean initial) {
	Block40Data* _data40_;
	gint64 sender_id = 0LL;
	JsonObject* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	gint64 message_id = 0LL;
	JsonObject* _tmp2_ = NULL;
	gint64 _tmp3_ = 0LL;
	gint64 _tmp4_ = 0LL;
	Account* _tmp5_ = NULL;
	gint64 _tmp6_ = 0LL;
	gchar* source_text = NULL;
	JsonObject* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	JsonArray* urls = NULL;
	JsonObject* _tmp10_ = NULL;
	JsonObject* _tmp11_ = NULL;
	JsonArray* _tmp12_ = NULL;
	JsonArray* _tmp13_ = NULL;
	JsonArray* _tmp14_ = NULL;
	guint _tmp15_ = 0U;
	CbTextEntity* _tmp16_ = NULL;
	JsonArray* _tmp17_ = NULL;
	gchar* text = NULL;
	const gchar* _tmp18_ = NULL;
	CbTextEntity* _tmp19_ = NULL;
	gint _tmp19__length1 = 0;
	gchar* _tmp20_ = NULL;
	gchar* sender_screen_name = NULL;
	JsonObject* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	gchar* sender_name = NULL;
	JsonObject* _tmp24_ = NULL;
	JsonObject* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	gchar* _tmp30_ = NULL;
	DMThreadsModel* _tmp31_ = NULL;
	gint64 _tmp32_ = 0LL;
	gboolean _tmp33_ = FALSE;
	Account* _tmp93_ = NULL;
	CbUserCounter* _tmp94_ = NULL;
	gint64 _tmp95_ = 0LL;
	const gchar* _tmp96_ = NULL;
	const gchar* _tmp97_ = NULL;
	JsonObject* _tmp98_ = NULL;
	gboolean _tmp99_ = FALSE;
	g_return_if_fail (IS_DM_MANAGER (self));
	g_return_if_fail (dm_obj != NULL);
	_data40_ = g_slice_new0 (Block40Data);
	_data40_->_ref_count_ = 1;
	_data40_->self = g_object_ref (self);
	_tmp0_ = dm_obj;
	_tmp1_ = json_object_get_int_member (_tmp0_, "sender_id");
	sender_id = _tmp1_;
	_tmp2_ = dm_obj;
	_tmp3_ = json_object_get_int_member (_tmp2_, "id");
	message_id = _tmp3_;
	_tmp4_ = sender_id;
	_tmp5_ = self->priv->account;
	_tmp6_ = _tmp5_->id;
	_vala_assert (_tmp4_ != _tmp6_, "sender_id != account.id");
	_tmp7_ = dm_obj;
	_tmp8_ = json_object_get_string_member (_tmp7_, "text");
	_tmp9_ = g_strdup (_tmp8_);
	source_text = _tmp9_;
	_tmp10_ = dm_obj;
	_tmp11_ = json_object_get_object_member (_tmp10_, "entities");
	_tmp12_ = json_object_get_array_member (_tmp11_, "urls");
	_tmp13_ = _json_array_ref0 (_tmp12_);
	urls = _tmp13_;
	_tmp14_ = urls;
	_tmp15_ = json_array_get_length (_tmp14_);
	_tmp16_ = g_new0 (CbTextEntity, _tmp15_);
	_data40_->url_list = _tmp16_;
	_data40_->url_list_length1 = _tmp15_;
	_data40_->_url_list_size_ = _data40_->url_list_length1;
	_tmp17_ = urls;
	json_array_foreach_element (_tmp17_, ___lambda90__json_array_foreach, _data40_);
	_tmp18_ = source_text;
	_tmp19_ = _data40_->url_list;
	_tmp19__length1 = _data40_->url_list_length1;
	_tmp20_ = cb_text_transform_text (_tmp18_, _tmp19_, _tmp19__length1, (guint) CB_TEXT_TRANSFORM_EXPAND_LINKS, (gsize) 0, (gint64) 0);
	text = _tmp20_;
	_tmp21_ = dm_obj;
	_tmp22_ = json_object_get_string_member (_tmp21_, "sender_screen_name");
	_tmp23_ = g_strdup (_tmp22_);
	sender_screen_name = _tmp23_;
	_tmp24_ = dm_obj;
	_tmp25_ = json_object_get_object_member (_tmp24_, "sender");
	_tmp26_ = json_object_get_string_member (_tmp25_, "name");
	_tmp27_ = string_strip (_tmp26_);
	_tmp28_ = _tmp27_;
	_tmp29_ = string_replace (_tmp28_, "&", "&amp;");
	_tmp30_ = _tmp29_;
	_g_free0 (_tmp28_);
	sender_name = _tmp30_;
	_tmp31_ = self->priv->threads_model;
	_tmp32_ = sender_id;
	_tmp33_ = dm_threads_model_has_thread (_tmp31_, _tmp32_);
	if (!_tmp33_) {
		DMThread* thread = NULL;
		DMThread* _tmp34_ = NULL;
		DMThread* _tmp35_ = NULL;
		gint64 _tmp36_ = 0LL;
		DMThread* _tmp37_ = NULL;
		const gchar* _tmp38_ = NULL;
		gchar* _tmp39_ = NULL;
		DMThread* _tmp40_ = NULL;
		const gchar* _tmp41_ = NULL;
		gchar* _tmp42_ = NULL;
		DMThread* _tmp43_ = NULL;
		const gchar* _tmp44_ = NULL;
		gchar* _tmp45_ = NULL;
		DMThread* _tmp46_ = NULL;
		gint64 _tmp47_ = 0LL;
		DMThreadsModel* _tmp48_ = NULL;
		DMThread* _tmp49_ = NULL;
		Account* _tmp50_ = NULL;
		SqlDatabase* _tmp51_ = NULL;
		SqlInsertStatement* _tmp52_ = NULL;
		SqlInsertStatement* _tmp53_ = NULL;
		gint64 _tmp54_ = 0LL;
		SqlInsertStatement* _tmp55_ = NULL;
		SqlInsertStatement* _tmp56_ = NULL;
		const gchar* _tmp57_ = NULL;
		SqlInsertStatement* _tmp58_ = NULL;
		SqlInsertStatement* _tmp59_ = NULL;
		const gchar* _tmp60_ = NULL;
		SqlInsertStatement* _tmp61_ = NULL;
		SqlInsertStatement* _tmp62_ = NULL;
		const gchar* _tmp63_ = NULL;
		SqlInsertStatement* _tmp64_ = NULL;
		SqlInsertStatement* _tmp65_ = NULL;
		gint64 _tmp66_ = 0LL;
		SqlInsertStatement* _tmp67_ = NULL;
		SqlInsertStatement* _tmp68_ = NULL;
		_tmp34_ = dm_thread_new ();
		thread = _tmp34_;
		_tmp35_ = thread;
		_tmp36_ = sender_id;
		_tmp35_->user.id = _tmp36_;
		_tmp37_ = thread;
		_tmp38_ = sender_screen_name;
		_tmp39_ = g_strdup (_tmp38_);
		_g_free0 (_tmp37_->user.screen_name);
		_tmp37_->user.screen_name = _tmp39_;
		_tmp40_ = thread;
		_tmp41_ = sender_name;
		_tmp42_ = g_strdup (_tmp41_);
		_g_free0 (_tmp40_->user.user_name);
		_tmp40_->user.user_name = _tmp42_;
		_tmp43_ = thread;
		_tmp44_ = text;
		_tmp45_ = g_strdup (_tmp44_);
		_g_free0 (_tmp43_->last_message);
		_tmp43_->last_message = _tmp45_;
		_tmp46_ = thread;
		_tmp47_ = message_id;
		_tmp46_->last_message_id = _tmp47_;
		_tmp48_ = self->priv->threads_model;
		_tmp49_ = thread;
		dm_threads_model_add (_tmp48_, _tmp49_);
		_tmp50_ = self->priv->account;
		_tmp51_ = _tmp50_->db;
		_tmp52_ = sql_database_insert (_tmp51_, "dm_threads");
		_tmp53_ = _tmp52_;
		_tmp54_ = sender_id;
		_tmp55_ = sql_insert_statement_vali64 (_tmp53_, "user_id", _tmp54_);
		_tmp56_ = _tmp55_;
		_tmp57_ = sender_screen_name;
		_tmp58_ = sql_insert_statement_val (_tmp56_, "screen_name", _tmp57_);
		_tmp59_ = _tmp58_;
		_tmp60_ = sender_name;
		_tmp61_ = sql_insert_statement_val (_tmp59_, "name", _tmp60_);
		_tmp62_ = _tmp61_;
		_tmp63_ = text;
		_tmp64_ = sql_insert_statement_val (_tmp62_, "last_message", _tmp63_);
		_tmp65_ = _tmp64_;
		_tmp66_ = message_id;
		_tmp67_ = sql_insert_statement_vali64 (_tmp65_, "last_message_id", _tmp66_);
		_tmp68_ = _tmp67_;
		sql_insert_statement_run (_tmp68_);
		_g_object_unref0 (_tmp68_);
		_g_object_unref0 (_tmp65_);
		_g_object_unref0 (_tmp62_);
		_g_object_unref0 (_tmp59_);
		_g_object_unref0 (_tmp56_);
		_g_object_unref0 (_tmp53_);
		_g_object_unref0 (thread);
	} else {
		DMThread* thread = NULL;
		DMThreadsModel* _tmp69_ = NULL;
		gint64 _tmp70_ = 0LL;
		DMThread* _tmp71_ = NULL;
		gint64 _tmp72_ = 0LL;
		DMThread* _tmp73_ = NULL;
		gint64 _tmp74_ = 0LL;
		_tmp69_ = self->priv->threads_model;
		_tmp70_ = sender_id;
		_tmp71_ = dm_threads_model_get_thread (_tmp69_, _tmp70_);
		thread = _tmp71_;
		_tmp72_ = message_id;
		_tmp73_ = thread;
		_tmp74_ = _tmp73_->last_message_id;
		if (_tmp72_ > _tmp74_) {
			DMThreadsModel* _tmp75_ = NULL;
			gint64 _tmp76_ = 0LL;
			gint64 _tmp77_ = 0LL;
			const gchar* _tmp78_ = NULL;
			Account* _tmp79_ = NULL;
			SqlDatabase* _tmp80_ = NULL;
			SqlUpdateStatement* _tmp81_ = NULL;
			SqlUpdateStatement* _tmp82_ = NULL;
			const gchar* _tmp83_ = NULL;
			SqlUpdateStatement* _tmp84_ = NULL;
			SqlUpdateStatement* _tmp85_ = NULL;
			gint64 _tmp86_ = 0LL;
			SqlUpdateStatement* _tmp87_ = NULL;
			SqlUpdateStatement* _tmp88_ = NULL;
			gint64 _tmp89_ = 0LL;
			SqlUpdateStatement* _tmp90_ = NULL;
			SqlUpdateStatement* _tmp91_ = NULL;
			DMThread* _tmp92_ = NULL;
			_tmp75_ = self->priv->threads_model;
			_tmp76_ = sender_id;
			_tmp77_ = message_id;
			_tmp78_ = text;
			dm_threads_model_update_last_message (_tmp75_, _tmp76_, _tmp77_, _tmp78_);
			_tmp79_ = self->priv->account;
			_tmp80_ = _tmp79_->db;
			_tmp81_ = sql_database_update (_tmp80_, "dm_threads");
			_tmp82_ = _tmp81_;
			_tmp83_ = text;
			_tmp84_ = sql_update_statement_val (_tmp82_, "last_message", _tmp83_);
			_tmp85_ = _tmp84_;
			_tmp86_ = message_id;
			_tmp87_ = sql_update_statement_vali64 (_tmp85_, "last_message_id", _tmp86_);
			_tmp88_ = _tmp87_;
			_tmp89_ = sender_id;
			_tmp90_ = sql_update_statement_where_eqi (_tmp88_, "user_id", _tmp89_);
			_tmp91_ = _tmp90_;
			sql_update_statement_run (_tmp91_);
			_g_object_unref0 (_tmp91_);
			_g_object_unref0 (_tmp88_);
			_g_object_unref0 (_tmp85_);
			_g_object_unref0 (_tmp82_);
			_tmp92_ = thread;
			g_signal_emit_by_name (self, "thread-changed", _tmp92_);
		}
		_g_object_unref0 (thread);
	}
	_tmp93_ = self->priv->account;
	_tmp94_ = _tmp93_->user_counter;
	_tmp95_ = sender_id;
	_tmp96_ = sender_screen_name;
	_tmp97_ = sender_name;
	cb_user_counter_user_seen (_tmp94_, _tmp95_, _tmp96_, _tmp97_);
	_tmp98_ = dm_obj;
	_tmp99_ = initial;
	dm_manager_save_message (self, _tmp98_, _tmp99_);
	_g_free0 (sender_name);
	_g_free0 (sender_screen_name);
	_g_free0 (text);
	_json_array_unref0 (urls);
	_g_free0 (source_text);
	block40_data_unref (_data40_);
	_data40_ = NULL;
}


static Block41Data* block41_data_ref (Block41Data* _data41_) {
	g_atomic_int_inc (&_data41_->_ref_count_);
	return _data41_;
}


static void block41_data_unref (void * _userdata_) {
	Block41Data* _data41_;
	_data41_ = (Block41Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data41_->_ref_count_)) {
		DMManager* self;
		self = _data41_->self;
		_data41_->url_list = (_vala_CbTextEntity_array_free (_data41_->url_list, _data41_->url_list_length1), NULL);
		_g_object_unref0 (self);
		g_slice_free (Block41Data, _data41_);
	}
}


static void ___lambda89_ (Block41Data* _data41_, JsonArray* arr, guint index, JsonNode* node) {
	DMManager* self;
	JsonObject* url = NULL;
	JsonNode* _tmp0_ = NULL;
	JsonObject* _tmp1_ = NULL;
	JsonObject* _tmp2_ = NULL;
	gchar* expanded_url = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	JsonArray* indices = NULL;
	JsonArray* _tmp5_ = NULL;
	JsonArray* _tmp6_ = NULL;
	CbTextEntity* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	guint _tmp8_ = 0U;
	gint64 _tmp9_ = 0LL;
	gint64 _tmp10_ = 0LL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	CbTextEntity _tmp15_ = {0};
	CbTextEntity _tmp16_ = {0};
	self = _data41_->self;
	g_return_if_fail (arr != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node;
	_tmp1_ = json_node_get_object (_tmp0_);
	_tmp2_ = _json_object_ref0 (_tmp1_);
	url = _tmp2_;
	_tmp3_ = json_object_get_string_member (url, "expanded_url");
	_tmp4_ = g_strdup (_tmp3_);
	expanded_url = _tmp4_;
	_tmp5_ = json_object_get_array_member (url, "indices");
	_tmp6_ = _json_array_ref0 (_tmp5_);
	indices = _tmp6_;
	_tmp7_ = _data41_->url_list;
	_tmp7__length1 = _data41_->url_list_length1;
	_tmp8_ = index;
	_tmp9_ = json_array_get_int_element (indices, (guint) 0);
	_tmp10_ = json_array_get_int_element (indices, (guint) 1);
	_tmp11_ = string_replace (expanded_url, "&", "&amp;");
	_tmp12_ = g_strdup (expanded_url);
	_tmp13_ = json_object_get_string_member (url, "display_url");
	_tmp14_ = g_strdup (_tmp13_);
	memset (&_tmp15_, 0, sizeof (CbTextEntity));
	_tmp15_.from = (guint) _tmp9_;
	_tmp15_.to = (guint) _tmp10_;
	_g_free0 (_tmp15_.target);
	_tmp15_.target = _tmp11_;
	_g_free0 (_tmp15_.tooltip_text);
	_tmp15_.tooltip_text = _tmp12_;
	_g_free0 (_tmp15_.display_text);
	_tmp15_.display_text = _tmp14_;
	cb_text_entity_free (&_tmp7_[_tmp8_]);
	_tmp7_[_tmp8_] = _tmp15_;
	_tmp16_ = _tmp7_[_tmp8_];
	_json_array_unref0 (indices);
	_g_free0 (expanded_url);
	_json_object_unref0 (url);
}


static void ____lambda89__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	___lambda89_ (self, array, index_, element_node);
}


static void dm_manager_save_message (DMManager* self, JsonObject* dm_obj, gboolean initial) {
	JsonObject* sender = NULL;
	JsonObject* _tmp0_ = NULL;
	JsonObject* _tmp1_ = NULL;
	JsonObject* _tmp2_ = NULL;
	JsonObject* recipient = NULL;
	JsonObject* _tmp3_ = NULL;
	JsonObject* _tmp4_ = NULL;
	JsonObject* _tmp5_ = NULL;
	gint64 sender_id = 0LL;
	JsonObject* _tmp6_ = NULL;
	gint64 _tmp7_ = 0LL;
	gint64 dm_id = 0LL;
	JsonObject* _tmp8_ = NULL;
	gint64 _tmp9_ = 0LL;
	gchar* text = NULL;
	JsonObject* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	JsonObject* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	Account* _tmp26_ = NULL;
	SqlDatabase* _tmp27_ = NULL;
	SqlInsertStatement* _tmp28_ = NULL;
	SqlInsertStatement* _tmp29_ = NULL;
	gint64 _tmp30_ = 0LL;
	SqlInsertStatement* _tmp31_ = NULL;
	SqlInsertStatement* _tmp32_ = NULL;
	gint64 _tmp33_ = 0LL;
	SqlInsertStatement* _tmp34_ = NULL;
	SqlInsertStatement* _tmp35_ = NULL;
	JsonObject* _tmp36_ = NULL;
	gint64 _tmp37_ = 0LL;
	SqlInsertStatement* _tmp38_ = NULL;
	SqlInsertStatement* _tmp39_ = NULL;
	JsonObject* _tmp40_ = NULL;
	const gchar* _tmp41_ = NULL;
	SqlInsertStatement* _tmp42_ = NULL;
	SqlInsertStatement* _tmp43_ = NULL;
	JsonObject* _tmp44_ = NULL;
	const gchar* _tmp45_ = NULL;
	SqlInsertStatement* _tmp46_ = NULL;
	SqlInsertStatement* _tmp47_ = NULL;
	JsonObject* _tmp48_ = NULL;
	const gchar* _tmp49_ = NULL;
	SqlInsertStatement* _tmp50_ = NULL;
	SqlInsertStatement* _tmp51_ = NULL;
	JsonObject* _tmp52_ = NULL;
	const gchar* _tmp53_ = NULL;
	SqlInsertStatement* _tmp54_ = NULL;
	SqlInsertStatement* _tmp55_ = NULL;
	JsonObject* _tmp56_ = NULL;
	const gchar* _tmp57_ = NULL;
	GDateTime* _tmp58_ = NULL;
	GDateTime* _tmp59_ = NULL;
	gint64 _tmp60_ = 0LL;
	SqlInsertStatement* _tmp61_ = NULL;
	SqlInsertStatement* _tmp62_ = NULL;
	const gchar* _tmp63_ = NULL;
	SqlInsertStatement* _tmp64_ = NULL;
	SqlInsertStatement* _tmp65_ = NULL;
	gboolean _tmp66_ = FALSE;
	gint64 _tmp67_ = 0LL;
	Account* _tmp68_ = NULL;
	gint64 _tmp69_ = 0LL;
	g_return_if_fail (IS_DM_MANAGER (self));
	g_return_if_fail (dm_obj != NULL);
	_tmp0_ = dm_obj;
	_tmp1_ = json_object_get_object_member (_tmp0_, "sender");
	_tmp2_ = _json_object_ref0 (_tmp1_);
	sender = _tmp2_;
	_tmp3_ = dm_obj;
	_tmp4_ = json_object_get_object_member (_tmp3_, "recipient");
	_tmp5_ = _json_object_ref0 (_tmp4_);
	recipient = _tmp5_;
	_tmp6_ = dm_obj;
	_tmp7_ = json_object_get_int_member (_tmp6_, "sender_id");
	sender_id = _tmp7_;
	_tmp8_ = dm_obj;
	_tmp9_ = json_object_get_int_member (_tmp8_, "id");
	dm_id = _tmp9_;
	_tmp10_ = dm_obj;
	_tmp11_ = json_object_get_string_member (_tmp10_, "text");
	_tmp12_ = g_strdup (_tmp11_);
	text = _tmp12_;
	_tmp13_ = dm_obj;
	_tmp14_ = json_object_has_member (_tmp13_, "entities");
	if (_tmp14_) {
		Block41Data* _data41_;
		JsonArray* urls = NULL;
		JsonObject* _tmp15_ = NULL;
		JsonObject* _tmp16_ = NULL;
		JsonArray* _tmp17_ = NULL;
		JsonArray* _tmp18_ = NULL;
		JsonArray* _tmp19_ = NULL;
		guint _tmp20_ = 0U;
		CbTextEntity* _tmp21_ = NULL;
		JsonArray* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		CbTextEntity* _tmp24_ = NULL;
		gint _tmp24__length1 = 0;
		gchar* _tmp25_ = NULL;
		_data41_ = g_slice_new0 (Block41Data);
		_data41_->_ref_count_ = 1;
		_data41_->self = g_object_ref (self);
		_tmp15_ = dm_obj;
		_tmp16_ = json_object_get_object_member (_tmp15_, "entities");
		_tmp17_ = json_object_get_array_member (_tmp16_, "urls");
		_tmp18_ = _json_array_ref0 (_tmp17_);
		urls = _tmp18_;
		_tmp19_ = urls;
		_tmp20_ = json_array_get_length (_tmp19_);
		_tmp21_ = g_new0 (CbTextEntity, _tmp20_);
		_data41_->url_list = _tmp21_;
		_data41_->url_list_length1 = _tmp20_;
		_data41_->_url_list_size_ = _data41_->url_list_length1;
		_tmp22_ = urls;
		json_array_foreach_element (_tmp22_, ____lambda89__json_array_foreach, _data41_);
		_tmp23_ = text;
		_tmp24_ = _data41_->url_list;
		_tmp24__length1 = _data41_->url_list_length1;
		_tmp25_ = cb_text_transform_text (_tmp23_, _tmp24_, _tmp24__length1, (guint) 0, (gsize) 0, (gint64) 0);
		_g_free0 (text);
		text = _tmp25_;
		_json_array_unref0 (urls);
		block41_data_unref (_data41_);
		_data41_ = NULL;
	}
	_tmp26_ = self->priv->account;
	_tmp27_ = _tmp26_->db;
	_tmp28_ = sql_database_insert (_tmp27_, "dms");
	_tmp29_ = _tmp28_;
	_tmp30_ = dm_id;
	_tmp31_ = sql_insert_statement_vali64 (_tmp29_, "id", _tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = sender_id;
	_tmp34_ = sql_insert_statement_vali64 (_tmp32_, "from_id", _tmp33_);
	_tmp35_ = _tmp34_;
	_tmp36_ = dm_obj;
	_tmp37_ = json_object_get_int_member (_tmp36_, "recipient_id");
	_tmp38_ = sql_insert_statement_vali64 (_tmp35_, "to_id", _tmp37_);
	_tmp39_ = _tmp38_;
	_tmp40_ = dm_obj;
	_tmp41_ = json_object_get_string_member (_tmp40_, "sender_screen_name");
	_tmp42_ = sql_insert_statement_val (_tmp39_, "from_screen_name", _tmp41_);
	_tmp43_ = _tmp42_;
	_tmp44_ = dm_obj;
	_tmp45_ = json_object_get_string_member (_tmp44_, "recipient_screen_name");
	_tmp46_ = sql_insert_statement_val (_tmp43_, "to_screen_name", _tmp45_);
	_tmp47_ = _tmp46_;
	_tmp48_ = sender;
	_tmp49_ = json_object_get_string_member (_tmp48_, "name");
	_tmp50_ = sql_insert_statement_val (_tmp47_, "from_name", _tmp49_);
	_tmp51_ = _tmp50_;
	_tmp52_ = recipient;
	_tmp53_ = json_object_get_string_member (_tmp52_, "name");
	_tmp54_ = sql_insert_statement_val (_tmp51_, "to_name", _tmp53_);
	_tmp55_ = _tmp54_;
	_tmp56_ = dm_obj;
	_tmp57_ = json_object_get_string_member (_tmp56_, "created_at");
	_tmp58_ = utils_parse_date (_tmp57_);
	_tmp59_ = _tmp58_;
	_tmp60_ = g_date_time_to_unix (_tmp59_);
	_tmp61_ = sql_insert_statement_vali64 (_tmp55_, "timestamp", _tmp60_);
	_tmp62_ = _tmp61_;
	_tmp63_ = text;
	_tmp64_ = sql_insert_statement_val (_tmp62_, "text", _tmp63_);
	_tmp65_ = _tmp64_;
	sql_insert_statement_run (_tmp65_);
	_g_object_unref0 (_tmp65_);
	_g_object_unref0 (_tmp62_);
	_g_date_time_unref0 (_tmp59_);
	_g_object_unref0 (_tmp55_);
	_g_object_unref0 (_tmp51_);
	_g_object_unref0 (_tmp47_);
	_g_object_unref0 (_tmp43_);
	_g_object_unref0 (_tmp39_);
	_g_object_unref0 (_tmp35_);
	_g_object_unref0 (_tmp32_);
	_g_object_unref0 (_tmp29_);
	_tmp67_ = sender_id;
	_tmp68_ = self->priv->account;
	_tmp69_ = _tmp68_->id;
	if (_tmp67_ != _tmp69_) {
		DMThreadsModel* _tmp70_ = NULL;
		gint64 _tmp71_ = 0LL;
		gboolean _tmp72_ = FALSE;
		_tmp70_ = self->priv->threads_model;
		_tmp71_ = sender_id;
		_tmp72_ = dm_threads_model_has_thread (_tmp70_, _tmp71_);
		_tmp66_ = _tmp72_;
	} else {
		_tmp66_ = FALSE;
	}
	if (_tmp66_) {
		DMThread* thread = NULL;
		DMThreadsModel* _tmp73_ = NULL;
		gint64 _tmp74_ = 0LL;
		DMThread* _tmp75_ = NULL;
		DMThreadsModel* _tmp76_ = NULL;
		gint64 _tmp77_ = 0LL;
		DMThread* _tmp78_ = NULL;
		const gchar* _tmp79_ = NULL;
		gboolean _tmp80_ = FALSE;
		DMThread* _tmp81_ = NULL;
		_tmp73_ = self->priv->threads_model;
		_tmp74_ = sender_id;
		_tmp75_ = dm_threads_model_get_thread (_tmp73_, _tmp74_);
		thread = _tmp75_;
		_tmp76_ = self->priv->threads_model;
		_tmp77_ = sender_id;
		dm_threads_model_increase_unread_count (_tmp76_, _tmp77_, 1);
		_tmp78_ = thread;
		_tmp79_ = text;
		_tmp80_ = initial;
		g_signal_emit_by_name (self, "message-received", _tmp78_, _tmp79_, _tmp80_);
		_tmp81_ = thread;
		g_signal_emit_by_name (self, "thread-changed", _tmp81_);
		_g_object_unref0 (thread);
	}
	_g_free0 (text);
	_json_object_unref0 (recipient);
	_json_object_unref0 (sender);
}


DMManager* dm_manager_construct (GType object_type) {
	DMManager * self = NULL;
	self = (DMManager*) g_object_new (object_type, NULL);
	return self;
}


DMManager* dm_manager_new (void) {
	return dm_manager_construct (TYPE_DM_MANAGER);
}


gboolean dm_manager_get_empty (DMManager* self) {
	gboolean result;
	DMThreadsModel* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	g_return_val_if_fail (IS_DM_MANAGER (self), FALSE);
	_tmp0_ = self->priv->threads_model;
	_tmp1_ = g_list_model_get_n_items (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_list_model_get_type (), GListModel));
	result = _tmp1_ == ((guint) 0);
	return result;
}


static void g_cclosure_user_marshal_VOID__OBJECT_STRING_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_STRING_BOOLEAN) (gpointer data1, gpointer arg_1, const char* arg_2, gboolean arg_3, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_STRING_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_STRING_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_string (param_values + 2), g_value_get_boolean (param_values + 3), data2);
}


static void dm_manager_class_init (DMManagerClass * klass) {
	dm_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DMManagerPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_dm_manager_get_property;
	G_OBJECT_CLASS (klass)->finalize = dm_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DM_MANAGER_EMPTY, g_param_spec_boolean ("empty", "empty", "empty", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("message_received", TYPE_DM_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_STRING_BOOLEAN, G_TYPE_NONE, 3, TYPE_DM_THREAD, G_TYPE_STRING, G_TYPE_BOOLEAN);
	g_signal_new ("thread_changed", TYPE_DM_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_DM_THREAD);
}


static void dm_manager_instance_init (DMManager * self) {
	self->priv = DM_MANAGER_GET_PRIVATE (self);
}


static void dm_manager_finalize (GObject* obj) {
	DMManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DM_MANAGER, DMManager);
	_g_object_unref0 (self->priv->threads_model);
	G_OBJECT_CLASS (dm_manager_parent_class)->finalize (obj);
}


GType dm_manager_get_type (void) {
	static volatile gsize dm_manager_type_id__volatile = 0;
	if (g_once_init_enter (&dm_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DMManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dm_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DMManager), 0, (GInstanceInitFunc) dm_manager_instance_init, NULL };
		GType dm_manager_type_id;
		dm_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "DMManager", &g_define_type_info, 0);
		g_once_init_leave (&dm_manager_type_id__volatile, dm_manager_type_id);
	}
	return dm_manager_type_id__volatile;
}


static void _vala_dm_manager_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DMManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DM_MANAGER, DMManager);
	switch (property_id) {
		case DM_MANAGER_EMPTY:
		g_value_set_boolean (value, dm_manager_get_empty (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



