; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx1010 -verify-machineinstrs < %s | FileCheck %s

define half @known_nnan_extract_vector_elt(float %a, float %b, i32 %idx, half %c) {
; CHECK-LABEL: known_nnan_extract_vector_elt:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CHECK-NEXT:    v_cvt_pkrtz_f16_f32_e32 v0, v0, v1
; CHECK-NEXT:    v_lshlrev_b32_e32 v1, 4, v2
; CHECK-NEXT:    v_add_f16_e32 v2, 1.0, v3
; CHECK-NEXT:    v_lshrrev_b32_e32 v0, v1, v0
; CHECK-NEXT:    v_cmp_lt_f16_e32 vcc_lo, v0, v2
; CHECK-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc_lo
; CHECK-NEXT:    s_setpc_b64 s[30:31]
  %cvt = call nnan <2 x half> @llvm.amdgcn.cvt.pkrtz(float %a, float %b)
  %extract = extractelement <2 x half> %cvt, i32 %idx
  %canon = call half @llvm.canonicalize.f16(half %extract)
  %nnan.c = fadd nnan nsz half %c, 1.0
  %cmp = fcmp olt half %extract, %nnan.c
  %select = select i1 %cmp, half %extract, half %nnan.c
  ret half %select
}

; should not emit v_max
define float @fma_not_fmaxnm_maybe_nan(i32 %i1, i32 %i2, i32 %i3) #0 {
; CHECK-LABEL: fma_not_fmaxnm_maybe_nan:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CHECK-NEXT:    v_cvt_f32_u32_e32 v0, v0
; CHECK-NEXT:    v_cvt_f32_u32_e32 v1, v1
; CHECK-NEXT:    v_fmaak_f32 v0, v1, v0, 0xff800000
; CHECK-NEXT:    v_cmp_nge_f32_e32 vcc_lo, 0xff800000, v0
; CHECK-NEXT:    v_cndmask_b32_e32 v0, 0xff800000, v0, vcc_lo
; CHECK-NEXT:    s_setpc_b64 s[30:31]
  %f1 = uitofp i32 %i1 to float
  %f2 = uitofp i32 %i2 to float
  %f3 = uitofp i32 %i2 to float
  %fma = tail call float @llvm.fma.f32(float %f2, float %f1, float 0xfff0000000000000)
  %cmp = fcmp ugt float %fma, 0xfff0000000000000
  %val = select i1 %cmp, float %fma, float 0xfff0000000000000
  ret float %val
}

declare float @llvm.fma.f32(float, float, float) nounwind readnone
declare float @llvm.amdgcn.fmad.ftz.f32(float, float, float)

declare <2 x half> @llvm.amdgcn.cvt.pkrtz(float, float)
declare half @llvm.canonicalize.f16(half)

attributes #0 = { nounwind "no-signed-zeros-fp-math"="true" "target-features"="+mad-mac-f32-insts" }
