'''OpenGL extension ARB.invalidate_subdata

This module customises the behaviour of the 
OpenGL.raw.GL.ARB.invalidate_subdata to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension adds a mechanism for an application to tell the GL that
	the previous contents of a subregion of an image or a range of a buffer 
	may be invalidated.
	
	GL implementations often include several memory spaces, each with 
	distinct performance characteristics, and the implementations 
	transparently move allocations between memory spaces. With this 
	extension, an application can tell the GL that the contents of a texture
	or buffer are no longer needed, and the implementation can avoid 
	transferring the data unnecessarily.
	
	Examples of when this may be useful include:
	
	(1) invalidating a multisample texture after resolving it into a non-
	    multisample texture.
	
	(2) invalidating depth/stencil buffers after using them to generate a color
	    buffer.
	
	(3) invalidating a subregion of a framebuffer rather than clearing it 
	    before rendering to it, when the whole subregion will be overwritten.
	
	(4) invalidating dynamically generated data (e.g. textures written by FBO 
	    rendering or CopyTexSubImage, buffers written by transform feedback,
	    etc.) after it is no longer needed but before the end of the frame.
	
	It is expected that the situations in which the GL will take advantage of
	this knowledge and achieve increased performance as a result of its use
	will be implementation-dependent. The first three examples may show 
	benefit on tiled renderers where some data won't need to be copied into 
	or out of on-chip memory. The fourth example may show a benefit in multi-
	GPU systems where some data won't need to be copied between GPUs.
	
	This extension is a superset of the EXT_discard_framebuffer extension 
	with the following additions:
	
	  - The parameters to InvalidateFramebufferEXT are extended for MRT support
	    and Desktop-GL-only buffer enums.
	
	  - New functions to invalidate a region of a texture image or buffer object
	    data store.
	

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/ARB/invalidate_subdata.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.ARB.invalidate_subdata import *
from OpenGL.raw.GL.ARB.invalidate_subdata import _EXTENSION_NAME

def glInitInvalidateSubdataARB():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

# INPUT glInvalidateFramebuffer.attachments size not checked against numAttachments
glInvalidateFramebuffer=wrapper.wrapper(glInvalidateFramebuffer).setInputArraySize(
    'attachments', None
)
# INPUT glInvalidateSubFramebuffer.attachments size not checked against numAttachments
glInvalidateSubFramebuffer=wrapper.wrapper(glInvalidateSubFramebuffer).setInputArraySize(
    'attachments', None
)
### END AUTOGENERATED SECTION