#!/usr/bin/perl

#from: http://burtleburtle.net/bob/hash/evahash.html#newhash

#note: we don't need a cryptographically strong hash function, and this is
#around 

use Inline C => "
// Inline C can't deal with typedefs, register, long int, etc...
// most changes are to deal with that. this only works on 32 bit machines...

// typedef  unsigned long int  u4;   /* unsigned 4-byte type */
// typedef  unsigned     char  u1;   /* unsigned 1-byte type */

// The mixing step
#define mix(a,b,c) { a=a-b;  a=a-c;  a=a^(c>>13); b=b-c;  b=b-a;  b=b^(a<<8); c=c-a;  c=c-b;  c=c^(b>>13); a=a-b;  a=a-c;  a=a^(c>>12); b=b-c;  b=b-a;  b=b^(a<<16); c=c-a;  c=c-b;  c=c^(b>>5); a=a-b;  a=a-c;  a=a^(c>>3); b=b-c;  b=b-a;  b=b^(a<<10); c=c-a;  c=c-b;  c=c^(b>>15); }

//char *k;       /* the key */
//long length;   /* the length of the key in bytes */
//long initval;  /* the previous hash, or an arbitrary value */
long newhash( char *k, long length, long initval) {
	long a,b,c;  /* the internal state */
	long len;    /* how many key bytes still need mixing */

	// Set up the internal state
	len = length;
	a = b = 0x9e3779b9;  /* the golden ratio; an arbitrary value */
	c = initval;         /* variable initialization of internal state */

	// handle most of the key
	while (len >= 12) {
		a=a+(k[0]+((long)k[1]<<8)+((long)k[2]<<16) +((long)k[3]<<24));
		b=b+(k[4]+((long)k[5]<<8)+((long)k[6]<<16) +((long)k[7]<<24));
		c=c+(k[8]+((long)k[9]<<8)+((long)k[10]<<16)+((long)k[11]<<24));
		mix(a,b,c);
		k = k+12; len = len-12;
	}

	// handle the last 11 bytes
	c = c+length;
	switch(len) { // note: all the case statements fall through
		case 11: c=c+((long)k[10]<<24);
		case 10: c=c+((long)k[9]<<16);
		case 9 : c=c+((long)k[8]<<8);
		// note: the first byte of c is reserved for the length
		case 8 : b=b+((long)k[7]<<24);
		case 7 : b=b+((long)k[6]<<16);
		case 6 : b=b+((long)k[5]<<8);
		case 5 : b=b+k[4];
		case 4 : a=a+((long)k[3]<<24);
		case 3 : a=a+((long)k[2]<<16);
		case 2 : a=a+((long)k[1]<<8);
		case 1 : a=a+k[0];
		// case 0: nothing left to add
	}
	mix(a,b,c);

	// return the result
	return c;
}
";

open(FH, "../foobar");
my $key = join('', <FH>);
close(FH);

#use Digest::MD5 qw(md5 md5_hex md5_base64);
#my $digest;
#for my $i (0..99) {
#	my $ctx = Digest::MD5->new;
#	$ctx->add($key);
#	$digest = $ctx->digest;
#}
#print "$digest\n";

print newhash($key, length($key), 0), "\n";
for my $i (0..99) {
	newhash($key, length($key), 0), "\n";
}

