# Generated by default/object.tt
package Paws::SecurityHub::AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails;
  use Moose;
  has Capabilities => (is => 'ro', isa => 'Paws::SecurityHub::AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails');
  has Devices => (is => 'ro', isa => 'ArrayRef[Paws::SecurityHub::AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails]');
  has InitProcessEnabled => (is => 'ro', isa => 'Bool');
  has MaxSwap => (is => 'ro', isa => 'Int');
  has SharedMemorySize => (is => 'ro', isa => 'Int');
  has Swappiness => (is => 'ro', isa => 'Int');
  has Tmpfs => (is => 'ro', isa => 'ArrayRef[Paws::SecurityHub::AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails object:

  $service_obj->Method(Att1 => { Capabilities => $value, ..., Tmpfs => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails object:

  $result = $service_obj->Method(...);
  $result->Att1->Capabilities

=head1 DESCRIPTION

E<gt>Linux-specific modifications that are applied to the container,
such as Linux kernel capabilities.

=head1 ATTRIBUTES


=head2 Capabilities => L<Paws::SecurityHub::AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersCapabilitiesDetails>

The Linux capabilities for the container that are added to or dropped
from the default configuration provided by Docker.


=head2 Devices => ArrayRef[L<Paws::SecurityHub::AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails>]

The host devices to expose to the container.


=head2 InitProcessEnabled => Bool

Whether to run an C<init> process inside the container that forwards
signals and reaps processes.


=head2 MaxSwap => Int

The total amount of swap memory (in MiB) that a container can use.


=head2 SharedMemorySize => Int

The value for the size (in MiB) of the B</dev/shm> volume.


=head2 Swappiness => Int

Configures the container's memory swappiness behavior. Determines how
aggressively pages are swapped. The higher the value, the more
aggressive the swappiness. The default is 60.


=head2 Tmpfs => ArrayRef[L<Paws::SecurityHub::AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails>]

The container path, mount options, and size (in MiB) of the tmpfs
mount.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

