/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Formatter;
import java.util.StringTokenizer;

class svm_scale {
    private String line = null;
    private double lower = -1.0;
    private double upper = 1.0;
    private double y_lower;
    private double y_upper;
    private boolean y_scaling = false;
    private double[] feature_max;
    private double[] feature_min;
    private double y_max = -1.7976931348623157E308;
    private double y_min = Double.MAX_VALUE;
    private int max_index;
    private long num_nonzeros = 0L;
    private long new_num_nonzeros = 0L;

    svm_scale() {
    }

    private static void exit_with_help() {
        System.out.print("Usage: svm-scale [options] data_filename\noptions:\n-l lower : x scaling lower limit (default -1)\n-u upper : x scaling upper limit (default +1)\n-y y_lower y_upper : y scaling limits (default: no y scaling)\n-s save_filename : save scaling parameters to save_filename\n-r restore_filename : restore scaling parameters from restore_filename\n");
        System.exit(1);
    }

    private BufferedReader rewind(BufferedReader bufferedReader, String string) throws IOException {
        bufferedReader.close();
        return new BufferedReader(new FileReader(string));
    }

    private void output_target(double d) {
        if (this.y_scaling) {
            d = d == this.y_min ? this.y_lower : (d == this.y_max ? this.y_upper : this.y_lower + (this.y_upper - this.y_lower) * (d - this.y_min) / (this.y_max - this.y_min));
        }
        System.out.print(d + " ");
    }

    private void output(int n, double d) {
        if (this.feature_max[n] == this.feature_min[n]) {
            return;
        }
        if ((d = d == this.feature_min[n] ? this.lower : (d == this.feature_max[n] ? this.upper : this.lower + (this.upper - this.lower) * (d - this.feature_min[n]) / (this.feature_max[n] - this.feature_min[n]))) != 0.0) {
            System.out.print(n + ":" + d + " ");
            ++this.new_num_nonzeros;
        }
    }

    private String readline(BufferedReader bufferedReader) throws IOException {
        this.line = bufferedReader.readLine();
        return this.line;
    }

    private void run(String[] stringArray) throws IOException {
        StringTokenizer stringTokenizer;
        int n;
        int n2;
        BufferedReader bufferedReader = null;
        BufferedReader bufferedReader2 = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        block15: for (n2 = 0; n2 < stringArray.length && stringArray[n2].charAt(0) == '-'; ++n2) {
            switch (stringArray[++n2 - 1].charAt(1)) {
                case 'l': {
                    this.lower = Double.parseDouble(stringArray[n2]);
                    continue block15;
                }
                case 'u': {
                    this.upper = Double.parseDouble(stringArray[n2]);
                    continue block15;
                }
                case 'y': {
                    this.y_lower = Double.parseDouble(stringArray[n2]);
                    this.y_upper = Double.parseDouble(stringArray[++n2]);
                    this.y_scaling = true;
                    continue block15;
                }
                case 's': {
                    string = stringArray[n2];
                    continue block15;
                }
                case 'r': {
                    string2 = stringArray[n2];
                    continue block15;
                }
                default: {
                    System.err.println("unknown option");
                    svm_scale.exit_with_help();
                }
            }
        }
        if (!(this.upper > this.lower) || this.y_scaling && !(this.y_upper > this.y_lower)) {
            System.err.println("inconsistent lower/upper specification");
            System.exit(1);
        }
        if (string2 != null && string != null) {
            System.err.println("cannot use -r and -s simultaneously");
            System.exit(1);
        }
        if (stringArray.length != n2 + 1) {
            svm_scale.exit_with_help();
        }
        string3 = stringArray[n2];
        try {
            bufferedReader = new BufferedReader(new FileReader(string3));
        }
        catch (Exception exception) {
            System.err.println("can't open file " + string3);
            System.exit(1);
        }
        this.max_index = 0;
        if (string2 != null) {
            try {
                bufferedReader2 = new BufferedReader(new FileReader(string2));
            }
            catch (Exception exception) {
                System.err.println("can't open file " + string2);
                System.exit(1);
            }
            int n3 = bufferedReader2.read();
            if (n3 == 121) {
                bufferedReader2.readLine();
                bufferedReader2.readLine();
                bufferedReader2.readLine();
            }
            bufferedReader2.readLine();
            bufferedReader2.readLine();
            String string4 = null;
            while ((string4 = bufferedReader2.readLine()) != null) {
                StringTokenizer stringTokenizer2 = new StringTokenizer(string4);
                int n4 = Integer.parseInt(stringTokenizer2.nextToken());
                this.max_index = Math.max(this.max_index, n4);
            }
            bufferedReader2 = this.rewind(bufferedReader2, string2);
        }
        while (this.readline(bufferedReader) != null) {
            StringTokenizer stringTokenizer3 = new StringTokenizer(this.line, " \t\n\r\f:");
            stringTokenizer3.nextToken();
            while (stringTokenizer3.hasMoreTokens()) {
                n = Integer.parseInt(stringTokenizer3.nextToken());
                this.max_index = Math.max(this.max_index, n);
                stringTokenizer3.nextToken();
                ++this.num_nonzeros;
            }
        }
        try {
            this.feature_max = new double[this.max_index + 1];
            this.feature_min = new double[this.max_index + 1];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.err.println("can't allocate enough memory");
            System.exit(1);
        }
        for (n2 = 0; n2 <= this.max_index; ++n2) {
            this.feature_max[n2] = -1.7976931348623157E308;
            this.feature_min[n2] = Double.MAX_VALUE;
        }
        bufferedReader = this.rewind(bufferedReader, string3);
        while (this.readline(bufferedReader) != null) {
            int n5 = 1;
            stringTokenizer = new StringTokenizer(this.line, " \t\n\r\f:");
            double d = Double.parseDouble(stringTokenizer.nextToken());
            this.y_max = Math.max(this.y_max, d);
            this.y_min = Math.min(this.y_min, d);
            while (stringTokenizer.hasMoreTokens()) {
                n = Integer.parseInt(stringTokenizer.nextToken());
                double d2 = Double.parseDouble(stringTokenizer.nextToken());
                for (n2 = n5; n2 < n; ++n2) {
                    this.feature_max[n2] = Math.max(this.feature_max[n2], 0.0);
                    this.feature_min[n2] = Math.min(this.feature_min[n2], 0.0);
                }
                this.feature_max[n] = Math.max(this.feature_max[n], d2);
                this.feature_min[n] = Math.min(this.feature_min[n], d2);
                n5 = n + 1;
            }
            for (n2 = n5; n2 <= this.max_index; ++n2) {
                this.feature_max[n2] = Math.max(this.feature_max[n2], 0.0);
                this.feature_min[n2] = Math.min(this.feature_min[n2], 0.0);
            }
        }
        bufferedReader = this.rewind(bufferedReader, string3);
        if (string2 != null) {
            StringTokenizer stringTokenizer4;
            bufferedReader2.mark(2);
            int n6 = bufferedReader2.read();
            if (n6 == 121) {
                bufferedReader2.readLine();
                stringTokenizer4 = new StringTokenizer(bufferedReader2.readLine());
                this.y_lower = Double.parseDouble(stringTokenizer4.nextToken());
                this.y_upper = Double.parseDouble(stringTokenizer4.nextToken());
                stringTokenizer4 = new StringTokenizer(bufferedReader2.readLine());
                this.y_min = Double.parseDouble(stringTokenizer4.nextToken());
                this.y_max = Double.parseDouble(stringTokenizer4.nextToken());
                this.y_scaling = true;
            } else {
                bufferedReader2.reset();
            }
            if (bufferedReader2.read() == 120) {
                bufferedReader2.readLine();
                stringTokenizer4 = new StringTokenizer(bufferedReader2.readLine());
                this.lower = Double.parseDouble(stringTokenizer4.nextToken());
                this.upper = Double.parseDouble(stringTokenizer4.nextToken());
                String string5 = null;
                while ((string5 = bufferedReader2.readLine()) != null) {
                    StringTokenizer stringTokenizer5 = new StringTokenizer(string5);
                    int n7 = Integer.parseInt(stringTokenizer5.nextToken());
                    double d = Double.parseDouble(stringTokenizer5.nextToken());
                    double d3 = Double.parseDouble(stringTokenizer5.nextToken());
                    if (n7 > this.max_index) continue;
                    this.feature_min[n7] = d;
                    this.feature_max[n7] = d3;
                }
            }
            bufferedReader2.close();
        }
        if (string != null) {
            Formatter formatter = new Formatter(new StringBuilder());
            BufferedWriter bufferedWriter = null;
            try {
                bufferedWriter = new BufferedWriter(new FileWriter(string));
            }
            catch (IOException iOException) {
                System.err.println("can't open file " + string);
                System.exit(1);
            }
            if (this.y_scaling) {
                formatter.format("y\n", new Object[0]);
                formatter.format("%.16g %.16g\n", this.y_lower, this.y_upper);
                formatter.format("%.16g %.16g\n", this.y_min, this.y_max);
            }
            formatter.format("x\n", new Object[0]);
            formatter.format("%.16g %.16g\n", this.lower, this.upper);
            for (n2 = 1; n2 <= this.max_index; ++n2) {
                if (this.feature_min[n2] == this.feature_max[n2]) continue;
                formatter.format("%d %.16g %.16g\n", n2, this.feature_min[n2], this.feature_max[n2]);
            }
            bufferedWriter.write(formatter.toString());
            bufferedWriter.close();
        }
        while (this.readline(bufferedReader) != null) {
            int n8 = 1;
            stringTokenizer = new StringTokenizer(this.line, " \t\n\r\f:");
            double d = Double.parseDouble(stringTokenizer.nextToken());
            this.output_target(d);
            while (stringTokenizer.hasMoreElements()) {
                n = Integer.parseInt(stringTokenizer.nextToken());
                double d4 = Double.parseDouble(stringTokenizer.nextToken());
                for (n2 = n8; n2 < n; ++n2) {
                    this.output(n2, 0.0);
                }
                this.output(n, d4);
                n8 = n + 1;
            }
            for (n2 = n8; n2 <= this.max_index; ++n2) {
                this.output(n2, 0.0);
            }
            System.out.print("\n");
        }
        if (this.new_num_nonzeros > this.num_nonzeros) {
            System.err.print("Warning: original #nonzeros " + this.num_nonzeros + "\n" + "         new      #nonzeros " + this.new_num_nonzeros + "\n" + "Use -l 0 if many original feature values are zeros\n");
        }
        bufferedReader.close();
    }

    public static void main(String[] stringArray) throws IOException {
        svm_scale svm_scale2 = new svm_scale();
        svm_scale2.run(stringArray);
    }
}

