use 5.008;
use Config;
use ExtUtils::MakeMaker;

my $obj_ext = $Config{obj_ext};

my %args = (
    NAME             => 'Digest::xxHash64',
    AUTHOR           => 'A. Sinan Unur <nanis@cpan.org>',
    ABSTRACT_FROM    => 'lib/Digest/xxHash64.pm',
    VERSION_FROM     => 'lib/Digest/xxHash64.pm',
    MIN_PERL_VERSION => '5.008',
    PREREQ_PM        => {},
    LICENSE          => 'mit',
    LIBS             => [''],
    DEFINE           => '',
    INC              => '-I.',
    OBJECT           => join(' ', map "$_$obj_ext", qw( xxHash64 xxhash ) ),
    OPTIMIZE         => ($Config{cc} eq 'cl' ? '-O2 -Ox' : '-O3'),
);

if ($MM_VERSION >= 6.64) {
    $args{TEST_REQUIRES} = { 'Math::Int64' => 0 },
}
else {
    $args{PREREQ_PM}{'Math::Int64'} = 0;
}

if ($MM_VERSION >= 6.52) {
    $args{CONFIGURE_REQUIRES} = { 'ExtUtils::MakeMaker' => '6.52'};
}

WriteMakefile( %args );

