/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock.control;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.couchbase.mock.CouchbaseMock;
import org.couchbase.mock.control.CommandNotFoundException;
import org.couchbase.mock.control.CommandStatus;
import org.couchbase.mock.control.MockCommand;
import org.couchbase.mock.control.handlers.CCCPCommandHandler;
import org.couchbase.mock.control.handlers.FailoverCommandHandler;
import org.couchbase.mock.control.handlers.GetMCPortsHandler;
import org.couchbase.mock.control.handlers.HiccupCommandHandler;
import org.couchbase.mock.control.handlers.KeyInfoCommandHandler;
import org.couchbase.mock.control.handlers.MockHelpCommandHandler;
import org.couchbase.mock.control.handlers.MockInfoCommandHandler;
import org.couchbase.mock.control.handlers.OpfailCommandHandler;
import org.couchbase.mock.control.handlers.PersistenceCommandHandler;
import org.couchbase.mock.control.handlers.RespawnCommandHandler;
import org.couchbase.mock.control.handlers.TimeTravelCommandHandler;
import org.couchbase.mock.control.handlers.TruncateCommandHandler;
import org.jetbrains.annotations.NotNull;

public class MockCommandDispatcher {
    public static final Map<String, Class> commandMap = new HashMap<String, Class>();
    private static final Map<MockCommand.Command, Class> classMap = new EnumMap<MockCommand.Command, Class>(MockCommand.Command.class);
    private static final Gson gs = new Gson();
    private final CouchbaseMock mock;

    private static void registerClass(MockCommand.Command cmd, Class cls) {
        if (!MockCommand.class.isAssignableFrom(cls)) {
            throw new RuntimeException("Can process only HarakiriMonitor objects");
        }
        String commandName = cmd.toString().toUpperCase();
        commandMap.put(commandName, cls);
        classMap.put(cmd, cls);
    }

    @NotNull
    public CommandStatus dispatch(String command, JsonObject payload) {
        MockCommand obj;
        MockCommand.Command cmd;
        if (!commandMap.containsKey(command = command.replaceAll(" ", "_").toUpperCase())) {
            throw new CommandNotFoundException("Unknown command: " + command);
        }
        try {
            cmd = MockCommand.Command.valueOf(command.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new CommandNotFoundException("No such command: " + command, e);
        }
        Class cls = classMap.get((Object)cmd);
        if (cls == null) {
            throw new RuntimeException("Can't find class for " + (Object)((Object)cmd));
        }
        try {
            obj = (MockCommand)cls.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return obj.execute(this.mock, cmd, payload);
    }

    public MockCommandDispatcher(CouchbaseMock mock) {
        this.mock = mock;
    }

    public CouchbaseMock getMock() {
        return this.mock;
    }

    public String processInput(String input) {
        CommandStatus status;
        JsonObject object;
        try {
            object = gs.fromJson(input, JsonObject.class);
        }
        catch (Throwable t) {
            return "{ \"status\" : \"fail\", \"error\" : \"Failed to parse input\" }";
        }
        String command = object.get("command").getAsString();
        JsonObject payload = !object.has("payload") ? new JsonObject() : object.get("payload").getAsJsonObject();
        try {
            status = this.dispatch(command, payload);
        }
        catch (CommandNotFoundException ex) {
            status = new CommandStatus();
            status.fail("No such command");
        }
        catch (Throwable t) {
            status = new CommandStatus();
            status.fail(t);
        }
        return status.toString();
    }

    static {
        MockCommandDispatcher.registerClass(MockCommand.Command.HICCUP, HiccupCommandHandler.class);
        MockCommandDispatcher.registerClass(MockCommand.Command.FAILOVER, FailoverCommandHandler.class);
        MockCommandDispatcher.registerClass(MockCommand.Command.TRUNCATE, TruncateCommandHandler.class);
        MockCommandDispatcher.registerClass(MockCommand.Command.RESPAWN, RespawnCommandHandler.class);
        MockCommandDispatcher.registerClass(MockCommand.Command.MOCKINFO, MockInfoCommandHandler.class);
        MockCommandDispatcher.registerClass(MockCommand.Command.CACHE, PersistenceCommandHandler.class);
        MockCommandDispatcher.registerClass(MockCommand.Command.UNCACHE, PersistenceCommandHandler.class);
        MockCommandDispatcher.registerClass(MockCommand.Command.PERSIST, PersistenceCommandHandler.class);
        MockCommandDispatcher.registerClass(MockCommand.Command.UNPERSIST, PersistenceCommandHandler.class);
        MockCommandDispatcher.registerClass(MockCommand.Command.ENDURE, PersistenceCommandHandler.class);
        MockCommandDispatcher.registerClass(MockCommand.Command.PURGE, PersistenceCommandHandler.class);
        MockCommandDispatcher.registerClass(MockCommand.Command.KEYINFO, KeyInfoCommandHandler.class);
        MockCommandDispatcher.registerClass(MockCommand.Command.TIME_TRAVEL, TimeTravelCommandHandler.class);
        MockCommandDispatcher.registerClass(MockCommand.Command.HELP, MockHelpCommandHandler.class);
        MockCommandDispatcher.registerClass(MockCommand.Command.OPFAIL, OpfailCommandHandler.class);
        MockCommandDispatcher.registerClass(MockCommand.Command.SET_CCCP, CCCPCommandHandler.class);
        MockCommandDispatcher.registerClass(MockCommand.Command.GET_MCPORTS, GetMCPortsHandler.class);
    }
}

