######################################################################
#
# 1031_qr1_mb.t
#
# Copyright (c) 2019 INABA Hitoshi <ina@cpan.org> in a CPAN
######################################################################

# This file is encoded in Shift_JIS.
die "This file is not encoded in Shift_JIS.\n" if '' ne "\x82\xA0";
die "This script is for jperl only. You are using $^X.\n" if $^X !~ /jperl/i;

use strict;
use FindBin;
use lib "$FindBin::Bin/../lib";
use UTF8::R2 qw(%mb);
use vars qw(@test);

BEGIN {
    $SIG{__WARN__} = sub {
        local($_) = @_;
        /\AIllegal hex digit ignored at /                      ? return :
        /\AUnrecognized escape \\h passed through at /         ? return :
        /\AUnrecognized escape \\v passed through at /         ? return :
        /\AUnrecognized escape \\R passed through at /         ? return :
        /\AUnrecognized escape \\H passed through at /         ? return :
        /\AUnrecognized escape \\V passed through at /         ? return :
        /\A\\C is deprecated in regex; marked by <-- HERE in / ? return :
        warn $_[0];
    };
}

@test = (
# 1
    sub { ("12ABC" =~ $mb{qr/./})                         },
    sub { ("12ABC" =~ $mb{qr/./})      && ($& eq '')    },
    sub { ("12ABC" =~ $mb{qr/.{2}/})   && ($& eq '')  },
    sub { ("12ABC" =~ $mb{qr/.{2}/})   && ($` eq '')      },
    sub { ("12ABC" =~ $mb{qr/.{2}/})   && ($' eq '12ABC') },
    sub { ("12ABC" =~ $mb{qr/(.{3})/}) && ($1 eq '1') },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
# 11
    sub { not ("12ABC" !~ $mb{qr/./})                         },
    sub { not ("12ABC" !~ $mb{qr/./})      && ($& eq '')    },
    sub { not ("12ABC" !~ $mb{qr/.{2}/})   && ($& eq '')  },
    sub { not ("12ABC" !~ $mb{qr/.{2}/})   && ($` eq '')      },
    sub { not ("12ABC" !~ $mb{qr/.{2}/})   && ($' eq '12ABC') },
    sub { not ("12ABC" !~ $mb{qr/(.{3})/}) && ($1 eq '1') },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
# 21
    sub { "0" =~ $mb{qr/\d/} },
    sub { "1" =~ $mb{qr/\d/} },
    sub { "2" =~ $mb{qr/\d/} },
    sub { "3" =~ $mb{qr/\d/} },
    sub { "4" =~ $mb{qr/\d/} },
    sub { "5" =~ $mb{qr/\d/} },
    sub { "6" =~ $mb{qr/\d/} },
    sub { "7" =~ $mb{qr/\d/} },
    sub { "8" =~ $mb{qr/\d/} },
    sub { "9" =~ $mb{qr/\d/} },
# 31
    sub { not ("A" =~ $mb{qr/\d/}) },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
# 41
    sub { "A" =~ $mb{qr/\w/} },
    sub { "B" =~ $mb{qr/\w/} },
    sub { "C" =~ $mb{qr/\w/} },
    sub { "D" =~ $mb{qr/\w/} },
    sub { "E" =~ $mb{qr/\w/} },
    sub { "F" =~ $mb{qr/\w/} },
    sub { "G" =~ $mb{qr/\w/} },
    sub { "H" =~ $mb{qr/\w/} },
    sub { "I" =~ $mb{qr/\w/} },
    sub { "J" =~ $mb{qr/\w/} },
# 51
    sub { "K" =~ $mb{qr/\w/} },
    sub { "L" =~ $mb{qr/\w/} },
    sub { "M" =~ $mb{qr/\w/} },
    sub { "N" =~ $mb{qr/\w/} },
    sub { "O" =~ $mb{qr/\w/} },
    sub { "P" =~ $mb{qr/\w/} },
    sub { "Q" =~ $mb{qr/\w/} },
    sub { "R" =~ $mb{qr/\w/} },
    sub { "S" =~ $mb{qr/\w/} },
    sub { "T" =~ $mb{qr/\w/} },
# 61
    sub { "U" =~ $mb{qr/\w/} },
    sub { "V" =~ $mb{qr/\w/} },
    sub { "W" =~ $mb{qr/\w/} },
    sub { "X" =~ $mb{qr/\w/} },
    sub { "Y" =~ $mb{qr/\w/} },
    sub { "Z" =~ $mb{qr/\w/} },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
# 71
    sub { "a" =~ $mb{qr/\w/} },
    sub { "b" =~ $mb{qr/\w/} },
    sub { "c" =~ $mb{qr/\w/} },
    sub { "d" =~ $mb{qr/\w/} },
    sub { "e" =~ $mb{qr/\w/} },
    sub { "f" =~ $mb{qr/\w/} },
    sub { "g" =~ $mb{qr/\w/} },
    sub { "h" =~ $mb{qr/\w/} },
    sub { "i" =~ $mb{qr/\w/} },
    sub { "j" =~ $mb{qr/\w/} },
# 81
    sub { "k" =~ $mb{qr/\w/} },
    sub { "l" =~ $mb{qr/\w/} },
    sub { "m" =~ $mb{qr/\w/} },
    sub { "n" =~ $mb{qr/\w/} },
    sub { "o" =~ $mb{qr/\w/} },
    sub { "p" =~ $mb{qr/\w/} },
    sub { "q" =~ $mb{qr/\w/} },
    sub { "r" =~ $mb{qr/\w/} },
    sub { "s" =~ $mb{qr/\w/} },
    sub { "t" =~ $mb{qr/\w/} },
# 91
    sub { "u" =~ $mb{qr/\w/} },
    sub { "v" =~ $mb{qr/\w/} },
    sub { "w" =~ $mb{qr/\w/} },
    sub { "x" =~ $mb{qr/\w/} },
    sub { "y" =~ $mb{qr/\w/} },
    sub { "z" =~ $mb{qr/\w/} },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
# 101
    sub { "0" =~ $mb{qr/\w/} },
    sub { "1" =~ $mb{qr/\w/} },
    sub { "2" =~ $mb{qr/\w/} },
    sub { "3" =~ $mb{qr/\w/} },
    sub { "4" =~ $mb{qr/\w/} },
    sub { "5" =~ $mb{qr/\w/} },
    sub { "6" =~ $mb{qr/\w/} },
    sub { "7" =~ $mb{qr/\w/} },
    sub { "8" =~ $mb{qr/\w/} },
    sub { "9" =~ $mb{qr/\w/} },
# 111
    sub { "_" =~ $mb{qr/\w/} },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
# 121
    sub { not ("" =~ $mb{qr/\w/}) },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
# 131
    sub {     ("\t"   =~ $mb{qr/\s/}) },
    sub {     ("\n"   =~ $mb{qr/\s/}) },
    sub { not ("\x0B" =~ $mb{qr/\s/}) },
    sub {     ("\f"   =~ $mb{qr/\s/}) },
    sub {     ("\r"   =~ $mb{qr/\s/}) },
    sub {     ("\x20" =~ $mb{qr/\s/}) },
    sub { not ("\x85" =~ $mb{qr/\s/}) },
    sub { not ("\xA0" =~ $mb{qr/\s/}) },
    sub {1},
    sub {1},
# 141
    sub { ($] < 5.010) or     ("\t"   =~ $mb{qr/\h/}) },
    sub { ($] < 5.010) or not ("\n"   =~ $mb{qr/\h/}) },
    sub { ($] < 5.010) or not ("\x0B" =~ $mb{qr/\h/}) },
    sub { ($] < 5.010) or not ("\f"   =~ $mb{qr/\h/}) },
    sub { ($] < 5.010) or not ("\r"   =~ $mb{qr/\h/}) },
    sub { ($] < 5.010) or     ("\x20" =~ $mb{qr/\h/}) },
    sub { ($] < 5.010) or not ("\x85" =~ $mb{qr/\h/}) },
    sub { ($] < 5.010) or not ("\xA0" =~ $mb{qr/\h/}) },
    sub {1},
    sub {1},
# 151
    sub { ($] < 5.010) or not ("\t"   =~ $mb{qr/\v/}) },
    sub { ($] < 5.010) or     ("\n"   =~ $mb{qr/\v/}) },
    sub { ($] < 5.010) or     ("\x0B" =~ $mb{qr/\v/}) },
    sub { ($] < 5.010) or     ("\f"   =~ $mb{qr/\v/}) },
    sub { ($] < 5.010) or     ("\r"   =~ $mb{qr/\v/}) },
    sub { ($] < 5.010) or not ("\x20" =~ $mb{qr/\v/}) },
    sub { ($] < 5.010) or not ("\x85" =~ $mb{qr/\v/}) },
    sub { ($] < 5.010) or not ("\xA0" =~ $mb{qr/\v/}) },
    sub {1},
    sub {1},
# 161
    sub { ($] < 5.006) or (5.022 < $]) or eval q{ not (""   =~ $mb{qr/\C/})                                           }},
    sub { ($] < 5.006) or (5.022 < $]) or eval q{     ("" =~ $mb{qr/\C/})                                           }},
    sub { ($] < 5.006) or (5.022 < $]) or eval q{     ("" =~ $mb{qr/\C/})   && ($& eq "\xE3")                       }},
    sub { ($] < 5.006) or (5.022 < $]) or eval q{     ("" =~ $mb{qr/\C/})   && ($& eq "\xE3") && ($' eq "\x81\x82") }},
    sub { ($] < 5.006) or (5.022 < $]) or eval q{     ("" =~ $mb{qr/(\C)/})                                         }},
    sub { ($] < 5.006) or (5.022 < $]) or eval q{     ("" =~ $mb{qr/(\C)/}) && ($1 eq "\xE3")                       }},
    sub { ($] < 5.006) or (5.022 < $]) or eval q{     ("" =~ $mb{qr/(\C)/}) && ($1 eq "\xE3") && ($' eq "\x81\x82") }},
    sub {1},
    sub {1},
    sub {1},
# 171
    sub { ($] < 5.012) or eval q{     ("" =~ $mb{qr/\N/})                   }},
    sub { ($] < 5.012) or eval q{     ("" =~ $mb{qr/\N/})   && ($& eq '') }},
    sub { ($] < 5.012) or eval q{     ("" =~ $mb{qr/(\N)/}) && ($1 eq '') }},
    sub { ($] < 5.012) or eval q{ not ("\n" =~ $mb{qr/\N/})                   }},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
# 181
    sub { ($] < 5.010) or not (""   =~ $mb{qr/\R/})                     },
    sub { ($] < 5.010) or     ("\r\n" =~ $mb{qr/\R/})                     },
    sub { ($] < 5.010) or     ("\r\n" =~ $mb{qr/\R/})   && ($& eq "\r\n") },
    sub { ($] < 5.010) or     ("\r\n" =~ $mb{qr/(\R)/}) && ($1 eq "\r\n") },
    sub { ($] < 5.010) or not ("\t"   =~ $mb{qr/\R/})                     },
    sub { ($] < 5.010) or     ("\n"   =~ $mb{qr/\R/})                     },
    sub { ($] < 5.010) or     ("\x0B" =~ $mb{qr/\R/})                     },
    sub { ($] < 5.010) or     ("\f"   =~ $mb{qr/\R/})                     },
    sub { ($] < 5.010) or     ("\r"   =~ $mb{qr/\R/})                     },
    sub { ($] < 5.010) or not ("\x20" =~ $mb{qr/\R/})                     },
# 191
    sub { ($] < 5.010) or not ("\x85" =~ $mb{qr/\R/})   },
    sub { ($] < 5.010) or not ("\xA0" =~ $mb{qr/\R/})   },
    sub { ($] < 5.010) or not ("\r\n" =~ $mb{qr/\R\n/}) },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
# 201
    sub { "0" !~ $mb{qr/\D/} },
    sub { "1" !~ $mb{qr/\D/} },
    sub { "2" !~ $mb{qr/\D/} },
    sub { "3" !~ $mb{qr/\D/} },
    sub { "4" !~ $mb{qr/\D/} },
    sub { "5" !~ $mb{qr/\D/} },
    sub { "6" !~ $mb{qr/\D/} },
    sub { "7" !~ $mb{qr/\D/} },
    sub { "8" !~ $mb{qr/\D/} },
    sub { "9" !~ $mb{qr/\D/} },
# 211
    sub { not ("A" !~ $mb{qr/\D/}) },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
# 221
    sub { "A" !~ $mb{qr/\W/} },
    sub { "B" !~ $mb{qr/\W/} },
    sub { "C" !~ $mb{qr/\W/} },
    sub { "D" !~ $mb{qr/\W/} },
    sub { "E" !~ $mb{qr/\W/} },
    sub { "F" !~ $mb{qr/\W/} },
    sub { "G" !~ $mb{qr/\W/} },
    sub { "H" !~ $mb{qr/\W/} },
    sub { "I" !~ $mb{qr/\W/} },
    sub { "J" !~ $mb{qr/\W/} },
# 231
    sub { "K" !~ $mb{qr/\W/} },
    sub { "L" !~ $mb{qr/\W/} },
    sub { "M" !~ $mb{qr/\W/} },
    sub { "N" !~ $mb{qr/\W/} },
    sub { "O" !~ $mb{qr/\W/} },
    sub { "P" !~ $mb{qr/\W/} },
    sub { "Q" !~ $mb{qr/\W/} },
    sub { "R" !~ $mb{qr/\W/} },
    sub { "S" !~ $mb{qr/\W/} },
    sub { "T" !~ $mb{qr/\W/} },
# 241
    sub { "U" !~ $mb{qr/\W/} },
    sub { "V" !~ $mb{qr/\W/} },
    sub { "W" !~ $mb{qr/\W/} },
    sub { "X" !~ $mb{qr/\W/} },
    sub { "Y" !~ $mb{qr/\W/} },
    sub { "Z" !~ $mb{qr/\W/} },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
# 251
    sub { "a" !~ $mb{qr/\W/} },
    sub { "b" !~ $mb{qr/\W/} },
    sub { "c" !~ $mb{qr/\W/} },
    sub { "d" !~ $mb{qr/\W/} },
    sub { "e" !~ $mb{qr/\W/} },
    sub { "f" !~ $mb{qr/\W/} },
    sub { "g" !~ $mb{qr/\W/} },
    sub { "h" !~ $mb{qr/\W/} },
    sub { "i" !~ $mb{qr/\W/} },
    sub { "j" !~ $mb{qr/\W/} },
# 261
    sub { "k" !~ $mb{qr/\W/} },
    sub { "l" !~ $mb{qr/\W/} },
    sub { "m" !~ $mb{qr/\W/} },
    sub { "n" !~ $mb{qr/\W/} },
    sub { "o" !~ $mb{qr/\W/} },
    sub { "p" !~ $mb{qr/\W/} },
    sub { "q" !~ $mb{qr/\W/} },
    sub { "r" !~ $mb{qr/\W/} },
    sub { "s" !~ $mb{qr/\W/} },
    sub { "t" !~ $mb{qr/\W/} },
# 271
    sub { "u" !~ $mb{qr/\W/} },
    sub { "v" !~ $mb{qr/\W/} },
    sub { "w" !~ $mb{qr/\W/} },
    sub { "x" !~ $mb{qr/\W/} },
    sub { "y" !~ $mb{qr/\W/} },
    sub { "z" !~ $mb{qr/\W/} },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
# 281
    sub { "0" !~ $mb{qr/\W/} },
    sub { "1" !~ $mb{qr/\W/} },
    sub { "2" !~ $mb{qr/\W/} },
    sub { "3" !~ $mb{qr/\W/} },
    sub { "4" !~ $mb{qr/\W/} },
    sub { "5" !~ $mb{qr/\W/} },
    sub { "6" !~ $mb{qr/\W/} },
    sub { "7" !~ $mb{qr/\W/} },
    sub { "8" !~ $mb{qr/\W/} },
    sub { "9" !~ $mb{qr/\W/} },
# 291
    sub { "_" !~ $mb{qr/\W/} },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
# 301
    sub { not ("" !~ $mb{qr/\W/}) },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
# 311
    sub {     ("\t"   !~ $mb{qr/\S/}) },
    sub {     ("\n"   !~ $mb{qr/\S/}) },
    sub { not ("\x0B" !~ $mb{qr/\S/}) },
    sub {     ("\f"   !~ $mb{qr/\S/}) },
    sub {     ("\r"   !~ $mb{qr/\S/}) },
    sub {     ("\x20" !~ $mb{qr/\S/}) },
    sub { not ("\x85" !~ $mb{qr/\S/}) },
    sub { not ("\xA0" !~ $mb{qr/\S/}) },
    sub {1},
    sub {1},
# 321
    sub { ($] < 5.010) or     ("\t"   !~ $mb{qr/\H/}) },
    sub { ($] < 5.010) or not ("\n"   !~ $mb{qr/\H/}) },
    sub { ($] < 5.010) or not ("\x0B" !~ $mb{qr/\H/}) },
    sub { ($] < 5.010) or not ("\f"   !~ $mb{qr/\H/}) },
    sub { ($] < 5.010) or not ("\r"   !~ $mb{qr/\H/}) },
    sub { ($] < 5.010) or     ("\x20" !~ $mb{qr/\H/}) },
    sub { ($] < 5.010) or not ("\x85" !~ $mb{qr/\H/}) },
    sub { ($] < 5.010) or not ("\xA0" !~ $mb{qr/\H/}) },
    sub {1},
    sub {1},
# 331
    sub { ($] < 5.010) or not ("\t"   !~ $mb{qr/\V/}) },
    sub { ($] < 5.010) or     ("\n"   !~ $mb{qr/\V/}) },
    sub { ($] < 5.010) or     ("\x0B" !~ $mb{qr/\V/}) },
    sub { ($] < 5.010) or     ("\f"   !~ $mb{qr/\V/}) },
    sub { ($] < 5.010) or     ("\r"   !~ $mb{qr/\V/}) },
    sub { ($] < 5.010) or not ("\x20" !~ $mb{qr/\V/}) },
    sub { ($] < 5.010) or not ("\x85" !~ $mb{qr/\V/}) },
    sub { ($] < 5.010) or not ("\xA0" !~ $mb{qr/\V/}) },
    sub {1},
    sub {1},
# 341
    sub { 1 or ("12345 2345 345" =~ $mb{qr/\b345/})                          },
    sub { 1 or ("12345 2345 345" =~ $mb{qr/\b345/}) && ($` eq "12345 2345 ") },
    sub { 1 or ("12345 1234 123" =~ $mb{qr/234\b/})                          },
    sub { 1 or ("12345 1234 123" =~ $mb{qr/234\b/}) && ($` eq "12345 1")     },
    sub { 1 or ("12345 2345 345" =~ $mb{qr/\B345/})                          },
    sub { 1 or ("12345 2345 345" =~ $mb{qr/\B345/}) && ($` eq "12")          },
    sub { 1 or ("12345 1234 123" =~ $mb{qr/234\B/})                          },
    sub { 1 or ("12345 1234 123" =~ $mb{qr/234\B/}) && ($` eq "1")           },
    sub {1},
    sub {1},
# 351
    sub { 1 or not ("PQRST@QRST@RST" =~ $mb{qr/\bRST/})                   },
    sub { 1 or not ("PQRST@PQRS@PQR" =~ $mb{qr/QRS\b/})                   },
    sub { 1 or     ("PQRST@QRST@RST" =~ $mb{qr/\BRST/})                   },
    sub { 1 or     ("PQRST@QRST@RST" =~ $mb{qr/\BRST/}) && ($` eq "PQ") },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
# 361
    sub { not "\n" =~       /./                             },
    sub {     "\n" =~       /./s                            },
    sub { not "\n" =~ $mb{qr/./}                            },
    sub {     "\n" =~ $mb{qr/./s}                           },
    sub { ($] < 5.012) or eval q{ not "\n" =~ $mb{qr/\N/}  }},
    sub { ($] < 5.012) or eval q{ not "\n" =~ $mb{qr/\N/s} }},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
# 371
    sub {      "\x00"             =~ $mb{qr/\x00/}             },
    sub {      "\x7F"             =~ $mb{qr/\x7F/}             },
    sub {      "\xC2\x80"         =~ $mb{qr/\xC2\x80/}         },
    sub {      "\xDF\xBA"         =~ $mb{qr/\xDF\xBA/}         },
    sub { 1 or "\xE0\xA0\x80"     =~ $mb{qr/\xE0\xA0\x80/}     },
    sub { 1 or "\xE0\xBF\x9A"     =~ $mb{qr/\xE0\xBF\x9A/}     },
    sub { 1 or "\xF0\x90\x80\x80" =~ $mb{qr/\xF0\x90\x80\x80/} },
    sub { 1 or "\xF0\x90\xB9\xBE" =~ $mb{qr/\xF0\x90\xB9\xBE/} },
    sub {1},
    sub {1},
# 381
    sub { ($] < 5.006) or (5.006 < $]) or eval q{ "\x00"             =~ $mb{qr/\x{00}/}     }},
    sub { ($] < 5.006) or (5.006 < $]) or eval q{ "\x7F"             =~ $mb{qr/\x{7F}/}     }},
    sub { ($] < 5.006) or (5.006 < $]) or eval q{ "\xC2\x80"         =~ $mb{qr/\x{80}/}     }},
    sub { ($] < 5.006) or (5.006 < $]) or eval q{ "\xC2\x80"         =~ $mb{qr/\x{0080}/}   }},
    sub { ($] < 5.006) or (5.006 < $]) or eval q{ "\xDF\xBA"         =~ $mb{qr/\x{7FA}/}    }},
    sub { ($] < 5.006) or (5.006 < $]) or eval q{ "\xDF\xBA"         =~ $mb{qr/\x{07FA}/}   }},
    sub { ($] < 5.006) or (5.006 < $]) or eval q{ "\xE0\xA0\x80"     =~ $mb{qr/\x{800}/}    }},
    sub { ($] < 5.006) or (5.006 < $]) or eval q{ "\xE0\xA0\x80"     =~ $mb{qr/\x{0800}/}   }},
    sub { ($] < 5.006) or (5.006 < $]) or eval q{ "\xE0\xBF\x9A"     =~ $mb{qr/\x{FDA}/}    }},
    sub { ($] < 5.006) or (5.006 < $]) or eval q{ "\xE0\xBF\x9A"     =~ $mb{qr/\x{0FDA}/}   }},
# 391
    sub { ($] < 5.006) or (5.006 < $]) or eval q{ "\xF0\x90\x80\x80" =~ $mb{qr/\x{10000}/}  }},
    sub { ($] < 5.006) or (5.006 < $]) or eval q{ "\xF0\x90\x80\x80" =~ $mb{qr/\x{010000}/} }},
    sub { ($] < 5.006) or (5.006 < $]) or eval q{ "\xF0\x90\xB9\xBE" =~ $mb{qr/\x{10E7E}/}  }},
    sub { ($] < 5.006) or (5.006 < $]) or eval q{ "\xF0\x90\xB9\xBE" =~ $mb{qr/\x{010E7E}/} }},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
# 401
    sub { ($] < 5.006) or eval q{ "\x{00}"     =~ $mb{qr/\x{00}/}     }},
    sub { ($] < 5.006) or eval q{ "\x{7F}"     =~ $mb{qr/\x{7F}/}     }},
    sub { ($] < 5.006) or eval q{ "\x{80}"     =~ $mb{qr/\x{80}/}     }},
    sub { ($] < 5.006) or eval q{ "\x{0080}"   =~ $mb{qr/\x{0080}/}   }},
    sub { ($] < 5.006) or eval q{ "\x{7FA}"    =~ $mb{qr/\x{7FA}/}    }},
    sub { ($] < 5.006) or eval q{ "\x{07FA}"   =~ $mb{qr/\x{07FA}/}   }},
    sub { ($] < 5.006) or eval q{ "\x{800}"    =~ $mb{qr/\x{800}/}    }},
    sub { ($] < 5.006) or eval q{ "\x{0800}"   =~ $mb{qr/\x{0800}/}   }},
    sub { ($] < 5.006) or eval q{ "\x{FDA}"    =~ $mb{qr/\x{FDA}/}    }},
    sub { ($] < 5.006) or eval q{ "\x{0FDA}"   =~ $mb{qr/\x{0FDA}/}   }},
# 411
    sub { ($] < 5.006) or eval q{ "\x{10000}"  =~ $mb{qr/\x{10000}/}  }},
    sub { ($] < 5.006) or eval q{ "\x{010000}" =~ $mb{qr/\x{010000}/} }},
    sub { ($] < 5.006) or eval q{ "\x{10E7E}"  =~ $mb{qr/\x{10E7E}/}  }},
    sub { ($] < 5.006) or eval q{ "\x{010E7E}" =~ $mb{qr/\x{010E7E}/} }},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
#
);

$|=1; print "1..",scalar(@test),"\n"; my $testno=1; sub ok { print $_[0]?'ok ':'not ok ',$testno++,$_[1]?" - $_[1]\n":"\n" } ok($_->()) for @test;

__END__
