# Generated by default/object.tt
package Paws::AutoScaling::CapacityForecast;
  use Moose;
  has Timestamps => (is => 'ro', isa => 'ArrayRef[Str|Undef]', required => 1);
  has Values => (is => 'ro', isa => 'ArrayRef[Num]', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AutoScaling::CapacityForecast

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AutoScaling::CapacityForecast object:

  $service_obj->Method(Att1 => { Timestamps => $value, ..., Values => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AutoScaling::CapacityForecast object:

  $result = $service_obj->Method(...);
  $result->Att1->Timestamps

=head1 DESCRIPTION

A C<GetPredictiveScalingForecast> call returns the capacity forecast
for a predictive scaling policy. This structure includes the data
points for that capacity forecast, along with the timestamps of those
data points.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Timestamps => ArrayRef[Str|Undef]

The time stamps for the data points, in UTC format.


=head2 B<REQUIRED> Values => ArrayRef[Num]

The values of the data points.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AutoScaling>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

