# Generated by default/object.tt
package Paws::CloudFront::KeyGroup;
  use Moose;
  has Id => (is => 'ro', isa => 'Str', required => 1);
  has KeyGroupConfig => (is => 'ro', isa => 'Paws::CloudFront::KeyGroupConfig', required => 1);
  has LastModifiedTime => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::CloudFront::KeyGroup

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CloudFront::KeyGroup object:

  $service_obj->Method(Att1 => { Id => $value, ..., LastModifiedTime => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CloudFront::KeyGroup object:

  $result = $service_obj->Method(...);
  $result->Att1->Id

=head1 DESCRIPTION

A key group.

A key group contains a list of public keys that you can use with
CloudFront signed URLs and signed cookies
(https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html).

=head1 ATTRIBUTES


=head2 B<REQUIRED> Id => Str

The identifier for the key group.


=head2 B<REQUIRED> KeyGroupConfig => L<Paws::CloudFront::KeyGroupConfig>

The key group configuration.


=head2 B<REQUIRED> LastModifiedTime => Str

The date and time when the key group was last modified.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CloudFront>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

