package Shipment::Purolator::WSDL::Types::PackageInformation;
$Shipment::Purolator::WSDL::Types::PackageInformation::VERSION = '3.03';
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns {'http://purolator.com/pws/datatypes/v1'}

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{    # BLOCK to scope variables

    my %ServiceID_of : ATTR(:get<ServiceID>);
    my %Description_of : ATTR(:get<Description>);
    my %TotalWeight_of : ATTR(:get<TotalWeight>);
    my %TotalPieces_of : ATTR(:get<TotalPieces>);
    my %PiecesInformation_of : ATTR(:get<PiecesInformation>);
    my %DangerousGoodsDeclarationDocumentIndicator_of :
      ATTR(:get<DangerousGoodsDeclarationDocumentIndicator>);
    my %OptionsInformation_of : ATTR(:get<OptionsInformation>);

    __PACKAGE__->_factory(
        [   qw(        ServiceID
              Description
              TotalWeight
              TotalPieces
              PiecesInformation
              DangerousGoodsDeclarationDocumentIndicator
              OptionsInformation

              )
        ],
        {   'ServiceID'         => \%ServiceID_of,
            'Description'       => \%Description_of,
            'TotalWeight'       => \%TotalWeight_of,
            'TotalPieces'       => \%TotalPieces_of,
            'PiecesInformation' => \%PiecesInformation_of,
            'DangerousGoodsDeclarationDocumentIndicator' =>
              \%DangerousGoodsDeclarationDocumentIndicator_of,
            'OptionsInformation' => \%OptionsInformation_of,
        },
        {   'ServiceID'   => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
            'Description' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
            'TotalWeight' => 'Shipment::Purolator::WSDL::Types::TotalWeight',
            'TotalPieces' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
            'PiecesInformation' =>
              'Shipment::Purolator::WSDL::Types::ArrayOfPiece',
            'DangerousGoodsDeclarationDocumentIndicator' =>
              'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
            'OptionsInformation' =>
              'Shipment::Purolator::WSDL::Types::OptionsInformation',
        },
        {

            'ServiceID'         => 'ServiceID',
            'Description'       => 'Description',
            'TotalWeight'       => 'TotalWeight',
            'TotalPieces'       => 'TotalPieces',
            'PiecesInformation' => 'PiecesInformation',
            'DangerousGoodsDeclarationDocumentIndicator' =>
              'DangerousGoodsDeclarationDocumentIndicator',
            'OptionsInformation' => 'OptionsInformation',
        }
    );

}    # end BLOCK


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Shipment::Purolator::WSDL::Types::PackageInformation

=head1 VERSION

version 3.03

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
PackageInformation from the namespace http://purolator.com/pws/datatypes/v1.

PackageInformation

=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * ServiceID (min/maxOccurs: 1/1)

=item * Description (min/maxOccurs: 0/1)

=item * TotalWeight (min/maxOccurs: 1/1)

=item * TotalPieces (min/maxOccurs: 1/1)

=item * PiecesInformation (min/maxOccurs: 0/1)

=item * DangerousGoodsDeclarationDocumentIndicator (min/maxOccurs: 0/1)

=item * OptionsInformation (min/maxOccurs: 0/1)

=back

=head1 NAME

Shipment::Purolator::WSDL::Types::PackageInformation

=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # Shipment::Purolator::WSDL::Types::PackageInformation
   ServiceID =>  $some_value, # string
   Description =>  $some_value, # string
   TotalWeight =>  { # Shipment::Purolator::WSDL::Types::TotalWeight
     Value =>  $some_value, # int
     WeightUnit => $some_value, # WeightUnit
   },
   TotalPieces =>  $some_value, # int
   PiecesInformation =>  { # Shipment::Purolator::WSDL::Types::ArrayOfPiece
     Piece =>  { # Shipment::Purolator::WSDL::Types::Piece
       Weight =>  { # Shipment::Purolator::WSDL::Types::Weight
         Value =>  $some_value, # decimal
         WeightUnit => $some_value, # WeightUnit
       },
       Length =>  { # Shipment::Purolator::WSDL::Types::Dimension
         Value =>  $some_value, # decimal
         DimensionUnit => $some_value, # DimensionUnit
       },
       Width => {}, # Shipment::Purolator::WSDL::Types::Dimension
       Height => {}, # Shipment::Purolator::WSDL::Types::Dimension
       Options =>  { # Shipment::Purolator::WSDL::Types::ArrayOfOptionIDValuePair
         OptionIDValuePair =>  { # Shipment::Purolator::WSDL::Types::OptionIDValuePair
           ID =>  $some_value, # string
           Value =>  $some_value, # string
         },
       },
     },
   },
   DangerousGoodsDeclarationDocumentIndicator =>  $some_value, # boolean
   OptionsInformation =>  { # Shipment::Purolator::WSDL::Types::OptionsInformation
     Options => {}, # Shipment::Purolator::WSDL::Types::ArrayOfOptionIDValuePair
     ExpressChequeAddress =>  { # Shipment::Purolator::WSDL::Types::Address
       Name =>  $some_value, # string
       Company =>  $some_value, # string
       Department =>  $some_value, # string
       StreetNumber =>  $some_value, # string
       StreetSuffix =>  $some_value, # string
       StreetName =>  $some_value, # string
       StreetType =>  $some_value, # string
       StreetDirection =>  $some_value, # string
       Suite =>  $some_value, # string
       Floor =>  $some_value, # string
       StreetAddress2 =>  $some_value, # string
       StreetAddress3 =>  $some_value, # string
       City =>  $some_value, # string
       Province =>  $some_value, # string
       Country =>  $some_value, # string
       PostalCode =>  $some_value, # string
       PhoneNumber =>  { # Shipment::Purolator::WSDL::Types::PhoneNumber
         CountryCode =>  $some_value, # string
         AreaCode =>  $some_value, # string
         Phone =>  $some_value, # string
         Extension =>  $some_value, # string
       },
       FaxNumber => {}, # Shipment::Purolator::WSDL::Types::PhoneNumber
     },
   },
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=head1 AUTHOR

Andrew Baerg <baergaj@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2018 by Andrew Baerg.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
