# Generated by default/object.tt
package Paws::AppMesh::VirtualGatewaySpec;
  use Moose;
  has BackendDefaults => (is => 'ro', isa => 'Paws::AppMesh::VirtualGatewayBackendDefaults', request_name => 'backendDefaults', traits => ['NameInRequest']);
  has Listeners => (is => 'ro', isa => 'ArrayRef[Paws::AppMesh::VirtualGatewayListener]', request_name => 'listeners', traits => ['NameInRequest'], required => 1);
  has Logging => (is => 'ro', isa => 'Paws::AppMesh::VirtualGatewayLogging', request_name => 'logging', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AppMesh::VirtualGatewaySpec

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AppMesh::VirtualGatewaySpec object:

  $service_obj->Method(Att1 => { BackendDefaults => $value, ..., Logging => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AppMesh::VirtualGatewaySpec object:

  $result = $service_obj->Method(...);
  $result->Att1->BackendDefaults

=head1 DESCRIPTION

An object that represents the specification of a service mesh resource.

=head1 ATTRIBUTES


=head2 BackendDefaults => L<Paws::AppMesh::VirtualGatewayBackendDefaults>

A reference to an object that represents the defaults for backends.


=head2 B<REQUIRED> Listeners => ArrayRef[L<Paws::AppMesh::VirtualGatewayListener>]

The listeners that the mesh endpoint is expected to receive inbound
traffic from. You can specify one listener.


=head2 Logging => L<Paws::AppMesh::VirtualGatewayLogging>





=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AppMesh>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

