# Generated by default/object.tt
package Paws::CostExplorer::Anomaly;
  use Moose;
  has AnomalyEndDate => (is => 'ro', isa => 'Str');
  has AnomalyId => (is => 'ro', isa => 'Str', required => 1);
  has AnomalyScore => (is => 'ro', isa => 'Paws::CostExplorer::AnomalyScore', required => 1);
  has AnomalyStartDate => (is => 'ro', isa => 'Str');
  has DimensionValue => (is => 'ro', isa => 'Str');
  has Feedback => (is => 'ro', isa => 'Str');
  has Impact => (is => 'ro', isa => 'Paws::CostExplorer::Impact', required => 1);
  has MonitorArn => (is => 'ro', isa => 'Str', required => 1);
  has RootCauses => (is => 'ro', isa => 'ArrayRef[Paws::CostExplorer::RootCause]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::CostExplorer::Anomaly

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CostExplorer::Anomaly object:

  $service_obj->Method(Att1 => { AnomalyEndDate => $value, ..., RootCauses => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CostExplorer::Anomaly object:

  $result = $service_obj->Method(...);
  $result->Att1->AnomalyEndDate

=head1 DESCRIPTION

An unusual cost pattern. This consists of the detailed metadata and the
current status of the anomaly object.

=head1 ATTRIBUTES


=head2 AnomalyEndDate => Str

The last day the anomaly is detected.


=head2 B<REQUIRED> AnomalyId => Str

The unique identifier for the anomaly.


=head2 B<REQUIRED> AnomalyScore => L<Paws::CostExplorer::AnomalyScore>

The latest and maximum score for the anomaly.


=head2 AnomalyStartDate => Str

The first day the anomaly is detected.


=head2 DimensionValue => Str

The dimension for the anomaly. For example, an AWS service in a service
monitor.


=head2 Feedback => Str

The feedback value.


=head2 B<REQUIRED> Impact => L<Paws::CostExplorer::Impact>

The dollar impact for the anomaly.


=head2 B<REQUIRED> MonitorArn => Str

The Amazon Resource Name (ARN) for the cost monitor that generated this
anomaly.


=head2 RootCauses => ArrayRef[L<Paws::CostExplorer::RootCause>]

The list of identified root causes for the anomaly.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CostExplorer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

