#!/usr/bin/perl
#-------------------------------------------------------------------------------
# Test Data::Send::Local
# Philip R Brenan at gmail dot com, Appa Apps Ltd, 2017
#-------------------------------------------------------------------------------

use warnings FATAL => qw(all);
use strict;
use Data::Send::Local;
use Test::More tests=>2;
use Test::SharedFork;

my $socket = 'socket';                                                          # Socket name
my $data   = 'hello';                                                           # Data

if ($^O !~ m/\AMSWin32\Z/)                                                      # Ignore windows
 {if (my $pid = fork())
   {ok recvLocal($socket) eq $data;                                             # Receive data
    waitpid($pid, 0);
   }
  else                                                                          # Receive data
   {ok !sendLocal($socket, $data);
   }
 }
else
 {my $n = Test::More->builder->expected_tests;
  ok 1 for 1..$n;
  diag("Will not work on windows because of lack of fork()");
 }
