/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.builder;

import com.googlecode.mp4parser.authoring.Track;
import com.googlecode.mp4parser.authoring.builder.Fragmenter;
import com.googlecode.mp4parser.util.Mp4Arrays;
import java.util.Arrays;

public class BetterFragmenter
implements Fragmenter {
    private double targetDuration;

    public BetterFragmenter(double targetDuration) {
        this.targetDuration = targetDuration;
    }

    public long[] sampleNumbers(Track track) {
        long ts = track.getTrackMetaData().getTimescale();
        long targetTicks = (long)(this.targetDuration * (double)ts);
        long[] fragments = new long[]{};
        long[] syncSamples = track.getSyncSamples();
        long[] durations = track.getSampleDurations();
        if (syncSamples != null) {
            long[] syncSampleTicks = new long[syncSamples.length];
            long ticks = 0L;
            long duration = track.getDuration();
            int i = 0;
            while (i < durations.length) {
                int pos = Arrays.binarySearch(syncSamples, (long)i + 1L);
                if (pos >= 0) {
                    syncSampleTicks[pos] = ticks;
                }
                ticks += durations[i];
                ++i;
            }
            long nextTargetTick = 0L;
            int currentSyncSampleIndex = 0;
            while (currentSyncSampleIndex < syncSampleTicks.length - 1) {
                long tickN1 = syncSampleTicks[currentSyncSampleIndex];
                long tickN2 = syncSampleTicks[currentSyncSampleIndex + 1];
                if (nextTargetTick <= tickN2 && Math.abs(tickN1 - nextTargetTick) < Math.abs(tickN2 - nextTargetTick)) {
                    fragments = Mp4Arrays.copyOfAndAppend(fragments, syncSamples[currentSyncSampleIndex]);
                    nextTargetTick = syncSampleTicks[currentSyncSampleIndex] + targetTicks;
                }
                ++currentSyncSampleIndex;
            }
            if (duration - syncSampleTicks[syncSampleTicks.length - 1] > targetTicks / 2L) {
                fragments = Mp4Arrays.copyOfAndAppend(fragments, syncSamples[syncSampleTicks.length - 1]);
            }
        } else {
            double time = 0.0;
            fragments = new long[]{1L};
            int i = 1;
            while (i < durations.length) {
                if ((time += (double)durations[i] / (double)ts) >= this.targetDuration) {
                    if (i > 0) {
                        fragments = Mp4Arrays.copyOfAndAppend(fragments, new long[]{i + 1});
                    }
                    time = 0.0;
                }
                ++i;
            }
            if (time < this.targetDuration && fragments.length > 1) {
                long numberSamplesLastTwoSegments = (long)(durations.length + 1) - fragments[fragments.length - 2];
                fragments[fragments.length - 1] = fragments[fragments.length - 2] + numberSamplesLastTwoSegments / 2L;
            }
        }
        return fragments;
    }
}

