my $script = <<'END_OF_SCRIPT';
~startperl~ -w

use Net::Whois::Raw;
use Getopt::Std;
use strict;
use vars qw($opt_s $opt_c $opt_S $opt_C $opt_t $opt_T $opt_h);

getopts("scSCtT:h");

if ($opt_h) {
	print <<EOM;
	$0 [ -s | -S ] [ -c | -C ] [ -t <timeout> ] [ -T] <domain> [ <server> ]

The -s switch attempts to strip the copyright message or disclaimer.
The -S switch will attempt some exra rules for it.
The -c switch attempts to return an empty answer for failed searches.
The -C switch will attempt some exra rules for it.
The -T switch takes a parameter that is used for the timeout for
connection attempts.
The -t switch enables caching.
EOM
	exit; 
}


$OMIT_MSG = $CHECK_FAIL = 0;

$OMIT_MSG = 1 if $opt_s;
$OMIT_MSG = 2 if $opt_S;
$CHECK_FAIL = 1 if $opt_c;
$CHECK_FAIL = 2 if $opt_C;
$TIMEOUT = $opt_T;

$CACHE_DIR = undef;
if ($opt_t) {
    if ($^O =~ /Win/) {
        $CACHE_DIR = $ENV{'TEMP'} || "C:\\temp";
    } else {
        $CACHE_DIR = $ENV{'TEMP'} || "/tmp";
        my @ent = getpwuid($>);
        if (@ent) {
            foreach ("/tmp/$ent[0]", "$ent[7]/.pwhois") {
                mkdir $_, 0644;
                if (open(O, ">$_/__$$-$$.tmp")) {
                    close(O);
                    unlink "$_/__$$-$$.tmp";
                    $CACHE_DIR = $_;
                    last;
                 }
            }
        }
    }
}

my $dom = $ARGV[0] || die "Usage: $0 domain";

my $server = $ARGV[1];

eval {
	my $result = whois($dom, $server);
	if ($result) {
		print $result;
	} else {
		print STDERR "Failed.\n";
	}
};
if ($@) {
	my $err = $@;
	$err =~ s/\s+at \S+ line \d+\.$//;
	print "\nWhois information could not be fetched:\n$err\n";
	exit -1;
}	

__END__

=head1 NAME

pwhois   - Perl written whois client

=head1 SYNOPSIS

	pwhois perl.com
	pwhois gnu.org
	pwhois -s police.co.il
	pwhois -c there.is.no.tld.called.foobar
	pwhois yahoo.com whois.networksolutions.com
	pwhois -T 10 funet.fi

etc etc.....

=head1 DESCRIPTION

Just invoke with a domain name, optionally with a whois server name.
The -s switch attempts to strip the copyright message or disclaimer.
The -c switch attempts to return an empty answer for failed searches.
The -T switch takes a parameter that is used for the timeout for
connection attempts.
 
=head1 AUTHOR

Ariel Brosh, B<schop@cpan.org>

=head1 SEE ALSO

L<Net::Whois::Raw>.

END_OF_SCRIPT
use Config;

my $file = __FILE__; $file =~ s/\.PL$//;

$script =~ s/\~(\w+)\~/$Config{$1}/eg;
if (!(open(FILE, ">$file"))  ||
    !(print FILE $script)  ||
    !(close(FILE))) {
    die "Error while writing $file: $!\n";
}
chmod 0755, $file;
print "Extracted $file from ",__FILE__," with variable substitutions.\n";

